#!/usr/bin/awk -f

# The caller must pass args: -v hfile=help-NAME.h NAME.NUM.md

BEGIN {
    heading = "/* DO NOT EDIT THIS FILE!  It is auto-generated from the option list in " ARGV[1] "! */"
    findcomment = hfile
    sub("\\.", "\\.", findcomment)
    findcomment = "\\[comment\\].*" findcomment
    backtick_cnt = 0
    prints = ""
}

/^```/ {
    backtick_cnt++
    next
}

foundcomment {
    if (backtick_cnt > 1) exit
    if (backtick_cnt == 1) {
	gsub(/"/, "\\\"")
	prints = prints "\n  rprintf(F,\"" $0 "\\n\");"
    }
    next
}

$0 ~ findcomment {
    foundcomment = 1
    backtick_cnt = 0
}

END {
    if (foundcomment && backtick_cnt > 1)
	print heading "\n" prints > hfile
    else {
	print "Failed to find " hfile " section in " ARGV[1]
	exit 1
    }
}
