
/* autogenerated from ../schroedinger/schro.orc */

#include <orc/orc.h>
#include <orc-test/orctest.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>


/* begin Orc C target preamble */
#define ORC_CLAMP(x,a,b) ((x)<(a) ? (a) : ((x)>(b) ? (b) : (x)))
#define ORC_ABS(a) ((a)<0 ? -(a) : (a))
#define ORC_MIN(a,b) ((a)<(b) ? (a) : (b))
#define ORC_MAX(a,b) ((a)>(b) ? (a) : (b))
#define ORC_SB_MAX 127
#define ORC_SB_MIN (-1-ORC_SB_MAX)
#define ORC_UB_MAX 255
#define ORC_UB_MIN 0
#define ORC_SW_MAX 32767
#define ORC_SW_MIN (-1-ORC_SW_MAX)
#define ORC_UW_MAX 65535
#define ORC_UW_MIN 0
#define ORC_SL_MAX 2147483647
#define ORC_SL_MIN (-1-ORC_SL_MAX)
#define ORC_UL_MAX 4294967295U
#define ORC_UL_MIN 0
#define ORC_CLAMP_SB(x) ORC_CLAMP(x,ORC_SB_MIN,ORC_SB_MAX)
#define ORC_CLAMP_UB(x) ORC_CLAMP(x,ORC_UB_MIN,ORC_UB_MAX)
#define ORC_CLAMP_SW(x) ORC_CLAMP(x,ORC_SW_MIN,ORC_SW_MAX)
#define ORC_CLAMP_UW(x) ORC_CLAMP(x,ORC_UW_MIN,ORC_UW_MAX)
#define ORC_CLAMP_SL(x) ORC_CLAMP(x,ORC_SL_MIN,ORC_SL_MAX)
#define ORC_CLAMP_UL(x) ORC_CLAMP(x,ORC_UL_MIN,ORC_UL_MAX)
#define ORC_SWAP_W(x) ((((x)&0xff)<<8) | (((x)&0xff00)>>8))
#define ORC_SWAP_L(x) ((((x)&0xff)<<24) | (((x)&0xff00)<<8) | (((x)&0xff0000)>>8) | (((x)&0xff000000)>>24))
#define ORC_PTR_OFFSET(ptr,offset) ((void *)(((unsigned char *)(ptr)) + (offset)))
#define ORC_AS_FLOAT(x) (((union { int i; float f; } *)(&x))->f)
/* end Orc C target preamble */


/* orc_add2_rshift_add_s16_22_op */
static void
_backup_orc_add2_rshift_add_s16_22_op (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  const int16_t var16 = 2;
  const int16_t var17 = 2;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];
  ptr6 = ex->arrays[6];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: addw */
    var32 = var5 + var6;
    /* 1: addw */
    var33 = var32 + var16;
    /* 2: shrsw */
    var34 = var33 >> var17;
    /* 3: addw */
    var0 = var4 + var34;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_add2_rshift_add_s16_22 */
static void
_backup_orc_add2_rshift_add_s16_22 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 2;
  const int16_t var17 = 2;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addw */
    var32 = var4 + var5;
    /* 1: addw */
    var33 = var32 + var16;
    /* 2: shrsw */
    var34 = var33 >> var17;
    /* 3: addw */
    var0 = var0 + var34;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_add2_rshift_sub_s16_22_op */
static void
_backup_orc_add2_rshift_sub_s16_22_op (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  const int16_t var16 = 2;
  const int16_t var17 = 2;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];
  ptr6 = ex->arrays[6];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: addw */
    var32 = var5 + var6;
    /* 1: addw */
    var33 = var32 + var16;
    /* 2: shrsw */
    var34 = var33 >> var17;
    /* 3: subw */
    var0 = var4 - var34;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_add2_rshift_sub_s16_22 */
static void
_backup_orc_add2_rshift_sub_s16_22 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 2;
  const int16_t var17 = 2;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addw */
    var32 = var4 + var5;
    /* 1: addw */
    var33 = var32 + var16;
    /* 2: shrsw */
    var34 = var33 >> var17;
    /* 3: subw */
    var0 = var0 - var34;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_add2_rshift_add_s16_11_op */
static void
_backup_orc_add2_rshift_add_s16_11_op (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];
  ptr6 = ex->arrays[6];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: avgsw */
    var32 = (var5 + var6 + 1)>>1;
    /* 1: addw */
    var0 = var4 + var32;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_add2_rshift_add_s16_11 */
static void
_backup_orc_add2_rshift_add_s16_11 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: avgsw */
    var32 = (var4 + var5 + 1)>>1;
    /* 1: addw */
    var0 = var0 + var32;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_add2_rshift_sub_s16_11_op */
static void
_backup_orc_add2_rshift_sub_s16_11_op (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];
  ptr6 = ex->arrays[6];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: avgsw */
    var32 = (var5 + var6 + 1)>>1;
    /* 1: subw */
    var0 = var4 - var32;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_add2_rshift_sub_s16_11 */
static void
_backup_orc_add2_rshift_sub_s16_11 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: avgsw */
    var32 = (var4 + var5 + 1)>>1;
    /* 1: subw */
    var0 = var0 - var32;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_add_const_rshift_s16_11 */
static void
_backup_orc_add_const_rshift_s16_11 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 1;
  const int16_t var17 = 1;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: addw */
    var32 = var4 + var16;
    /* 1: shrsw */
    var0 = var32 >> var17;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_add_const_rshift_s16 */
static void
_backup_orc_add_const_rshift_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  int16_t var32;

  ptr0 = ex->arrays[0];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    /* 0: addw */
    var32 = var0 + var24;
    /* 1: shrsw */
    var0 = var32 >> var25;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_add_s16 */
static void
_backup_orc_add_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addw */
    var0 = var4 + var5;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_add_s16_2d */
static void
_backup_orc_add_s16_2d (OrcExecutor *ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);

    for (i = 0; i < n; i++) {
      var0 = *ptr0;
      var4 = *ptr4;
      ptr4++;
      /* 0: addw */
      var0 = var0 + var4;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_addc_rshift_s16 */
static void
_backup_orc_addc_rshift_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var24 = ex->params[24];
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addw */
    var32 = var4 + var5;
    /* 1: shrsw */
    var0 = var32 >> var24;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_lshift1_s16 */
static void
_backup_orc_lshift1_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 1;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: shlw */
    var0 = var4 << var16;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_lshift2_s16 */
static void
_backup_orc_lshift2_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 2;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: shlw */
    var0 = var4 << var16;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_lshift_s16_ip */
static void
_backup_orc_lshift_s16_ip (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  const int16_t var24 = ex->params[24];

  ptr0 = ex->arrays[0];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    /* 0: shlw */
    var0 = var0 << var24;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_mas2_add_s16_op */
static void
_backup_orc_mas2_add_s16_op (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  const int16_t var24 = ex->params[24];
  const int32_t var25 = ex->params[25];
  const int32_t var26 = ex->params[26];
  int16_t var32;
  int32_t var33;
  int32_t var34;
  int32_t var35;
  int16_t var36;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];
  ptr6 = ex->arrays[6];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: addw */
    var32 = var5 + var6;
    /* 1: mulswl */
    var33 = var32 * var24;
    /* 2: addl */
    var34 = var33 + var25;
    /* 3: shrsl */
    var35 = var34 >> var26;
    /* 4: convlw */
    var36 = var35;
    /* 5: addw */
    var0 = var4 + var36;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_mas2_add_s16_ip */
static void
_backup_orc_mas2_add_s16_ip (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var24 = ex->params[24];
  const int32_t var25 = ex->params[25];
  const int32_t var26 = ex->params[26];
  int16_t var32;
  int32_t var33;
  int32_t var34;
  int32_t var35;
  int16_t var36;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addw */
    var32 = var4 + var5;
    /* 1: mulswl */
    var33 = var32 * var24;
    /* 2: addl */
    var34 = var33 + var25;
    /* 3: shrsl */
    var35 = var34 >> var26;
    /* 4: convlw */
    var36 = var35;
    /* 5: addw */
    var0 = var0 + var36;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_mas2_sub_s16_op */
static void
_backup_orc_mas2_sub_s16_op (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  const int16_t var24 = ex->params[24];
  const int32_t var25 = ex->params[25];
  const int32_t var26 = ex->params[26];
  int16_t var32;
  int32_t var33;
  int32_t var34;
  int32_t var35;
  int16_t var36;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];
  ptr6 = ex->arrays[6];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: addw */
    var32 = var5 + var6;
    /* 1: mulswl */
    var33 = var32 * var24;
    /* 2: addl */
    var34 = var33 + var25;
    /* 3: shrsl */
    var35 = var34 >> var26;
    /* 4: convlw */
    var36 = var35;
    /* 5: subw */
    var0 = var4 - var36;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_mas2_sub_s16_ip */
static void
_backup_orc_mas2_sub_s16_ip (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var24 = ex->params[24];
  const int32_t var25 = ex->params[25];
  const int32_t var26 = ex->params[26];
  int16_t var32;
  int32_t var33;
  int32_t var34;
  int32_t var35;
  int16_t var36;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addw */
    var32 = var4 + var5;
    /* 1: mulswl */
    var33 = var32 * var24;
    /* 2: addl */
    var34 = var33 + var25;
    /* 3: shrsl */
    var35 = var34 >> var26;
    /* 4: convlw */
    var36 = var35;
    /* 5: subw */
    var0 = var0 - var36;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_mas4_across_add_s16_1991_op */
static void
_backup_orc_mas4_across_add_s16_1991_op (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  int16_t var7;
  const int16_t * ptr7;
  int16_t var8;
  const int16_t * ptr8;
  const int16_t var16 = 9;
  const int32_t var24 = ex->params[24];
  const int32_t var25 = ex->params[25];
  int16_t var32;
  int16_t var33;
  int32_t var34;
  int32_t var35;
  int32_t var36;
  int32_t var37;
  int32_t var38;
  int16_t var39;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];
  ptr6 = ex->arrays[6];
  ptr7 = ex->arrays[7];
  ptr8 = ex->arrays[8];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    var7 = *ptr7;
    ptr7++;
    var8 = *ptr8;
    ptr8++;
    /* 0: addw */
    var32 = var6 + var7;
    /* 1: mulswl */
    var34 = var32 * var16;
    /* 2: addw */
    var33 = var5 + var8;
    /* 3: convswl */
    var35 = var33;
    /* 4: subl */
    var36 = var34 - var35;
    /* 5: addl */
    var37 = var36 + var24;
    /* 6: shrsl */
    var38 = var37 >> var25;
    /* 7: convlw */
    var39 = var38;
    /* 8: addw */
    var0 = var4 + var39;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_mas4_across_add_s16_1991_ip */
static void
_backup_orc_mas4_across_add_s16_1991_ip (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  int16_t var7;
  const int16_t * ptr7;
  const int16_t var16 = 9;
  const int32_t var24 = ex->params[24];
  const int32_t var25 = ex->params[25];
  int16_t var32;
  int16_t var33;
  int32_t var34;
  int32_t var35;
  int32_t var36;
  int32_t var37;
  int32_t var38;
  int16_t var39;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];
  ptr6 = ex->arrays[6];
  ptr7 = ex->arrays[7];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    var7 = *ptr7;
    ptr7++;
    /* 0: addw */
    var32 = var5 + var6;
    /* 1: mulswl */
    var34 = var32 * var16;
    /* 2: addw */
    var33 = var4 + var7;
    /* 3: convswl */
    var35 = var33;
    /* 4: subl */
    var36 = var34 - var35;
    /* 5: addl */
    var37 = var36 + var24;
    /* 6: shrsl */
    var38 = var37 >> var25;
    /* 7: convlw */
    var39 = var38;
    /* 8: addw */
    var0 = var0 + var39;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_mas4_across_sub_s16_1991_op */
static void
_backup_orc_mas4_across_sub_s16_1991_op (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  int16_t var7;
  const int16_t * ptr7;
  int16_t var8;
  const int16_t * ptr8;
  const int16_t var16 = 9;
  const int32_t var24 = ex->params[24];
  const int32_t var25 = ex->params[25];
  int16_t var32;
  int16_t var33;
  int32_t var34;
  int32_t var35;
  int32_t var36;
  int32_t var37;
  int32_t var38;
  int16_t var39;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];
  ptr6 = ex->arrays[6];
  ptr7 = ex->arrays[7];
  ptr8 = ex->arrays[8];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    var7 = *ptr7;
    ptr7++;
    var8 = *ptr8;
    ptr8++;
    /* 0: addw */
    var32 = var6 + var7;
    /* 1: mulswl */
    var34 = var32 * var16;
    /* 2: addw */
    var33 = var5 + var8;
    /* 3: convswl */
    var35 = var33;
    /* 4: subl */
    var36 = var34 - var35;
    /* 5: addl */
    var37 = var36 + var24;
    /* 6: shrsl */
    var38 = var37 >> var25;
    /* 7: convlw */
    var39 = var38;
    /* 8: subw */
    var0 = var4 - var39;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_mas4_across_sub_s16_1991_ip */
static void
_backup_orc_mas4_across_sub_s16_1991_ip (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  int16_t var6;
  const int16_t * ptr6;
  int16_t var7;
  const int16_t * ptr7;
  const int16_t var16 = 9;
  const int32_t var24 = ex->params[24];
  const int32_t var25 = ex->params[25];
  int16_t var32;
  int16_t var33;
  int32_t var34;
  int32_t var35;
  int32_t var36;
  int32_t var37;
  int32_t var38;
  int16_t var39;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];
  ptr6 = ex->arrays[6];
  ptr7 = ex->arrays[7];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    var7 = *ptr7;
    ptr7++;
    /* 0: addw */
    var32 = var5 + var6;
    /* 1: mulswl */
    var34 = var32 * var16;
    /* 2: addw */
    var33 = var4 + var7;
    /* 3: convswl */
    var35 = var33;
    /* 4: subl */
    var36 = var34 - var35;
    /* 5: addl */
    var37 = var36 + var24;
    /* 6: shrsl */
    var38 = var37 >> var25;
    /* 7: convlw */
    var39 = var38;
    /* 8: subw */
    var0 = var0 - var39;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_subtract_s16 */
static void
_backup_orc_subtract_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: subw */
    var0 = var4 - var5;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_add_s16_u8 */
static void
_backup_orc_add_s16_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: convubw */
    var32 = (uint8_t)var5;
    /* 1: addw */
    var0 = var32 + var4;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_add_s16_u8_2d */
static void
_backup_orc_add_s16_u8_2d (OrcExecutor *ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  int16_t var0;
  int16_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int16_t var32;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);

    for (i = 0; i < n; i++) {
      var0 = *ptr0;
      var4 = *ptr4;
      ptr4++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: addw */
      var0 = var0 + var32;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_convert_s16_u8 */
static void
_backup_orc_convert_s16_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convubw */
    var0 = (uint8_t)var4;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_convert_u8_s16 */
static void
_backup_orc_convert_u8_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convsuswb */
    var0 = ORC_CLAMP_UB(var4);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_offsetconvert_u8_s16 */
static void
_backup_orc_offsetconvert_u8_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 128;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: addw */
    var32 = var4 + var16;
    /* 1: convsuswb */
    var0 = ORC_CLAMP_UB(var32);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_offsetconvert_s16_u8 */
static void
_backup_orc_offsetconvert_s16_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  const int16_t var16 = 128;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convubw */
    var32 = (uint8_t)var4;
    /* 1: subw */
    var0 = var32 - var16;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_subtract_s16_u8 */
static void
_backup_orc_subtract_s16_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: convubw */
    var32 = (uint8_t)var5;
    /* 1: subw */
    var0 = var4 - var32;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_multiply_and_add_s16_u8 */
static void
_backup_orc_multiply_and_add_s16_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int16_t var32;
  int16_t var33;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: convubw */
    var32 = (uint8_t)var5;
    /* 1: mullw */
    var33 = (var32 * var4) & 0xffff;
    /* 2: addw */
    var0 = var0 + var33;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_splat_s16_ns */
static void
_backup_orc_splat_s16_ns (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  const int16_t var24 = ex->params[24];

  ptr0 = ex->arrays[0];

  for (i = 0; i < n; i++) {
    /* 0: copyw */
    var0 = var24;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_splat_s16_2d_4xn */
static void
_backup_orc_splat_s16_2d_4xn (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 4;
  int m = ex->params[ORC_VAR_A1];
  int16_t var0;
  int16_t * ptr0;
  const int16_t var24 = ex->params[24];

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);

    for (i = 0; i < n; i++) {
      /* 0: copyw */
      var0 = var24;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_splat_s16_2d_8xn */
static void
_backup_orc_splat_s16_2d_8xn (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 8;
  int m = ex->params[ORC_VAR_A1];
  int16_t var0;
  int16_t * ptr0;
  const int16_t var24 = ex->params[24];

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);

    for (i = 0; i < n; i++) {
      /* 0: copyw */
      var0 = var24;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_splat_s16_2d */
static void
_backup_orc_splat_s16_2d (OrcExecutor *ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  int16_t var0;
  int16_t * ptr0;
  const int16_t var24 = ex->params[24];

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);

    for (i = 0; i < n; i++) {
      /* 0: copyw */
      var0 = var24;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_splat_u8_ns */
static void
_backup_orc_splat_u8_ns (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  const int8_t var24 = ex->params[24];

  ptr0 = ex->arrays[0];

  for (i = 0; i < n; i++) {
    /* 0: copyb */
    var0 = var24;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_splat_u8_2d */
static void
_backup_orc_splat_u8_2d (OrcExecutor *ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  const int8_t var24 = ex->params[24];

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);

    for (i = 0; i < n; i++) {
      /* 0: copyb */
      var0 = var24;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_average_u8 */
static void
_backup_orc_average_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: avgub */
    var0 = ((uint8_t)var4 + (uint8_t)var5 + 1)>>1;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_rrshift6_add_s16_2d */
static void
_backup_orc_rrshift6_add_s16_2d (OrcExecutor *ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 32;
  const int16_t var17 = 6;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: addw */
      var32 = var5 + var16;
      /* 1: shrsw */
      var33 = var32 >> var17;
      /* 2: addw */
      var34 = var4 + var33;
      /* 3: convsuswb */
      var0 = ORC_CLAMP_UB(var34);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_rrshift6_sub_s16_2d */
static void
_backup_orc_rrshift6_sub_s16_2d (OrcExecutor *ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  const int16_t var16 = 8160;
  const int16_t var17 = 6;
  int16_t var32;
  int16_t var33;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr1 = ORC_PTR_OFFSET(ex->arrays[1], ex->params[1] * j);

    for (i = 0; i < n; i++) {
      var0 = *ptr0;
      var1 = *ptr1;
      /* 0: subw */
      var32 = var1 - var16;
      /* 1: shrsw */
      var33 = var32 >> var17;
      /* 2: copyw */
      var1 = var33;
      /* 3: subw */
      var0 = var0 - var33;
      *ptr0 = var0;
      ptr0++;
      *ptr1 = var1;
      ptr1++;
    }
  }

}

/* orc_rrshift6_s16_ip_2d */
static void
_backup_orc_rrshift6_s16_ip_2d (OrcExecutor *ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  int16_t var0;
  int16_t * ptr0;
  const int16_t var16 = 8160;
  const int16_t var17 = 6;
  int16_t var32;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);

    for (i = 0; i < n; i++) {
      var0 = *ptr0;
      /* 0: subw */
      var32 = var0 - var16;
      /* 1: shrsw */
      var0 = var32 >> var17;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_rrshift6_s16_ip */
static void
_backup_orc_rrshift6_s16_ip (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  const int16_t var16 = 8160;
  const int16_t var17 = 6;
  int16_t var32;

  ptr0 = ex->arrays[0];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    /* 0: subw */
    var32 = var0 - var16;
    /* 1: shrsw */
    var0 = var32 >> var17;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_unpack_yuyv_y */
static void
_backup_orc_unpack_yuyv_y (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select0wb */
    var0 = (uint16_t)var4 & 0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_unpack_yuyv_u */
static void
_backup_orc_unpack_yuyv_u (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int32_t var4;
  const int32_t * ptr4;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select0lw */
    var32 = (uint32_t)var4 & 0xffff;
    /* 1: select1wb */
    var0 = ((uint16_t)var32 >> 8)&0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_unpack_yuyv_v */
static void
_backup_orc_unpack_yuyv_v (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int32_t var4;
  const int32_t * ptr4;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select1lw */
    var32 = ((uint32_t)var4 >> 16)&0xffff;
    /* 1: select1wb */
    var0 = ((uint16_t)var32 >> 8)&0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_packyuyv */
static void
_backup_orc_packyuyv (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int32_t var0;
  int32_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int8_t var6;
  const int8_t * ptr6;
  int8_t var32;
  int8_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];
  ptr6 = ex->arrays[6];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: copyw */
    var36 = var4;
    /* 1: select0wb */
    var32 = (uint16_t)var36 & 0xff;
    /* 2: select1wb */
    var33 = ((uint16_t)var36 >> 8)&0xff;
    /* 3: mergebw */
    var34 = ((uint8_t)var32) | ((uint8_t)var5 << 8);
    /* 4: mergebw */
    var35 = ((uint8_t)var33) | ((uint8_t)var6 << 8);
    /* 5: mergewl */
    var0 = ((uint16_t)var34) | ((uint16_t)var35 << 16);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_unpack_uyvy_y */
static void
_backup_orc_unpack_uyvy_y (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select1wb */
    var0 = ((uint16_t)var4 >> 8)&0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_unpack_uyvy_u */
static void
_backup_orc_unpack_uyvy_u (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int32_t var4;
  const int32_t * ptr4;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select0lw */
    var32 = (uint32_t)var4 & 0xffff;
    /* 1: select0wb */
    var0 = (uint16_t)var32 & 0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_unpack_uyvy_v */
static void
_backup_orc_unpack_uyvy_v (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int32_t var4;
  const int32_t * ptr4;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select1lw */
    var32 = ((uint32_t)var4 >> 16)&0xffff;
    /* 1: select0wb */
    var0 = (uint16_t)var32 & 0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_interleave2_s16 */
static void
_backup_orc_interleave2_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int32_t var0;
  int32_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: mergewl */
    var0 = ((uint16_t)var4) | ((uint16_t)var5 << 16);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_interleave2_rrshift1_s16 */
static void
_backup_orc_interleave2_rrshift1_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int32_t var0;
  int32_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 1;
  const int16_t var17 = 1;
  const int16_t var18 = 1;
  const int16_t var19 = 1;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: addw */
    var32 = var4 + var16;
    /* 1: shrsw */
    var34 = var32 >> var17;
    /* 2: addw */
    var33 = var5 + var18;
    /* 3: shrsw */
    var35 = var33 >> var19;
    /* 4: mergewl */
    var0 = ((uint16_t)var34) | ((uint16_t)var35 << 16);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_deinterleave2_s16 */
static void
_backup_orc_deinterleave2_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  int32_t var4;
  const int32_t * ptr4;
  int32_t var32;

  ptr0 = ex->arrays[0];
  ptr1 = ex->arrays[1];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: copyl */
    var32 = var4;
    /* 1: select0lw */
    var0 = (uint32_t)var32 & 0xffff;
    /* 2: select1lw */
    var1 = ((uint32_t)var32 >> 16)&0xffff;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

/* orc_deinterleave2_lshift1_s16 */
static void
_backup_orc_deinterleave2_lshift1_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  int32_t var4;
  const int32_t * ptr4;
  const int16_t var16 = 1;
  const int16_t var17 = 1;
  int32_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = ex->arrays[0];
  ptr1 = ex->arrays[1];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: copyl */
    var32 = var4;
    /* 1: select0lw */
    var33 = (uint32_t)var32 & 0xffff;
    /* 2: shlw */
    var0 = var33 << var16;
    /* 3: select1lw */
    var34 = ((uint32_t)var32 >> 16)&0xffff;
    /* 4: shlw */
    var1 = var34 << var17;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

/* orc_haar_deint_lshift1_split_s16 */
static void
_backup_orc_haar_deint_lshift1_split_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  int32_t var4;
  const int32_t * ptr4;
  const int16_t var16 = 1;
  const int16_t var17 = 1;
  const int16_t var18 = 0;
  int16_t var32;
  int16_t var33;
  int32_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;

  ptr0 = ex->arrays[0];
  ptr1 = ex->arrays[1];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: copyl */
    var34 = var4;
    /* 1: select0lw */
    var32 = (uint32_t)var34 & 0xffff;
    /* 2: select1lw */
    var33 = ((uint32_t)var34 >> 16)&0xffff;
    /* 3: shlw */
    var35 = var32 << var16;
    /* 4: shlw */
    var36 = var33 << var17;
    /* 5: subw */
    var37 = var36 - var35;
    /* 6: copyw */
    var1 = var37;
    /* 7: avgsw */
    var38 = (var37 + var18 + 1)>>1;
    /* 8: addw */
    var0 = var35 + var38;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

/* orc_haar_deint_split_s16 */
static void
_backup_orc_haar_deint_split_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  int32_t var4;
  const int32_t * ptr4;
  const int16_t var16 = 0;
  int16_t var32;
  int16_t var33;
  int32_t var34;
  int16_t var35;
  int16_t var36;

  ptr0 = ex->arrays[0];
  ptr1 = ex->arrays[1];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: copyl */
    var34 = var4;
    /* 1: select0lw */
    var32 = (uint32_t)var34 & 0xffff;
    /* 2: select1lw */
    var33 = ((uint32_t)var34 >> 16)&0xffff;
    /* 3: subw */
    var35 = var33 - var32;
    /* 4: copyw */
    var1 = var35;
    /* 5: avgsw */
    var36 = (var35 + var16 + 1)>>1;
    /* 6: addw */
    var0 = var32 + var36;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

/* orc_haar_split_s16_lo */
static void
_backup_orc_haar_split_s16_lo (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 0;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: copyw */
    var32 = var4;
    /* 1: subw */
    var33 = var5 - var32;
    /* 2: avgsw */
    var34 = (var33 + var16 + 1)>>1;
    /* 3: addw */
    var0 = var32 + var34;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_haar_split_s16_hi */
static void
_backup_orc_haar_split_s16_hi (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: subw */
    var0 = var5 - var4;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_haar_split_s16_op */
static void
_backup_orc_haar_split_s16_op (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 0;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = ex->arrays[0];
  ptr1 = ex->arrays[1];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: copyw */
    var32 = var4;
    /* 1: subw */
    var33 = var5 - var32;
    /* 2: copyw */
    var1 = var33;
    /* 3: avgsw */
    var34 = (var33 + var16 + 1)>>1;
    /* 4: addw */
    var0 = var32 + var34;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

/* orc_haar_split_s16 */
static void
_backup_orc_haar_split_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  const int16_t var16 = 0;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;

  ptr0 = ex->arrays[0];
  ptr1 = ex->arrays[1];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var1 = *ptr1;
    /* 0: copyw */
    var32 = var0;
    /* 1: copyw */
    var33 = var1;
    /* 2: subw */
    var34 = var33 - var32;
    /* 3: copyw */
    var1 = var34;
    /* 4: avgsw */
    var35 = (var34 + var16 + 1)>>1;
    /* 5: addw */
    var0 = var32 + var35;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

/* orc_haar_synth_s16_lo */
static void
_backup_orc_haar_synth_s16_lo (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 0;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: avgsw */
    var32 = (var5 + var16 + 1)>>1;
    /* 1: subw */
    var0 = var4 - var32;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_haar_synth_s16_hi */
static void
_backup_orc_haar_synth_s16_hi (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 0;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: copyw */
    var33 = var5;
    /* 1: avgsw */
    var34 = (var33 + var16 + 1)>>1;
    /* 2: subw */
    var32 = var4 - var34;
    /* 3: addw */
    var0 = var33 + var32;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_haar_synth_s16_op */
static void
_backup_orc_haar_synth_s16_op (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 0;
  int16_t var32;
  int16_t var33;
  int16_t var34;

  ptr0 = ex->arrays[0];
  ptr1 = ex->arrays[1];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: copyw */
    var33 = var5;
    /* 1: avgsw */
    var34 = (var33 + var16 + 1)>>1;
    /* 2: subw */
    var32 = var4 - var34;
    /* 3: copyw */
    var0 = var32;
    /* 4: addw */
    var1 = var33 + var32;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

/* orc_haar_synth_s16 */
static void
_backup_orc_haar_synth_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  const int16_t var16 = 0;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;

  ptr0 = ex->arrays[0];
  ptr1 = ex->arrays[1];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var1 = *ptr1;
    /* 0: copyw */
    var32 = var0;
    /* 1: copyw */
    var33 = var1;
    /* 2: avgsw */
    var34 = (var33 + var16 + 1)>>1;
    /* 3: subw */
    var35 = var32 - var34;
    /* 4: copyw */
    var0 = var35;
    /* 5: addw */
    var1 = var33 + var35;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

/* orc_haar_synth_rrshift1_int_s16 */
static void
_backup_orc_haar_synth_rrshift1_int_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int32_t var0;
  int32_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 0;
  const int16_t var17 = 0;
  const int16_t var18 = 0;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: copyw */
    var33 = var5;
    /* 1: avgsw */
    var32 = (var33 + var16 + 1)>>1;
    /* 2: subw */
    var34 = var4 - var32;
    /* 3: addw */
    var35 = var33 + var34;
    /* 4: avgsw */
    var36 = (var34 + var17 + 1)>>1;
    /* 5: avgsw */
    var37 = (var35 + var18 + 1)>>1;
    /* 6: mergewl */
    var0 = ((uint16_t)var36) | ((uint16_t)var37 << 16);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_haar_synth_int_s16 */
static void
_backup_orc_haar_synth_int_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int32_t var0;
  int32_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 0;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: copyw */
    var33 = var5;
    /* 1: avgsw */
    var32 = (var33 + var16 + 1)>>1;
    /* 2: subw */
    var34 = var4 - var32;
    /* 3: addw */
    var35 = var33 + var34;
    /* 4: mergewl */
    var0 = ((uint16_t)var34) | ((uint16_t)var35 << 16);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_haar_sub_s16 */
static void
_backup_orc_haar_sub_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    /* 0: subw */
    var0 = var0 - var4;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_haar_add_half_s16 */
static void
_backup_orc_haar_add_half_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 0;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    /* 0: avgsw */
    var32 = (var4 + var16 + 1)>>1;
    /* 1: addw */
    var0 = var0 + var32;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_haar_add_s16 */
static void
_backup_orc_haar_add_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    /* 0: addw */
    var0 = var0 + var4;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_haar_sub_half_s16 */
static void
_backup_orc_haar_sub_half_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 0;
  int16_t var32;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    var4 = *ptr4;
    ptr4++;
    /* 0: avgsw */
    var32 = (var4 + var16 + 1)>>1;
    /* 1: subw */
    var0 = var0 - var32;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_sum_u8 */
static void
_backup_orc_sum_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var4;
  const int8_t * ptr4;
  int32_t var12 = 0;
  int16_t var32;
  int32_t var33;

  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convubw */
    var32 = (uint8_t)var4;
    /* 1: convuwl */
    var33 = (uint16_t)var32;
    /* 2: accl */
    var12 = var12 + var33;
  }
  ex->accumulators[0] = var12;

}

/* orc_sum_s16 */
static void
_backup_orc_sum_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var4;
  const int16_t * ptr4;
  int32_t var12 = 0;
  int32_t var32;

  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convswl */
    var32 = var4;
    /* 1: accl */
    var12 = var12 + var32;
  }
  ex->accumulators[0] = var12;

}

/* orc_sum_square_diff_u8 */
static void
_backup_orc_sum_square_diff_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int32_t var12 = 0;
  int16_t var32;
  int16_t var33;
  int32_t var34;
  int16_t var35;
  int16_t var36;

  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: convubw */
    var32 = (uint8_t)var4;
    /* 1: convubw */
    var33 = (uint8_t)var5;
    /* 2: subw */
    var35 = var32 - var33;
    /* 3: mullw */
    var36 = (var35 * var35) & 0xffff;
    /* 4: convuwl */
    var34 = (uint16_t)var36;
    /* 5: accl */
    var12 = var12 + var34;
  }
  ex->accumulators[0] = var12;

}

/* orc_dequantise_s16_2d_4xn */
static void
_backup_orc_dequantise_s16_2d_4xn (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 4;
  int m = ex->params[ORC_VAR_A1];
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 2;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      /* 0: copyw */
      var32 = var4;
      /* 1: signw */
      var33 = ORC_CLAMP(var32,-1,1);
      /* 2: absw */
      var34 = ORC_ABS(var32);
      /* 3: mullw */
      var35 = (var34 * var24) & 0xffff;
      /* 4: addw */
      var36 = var35 + var25;
      /* 5: shrsw */
      var37 = var36 >> var16;
      /* 6: mullw */
      var0 = (var37 * var33) & 0xffff;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_dequantise_s16_2d_8xn */
static void
_backup_orc_dequantise_s16_2d_8xn (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 8;
  int m = ex->params[ORC_VAR_A1];
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 2;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      /* 0: copyw */
      var32 = var4;
      /* 1: signw */
      var33 = ORC_CLAMP(var32,-1,1);
      /* 2: absw */
      var34 = ORC_ABS(var32);
      /* 3: mullw */
      var35 = (var34 * var24) & 0xffff;
      /* 4: addw */
      var36 = var35 + var25;
      /* 5: shrsw */
      var37 = var36 >> var16;
      /* 6: mullw */
      var0 = (var37 * var33) & 0xffff;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_dequantise_s16_ip_2d_8xn */
static void
_backup_orc_dequantise_s16_ip_2d_8xn (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 8;
  int m = ex->params[ORC_VAR_A1];
  int16_t var0;
  int16_t * ptr0;
  const int16_t var16 = 2;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);

    for (i = 0; i < n; i++) {
      var0 = *ptr0;
      /* 0: copyw */
      var32 = var0;
      /* 1: signw */
      var33 = ORC_CLAMP(var32,-1,1);
      /* 2: absw */
      var34 = ORC_ABS(var32);
      /* 3: mullw */
      var35 = (var34 * var24) & 0xffff;
      /* 4: addw */
      var36 = var35 + var25;
      /* 5: shrsw */
      var37 = var36 >> var16;
      /* 6: mullw */
      var0 = (var37 * var33) & 0xffff;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_dequantise_s16_ip_2d */
static void
_backup_orc_dequantise_s16_ip_2d (OrcExecutor *ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  int16_t var0;
  int16_t * ptr0;
  const int16_t var16 = 2;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);

    for (i = 0; i < n; i++) {
      var0 = *ptr0;
      /* 0: copyw */
      var32 = var0;
      /* 1: signw */
      var33 = ORC_CLAMP(var32,-1,1);
      /* 2: absw */
      var34 = ORC_ABS(var32);
      /* 3: mullw */
      var35 = (var34 * var24) & 0xffff;
      /* 4: addw */
      var36 = var35 + var25;
      /* 5: shrsw */
      var37 = var36 >> var16;
      /* 6: mullw */
      var0 = (var37 * var33) & 0xffff;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_dequantise_s16_ip */
static void
_backup_orc_dequantise_s16_ip (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  const int16_t var16 = 2;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;

  ptr0 = ex->arrays[0];

  for (i = 0; i < n; i++) {
    var0 = *ptr0;
    /* 0: copyw */
    var32 = var0;
    /* 1: signw */
    var33 = ORC_CLAMP(var32,-1,1);
    /* 2: absw */
    var34 = ORC_ABS(var32);
    /* 3: mullw */
    var35 = (var34 * var24) & 0xffff;
    /* 4: addw */
    var36 = var35 + var25;
    /* 5: shrsw */
    var37 = var36 >> var16;
    /* 6: mullw */
    var0 = (var37 * var33) & 0xffff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_dequantise_s16 */
static void
_backup_orc_dequantise_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 2;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: copyw */
    var32 = var4;
    /* 1: signw */
    var33 = ORC_CLAMP(var32,-1,1);
    /* 2: absw */
    var34 = ORC_ABS(var32);
    /* 3: mullw */
    var35 = (var34 * var24) & 0xffff;
    /* 4: addw */
    var36 = var35 + var25;
    /* 5: shrsw */
    var37 = var36 >> var16;
    /* 6: mullw */
    var0 = (var37 * var33) & 0xffff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_quantise1_s16 */
static void
_backup_orc_quantise1_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 2;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: copyw */
    var32 = var4;
    /* 1: signw */
    var33 = ORC_CLAMP(var32,-1,1);
    /* 2: absw */
    var34 = ORC_ABS(var32);
    /* 3: shlw */
    var35 = var34 << var16;
    /* 4: subw */
    var36 = var35 - var25;
    /* 5: mulhuw */
    var37 = ((uint32_t)((uint16_t)var36) * (uint32_t)((uint16_t)var24)) >> 16;
    /* 6: shruw */
    var38 = ((uint16_t)var37) >> var26;
    /* 7: mullw */
    var0 = (var38 * var33) & 0xffff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_quantise2_s16 */
static void
_backup_orc_quantise2_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  const int16_t var16 = 2;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: copyw */
    var32 = var4;
    /* 1: signw */
    var33 = ORC_CLAMP(var32,-1,1);
    /* 2: absw */
    var34 = ORC_ABS(var32);
    /* 3: shlw */
    var35 = var34 << var16;
    /* 4: subw */
    var36 = var35 - var25;
    /* 5: shruw */
    var37 = ((uint16_t)var36) >> var24;
    /* 6: mullw */
    var0 = (var37 * var33) & 0xffff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_quantdequant1_s16 */
static void
_backup_orc_quantdequant1_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  const int16_t var16 = 2;
  const int16_t var17 = 2;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  const int16_t var27 = ex->params[27];
  const int16_t var28 = ex->params[28];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;
  int16_t var43;

  ptr0 = ex->arrays[0];
  ptr1 = ex->arrays[1];

  for (i = 0; i < n; i++) {
    var1 = *ptr1;
    /* 0: copyw */
    var32 = var1;
    /* 1: signw */
    var33 = ORC_CLAMP(var32,-1,1);
    /* 2: absw */
    var34 = ORC_ABS(var32);
    /* 3: shlw */
    var35 = var34 << var16;
    /* 4: subw */
    var36 = var35 - var25;
    /* 5: mulhuw */
    var37 = ((uint32_t)((uint16_t)var36) * (uint32_t)((uint16_t)var24)) >> 16;
    /* 6: shruw */
    var38 = ((uint16_t)var37) >> var26;
    /* 7: mullw */
    var39 = (var38 * var33) & 0xffff;
    /* 8: copyw */
    var0 = var39;
    /* 9: signw */
    var40 = ORC_CLAMP(var39,-1,1);
    /* 10: mullw */
    var41 = (var38 * var27) & 0xffff;
    /* 11: addw */
    var42 = var41 + var28;
    /* 12: shrsw */
    var43 = var42 >> var17;
    /* 13: mullw */
    var1 = (var43 * var40) & 0xffff;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

/* orc_quantdequant3_s16 */
static void
_backup_orc_quantdequant3_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  const int16_t var16 = 2;
  const int16_t var17 = 2;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  const int16_t var27 = ex->params[27];
  const int16_t var28 = ex->params[28];
  const int32_t var29 = ex->params[29];
  int16_t var32;
  int16_t var33;
  int32_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int32_t var38;
  int32_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;
  int16_t var43;
  int16_t var44;
  int16_t var45;

  ptr0 = ex->arrays[0];
  ptr1 = ex->arrays[1];

  for (i = 0; i < n; i++) {
    var1 = *ptr1;
    /* 0: copyw */
    var32 = var1;
    /* 1: signw */
    var33 = ORC_CLAMP(var32,-1,1);
    /* 2: absw */
    var35 = ORC_ABS(var32);
    /* 3: shlw */
    var36 = var35 << var16;
    /* 4: subw */
    var37 = var36 - var25;
    /* 5: muluwl */
    var34 = (uint16_t)var37 * (uint16_t)var24;
    /* 6: addl */
    var38 = var34 + var29;
    /* 7: shrul */
    var39 = ((uint32_t)var38) >> var26;
    /* 8: convlw */
    var40 = var39;
    /* 9: mullw */
    var41 = (var40 * var33) & 0xffff;
    /* 10: copyw */
    var0 = var41;
    /* 11: signw */
    var42 = ORC_CLAMP(var41,-1,1);
    /* 12: mullw */
    var43 = (var40 * var27) & 0xffff;
    /* 13: addw */
    var44 = var43 + var28;
    /* 14: shrsw */
    var45 = var44 >> var17;
    /* 15: mullw */
    var1 = (var45 * var42) & 0xffff;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

/* orc_quantdequant2_s16 */
static void
_backup_orc_quantdequant2_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var0;
  int16_t * ptr0;
  int16_t var1;
  int16_t * ptr1;
  const int16_t var16 = 2;
  const int16_t var17 = 2;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  const int16_t var27 = ex->params[27];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;

  ptr0 = ex->arrays[0];
  ptr1 = ex->arrays[1];

  for (i = 0; i < n; i++) {
    var1 = *ptr1;
    /* 0: copyw */
    var32 = var1;
    /* 1: signw */
    var33 = ORC_CLAMP(var32,-1,1);
    /* 2: absw */
    var34 = ORC_ABS(var32);
    /* 3: shlw */
    var35 = var34 << var16;
    /* 4: subw */
    var36 = var35 - var25;
    /* 5: shruw */
    var37 = ((uint16_t)var36) >> var24;
    /* 6: mullw */
    var38 = (var37 * var33) & 0xffff;
    /* 7: copyw */
    var0 = var38;
    /* 8: signw */
    var39 = ORC_CLAMP(var38,-1,1);
    /* 9: mullw */
    var40 = (var37 * var26) & 0xffff;
    /* 10: addw */
    var41 = var40 + var27;
    /* 11: shrsw */
    var42 = var41 >> var17;
    /* 12: mullw */
    var1 = (var42 * var39) & 0xffff;
    *ptr0 = var0;
    ptr0++;
    *ptr1 = var1;
    ptr1++;
  }

}

/* orc_downsample_vert_u8 */
static void
_backup_orc_downsample_vert_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int8_t var6;
  const int8_t * ptr6;
  int8_t var7;
  const int8_t * ptr7;
  const int16_t var16 = 6;
  const int16_t var17 = 26;
  const int16_t var18 = 32;
  const int16_t var19 = 6;
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];
  ptr6 = ex->arrays[6];
  ptr7 = ex->arrays[7];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    var7 = *ptr7;
    ptr7++;
    /* 0: convubw */
    var32 = (uint8_t)var4;
    /* 1: convubw */
    var33 = (uint8_t)var7;
    /* 2: addw */
    var35 = var32 + var33;
    /* 3: mullw */
    var36 = (var35 * var16) & 0xffff;
    /* 4: convubw */
    var37 = (uint8_t)var5;
    /* 5: convubw */
    var34 = (uint8_t)var6;
    /* 6: addw */
    var38 = var37 + var34;
    /* 7: mullw */
    var39 = (var38 * var17) & 0xffff;
    /* 8: addw */
    var40 = var39 + var36;
    /* 9: addw */
    var41 = var40 + var18;
    /* 10: shruw */
    var42 = ((uint16_t)var41) >> var19;
    /* 11: convwb */
    var0 = var42;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_downsample_horiz_u8 */
static void
_backup_orc_downsample_horiz_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int8_t var0;
  int8_t * ptr0;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var5;
  const int16_t * ptr5;
  const int16_t var16 = 6;
  const int16_t var17 = 26;
  const int16_t var18 = 32;
  const int16_t var19 = 6;
  int16_t var32;
  int16_t var33;
  int8_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int8_t var38;
  int16_t var39;
  int16_t var40;
  int8_t var41;
  int16_t var42;
  int8_t var43;
  int16_t var44;
  int16_t var45;
  int16_t var46;
  int16_t var47;
  int16_t var48;

  ptr0 = ex->arrays[0];
  ptr4 = ex->arrays[4];
  ptr5 = ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: copyw */
    var32 = var4;
    /* 1: copyw */
    var33 = var5;
    /* 2: select0wb */
    var34 = (uint16_t)var32 & 0xff;
    /* 3: convubw */
    var35 = (uint8_t)var34;
    /* 4: select1wb */
    var38 = ((uint16_t)var33 >> 8)&0xff;
    /* 5: convubw */
    var36 = (uint8_t)var38;
    /* 6: addw */
    var39 = var35 + var36;
    /* 7: mullw */
    var40 = (var39 * var16) & 0xffff;
    /* 8: select1wb */
    var41 = ((uint16_t)var32 >> 8)&0xff;
    /* 9: convubw */
    var42 = (uint8_t)var41;
    /* 10: select0wb */
    var43 = (uint16_t)var33 & 0xff;
    /* 11: convubw */
    var37 = (uint8_t)var43;
    /* 12: addw */
    var44 = var42 + var37;
    /* 13: mullw */
    var45 = (var44 * var17) & 0xffff;
    /* 14: addw */
    var46 = var40 + var45;
    /* 15: addw */
    var47 = var46 + var18;
    /* 16: shruw */
    var48 = ((uint16_t)var47) >> var19;
    /* 17: convwb */
    var0 = var48;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_stats_moment_s16 */
static void
_backup_orc_stats_moment_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var4;
  const int16_t * ptr4;
  int32_t var12 = 0;
  const int16_t var16 = 2;
  const int16_t var17 = 0;
  int16_t var32;
  int32_t var33;
  int16_t var34;
  int16_t var35;

  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: absw */
    var32 = ORC_ABS(var4);
    /* 1: subw */
    var34 = var32 - var16;
    /* 2: maxsw */
    var35 = ORC_MAX(var34, var17);
    /* 3: convuwl */
    var33 = (uint16_t)var35;
    /* 4: accl */
    var12 = var12 + var33;
  }
  ex->accumulators[0] = var12;

}

/* orc_stats_above_s16 */
static void
_backup_orc_stats_above_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var4;
  const int16_t * ptr4;
  int32_t var12 = 0;
  const int16_t var16 = 1;
  const int16_t var17 = 0;
  const int16_t var18 = 1;
  int16_t var32;
  int32_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;

  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: absw */
    var32 = ORC_ABS(var4);
    /* 1: subw */
    var34 = var32 - var16;
    /* 2: maxsw */
    var35 = ORC_MAX(var34, var17);
    /* 3: minsw */
    var36 = ORC_MIN(var35, var18);
    /* 4: convuwl */
    var33 = (uint16_t)var36;
    /* 5: accl */
    var12 = var12 + var33;
  }
  ex->accumulators[0] = var12;

}

/* orc_accw */
static void
_backup_orc_accw (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  int16_t var4;
  const int16_t * ptr4;
  int16_t var12 = 0;
  int16_t var32;

  ptr4 = ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: absw */
    var32 = ORC_ABS(var4);
    /* 1: accw */
    var12 = var12 + var32;
  }
  ex->accumulators[0] = (var12 & 0xffff);

}

/* orc_avg2_8xn_u8 */
static void
_backup_orc_avg2_8xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 8;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: avgub */
      var0 = ((uint8_t)var4 + (uint8_t)var5 + 1)>>1;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_avg2_12xn_u8 */
static void
_backup_orc_avg2_12xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 12;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: avgub */
      var0 = ((uint8_t)var4 + (uint8_t)var5 + 1)>>1;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_avg2_16xn_u8 */
static void
_backup_orc_avg2_16xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 16;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: avgub */
      var0 = ((uint8_t)var4 + (uint8_t)var5 + 1)>>1;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_avg2_32xn_u8 */
static void
_backup_orc_avg2_32xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 32;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: avgub */
      var0 = ((uint8_t)var4 + (uint8_t)var5 + 1)>>1;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_avg2_nxm_u8 */
static void
_backup_orc_avg2_nxm_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: avgub */
      var0 = ((uint8_t)var4 + (uint8_t)var5 + 1)>>1;
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_combine4_8xn_u8 */
static void
_backup_orc_combine4_8xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 8;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int8_t var6;
  const int8_t * ptr6;
  int8_t var7;
  const int8_t * ptr7;
  const int16_t var16 = 8;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  const int16_t var27 = ex->params[27];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;
  int16_t var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET(ex->arrays[6], ex->params[6] * j);
    ptr7 = ORC_PTR_OFFSET(ex->arrays[7], ex->params[7] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      var6 = *ptr6;
      ptr6++;
      var7 = *ptr7;
      ptr7++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: mullw */
      var33 = (var32 * var24) & 0xffff;
      /* 2: convubw */
      var34 = (uint8_t)var5;
      /* 3: mullw */
      var35 = (var34 * var25) & 0xffff;
      /* 4: addw */
      var36 = var33 + var35;
      /* 5: convubw */
      var37 = (uint8_t)var6;
      /* 6: mullw */
      var38 = (var37 * var26) & 0xffff;
      /* 7: addw */
      var39 = var36 + var38;
      /* 8: convubw */
      var40 = (uint8_t)var7;
      /* 9: mullw */
      var41 = (var40 * var27) & 0xffff;
      /* 10: addw */
      var42 = var39 + var41;
      /* 11: addw */
      var43 = var42 + var16;
      /* 12: convsuswb */
      var0 = ORC_CLAMP_UB(var43);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_combine4_12xn_u8 */
static void
_backup_orc_combine4_12xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 12;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int8_t var6;
  const int8_t * ptr6;
  int8_t var7;
  const int8_t * ptr7;
  const int16_t var16 = 8;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  const int16_t var27 = ex->params[27];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;
  int16_t var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET(ex->arrays[6], ex->params[6] * j);
    ptr7 = ORC_PTR_OFFSET(ex->arrays[7], ex->params[7] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      var6 = *ptr6;
      ptr6++;
      var7 = *ptr7;
      ptr7++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: mullw */
      var33 = (var32 * var24) & 0xffff;
      /* 2: convubw */
      var34 = (uint8_t)var5;
      /* 3: mullw */
      var35 = (var34 * var25) & 0xffff;
      /* 4: addw */
      var36 = var33 + var35;
      /* 5: convubw */
      var37 = (uint8_t)var6;
      /* 6: mullw */
      var38 = (var37 * var26) & 0xffff;
      /* 7: addw */
      var39 = var36 + var38;
      /* 8: convubw */
      var40 = (uint8_t)var7;
      /* 9: mullw */
      var41 = (var40 * var27) & 0xffff;
      /* 10: addw */
      var42 = var39 + var41;
      /* 11: addw */
      var43 = var42 + var16;
      /* 12: convsuswb */
      var0 = ORC_CLAMP_UB(var43);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_combine4_16xn_u8 */
static void
_backup_orc_combine4_16xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 16;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int8_t var6;
  const int8_t * ptr6;
  int8_t var7;
  const int8_t * ptr7;
  const int16_t var16 = 8;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  const int16_t var27 = ex->params[27];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;
  int16_t var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET(ex->arrays[6], ex->params[6] * j);
    ptr7 = ORC_PTR_OFFSET(ex->arrays[7], ex->params[7] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      var6 = *ptr6;
      ptr6++;
      var7 = *ptr7;
      ptr7++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: mullw */
      var33 = (var32 * var24) & 0xffff;
      /* 2: convubw */
      var34 = (uint8_t)var5;
      /* 3: mullw */
      var35 = (var34 * var25) & 0xffff;
      /* 4: addw */
      var36 = var33 + var35;
      /* 5: convubw */
      var37 = (uint8_t)var6;
      /* 6: mullw */
      var38 = (var37 * var26) & 0xffff;
      /* 7: addw */
      var39 = var36 + var38;
      /* 8: convubw */
      var40 = (uint8_t)var7;
      /* 9: mullw */
      var41 = (var40 * var27) & 0xffff;
      /* 10: addw */
      var42 = var39 + var41;
      /* 11: addw */
      var43 = var42 + var16;
      /* 12: convsuswb */
      var0 = ORC_CLAMP_UB(var43);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_combine4_24xn_u8 */
static void
_backup_orc_combine4_24xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 24;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int8_t var6;
  const int8_t * ptr6;
  int8_t var7;
  const int8_t * ptr7;
  const int16_t var16 = 8;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  const int16_t var27 = ex->params[27];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;
  int16_t var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET(ex->arrays[6], ex->params[6] * j);
    ptr7 = ORC_PTR_OFFSET(ex->arrays[7], ex->params[7] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      var6 = *ptr6;
      ptr6++;
      var7 = *ptr7;
      ptr7++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: mullw */
      var33 = (var32 * var24) & 0xffff;
      /* 2: convubw */
      var34 = (uint8_t)var5;
      /* 3: mullw */
      var35 = (var34 * var25) & 0xffff;
      /* 4: addw */
      var36 = var33 + var35;
      /* 5: convubw */
      var37 = (uint8_t)var6;
      /* 6: mullw */
      var38 = (var37 * var26) & 0xffff;
      /* 7: addw */
      var39 = var36 + var38;
      /* 8: convubw */
      var40 = (uint8_t)var7;
      /* 9: mullw */
      var41 = (var40 * var27) & 0xffff;
      /* 10: addw */
      var42 = var39 + var41;
      /* 11: addw */
      var43 = var42 + var16;
      /* 12: convsuswb */
      var0 = ORC_CLAMP_UB(var43);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_combine4_32xn_u8 */
static void
_backup_orc_combine4_32xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 32;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int8_t var6;
  const int8_t * ptr6;
  int8_t var7;
  const int8_t * ptr7;
  const int16_t var16 = 8;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  const int16_t var27 = ex->params[27];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;
  int16_t var43;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET(ex->arrays[6], ex->params[6] * j);
    ptr7 = ORC_PTR_OFFSET(ex->arrays[7], ex->params[7] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      var6 = *ptr6;
      ptr6++;
      var7 = *ptr7;
      ptr7++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: mullw */
      var33 = (var32 * var24) & 0xffff;
      /* 2: convubw */
      var34 = (uint8_t)var5;
      /* 3: mullw */
      var35 = (var34 * var25) & 0xffff;
      /* 4: addw */
      var36 = var33 + var35;
      /* 5: convubw */
      var37 = (uint8_t)var6;
      /* 6: mullw */
      var38 = (var37 * var26) & 0xffff;
      /* 7: addw */
      var39 = var36 + var38;
      /* 8: convubw */
      var40 = (uint8_t)var7;
      /* 9: mullw */
      var41 = (var40 * var27) & 0xffff;
      /* 10: addw */
      var42 = var39 + var41;
      /* 11: addw */
      var43 = var42 + var16;
      /* 12: convsuswb */
      var0 = ORC_CLAMP_UB(var43);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_combine4_nxm_u8 */
static void
_backup_orc_combine4_nxm_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int8_t var6;
  const int8_t * ptr6;
  int8_t var7;
  const int8_t * ptr7;
  const int16_t var16 = 8;
  const int16_t var17 = 4;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  const int16_t var27 = ex->params[27];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;
  int16_t var39;
  int16_t var40;
  int16_t var41;
  int16_t var42;
  int16_t var43;
  int16_t var44;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);
    ptr6 = ORC_PTR_OFFSET(ex->arrays[6], ex->params[6] * j);
    ptr7 = ORC_PTR_OFFSET(ex->arrays[7], ex->params[7] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      var6 = *ptr6;
      ptr6++;
      var7 = *ptr7;
      ptr7++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: mullw */
      var33 = (var32 * var24) & 0xffff;
      /* 2: convubw */
      var34 = (uint8_t)var5;
      /* 3: mullw */
      var35 = (var34 * var25) & 0xffff;
      /* 4: addw */
      var36 = var33 + var35;
      /* 5: convubw */
      var37 = (uint8_t)var6;
      /* 6: mullw */
      var38 = (var37 * var26) & 0xffff;
      /* 7: addw */
      var39 = var36 + var38;
      /* 8: convubw */
      var40 = (uint8_t)var7;
      /* 9: mullw */
      var41 = (var40 * var27) & 0xffff;
      /* 10: addw */
      var42 = var39 + var41;
      /* 11: addw */
      var43 = var42 + var16;
      /* 12: shrsw */
      var44 = var43 >> var17;
      /* 13: convsuswb */
      var0 = ORC_CLAMP_UB(var44);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_combine2_8xn_u8 */
static void
_backup_orc_combine2_8xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 8;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  const int16_t var27 = ex->params[27];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: convubw */
      var33 = (uint8_t)var5;
      /* 2: mullw */
      var34 = (var32 * var24) & 0xffff;
      /* 3: mullw */
      var35 = (var33 * var25) & 0xffff;
      /* 4: addw */
      var36 = var34 + var35;
      /* 5: addw */
      var37 = var36 + var26;
      /* 6: shrsw */
      var38 = var37 >> var27;
      /* 7: convsuswb */
      var0 = ORC_CLAMP_UB(var38);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_combine2_12xn_u8 */
static void
_backup_orc_combine2_12xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 12;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  const int16_t var27 = ex->params[27];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: convubw */
      var33 = (uint8_t)var5;
      /* 2: mullw */
      var34 = (var32 * var24) & 0xffff;
      /* 3: mullw */
      var35 = (var33 * var25) & 0xffff;
      /* 4: addw */
      var36 = var34 + var35;
      /* 5: addw */
      var37 = var36 + var26;
      /* 6: shrsw */
      var38 = var37 >> var27;
      /* 7: convsuswb */
      var0 = ORC_CLAMP_UB(var38);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_combine2_16xn_u8 */
static void
_backup_orc_combine2_16xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 16;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  const int16_t var27 = ex->params[27];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: convubw */
      var33 = (uint8_t)var5;
      /* 2: mullw */
      var34 = (var32 * var24) & 0xffff;
      /* 3: mullw */
      var35 = (var33 * var25) & 0xffff;
      /* 4: addw */
      var36 = var34 + var35;
      /* 5: addw */
      var37 = var36 + var26;
      /* 6: shrsw */
      var38 = var37 >> var27;
      /* 7: convsuswb */
      var0 = ORC_CLAMP_UB(var38);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_combine2_nxm_u8 */
static void
_backup_orc_combine2_nxm_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  int8_t var0;
  int8_t * ptr0;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  const int16_t var24 = ex->params[24];
  const int16_t var25 = ex->params[25];
  const int16_t var26 = ex->params[26];
  const int16_t var27 = ex->params[27];
  int16_t var32;
  int16_t var33;
  int16_t var34;
  int16_t var35;
  int16_t var36;
  int16_t var37;
  int16_t var38;

  for (j = 0; j < m; j++) {
    ptr0 = ORC_PTR_OFFSET(ex->arrays[0], ex->params[0] * j);
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: convubw */
      var32 = (uint8_t)var4;
      /* 1: convubw */
      var33 = (uint8_t)var5;
      /* 2: mullw */
      var34 = (var32 * var24) & 0xffff;
      /* 3: mullw */
      var35 = (var33 * var25) & 0xffff;
      /* 4: addw */
      var36 = var34 + var35;
      /* 5: addw */
      var37 = var36 + var26;
      /* 6: shrsw */
      var38 = var37 >> var27;
      /* 7: convsuswb */
      var0 = ORC_CLAMP_UB(var38);
      *ptr0 = var0;
      ptr0++;
    }
  }

}

/* orc_sad_nxm_u8 */
static void
_backup_orc_sad_nxm_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = ex->n;
  int m = ex->params[ORC_VAR_A1];
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int32_t var12 = 0;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: accsadubl */
      var12 = var12 + ORC_ABS((int32_t)(uint8_t)var4 - (int32_t)(uint8_t)var5);
    }
  }
  ex->accumulators[0] = var12;

}

/* orc_sad_8x8_u8 */
static void
_backup_orc_sad_8x8_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 8;
  int m = 8;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int32_t var12 = 0;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: accsadubl */
      var12 = var12 + ORC_ABS((int32_t)(uint8_t)var4 - (int32_t)(uint8_t)var5);
    }
  }
  ex->accumulators[0] = var12;

}

/* orc_sad_12x12_u8 */
static void
_backup_orc_sad_12x12_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 12;
  int m = 12;
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int32_t var12 = 0;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: accsadubl */
      var12 = var12 + ORC_ABS((int32_t)(uint8_t)var4 - (int32_t)(uint8_t)var5);
    }
  }
  ex->accumulators[0] = var12;

}

/* orc_sad_16xn_u8 */
static void
_backup_orc_sad_16xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 16;
  int m = ex->params[ORC_VAR_A1];
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int32_t var12 = 0;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: accsadubl */
      var12 = var12 + ORC_ABS((int32_t)(uint8_t)var4 - (int32_t)(uint8_t)var5);
    }
  }
  ex->accumulators[0] = var12;

}

/* orc_sad_32xn_u8 */
static void
_backup_orc_sad_32xn_u8 (OrcExecutor *ex)
{
  int i;
  int j;
  int n = 32;
  int m = ex->params[ORC_VAR_A1];
  int8_t var4;
  const int8_t * ptr4;
  int8_t var5;
  const int8_t * ptr5;
  int32_t var12 = 0;

  for (j = 0; j < m; j++) {
    ptr4 = ORC_PTR_OFFSET(ex->arrays[4], ex->params[4] * j);
    ptr5 = ORC_PTR_OFFSET(ex->arrays[5], ex->params[5] * j);

    for (i = 0; i < n; i++) {
      var4 = *ptr4;
      ptr4++;
      var5 = *ptr5;
      ptr5++;
      /* 0: accsadubl */
      var12 = var12 + ORC_ABS((int32_t)(uint8_t)var4 - (int32_t)(uint8_t)var5);
    }
  }
  ex->accumulators[0] = var12;

}


int
main (int argc, char *argv[])
{
  int error = FALSE;

  orc_test_init ();

  /* orc_add2_rshift_add_s16_22_op */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_add2_rshift_add_s16_22_op:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_add2_rshift_add_s16_22_op");
    orc_program_set_backup_function (p, _backup_orc_add2_rshift_add_s16_22_op);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
    orc_program_add_source (p, 2, "s3");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_constant (p, 2, 2, "c2");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
    orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_add2_rshift_add_s16_22 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_add2_rshift_add_s16_22:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_add2_rshift_add_s16_22");
    orc_program_set_backup_function (p, _backup_orc_add2_rshift_add_s16_22);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_constant (p, 2, 2, "c2");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S2);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
    orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_add2_rshift_sub_s16_22_op */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_add2_rshift_sub_s16_22_op:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_add2_rshift_sub_s16_22_op");
    orc_program_set_backup_function (p, _backup_orc_add2_rshift_sub_s16_22_op);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
    orc_program_add_source (p, 2, "s3");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_constant (p, 2, 2, "c2");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
    orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_add2_rshift_sub_s16_22 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_add2_rshift_sub_s16_22:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_add2_rshift_sub_s16_22");
    orc_program_set_backup_function (p, _backup_orc_add2_rshift_sub_s16_22);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_constant (p, 2, 2, "c2");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S2);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
    orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_add2_rshift_add_s16_11_op */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_add2_rshift_add_s16_11_op:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_add2_rshift_add_s16_11_op");
    orc_program_set_backup_function (p, _backup_orc_add2_rshift_add_s16_11_op);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
    orc_program_add_source (p, 2, "s3");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "avgsw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3);
    orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_add2_rshift_add_s16_11 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_add2_rshift_add_s16_11:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_add2_rshift_add_s16_11");
    orc_program_set_backup_function (p, _backup_orc_add2_rshift_add_s16_11);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "avgsw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S2);
    orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_add2_rshift_sub_s16_11_op */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_add2_rshift_sub_s16_11_op:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_add2_rshift_sub_s16_11_op");
    orc_program_set_backup_function (p, _backup_orc_add2_rshift_sub_s16_11_op);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
    orc_program_add_source (p, 2, "s3");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "avgsw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3);
    orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_add2_rshift_sub_s16_11 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_add2_rshift_sub_s16_11:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_add2_rshift_sub_s16_11");
    orc_program_set_backup_function (p, _backup_orc_add2_rshift_sub_s16_11);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "avgsw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S2);
    orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_add_const_rshift_s16_11 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_add_const_rshift_s16_11:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_add_const_rshift_s16_11");
    orc_program_set_backup_function (p, _backup_orc_add_const_rshift_s16_11);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 1, "c1");
      orc_program_add_constant (p, 2, 1, "c2");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1);
    orc_program_append (p, "shrsw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_add_const_rshift_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_add_const_rshift_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_add_const_rshift_s16");
    orc_program_set_backup_function (p, _backup_orc_add_const_rshift_s16);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_P1);
    orc_program_append (p, "shrsw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_P2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_add_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_add_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_add_s16");
    orc_program_set_backup_function (p, _backup_orc_add_s16);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_add_s16_2d */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_add_s16_2d:\n");
    p = orc_program_new ();
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_add_s16_2d");
    orc_program_set_backup_function (p, _backup_orc_add_s16_2d);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");

    orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_S1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_addc_rshift_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_addc_rshift_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_addc_rshift_s16");
    orc_program_set_backup_function (p, _backup_orc_addc_rshift_s16);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S2);
    orc_program_append (p, "shrsw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_P1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_lshift1_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_lshift1_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_lshift1_s16");
    orc_program_set_backup_function (p, _backup_orc_lshift1_s16);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 1, "c1");

    orc_program_append (p, "shlw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_C1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_lshift2_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_lshift2_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_lshift2_s16");
    orc_program_set_backup_function (p, _backup_orc_lshift2_s16);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 2, "c1");

    orc_program_append (p, "shlw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_C1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_lshift_s16_ip */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_lshift_s16_ip:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_lshift_s16_ip");
    orc_program_set_backup_function (p, _backup_orc_lshift_s16_ip);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_parameter (p, 2, "p1");

    orc_program_append (p, "shlw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_P1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_mas2_add_s16_op */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_mas2_add_s16_op:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_mas2_add_s16_op");
    orc_program_set_backup_function (p, _backup_orc_mas2_add_s16_op);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
    orc_program_add_source (p, 2, "s3");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 4, "p2");
    orc_program_add_parameter (p, 4, "p3");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 4, "t2");

    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3);
    orc_program_append (p, "mulswl", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "addl", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2);
    orc_program_append (p, "shrsl", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P3);
    orc_program_append (p, "convlw", ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
    orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_mas2_add_s16_ip */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_mas2_add_s16_ip:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_mas2_add_s16_ip");
    orc_program_set_backup_function (p, _backup_orc_mas2_add_s16_ip);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 4, "p2");
    orc_program_add_parameter (p, 4, "p3");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 4, "t2");

    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S2);
    orc_program_append (p, "mulswl", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "addl", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2);
    orc_program_append (p, "shrsl", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P3);
    orc_program_append (p, "convlw", ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
    orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_mas2_sub_s16_op */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_mas2_sub_s16_op:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_mas2_sub_s16_op");
    orc_program_set_backup_function (p, _backup_orc_mas2_sub_s16_op);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
    orc_program_add_source (p, 2, "s3");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 4, "p2");
    orc_program_add_parameter (p, 4, "p3");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 4, "t2");

    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3);
    orc_program_append (p, "mulswl", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "addl", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2);
    orc_program_append (p, "shrsl", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P3);
    orc_program_append (p, "convlw", ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
    orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_mas2_sub_s16_ip */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_mas2_sub_s16_ip:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_mas2_sub_s16_ip");
    orc_program_set_backup_function (p, _backup_orc_mas2_sub_s16_ip);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 4, "p2");
    orc_program_add_parameter (p, 4, "p3");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 4, "t2");

    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S2);
    orc_program_append (p, "mulswl", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "addl", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2);
    orc_program_append (p, "shrsl", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P3);
    orc_program_append (p, "convlw", ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_D1);
    orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_mas4_across_add_s16_1991_op */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_mas4_across_add_s16_1991_op:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_mas4_across_add_s16_1991_op");
    orc_program_set_backup_function (p, _backup_orc_mas4_across_add_s16_1991_op);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
    orc_program_add_source (p, 2, "s3");
    orc_program_add_source (p, 2, "s4");
    orc_program_add_source (p, 2, "s5");
      orc_program_add_constant (p, 2, 9, "c1");
    orc_program_add_parameter (p, 4, "p1");
    orc_program_add_parameter (p, 4, "p2");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");
    orc_program_add_temporary (p, 4, "t3");
    orc_program_add_temporary (p, 4, "t4");

    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_S4);
    orc_program_append (p, "mulswl", ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_S5);
    orc_program_append (p, "convswl", ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_D1);
    orc_program_append (p, "subl", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4);
    orc_program_append (p, "addl", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P1);
    orc_program_append (p, "shrsl", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P2);
    orc_program_append (p, "convlw", ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1);
    orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_mas4_across_add_s16_1991_ip */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_mas4_across_add_s16_1991_ip:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_mas4_across_add_s16_1991_ip");
    orc_program_set_backup_function (p, _backup_orc_mas4_across_add_s16_1991_ip);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
    orc_program_add_source (p, 2, "s3");
    orc_program_add_source (p, 2, "s4");
      orc_program_add_constant (p, 2, 9, "c1");
    orc_program_add_parameter (p, 4, "p1");
    orc_program_add_parameter (p, 4, "p2");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");
    orc_program_add_temporary (p, 4, "t3");
    orc_program_add_temporary (p, 4, "t4");

    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3);
    orc_program_append (p, "mulswl", ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_S4);
    orc_program_append (p, "convswl", ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_D1);
    orc_program_append (p, "subl", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4);
    orc_program_append (p, "addl", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P1);
    orc_program_append (p, "shrsl", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P2);
    orc_program_append (p, "convlw", ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1);
    orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_mas4_across_sub_s16_1991_op */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_mas4_across_sub_s16_1991_op:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_mas4_across_sub_s16_1991_op");
    orc_program_set_backup_function (p, _backup_orc_mas4_across_sub_s16_1991_op);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
    orc_program_add_source (p, 2, "s3");
    orc_program_add_source (p, 2, "s4");
    orc_program_add_source (p, 2, "s5");
      orc_program_add_constant (p, 2, 9, "c1");
    orc_program_add_parameter (p, 4, "p1");
    orc_program_add_parameter (p, 4, "p2");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");
    orc_program_add_temporary (p, 4, "t3");
    orc_program_add_temporary (p, 4, "t4");

    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_S4);
    orc_program_append (p, "mulswl", ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_S5);
    orc_program_append (p, "convswl", ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_D1);
    orc_program_append (p, "subl", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4);
    orc_program_append (p, "addl", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P1);
    orc_program_append (p, "shrsl", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P2);
    orc_program_append (p, "convlw", ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1);
    orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_mas4_across_sub_s16_1991_ip */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_mas4_across_sub_s16_1991_ip:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_mas4_across_sub_s16_1991_ip");
    orc_program_set_backup_function (p, _backup_orc_mas4_across_sub_s16_1991_ip);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
    orc_program_add_source (p, 2, "s3");
    orc_program_add_source (p, 2, "s4");
      orc_program_add_constant (p, 2, 9, "c1");
    orc_program_add_parameter (p, 4, "p1");
    orc_program_add_parameter (p, 4, "p2");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");
    orc_program_add_temporary (p, 4, "t3");
    orc_program_add_temporary (p, 4, "t4");

    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_S3);
    orc_program_append (p, "mulswl", ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_S1, ORC_VAR_S4);
    orc_program_append (p, "convswl", ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_D1);
    orc_program_append (p, "subl", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4);
    orc_program_append (p, "addl", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P1);
    orc_program_append (p, "shrsl", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P2);
    orc_program_append (p, "convlw", ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1);
    orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_subtract_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_subtract_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_subtract_s16");
    orc_program_set_backup_function (p, _backup_orc_subtract_s16);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_add_s16_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_add_s16_u8:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_add_s16_u8");
    orc_program_set_backup_function (p, _backup_orc_add_s16_u8);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_S1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_add_s16_u8_2d */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_add_s16_u8_2d:\n");
    p = orc_program_new ();
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_add_s16_u8_2d");
    orc_program_set_backup_function (p, _backup_orc_add_s16_u8_2d);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_convert_s16_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_convert_s16_u8:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_convert_s16_u8");
    orc_program_set_backup_function (p, _backup_orc_convert_s16_u8);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 1, "s1");

    orc_program_append (p, "convubw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_convert_u8_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_convert_u8_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_convert_u8_s16");
    orc_program_set_backup_function (p, _backup_orc_convert_u8_s16);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 2, "s1");

    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_offsetconvert_u8_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_offsetconvert_u8_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_offsetconvert_u8_s16");
    orc_program_set_backup_function (p, _backup_orc_offsetconvert_u8_s16);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 128, "c1");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1);
    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_offsetconvert_s16_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_offsetconvert_s16_u8:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_offsetconvert_s16_u8");
    orc_program_set_backup_function (p, _backup_orc_offsetconvert_s16_u8);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 1, "s1");
      orc_program_add_constant (p, 2, 128, "c1");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_subtract_s16_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_subtract_s16_u8:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_subtract_s16_u8");
    orc_program_set_backup_function (p, _backup_orc_subtract_s16_u8);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_multiply_and_add_s16_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_multiply_and_add_s16_u8:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_multiply_and_add_s16_u8");
    orc_program_set_backup_function (p, _backup_orc_multiply_and_add_s16_u8);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_S1);
    orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_splat_s16_ns */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_splat_s16_ns:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_splat_s16_ns");
    orc_program_set_backup_function (p, _backup_orc_splat_s16_ns);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_parameter (p, 2, "p1");

    orc_program_append (p, "copyw", ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_splat_s16_2d_4xn */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_splat_s16_2d_4xn:\n");
    p = orc_program_new ();
      orc_program_set_constant_n (p, 4);
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_splat_s16_2d_4xn");
    orc_program_set_backup_function (p, _backup_orc_splat_s16_2d_4xn);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_parameter (p, 2, "p1");

    orc_program_append (p, "copyw", ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_splat_s16_2d_8xn */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_splat_s16_2d_8xn:\n");
    p = orc_program_new ();
      orc_program_set_constant_n (p, 8);
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_splat_s16_2d_8xn");
    orc_program_set_backup_function (p, _backup_orc_splat_s16_2d_8xn);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_parameter (p, 2, "p1");

    orc_program_append (p, "copyw", ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_splat_s16_2d */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_splat_s16_2d:\n");
    p = orc_program_new ();
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_splat_s16_2d");
    orc_program_set_backup_function (p, _backup_orc_splat_s16_2d);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_parameter (p, 2, "p1");

    orc_program_append (p, "copyw", ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_splat_u8_ns */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_splat_u8_ns:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_splat_u8_ns");
    orc_program_set_backup_function (p, _backup_orc_splat_u8_ns);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_parameter (p, 1, "p1");

    orc_program_append (p, "copyb", ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_splat_u8_2d */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_splat_u8_2d:\n");
    p = orc_program_new ();
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_splat_u8_2d");
    orc_program_set_backup_function (p, _backup_orc_splat_u8_2d);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_parameter (p, 1, "p1");

    orc_program_append (p, "copyb", ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_average_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_average_u8:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_average_u8");
    orc_program_set_backup_function (p, _backup_orc_average_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "avgub", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_rrshift6_add_s16_2d */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_rrshift6_add_s16_2d:\n");
    p = orc_program_new ();
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_rrshift6_add_s16_2d");
    orc_program_set_backup_function (p, _backup_orc_rrshift6_add_s16_2d);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 2, 32, "c1");
      orc_program_add_constant (p, 2, 6, "c2");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_C1);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T1);
    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_rrshift6_sub_s16_2d */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_rrshift6_sub_s16_2d:\n");
    p = orc_program_new ();
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_rrshift6_sub_s16_2d");
    orc_program_set_backup_function (p, _backup_orc_rrshift6_sub_s16_2d);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_destination (p, 2, "d2");
      orc_program_add_constant (p, 2, 8160, "c1");
      orc_program_add_constant (p, 2, 6, "c2");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_D2, ORC_VAR_C1);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
    orc_program_append (p, "copyw", ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_rrshift6_s16_ip_2d */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_rrshift6_s16_ip_2d:\n");
    p = orc_program_new ();
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_rrshift6_s16_ip_2d");
    orc_program_set_backup_function (p, _backup_orc_rrshift6_s16_ip_2d);
    orc_program_add_destination (p, 2, "d1");
      orc_program_add_constant (p, 2, 8160, "c1");
      orc_program_add_constant (p, 2, 6, "c2");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_C1);
    orc_program_append (p, "shrsw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_rrshift6_s16_ip */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_rrshift6_s16_ip:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_rrshift6_s16_ip");
    orc_program_set_backup_function (p, _backup_orc_rrshift6_s16_ip);
    orc_program_add_destination (p, 2, "d1");
      orc_program_add_constant (p, 2, 8160, "c1");
      orc_program_add_constant (p, 2, 6, "c2");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_C1);
    orc_program_append (p, "shrsw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_unpack_yuyv_y */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_unpack_yuyv_y:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_unpack_yuyv_y");
    orc_program_set_backup_function (p, _backup_orc_unpack_yuyv_y);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 2, "s1");

    orc_program_append (p, "select0wb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_unpack_yuyv_u */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_unpack_yuyv_u:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_unpack_yuyv_u");
    orc_program_set_backup_function (p, _backup_orc_unpack_yuyv_u);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "select0lw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "select1wb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_unpack_yuyv_v */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_unpack_yuyv_v:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_unpack_yuyv_v");
    orc_program_set_backup_function (p, _backup_orc_unpack_yuyv_v);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "select1lw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "select1wb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_packyuyv */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_packyuyv:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_packyuyv");
    orc_program_set_backup_function (p, _backup_orc_packyuyv);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_source (p, 1, "s3");
    orc_program_add_temporary (p, 1, "t1");
    orc_program_add_temporary (p, 1, "t2");
    orc_program_add_temporary (p, 2, "t3");
    orc_program_add_temporary (p, 2, "t4");
    orc_program_add_temporary (p, 2, "t5");

    orc_program_append (p, "copyw", ORC_VAR_T5, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "select0wb", ORC_VAR_T1, ORC_VAR_T5, ORC_VAR_D1);
    orc_program_append (p, "select1wb", ORC_VAR_T2, ORC_VAR_T5, ORC_VAR_D1);
    orc_program_append (p, "mergebw", ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_S2);
    orc_program_append (p, "mergebw", ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_S3);
    orc_program_append (p, "mergewl", ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_T4);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_unpack_uyvy_y */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_unpack_uyvy_y:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_unpack_uyvy_y");
    orc_program_set_backup_function (p, _backup_orc_unpack_uyvy_y);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 2, "s1");

    orc_program_append (p, "select1wb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_unpack_uyvy_u */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_unpack_uyvy_u:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_unpack_uyvy_u");
    orc_program_set_backup_function (p, _backup_orc_unpack_uyvy_u);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "select0lw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "select0wb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_unpack_uyvy_v */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_unpack_uyvy_v:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_unpack_uyvy_v");
    orc_program_set_backup_function (p, _backup_orc_unpack_uyvy_v);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "select1lw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "select0wb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_interleave2_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_interleave2_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_interleave2_s16");
    orc_program_set_backup_function (p, _backup_orc_interleave2_s16);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "mergewl", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_interleave2_rrshift1_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_interleave2_rrshift1_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_interleave2_rrshift1_s16");
    orc_program_set_backup_function (p, _backup_orc_interleave2_rrshift1_s16);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 2, 1, "c1");
      orc_program_add_constant (p, 2, 1, "c2");
      orc_program_add_constant (p, 2, 1, "c3");
      orc_program_add_constant (p, 2, 1, "c4");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_C3);
    orc_program_append (p, "shrsw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C4);
    orc_program_append (p, "mergewl", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_deinterleave2_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_deinterleave2_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_deinterleave2_s16");
    orc_program_set_backup_function (p, _backup_orc_deinterleave2_s16);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_destination (p, 2, "d2");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_temporary (p, 4, "t1");

    orc_program_append (p, "copyl", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "select0lw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "select1lw", ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_deinterleave2_lshift1_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_deinterleave2_lshift1_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_deinterleave2_lshift1_s16");
    orc_program_set_backup_function (p, _backup_orc_deinterleave2_lshift1_s16);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_destination (p, 2, "d2");
    orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 2, 1, "c1");
      orc_program_add_constant (p, 2, 1, "c2");
    orc_program_add_temporary (p, 4, "t1");
    orc_program_add_temporary (p, 2, "t2");
    orc_program_add_temporary (p, 2, "t3");

    orc_program_append (p, "copyl", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "select0lw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "shlw", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_C1);
    orc_program_append (p, "select1lw", ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "shlw", ORC_VAR_D2, ORC_VAR_T3, ORC_VAR_C2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_haar_deint_lshift1_split_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_haar_deint_lshift1_split_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_haar_deint_lshift1_split_s16");
    orc_program_set_backup_function (p, _backup_orc_haar_deint_lshift1_split_s16);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_destination (p, 2, "d2");
    orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 2, 1, "c1");
      orc_program_add_constant (p, 2, 1, "c2");
      orc_program_add_constant (p, 2, 0, "c3");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");
    orc_program_add_temporary (p, 4, "t3");

    orc_program_append (p, "copyl", ORC_VAR_T3, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "select0lw", ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1);
    orc_program_append (p, "select1lw", ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_D1);
    orc_program_append (p, "shlw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "shlw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C2);
    orc_program_append (p, "subw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
    orc_program_append (p, "copyw", ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_D1);
    orc_program_append (p, "avgsw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C3);
    orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_haar_deint_split_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_haar_deint_split_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_haar_deint_split_s16");
    orc_program_set_backup_function (p, _backup_orc_haar_deint_split_s16);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_destination (p, 2, "d2");
    orc_program_add_source (p, 4, "s1");
      orc_program_add_constant (p, 2, 0, "c1");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");
    orc_program_add_temporary (p, 4, "t3");

    orc_program_append (p, "copyl", ORC_VAR_T3, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "select0lw", ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1);
    orc_program_append (p, "select1lw", ORC_VAR_T2, ORC_VAR_T3, ORC_VAR_D1);
    orc_program_append (p, "subw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
    orc_program_append (p, "copyw", ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_D1);
    orc_program_append (p, "avgsw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1);
    orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_haar_split_s16_lo */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_haar_split_s16_lo:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_haar_split_s16_lo");
    orc_program_set_backup_function (p, _backup_orc_haar_split_s16_lo);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 2, 0, "c1");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "subw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_T1);
    orc_program_append (p, "avgsw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1);
    orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_haar_split_s16_hi */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_haar_split_s16_hi:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_haar_split_s16_hi");
    orc_program_set_backup_function (p, _backup_orc_haar_split_s16_hi);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");

    orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_S2, ORC_VAR_S1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_haar_split_s16_op */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_haar_split_s16_op:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_haar_split_s16_op");
    orc_program_set_backup_function (p, _backup_orc_haar_split_s16_op);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_destination (p, 2, "d2");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 2, 0, "c1");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "subw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_T1);
    orc_program_append (p, "copyw", ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_D1);
    orc_program_append (p, "avgsw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1);
    orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_haar_split_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_haar_split_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_haar_split_s16");
    orc_program_set_backup_function (p, _backup_orc_haar_split_s16);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_destination (p, 2, "d2");
      orc_program_add_constant (p, 2, 0, "c1");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
    orc_program_append (p, "copyw", ORC_VAR_T2, ORC_VAR_D2, ORC_VAR_D1);
    orc_program_append (p, "subw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
    orc_program_append (p, "copyw", ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_D1);
    orc_program_append (p, "avgsw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1);
    orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_haar_synth_s16_lo */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_haar_synth_s16_lo:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_haar_synth_s16_lo");
    orc_program_set_backup_function (p, _backup_orc_haar_synth_s16_lo);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 2, 0, "c1");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "avgsw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_C1);
    orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_haar_synth_s16_hi */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_haar_synth_s16_hi:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_haar_synth_s16_hi");
    orc_program_set_backup_function (p, _backup_orc_haar_synth_s16_hi);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 2, 0, "c1");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");
    orc_program_add_temporary (p, 2, "t3");

    orc_program_append (p, "copyw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "avgsw", ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_C1);
    orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T3);
    orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_haar_synth_s16_op */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_haar_synth_s16_op:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_haar_synth_s16_op");
    orc_program_set_backup_function (p, _backup_orc_haar_synth_s16_op);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_destination (p, 2, "d2");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 2, 0, "c1");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");
    orc_program_add_temporary (p, 2, "t3");

    orc_program_append (p, "copyw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "avgsw", ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_C1);
    orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T3);
    orc_program_append (p, "copyw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "addw", ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_haar_synth_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_haar_synth_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_haar_synth_s16");
    orc_program_set_backup_function (p, _backup_orc_haar_synth_s16);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_destination (p, 2, "d2");
      orc_program_add_constant (p, 2, 0, "c1");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");
    orc_program_add_temporary (p, 2, "t3");

    orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
    orc_program_append (p, "copyw", ORC_VAR_T2, ORC_VAR_D2, ORC_VAR_D1);
    orc_program_append (p, "avgsw", ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_C1);
    orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T3);
    orc_program_append (p, "copyw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "addw", ORC_VAR_D2, ORC_VAR_T2, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_haar_synth_rrshift1_int_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_haar_synth_rrshift1_int_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_haar_synth_rrshift1_int_s16");
    orc_program_set_backup_function (p, _backup_orc_haar_synth_rrshift1_int_s16);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 2, 0, "c1");
      orc_program_add_constant (p, 2, 0, "c2");
      orc_program_add_constant (p, 2, 0, "c3");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "copyw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "avgsw", ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_C1);
    orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T1);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
    orc_program_append (p, "avgsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
    orc_program_append (p, "avgsw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C3);
    orc_program_append (p, "mergewl", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_haar_synth_int_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_haar_synth_int_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_haar_synth_int_s16");
    orc_program_set_backup_function (p, _backup_orc_haar_synth_int_s16);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 2, 0, "c1");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "copyw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "avgsw", ORC_VAR_T1, ORC_VAR_T2, ORC_VAR_C1);
    orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_T1);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
    orc_program_append (p, "mergewl", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_haar_sub_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_haar_sub_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_haar_sub_s16");
    orc_program_set_backup_function (p, _backup_orc_haar_sub_s16);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");

    orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_S1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_haar_add_half_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_haar_add_half_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_haar_add_half_s16");
    orc_program_set_backup_function (p, _backup_orc_haar_add_half_s16);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 0, "c1");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "avgsw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1);
    orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_haar_add_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_haar_add_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_haar_add_s16");
    orc_program_set_backup_function (p, _backup_orc_haar_add_s16);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");

    orc_program_append (p, "addw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_S1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_haar_sub_half_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_haar_sub_half_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_haar_sub_half_s16");
    orc_program_set_backup_function (p, _backup_orc_haar_sub_half_s16);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 0, "c1");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "avgsw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1);
    orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_D1, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_sum_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_sum_u8:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_sum_u8");
    orc_program_set_backup_function (p, _backup_orc_sum_u8);
    orc_program_add_source (p, 1, "s1");
    orc_program_add_accumulator (p, 4, "a1");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 4, "t2");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "convuwl", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "accl", ORC_VAR_A1, ORC_VAR_T2, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_sum_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_sum_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_sum_s16");
    orc_program_set_backup_function (p, _backup_orc_sum_s16);
    orc_program_add_source (p, 2, "s1");
    orc_program_add_accumulator (p, 4, "a1");
    orc_program_add_temporary (p, 4, "t1");

    orc_program_append (p, "convswl", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "accl", ORC_VAR_A1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_sum_square_diff_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_sum_square_diff_u8:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_sum_square_diff_u8");
    orc_program_set_backup_function (p, _backup_orc_sum_square_diff_u8);
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_accumulator (p, 4, "a1");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");
    orc_program_add_temporary (p, 4, "t3");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T1);
    orc_program_append (p, "convuwl", ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "accl", ORC_VAR_A1, ORC_VAR_T3, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_dequantise_s16_2d_4xn */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_dequantise_s16_2d_4xn:\n");
    p = orc_program_new ();
      orc_program_set_constant_n (p, 4);
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_dequantise_s16_2d_4xn");
    orc_program_set_backup_function (p, _backup_orc_dequantise_s16_2d_4xn);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 2, "c1");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "absw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "mullw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_dequantise_s16_2d_8xn */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_dequantise_s16_2d_8xn:\n");
    p = orc_program_new ();
      orc_program_set_constant_n (p, 8);
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_dequantise_s16_2d_8xn");
    orc_program_set_backup_function (p, _backup_orc_dequantise_s16_2d_8xn);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 2, "c1");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "absw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "mullw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_dequantise_s16_ip_2d_8xn */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_dequantise_s16_ip_2d_8xn:\n");
    p = orc_program_new ();
      orc_program_set_constant_n (p, 8);
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_dequantise_s16_ip_2d_8xn");
    orc_program_set_backup_function (p, _backup_orc_dequantise_s16_ip_2d_8xn);
    orc_program_add_destination (p, 2, "d1");
      orc_program_add_constant (p, 2, 2, "c1");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
    orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "absw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "mullw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_dequantise_s16_ip_2d */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_dequantise_s16_ip_2d:\n");
    p = orc_program_new ();
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_dequantise_s16_ip_2d");
    orc_program_set_backup_function (p, _backup_orc_dequantise_s16_ip_2d);
    orc_program_add_destination (p, 2, "d1");
      orc_program_add_constant (p, 2, 2, "c1");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
    orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "absw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "mullw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_dequantise_s16_ip */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_dequantise_s16_ip:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_dequantise_s16_ip");
    orc_program_set_backup_function (p, _backup_orc_dequantise_s16_ip);
    orc_program_add_destination (p, 2, "d1");
      orc_program_add_constant (p, 2, 2, "c1");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_D1, ORC_VAR_D1);
    orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "absw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "mullw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_dequantise_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_dequantise_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_dequantise_s16");
    orc_program_set_backup_function (p, _backup_orc_dequantise_s16);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 2, "c1");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "absw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "mullw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_quantise1_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_quantise1_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_quantise1_s16");
    orc_program_set_backup_function (p, _backup_orc_quantise1_s16);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 2, "c1");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_parameter (p, 2, "p3");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "absw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "shlw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
    orc_program_append (p, "mulhuw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "shruw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
    orc_program_append (p, "mullw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_quantise2_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_quantise2_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_quantise2_s16");
    orc_program_set_backup_function (p, _backup_orc_quantise2_s16);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 2, "c1");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "absw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "shlw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
    orc_program_append (p, "shruw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "mullw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_quantdequant1_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_quantdequant1_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_quantdequant1_s16");
    orc_program_set_backup_function (p, _backup_orc_quantdequant1_s16);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_destination (p, 2, "d2");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_constant (p, 2, 2, "c2");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_parameter (p, 2, "p3");
    orc_program_add_parameter (p, 2, "p4");
    orc_program_add_parameter (p, 2, "p5");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_D2, ORC_VAR_D1);
    orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "absw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "shlw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
    orc_program_append (p, "mulhuw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "shruw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T2);
    orc_program_append (p, "copyw", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1);
    orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P5);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
    orc_program_append (p, "mullw", ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_T2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_quantdequant3_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_quantdequant3_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_quantdequant3_s16");
    orc_program_set_backup_function (p, _backup_orc_quantdequant3_s16);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_destination (p, 2, "d2");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_constant (p, 2, 2, "c2");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_parameter (p, 2, "p3");
    orc_program_add_parameter (p, 2, "p4");
    orc_program_add_parameter (p, 2, "p5");
    orc_program_add_parameter (p, 4, "p6");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");
    orc_program_add_temporary (p, 4, "t3");

    orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_D2, ORC_VAR_D1);
    orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "absw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "shlw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
    orc_program_append (p, "muluwl", ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "addl", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P6);
    orc_program_append (p, "shrul", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_P3);
    orc_program_append (p, "convlw", ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T2);
    orc_program_append (p, "copyw", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1);
    orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P5);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
    orc_program_append (p, "mullw", ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_T2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_quantdequant2_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_quantdequant2_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_quantdequant2_s16");
    orc_program_set_backup_function (p, _backup_orc_quantdequant2_s16);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_destination (p, 2, "d2");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_constant (p, 2, 2, "c2");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_parameter (p, 2, "p3");
    orc_program_add_parameter (p, 2, "p4");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_D2, ORC_VAR_D1);
    orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "absw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "shlw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
    orc_program_append (p, "shruw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_T2);
    orc_program_append (p, "copyw", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1);
    orc_program_append (p, "signw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
    orc_program_append (p, "mullw", ORC_VAR_D2, ORC_VAR_T1, ORC_VAR_T2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_downsample_vert_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_downsample_vert_u8:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_downsample_vert_u8");
    orc_program_set_backup_function (p, _backup_orc_downsample_vert_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_source (p, 1, "s3");
    orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 2, 6, "c1");
      orc_program_add_constant (p, 2, 26, "c2");
      orc_program_add_constant (p, 2, 32, "c3");
      orc_program_add_constant (p, 2, 6, "c4");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");
    orc_program_add_temporary (p, 2, "t3");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S4, ORC_VAR_D1);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "convubw", ORC_VAR_T3, ORC_VAR_S3, ORC_VAR_D1);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T3);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C2);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C3);
    orc_program_append (p, "shruw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C4);
    orc_program_append (p, "convwb", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_downsample_horiz_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_downsample_horiz_u8:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_downsample_horiz_u8");
    orc_program_set_backup_function (p, _backup_orc_downsample_horiz_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 2, 6, "c1");
      orc_program_add_constant (p, 2, 26, "c2");
      orc_program_add_constant (p, 2, 32, "c3");
      orc_program_add_constant (p, 2, 6, "c4");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");
    orc_program_add_temporary (p, 1, "t3");
    orc_program_add_temporary (p, 2, "t4");
    orc_program_add_temporary (p, 2, "t5");
    orc_program_add_temporary (p, 2, "t6");

    orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "copyw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "select0wb", ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "convubw", ORC_VAR_T4, ORC_VAR_T3, ORC_VAR_D1);
    orc_program_append (p, "select1wb", ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_D1);
    orc_program_append (p, "convubw", ORC_VAR_T5, ORC_VAR_T3, ORC_VAR_D1);
    orc_program_append (p, "addw", ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_T5);
    orc_program_append (p, "mullw", ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C1);
    orc_program_append (p, "select1wb", ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "convubw", ORC_VAR_T5, ORC_VAR_T3, ORC_VAR_D1);
    orc_program_append (p, "select0wb", ORC_VAR_T3, ORC_VAR_T2, ORC_VAR_D1);
    orc_program_append (p, "convubw", ORC_VAR_T6, ORC_VAR_T3, ORC_VAR_D1);
    orc_program_append (p, "addw", ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_T6);
    orc_program_append (p, "mullw", ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_C2);
    orc_program_append (p, "addw", ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_T5);
    orc_program_append (p, "addw", ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C3);
    orc_program_append (p, "shruw", ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C4);
    orc_program_append (p, "convwb", ORC_VAR_D1, ORC_VAR_T4, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_stats_moment_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_stats_moment_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_stats_moment_s16");
    orc_program_set_backup_function (p, _backup_orc_stats_moment_s16);
    orc_program_add_source (p, 2, "s1");
    orc_program_add_accumulator (p, 4, "a1");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_constant (p, 2, 0, "c2");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 4, "t2");

    orc_program_append (p, "absw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "maxsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
    orc_program_append (p, "convuwl", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "accl", ORC_VAR_A1, ORC_VAR_T2, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_stats_above_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_stats_above_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_stats_above_s16");
    orc_program_set_backup_function (p, _backup_orc_stats_above_s16);
    orc_program_add_source (p, 2, "s1");
    orc_program_add_accumulator (p, 4, "a1");
      orc_program_add_constant (p, 2, 1, "c1");
      orc_program_add_constant (p, 2, 0, "c2");
      orc_program_add_constant (p, 2, 1, "c3");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 4, "t2");

    orc_program_append (p, "absw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "maxsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
    orc_program_append (p, "minsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C3);
    orc_program_append (p, "convuwl", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "accl", ORC_VAR_A1, ORC_VAR_T2, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_accw */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_accw:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_accw");
    orc_program_set_backup_function (p, _backup_orc_accw);
    orc_program_add_source (p, 2, "s1");
    orc_program_add_accumulator (p, 2, "a1");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "absw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "accw", ORC_VAR_A1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_avg2_8xn_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_avg2_8xn_u8:\n");
    p = orc_program_new ();
      orc_program_set_constant_n (p, 8);
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_avg2_8xn_u8");
    orc_program_set_backup_function (p, _backup_orc_avg2_8xn_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "avgub", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_avg2_12xn_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_avg2_12xn_u8:\n");
    p = orc_program_new ();
      orc_program_set_constant_n (p, 12);
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_avg2_12xn_u8");
    orc_program_set_backup_function (p, _backup_orc_avg2_12xn_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "avgub", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_avg2_16xn_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_avg2_16xn_u8:\n");
    p = orc_program_new ();
      orc_program_set_constant_n (p, 16);
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_avg2_16xn_u8");
    orc_program_set_backup_function (p, _backup_orc_avg2_16xn_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "avgub", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_avg2_32xn_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_avg2_32xn_u8:\n");
    p = orc_program_new ();
      orc_program_set_constant_n (p, 32);
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_avg2_32xn_u8");
    orc_program_set_backup_function (p, _backup_orc_avg2_32xn_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "avgub", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_avg2_nxm_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_avg2_nxm_u8:\n");
    p = orc_program_new ();
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_avg2_nxm_u8");
    orc_program_set_backup_function (p, _backup_orc_avg2_nxm_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "avgub", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_combine4_8xn_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_combine4_8xn_u8:\n");
    p = orc_program_new ();
      orc_program_set_constant_n (p, 8);
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_combine4_8xn_u8");
    orc_program_set_backup_function (p, _backup_orc_combine4_8xn_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_source (p, 1, "s3");
    orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 2, 8, "c1");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_parameter (p, 2, "p3");
    orc_program_add_parameter (p, 2, "p4");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S4, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1);
    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_combine4_12xn_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_combine4_12xn_u8:\n");
    p = orc_program_new ();
      orc_program_set_constant_n (p, 12);
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_combine4_12xn_u8");
    orc_program_set_backup_function (p, _backup_orc_combine4_12xn_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_source (p, 1, "s3");
    orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 2, 8, "c1");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_parameter (p, 2, "p3");
    orc_program_add_parameter (p, 2, "p4");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S4, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1);
    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_combine4_16xn_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_combine4_16xn_u8:\n");
    p = orc_program_new ();
      orc_program_set_constant_n (p, 16);
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_combine4_16xn_u8");
    orc_program_set_backup_function (p, _backup_orc_combine4_16xn_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_source (p, 1, "s3");
    orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 2, 8, "c1");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_parameter (p, 2, "p3");
    orc_program_add_parameter (p, 2, "p4");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S4, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1);
    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_combine4_24xn_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_combine4_24xn_u8:\n");
    p = orc_program_new ();
      orc_program_set_constant_n (p, 24);
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_combine4_24xn_u8");
    orc_program_set_backup_function (p, _backup_orc_combine4_24xn_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_source (p, 1, "s3");
    orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 2, 8, "c1");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_parameter (p, 2, "p3");
    orc_program_add_parameter (p, 2, "p4");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S4, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1);
    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_combine4_32xn_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_combine4_32xn_u8:\n");
    p = orc_program_new ();
      orc_program_set_constant_n (p, 32);
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_combine4_32xn_u8");
    orc_program_set_backup_function (p, _backup_orc_combine4_32xn_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_source (p, 1, "s3");
    orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 2, 8, "c1");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_parameter (p, 2, "p3");
    orc_program_add_parameter (p, 2, "p4");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S4, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1);
    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_combine4_nxm_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_combine4_nxm_u8:\n");
    p = orc_program_new ();
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_combine4_nxm_u8");
    orc_program_set_backup_function (p, _backup_orc_combine4_nxm_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_source (p, 1, "s3");
    orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 2, 8, "c1");
      orc_program_add_constant (p, 2, 4, "c2");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_parameter (p, 2, "p3");
    orc_program_add_parameter (p, 2, "p4");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P2);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S3, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S4, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1);
    orc_program_append (p, "shrsw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C2);
    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_combine2_8xn_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_combine2_8xn_u8:\n");
    p = orc_program_new ();
      orc_program_set_constant_n (p, 8);
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_combine2_8xn_u8");
    orc_program_set_backup_function (p, _backup_orc_combine2_8xn_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_parameter (p, 2, "p3");
    orc_program_add_parameter (p, 2, "p4");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_combine2_12xn_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_combine2_12xn_u8:\n");
    p = orc_program_new ();
      orc_program_set_constant_n (p, 12);
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_combine2_12xn_u8");
    orc_program_set_backup_function (p, _backup_orc_combine2_12xn_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_parameter (p, 2, "p3");
    orc_program_add_parameter (p, 2, "p4");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_combine2_16xn_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_combine2_16xn_u8:\n");
    p = orc_program_new ();
      orc_program_set_constant_n (p, 16);
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_combine2_16xn_u8");
    orc_program_set_backup_function (p, _backup_orc_combine2_16xn_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_parameter (p, 2, "p3");
    orc_program_add_parameter (p, 2, "p4");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_combine2_nxm_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_combine2_nxm_u8:\n");
    p = orc_program_new ();
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_combine2_nxm_u8");
    orc_program_set_backup_function (p, _backup_orc_combine2_nxm_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_parameter (p, 2, "p3");
    orc_program_add_parameter (p, 2, "p4");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_sad_nxm_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_sad_nxm_u8:\n");
    p = orc_program_new ();
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_sad_nxm_u8");
    orc_program_set_backup_function (p, _backup_orc_sad_nxm_u8);
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_accumulator (p, 4, "a1");

    orc_program_append (p, "accsadubl", ORC_VAR_A1, ORC_VAR_S1, ORC_VAR_S2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_sad_8x8_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_sad_8x8_u8:\n");
    p = orc_program_new ();
      orc_program_set_constant_n (p, 8);
      orc_program_set_2d (p);
      orc_program_set_constant_m (p, 8);
    orc_program_set_name (p, "orc_sad_8x8_u8");
    orc_program_set_backup_function (p, _backup_orc_sad_8x8_u8);
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_accumulator (p, 4, "a1");

    orc_program_append (p, "accsadubl", ORC_VAR_A1, ORC_VAR_S1, ORC_VAR_S2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_sad_12x12_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_sad_12x12_u8:\n");
    p = orc_program_new ();
      orc_program_set_constant_n (p, 12);
      orc_program_set_2d (p);
      orc_program_set_constant_m (p, 12);
    orc_program_set_name (p, "orc_sad_12x12_u8");
    orc_program_set_backup_function (p, _backup_orc_sad_12x12_u8);
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_accumulator (p, 4, "a1");

    orc_program_append (p, "accsadubl", ORC_VAR_A1, ORC_VAR_S1, ORC_VAR_S2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_sad_16xn_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_sad_16xn_u8:\n");
    p = orc_program_new ();
      orc_program_set_constant_n (p, 16);
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_sad_16xn_u8");
    orc_program_set_backup_function (p, _backup_orc_sad_16xn_u8);
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_accumulator (p, 4, "a1");

    orc_program_append (p, "accsadubl", ORC_VAR_A1, ORC_VAR_S1, ORC_VAR_S2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }

  /* orc_sad_32xn_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    printf ("orc_sad_32xn_u8:\n");
    p = orc_program_new ();
      orc_program_set_constant_n (p, 32);
      orc_program_set_2d (p);
    orc_program_set_name (p, "orc_sad_32xn_u8");
    orc_program_set_backup_function (p, _backup_orc_sad_32xn_u8);
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_accumulator (p, 4, "a1");

    orc_program_append (p, "accsadubl", ORC_VAR_A1, ORC_VAR_S1, ORC_VAR_S2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    }

    ret = orc_test_compare_output (p);
    if (!ret) {
      error = TRUE;
    }

    orc_program_free (p);
  }


  if (error) {
    return 1;
  };
  return 0;
}
