#ifndef SCREEM_FILE_H
#define SCREEM_FILE_H

#include <glib-object.h>

#define SCREEM_TYPE_FILE            (screem_file_get_type ())
#define SCREEM_FILE(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREEM_TYPE_FILE, ScreemFile))
#define SCREEM_FILE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SCREEM_TYPE_FILE, ScreemFileClass))
#define SCREEM_IS_FILE(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREEM_TYPE_FILE))

typedef struct ScreemFilePrivate ScreemFilePrivate;

typedef enum {
	SCREEM_FILE_UNCOMPRESSED,
	SCREEM_FILE_GZIPPED,
	SCREEM_FILE_BZIPPED
} ScreemFileCompressType;

typedef struct {
	GObject parent;

	ScreemFilePrivate *priv;
} ScreemFile;

typedef struct {
	GObjectClass parent_class;

	void (*long_job)( ScreemFile *file );
	
	void (*error)( ScreemFile *file, const gchar *uri );
	void (*progress)( ScreemFile *file, const gchar *uri,
			guint64 total, guint64 current );
	void (*complete)( ScreemFile *file, const gchar *uri,
			gboolean success );
	
} ScreemFileClass;

GType screem_file_get_type( void );

ScreemFile *screem_file_new( void );
ScreemFile *screem_file_new_with_uri( const gchar *uri );

void screem_file_set_uri( ScreemFile *file, const gchar *uri );
const gchar *screem_file_get_uri( ScreemFile *file );

GError *screem_file_get_error( ScreemFile *file );
ScreemFileCompressType screem_file_get_compression_type( ScreemFile *file );

const gchar *screem_file_get_data( ScreemFile *file );
const GString *screem_file_get_data_as_string( ScreemFile *file );
guint64 screem_file_get_size( const ScreemFile *file );

void screem_file_cancel( ScreemFile *file );
void screem_file_load( ScreemFile *file );

gboolean screem_file_completed( const ScreemFile *file );

const gchar *screem_file_get_mime_type( const ScreemFile *file );

#endif
