#ifndef SCREEM_LINK_VIEW_UTIL_H
#define SCREEM_LINK_VIEW_UTIL_H

#include <libgnomecanvas/gnome-canvas.h>

enum {
	GOODNODE = 1,
	EXTERNALNODE,
	BADNODE,
	NONODE,
	UPDATENODE,
	CHECKNODE
};

/* remote link status */
typedef enum {
	REMOTE_NOT_CHECKED = 0,
	REMOTE_EXISTS,
	REMOTE_UNREACHABLE,
	REMOTE_BROKEN,
	REMOTE_CHECKING
} RemoteStatus;

/* Must keep in sync with sitecopy's values */
typedef enum {
	file_unchanged, /* Remote file is same as local file */
	file_changed, /* File has changed locally, and should be uploaded */
	file_new, /* File is new locally, and should be uploaded */
	file_deleted,/* File deleted locally, and should be deleted remotely */
	file_moved /* File has been moved locally, should be moved remotely */
} SyncStatus;

GnomeCanvasItem* node_draw( GnomeCanvasGroup *root, gdouble x,
			    gdouble y, gint node_type, gboolean legend );

#endif
