#ifndef SCREEM_MARKUP_H
#define SCREEM_MARKUP_H

#include <glib/gtypes.h>

#include "screem-dtd-db.h"
#include "screem-dtd.h"

#include "screem-page.h"
#include "screem-site.h"

const gchar* screem_markup_char_to_ent( guint c );

gboolean screem_markup_is_entity( const gchar *text, guint pos,
		guint *start, guint *end );
gboolean screem_markup_is_attribute( const gchar *text, guint pos,
		guint *start, guint *end );
gboolean screem_markup_is_tag( const gchar *text, guint pos,
		guint *start, guint *end );

gchar *screem_markup_next_tag( const gchar *text, guint pos,
		guint *start, guint *end, gchar **name );

gchar *screem_markup_encode_text( const gchar *text );
gchar *screem_markup_change_case( const gchar *text, gboolean upper );

gboolean screem_markup_next_tag_close( const gchar *text,
		const gchar *tname, guint pos );

GSList *screem_markup_build_attributes_list( const gchar *tag, 
		GSList *list );
GSList *screem_markup_get_links( ScreemDTD *dtd, const gchar *text );

void screem_markup_fix_links( ScreemSite *site,
		ScreemPage *page, const gchar *pagepath,
		const gchar *origpagepath, 
		const gchar *source, const gchar *dest );

void screem_markup_update_from_template( ScreemSite *site,
		ScreemPage *template_page, ScreemPage *page,
		const gchar *template_tag, GSList *blocks );

gchar *screem_markup_basic_html( ScreemDTDDB *db, const gchar *doctype,
		gboolean frameset, gboolean xhtml );

gchar *screem_markup_get_charset( const gchar *text, 
		GCompareFunc compare, guint *retpos, guint *retlen );

#endif
