#ifndef SCREEM_SEARCH_H
#define SCREEM_SEARCH_H

#include <glib-object.h>

#include <regex.h>

#include "screem-page.h"

#define SCREEM_TYPE_SEARCH            (screem_search_get_type ())
#define SCREEM_SEARCH(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREEM_TYPE_SEARCH, ScreemSearch))
#define SCREEM_SEARCH_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SCREEM_TYPE_SEARCH, ScreemSearchClass))
#define SCREEM_IS_SEARCH(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREEM_TYPE_SEARCH))

typedef struct ScreemSearchPrivate ScreemSearchPrivate;

typedef enum {
	SCREEM_SEARCH_SINGLE = 0,
	SCREEM_SEARCH_SITE,
	SCREEM_SEARCH_OPEN
} ScreemSearchType;

typedef enum {
	SCREEM_SEARCH_START = 0,
	SCREEM_SEARCH_CURRENT
} ScreemSearchFrom;

typedef struct  {
	GObject parent;

	ScreemSearchPrivate *priv;
} ScreemSearch;

typedef struct {
        GObjectClass parent_class;

	void (*found)( ScreemSearch *search,
			ScreemPage *page,
			guint pos,
			guint len );
	void (*notfound)( ScreemSearch *search,
			ScreemPage *page );
	
} ScreemSearchClass;

/* util funcs for searching without a ScreemSearch object */
gint screem_search_static( const gchar *text, const gchar *find,
			gboolean use_regex, gint start, guint *length, 
			size_t *nmatch, regmatch_t **pmatch );
gchar *find_text( const gchar *string, const gchar *find, 
		  const gchar *replace, guint *length );

ScreemSearch *screem_search_new( void );
GType screem_search_get_type( void );

void screem_search_set_search_type( ScreemSearch *search,
		ScreemSearchType type );
ScreemSearchType screem_search_get_search_type( const ScreemSearch *search );

void screem_search_set_from( ScreemSearch *search,
		ScreemSearchFrom from, gboolean reset );
ScreemSearchFrom screem_search_get_from( const ScreemSearch *search );

void screem_search_set_regexp( ScreemSearch *search, gboolean flag );
gboolean screem_search_get_regexp( const ScreemSearch *search );

void screem_search_set_find_pattern( ScreemSearch *search,
		const gchar *pattern );
gchar *screem_search_get_find_pattern( const ScreemSearch *search );

void screem_search_set_replace_pattern( ScreemSearch *search,
		const gchar *pattern );
gchar *screem_search_get_replace_pattern( const ScreemSearch *search );


void screem_search_do_find( ScreemSearch *search );
void screem_search_do_replace( ScreemSearch *search );

void screem_search_show_dialog( ScreemSearch *search, 
				gboolean doreplace );

#endif
