#ifndef SCREEM_XML_MODEL_H
#define SCREEM_XML_MODEL_H

#include <gtk/gtktreemodel.h>
#include <libxml/tree.h>

#define SCREEM_TYPE_XML_MODEL              (screem_xml_model_get_type ())
#define SCREEM_XML_MODEL(obj)              (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREEM_TYPE_XML_MODEL, ScreemXmlModel))
#define SCREEM_XML_MODEL_CLASS(vtable)     (G_TYPE_CHECK_CLASS_CAST ((vtable), SCREEM_TYPE_XML_MODEL, ScreemXmlModelClass))
#define SCREEM_IS_XML_MODEL(obj)           (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREEM_TYPE_XML_MODEL))
#define SCREEM_IS_XML_MODEL_CLASS(vtable)  (G_TYPE_CHECK_CLASS_TYPE ((vtable), SCREEM_TYPE_XML_MODEL))
#define SCREEM_XML_MODEL_GET_CLASS(inst)   (G_TYPE_INSTANCE_GET_CLASS ((obj), SCREEM_TYPE_XML_MODEL, ScreemXmlModelClass))

typedef struct ScreemXmlModelPrivate ScreemXmlModelPrivate;

typedef struct {
	GObject parent_instance;

	ScreemXmlModelPrivate *priv;
} ScreemXmlModel;

typedef struct {
  GObjectClass parent_class;
  
} ScreemXmlModelClass;

typedef enum {
	SCREEM_XML_MODEL_NAME,
	SCREEM_XML_MODEL_TEXT,
	SCREEM_XML_MODEL_START,
	SCREEM_XML_MODEL_END,
	SCREEM_XML_MODEL_VALID,
	SCREEM_XML_MODEL_ICON,
	SCREEM_XML_MODEL_NODE,
	
	SCREEM_XML_MODEL_NUM_COLS
} ScreemXmlModelCols;

GType screem_xml_model_get_type( void );
GtkTreeModel *screem_xml_model_new( void );
GtkTreeModel *screem_xml_model_new_with_doc( xmlDocPtr doc );

xmlDocPtr screem_xml_model_get_doc( ScreemXmlModel *model );
void screem_xml_model_set_doc( ScreemXmlModel *model, xmlDocPtr doc );

gboolean screem_xml_model_prepend( ScreemXmlModel *model, 
		GtkTreeIter *it, GtkTreeIter *parent );
gboolean screem_xml_model_append( ScreemXmlModel *model, 
		GtkTreeIter *it, GtkTreeIter *parent );

xmlNodePtr screem_xml_model_get_xml_node( ScreemXmlModel *model,
		GtkTreeIter *it );


void screem_xml_model_set_value( ScreemXmlModel *model,
		GtkTreeIter *iter, gint column, GValue *value );
void screem_xml_model_set_valist( ScreemXmlModel *model,
		GtkTreeIter *iter, va_list va_args );
void screem_xml_model_set( ScreemXmlModel *model, GtkTreeIter *iter,
		... );

#endif 

