/* simple-scan.c generated by valac 0.26.2, the Vala compiler
 * generated from simple-scan.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gudev/gudev.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gio/gio.h>
#include "colord.h"
#include <float.h>
#include <math.h>
#include "sane/sane.h"
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <unistd.h>
#include <locale.h>


#define TYPE_SIMPLE_SCAN (simple_scan_get_type ())
#define SIMPLE_SCAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SIMPLE_SCAN, SimpleScan))
#define SIMPLE_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SIMPLE_SCAN, SimpleScanClass))
#define IS_SIMPLE_SCAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SIMPLE_SCAN))
#define IS_SIMPLE_SCAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SIMPLE_SCAN))
#define SIMPLE_SCAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SIMPLE_SCAN, SimpleScanClass))

typedef struct _SimpleScan SimpleScan;
typedef struct _SimpleScanClass SimpleScanClass;
typedef struct _SimpleScanPrivate SimpleScanPrivate;

#define TYPE_SCAN_DEVICE (scan_device_get_type ())
#define SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_DEVICE, ScanDevice))
#define SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_DEVICE, ScanDeviceClass))
#define IS_SCAN_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_DEVICE))
#define IS_SCAN_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_DEVICE))
#define SCAN_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_DEVICE, ScanDeviceClass))

typedef struct _ScanDevice ScanDevice;
typedef struct _ScanDeviceClass ScanDeviceClass;

#define TYPE_USER_INTERFACE (user_interface_get_type ())
#define USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_INTERFACE, UserInterface))
#define USER_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_INTERFACE, UserInterfaceClass))
#define IS_USER_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_INTERFACE))
#define IS_USER_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_INTERFACE))
#define USER_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_INTERFACE, UserInterfaceClass))

typedef struct _UserInterface UserInterface;
typedef struct _UserInterfaceClass UserInterfaceClass;

#define TYPE_SCANNER (scanner_get_type ())
#define SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCANNER, Scanner))
#define SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCANNER, ScannerClass))
#define IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCANNER))
#define IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCANNER))
#define SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCANNER, ScannerClass))

typedef struct _Scanner Scanner;
typedef struct _ScannerClass ScannerClass;

#define TYPE_BOOK (book_get_type ())
#define BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOOK, Book))
#define BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOOK, BookClass))
#define IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOOK))
#define IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOOK))
#define BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOOK, BookClass))

typedef struct _Book Book;
typedef struct _BookClass BookClass;
#define _scan_device_unref0(var) ((var == NULL) ? NULL : (var = (scan_device_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _scanner_unref0(var) ((var == NULL) ? NULL : (var = (scanner_unref (var), NULL)))
#define _book_unref0(var) ((var == NULL) ? NULL : (var = (book_unref (var), NULL)))

#define TYPE_SCAN_OPTIONS (scan_options_get_type ())
#define SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_OPTIONS, ScanOptions))
#define SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_OPTIONS, ScanOptionsClass))
#define IS_SCAN_OPTIONS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_OPTIONS))
#define IS_SCAN_OPTIONS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_OPTIONS))
#define SCAN_OPTIONS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_OPTIONS, ScanOptionsClass))

typedef struct _ScanOptions ScanOptions;
typedef struct _ScanOptionsClass ScanOptionsClass;

#define TYPE_SCAN_PAGE_INFO (scan_page_info_get_type ())
#define SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfo))
#define SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))
#define IS_SCAN_PAGE_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_PAGE_INFO))
#define IS_SCAN_PAGE_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_PAGE_INFO))
#define SCAN_PAGE_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_PAGE_INFO, ScanPageInfoClass))

typedef struct _ScanPageInfo ScanPageInfo;
typedef struct _ScanPageInfoClass ScanPageInfoClass;

#define TYPE_SCAN_LINE (scan_line_get_type ())
#define SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SCAN_LINE, ScanLine))
#define SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SCAN_LINE, ScanLineClass))
#define IS_SCAN_LINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SCAN_LINE))
#define IS_SCAN_LINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SCAN_LINE))
#define SCAN_LINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SCAN_LINE, ScanLineClass))

typedef struct _ScanLine ScanLine;
typedef struct _ScanLineClass ScanLineClass;
typedef struct _ScanDevicePrivate ScanDevicePrivate;
#define __g_list_free__scan_device_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__scan_device_unref0_ (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ScanPageInfoPrivate ScanPageInfoPrivate;
typedef struct _ScanOptionsPrivate ScanOptionsPrivate;

#define TYPE_SCAN_MODE (scan_mode_get_type ())

#define TYPE_SCAN_TYPE (scan_type_get_type ())
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

struct _SimpleScan {
	GtkApplication parent_instance;
	SimpleScanPrivate * priv;
};

struct _SimpleScanClass {
	GtkApplicationClass parent_class;
};

struct _SimpleScanPrivate {
	ScanDevice* default_device;
	gboolean have_devices;
	GUdevClient* udev_client;
	UserInterface* ui;
	Scanner* scanner;
	Book* book;
};

struct _ScanDevice {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanDevicePrivate * priv;
	gchar* name;
	gchar* label;
};

struct _ScanDeviceClass {
	GTypeClass parent_class;
	void (*finalize) (ScanDevice *self);
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _ScanPageInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanPageInfoPrivate * priv;
	gint width;
	gint height;
	gint depth;
	gint n_channels;
	gdouble dpi;
	gchar* device;
};

struct _ScanPageInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ScanPageInfo *self);
};

typedef enum  {
	SCAN_MODE_DEFAULT,
	SCAN_MODE_COLOR,
	SCAN_MODE_GRAY,
	SCAN_MODE_LINEART
} ScanMode;

typedef enum  {
	SCAN_TYPE_SINGLE,
	SCAN_TYPE_ADF_FRONT,
	SCAN_TYPE_ADF_BACK,
	SCAN_TYPE_ADF_BOTH
} ScanType;

struct _ScanOptions {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ScanOptionsPrivate * priv;
	gint dpi;
	ScanMode scan_mode;
	gint depth;
	ScanType type;
	gint paper_width;
	gint paper_height;
	gint brightness;
	gint contrast;
};

struct _ScanOptionsClass {
	GTypeClass parent_class;
	void (*finalize) (ScanOptions *self);
};


static gpointer simple_scan_parent_class = NULL;
static gboolean simple_scan_show_version;
static gboolean simple_scan_show_version = FALSE;
static gboolean simple_scan_debug_enabled;
static gboolean simple_scan_debug_enabled = FALSE;
static gchar* simple_scan_fix_pdf_filename;
static gchar* simple_scan_fix_pdf_filename = NULL;
static GTimer* simple_scan_log_timer;
static GTimer* simple_scan_log_timer = NULL;
static FILE* simple_scan_log_file;
static FILE* simple_scan_log_file = NULL;

GType simple_scan_get_type (void) G_GNUC_CONST;
gpointer scan_device_ref (gpointer instance);
void scan_device_unref (gpointer instance);
GParamSpec* param_spec_scan_device (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_device (GValue* value, gpointer v_object);
void value_take_scan_device (GValue* value, gpointer v_object);
gpointer value_get_scan_device (const GValue* value);
GType scan_device_get_type (void) G_GNUC_CONST;
GType user_interface_get_type (void) G_GNUC_CONST;
gpointer scanner_ref (gpointer instance);
void scanner_unref (gpointer instance);
GParamSpec* param_spec_scanner (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scanner (GValue* value, gpointer v_object);
void value_take_scanner (GValue* value, gpointer v_object);
gpointer value_get_scanner (const GValue* value);
GType scanner_get_type (void) G_GNUC_CONST;
gpointer book_ref (gpointer instance);
void book_unref (gpointer instance);
GParamSpec* param_spec_book (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_book (GValue* value, gpointer v_object);
void value_take_book (GValue* value, gpointer v_object);
gpointer value_get_book (const GValue* value);
GType book_get_type (void) G_GNUC_CONST;
#define SIMPLE_SCAN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SIMPLE_SCAN, SimpleScanPrivate))
enum  {
	SIMPLE_SCAN_DUMMY_PROPERTY
};
SimpleScan* simple_scan_new (ScanDevice* device);
SimpleScan* simple_scan_construct (GType object_type, ScanDevice* device);
static void simple_scan_real_startup (GApplication* base);
UserInterface* user_interface_new (void);
UserInterface* user_interface_construct (GType object_type);
Book* user_interface_get_book (UserInterface* self);
gpointer scan_options_ref (gpointer instance);
void scan_options_unref (gpointer instance);
GParamSpec* param_spec_scan_options (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_options (GValue* value, gpointer v_object);
void value_take_scan_options (GValue* value, gpointer v_object);
gpointer value_get_scan_options (const GValue* value);
GType scan_options_get_type (void) G_GNUC_CONST;
static void simple_scan_scan_cb (SimpleScan* self, UserInterface* ui, const gchar* device, ScanOptions* options);
static void _simple_scan_scan_cb_user_interface_start_scan (UserInterface* _sender, const gchar* device, ScanOptions* options, gpointer self);
static void simple_scan_cancel_cb (SimpleScan* self, UserInterface* ui);
static void _simple_scan_cancel_cb_user_interface_stop_scan (UserInterface* _sender, gpointer self);
static void simple_scan_email_cb (SimpleScan* self, UserInterface* ui, const gchar* profile, gint quality);
static void _simple_scan_email_cb_user_interface_email (UserInterface* _sender, const gchar* profile, gint quality, gpointer self);
Scanner* scanner_get_instance (void);
static void simple_scan_update_scan_devices_cb (SimpleScan* self, Scanner* scanner, GList* devices);
static void _simple_scan_update_scan_devices_cb_scanner_update_devices (Scanner* _sender, GList* devices, gpointer self);
static void simple_scan_authorize_cb (SimpleScan* self, Scanner* scanner, const gchar* resource);
static void _simple_scan_authorize_cb_scanner_request_authorization (Scanner* _sender, const gchar* resource, gpointer self);
static void simple_scan_scanner_new_page_cb (SimpleScan* self, Scanner* scanner);
static void _simple_scan_scanner_new_page_cb_scanner_expect_page (Scanner* _sender, gpointer self);
gpointer scan_page_info_ref (gpointer instance);
void scan_page_info_unref (gpointer instance);
GParamSpec* param_spec_scan_page_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_page_info (GValue* value, gpointer v_object);
void value_take_scan_page_info (GValue* value, gpointer v_object);
gpointer value_get_scan_page_info (const GValue* value);
GType scan_page_info_get_type (void) G_GNUC_CONST;
static void simple_scan_scanner_page_info_cb (SimpleScan* self, Scanner* scanner, ScanPageInfo* info);
static void _simple_scan_scanner_page_info_cb_scanner_got_page_info (Scanner* _sender, ScanPageInfo* info, gpointer self);
gpointer scan_line_ref (gpointer instance);
void scan_line_unref (gpointer instance);
GParamSpec* param_spec_scan_line (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_scan_line (GValue* value, gpointer v_object);
void value_take_scan_line (GValue* value, gpointer v_object);
gpointer value_get_scan_line (const GValue* value);
GType scan_line_get_type (void) G_GNUC_CONST;
static void simple_scan_scanner_line_cb (SimpleScan* self, Scanner* scanner, ScanLine* line);
static void _simple_scan_scanner_line_cb_scanner_got_line (Scanner* _sender, ScanLine* line, gpointer self);
static void simple_scan_scanner_page_done_cb (SimpleScan* self, Scanner* scanner);
static void _simple_scan_scanner_page_done_cb_scanner_page_done (Scanner* _sender, gpointer self);
static void simple_scan_scanner_document_done_cb (SimpleScan* self, Scanner* scanner);
static void _simple_scan_scanner_document_done_cb_scanner_document_done (Scanner* _sender, gpointer self);
static void simple_scan_scanner_failed_cb (SimpleScan* self, Scanner* scanner, gint error_code, const gchar* error_string);
static void _simple_scan_scanner_failed_cb_scanner_scan_failed (Scanner* _sender, gint error_code, const gchar* error_string, gpointer self);
static void simple_scan_scanner_scanning_changed_cb (SimpleScan* self, Scanner* scanner);
static void _simple_scan_scanner_scanning_changed_cb_scanner_scanning_changed (Scanner* _sender, gpointer self);
static void simple_scan_on_uevent (SimpleScan* self, GUdevClient* client, const gchar* action, GUdevDevice* device);
static void _simple_scan_on_uevent_g_udev_client_uevent (GUdevClient* _sender, const gchar* action, GUdevDevice* device, gpointer self);
void user_interface_set_scan_devices (UserInterface* self, GList* devices);
void user_interface_set_selected_device (UserInterface* self, const gchar* value);
static void _scan_device_unref0_ (gpointer var);
static void _g_list_free__scan_device_unref0_ (GList* self);
static void simple_scan_real_activate (GApplication* base);
void user_interface_start (UserInterface* self);
void scanner_start (Scanner* self);
static void simple_scan_real_shutdown (GApplication* base);
void scanner_free (Scanner* self);
void user_interface_authorize (UserInterface* self, const gchar* resource, gchar** username, gchar** password);
void scanner_authorize (Scanner* self, const gchar* username, const gchar* password);
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
static Page* simple_scan_append_page (SimpleScan* self);
Page* book_get_page (Book* self, gint page_number);
gboolean page_get_has_data (Page* self);
void user_interface_set_selected_page (UserInterface* self, Page* value);
void page_start (Page* self);
GType scan_direction_get_type (void) G_GNUC_CONST;
ScanDirection page_get_scan_direction (Page* self);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
gint page_get_dpi (Page* self);
gboolean page_get_has_crop (Page* self);
const gchar* page_get_crop_name (Page* self);
gint page_get_crop_x (Page* self);
gint page_get_crop_y (Page* self);
gint page_get_crop_width (Page* self);
gint page_get_crop_height (Page* self);
Page* page_new (gint width, gint height, gint dpi, ScanDirection scan_direction);
Page* page_construct (GType object_type, gint width, gint height, gint dpi, ScanDirection scan_direction);
void book_append_page (Book* self, Page* page);
void page_set_named_crop (Page* self, const gchar* name);
void page_set_custom_crop (Page* self, gint width, gint height);
void page_move_crop (Page* self, gint x, gint y);
static gchar* simple_scan_get_profile_for_device (SimpleScan* self, const gchar* device_name);
void page_set_page_info (Page* self, ScanPageInfo* info);
void page_set_color_profile (Page* self, const gchar* value);
guint book_get_n_pages (Book* self);
void page_parse_scan_line (Page* self, ScanLine* line);
void page_finish (Page* self);
static void simple_scan_remove_empty_page (SimpleScan* self);
void book_delete_page (Book* self, Page* page);
void user_interface_show_error (UserInterface* self, const gchar* error_title, const gchar* error_text, gboolean change_scanner_hint);
gboolean scanner_is_scanning (Scanner* self);
void user_interface_set_scanning (UserInterface* self, gboolean value);
GType scan_mode_get_type (void) G_GNUC_CONST;
GType scan_type_get_type (void) G_GNUC_CONST;
void user_interface_set_default_file_name (UserInterface* self, const gchar* value);
void scanner_scan (Scanner* self, const gchar* device, ScanOptions* options);
void scanner_cancel (Scanner* self);
static gchar* simple_scan_get_temporary_filename (SimpleScan* self, const gchar* prefix, const gchar* extension);
void user_interface_show_progress_dialog (UserInterface* self);
void book_save (Book* self, const gchar* type, gint quality, GFile* file, GError** error);
void user_interface_hide_progress_dialog (UserInterface* self);
void page_save (Page* self, const gchar* type, gint quality, GFile* file, GError** error);
static void simple_scan_log_cb (const gchar* log_domain, GLogLevelFlags log_level, const gchar* message);
void scanner_redetect (Scanner* self);
static void simple_scan_fix_pdf (const gchar* filename, GError** error);
gint simple_scan_main (gchar** args, int args_length1);
ScanDevice* scan_device_new (void);
ScanDevice* scan_device_construct (GType object_type);
static void _simple_scan_log_cb_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self);
static void simple_scan_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

const GOptionEntry SIMPLE_SCAN_options[4] = {{"version", 'v', 0, G_OPTION_ARG_NONE, &simple_scan_show_version, "Show release version", NULL}, {"debug", 'd', 0, G_OPTION_ARG_NONE, &simple_scan_debug_enabled, "Print debugging messages", NULL}, {"fix-pdf", (gchar) 0, 0, G_OPTION_ARG_STRING, &simple_scan_fix_pdf_filename, "Fix PDF files generated with older versions of Simple Scan", "FILENAME..."}, {NULL}};

static gpointer _scan_device_ref0 (gpointer self) {
#line 41 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	return self ? scan_device_ref (self) : NULL;
#line 406 "simple-scan.c"
}


SimpleScan* simple_scan_construct (GType object_type, ScanDevice* device) {
	SimpleScan * self = NULL;
	ScanDevice* _tmp0_ = NULL;
	ScanDevice* _tmp1_ = NULL;
#line 39 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	self = (SimpleScan*) g_object_new (object_type, NULL);
#line 41 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp0_ = device;
#line 41 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp1_ = _scan_device_ref0 (_tmp0_);
#line 41 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_scan_device_unref0 (self->priv->default_device);
#line 41 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	self->priv->default_device = _tmp1_;
#line 39 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	return self;
#line 426 "simple-scan.c"
}


SimpleScan* simple_scan_new (ScanDevice* device) {
#line 39 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	return simple_scan_construct (TYPE_SIMPLE_SCAN, device);
#line 433 "simple-scan.c"
}


static gpointer _book_ref0 (gpointer self) {
#line 49 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	return self ? book_ref (self) : NULL;
#line 440 "simple-scan.c"
}


static void _simple_scan_scan_cb_user_interface_start_scan (UserInterface* _sender, const gchar* device, ScanOptions* options, gpointer self) {
#line 50 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	simple_scan_scan_cb ((SimpleScan*) self, _sender, device, options);
#line 447 "simple-scan.c"
}


static void _simple_scan_cancel_cb_user_interface_stop_scan (UserInterface* _sender, gpointer self) {
#line 51 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	simple_scan_cancel_cb ((SimpleScan*) self, _sender);
#line 454 "simple-scan.c"
}


static void _simple_scan_email_cb_user_interface_email (UserInterface* _sender, const gchar* profile, gint quality, gpointer self) {
#line 52 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	simple_scan_email_cb ((SimpleScan*) self, _sender, profile, quality);
#line 461 "simple-scan.c"
}


static void _simple_scan_update_scan_devices_cb_scanner_update_devices (Scanner* _sender, GList* devices, gpointer self) {
#line 55 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	simple_scan_update_scan_devices_cb ((SimpleScan*) self, _sender, devices);
#line 468 "simple-scan.c"
}


static void _simple_scan_authorize_cb_scanner_request_authorization (Scanner* _sender, const gchar* resource, gpointer self) {
#line 56 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	simple_scan_authorize_cb ((SimpleScan*) self, _sender, resource);
#line 475 "simple-scan.c"
}


static void _simple_scan_scanner_new_page_cb_scanner_expect_page (Scanner* _sender, gpointer self) {
#line 57 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	simple_scan_scanner_new_page_cb ((SimpleScan*) self, _sender);
#line 482 "simple-scan.c"
}


static void _simple_scan_scanner_page_info_cb_scanner_got_page_info (Scanner* _sender, ScanPageInfo* info, gpointer self) {
#line 58 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	simple_scan_scanner_page_info_cb ((SimpleScan*) self, _sender, info);
#line 489 "simple-scan.c"
}


static void _simple_scan_scanner_line_cb_scanner_got_line (Scanner* _sender, ScanLine* line, gpointer self) {
#line 59 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	simple_scan_scanner_line_cb ((SimpleScan*) self, _sender, line);
#line 496 "simple-scan.c"
}


static void _simple_scan_scanner_page_done_cb_scanner_page_done (Scanner* _sender, gpointer self) {
#line 60 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	simple_scan_scanner_page_done_cb ((SimpleScan*) self, _sender);
#line 503 "simple-scan.c"
}


static void _simple_scan_scanner_document_done_cb_scanner_document_done (Scanner* _sender, gpointer self) {
#line 61 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	simple_scan_scanner_document_done_cb ((SimpleScan*) self, _sender);
#line 510 "simple-scan.c"
}


static void _simple_scan_scanner_failed_cb_scanner_scan_failed (Scanner* _sender, gint error_code, const gchar* error_string, gpointer self) {
#line 62 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	simple_scan_scanner_failed_cb ((SimpleScan*) self, _sender, error_code, error_string);
#line 517 "simple-scan.c"
}


static void _simple_scan_scanner_scanning_changed_cb_scanner_scanning_changed (Scanner* _sender, gpointer self) {
#line 63 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	simple_scan_scanner_scanning_changed_cb ((SimpleScan*) self, _sender);
#line 524 "simple-scan.c"
}


static void _simple_scan_on_uevent_g_udev_client_uevent (GUdevClient* _sender, const gchar* action, GUdevDevice* device, gpointer self) {
#line 67 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	simple_scan_on_uevent ((SimpleScan*) self, _sender, action, device);
#line 531 "simple-scan.c"
}


static void _scan_device_unref0_ (gpointer var) {
#line 69 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	(var == NULL) ? NULL : (var = (scan_device_unref (var), NULL));
#line 538 "simple-scan.c"
}


static void _g_list_free__scan_device_unref0_ (GList* self) {
#line 69 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_list_foreach (self, (GFunc) _scan_device_unref0_, NULL);
#line 69 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_list_free (self);
#line 547 "simple-scan.c"
}


static void simple_scan_real_startup (GApplication* base) {
	SimpleScan * self;
	UserInterface* _tmp0_ = NULL;
	UserInterface* _tmp1_ = NULL;
	Book* _tmp2_ = NULL;
	Book* _tmp3_ = NULL;
	Book* _tmp4_ = NULL;
	UserInterface* _tmp5_ = NULL;
	UserInterface* _tmp6_ = NULL;
	UserInterface* _tmp7_ = NULL;
	Scanner* _tmp8_ = NULL;
	Scanner* _tmp9_ = NULL;
	Scanner* _tmp10_ = NULL;
	Scanner* _tmp11_ = NULL;
	Scanner* _tmp12_ = NULL;
	Scanner* _tmp13_ = NULL;
	Scanner* _tmp14_ = NULL;
	Scanner* _tmp15_ = NULL;
	Scanner* _tmp16_ = NULL;
	Scanner* _tmp17_ = NULL;
	gchar** subsystems = NULL;
	gchar* _tmp18_ = NULL;
	gchar** _tmp19_ = NULL;
	gint subsystems_length1 = 0;
	gint _subsystems_size_ = 0;
	gchar** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	GUdevClient* _tmp21_ = NULL;
	GUdevClient* _tmp22_ = NULL;
	ScanDevice* _tmp23_ = NULL;
#line 44 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	self = (SimpleScan*) base;
#line 46 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	G_APPLICATION_CLASS (simple_scan_parent_class)->startup ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 48 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp0_ = user_interface_new ();
#line 48 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_object_ref_sink (_tmp0_);
#line 48 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_object_unref0 (self->priv->ui);
#line 48 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	self->priv->ui = _tmp0_;
#line 49 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp1_ = self->priv->ui;
#line 49 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp2_ = user_interface_get_book (_tmp1_);
#line 49 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp3_ = _tmp2_;
#line 49 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp4_ = _book_ref0 (_tmp3_);
#line 49 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_book_unref0 (self->priv->book);
#line 49 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	self->priv->book = _tmp4_;
#line 50 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp5_ = self->priv->ui;
#line 50 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_signal_connect_object (_tmp5_, "start-scan", (GCallback) _simple_scan_scan_cb_user_interface_start_scan, self, 0);
#line 51 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp6_ = self->priv->ui;
#line 51 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_signal_connect_object (_tmp6_, "stop-scan", (GCallback) _simple_scan_cancel_cb_user_interface_stop_scan, self, 0);
#line 52 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp7_ = self->priv->ui;
#line 52 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_signal_connect_object (_tmp7_, "email", (GCallback) _simple_scan_email_cb_user_interface_email, self, 0);
#line 54 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp8_ = scanner_get_instance ();
#line 54 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_scanner_unref0 (self->priv->scanner);
#line 54 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	self->priv->scanner = _tmp8_;
#line 55 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp9_ = self->priv->scanner;
#line 55 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_signal_connect_object (_tmp9_, "update-devices", (GCallback) _simple_scan_update_scan_devices_cb_scanner_update_devices, self, 0);
#line 56 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp10_ = self->priv->scanner;
#line 56 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_signal_connect_object (_tmp10_, "request-authorization", (GCallback) _simple_scan_authorize_cb_scanner_request_authorization, self, 0);
#line 57 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp11_ = self->priv->scanner;
#line 57 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_signal_connect_object (_tmp11_, "expect-page", (GCallback) _simple_scan_scanner_new_page_cb_scanner_expect_page, self, 0);
#line 58 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp12_ = self->priv->scanner;
#line 58 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_signal_connect_object (_tmp12_, "got-page-info", (GCallback) _simple_scan_scanner_page_info_cb_scanner_got_page_info, self, 0);
#line 59 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp13_ = self->priv->scanner;
#line 59 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_signal_connect_object (_tmp13_, "got-line", (GCallback) _simple_scan_scanner_line_cb_scanner_got_line, self, 0);
#line 60 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp14_ = self->priv->scanner;
#line 60 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_signal_connect_object (_tmp14_, "page-done", (GCallback) _simple_scan_scanner_page_done_cb_scanner_page_done, self, 0);
#line 61 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp15_ = self->priv->scanner;
#line 61 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_signal_connect_object (_tmp15_, "document-done", (GCallback) _simple_scan_scanner_document_done_cb_scanner_document_done, self, 0);
#line 62 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp16_ = self->priv->scanner;
#line 62 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_signal_connect_object (_tmp16_, "scan-failed", (GCallback) _simple_scan_scanner_failed_cb_scanner_scan_failed, self, 0);
#line 63 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp17_ = self->priv->scanner;
#line 63 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_signal_connect_object (_tmp17_, "scanning-changed", (GCallback) _simple_scan_scanner_scanning_changed_cb_scanner_scanning_changed, self, 0);
#line 65 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp18_ = g_strdup ("usb");
#line 65 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp19_ = g_new0 (gchar*, 2 + 1);
#line 65 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp19_[0] = _tmp18_;
#line 65 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp19_[1] = NULL;
#line 65 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	subsystems = _tmp19_;
#line 65 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	subsystems_length1 = 2;
#line 65 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_subsystems_size_ = subsystems_length1;
#line 66 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp20_ = subsystems;
#line 66 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp20__length1 = subsystems_length1;
#line 66 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp21_ = g_udev_client_new (_tmp20_);
#line 66 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_object_unref0 (self->priv->udev_client);
#line 66 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	self->priv->udev_client = _tmp21_;
#line 67 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp22_ = self->priv->udev_client;
#line 67 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_signal_connect_object (_tmp22_, "uevent", (GCallback) _simple_scan_on_uevent_g_udev_client_uevent, self, 0);
#line 69 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp23_ = self->priv->default_device;
#line 69 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	if (_tmp23_ != NULL) {
#line 691 "simple-scan.c"
		GList* device_list = NULL;
		ScanDevice* _tmp24_ = NULL;
		ScanDevice* _tmp25_ = NULL;
		UserInterface* _tmp26_ = NULL;
		GList* _tmp27_ = NULL;
		UserInterface* _tmp28_ = NULL;
		ScanDevice* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
#line 71 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		device_list = NULL;
#line 73 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp24_ = self->priv->default_device;
#line 73 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp25_ = _scan_device_ref0 (_tmp24_);
#line 73 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		device_list = g_list_append (device_list, _tmp25_);
#line 74 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp26_ = self->priv->ui;
#line 74 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp27_ = device_list;
#line 74 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		user_interface_set_scan_devices (_tmp26_, _tmp27_);
#line 75 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp28_ = self->priv->ui;
#line 75 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp29_ = self->priv->default_device;
#line 75 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp30_ = _tmp29_->name;
#line 75 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		user_interface_set_selected_device (_tmp28_, _tmp30_);
#line 69 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		__g_list_free__scan_device_unref0_0 (device_list);
#line 724 "simple-scan.c"
	}
#line 44 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	subsystems = (_vala_array_free (subsystems, subsystems_length1, (GDestroyNotify) g_free), NULL);
#line 728 "simple-scan.c"
}


static void simple_scan_real_activate (GApplication* base) {
	SimpleScan * self;
	UserInterface* _tmp0_ = NULL;
	Scanner* _tmp1_ = NULL;
#line 79 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	self = (SimpleScan*) base;
#line 81 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	G_APPLICATION_CLASS (simple_scan_parent_class)->activate ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 82 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp0_ = self->priv->ui;
#line 82 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	user_interface_start (_tmp0_);
#line 83 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp1_ = self->priv->scanner;
#line 83 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	scanner_start (_tmp1_);
#line 748 "simple-scan.c"
}


static void simple_scan_real_shutdown (GApplication* base) {
	SimpleScan * self;
	Scanner* _tmp0_ = NULL;
#line 86 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	self = (SimpleScan*) base;
#line 88 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	G_APPLICATION_CLASS (simple_scan_parent_class)->shutdown ((GApplication*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_get_type (), GtkApplication));
#line 89 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_book_unref0 (self->priv->book);
#line 89 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	self->priv->book = NULL;
#line 90 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_object_unref0 (self->priv->ui);
#line 90 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	self->priv->ui = NULL;
#line 91 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_object_unref0 (self->priv->udev_client);
#line 91 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	self->priv->udev_client = NULL;
#line 92 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp0_ = self->priv->scanner;
#line 92 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	scanner_free (_tmp0_);
#line 775 "simple-scan.c"
}


static void simple_scan_update_scan_devices_cb (SimpleScan* self, Scanner* scanner, GList* devices) {
	GList* devices_copy = NULL;
	GList* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	ScanDevice* _tmp2_ = NULL;
	GList* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	UserInterface* _tmp12_ = NULL;
	GList* _tmp13_ = NULL;
#line 95 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 95 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 97 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp0_ = devices;
#line 97 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp1_ = g_list_copy (_tmp0_);
#line 97 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	devices_copy = _tmp1_;
#line 100 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp2_ = self->priv->default_device;
#line 100 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	if (_tmp2_ != NULL) {
#line 802 "simple-scan.c"
		gboolean default_in_list = FALSE;
		GList* _tmp3_ = NULL;
		gboolean _tmp8_ = FALSE;
#line 102 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		default_in_list = FALSE;
#line 103 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp3_ = devices_copy;
#line 810 "simple-scan.c"
		{
			GList* device_collection = NULL;
			GList* device_it = NULL;
#line 103 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			device_collection = _tmp3_;
#line 103 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
#line 818 "simple-scan.c"
				ScanDevice* device = NULL;
#line 103 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				device = (ScanDevice*) device_it->data;
#line 822 "simple-scan.c"
				{
					ScanDevice* _tmp4_ = NULL;
					const gchar* _tmp5_ = NULL;
					ScanDevice* _tmp6_ = NULL;
					const gchar* _tmp7_ = NULL;
#line 105 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp4_ = device;
#line 105 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp5_ = _tmp4_->name;
#line 105 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp6_ = self->priv->default_device;
#line 105 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp7_ = _tmp6_->name;
#line 105 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					if (g_strcmp0 (_tmp5_, _tmp7_) == 0) {
#line 107 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						default_in_list = TRUE;
#line 108 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						break;
#line 842 "simple-scan.c"
					}
				}
			}
		}
#line 112 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp8_ = default_in_list;
#line 112 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		if (!_tmp8_) {
#line 851 "simple-scan.c"
			ScanDevice* _tmp9_ = NULL;
#line 113 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp9_ = self->priv->default_device;
#line 113 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			devices_copy = g_list_prepend (devices_copy, _tmp9_);
#line 857 "simple-scan.c"
		}
	}
#line 116 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp10_ = devices_copy;
#line 116 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp11_ = g_list_length (_tmp10_);
#line 116 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	self->priv->have_devices = _tmp11_ > ((guint) 0);
#line 117 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp12_ = self->priv->ui;
#line 117 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp13_ = devices_copy;
#line 117 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	user_interface_set_scan_devices (_tmp12_, _tmp13_);
#line 95 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_list_free0 (devices_copy);
#line 874 "simple-scan.c"
}


static void simple_scan_authorize_cb (SimpleScan* self, Scanner* scanner, const gchar* resource) {
	gchar* username = NULL;
	gchar* password = NULL;
	UserInterface* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	Scanner* _tmp4_ = NULL;
#line 120 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 120 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 120 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (resource != NULL);
#line 123 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp0_ = self->priv->ui;
#line 123 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp1_ = resource;
#line 123 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	user_interface_authorize (_tmp0_, _tmp1_, &_tmp2_, &_tmp3_);
#line 123 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_free0 (username);
#line 123 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	username = _tmp2_;
#line 123 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_free0 (password);
#line 123 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	password = _tmp3_;
#line 124 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp4_ = scanner;
#line 124 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	scanner_authorize (_tmp4_, username, password);
#line 120 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_free0 (password);
#line 120 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_free0 (username);
#line 914 "simple-scan.c"
}


static Page* simple_scan_append_page (SimpleScan* self) {
	Page* result = NULL;
	Page* page = NULL;
	Book* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	Page* _tmp3_ = NULL;
	ScanDirection scan_direction = 0;
	gboolean do_crop = FALSE;
	gchar* named_crop = NULL;
	gint width = 0;
	gint height = 0;
	gint dpi = 0;
	gint cx = 0;
	gint cy = 0;
	gint cw = 0;
	gint ch = 0;
	Page* _tmp10_ = NULL;
	gint _tmp43_ = 0;
	gint _tmp44_ = 0;
	gint _tmp45_ = 0;
	ScanDirection _tmp46_ = 0;
	Page* _tmp47_ = NULL;
	Book* _tmp48_ = NULL;
	Page* _tmp49_ = NULL;
	gboolean _tmp50_ = FALSE;
	UserInterface* _tmp60_ = NULL;
	Page* _tmp61_ = NULL;
	Page* _tmp62_ = NULL;
#line 127 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 130 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp0_ = self->priv->book;
#line 130 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp1_ = book_get_page (_tmp0_, -1);
#line 130 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	page = _tmp1_;
#line 131 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp3_ = page;
#line 131 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	if (_tmp3_ != NULL) {
#line 959 "simple-scan.c"
		Page* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
#line 131 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp4_ = page;
#line 131 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp5_ = page_get_has_data (_tmp4_);
#line 131 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp6_ = _tmp5_;
#line 131 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp2_ = !_tmp6_;
#line 971 "simple-scan.c"
	} else {
#line 131 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp2_ = FALSE;
#line 975 "simple-scan.c"
	}
#line 131 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	if (_tmp2_) {
#line 979 "simple-scan.c"
		UserInterface* _tmp7_ = NULL;
		Page* _tmp8_ = NULL;
		Page* _tmp9_ = NULL;
#line 133 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp7_ = self->priv->ui;
#line 133 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp8_ = page;
#line 133 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		user_interface_set_selected_page (_tmp7_, _tmp8_);
#line 134 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp9_ = page;
#line 134 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		page_start (_tmp9_);
#line 135 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		result = page;
#line 135 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		return result;
#line 997 "simple-scan.c"
	}
#line 139 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	scan_direction = SCAN_DIRECTION_TOP_TO_BOTTOM;
#line 140 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	do_crop = FALSE;
#line 141 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	named_crop = NULL;
#line 142 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	width = 100;
#line 142 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	height = 100;
#line 142 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	dpi = 100;
#line 142 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	cx = 0;
#line 142 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	cy = 0;
#line 142 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	cw = 0;
#line 142 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	ch = 0;
#line 143 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp10_ = page;
#line 143 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	if (_tmp10_ != NULL) {
#line 1023 "simple-scan.c"
		Page* _tmp11_ = NULL;
		ScanDirection _tmp12_ = 0;
		ScanDirection _tmp13_ = 0;
		Page* _tmp14_ = NULL;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		Page* _tmp17_ = NULL;
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		Page* _tmp20_ = NULL;
		gint _tmp21_ = 0;
		gint _tmp22_ = 0;
		Page* _tmp23_ = NULL;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		gboolean _tmp26_ = FALSE;
#line 145 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp11_ = page;
#line 145 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp12_ = page_get_scan_direction (_tmp11_);
#line 145 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp13_ = _tmp12_;
#line 145 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		scan_direction = _tmp13_;
#line 146 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp14_ = page;
#line 146 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp15_ = page_get_width (_tmp14_);
#line 146 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp16_ = _tmp15_;
#line 146 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		width = _tmp16_;
#line 147 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp17_ = page;
#line 147 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp18_ = page_get_height (_tmp17_);
#line 147 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp19_ = _tmp18_;
#line 147 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		height = _tmp19_;
#line 148 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp20_ = page;
#line 148 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp21_ = page_get_dpi (_tmp20_);
#line 148 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp22_ = _tmp21_;
#line 148 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		dpi = _tmp22_;
#line 150 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp23_ = page;
#line 150 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp24_ = page_get_has_crop (_tmp23_);
#line 150 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp25_ = _tmp24_;
#line 150 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		do_crop = _tmp25_;
#line 151 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp26_ = do_crop;
#line 151 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		if (_tmp26_) {
#line 1084 "simple-scan.c"
			Page* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			gchar* _tmp30_ = NULL;
			Page* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			gint _tmp33_ = 0;
			Page* _tmp34_ = NULL;
			gint _tmp35_ = 0;
			gint _tmp36_ = 0;
			Page* _tmp37_ = NULL;
			gint _tmp38_ = 0;
			gint _tmp39_ = 0;
			Page* _tmp40_ = NULL;
			gint _tmp41_ = 0;
			gint _tmp42_ = 0;
#line 153 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp27_ = page;
#line 153 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp28_ = page_get_crop_name (_tmp27_);
#line 153 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp29_ = _tmp28_;
#line 153 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp30_ = g_strdup (_tmp29_);
#line 153 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_g_free0 (named_crop);
#line 153 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			named_crop = _tmp30_;
#line 154 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp31_ = page;
#line 154 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp32_ = page_get_crop_x (_tmp31_);
#line 154 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp33_ = _tmp32_;
#line 154 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			cx = _tmp33_;
#line 155 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp34_ = page;
#line 155 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp35_ = page_get_crop_y (_tmp34_);
#line 155 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp36_ = _tmp35_;
#line 155 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			cy = _tmp36_;
#line 156 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp37_ = page;
#line 156 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp38_ = page_get_crop_width (_tmp37_);
#line 156 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp39_ = _tmp38_;
#line 156 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			cw = _tmp39_;
#line 157 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp40_ = page;
#line 157 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp41_ = page_get_crop_height (_tmp40_);
#line 157 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp42_ = _tmp41_;
#line 157 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			ch = _tmp42_;
#line 1145 "simple-scan.c"
		}
	}
#line 161 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp43_ = width;
#line 161 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp44_ = height;
#line 161 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp45_ = dpi;
#line 161 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp46_ = scan_direction;
#line 161 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp47_ = page_new (_tmp43_, _tmp44_, _tmp45_, _tmp46_);
#line 161 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_page_unref0 (page);
#line 161 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	page = _tmp47_;
#line 162 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp48_ = self->priv->book;
#line 162 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp49_ = page;
#line 162 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	book_append_page (_tmp48_, _tmp49_);
#line 163 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp50_ = do_crop;
#line 163 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	if (_tmp50_) {
#line 1172 "simple-scan.c"
		const gchar* _tmp51_ = NULL;
		Page* _tmp57_ = NULL;
		gint _tmp58_ = 0;
		gint _tmp59_ = 0;
#line 165 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp51_ = named_crop;
#line 165 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		if (_tmp51_ != NULL) {
#line 1181 "simple-scan.c"
			Page* _tmp52_ = NULL;
			const gchar* _tmp53_ = NULL;
#line 167 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp52_ = page;
#line 167 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp53_ = named_crop;
#line 167 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			page_set_named_crop (_tmp52_, _tmp53_);
#line 1190 "simple-scan.c"
		} else {
			Page* _tmp54_ = NULL;
			gint _tmp55_ = 0;
			gint _tmp56_ = 0;
#line 170 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp54_ = page;
#line 170 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp55_ = cw;
#line 170 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp56_ = ch;
#line 170 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			page_set_custom_crop (_tmp54_, _tmp55_, _tmp56_);
#line 1203 "simple-scan.c"
		}
#line 171 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp57_ = page;
#line 171 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp58_ = cx;
#line 171 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp59_ = cy;
#line 171 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		page_move_crop (_tmp57_, _tmp58_, _tmp59_);
#line 1213 "simple-scan.c"
	}
#line 173 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp60_ = self->priv->ui;
#line 173 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp61_ = page;
#line 173 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	user_interface_set_selected_page (_tmp60_, _tmp61_);
#line 174 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp62_ = page;
#line 174 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	page_start (_tmp62_);
#line 176 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	result = page;
#line 176 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_free0 (named_crop);
#line 176 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	return result;
#line 1231 "simple-scan.c"
}


static void simple_scan_scanner_new_page_cb (SimpleScan* self, Scanner* scanner) {
	Page* _tmp0_ = NULL;
	Page* _tmp1_ = NULL;
#line 179 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 179 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 181 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp0_ = simple_scan_append_page (self);
#line 181 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp1_ = _tmp0_;
#line 181 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_page_unref0 (_tmp1_);
#line 1248 "simple-scan.c"
}


static gchar* simple_scan_get_profile_for_device (SimpleScan* self, const gchar* device_name) {
	gchar* result = NULL;
	gchar* device_id = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	CdClient* client = NULL;
	CdClient* _tmp3_ = NULL;
	CdDevice* device = NULL;
	CdProfile* profile = NULL;
	CdDevice* _tmp19_ = NULL;
	CdProfile* _tmp20_ = NULL;
	CdProfile* _tmp21_ = NULL;
	CdProfile* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	CdProfile* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	const gchar* _tmp34_ = NULL;
	CdProfile* _tmp35_ = NULL;
	const gchar* _tmp36_ = NULL;
	const gchar* _tmp37_ = NULL;
	gchar* _tmp38_ = NULL;
	GError * _inner_error_ = NULL;
#line 184 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 184 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_val_if_fail (device_name != NULL, NULL);
#line 187 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp0_ = device_name;
#line 187 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp1_ = g_strdup_printf ("sane:%s", _tmp0_);
#line 187 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	device_id = _tmp1_;
#line 188 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp2_ = device_name;
#line 188 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_debug ("simple-scan.vala:188: Getting color profile for device %s", _tmp2_);
#line 190 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp3_ = cd_client_new ();
#line 190 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	client = _tmp3_;
#line 1295 "simple-scan.c"
	{
		CdClient* _tmp4_ = NULL;
#line 193 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp4_ = client;
#line 193 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		cd_client_connect_sync (_tmp4_, NULL, &_inner_error_);
#line 193 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1304 "simple-scan.c"
			goto __catch4_g_error;
		}
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
#line 191 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		e = _inner_error_;
#line 191 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 197 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp5_ = e;
#line 197 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp6_ = _tmp5_->message;
#line 197 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_debug ("simple-scan.vala:197: Failed to connect to colord: %s", _tmp6_);
#line 198 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		result = NULL;
#line 198 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_error_free0 (e);
#line 198 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 198 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_free0 (device_id);
#line 198 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		return result;
#line 1334 "simple-scan.c"
	}
	__finally4:
#line 191 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 191 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 191 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_free0 (device_id);
#line 191 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 191 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 191 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		return NULL;
#line 1349 "simple-scan.c"
	}
	{
		CdDevice* _tmp7_ = NULL;
		CdClient* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		CdDevice* _tmp10_ = NULL;
		CdDevice* _tmp11_ = NULL;
#line 204 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp8_ = client;
#line 204 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp9_ = device_id;
#line 204 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp10_ = cd_client_find_device_by_property_sync (_tmp8_, CD_DEVICE_PROPERTY_SERIAL, _tmp9_, NULL, &_inner_error_);
#line 204 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp7_ = _tmp10_;
#line 204 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1367 "simple-scan.c"
			goto __catch5_g_error;
		}
#line 204 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp11_ = _tmp7_;
#line 204 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp7_ = NULL;
#line 204 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 204 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		device = _tmp11_;
#line 202 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_object_unref0 (_tmp7_);
#line 1380 "simple-scan.c"
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp12_ = NULL;
		GError* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
#line 202 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		e = _inner_error_;
#line 202 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 208 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp12_ = device_name;
#line 208 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp13_ = e;
#line 208 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp14_ = _tmp13_->message;
#line 208 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_debug ("simple-scan.vala:208: Unable to find colord device %s: %s", _tmp12_, _tmp14_);
#line 209 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		result = NULL;
#line 209 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_error_free0 (e);
#line 209 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 209 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 209 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_free0 (device_id);
#line 209 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		return result;
#line 1413 "simple-scan.c"
	}
	__finally5:
#line 202 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 202 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 202 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 202 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_free0 (device_id);
#line 202 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 202 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 202 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		return NULL;
#line 1430 "simple-scan.c"
	}
	{
		CdDevice* _tmp15_ = NULL;
#line 214 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp15_ = device;
#line 214 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		cd_device_connect_sync (_tmp15_, NULL, &_inner_error_);
#line 214 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1440 "simple-scan.c"
			goto __catch6_g_error;
		}
	}
	goto __finally6;
	__catch6_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp16_ = NULL;
		GError* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
#line 212 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		e = _inner_error_;
#line 212 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 218 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp16_ = device_name;
#line 218 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp17_ = e;
#line 218 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp18_ = _tmp17_->message;
#line 218 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_debug ("simple-scan.vala:218: Failed to get properties from the device %s: %s", _tmp16_, _tmp18_);
#line 219 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		result = NULL;
#line 219 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_error_free0 (e);
#line 219 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 219 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 219 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_free0 (device_id);
#line 219 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		return result;
#line 1475 "simple-scan.c"
	}
	__finally6:
#line 212 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 212 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 212 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 212 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_free0 (device_id);
#line 212 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 212 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 212 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		return NULL;
#line 1492 "simple-scan.c"
	}
#line 222 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp19_ = device;
#line 222 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp20_ = cd_device_get_default_profile (_tmp19_);
#line 222 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	profile = _tmp20_;
#line 223 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp21_ = profile;
#line 223 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	if (_tmp21_ == NULL) {
#line 1504 "simple-scan.c"
		const gchar* _tmp22_ = NULL;
#line 225 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp22_ = device_name;
#line 225 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_debug ("simple-scan.vala:225: No default color profile for device: %s", _tmp22_);
#line 226 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		result = NULL;
#line 226 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_object_unref0 (profile);
#line 226 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 226 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 226 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_free0 (device_id);
#line 226 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		return result;
#line 1522 "simple-scan.c"
	}
	{
		CdProfile* _tmp23_ = NULL;
#line 231 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp23_ = profile;
#line 231 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		cd_profile_connect_sync (_tmp23_, NULL, &_inner_error_);
#line 231 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1532 "simple-scan.c"
			goto __catch7_g_error;
		}
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp24_ = NULL;
		GError* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
#line 229 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		e = _inner_error_;
#line 229 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 235 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp24_ = device_name;
#line 235 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp25_ = e;
#line 235 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp26_ = _tmp25_->message;
#line 235 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_debug ("simple-scan.vala:235: Failed to get properties from the profile %s: %s", _tmp24_, _tmp26_);
#line 236 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		result = NULL;
#line 236 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_error_free0 (e);
#line 236 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_object_unref0 (profile);
#line 236 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 236 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 236 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_free0 (device_id);
#line 236 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		return result;
#line 1569 "simple-scan.c"
	}
	__finally7:
#line 229 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 229 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_object_unref0 (profile);
#line 229 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 229 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 229 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_free0 (device_id);
#line 229 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 229 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 229 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		return NULL;
#line 1588 "simple-scan.c"
	}
#line 239 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp27_ = profile;
#line 239 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp28_ = cd_profile_get_filename (_tmp27_);
#line 239 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp29_ = _tmp28_;
#line 239 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	if (_tmp29_ == NULL) {
#line 1598 "simple-scan.c"
		const gchar* _tmp30_ = NULL;
#line 241 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp30_ = device_name;
#line 241 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_debug ("simple-scan.vala:241: No icc color profile for the device %s", _tmp30_);
#line 242 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		result = NULL;
#line 242 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_object_unref0 (profile);
#line 242 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_object_unref0 (device);
#line 242 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_object_unref0 (client);
#line 242 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_free0 (device_id);
#line 242 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		return result;
#line 1616 "simple-scan.c"
	}
#line 245 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp31_ = profile;
#line 245 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp32_ = cd_profile_get_filename (_tmp31_);
#line 245 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp33_ = _tmp32_;
#line 245 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp34_ = device_name;
#line 245 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_debug ("simple-scan.vala:245: Using color profile %s for device %s", _tmp33_, _tmp34_);
#line 246 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp35_ = profile;
#line 246 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp36_ = cd_profile_get_filename (_tmp35_);
#line 246 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp37_ = _tmp36_;
#line 246 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp38_ = g_strdup (_tmp37_);
#line 246 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	result = _tmp38_;
#line 246 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_object_unref0 (profile);
#line 246 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_object_unref0 (device);
#line 246 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_object_unref0 (client);
#line 246 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_free0 (device_id);
#line 246 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	return result;
#line 1648 "simple-scan.c"
}


static void simple_scan_scanner_page_info_cb (SimpleScan* self, Scanner* scanner, ScanPageInfo* info) {
	ScanPageInfo* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	ScanPageInfo* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	ScanPageInfo* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	Page* page = NULL;
	Page* _tmp6_ = NULL;
	ScanPageInfo* _tmp7_ = NULL;
	ScanPageInfo* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
#line 252 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 252 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 252 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (info != NULL);
#line 254 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp0_ = info;
#line 254 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp1_ = _tmp0_->width;
#line 254 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp2_ = info;
#line 254 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp3_ = _tmp2_->height;
#line 254 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp4_ = info;
#line 254 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp5_ = _tmp4_->depth;
#line 254 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_debug ("simple-scan.vala:254: Page is %d pixels wide, %d pixels high, %d bits " \
"per pixel", _tmp1_, _tmp3_, _tmp5_);
#line 258 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp6_ = simple_scan_append_page (self);
#line 258 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	page = _tmp6_;
#line 259 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp7_ = info;
#line 259 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	page_set_page_info (page, _tmp7_);
#line 264 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp8_ = info;
#line 264 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp9_ = _tmp8_->device;
#line 264 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp10_ = simple_scan_get_profile_for_device (self, _tmp9_);
#line 264 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp11_ = _tmp10_;
#line 264 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	page_set_color_profile (page, _tmp11_);
#line 264 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_free0 (_tmp11_);
#line 252 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_page_unref0 (page);
#line 1708 "simple-scan.c"
}


static void simple_scan_scanner_line_cb (SimpleScan* self, Scanner* scanner, ScanLine* line) {
	Page* page = NULL;
	Book* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	Page* _tmp4_ = NULL;
	ScanLine* _tmp5_ = NULL;
#line 267 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 267 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 267 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (line != NULL);
#line 269 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp0_ = self->priv->book;
#line 269 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp1_ = self->priv->book;
#line 269 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp2_ = book_get_n_pages (_tmp1_);
#line 269 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp3_ = _tmp2_;
#line 269 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp4_ = book_get_page (_tmp0_, ((gint) _tmp3_) - 1);
#line 269 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	page = _tmp4_;
#line 270 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp5_ = line;
#line 270 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	page_parse_scan_line (page, _tmp5_);
#line 267 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_page_unref0 (page);
#line 1744 "simple-scan.c"
}


static void simple_scan_scanner_page_done_cb (SimpleScan* self, Scanner* scanner) {
	Page* page = NULL;
	Book* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	Page* _tmp4_ = NULL;
#line 273 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 273 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 275 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp0_ = self->priv->book;
#line 275 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp1_ = self->priv->book;
#line 275 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp2_ = book_get_n_pages (_tmp1_);
#line 275 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp3_ = _tmp2_;
#line 275 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp4_ = book_get_page (_tmp0_, ((gint) _tmp3_) - 1);
#line 275 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	page = _tmp4_;
#line 276 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	page_finish (page);
#line 273 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_page_unref0 (page);
#line 1775 "simple-scan.c"
}


static void simple_scan_remove_empty_page (SimpleScan* self) {
	Page* page = NULL;
	Book* _tmp0_ = NULL;
	Book* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	Page* _tmp4_ = NULL;
	Page* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
#line 279 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 281 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp0_ = self->priv->book;
#line 281 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp1_ = self->priv->book;
#line 281 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp2_ = book_get_n_pages (_tmp1_);
#line 281 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp3_ = _tmp2_;
#line 281 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp4_ = book_get_page (_tmp0_, ((gint) _tmp3_) - 1);
#line 281 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	page = _tmp4_;
#line 282 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp5_ = page;
#line 282 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp6_ = page_get_has_data (_tmp5_);
#line 282 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp7_ = _tmp6_;
#line 282 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	if (!_tmp7_) {
#line 1811 "simple-scan.c"
		Book* _tmp8_ = NULL;
		Page* _tmp9_ = NULL;
#line 283 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp8_ = self->priv->book;
#line 283 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp9_ = page;
#line 283 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		book_delete_page (_tmp8_, _tmp9_);
#line 1820 "simple-scan.c"
	}
#line 279 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_page_unref0 (page);
#line 1824 "simple-scan.c"
}


static void simple_scan_scanner_document_done_cb (SimpleScan* self, Scanner* scanner) {
#line 286 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 286 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 288 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	simple_scan_remove_empty_page (self);
#line 1835 "simple-scan.c"
}


static void simple_scan_scanner_failed_cb (SimpleScan* self, Scanner* scanner, gint error_code, const gchar* error_string) {
	gint _tmp0_ = 0;
#line 291 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 291 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 291 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (error_string != NULL);
#line 293 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	simple_scan_remove_empty_page (self);
#line 294 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp0_ = error_code;
#line 294 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	if (_tmp0_ != ((gint) SANE_STATUS_CANCELLED)) {
#line 1853 "simple-scan.c"
		UserInterface* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gboolean _tmp4_ = FALSE;
#line 296 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp1_ = self->priv->ui;
#line 296 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp2_ = _ ("Failed to scan");
#line 296 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp3_ = error_string;
#line 296 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp4_ = self->priv->have_devices;
#line 296 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		user_interface_show_error (_tmp1_, _tmp2_, _tmp3_, _tmp4_);
#line 1868 "simple-scan.c"
	}
}


static void simple_scan_scanner_scanning_changed_cb (SimpleScan* self, Scanner* scanner) {
	UserInterface* _tmp0_ = NULL;
	Scanner* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
#line 303 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 303 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (scanner != NULL);
#line 305 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp0_ = self->priv->ui;
#line 305 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp1_ = scanner;
#line 305 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp2_ = scanner_is_scanning (_tmp1_);
#line 305 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	user_interface_set_scanning (_tmp0_, _tmp2_);
#line 1889 "simple-scan.c"
}


static void simple_scan_scan_cb (SimpleScan* self, UserInterface* ui, const gchar* device, ScanOptions* options) {
	ScanOptions* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	const gchar* _tmp2_ = NULL;
	Scanner* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gchar* filename_prefix = NULL;
	const gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	gchar* extension = NULL;
	ScanOptions* _tmp9_ = NULL;
	ScanMode _tmp10_ = 0;
	gchar* filename = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	UserInterface* _tmp16_ = NULL;
	Scanner* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	ScanOptions* _tmp19_ = NULL;
#line 308 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 308 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (ui != NULL);
#line 308 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (options != NULL);
#line 310 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp0_ = options;
#line 310 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp1_ = _tmp0_->dpi;
#line 310 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp2_ = device;
#line 310 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_debug ("simple-scan.vala:310: Requesting scan at %d dpi from device '%s'", _tmp1_, _tmp2_);
#line 312 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp3_ = self->priv->scanner;
#line 312 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp4_ = scanner_is_scanning (_tmp3_);
#line 312 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	if (!_tmp4_) {
#line 1933 "simple-scan.c"
		Page* _tmp5_ = NULL;
		Page* _tmp6_ = NULL;
#line 313 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp5_ = simple_scan_append_page (self);
#line 313 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp6_ = _tmp5_;
#line 313 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_page_unref0 (_tmp6_);
#line 1942 "simple-scan.c"
	}
#line 316 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp7_ = _ ("Scanned Document");
#line 316 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp8_ = g_strdup (_tmp7_);
#line 316 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	filename_prefix = _tmp8_;
#line 318 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp9_ = options;
#line 318 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp10_ = _tmp9_->scan_mode;
#line 318 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	if (_tmp10_ == SCAN_MODE_COLOR) {
#line 1956 "simple-scan.c"
		gchar* _tmp11_ = NULL;
#line 319 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp11_ = g_strdup ("jpg");
#line 319 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_free0 (extension);
#line 319 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		extension = _tmp11_;
#line 1964 "simple-scan.c"
	} else {
		gchar* _tmp12_ = NULL;
#line 321 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp12_ = g_strdup ("pdf");
#line 321 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_free0 (extension);
#line 321 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		extension = _tmp12_;
#line 1973 "simple-scan.c"
	}
#line 322 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp13_ = filename_prefix;
#line 322 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp14_ = extension;
#line 322 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp15_ = g_strdup_printf ("%s.%s", _tmp13_, _tmp14_);
#line 322 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	filename = _tmp15_;
#line 323 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp16_ = ui;
#line 323 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	user_interface_set_default_file_name (_tmp16_, filename);
#line 324 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp17_ = self->priv->scanner;
#line 324 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp18_ = device;
#line 324 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp19_ = options;
#line 324 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	scanner_scan (_tmp17_, _tmp18_, _tmp19_);
#line 308 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_free0 (filename);
#line 308 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_free0 (extension);
#line 308 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_free0 (filename_prefix);
#line 2001 "simple-scan.c"
}


static void simple_scan_cancel_cb (SimpleScan* self, UserInterface* ui) {
	Scanner* _tmp0_ = NULL;
#line 327 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 327 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (ui != NULL);
#line 329 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp0_ = self->priv->scanner;
#line 329 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	scanner_cancel (_tmp0_);
#line 2015 "simple-scan.c"
}


static gchar* simple_scan_get_temporary_filename (SimpleScan* self, const gchar* prefix, const gchar* extension) {
	gchar* result = NULL;
	gchar* filename = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* path = NULL;
	GError * _inner_error_ = NULL;
#line 332 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 332 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_val_if_fail (prefix != NULL, NULL);
#line 332 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_val_if_fail (extension != NULL, NULL);
#line 337 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp0_ = prefix;
#line 337 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp1_ = extension;
#line 337 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp2_ = g_strdup_printf ("%sXXXXXX.%s", _tmp0_, _tmp1_);
#line 337 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	filename = _tmp2_;
#line 2041 "simple-scan.c"
	{
		gint fd = 0;
		const gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
#line 341 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp3_ = filename;
#line 341 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp5_ = g_file_open_tmp (_tmp3_, &_tmp4_, &_inner_error_);
#line 341 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_free0 (path);
#line 341 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		path = _tmp4_;
#line 341 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		fd = _tmp5_;
#line 341 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2060 "simple-scan.c"
			goto __catch8_g_error;
		}
#line 342 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp6_ = fd;
#line 342 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		close (_tmp6_);
#line 2067 "simple-scan.c"
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
#line 339 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		e = _inner_error_;
#line 339 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 346 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp7_ = e;
#line 346 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp8_ = _tmp7_->message;
#line 346 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_warning ("simple-scan.vala:346: Error saving email attachment: %s", _tmp8_);
#line 347 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		result = NULL;
#line 347 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_error_free0 (e);
#line 347 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_free0 (path);
#line 347 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_free0 (filename);
#line 347 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		return result;
#line 2095 "simple-scan.c"
	}
	__finally8:
#line 339 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 339 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_free0 (path);
#line 339 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_free0 (filename);
#line 339 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 339 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 339 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		return NULL;
#line 2110 "simple-scan.c"
	}
#line 350 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	result = path;
#line 350 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_free0 (filename);
#line 350 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	return result;
#line 2118 "simple-scan.c"
}


static void simple_scan_email_cb (SimpleScan* self, UserInterface* ui, const gchar* profile, gint quality) {
	gboolean saved = FALSE;
	gchar* command_line = NULL;
	gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp42_ = NULL;
	GError * _inner_error_ = NULL;
#line 353 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 353 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (ui != NULL);
#line 353 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (profile != NULL);
#line 355 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	saved = FALSE;
#line 356 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp0_ = g_strdup ("xdg-email");
#line 356 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	command_line = _tmp0_;
#line 359 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp1_ = profile;
#line 359 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	if (g_strcmp0 (_tmp1_, "text") == 0) {
#line 2145 "simple-scan.c"
		gchar* path = NULL;
		gchar* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
#line 362 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp2_ = simple_scan_get_temporary_filename (self, "scan", "pdf");
#line 362 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		path = _tmp2_;
#line 363 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp3_ = path;
#line 363 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		if (_tmp3_ != NULL) {
#line 2157 "simple-scan.c"
			GFile* file = NULL;
			const gchar* _tmp4_ = NULL;
			GFile* _tmp5_ = NULL;
			UserInterface* _tmp6_ = NULL;
			const gchar* _tmp13_ = NULL;
			const gchar* _tmp14_ = NULL;
			gchar* _tmp15_ = NULL;
			gchar* _tmp16_ = NULL;
			gchar* _tmp17_ = NULL;
#line 365 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp4_ = path;
#line 365 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp5_ = g_file_new_for_path (_tmp4_);
#line 365 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			file = _tmp5_;
#line 366 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp6_ = ui;
#line 366 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			user_interface_show_progress_dialog (_tmp6_);
#line 2177 "simple-scan.c"
			{
				Book* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				GFile* _tmp9_ = NULL;
#line 369 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_tmp7_ = self->priv->book;
#line 369 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_tmp8_ = quality;
#line 369 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_tmp9_ = file;
#line 369 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				book_save (_tmp7_, "pdf", _tmp8_, _tmp9_, &_inner_error_);
#line 369 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2192 "simple-scan.c"
					goto __catch9_g_error;
				}
			}
			goto __finally9;
			__catch9_g_error:
			{
				GError* e = NULL;
				UserInterface* _tmp10_ = NULL;
				GError* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
#line 367 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				e = _inner_error_;
#line 367 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_inner_error_ = NULL;
#line 373 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_tmp10_ = ui;
#line 373 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				user_interface_hide_progress_dialog (_tmp10_);
#line 374 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_tmp11_ = e;
#line 374 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_tmp12_ = _tmp11_->message;
#line 374 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				g_warning ("simple-scan.vala:374: Unable to save email file: %s", _tmp12_);
#line 375 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_g_error_free0 (e);
#line 375 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_g_object_unref0 (file);
#line 375 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_g_free0 (path);
#line 375 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_g_free0 (command_line);
#line 375 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				return;
#line 2227 "simple-scan.c"
			}
			__finally9:
#line 367 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 367 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_g_object_unref0 (file);
#line 367 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_g_free0 (path);
#line 367 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_g_free0 (command_line);
#line 367 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 367 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				g_clear_error (&_inner_error_);
#line 367 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				return;
#line 2244 "simple-scan.c"
			}
#line 377 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp13_ = command_line;
#line 377 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp14_ = path;
#line 377 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp15_ = g_strdup_printf (" --attach %s", _tmp14_);
#line 377 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp16_ = _tmp15_;
#line 377 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp17_ = g_strconcat (_tmp13_, _tmp16_, NULL);
#line 377 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_g_free0 (command_line);
#line 377 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			command_line = _tmp17_;
#line 377 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_g_free0 (_tmp16_);
#line 363 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_g_object_unref0 (file);
#line 2264 "simple-scan.c"
		}
#line 359 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_free0 (path);
#line 2268 "simple-scan.c"
	} else {
		{
			gint i = 0;
#line 382 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			i = 0;
#line 2274 "simple-scan.c"
			{
				gboolean _tmp18_ = FALSE;
#line 382 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_tmp18_ = TRUE;
#line 382 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				while (TRUE) {
#line 2281 "simple-scan.c"
					gint _tmp20_ = 0;
					Book* _tmp21_ = NULL;
					guint _tmp22_ = 0U;
					guint _tmp23_ = 0U;
					gchar* path = NULL;
					gchar* _tmp24_ = NULL;
					const gchar* _tmp25_ = NULL;
					GFile* file = NULL;
					const gchar* _tmp26_ = NULL;
					GFile* _tmp27_ = NULL;
					const gchar* _tmp36_ = NULL;
					const gchar* _tmp37_ = NULL;
					gchar* _tmp38_ = NULL;
					gchar* _tmp39_ = NULL;
					gchar* _tmp40_ = NULL;
					gboolean _tmp41_ = FALSE;
#line 382 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					if (!_tmp18_) {
#line 2300 "simple-scan.c"
						gint _tmp19_ = 0;
#line 382 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp19_ = i;
#line 382 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						i = _tmp19_ + 1;
#line 2306 "simple-scan.c"
					}
#line 382 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp18_ = FALSE;
#line 382 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp20_ = i;
#line 382 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp21_ = self->priv->book;
#line 382 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp22_ = book_get_n_pages (_tmp21_);
#line 382 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp23_ = _tmp22_;
#line 382 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					if (!(((guint) _tmp20_) < _tmp23_)) {
#line 382 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						break;
#line 2322 "simple-scan.c"
					}
#line 384 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp24_ = simple_scan_get_temporary_filename (self, "scan", "jpg");
#line 384 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					path = _tmp24_;
#line 385 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp25_ = path;
#line 385 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					if (_tmp25_ == NULL) {
#line 387 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						saved = FALSE;
#line 388 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_g_free0 (path);
#line 388 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						break;
#line 2338 "simple-scan.c"
					}
#line 391 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp26_ = path;
#line 391 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp27_ = g_file_new_for_path (_tmp26_);
#line 391 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					file = _tmp27_;
#line 2346 "simple-scan.c"
					{
						Book* _tmp28_ = NULL;
						gint _tmp29_ = 0;
						Page* _tmp30_ = NULL;
						Page* _tmp31_ = NULL;
						gint _tmp32_ = 0;
						GFile* _tmp33_ = NULL;
#line 394 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp28_ = self->priv->book;
#line 394 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp29_ = i;
#line 394 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp30_ = book_get_page (_tmp28_, _tmp29_);
#line 394 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp31_ = _tmp30_;
#line 394 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp32_ = quality;
#line 394 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp33_ = file;
#line 394 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						page_save (_tmp31_, "jpeg", _tmp32_, _tmp33_, &_inner_error_);
#line 394 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_page_unref0 (_tmp31_);
#line 394 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2372 "simple-scan.c"
							goto __catch10_g_error;
						}
					}
					goto __finally10;
					__catch10_g_error:
					{
						GError* e = NULL;
						GError* _tmp34_ = NULL;
						const gchar* _tmp35_ = NULL;
#line 392 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						e = _inner_error_;
#line 392 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_inner_error_ = NULL;
#line 398 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp34_ = e;
#line 398 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp35_ = _tmp34_->message;
#line 398 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						g_warning ("simple-scan.vala:398: Unable to save email file: %s", _tmp35_);
#line 399 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_g_error_free0 (e);
#line 399 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_g_object_unref0 (file);
#line 399 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_g_free0 (path);
#line 399 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_g_free0 (command_line);
#line 399 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						return;
#line 2402 "simple-scan.c"
					}
					__finally10:
#line 392 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 392 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_g_object_unref0 (file);
#line 392 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_g_free0 (path);
#line 392 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_g_free0 (command_line);
#line 392 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 392 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						g_clear_error (&_inner_error_);
#line 392 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						return;
#line 2419 "simple-scan.c"
					}
#line 401 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp36_ = command_line;
#line 401 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp37_ = path;
#line 401 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp38_ = g_strdup_printf (" --attach %s", _tmp37_);
#line 401 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp39_ = _tmp38_;
#line 401 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp40_ = g_strconcat (_tmp36_, _tmp39_, NULL);
#line 401 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_g_free0 (command_line);
#line 401 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					command_line = _tmp40_;
#line 401 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_g_free0 (_tmp39_);
#line 403 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp41_ = saved;
#line 403 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					if (!_tmp41_) {
#line 404 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_g_object_unref0 (file);
#line 404 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_g_free0 (path);
#line 404 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						break;
#line 2447 "simple-scan.c"
					}
#line 382 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_g_object_unref0 (file);
#line 382 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_g_free0 (path);
#line 2453 "simple-scan.c"
				}
			}
		}
	}
#line 408 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp42_ = command_line;
#line 408 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_debug ("simple-scan.vala:408: Launching email client: %s", _tmp42_);
#line 2462 "simple-scan.c"
	{
		const gchar* _tmp43_ = NULL;
#line 411 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp43_ = command_line;
#line 411 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_spawn_command_line_async (_tmp43_, &_inner_error_);
#line 411 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2471 "simple-scan.c"
			goto __catch11_g_error;
		}
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		GError* _tmp44_ = NULL;
		const gchar* _tmp45_ = NULL;
#line 409 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		e = _inner_error_;
#line 409 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 415 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp44_ = e;
#line 415 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp45_ = _tmp44_->message;
#line 415 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_warning ("simple-scan.vala:415: Unable to start email: %s", _tmp45_);
#line 409 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_error_free0 (e);
#line 2493 "simple-scan.c"
	}
	__finally11:
#line 409 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 409 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_free0 (command_line);
#line 409 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 409 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 409 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		return;
#line 2506 "simple-scan.c"
	}
#line 353 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_free0 (command_line);
#line 2510 "simple-scan.c"
}


static void simple_scan_log_cb (const gchar* log_domain, GLogLevelFlags log_level, const gchar* message) {
	gchar* prefix = NULL;
	GLogLevelFlags _tmp0_ = 0;
	FILE* _tmp8_ = NULL;
	GTimer* _tmp9_ = NULL;
	gdouble _tmp10_ = 0.0;
	const gchar* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
#line 419 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (message != NULL);
#line 423 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp0_ = log_level;
#line 423 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	switch (_tmp0_ & G_LOG_LEVEL_MASK) {
#line 423 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		case G_LOG_LEVEL_ERROR:
#line 2531 "simple-scan.c"
		{
			gchar* _tmp1_ = NULL;
#line 426 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp1_ = g_strdup ("ERROR:");
#line 426 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_g_free0 (prefix);
#line 426 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			prefix = _tmp1_;
#line 427 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			break;
#line 2542 "simple-scan.c"
		}
#line 423 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		case G_LOG_LEVEL_CRITICAL:
#line 2546 "simple-scan.c"
		{
			gchar* _tmp2_ = NULL;
#line 429 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp2_ = g_strdup ("CRITICAL:");
#line 429 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_g_free0 (prefix);
#line 429 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			prefix = _tmp2_;
#line 430 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			break;
#line 2557 "simple-scan.c"
		}
#line 423 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		case G_LOG_LEVEL_WARNING:
#line 2561 "simple-scan.c"
		{
			gchar* _tmp3_ = NULL;
#line 432 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp3_ = g_strdup ("WARNING:");
#line 432 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_g_free0 (prefix);
#line 432 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			prefix = _tmp3_;
#line 433 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			break;
#line 2572 "simple-scan.c"
		}
#line 423 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		case G_LOG_LEVEL_MESSAGE:
#line 2576 "simple-scan.c"
		{
			gchar* _tmp4_ = NULL;
#line 435 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp4_ = g_strdup ("MESSAGE:");
#line 435 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_g_free0 (prefix);
#line 435 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			prefix = _tmp4_;
#line 436 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			break;
#line 2587 "simple-scan.c"
		}
#line 423 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		case G_LOG_LEVEL_INFO:
#line 2591 "simple-scan.c"
		{
			gchar* _tmp5_ = NULL;
#line 438 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp5_ = g_strdup ("INFO:");
#line 438 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_g_free0 (prefix);
#line 438 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			prefix = _tmp5_;
#line 439 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			break;
#line 2602 "simple-scan.c"
		}
#line 423 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		case G_LOG_LEVEL_DEBUG:
#line 2606 "simple-scan.c"
		{
			gchar* _tmp6_ = NULL;
#line 441 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp6_ = g_strdup ("DEBUG:");
#line 441 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_g_free0 (prefix);
#line 441 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			prefix = _tmp6_;
#line 442 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			break;
#line 2617 "simple-scan.c"
		}
		default:
		{
			gchar* _tmp7_ = NULL;
#line 444 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp7_ = g_strdup ("LOG:");
#line 444 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_g_free0 (prefix);
#line 444 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			prefix = _tmp7_;
#line 445 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			break;
#line 2630 "simple-scan.c"
		}
	}
#line 448 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp8_ = simple_scan_log_file;
#line 448 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp9_ = simple_scan_log_timer;
#line 448 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp10_ = g_timer_elapsed (_tmp9_, NULL);
#line 448 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp11_ = prefix;
#line 448 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp12_ = message;
#line 448 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	fprintf (_tmp8_, "[%+.2fs] %s %s\n", _tmp10_, _tmp11_, _tmp12_);
#line 449 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp13_ = simple_scan_debug_enabled;
#line 449 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	if (_tmp13_) {
#line 2649 "simple-scan.c"
		FILE* _tmp14_ = NULL;
		GTimer* _tmp15_ = NULL;
		gdouble _tmp16_ = 0.0;
		const gchar* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
#line 450 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp14_ = stderr;
#line 450 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp15_ = simple_scan_log_timer;
#line 450 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp16_ = g_timer_elapsed (_tmp15_, NULL);
#line 450 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp17_ = prefix;
#line 450 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp18_ = message;
#line 450 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		fprintf (_tmp14_, "[%+.2fs] %s %s\n", _tmp16_, _tmp17_, _tmp18_);
#line 2667 "simple-scan.c"
	}
#line 419 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_free0 (prefix);
#line 2671 "simple-scan.c"
}


static void simple_scan_on_uevent (SimpleScan* self, GUdevClient* client, const gchar* action, GUdevDevice* device) {
	Scanner* _tmp0_ = NULL;
#line 453 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (self != NULL);
#line 453 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (client != NULL);
#line 453 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (action != NULL);
#line 453 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (device != NULL);
#line 455 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp0_ = self->priv->scanner;
#line 455 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	scanner_redetect (_tmp0_);
#line 2689 "simple-scan.c"
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_ = NULL;
	glong _tmp1_ = 0L;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
#line 1197 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp0_ = str;
#line 1197 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = maxlen;
#line 1197 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
#line 1197 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	end = _tmp2_;
#line 1198 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp3_ = end;
#line 1198 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp3_ == NULL) {
#line 2712 "simple-scan.c"
		glong _tmp4_ = 0L;
#line 1199 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp4_ = maxlen;
#line 1199 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		result = _tmp4_;
#line 1199 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		return result;
#line 2720 "simple-scan.c"
	} else {
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
#line 1201 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp5_ = end;
#line 1201 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp6_ = str;
#line 1201 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		result = (glong) (_tmp5_ - _tmp6_);
#line 1201 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		return result;
#line 2732 "simple-scan.c"
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_ = 0L;
	glong _tmp8_ = 0L;
	glong _tmp14_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	glong _tmp21_ = 0L;
	gchar* _tmp22_ = NULL;
#line 1208 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1210 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp1_ = offset;
#line 1210 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp1_ >= ((glong) 0)) {
#line 2756 "simple-scan.c"
		glong _tmp2_ = 0L;
#line 1210 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp2_ = len;
#line 1210 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp0_ = _tmp2_ >= ((glong) 0);
#line 2762 "simple-scan.c"
	} else {
#line 1210 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp0_ = FALSE;
#line 2766 "simple-scan.c"
	}
#line 1210 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp0_) {
#line 2770 "simple-scan.c"
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		glong _tmp5_ = 0L;
#line 1212 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp3_ = offset;
#line 1212 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp4_ = len;
#line 1212 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp5_ = string_strnlen ((gchar*) self, _tmp3_ + _tmp4_);
#line 1212 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		string_length = _tmp5_;
#line 2782 "simple-scan.c"
	} else {
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
#line 1214 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp6_ = strlen (self);
#line 1214 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp7_ = _tmp6_;
#line 1214 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		string_length = (glong) _tmp7_;
#line 2792 "simple-scan.c"
	}
#line 1217 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp8_ = offset;
#line 1217 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp8_ < ((glong) 0)) {
#line 2798 "simple-scan.c"
		glong _tmp9_ = 0L;
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
#line 1218 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp9_ = string_length;
#line 1218 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp10_ = offset;
#line 1218 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		offset = _tmp9_ + _tmp10_;
#line 1219 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp11_ = offset;
#line 1219 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp11_ >= ((glong) 0), NULL);
#line 2812 "simple-scan.c"
	} else {
		glong _tmp12_ = 0L;
		glong _tmp13_ = 0L;
#line 1221 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp12_ = offset;
#line 1221 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp13_ = string_length;
#line 1221 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		g_return_val_if_fail (_tmp12_ <= _tmp13_, NULL);
#line 2822 "simple-scan.c"
	}
#line 1223 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp14_ = len;
#line 1223 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	if (_tmp14_ < ((glong) 0)) {
#line 2828 "simple-scan.c"
		glong _tmp15_ = 0L;
		glong _tmp16_ = 0L;
#line 1224 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp15_ = string_length;
#line 1224 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		_tmp16_ = offset;
#line 1224 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
		len = _tmp15_ - _tmp16_;
#line 2837 "simple-scan.c"
	}
#line 1226 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp17_ = offset;
#line 1226 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp18_ = len;
#line 1226 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp19_ = string_length;
#line 1226 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	g_return_val_if_fail ((_tmp17_ + _tmp18_) <= _tmp19_, NULL);
#line 1227 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp20_ = offset;
#line 1227 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp21_ = len;
#line 1227 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	_tmp22_ = g_strndup (((gchar*) self) + _tmp20_, (gsize) _tmp21_);
#line 1227 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	result = _tmp22_;
#line 1227 "/usr/share/vala-0.26/vapi/glib-2.0.vapi"
	return result;
#line 2857 "simple-scan.c"
}


static void simple_scan_fix_pdf (const gchar* filename, GError** error) {
	guint8* data = NULL;
	gint data_length1 = 0;
	gint _data_size_ = 0;
	const gchar* _tmp0_ = NULL;
	guint8* _tmp1_ = NULL;
	size_t _tmp2_;
	FILE* fixed_file = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	FILE* _tmp6_ = NULL;
	FILE* _tmp7_ = NULL;
	gint offset = 0;
	gint line_number = 0;
	gint xref_offset = 0;
	gint xref_line = 0;
	gint startxref_line = 0;
	gint fixed_size = 0;
	GString* line = NULL;
	GString* _tmp8_ = NULL;
	const gchar* _tmp102_ = NULL;
	const gchar* _tmp103_ = NULL;
	gchar* _tmp104_ = NULL;
	gchar* _tmp105_ = NULL;
	gint _tmp106_ = 0;
	gboolean _tmp107_ = FALSE;
	GError * _inner_error_ = NULL;
#line 458 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_return_if_fail (filename != NULL);
#line 461 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp0_ = filename;
#line 461 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_file_get_contents (_tmp0_, (gchar**) (&_tmp1_), &_tmp2_, &_inner_error_);
#line 461 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	data = (g_free (data), NULL);
#line 461 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	data = _tmp1_;
#line 461 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	data_length1 = _tmp2_;
#line 461 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_data_size_ = data_length1;
#line 461 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 461 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_propagate_error (error, _inner_error_);
#line 461 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		data = (g_free (data), NULL);
#line 461 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		return;
#line 2911 "simple-scan.c"
	}
#line 463 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp3_ = filename;
#line 463 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp4_ = g_strconcat (_tmp3_, ".fixed", NULL);
#line 463 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp5_ = _tmp4_;
#line 463 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp6_ = g_fopen (_tmp5_, "w");
#line 463 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp7_ = _tmp6_;
#line 463 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_free0 (_tmp5_);
#line 463 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	fixed_file = _tmp7_;
#line 465 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	offset = 0;
#line 466 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	line_number = 0;
#line 467 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	xref_offset = 0;
#line 468 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	xref_line = -1;
#line 469 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	startxref_line = -1;
#line 470 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	fixed_size = -1;
#line 471 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp8_ = g_string_new ("");
#line 471 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	line = _tmp8_;
#line 472 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	while (TRUE) {
#line 2945 "simple-scan.c"
		gint _tmp9_ = 0;
		gint end_offset = 0;
		gint _tmp10_ = 0;
		GString* _tmp11_ = NULL;
		GString* _tmp19_ = NULL;
		const gchar* _tmp20_ = NULL;
		GString* _tmp22_ = NULL;
		const gchar* _tmp23_ = NULL;
		gboolean _tmp25_ = FALSE;
		gint _tmp26_ = 0;
		gint _tmp100_ = 0;
		gint _tmp101_ = 0;
#line 472 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp9_ = offset;
#line 472 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		if (!(_tmp9_ < data_length1)) {
#line 472 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			break;
#line 2964 "simple-scan.c"
		}
#line 474 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp10_ = offset;
#line 474 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		end_offset = _tmp10_;
#line 475 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp11_ = line;
#line 475 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_string_assign (_tmp11_, "");
#line 476 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		while (TRUE) {
#line 2976 "simple-scan.c"
			gint _tmp12_ = 0;
			guint8 c = 0U;
			gint _tmp13_ = 0;
			guint8 _tmp14_ = 0U;
			GString* _tmp15_ = NULL;
			guint8 _tmp16_ = 0U;
			gint _tmp17_ = 0;
			guint8 _tmp18_ = 0U;
#line 476 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp12_ = end_offset;
#line 476 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			if (!(_tmp12_ < data_length1)) {
#line 476 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				break;
#line 2991 "simple-scan.c"
			}
#line 478 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp13_ = end_offset;
#line 478 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp14_ = data[_tmp13_];
#line 478 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			c = _tmp14_;
#line 479 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp15_ = line;
#line 479 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp16_ = c;
#line 479 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			g_string_append_c (_tmp15_, (gchar) _tmp16_);
#line 480 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp17_ = end_offset;
#line 480 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			end_offset = _tmp17_ + 1;
#line 481 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp18_ = c;
#line 481 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			if (_tmp18_ == ((guint8) '\n')) {
#line 482 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				break;
#line 3015 "simple-scan.c"
			}
		}
#line 485 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp19_ = line;
#line 485 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp20_ = _tmp19_->str;
#line 485 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		if (g_strcmp0 (_tmp20_, "startxref\n") == 0) {
#line 3024 "simple-scan.c"
			gint _tmp21_ = 0;
#line 486 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp21_ = line_number;
#line 486 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			startxref_line = _tmp21_;
#line 3030 "simple-scan.c"
		}
#line 488 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp22_ = line;
#line 488 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp23_ = _tmp22_->str;
#line 488 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		if (g_strcmp0 (_tmp23_, "xref\n") == 0) {
#line 3038 "simple-scan.c"
			gint _tmp24_ = 0;
#line 489 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp24_ = line_number;
#line 489 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			xref_line = _tmp24_;
#line 3044 "simple-scan.c"
		}
#line 492 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp26_ = line_number;
#line 492 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		if (_tmp26_ < 2) {
#line 3050 "simple-scan.c"
			GString* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			gboolean _tmp29_ = FALSE;
#line 492 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp27_ = line;
#line 492 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp28_ = _tmp27_->str;
#line 492 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp29_ = g_str_has_prefix (_tmp28_, "%%");
#line 492 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp25_ = _tmp29_;
#line 3062 "simple-scan.c"
		} else {
#line 492 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp25_ = FALSE;
#line 3066 "simple-scan.c"
		}
#line 492 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		if (_tmp25_) {
#line 3070 "simple-scan.c"
			gint _tmp30_ = 0;
			FILE* _tmp31_ = NULL;
			GString* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
			gchar* _tmp34_ = NULL;
			gchar* _tmp35_ = NULL;
#line 494 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp30_ = xref_offset;
#line 494 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			xref_offset = _tmp30_ - 1;
#line 495 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp31_ = fixed_file;
#line 495 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp32_ = line;
#line 495 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp33_ = _tmp32_->str;
#line 495 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp34_ = string_substring (_tmp33_, (glong) 1, (glong) (-1));
#line 495 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp35_ = _tmp34_;
#line 495 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			fprintf (_tmp31_, "%s", _tmp35_);
#line 495 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_g_free0 (_tmp35_);
#line 3095 "simple-scan.c"
		} else {
			gboolean _tmp36_ = FALSE;
			gint _tmp37_ = 0;
			gint _tmp38_ = 0;
#line 499 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp37_ = line_number;
#line 499 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp38_ = xref_line;
#line 499 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			if (_tmp37_ == (_tmp38_ + 1)) {
#line 3106 "simple-scan.c"
				GString* _tmp39_ = NULL;
				const gchar* _tmp40_ = NULL;
				gboolean _tmp41_ = FALSE;
#line 499 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_tmp39_ = line;
#line 499 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_tmp40_ = _tmp39_->str;
#line 499 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_tmp41_ = g_str_has_prefix (_tmp40_, "1 ");
#line 499 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_tmp36_ = _tmp41_;
#line 3118 "simple-scan.c"
			} else {
#line 499 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_tmp36_ = FALSE;
#line 3122 "simple-scan.c"
			}
#line 499 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			if (_tmp36_) {
#line 3126 "simple-scan.c"
				GString* _tmp42_ = NULL;
				const gchar* _tmp43_ = NULL;
				gchar* _tmp44_ = NULL;
				gchar* _tmp45_ = NULL;
				gint _tmp46_ = 0;
				FILE* _tmp47_ = NULL;
				gint _tmp48_ = 0;
				FILE* _tmp49_ = NULL;
#line 501 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_tmp42_ = line;
#line 501 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_tmp43_ = _tmp42_->str;
#line 501 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_tmp44_ = string_substring (_tmp43_, (glong) 2, (glong) (-1));
#line 501 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_tmp45_ = _tmp44_;
#line 501 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_tmp46_ = atoi (_tmp45_);
#line 501 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				fixed_size = _tmp46_ + 1;
#line 501 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_g_free0 (_tmp45_);
#line 502 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_tmp47_ = fixed_file;
#line 502 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_tmp48_ = fixed_size;
#line 502 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				fprintf (_tmp47_, "0 %d\n", _tmp48_);
#line 503 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_tmp49_ = fixed_file;
#line 503 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				fprintf (_tmp49_, "0000000000 65535 f \n");
#line 3159 "simple-scan.c"
			} else {
				gboolean _tmp50_ = FALSE;
				gint _tmp51_ = 0;
				gint _tmp52_ = 0;
#line 507 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_tmp51_ = line_number;
#line 507 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				_tmp52_ = xref_line;
#line 507 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				if (_tmp51_ > _tmp52_) {
#line 3170 "simple-scan.c"
					GString* _tmp53_ = NULL;
					const gchar* _tmp54_ = NULL;
					gboolean _tmp55_ = FALSE;
#line 507 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp53_ = line;
#line 507 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp54_ = _tmp53_->str;
#line 507 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp55_ = g_str_has_suffix (_tmp54_, " 0000 n\n");
#line 507 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp50_ = _tmp55_;
#line 3182 "simple-scan.c"
				} else {
#line 507 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp50_ = FALSE;
#line 3186 "simple-scan.c"
				}
#line 507 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				if (_tmp50_) {
#line 3190 "simple-scan.c"
					FILE* _tmp56_ = NULL;
					GString* _tmp57_ = NULL;
					const gchar* _tmp58_ = NULL;
					gint _tmp59_ = 0;
					gint _tmp60_ = 0;
#line 508 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp56_ = fixed_file;
#line 508 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp57_ = line;
#line 508 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp58_ = _tmp57_->str;
#line 508 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp59_ = atoi (_tmp58_);
#line 508 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp60_ = xref_offset;
#line 508 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					fprintf (_tmp56_, "%010d 00000 n \n", _tmp59_ + _tmp60_);
#line 3208 "simple-scan.c"
				} else {
					gboolean _tmp61_ = FALSE;
					gint _tmp62_ = 0;
#line 511 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp62_ = startxref_line;
#line 511 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					if (_tmp62_ > 0) {
#line 3216 "simple-scan.c"
						gint _tmp63_ = 0;
						gint _tmp64_ = 0;
#line 511 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp63_ = line_number;
#line 511 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp64_ = startxref_line;
#line 511 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp61_ = _tmp63_ == (_tmp64_ + 1);
#line 3225 "simple-scan.c"
					} else {
#line 511 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp61_ = FALSE;
#line 3229 "simple-scan.c"
					}
#line 511 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					if (_tmp61_) {
#line 3233 "simple-scan.c"
						FILE* _tmp65_ = NULL;
						GString* _tmp66_ = NULL;
						const gchar* _tmp67_ = NULL;
						gint _tmp68_ = 0;
						gint _tmp69_ = 0;
						gchar* _tmp70_ = NULL;
						gchar* _tmp71_ = NULL;
#line 512 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp65_ = fixed_file;
#line 512 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp66_ = line;
#line 512 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp67_ = _tmp66_->str;
#line 512 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp68_ = atoi (_tmp67_);
#line 512 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp69_ = xref_offset;
#line 512 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp70_ = g_strdup_printf ("%d\n", _tmp68_ + _tmp69_);
#line 512 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp71_ = _tmp70_;
#line 512 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						fprintf (_tmp65_, "%s", _tmp71_);
#line 512 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_g_free0 (_tmp71_);
#line 3259 "simple-scan.c"
					} else {
						gboolean _tmp72_ = FALSE;
						gint _tmp73_ = 0;
#line 514 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp73_ = fixed_size;
#line 514 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						if (_tmp73_ > 0) {
#line 3267 "simple-scan.c"
							GString* _tmp74_ = NULL;
							const gchar* _tmp75_ = NULL;
							gboolean _tmp76_ = FALSE;
#line 514 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
							_tmp74_ = line;
#line 514 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
							_tmp75_ = _tmp74_->str;
#line 514 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
							_tmp76_ = g_str_has_prefix (_tmp75_, "/Size ");
#line 514 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
							_tmp72_ = _tmp76_;
#line 3279 "simple-scan.c"
						} else {
#line 514 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
							_tmp72_ = FALSE;
#line 3283 "simple-scan.c"
						}
#line 514 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						if (_tmp72_) {
#line 3287 "simple-scan.c"
							FILE* _tmp77_ = NULL;
							gint _tmp78_ = 0;
							gchar* _tmp79_ = NULL;
							gchar* _tmp80_ = NULL;
#line 515 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
							_tmp77_ = fixed_file;
#line 515 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
							_tmp78_ = fixed_size;
#line 515 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
							_tmp79_ = g_strdup_printf ("/Size %d\n", _tmp78_);
#line 515 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
							_tmp80_ = _tmp79_;
#line 515 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
							fprintf (_tmp77_, "%s", _tmp80_);
#line 515 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
							_g_free0 (_tmp80_);
#line 3304 "simple-scan.c"
						} else {
							gboolean _tmp81_ = FALSE;
							gint _tmp82_ = 0;
							gint _tmp83_ = 0;
#line 518 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
							_tmp82_ = line_number;
#line 518 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
							_tmp83_ = startxref_line;
#line 518 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
							if (_tmp82_ == (_tmp83_ + 2)) {
#line 3315 "simple-scan.c"
								GString* _tmp84_ = NULL;
								const gchar* _tmp85_ = NULL;
								gboolean _tmp86_ = FALSE;
#line 518 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
								_tmp84_ = line;
#line 518 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
								_tmp85_ = _tmp84_->str;
#line 518 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
								_tmp86_ = g_str_has_prefix (_tmp85_, "%%%%");
#line 518 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
								_tmp81_ = _tmp86_;
#line 3327 "simple-scan.c"
							} else {
#line 518 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
								_tmp81_ = FALSE;
#line 3331 "simple-scan.c"
							}
#line 518 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
							if (_tmp81_) {
#line 3335 "simple-scan.c"
								FILE* _tmp87_ = NULL;
								GString* _tmp88_ = NULL;
								const gchar* _tmp89_ = NULL;
								gchar* _tmp90_ = NULL;
								gchar* _tmp91_ = NULL;
#line 519 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
								_tmp87_ = fixed_file;
#line 519 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
								_tmp88_ = line;
#line 519 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
								_tmp89_ = _tmp88_->str;
#line 519 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
								_tmp90_ = string_substring (_tmp89_, (glong) 2, (glong) (-1));
#line 519 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
								_tmp91_ = _tmp90_;
#line 519 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
								fprintf (_tmp87_, "%s", _tmp91_);
#line 519 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
								_g_free0 (_tmp91_);
#line 3355 "simple-scan.c"
							} else {
								{
									gint i = 0;
									gint _tmp92_ = 0;
#line 522 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
									_tmp92_ = offset;
#line 522 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
									i = _tmp92_;
#line 3364 "simple-scan.c"
									{
										gboolean _tmp93_ = FALSE;
#line 522 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
										_tmp93_ = TRUE;
#line 522 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
										while (TRUE) {
#line 3371 "simple-scan.c"
											gint _tmp95_ = 0;
											gint _tmp96_ = 0;
											FILE* _tmp97_ = NULL;
											gint _tmp98_ = 0;
											guint8 _tmp99_ = 0U;
#line 522 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
											if (!_tmp93_) {
#line 3379 "simple-scan.c"
												gint _tmp94_ = 0;
#line 522 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
												_tmp94_ = i;
#line 522 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
												i = _tmp94_ + 1;
#line 3385 "simple-scan.c"
											}
#line 522 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
											_tmp93_ = FALSE;
#line 522 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
											_tmp95_ = i;
#line 522 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
											_tmp96_ = end_offset;
#line 522 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
											if (!(_tmp95_ < _tmp96_)) {
#line 522 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
												break;
#line 3397 "simple-scan.c"
											}
#line 523 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
											_tmp97_ = fixed_file;
#line 523 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
											_tmp98_ = i;
#line 523 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
											_tmp99_ = data[_tmp98_];
#line 523 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
											fputc ((gchar) _tmp99_, _tmp97_);
#line 3407 "simple-scan.c"
										}
									}
								}
							}
						}
					}
				}
			}
		}
#line 525 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp100_ = line_number;
#line 525 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		line_number = _tmp100_ + 1;
#line 526 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp101_ = end_offset;
#line 526 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		offset = _tmp101_;
#line 3425 "simple-scan.c"
	}
#line 529 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp102_ = filename;
#line 529 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp103_ = filename;
#line 529 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp104_ = g_strconcat (_tmp103_, "~", NULL);
#line 529 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp105_ = _tmp104_;
#line 529 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp106_ = g_rename (_tmp102_, _tmp105_);
#line 529 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp107_ = _tmp106_ >= 0;
#line 529 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_free0 (_tmp105_);
#line 529 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	if (_tmp107_) {
#line 3443 "simple-scan.c"
		const gchar* _tmp108_ = NULL;
		gchar* _tmp109_ = NULL;
		gchar* _tmp110_ = NULL;
		const gchar* _tmp111_ = NULL;
#line 530 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp108_ = filename;
#line 530 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp109_ = g_strconcat (_tmp108_, ".fixed", NULL);
#line 530 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp110_ = _tmp109_;
#line 530 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp111_ = filename;
#line 530 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_rename (_tmp110_, _tmp111_);
#line 530 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_free0 (_tmp110_);
#line 3460 "simple-scan.c"
	}
#line 458 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_string_free0 (line);
#line 458 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_fclose0 (fixed_file);
#line 458 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	data = (g_free (data), NULL);
#line 3468 "simple-scan.c"
}


static void _simple_scan_log_cb_glog_func (const gchar* log_domain, GLogLevelFlags log_levels, const gchar* message, gpointer self) {
#line 592 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	simple_scan_log_cb (log_domain, log_levels, message);
#line 3475 "simple-scan.c"
}


gint simple_scan_main (gchar** args, int args_length1) {
	gint result = 0;
	GOptionContext* c = NULL;
	const gchar* _tmp0_ = NULL;
	GOptionContext* _tmp1_ = NULL;
	GOptionContext* _tmp2_ = NULL;
	GOptionContext* _tmp3_ = NULL;
	GOptionGroup* _tmp4_ = NULL;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp16_ = NULL;
	ScanDevice* device = NULL;
	gchar** _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	GTimer* _tmp38_ = NULL;
	gchar* path = NULL;
	const gchar* _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	gchar* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	FILE* _tmp45_ = NULL;
	pid_t _tmp46_ = 0;
	SimpleScan* app = NULL;
	ScanDevice* _tmp47_ = NULL;
	SimpleScan* _tmp48_ = NULL;
	SimpleScan* _tmp49_ = NULL;
	gint _tmp50_ = 0;
	GError * _inner_error_ = NULL;
#line 535 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	setlocale (LC_ALL, "");
#line 536 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
#line 537 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
#line 538 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	textdomain (GETTEXT_PACKAGE);
#line 540 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp0_ = _ ("[DEVICE...] - Scanning utility");
#line 540 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp1_ = g_option_context_new (_tmp0_);
#line 540 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	c = _tmp1_;
#line 542 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp2_ = c;
#line 542 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_option_context_add_main_entries (_tmp2_, SIMPLE_SCAN_options, GETTEXT_PACKAGE);
#line 543 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp3_ = c;
#line 543 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp4_ = gtk_get_option_group (TRUE);
#line 543 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_option_context_add_group (_tmp3_, _tmp4_);
#line 3532 "simple-scan.c"
	{
		GOptionContext* _tmp5_ = NULL;
#line 546 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp5_ = c;
#line 546 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_option_context_parse (_tmp5_, &args_length1, &args, &_inner_error_);
#line 546 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3541 "simple-scan.c"
			goto __catch12_g_error;
		}
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		FILE* _tmp6_ = NULL;
		GError* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		FILE* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		gchar** _tmp11_ = NULL;
		gint _tmp11__length1 = 0;
		const gchar* _tmp12_ = NULL;
		FILE* _tmp13_ = NULL;
#line 544 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		e = _inner_error_;
#line 544 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_inner_error_ = NULL;
#line 550 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp6_ = stderr;
#line 550 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp7_ = e;
#line 550 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp8_ = _tmp7_->message;
#line 550 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		fprintf (_tmp6_, "%s\n", _tmp8_);
#line 551 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp9_ = stderr;
#line 551 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp10_ = _ ("Run '%s --help' to see a full list of available command line options.");
#line 551 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp11_ = args;
#line 551 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp11__length1 = args_length1;
#line 551 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp12_ = _tmp11_[0];
#line 551 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		fprintf (_tmp9_, _tmp10_, _tmp12_);
#line 553 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp13_ = stderr;
#line 553 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		fprintf (_tmp13_, "\n");
#line 554 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		result = EXIT_FAILURE;
#line 554 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_error_free0 (e);
#line 554 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_option_context_free0 (c);
#line 554 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		return result;
#line 3594 "simple-scan.c"
	}
	__finally12:
#line 544 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 544 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_option_context_free0 (c);
#line 544 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 544 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		g_clear_error (&_inner_error_);
#line 544 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		return 0;
#line 3607 "simple-scan.c"
	}
#line 556 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp14_ = simple_scan_show_version;
#line 556 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	if (_tmp14_) {
#line 3613 "simple-scan.c"
		FILE* _tmp15_ = NULL;
#line 559 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp15_ = stderr;
#line 559 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		fprintf (_tmp15_, "simple-scan %s\n", VERSION);
#line 560 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		result = EXIT_SUCCESS;
#line 560 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_option_context_free0 (c);
#line 560 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		return result;
#line 3625 "simple-scan.c"
	}
#line 562 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp16_ = simple_scan_fix_pdf_filename;
#line 562 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	if (_tmp16_ != NULL) {
#line 3631 "simple-scan.c"
		{
			const gchar* _tmp17_ = NULL;
#line 566 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp17_ = simple_scan_fix_pdf_filename;
#line 566 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			simple_scan_fix_pdf (_tmp17_, &_inner_error_);
#line 566 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3640 "simple-scan.c"
				goto __catch13_g_error;
			}
			{
				gint i = 0;
#line 567 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
				i = 1;
#line 3647 "simple-scan.c"
				{
					gboolean _tmp18_ = FALSE;
#line 567 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					_tmp18_ = TRUE;
#line 567 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
					while (TRUE) {
#line 3654 "simple-scan.c"
						gint _tmp20_ = 0;
						gchar** _tmp21_ = NULL;
						gint _tmp21__length1 = 0;
						gchar** _tmp22_ = NULL;
						gint _tmp22__length1 = 0;
						gint _tmp23_ = 0;
						const gchar* _tmp24_ = NULL;
#line 567 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						if (!_tmp18_) {
#line 3664 "simple-scan.c"
							gint _tmp19_ = 0;
#line 567 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
							_tmp19_ = i;
#line 567 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
							i = _tmp19_ + 1;
#line 3670 "simple-scan.c"
						}
#line 567 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp18_ = FALSE;
#line 567 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp20_ = i;
#line 567 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp21_ = args;
#line 567 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp21__length1 = args_length1;
#line 567 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						if (!(_tmp20_ < _tmp21__length1)) {
#line 567 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
							break;
#line 3684 "simple-scan.c"
						}
#line 568 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp22_ = args;
#line 568 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp22__length1 = args_length1;
#line 568 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp23_ = i;
#line 568 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						_tmp24_ = _tmp22_[_tmp23_];
#line 568 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						simple_scan_fix_pdf (_tmp24_, &_inner_error_);
#line 568 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
						if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 3698 "simple-scan.c"
							goto __catch13_g_error;
						}
					}
				}
			}
		}
		goto __finally13;
		__catch13_g_error:
		{
			GError* e = NULL;
			FILE* _tmp25_ = NULL;
			GError* _tmp26_ = NULL;
			const gchar* _tmp27_ = NULL;
#line 564 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			e = _inner_error_;
#line 564 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_inner_error_ = NULL;
#line 572 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp25_ = stderr;
#line 572 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp26_ = e;
#line 572 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_tmp27_ = _tmp26_->message;
#line 572 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			fprintf (_tmp25_, "Error fixing PDF file: %s", _tmp27_);
#line 573 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			result = EXIT_FAILURE;
#line 573 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_g_error_free0 (e);
#line 573 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_g_option_context_free0 (c);
#line 573 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			return result;
#line 3732 "simple-scan.c"
		}
		__finally13:
#line 564 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 564 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			_g_option_context_free0 (c);
#line 564 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 564 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			g_clear_error (&_inner_error_);
#line 564 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
			return 0;
#line 3745 "simple-scan.c"
		}
#line 575 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		result = EXIT_SUCCESS;
#line 575 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_option_context_free0 (c);
#line 575 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		return result;
#line 3753 "simple-scan.c"
	}
#line 578 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	device = NULL;
#line 579 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp28_ = args;
#line 579 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp28__length1 = args_length1;
#line 579 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	if (_tmp28__length1 > 1) {
#line 3763 "simple-scan.c"
		ScanDevice* _tmp29_ = NULL;
		ScanDevice* _tmp30_ = NULL;
		gchar** _tmp31_ = NULL;
		gint _tmp31__length1 = 0;
		const gchar* _tmp32_ = NULL;
		gchar* _tmp33_ = NULL;
		ScanDevice* _tmp34_ = NULL;
		gchar** _tmp35_ = NULL;
		gint _tmp35__length1 = 0;
		const gchar* _tmp36_ = NULL;
		gchar* _tmp37_ = NULL;
#line 581 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp29_ = scan_device_new ();
#line 581 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_scan_device_unref0 (device);
#line 581 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		device = _tmp29_;
#line 582 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp30_ = device;
#line 582 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp31_ = args;
#line 582 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp31__length1 = args_length1;
#line 582 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp32_ = _tmp31_[1];
#line 582 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp33_ = g_strdup (_tmp32_);
#line 582 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_free0 (_tmp30_->name);
#line 582 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp30_->name = _tmp33_;
#line 583 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp34_ = device;
#line 583 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp35_ = args;
#line 583 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp35__length1 = args_length1;
#line 583 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp36_ = _tmp35_[1];
#line 583 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp37_ = g_strdup (_tmp36_);
#line 583 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_g_free0 (_tmp34_->label);
#line 583 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
		_tmp34_->label = _tmp37_;
#line 3809 "simple-scan.c"
	}
#line 587 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp38_ = g_timer_new ();
#line 587 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_timer_destroy0 (simple_scan_log_timer);
#line 587 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	simple_scan_log_timer = _tmp38_;
#line 588 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp39_ = g_get_user_cache_dir ();
#line 588 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp40_ = g_build_filename (_tmp39_, "simple-scan", NULL, NULL);
#line 588 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	path = _tmp40_;
#line 589 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp41_ = path;
#line 589 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_mkdir_with_parents (_tmp41_, 0700);
#line 590 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp42_ = g_get_user_cache_dir ();
#line 590 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp43_ = g_build_filename (_tmp42_, "simple-scan", "simple-scan.log", NULL, NULL);
#line 590 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_free0 (path);
#line 590 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	path = _tmp43_;
#line 591 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp44_ = path;
#line 591 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp45_ = g_fopen (_tmp44_, "w");
#line 591 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_fclose0 (simple_scan_log_file);
#line 591 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	simple_scan_log_file = _tmp45_;
#line 592 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_log_set_default_handler (_simple_scan_log_cb_glog_func, NULL);
#line 594 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp46_ = getpid ();
#line 594 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_debug ("simple-scan.vala:594: Starting Simple Scan %s, PID=%i", VERSION, (gint) _tmp46_);
#line 596 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	gtk_init (&args_length1, &args);
#line 598 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp47_ = device;
#line 598 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp48_ = simple_scan_new (_tmp47_);
#line 598 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	app = _tmp48_;
#line 599 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp49_ = app;
#line 599 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_tmp50_ = g_application_run ((GApplication*) _tmp49_, 0, NULL);
#line 599 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	result = _tmp50_;
#line 599 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_object_unref0 (app);
#line 599 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_free0 (path);
#line 599 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_scan_device_unref0 (device);
#line 599 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_option_context_free0 (c);
#line 599 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	return result;
#line 3873 "simple-scan.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 533 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	return simple_scan_main (argv, argc);
#line 3883 "simple-scan.c"
}


static void simple_scan_class_init (SimpleScanClass * klass) {
#line 12 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	simple_scan_parent_class = g_type_class_peek_parent (klass);
#line 12 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	g_type_class_add_private (klass, sizeof (SimpleScanPrivate));
#line 12 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	((GApplicationClass *) klass)->startup = simple_scan_real_startup;
#line 12 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	((GApplicationClass *) klass)->activate = simple_scan_real_activate;
#line 12 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	((GApplicationClass *) klass)->shutdown = simple_scan_real_shutdown;
#line 12 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	G_OBJECT_CLASS (klass)->finalize = simple_scan_finalize;
#line 3900 "simple-scan.c"
}


static void simple_scan_instance_init (SimpleScan * self) {
#line 12 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	self->priv = SIMPLE_SCAN_GET_PRIVATE (self);
#line 32 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	self->priv->default_device = NULL;
#line 33 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	self->priv->have_devices = FALSE;
#line 3911 "simple-scan.c"
}


static void simple_scan_finalize (GObject* obj) {
	SimpleScan * self;
#line 12 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SIMPLE_SCAN, SimpleScan);
#line 32 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_scan_device_unref0 (self->priv->default_device);
#line 34 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_object_unref0 (self->priv->udev_client);
#line 35 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_g_object_unref0 (self->priv->ui);
#line 36 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_scanner_unref0 (self->priv->scanner);
#line 37 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	_book_unref0 (self->priv->book);
#line 12 "/home/bob/bzr/simple-scan/3.16/src/simple-scan.vala"
	G_OBJECT_CLASS (simple_scan_parent_class)->finalize (obj);
#line 3931 "simple-scan.c"
}


GType simple_scan_get_type (void) {
	static volatile gsize simple_scan_type_id__volatile = 0;
	if (g_once_init_enter (&simple_scan_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SimpleScanClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) simple_scan_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SimpleScan), 0, (GInstanceInitFunc) simple_scan_instance_init, NULL };
		GType simple_scan_type_id;
		simple_scan_type_id = g_type_register_static (gtk_application_get_type (), "SimpleScan", &g_define_type_info, 0);
		g_once_init_leave (&simple_scan_type_id__volatile, simple_scan_type_id);
	}
	return simple_scan_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



