% See the slprof script for an example of using the profiler.
%
_boseos_info=0;
private variable Counts = Assoc_Type[Int_Type, 0];
private variable Times = Assoc_Type[Double_Type, 0.0];
private variable Stack_Depth = 0;
private variable Times_Stack = Double_Type[4096];
private variable Lines_Stack = String_Type[4096];
private variable Counts_Stack = Int_Type[4096];

private variable Num_Counts;
private variable Overhead_Per_Call = 0.0;
private variable Error_Per_Call = 0.0;

private define bos_handler (file, line)
{
   variable s = Stack_Depth;
   Stack_Depth++;
   file = sprintf ("%s:%d", file, line);
   Counts[file] += 1;
   Lines_Stack[s] = file;
   Counts_Stack[s] = Num_Counts;
   Num_Counts++;
   Times_Stack[s] = toc();
}

private define eos_handler ()
{
   variable t = toc();
   Stack_Depth--;
   variable file = Lines_Stack[Stack_Depth];
   Times[file] += (t - Times_Stack[Stack_Depth] - Error_Per_Call)
     - Overhead_Per_Call * ((Num_Counts-1) - Counts_Stack[Stack_Depth]);
}

define profile_on ()
{
   _boseos_info = 3;
}
define profile_off ()
{
   _boseos_info = 0;
}

define profile_begin ()
{
   ()=_set_bos_handler (&bos_handler);
   ()=_set_eos_handler (&eos_handler);
   Stack_Depth = 0;
   Times = Assoc_Type[Double_Type, 0.0];
   Counts = Assoc_Type[Int_Type, 0];
   Counts_Stack = Int_Type[4096];
   Num_Counts = 0;
   _boseos_info = 3;
   tic ();
}

define profile_end ()
{
   ()=_set_bos_handler (NULL);
   ()=_set_eos_handler (NULL);
   profile_off ();
}

profile_off ();
private define calibrate_fun_0 (n)
{
   loop (n) 
     {
	() = 1;	() = 1;	() = 1;	() = 1; () = 1;
     }
}

profile_on ();
private define calibrate_fun_1 (n)
{
   loop (n) 
     {
	() = 1;	() = 1;	() = 1;	() = 1; () = 1;
     }
}
profile_off ();

#ifnexists sum
private define sum (x)
{
   variable s = 0.0;
   foreach (x) s += ();
   return s;
}
#endif

define profile_calibrate ()
{
   if (_NARGS == 0) 1000;
   variable n1 = ();
#iffalse
   variable tstart = ftime ();
#endif
   variable t0, t1;
   variable n0 = 1000*n1;
   
   Overhead_Per_Call = 0.0;
   Error_Per_Call = 0.0;
   tic();
   calibrate_fun_0 (n0);
   t0 = toc;
   
   profile_begin ();
   tic ();
   calibrate_fun_1 (n1);
   t1 = toc ();
   profile_end ();
   variable num_calls = sum (assoc_get_values (Counts));
   variable t_expected = ((t0*n1)/n0);
   variable t_obs = sum(assoc_get_values(Times));
   Error_Per_Call = (t_obs - t_expected)/num_calls;
   Overhead_Per_Call = (t1-t_expected)/num_calls;
#iffalse
   vmessage ("Calibration took %g secs, Err=%g, Ovr=%g, Calls=%g",
	     ftime() - tstart, Error_Per_Call, Overhead_Per_Call, num_calls);
#endif
}

define profile_report (fp)
{
   if (typeof (fp) == String_Type)
     fp = fopen (fp, "w");

   variable keys = assoc_get_keys (Times);
   variable times = assoc_get_values (Times);
   variable n = length (times);

   variable rates = Float_Type[n];
   variable i;
   _for i (0, n-1, 1)
     {
	variable c = Counts[keys[i]];
	rates[i] = times[i]/c;
     }

   i = array_sort (times);
   i = i[[-1::-1]];

   times = times[i];
   rates = rates[i];
   keys = keys[i];

   variable total_counts = sum(assoc_get_values(Counts));
   () = fprintf (fp, "#Total Calls: %g, Profiler overhead: %g secs\n\n", 
		 total_counts, Overhead_Per_Call * total_counts);

   () = fprintf (fp, "#NCalls msecs/Call  Tot Secs  File:line\n");
   _for i (0, n-1, 1)
     {
	variable key = keys[i];
	variable t = Times[key];
	c = Counts[key];
	() = fprintf (fp, "%7d %10.6f %10.6f %s\n", 
		      Counts[key], rates[i]*1e3, times[i], key);
     }
}
	
provide ("profile");
