/* 
 * Copyright (C) 2003-2005 Ross Burton <ross@burtonini.com>
 *
 * Sound Juicer - sj-about.c
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Authors: Ross Burton <ross@burtonini.com>
 */

#include "sound-juicer.h"

#include <gtk/gtkaboutdialog.h>
#include <string.h>

void on_about_activate (void)
{
  static GtkWidget *win = NULL;
  GdkPixbuf *pixbuf;
  
  const gchar *authors[] = {
    "Ross Burton <ross@burtonini.com>",
    "And many others who have contributed patches.",
    NULL
  };
  const gchar *documentors[] = {
    "Shaun McCance <shaunm@gnome.org>",
    "Mike Hearn <mike@theoretic.com>",
    NULL
  };

  if (win != NULL) {
    gtk_window_present (GTK_WINDOW (win));
    return;
  }

  /* Don't care if the icon cannot be found */
  pixbuf = gtk_icon_theme_load_icon (gtk_icon_theme_get_default (), "sound-juicer", 128, 0, NULL);
  /* TODO: leaks theme */

  win = g_object_new (GTK_TYPE_ABOUT_DIALOG,
                      "name", _("Sound Juicer"),
                      "comments", _("An Audio CD Extractor"),
                      "version", VERSION,
                      "copyright", "Copyright \xc2\xa9 2003-2005 Ross Burton",
                      "authors", authors,
                      "documenters", documentors,
                      /*
                       * Note to translators: put here your name and email so it will show
                       * up in the "about" box
                       */
                      "translator-credits", _("translator-credits"),
                      "logo", pixbuf,
                      NULL);

  g_object_unref (pixbuf);
  
  g_signal_connect (win, "response", G_CALLBACK (gtk_widget_destroy), NULL);
  gtk_window_set_transient_for (GTK_WINDOW (win), GTK_WINDOW (main_window));
  gtk_window_set_destroy_with_parent (GTK_WINDOW (win), TRUE);
  
  g_object_add_weak_pointer (G_OBJECT (win), (gpointer) & win);
  
  gtk_window_present (GTK_WINDOW (win));
}
