//------------------------------------------------------------------------------
// GxB_SelectOp_new: create a new user-defined select operator
//------------------------------------------------------------------------------

// SuiteSparse:GraphBLAS, Timothy A. Davis, (c) 2017-2018, All Rights Reserved.
// http://suitesparse.com   See GraphBLAS/Doc/License.txt for license.

//------------------------------------------------------------------------------

// GxB_SelectOp_new is implemented both as a macro and a function.  Both are
// user-callable.  The macro is used by default since it can capture the name
// of the select function.

#include "GB.h"

// the macro version of this function must first be #undefined
#undef GxB_SelectOp_new

GrB_Info GxB_SelectOp_new       // create a new user-defined select operator
(
    GxB_SelectOp *selectop,     // handle for the new select operator
    void *function,             // pointer to the select function
    const GrB_Type xtype        // type of input x, or NULL if type-generic
)
{
    return (GB_SelectOp_new (selectop, function, xtype, "f")) ;
}

