/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 0



/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     ID = 258,
     HBLOCK = 259,
     POUND = 260,
     STRING = 261,
     INCLUDE = 262,
     IMPORT = 263,
     INSERT = 264,
     CHARCONST = 265,
     NUM_INT = 266,
     NUM_FLOAT = 267,
     NUM_UNSIGNED = 268,
     NUM_LONG = 269,
     NUM_ULONG = 270,
     NUM_LONGLONG = 271,
     NUM_ULONGLONG = 272,
     TYPEDEF = 273,
     TYPE_INT = 274,
     TYPE_UNSIGNED = 275,
     TYPE_SHORT = 276,
     TYPE_LONG = 277,
     TYPE_FLOAT = 278,
     TYPE_DOUBLE = 279,
     TYPE_CHAR = 280,
     TYPE_VOID = 281,
     TYPE_SIGNED = 282,
     TYPE_BOOL = 283,
     TYPE_TYPEDEF = 284,
     TYPE_RAW = 285,
     LPAREN = 286,
     RPAREN = 287,
     COMMA = 288,
     SEMI = 289,
     EXTERN = 290,
     INIT = 291,
     LBRACE = 292,
     RBRACE = 293,
     PERIOD = 294,
     CONST_QUAL = 295,
     VOLATILE = 296,
     STRUCT = 297,
     UNION = 298,
     EQUAL = 299,
     SIZEOF = 300,
     MODULE = 301,
     LBRACKET = 302,
     RBRACKET = 303,
     ILLEGAL = 304,
     CONSTANT = 305,
     NAME = 306,
     RENAME = 307,
     NAMEWARN = 308,
     EXTEND = 309,
     PRAGMA = 310,
     FEATURE = 311,
     VARARGS = 312,
     ENUM = 313,
     CLASS = 314,
     TYPENAME = 315,
     PRIVATE = 316,
     PUBLIC = 317,
     PROTECTED = 318,
     COLON = 319,
     STATIC = 320,
     VIRTUAL = 321,
     FRIEND = 322,
     THROW = 323,
     CATCH = 324,
     USING = 325,
     NAMESPACE = 326,
     NATIVE = 327,
     INLINE = 328,
     TYPEMAP = 329,
     EXCEPT = 330,
     ECHO = 331,
     APPLY = 332,
     CLEAR = 333,
     SWIGTEMPLATE = 334,
     FRAGMENT = 335,
     WARN = 336,
     LESSTHAN = 337,
     GREATERTHAN = 338,
     MODULO = 339,
     DELETE_KW = 340,
     TYPES = 341,
     PARMS = 342,
     NONID = 343,
     DSTAR = 344,
     DCNOT = 345,
     TEMPLATE = 346,
     OPERATOR = 347,
     COPERATOR = 348,
     PARSETYPE = 349,
     PARSEPARM = 350,
     CAST = 351,
     LOR = 352,
     LAND = 353,
     OR = 354,
     XOR = 355,
     AND = 356,
     RSHIFT = 357,
     LSHIFT = 358,
     MINUS = 359,
     PLUS = 360,
     SLASH = 361,
     STAR = 362,
     LNOT = 363,
     NOT = 364,
     UMINUS = 365,
     DCOLON = 366
   };
#endif
#define ID 258
#define HBLOCK 259
#define POUND 260
#define STRING 261
#define INCLUDE 262
#define IMPORT 263
#define INSERT 264
#define CHARCONST 265
#define NUM_INT 266
#define NUM_FLOAT 267
#define NUM_UNSIGNED 268
#define NUM_LONG 269
#define NUM_ULONG 270
#define NUM_LONGLONG 271
#define NUM_ULONGLONG 272
#define TYPEDEF 273
#define TYPE_INT 274
#define TYPE_UNSIGNED 275
#define TYPE_SHORT 276
#define TYPE_LONG 277
#define TYPE_FLOAT 278
#define TYPE_DOUBLE 279
#define TYPE_CHAR 280
#define TYPE_VOID 281
#define TYPE_SIGNED 282
#define TYPE_BOOL 283
#define TYPE_TYPEDEF 284
#define TYPE_RAW 285
#define LPAREN 286
#define RPAREN 287
#define COMMA 288
#define SEMI 289
#define EXTERN 290
#define INIT 291
#define LBRACE 292
#define RBRACE 293
#define PERIOD 294
#define CONST_QUAL 295
#define VOLATILE 296
#define STRUCT 297
#define UNION 298
#define EQUAL 299
#define SIZEOF 300
#define MODULE 301
#define LBRACKET 302
#define RBRACKET 303
#define ILLEGAL 304
#define CONSTANT 305
#define NAME 306
#define RENAME 307
#define NAMEWARN 308
#define EXTEND 309
#define PRAGMA 310
#define FEATURE 311
#define VARARGS 312
#define ENUM 313
#define CLASS 314
#define TYPENAME 315
#define PRIVATE 316
#define PUBLIC 317
#define PROTECTED 318
#define COLON 319
#define STATIC 320
#define VIRTUAL 321
#define FRIEND 322
#define THROW 323
#define CATCH 324
#define USING 325
#define NAMESPACE 326
#define NATIVE 327
#define INLINE 328
#define TYPEMAP 329
#define EXCEPT 330
#define ECHO 331
#define APPLY 332
#define CLEAR 333
#define SWIGTEMPLATE 334
#define FRAGMENT 335
#define WARN 336
#define LESSTHAN 337
#define GREATERTHAN 338
#define MODULO 339
#define DELETE_KW 340
#define TYPES 341
#define PARMS 342
#define NONID 343
#define DSTAR 344
#define DCNOT 345
#define TEMPLATE 346
#define OPERATOR 347
#define COPERATOR 348
#define PARSETYPE 349
#define PARSEPARM 350
#define CAST 351
#define LOR 352
#define LAND 353
#define OR 354
#define XOR 355
#define AND 356
#define RSHIFT 357
#define LSHIFT 358
#define MINUS 359
#define PLUS 360
#define SLASH 361
#define STAR 362
#define LNOT 363
#define NOT 364
#define UMINUS 365
#define DCOLON 366




/* Copy the first part of user declarations.  */
#line 1 "parser.y"

/* -----------------------------------------------------------------------------
 * parser.y
 *
 *     YACC parser for SWIG.   The grammar is a somewhat broken subset of C/C++.
 *     This file is a bit of a mess and probably needs to be rewritten at
 *     some point.  Beware.
 *
 * Author(s) : David Beazley (beazley@cs.uchicago.edu)
 *
 * Copyright (C) 1998-2001.  The University of Chicago
 * Copyright (C) 1995-1998.  The University of Utah and The Regents of the
 *                           University of California.
 *
 * See the file LICENSE for information on usage and redistribution.
 * ----------------------------------------------------------------------------- */

#define yylex yylex

char cvsroot_parser_y[] = "$Header: /cvsroot/swig/SWIG/Source/CParse/parser.y,v 1.55 2004/08/23 20:10:51 wsfulton Exp $";

#include "swig.h"
#include "cparse.h"
#include "preprocessor.h"
#include <ctype.h>

/* We do this for portability */
#undef alloca
#define alloca malloc

/* -----------------------------------------------------------------------------
 *                               Externals
 * ----------------------------------------------------------------------------- */

int  yyparse();

/* NEW Variables */

static Node    *top = 0;      /* Top of the generated parse tree */
static int      unnamed = 0;  /* Unnamed datatype counter */
static Hash    *extendhash = 0;     /* Hash table of added methods */
static Hash    *classes = 0;        /* Hash table of classes */
static Symtab  *prev_symtab = 0;
static Node    *current_class = 0;
       String  *ModuleName = 0;
static Node    *module_node = 0;
static String  *Classprefix = 0;  
static String  *Namespaceprefix = 0;
static int      inclass = 0;
static char    *last_cpptype = 0;
static int      inherit_list = 0;
static Parm    *template_parameters = 0;
static int      extendmode   = 0;
static int      dirprot_mode  = 0;

/* -----------------------------------------------------------------------------
 *                            Assist Functions
 * ----------------------------------------------------------------------------- */

/* Called by the parser (yyparse) when an error is found.*/
static void yyerror (const char *e) {
  (void)e;
}

static Node *new_node(const String_or_char *tag) {
  Node *n = NewHash();
  set_nodeType(n,tag);
  Setfile(n,cparse_file);
  Setline(n,cparse_line);
  return n;
}

/* Copies a node.  Does not copy tree links or symbol table data (except for
   sym:name) */

static Node *copy_node(Node *n) {
  Node *nn;
  String *key;
  Iterator k;
  nn = NewHash();
  Setfile(nn,Getfile(n));
  Setline(nn,Getline(n));
  for (k = First(n); k.key; k = Next(k)) {
    key = k.key;
    if ((Strcmp(key,"nextSibling") == 0) ||
	(Strcmp(key,"previousSibling") == 0) ||
	(Strcmp(key,"parentNode") == 0) ||
	(Strcmp(key,"lastChild") == 0)) {
      continue;
    }
    if (Strncmp(key,"csym:",5) == 0) continue;
    /* We do copy sym:name.  For templates */
    if ((Strcmp(key,"sym:name") == 0) || 
	(Strcmp(key,"sym:weak") == 0) ||
	(Strcmp(key,"sym:typename") == 0)) {
      Setattr(nn,key, Copy(k.item));
      continue;
    }
    if (Strcmp(key,"sym:symtab") == 0) {
      Setattr(nn,"sym:needs_symtab", "1");
    }
    /* We don't copy any other symbol table attributes */
    if (Strncmp(key,"sym:",4) == 0) {
      continue;
    }
    /* If children.  We copy them recursively using this function */
    if (Strcmp(key,"firstChild") == 0) {
      /* Copy children */
      Node *cn = k.item;
      while (cn) {
	appendChild(nn,copy_node(cn));
	cn = nextSibling(cn);
      }
      continue;
    }
    /* We don't copy the symbol table.  But we drop an attribute 
       requires_symtab so that functions know it needs to be built */

    if (Strcmp(key,"symtab") == 0) {
      /* Node defined a symbol table. */
      Setattr(nn,"requires_symtab","1");
      continue;
    }
    /* Can't copy nodes */
    if (Strcmp(key,"node") == 0) {
      continue;
    }
    if ((Strcmp(key,"parms") == 0) || (Strcmp(key,"pattern") == 0) || (Strcmp(key,"throws") == 0)
	|| (Strcmp(key,"kwargs") == 0)) {
      Setattr(nn,key,CopyParmList(k.item));
      continue;
    }
    /* Looks okay.  Just copy the data using Copy */
    Setattr(nn, key, Copy(k.item));
  }
  return nn;
}

/* -----------------------------------------------------------------------------
 *                              Variables
 * ----------------------------------------------------------------------------- */

      char  *typemap_lang = 0;    /* Current language setting */

static int cplus_mode  = 0;
static String  *class_rename = 0;

/* C++ modes */

#define  CPLUS_PUBLIC    1
#define  CPLUS_PRIVATE   2
#define  CPLUS_PROTECTED 3

void SWIG_typemap_lang(const char *tm_lang) {
  typemap_lang = Swig_copy_string(tm_lang);
}

/* -----------------------------------------------------------------------------
 *                           Assist functions
 * ----------------------------------------------------------------------------- */

/* Perform type-promotion for binary operators */
static int promote(int t1, int t2) {
  return t1 > t2 ? t1 : t2;
}

static String *yyrename = 0;

/* Forward renaming operator */
static Hash   *rename_hash = 0;
static Hash   *namewarn_hash = 0;
static Hash   *features_hash = 0;

static String *feature_identifier_fix(String *s) {
  if (SwigType_istemplate(s)) {
    String *tp, *ts, *ta, *tq;
    tp = SwigType_templateprefix(s);
    ts = SwigType_templatesuffix(s);
    ta = SwigType_templateargs(s);
    tq = Swig_symbol_type_qualify(ta,0);
    Append(tp,tq);
    Append(tp,ts);
    Delete(ts);
    Delete(ta);
    Delete(tq);
    return tp;
  } else {
    return NewString(s);
  }
}

static void
rename_add(char *name, SwigType *decl, char *newname) {
  String *nname;
  if (!rename_hash) rename_hash = NewHash();
  if (Namespaceprefix) {
    nname = NewStringf("%s::%s",Namespaceprefix, name);
  } else {
    nname = NewString(name);
  }
  Swig_name_object_set(rename_hash,nname,decl,NewString(newname));
  Delete(nname);
}

static void
namewarn_add(char *name, SwigType *decl, char *warning) {
  String *nname;
  if (!namewarn_hash) namewarn_hash = NewHash();
  if (Namespaceprefix) {
    nname = NewStringf("%s::%s",Namespaceprefix, name);
  } else {
    nname = NewString(name);
  }

  Swig_name_object_set(namewarn_hash,nname,decl,NewString(warning));
  Delete(nname);
}

static void
rename_inherit(String *base, String *derived) {
  /*  Printf(stdout,"base = '%s', derived = '%s'\n", base, derived); */
  Swig_name_object_inherit(rename_hash,base,derived);
  Swig_name_object_inherit(namewarn_hash,base,derived);
  Swig_name_object_inherit(features_hash,base,derived);
}

/* Generate the symbol table name for an object */
/* This is a bit of a mess. Need to clean up */
static String *add_oldname = 0;

static String *make_name(String *name,SwigType *decl) {
  String *rn = 0;
  String *origname = name;
  int     destructor = 0;

  if (name && (*(Char(name)) == '~')) {
    destructor = 1;
  }
  if (yyrename) {
    String *s = yyrename;
    yyrename = 0;
    if (destructor) {
      Insert(s,0,"~");
    }
    return s;
  }

  if (!name) return 0;
  /* Check to see if the name is in the hash */
  if (!rename_hash) {
    if (add_oldname) return Copy(add_oldname);
    return origname;
  }
  rn = Swig_name_object_get(rename_hash, Namespaceprefix, name, decl);
  if (!rn) {
    if (add_oldname) return Copy(add_oldname);
    return name;
  }
  if (destructor) {
    if (Strcmp(rn,"$ignore") != 0) {
      String *s = NewStringf("~%s", rn);
      return s;
    }
  }
  return Copy(rn);
}

/* Generate an unnamed identifier */
static String *make_unnamed() {
  unnamed++;
  return NewStringf("$unnamed%d$",unnamed);
}

/* Return the node name when it requires to emit a name warning */
static String *name_warning(Node *n,String *name,SwigType *decl) {
  /* Return in the obvious cases */
  if (!namewarn_hash || !name || !need_name_warning(n)) return 0;

  /* Check to see if the name is in the hash */
  return Swig_name_object_get(namewarn_hash,Namespaceprefix,name,decl);
}

/* Return if the node is a friend declaration */
static int is_friend(Node *n) {
 return Cmp(Getattr(n,"storage"),"friend") == 0;
}

/* Add declaration list to symbol table */
static int  add_only_one = 0;

static void add_symbols(Node *n) {
  String *decl;
  String *wrn = 0;
  if (inclass && n) {
    cparse_normalize_void(n);
  }
  while (n) {
    String *symname;
    /* for friends, we need to pop the scope once */
    int isfriend = is_friend(n);
    Symtab *class_scope = isfriend ? Swig_symbol_popscope() : 0;

    if (!isfriend && inclass && (cplus_mode != CPLUS_PUBLIC)) {
      int only_csymbol = 1;
      if (cplus_mode == CPLUS_PROTECTED) {
	Setattr(n,"access", "protected");
	only_csymbol = !need_protected(n, dirprot_mode);
      } else {
	/* private are needed only when they are pure virtuals */
	Setattr(n,"access", "private");
	if ((Cmp(Getattr(n,"storage"),"virtual") == 0) 
	    && (Cmp(Getattr(n,"value"),"0") == 0)) {
	  only_csymbol = !need_protected(n, dirprot_mode);
	}    
      }
      if (only_csymbol) {
	/* Only add to C symbol table and continue */
	Swig_symbol_add(0, n); 
	if (add_only_one) break;
	n = nextSibling(n);
	continue;
      }
    }
    if (Getattr(n,"sym:name")) {
      n = nextSibling(n);
      continue;
    }
    decl = Getattr(n,"decl");
    if (!SwigType_isfunction(decl)) {
      String *makename = Getattr(n,"parser:makename");
      if (makename) {
        Delattr(n,"parser:makename"); /* temporary information, don't leave it hanging around */
      } else {
        makename = Getattr(n,"name");
      }
      
      symname = make_name(makename,0);
      if (!symname) {
	symname = Getattr(n,"unnamed");
      }
      if (symname) {
	wrn = name_warning(n,symname,0);
	Swig_features_get(features_hash, Namespaceprefix, Getattr(n,"name"), 0, n);
      }
    } else {
      SwigType *fdecl = Copy(decl);
      SwigType *fun = SwigType_pop_function(fdecl);

      /* for friends, we need to disable the class prefix */
      String* class_prefix = isfriend ? Namespaceprefix : 0;
      if (isfriend) Namespaceprefix = 0;

      symname = make_name(Getattr(n,"name"),fun);
      wrn = name_warning(n,symname,fun);
      
      Swig_features_get(features_hash,Namespaceprefix,Getattr(n,"name"),fun,n);
      Delete(fdecl);
      Delete(fun);
      
      /* restore the class prefix if needed */
      if (isfriend) Namespaceprefix = class_prefix;
    }
    if (!symname) {
      n = nextSibling(n);
      continue;
    }
    if (strncmp(Char(symname),"$ignore",7) == 0) {
      char *c = Char(symname)+7;
      Setattr(n,"feature:ignore","1");
      if (strlen(c)) {
	Swig_warning(0,Getfile(n), Getline(n), "%s\n",c+1);
      }
      Swig_symbol_add(0, n);
    } else {
      Node *c;
      if ((wrn) && (Len(wrn))) {
	Swig_warning(0,Getfile(n),Getline(n), "%s\n", wrn);
      }
      c = Swig_symbol_add(symname,n);
      if (c != n) {
        if (Getattr(n,"sym:weak")) {
          Setattr(n,"sym:name",symname);
        } else if ((Strcmp(nodeType(n),"template") == 0) && (Strcmp(Getattr(n,"templatetype"),"cdecl") == 0)) {
          Setattr(n,"sym:name",symname);
        } else {
          String *e = NewString("");
          String *en = NewString("");
          String *ec = NewString("");
          int redefined = need_redefined_warn(n,c,inclass);
          if (redefined) {
            Printf(en,"Identifier '%s' redefined (ignored)",symname);
            Printf(ec,"previous definition of '%s'",symname);
          } else {
            Printf(en,"Redundant redeclaration of '%s'",symname);
            Printf(ec,"previous declaration of '%s'",symname);
          }
          if (Cmp(symname,Getattr(n,"name"))) {
            Printf(en," (Renamed from '%s')", SwigType_namestr(Getattr(n,"name")));
          }
          Printf(en,",");
          if (Cmp(symname,Getattr(c,"name"))) {
            Printf(ec," (Renamed from '%s')", SwigType_namestr(Getattr(c,"name")));
          }
          Printf(ec,".");
          if (redefined) {
            Swig_warning(WARN_PARSE_REDEFINED,Getfile(n),Getline(n),"%s\n",en);
            Swig_warning(WARN_PARSE_REDEFINED,Getfile(c),Getline(c),"%s\n",ec);
          } else if (!is_friend(n) && !is_friend(c)) {
            Swig_warning(WARN_PARSE_REDUNDANT,Getfile(n),Getline(n),"%s\n",en);
            Swig_warning(WARN_PARSE_REDUNDANT,Getfile(c),Getline(c),"%s\n",ec);
          }
          Printf(e,"%s:%d:%s\n%s:%d:%s\n",Getfile(n),Getline(n),en,
                 Getfile(c),Getline(c),ec);
          Setattr(n,"error",e);
          Delete(en);
          Delete(ec);
        }
      }
    }
    /* restore the class scope if needed */
    if (isfriend) Swig_symbol_setscope(class_scope);

    if (add_only_one) return;
    n = nextSibling(n);
  }
}


/* add symbols a parse tree node copy */

void add_symbols_copy(Node *n) {
  String *name;
  int    emode = 0;

  while (n) {

    if (Strcmp(nodeType(n),"access") == 0) {
      String *kind = Getattr(n,"kind");
      if (Strcmp(kind,"public") == 0) {
	cplus_mode = CPLUS_PUBLIC;
      } else if (Strcmp(kind,"private") == 0) {
	cplus_mode = CPLUS_PRIVATE;
      } else if (Strcmp(kind,"protected") == 0) {
	cplus_mode = CPLUS_PROTECTED;
      }
      n = nextSibling(n);
      continue;
    }

    add_oldname = Getattr(n,"sym:name");
    if ((add_oldname) || (Getattr(n,"sym:needs_symtab"))) {
      if (add_oldname) {
	DohIncref(add_oldname);
	/* If already renamed, we used that name */
	if (Strcmp(add_oldname, Getattr(n,"name")) != 0) {
	  yyrename = add_oldname;
	}
      }
      Delattr(n,"sym:needs_symtab");
      Delattr(n,"sym:name");

      add_only_one = 1;
      add_symbols(n);

      if (Getattr(n,"partialargs")) {
	Swig_symbol_cadd(Getattr(n,"partialargs"),n);
      }
      add_only_one = 0;
      name = Getattr(n,"name");
      if (Getattr(n,"requires_symtab")) {
	Swig_symbol_newscope();
	Swig_symbol_setscopename(name);
	Namespaceprefix = Swig_symbol_qualifiedscopename(0);
      }
      if (Strcmp(nodeType(n),"class") == 0) {
	inclass = 1;
	if (Strcmp(Getattr(n,"kind"),"class") == 0) {
	  cplus_mode = CPLUS_PRIVATE;
	} else {
	  cplus_mode = CPLUS_PUBLIC;
	}
      }
      if (Strcmp(nodeType(n),"extend") == 0) {
	emode = cplus_mode;
	cplus_mode = CPLUS_PUBLIC;
      }
      add_symbols_copy(firstChild(n));
      if (Strcmp(nodeType(n),"extend") == 0) {
	cplus_mode = emode;
      }
      if (Getattr(n,"requires_symtab")) {
	Setattr(n,"symtab", Swig_symbol_popscope());
	Delattr(n,"requires_symtab");
	Namespaceprefix = Swig_symbol_qualifiedscopename(0);
      }
      if (add_oldname) {
	Delete(add_oldname);
      }
      if (Strcmp(nodeType(n),"class") == 0) {
	inclass = 0;
      }
      add_oldname = 0;
    } else {
      if (Strcmp(nodeType(n),"extend") == 0) {
	emode = cplus_mode;
	cplus_mode = CPLUS_PUBLIC;
      }
      add_symbols_copy(firstChild(n));
      if (Strcmp(nodeType(n),"extend") == 0) {
	cplus_mode = emode;
      }
    }
    n = nextSibling(n);
  }
}

/* Extension merge.  This function is used to handle the %extend directive
   when it appears before a class definition.   To handle this, the %extend
   actually needs to take precedence.  Therefore, we will selectively nuke symbols
   from the current symbol table, replacing them with the added methods */

static void merge_extensions(Node *cls, Node *am) {
  Node *n;
  Node *csym;

  n = firstChild(am);
  while (n) {
    String *symname;
    if (Strcmp(nodeType(n),"constructor") == 0) {
      symname = Getattr(n,"sym:name");
      if (symname) {
	if (Strcmp(symname,Getattr(n,"name")) == 0) {
	  /* If the name and the sym:name of a constructor are the same,
             then it hasn't been renamed.  However---the name of the class
             itself might have been renamed so we need to do a consistency
             check here */
	  if (Getattr(cls,"sym:name")) {
	    Setattr(n,"sym:name", Getattr(cls,"sym:name"));
	  }
	}
      } 
    }

    symname = Getattr(n,"sym:name");
    DohIncref(symname);
    if ((symname) && (!Getattr(n,"error"))) {
      /* Remove node from its symbol table */
      Swig_symbol_remove(n);
      csym = Swig_symbol_add(symname,n);
      if (csym != n) {
	/* Conflict with previous definition.  Nuke previous definition */
	String *e = NewString("");
	String *en = NewString("");
	String *ec = NewString("");
	Printf(ec,"Identifier '%s' redefined by %%extend (ignored),",symname);
	Printf(en,"%%extend definition of '%s'.",symname);
	Swig_warning(WARN_PARSE_REDEFINED,Getfile(csym),Getline(csym),"%s\n",ec);
	Swig_warning(WARN_PARSE_REDEFINED,Getfile(n),Getline(n),"%s\n",en);
	Printf(e,"%s:%d:%s\n%s:%d:%s\n",Getfile(csym),Getline(csym),ec, 
	       Getfile(n),Getline(n),en);
	Setattr(csym,"error",e);
	Delete(en);
	Delete(ec);
	Swig_symbol_remove(csym);              /* Remove class definition */
	Swig_symbol_add(symname,n);            /* Insert extend definition */
      }
    }
    n = nextSibling(n);
  }
}

/* Check for unused %extend.  Special case, don't report unused
   extensions for templates */
 
 static void check_extensions() {
   Iterator ki;

   if (!extendhash) return;
   for (ki = First(extendhash); ki.key; ki = Next(ki)) {
     if (!Strstr(ki.key,"<")) {
       Swig_warning(WARN_PARSE_EXTEND_UNDEF,Getfile(ki.item), Getline(ki.item), "%%extend defined for an undeclared class %s.\n", ki.key);
     }
   }
 }

/* Check a set of declarations to see if any are pure-abstract */

 static List *pure_abstract(Node *n) {
   List *abs = 0;
   while (n) {
     if (Cmp(nodeType(n),"cdecl") == 0) {
       String *decl = Getattr(n,"decl");
       if (SwigType_isfunction(decl)) {
	 String *init = Getattr(n,"value");
	 if (Cmp(init,"0") == 0) {
	   if (!abs) {
	     abs = NewList();
	   }
	   Append(abs,n);
	   Setattr(n,"abstract","1");
	 }
       }
     } else if (Cmp(nodeType(n),"destructor") == 0) {
       if (Cmp(Getattr(n,"value"),"0") == 0) {
	 if (!abs) {
	   abs = NewList();
	 }
	 Append(abs,n);
	 Setattr(n,"abstract","1");
       }
     }
     n = nextSibling(n);
   }
   return abs;
 }

 /* Make a classname */

 static String *make_class_name(String *name) {
   String *nname = 0;
   if (Namespaceprefix) {
     nname= NewStringf("%s::%s", Namespaceprefix, name);
   } else {
     nname = NewString(name);
   }
   if (SwigType_istemplate(nname)) {
     String *prefix, *args, *qargs;
     prefix = SwigType_templateprefix(nname);
     args   = SwigType_templateargs(nname);
     qargs  = Swig_symbol_type_qualify(args,0);
     Append(prefix,qargs);
     Delete(nname);
     nname = prefix;
   }
   return nname;
 }

 static List *make_inherit_list(String *clsname, List *names) {
   int i;
   String *derived;
   List *bases = NewList();

   if (Namespaceprefix) derived = NewStringf("%s::%s", Namespaceprefix,clsname);
   else derived = NewString(clsname);

   for (i = 0; i < Len(names); i++) {
     Node *s;
     String *base;
     String *n = Getitem(names,i);
     /* Try to figure out where this symbol is */
     s = Swig_symbol_clookup(n,0);
     if (s) {
       while (s && (Strcmp(nodeType(s),"class") != 0)) {
	 /* Not a class.  Could be a typedef though. */
	 String *storage = Getattr(s,"storage");
	 if (storage && (Strcmp(storage,"typedef") == 0)) {
	   String *nn = Getattr(s,"type");
	   s = Swig_symbol_clookup(nn,Getattr(s,"sym:symtab"));
	 } else {
	   break;
	 }
       }
       if (s && ((Strcmp(nodeType(s),"class") == 0) || (Strcmp(nodeType(s),"template") == 0))) {
	 String *q = Swig_symbol_qualified(s);
	 Append(bases,s);
	 if (q) {
	   base = NewStringf("%s::%s", q, Getattr(s,"name"));
	 } else {
	   base = NewString(Getattr(s,"name"));
	 }
       } else {
	 base = NewString(n);
       }
     } else {
       base = NewString(n);
     }
     if (base) {
       rename_inherit(base,derived);
       Delete(base);
     }
   }
   return bases;
 }

/* Structures for handling code fragments built for nested classes */

typedef struct Nested {
  String   *code;        /* Associated code fragment */
  int      line;         /* line number where it starts */
  char     *name;        /* Name associated with this nested class */
  char     *kind;        /* Kind of class */
  SwigType *type;        /* Datatype associated with the name */
  struct Nested   *next;        /* Next code fragment in list */
} Nested;

/* Some internal variables for saving nested class information */

static Nested      *nested_list = 0;

/* Add a function to the nested list */

static void add_nested(Nested *n) {
  Nested *n1;
  if (!nested_list) nested_list = n;
  else {
    n1 = nested_list;
    while (n1->next) n1 = n1->next;
    n1->next = n;
  }
}

/* Dump all of the nested class declarations to the inline processor
 * However.  We need to do a few name replacements and other munging
 * first.  This function must be called before closing a class! */

static Node *dump_nested(char *parent) {
  Nested *n,*n1;
  Node *ret = 0;
  n = nested_list;
  if (!parent) {
    nested_list = 0;
    return 0;
  }
  while (n) {
    char temp[256];
    Node *retx;
    /* Token replace the name of the parent class */
    Replace(n->code, "$classname", parent, DOH_REPLACE_ANY);
    /* Fix up the name of the datatype (for building typedefs and other stuff) */
    sprintf(temp,"%s_%s", parent,n->name);

    Append(n->type,parent);
    Append(n->type,"_");
    Append(n->type,n->name);

    /* Add the appropriate declaration to the C++ processor */
    retx = new_node("cdecl");
    Setattr(retx,"name",n->name);
    Setattr(retx,"type",Copy(n->type));
    Setattr(retx,"nested",parent);
    add_symbols(retx);
    if (ret) {
      set_nextSibling(retx,ret);
    }
    ret = retx;

    /* Insert a forward class declaration */
    /* Disabled: [ 597599 ] union in class: incorrect scope 
    retx = new_node("classforward");
    Setattr(retx,"kind",n->kind);
    Setattr(retx,"name",Copy(n->type));
    Setattr(retx,"sym:name", make_name(n->type,0));
    set_nextSibling(retx,ret);
    ret = retx; 
    */

    /* Make all SWIG created typedef structs/unions/classes unnamed else 
       redefinition errors occur - nasty hack alert.*/

    {
      const char* types_array[3] = {"struct", "union", "class"};
      int i;
      for (i=0; i<3; i++) {
	char* code_ptr = Char(n->code);
      while (code_ptr) {
        /* Replace struct name (as in 'struct name {' ) with whitespace
           name will be between struct and { */
	
        code_ptr = strstr(code_ptr, types_array[i]);
        if (code_ptr) {
	  char *open_bracket_pos;
          code_ptr += strlen(types_array[i]);
          open_bracket_pos = strstr(code_ptr, "{");
          if (open_bracket_pos) { 
            /* Make sure we don't have something like struct A a; */
            char* semi_colon_pos = strstr(code_ptr, ";");
            if (!(semi_colon_pos && (semi_colon_pos < open_bracket_pos)))
              while (code_ptr < open_bracket_pos)
                *code_ptr++ = ' ';
          }
        }
      }
      }
    }
    
    {
      /* Remove SWIG directive %constant which may be left in the SWIG created typedefs */
      char* code_ptr = Char(n->code);
      while (code_ptr) {
	code_ptr = strstr(code_ptr, "%constant");
	if (code_ptr) {
	  char* directive_end_pos = strstr(code_ptr, ";");
	  if (directive_end_pos) { 
            while (code_ptr <= directive_end_pos)
              *code_ptr++ = ' ';
	  }
	}
      }
    }
    {
      Node *head;
      head = new_node("insert");
      Setattr(head,"code",NewStringf("\n%s\n",n->code));
      set_nextSibling(head,ret);
      ret = head;
    }
      
    /* Dump the code to the scanner */
    start_inline(Char(n->code),n->line);

    n1 = n->next;
    Delete(n->code);
    free(n);
    n = n1;
  }
  nested_list = 0;
  return ret;
}

Node *Swig_cparse(File *f) {
  scanner_file(f);
  top = 0;
  yyparse();
  return top;
}

static void new_feature(const char *featurename, String *val, Hash *featureattribs, char *declaratorid, SwigType *t, ParmList *declaratorparms, String *qualifier) {
  String *fname;
  String *name;
  String *fixname;
  if (!features_hash) features_hash = NewHash();
  fname = NewStringf("feature:%s",featurename);
  if (declaratorid) {
    fixname = feature_identifier_fix(declaratorid);
  } else {
    fixname = NewString("");
  }
  if (Namespaceprefix) {
   name = NewStringf("%s::%s",Namespaceprefix, fixname);
  } else {
   name = fixname;
  }
  if (declaratorparms) {
   Setmeta(val,"parms",declaratorparms);
  }
  if (declaratorparms) Setmeta(val,"parms",declaratorparms);
  if (!Len(t)) t = 0;
  if (t) {
   if (qualifier) SwigType_push(t,qualifier);
   if (SwigType_isfunction(t)) {
     SwigType *decl = SwigType_pop_function(t);
     if (SwigType_ispointer(t)) {
       String *nname = NewStringf("*%s",name);
       Swig_feature_set(features_hash, nname, decl, fname, val, featureattribs);
       Delete(nname);
     } else {
       Swig_feature_set(features_hash, name, decl, fname, val, featureattribs);
     }
   } else if (SwigType_ispointer(t)) {
     String *nname = NewStringf("*%s",name);
     Swig_feature_set(features_hash,nname,0,fname,val, featureattribs);
     Delete(nname);
   }
  } else {
   /* Global feature, that is, feature not associated with any particular symbol */
   Swig_feature_set(features_hash,name,0,fname,val, featureattribs);
  }
  Delete(fname);
  Delete(name);
}



/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 874 "parser.y"
typedef union YYSTYPE {
  char  *id;
  List  *bases;
  struct Define {
    String *val;
    String *rawval;
    int     type;
    String *qualifier;
    String *bitfield;
    Parm   *throws;
  } dtype;
  struct {
    char *type;
    char *filename;
    int   line;
  } loc;
  struct {
    char      *id;
    SwigType  *type;
    String    *defarg;
    ParmList  *parms;
    short      have_parms;
    ParmList  *throws;
  } decl;
  Parm         *tparms;
  struct {
    String     *op;
    Hash       *kwargs;
  } tmap;
  struct {
    String     *type;
    String     *us;
  } ptype;
  SwigType     *type;
  String       *str;
  Parm         *p;
  ParmList     *pl;
  int           ivalue;
  Node         *node;
} YYSTYPE;
/* Line 191 of yacc.c.  */
#line 1211 "y.tab.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif



/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1223 "y.tab.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
  };

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE))				\
      + YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  44
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   3488

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  112
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  141
/* YYNRULES -- Number of rules. */
#define YYNRULES  437
/* YYNRULES -- Number of states. */
#define YYNSTATES  848

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   366

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned char yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     9,    12,    16,    19,    22,    24,
      26,    28,    30,    32,    34,    36,    39,    41,    43,    45,
      47,    49,    51,    53,    55,    57,    59,    61,    63,    65,
      67,    69,    71,    73,    75,    77,    79,    81,    82,    90,
      96,   100,   106,   112,   116,   119,   122,   128,   131,   137,
     140,   145,   147,   149,   157,   165,   171,   172,   180,   182,
     184,   187,   190,   192,   198,   204,   210,   214,   219,   223,
     231,   240,   246,   250,   252,   254,   258,   260,   265,   273,
     280,   282,   284,   292,   302,   311,   322,   328,   336,   343,
     352,   354,   356,   362,   367,   373,   381,   383,   387,   394,
     401,   410,   412,   415,   419,   421,   424,   428,   435,   441,
     451,   454,   456,   458,   460,   466,   472,   474,   479,   481,
     483,   486,   492,   499,   504,   512,   521,   528,   530,   532,
     534,   536,   538,   540,   541,   551,   552,   561,   563,   566,
     571,   572,   579,   583,   585,   587,   589,   591,   593,   595,
     599,   604,   605,   612,   613,   619,   625,   628,   629,   636,
     638,   639,   643,   645,   647,   649,   651,   653,   655,   657,
     659,   663,   665,   667,   669,   671,   673,   675,   677,   679,
     681,   688,   695,   703,   712,   721,   729,   735,   738,   741,
     744,   745,   753,   754,   761,   763,   765,   767,   769,   771,
     773,   775,   777,   779,   781,   783,   785,   787,   790,   793,
     796,   801,   804,   810,   812,   815,   817,   819,   821,   823,
     825,   827,   830,   832,   836,   838,   841,   848,   852,   854,
     857,   859,   863,   865,   867,   869,   871,   874,   878,   881,
     884,   886,   889,   892,   894,   896,   898,   900,   903,   907,
     909,   912,   916,   921,   927,   932,   934,   937,   941,   946,
     952,   956,   961,   966,   968,   971,   976,   981,   987,   991,
     996,  1001,  1003,  1006,  1009,  1013,  1015,  1018,  1020,  1023,
    1027,  1032,  1036,  1041,  1044,  1048,  1052,  1057,  1061,  1065,
    1068,  1071,  1073,  1075,  1078,  1080,  1082,  1084,  1087,  1089,
    1091,  1093,  1095,  1098,  1101,  1103,  1106,  1108,  1111,  1113,
    1115,  1118,  1120,  1122,  1124,  1126,  1128,  1130,  1132,  1134,
    1135,  1138,  1140,  1142,  1144,  1148,  1150,  1152,  1156,  1158,
    1160,  1162,  1164,  1166,  1172,  1174,  1176,  1180,  1185,  1191,
    1197,  1204,  1206,  1208,  1210,  1212,  1214,  1216,  1218,  1222,
    1226,  1230,  1234,  1238,  1242,  1246,  1250,  1254,  1258,  1262,
    1265,  1268,  1271,  1274,  1277,  1279,  1280,  1284,  1286,  1288,
    1292,  1295,  1300,  1302,  1304,  1306,  1308,  1310,  1312,  1314,
    1316,  1318,  1320,  1325,  1331,  1333,  1337,  1341,  1346,  1351,
    1355,  1358,  1360,  1362,  1366,  1369,  1373,  1375,  1377,  1379,
    1381,  1383,  1386,  1391,  1393,  1397,  1399,  1403,  1407,  1410,
    1413,  1416,  1419,  1422,  1427,  1429,  1433,  1435,  1439,  1443,
    1446,  1449,  1452,  1455,  1457,  1459,  1461,  1463,  1467,  1469,
    1473,  1479,  1481,  1485,  1489,  1495,  1497,  1499
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     113,     0,    -1,   114,    -1,    94,   195,    34,    -1,    94,
       1,    -1,    95,   195,    34,    -1,    95,     1,    -1,   114,
     115,    -1,   252,    -1,   116,    -1,   153,    -1,   160,    -1,
      34,    -1,     1,    -1,   159,    -1,     1,    93,    -1,   117,
      -1,   119,    -1,   120,    -1,   121,    -1,   122,    -1,   123,
      -1,   126,    -1,   127,    -1,   130,    -1,   131,    -1,   132,
      -1,   133,    -1,   134,    -1,   135,    -1,   138,    -1,   140,
      -1,   143,    -1,   145,    -1,   150,    -1,   151,    -1,   152,
      -1,    -1,    54,   249,   242,    37,   118,   174,    38,    -1,
      77,   149,    37,   147,    38,    -1,    78,   147,    34,    -1,
      50,     3,    44,   217,    34,    -1,    50,   211,   203,   200,
      34,    -1,    50,     1,    34,    -1,    76,     4,    -1,    76,
     247,    -1,    75,    31,     3,    32,    37,    -1,    75,    37,
      -1,    75,    31,     3,    32,    34,    -1,    75,    34,    -1,
     247,    37,   211,    38,    -1,   247,    -1,   124,    -1,    80,
      31,   125,    33,   250,    32,     4,    -1,    80,    31,   125,
      33,   250,    32,    37,    -1,    80,    31,   125,    32,    34,
      -1,    -1,   129,   249,   247,    47,   128,   114,    48,    -1,
       7,    -1,     8,    -1,    73,     4,    -1,    73,    37,    -1,
       4,    -1,     9,    31,   240,    32,   247,    -1,     9,    31,
     240,    32,     4,    -1,     9,    31,   240,    32,    37,    -1,
      46,   249,   240,    -1,    51,    31,   240,    32,    -1,    51,
      31,    32,    -1,    72,    31,     3,    32,   191,     3,    34,
      -1,    72,    31,     3,    32,   191,   211,   203,    34,    -1,
      55,   137,     3,    44,   136,    -1,    55,   137,     3,    -1,
     247,    -1,     4,    -1,    31,     3,    32,    -1,   252,    -1,
     139,   203,   240,    34,    -1,   139,    31,   240,    32,   203,
     234,    34,    -1,   139,    31,   240,    32,   247,    34,    -1,
      52,    -1,    53,    -1,    56,    31,   240,    32,   203,   234,
     141,    -1,    56,    31,   240,    33,   251,    32,   203,   234,
      34,    -1,    56,    31,   240,   142,    32,   203,   234,   141,
      -1,    56,    31,   240,    33,   251,   142,    32,   203,   234,
      34,    -1,    56,    31,   240,    32,   141,    -1,    56,    31,
     240,    33,   251,    32,    34,    -1,    56,    31,   240,   142,
      32,   141,    -1,    56,    31,   240,    33,   251,   142,    32,
      34,    -1,   248,    -1,    34,    -1,    87,    31,   192,    32,
      34,    -1,    33,   240,    44,   251,    -1,    33,   240,    44,
     251,   142,    -1,    57,    31,   144,    32,   203,   234,    34,
      -1,   192,    -1,    11,    33,   195,    -1,    74,    31,   146,
      32,   147,   248,    -1,    74,    31,   146,    32,   147,    34,
      -1,    74,    31,   146,    32,   147,    44,   149,    34,    -1,
     250,    -1,   149,   148,    -1,    33,   149,   148,    -1,   252,
      -1,   211,   202,    -1,    31,   192,    32,    -1,    31,   192,
      32,    31,   192,    32,    -1,    86,    31,   192,    32,    34,
      -1,    79,    31,   241,    32,   245,    82,   196,    83,    34,
      -1,    81,   247,    -1,   154,    -1,   158,    -1,   157,    -1,
      35,   247,    37,   114,    38,    -1,   191,   211,   203,   156,
     155,    -1,    34,    -1,    33,   203,   156,   155,    -1,    37,
      -1,   200,    -1,   209,   200,    -1,    68,    31,   192,    32,
     200,    -1,   209,    68,    31,   192,    32,   200,    -1,   191,
      58,     3,    34,    -1,   191,    58,   219,    37,   220,    38,
      34,    -1,   191,    58,   219,    37,   220,    38,   203,   155,
      -1,   191,   211,    31,   192,    32,   235,    -1,   161,    -1,
     165,    -1,   166,    -1,   170,    -1,   171,    -1,   181,    -1,
      -1,   191,   232,   242,   226,    37,   162,   174,    38,   164,
      -1,    -1,   191,   232,    37,   163,   174,    38,   203,   155,
      -1,    34,    -1,   203,   155,    -1,   191,   232,   242,    34,
      -1,    -1,    91,    82,   169,    83,   167,   168,    -1,    91,
     232,   242,    -1,   154,    -1,   161,    -1,   178,    -1,   166,
      -1,   165,    -1,   193,    -1,    70,   242,    34,    -1,    70,
      71,   242,    34,    -1,    -1,    71,   242,    37,   172,   114,
      38,    -1,    -1,    71,    37,   173,   114,    38,    -1,    71,
       3,    44,   242,    34,    -1,   177,   174,    -1,    -1,    54,
      37,   175,   174,    38,   174,    -1,   252,    -1,    -1,     1,
     176,   174,    -1,   153,    -1,   178,    -1,   179,    -1,   182,
      -1,   187,    -1,   180,    -1,   165,    -1,   183,    -1,   191,
     242,    34,    -1,   170,    -1,   166,    -1,   181,    -1,   151,
      -1,   152,    -1,   190,    -1,   126,    -1,   150,    -1,    34,
      -1,   191,   211,    31,   192,    32,   235,    -1,   109,   244,
      31,   192,    32,   188,    -1,    66,   109,   244,    31,   192,
      32,   189,    -1,   191,    93,   211,   208,    31,   192,    32,
     189,    -1,   191,    93,   211,   101,    31,   192,    32,   189,
      -1,   191,    93,   211,    31,   192,    32,   189,    -1,    69,
      31,   192,    32,    37,    -1,    62,    64,    -1,    61,    64,
      -1,    63,    64,    -1,    -1,   191,   232,     3,    37,   184,
     186,    34,    -1,    -1,   191,   232,    37,   185,   186,    34,
      -1,   203,    -1,   252,    -1,   135,    -1,   121,    -1,   133,
      -1,   138,    -1,   140,    -1,   143,    -1,   131,    -1,   145,
      -1,   119,    -1,   120,    -1,   122,    -1,   234,    34,    -1,
     234,    37,    -1,   234,    34,    -1,   234,    44,   217,    34,
      -1,   234,    37,    -1,   191,   211,    64,    11,    34,    -1,
      35,    -1,    35,   247,    -1,    65,    -1,    18,    -1,    66,
      -1,    67,    -1,   252,    -1,   193,    -1,   195,   194,    -1,
     252,    -1,    33,   195,   194,    -1,   252,    -1,   212,   201,
      -1,    91,    82,   232,    83,   232,   242,    -1,    39,    39,
      39,    -1,   197,    -1,   199,   198,    -1,   252,    -1,    33,
     199,   198,    -1,   252,    -1,   195,    -1,   224,    -1,     6,
      -1,    44,   217,    -1,    44,   101,   203,    -1,    44,    37,
      -1,    64,    11,    -1,   252,    -1,   203,   200,    -1,   206,
     200,    -1,   200,    -1,   203,    -1,   206,    -1,   252,    -1,
     208,   204,    -1,   208,   101,   204,    -1,   205,    -1,   101,
     204,    -1,   242,    89,   204,    -1,   208,   242,    89,   204,
      -1,   208,   242,    89,   101,   204,    -1,   242,    89,   101,
     204,    -1,   242,    -1,   109,   242,    -1,    31,   242,    32,
      -1,    31,   208,   204,    32,    -1,    31,   242,    89,   204,
      32,    -1,   204,    47,    48,    -1,   204,    47,   223,    48,
      -1,   204,    31,   192,    32,    -1,   242,    -1,   109,   242,
      -1,    31,   208,   205,    32,    -1,    31,   101,   205,    32,
      -1,    31,   242,    89,   205,    32,    -1,   205,    47,    48,
      -1,   205,    47,   223,    48,    -1,   205,    31,   192,    32,
      -1,   208,    -1,   208,   207,    -1,   208,   101,    -1,   208,
     101,   207,    -1,   207,    -1,   101,   207,    -1,   101,    -1,
     242,    89,    -1,   208,   242,    89,    -1,   208,   242,    89,
     207,    -1,   207,    47,    48,    -1,   207,    47,   223,    48,
      -1,    47,    48,    -1,    47,   223,    48,    -1,    31,   206,
      32,    -1,   207,    31,   192,    32,    -1,    31,   192,    32,
      -1,   107,   209,   208,    -1,   107,   208,    -1,   107,   209,
      -1,   107,    -1,   210,    -1,   210,   209,    -1,    40,    -1,
      41,    -1,   212,    -1,   209,   213,    -1,   213,    -1,   214,
      -1,    28,    -1,    26,    -1,    29,   239,    -1,    58,   242,
      -1,    30,    -1,   213,   209,    -1,   242,    -1,   232,   242,
      -1,   215,    -1,   216,    -1,   216,   215,    -1,    19,    -1,
      21,    -1,    22,    -1,    25,    -1,    23,    -1,    24,    -1,
      27,    -1,    20,    -1,    -1,   218,   223,    -1,    10,    -1,
       3,    -1,   252,    -1,   220,    33,   221,    -1,   221,    -1,
       3,    -1,     3,    44,   222,    -1,   252,    -1,   223,    -1,
      10,    -1,   224,    -1,   247,    -1,    45,    31,   211,   201,
      32,    -1,   225,    -1,   211,    -1,    31,   223,    32,    -1,
      31,   223,    32,   223,    -1,    31,   223,   208,    32,   223,
      -1,    31,   223,   101,    32,   223,    -1,    31,   223,   208,
     101,    32,   223,    -1,    11,    -1,    12,    -1,    13,    -1,
      14,    -1,    15,    -1,    16,    -1,    17,    -1,   223,   105,
     223,    -1,   223,   104,   223,    -1,   223,   107,   223,    -1,
     223,   106,   223,    -1,   223,   101,   223,    -1,   223,    99,
     223,    -1,   223,   100,   223,    -1,   223,   103,   223,    -1,
     223,   102,   223,    -1,   223,    98,   223,    -1,   223,    97,
     223,    -1,   104,   223,    -1,   105,   223,    -1,   109,   223,
      -1,   108,   223,    -1,   211,    31,    -1,   227,    -1,    -1,
      64,   228,   229,    -1,   252,    -1,   230,    -1,   229,    33,
     230,    -1,   233,   242,    -1,   233,   231,   233,   242,    -1,
      62,    -1,    61,    -1,    63,    -1,    59,    -1,    42,    -1,
      43,    -1,    60,    -1,    66,    -1,   252,    -1,   209,    -1,
      68,    31,   192,    32,    -1,   209,    68,    31,   192,    32,
      -1,   252,    -1,   234,   236,    34,    -1,   234,   236,    37,
      -1,    31,   192,    32,    34,    -1,    31,   192,    32,    37,
      -1,    44,   217,    34,    -1,    64,   237,    -1,   252,    -1,
     238,    -1,   237,    33,   238,    -1,   242,    31,    -1,    82,
     196,    83,    -1,   252,    -1,     3,    -1,   247,    -1,   240,
      -1,   252,    -1,   244,   243,    -1,    88,   111,   244,   243,
      -1,   244,    -1,    88,   111,   244,    -1,    92,    -1,    88,
     111,    92,    -1,   111,   244,   243,    -1,   111,   244,    -1,
     111,    92,    -1,    90,   244,    -1,     3,   239,    -1,     3,
     246,    -1,    88,   111,     3,   246,    -1,     3,    -1,    88,
     111,     3,    -1,    92,    -1,    88,   111,    92,    -1,   111,
       3,   246,    -1,   111,     3,    -1,   111,    92,    -1,    90,
       3,    -1,   247,     6,    -1,     6,    -1,   247,    -1,    37,
      -1,     4,    -1,    31,   250,    32,    -1,   252,    -1,   240,
      44,   251,    -1,   240,    44,   251,    33,   250,    -1,   240,
      -1,   240,    33,   250,    -1,   240,    44,   124,    -1,   240,
      44,   124,    33,   250,    -1,   247,    -1,   224,    -1,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,  1018,  1018,  1030,  1033,  1036,  1039,  1044,  1048,  1053,
    1054,  1055,  1056,  1057,  1069,  1085,  1095,  1096,  1097,  1098,
    1099,  1100,  1101,  1102,  1103,  1104,  1105,  1106,  1107,  1108,
    1109,  1110,  1111,  1112,  1113,  1114,  1115,  1122,  1122,  1194,
    1204,  1215,  1234,  1256,  1267,  1276,  1295,  1301,  1307,  1312,
    1323,  1330,  1334,  1339,  1348,  1360,  1373,  1373,  1400,  1401,
    1408,  1428,  1455,  1459,  1469,  1474,  1489,  1505,  1509,  1521,
    1527,  1553,  1559,  1566,  1567,  1570,  1571,  1579,  1590,  1634,
    1645,  1648,  1675,  1680,  1685,  1690,  1697,  1702,  1707,  1712,
    1719,  1720,  1721,  1724,  1729,  1739,  1775,  1776,  1805,  1817,
    1825,  1838,  1860,  1866,  1870,  1873,  1881,  1886,  1898,  1908,
    2158,  2168,  2174,  2175,  2179,  2195,  2248,  2252,  2271,  2277,
    2282,  2287,  2292,  2304,  2319,  2330,  2398,  2445,  2446,  2447,
    2448,  2449,  2450,  2456,  2456,  2589,  2589,  2684,  2685,  2697,
    2715,  2715,  2928,  2934,  2937,  2940,  2943,  2946,  2951,  2983,
    2989,  3016,  3016,  3043,  3043,  3063,  3090,  3104,  3104,  3114,
    3115,  3115,  3135,  3136,  3150,  3151,  3152,  3153,  3154,  3155,
    3156,  3157,  3158,  3159,  3160,  3161,  3162,  3163,  3164,  3165,
    3174,  3195,  3211,  3244,  3258,  3275,  3293,  3300,  3307,  3315,
    3338,  3338,  3367,  3367,  3394,  3395,  3401,  3404,  3408,  3411,
    3412,  3413,  3414,  3415,  3416,  3417,  3418,  3421,  3424,  3427,
    3434,  3441,  3451,  3457,  3458,  3466,  3467,  3468,  3469,  3470,
    3477,  3488,  3496,  3499,  3503,  3507,  3517,  3522,  3530,  3543,
    3551,  3554,  3558,  3562,  3588,  3594,  3602,  3612,  3640,  3648,
    3655,  3664,  3668,  3672,  3679,  3696,  3713,  3721,  3729,  3738,
    3742,  3751,  3762,  3774,  3784,  3797,  3804,  3812,  3828,  3836,
    3847,  3858,  3869,  3888,  3896,  3913,  3921,  3928,  3939,  3950,
    3961,  3980,  3986,  3992,  3999,  4008,  4011,  4020,  4027,  4034,
    4044,  4055,  4066,  4077,  4084,  4091,  4094,  4111,  4121,  4128,
    4134,  4139,  4145,  4149,  4155,  4156,  4162,  4168,  4172,  4175,
    4178,  4179,  4180,  4181,  4182,  4183,  4188,  4191,  4196,  4221,
    4224,  4266,  4270,  4274,  4278,  4282,  4286,  4290,  4294,  4300,
    4300,  4319,  4336,  4337,  4340,  4353,  4361,  4367,  4380,  4383,
    4392,  4403,  4404,  4408,  4413,  4414,  4438,  4445,  4451,  4458,
    4465,  4475,  4476,  4477,  4478,  4479,  4480,  4481,  4484,  4488,
    4492,  4496,  4500,  4504,  4508,  4512,  4516,  4520,  4524,  4528,
    4532,  4536,  4540,  4544,  4555,  4560,  4560,  4561,  4564,  4569,
    4575,  4585,  4597,  4598,  4599,  4603,  4607,  4611,  4615,  4621,
    4622,  4625,  4629,  4633,  4637,  4643,  4649,  4655,  4662,  4669,
    4676,  4677,  4680,  4681,  4684,  4690,  4696,  4699,  4700,  4703,
    4704,  4707,  4712,  4716,  4719,  4722,  4725,  4730,  4734,  4737,
    4744,  4750,  4759,  4764,  4768,  4771,  4774,  4777,  4782,  4786,
    4789,  4792,  4798,  4803,  4806,  4809,  4813,  4818,  4831,  4835,
    4840,  4846,  4850,  4855,  4859,  4866,  4869,  4874
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "ID", "HBLOCK", "POUND", "STRING", 
  "INCLUDE", "IMPORT", "INSERT", "CHARCONST", "NUM_INT", "NUM_FLOAT", 
  "NUM_UNSIGNED", "NUM_LONG", "NUM_ULONG", "NUM_LONGLONG", 
  "NUM_ULONGLONG", "TYPEDEF", "TYPE_INT", "TYPE_UNSIGNED", "TYPE_SHORT", 
  "TYPE_LONG", "TYPE_FLOAT", "TYPE_DOUBLE", "TYPE_CHAR", "TYPE_VOID", 
  "TYPE_SIGNED", "TYPE_BOOL", "TYPE_TYPEDEF", "TYPE_RAW", "LPAREN", 
  "RPAREN", "COMMA", "SEMI", "EXTERN", "INIT", "LBRACE", "RBRACE", 
  "PERIOD", "CONST_QUAL", "VOLATILE", "STRUCT", "UNION", "EQUAL", 
  "SIZEOF", "MODULE", "LBRACKET", "RBRACKET", "ILLEGAL", "CONSTANT", 
  "NAME", "RENAME", "NAMEWARN", "EXTEND", "PRAGMA", "FEATURE", "VARARGS", 
  "ENUM", "CLASS", "TYPENAME", "PRIVATE", "PUBLIC", "PROTECTED", "COLON", 
  "STATIC", "VIRTUAL", "FRIEND", "THROW", "CATCH", "USING", "NAMESPACE", 
  "NATIVE", "INLINE", "TYPEMAP", "EXCEPT", "ECHO", "APPLY", "CLEAR", 
  "SWIGTEMPLATE", "FRAGMENT", "WARN", "LESSTHAN", "GREATERTHAN", "MODULO", 
  "DELETE_KW", "TYPES", "PARMS", "NONID", "DSTAR", "DCNOT", "TEMPLATE", 
  "OPERATOR", "COPERATOR", "PARSETYPE", "PARSEPARM", "CAST", "LOR", 
  "LAND", "OR", "XOR", "AND", "RSHIFT", "LSHIFT", "MINUS", "PLUS", 
  "SLASH", "STAR", "LNOT", "NOT", "UMINUS", "DCOLON", "$accept", 
  "program", "interface", "declaration", "swig_directive", 
  "extend_directive", "@1", "apply_directive", "clear_directive", 
  "constant_directive", "echo_directive", "except_directive", 
  "stringtype", "fname", "fragment_directive", "include_directive", "@2", 
  "includetype", "inline_directive", "insert_directive", 
  "module_directive", "name_directive", "native_directive", 
  "pragma_directive", "pragma_arg", "pragma_lang", "rename_directive", 
  "rename_namewarn", "feature_directive", "stringbracesemi", "featattr", 
  "varargs_directive", "varargs_parms", "typemap_directive", 
  "typemap_type", "tm_list", "tm_tail", "typemap_parm", "types_directive", 
  "template_directive", "warn_directive", "c_declaration", "c_decl", 
  "c_decl_tail", "initializer", "c_enum_forward_decl", "c_enum_decl", 
  "c_constructor_decl", "cpp_declaration", "cpp_class_decl", "@3", "@4", 
  "cpp_opt_declarators", "cpp_forward_class_decl", "cpp_template_decl", 
  "@5", "cpp_temp_possible", "template_parms", "cpp_using_decl", 
  "cpp_namespace_decl", "@6", "@7", "cpp_members", "@8", "@9", 
  "cpp_member", "cpp_constructor_decl", "cpp_destructor_decl", 
  "cpp_conversion_operator", "cpp_catch_decl", "cpp_protection_decl", 
  "cpp_nested", "@10", "@11", "nested_decl", "cpp_swig_directive", 
  "cpp_end", "cpp_vend", "anonymous_bitfield", "storage_class", "parms", 
  "rawparms", "ptail", "parm", "valparms", "rawvalparms", "valptail", 
  "valparm", "def_args", "parameter_declarator", 
  "typemap_parameter_declarator", "declarator", "notso_direct_declarator", 
  "direct_declarator", "abstract_declarator", 
  "direct_abstract_declarator", "pointer", "type_qualifier", 
  "type_qualifier_raw", "type", "rawtype", "type_right", "primitive_type", 
  "primitive_type_list", "type_specifier", "definetype", "@12", "ename", 
  "enumlist", "edecl", "etype", "expr", "exprnum", "exprcompound", 
  "inherit", "raw_inherit", "@13", "base_list", "base_specifier", 
  "access_specifier", "cpptype", "opt_virtual", "cpp_const", "ctor_end", 
  "ctor_initializer", "mem_initializer_list", "mem_initializer", 
  "template_decl", "idstring", "idstringopt", "idcolon", "idcolontail", 
  "idtemplate", "idcolonnt", "idcolontailnt", "string", "stringbrace", 
  "options", "kwargs", "stringnum", "empty", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned char yyr1[] =
{
       0,   112,   113,   113,   113,   113,   113,   114,   114,   115,
     115,   115,   115,   115,   115,   115,   116,   116,   116,   116,
     116,   116,   116,   116,   116,   116,   116,   116,   116,   116,
     116,   116,   116,   116,   116,   116,   116,   118,   117,   119,
     120,   121,   121,   121,   122,   122,   123,   123,   123,   123,
     124,   125,   125,   126,   126,   126,   128,   127,   129,   129,
     130,   130,   131,   131,   131,   131,   132,   133,   133,   134,
     134,   135,   135,   136,   136,   137,   137,   138,   138,   138,
     139,   139,   140,   140,   140,   140,   140,   140,   140,   140,
     141,   141,   141,   142,   142,   143,   144,   144,   145,   145,
     145,   146,   147,   148,   148,   149,   149,   149,   150,   151,
     152,   153,   153,   153,   153,   154,   155,   155,   155,   156,
     156,   156,   156,   157,   158,   158,   159,   160,   160,   160,
     160,   160,   160,   162,   161,   163,   161,   164,   164,   165,
     167,   166,   166,   168,   168,   168,   168,   168,   169,   170,
     170,   172,   171,   173,   171,   171,   174,   175,   174,   174,
     176,   174,   177,   177,   177,   177,   177,   177,   177,   177,
     177,   177,   177,   177,   177,   177,   177,   177,   177,   177,
     178,   179,   179,   180,   180,   180,   181,   182,   182,   182,
     184,   183,   185,   183,   186,   186,   187,   187,   187,   187,
     187,   187,   187,   187,   187,   187,   187,   188,   188,   189,
     189,   189,   190,   191,   191,   191,   191,   191,   191,   191,
     192,   193,   193,   194,   194,   195,   195,   195,   196,   197,
     197,   198,   198,   199,   199,   199,   200,   200,   200,   200,
     200,   201,   201,   201,   202,   202,   202,   203,   203,   203,
     203,   203,   203,   203,   203,   204,   204,   204,   204,   204,
     204,   204,   204,   205,   205,   205,   205,   205,   205,   205,
     205,   206,   206,   206,   206,   206,   206,   206,   206,   206,
     206,   207,   207,   207,   207,   207,   207,   207,   208,   208,
     208,   208,   209,   209,   210,   210,   211,   212,   212,   213,
     213,   213,   213,   213,   213,   213,   213,   213,   214,   215,
     215,   216,   216,   216,   216,   216,   216,   216,   216,   218,
     217,   217,   219,   219,   220,   220,   221,   221,   221,   222,
     222,   223,   223,   223,   223,   223,   223,   223,   223,   223,
     223,   224,   224,   224,   224,   224,   224,   224,   225,   225,
     225,   225,   225,   225,   225,   225,   225,   225,   225,   225,
     225,   225,   225,   225,   226,   228,   227,   227,   229,   229,
     230,   230,   231,   231,   231,   232,   232,   232,   232,   233,
     233,   234,   234,   234,   234,   235,   235,   235,   235,   235,
     236,   236,   237,   237,   238,   239,   239,   240,   240,   241,
     241,   242,   242,   242,   242,   242,   242,   243,   243,   243,
     243,   244,   245,   245,   245,   245,   245,   245,   246,   246,
     246,   246,   247,   247,   248,   248,   248,   249,   249,   250,
     250,   250,   250,   250,   250,   251,   251,   252
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     3,     2,     3,     2,     2,     1,     1,
       1,     1,     1,     1,     1,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     0,     7,     5,
       3,     5,     5,     3,     2,     2,     5,     2,     5,     2,
       4,     1,     1,     7,     7,     5,     0,     7,     1,     1,
       2,     2,     1,     5,     5,     5,     3,     4,     3,     7,
       8,     5,     3,     1,     1,     3,     1,     4,     7,     6,
       1,     1,     7,     9,     8,    10,     5,     7,     6,     8,
       1,     1,     5,     4,     5,     7,     1,     3,     6,     6,
       8,     1,     2,     3,     1,     2,     3,     6,     5,     9,
       2,     1,     1,     1,     5,     5,     1,     4,     1,     1,
       2,     5,     6,     4,     7,     8,     6,     1,     1,     1,
       1,     1,     1,     0,     9,     0,     8,     1,     2,     4,
       0,     6,     3,     1,     1,     1,     1,     1,     1,     3,
       4,     0,     6,     0,     5,     5,     2,     0,     6,     1,
       0,     3,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       6,     6,     7,     8,     8,     7,     5,     2,     2,     2,
       0,     7,     0,     6,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     2,     2,
       4,     2,     5,     1,     2,     1,     1,     1,     1,     1,
       1,     2,     1,     3,     1,     2,     6,     3,     1,     2,
       1,     3,     1,     1,     1,     1,     2,     3,     2,     2,
       1,     2,     2,     1,     1,     1,     1,     2,     3,     1,
       2,     3,     4,     5,     4,     1,     2,     3,     4,     5,
       3,     4,     4,     1,     2,     4,     4,     5,     3,     4,
       4,     1,     2,     2,     3,     1,     2,     1,     2,     3,
       4,     3,     4,     2,     3,     3,     4,     3,     3,     2,
       2,     1,     1,     2,     1,     1,     1,     2,     1,     1,
       1,     1,     2,     2,     1,     2,     1,     2,     1,     1,
       2,     1,     1,     1,     1,     1,     1,     1,     1,     0,
       2,     1,     1,     1,     3,     1,     1,     3,     1,     1,
       1,     1,     1,     5,     1,     1,     3,     4,     5,     5,
       6,     1,     1,     1,     1,     1,     1,     1,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     2,
       2,     2,     2,     2,     1,     0,     3,     1,     1,     3,
       2,     4,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     4,     5,     1,     3,     3,     4,     4,     3,
       2,     1,     1,     3,     2,     3,     1,     1,     1,     1,
       1,     2,     4,     1,     3,     1,     3,     3,     2,     2,
       2,     2,     2,     4,     1,     3,     1,     3,     3,     2,
       2,     2,     2,     1,     1,     1,     1,     3,     1,     3,
       5,     1,     3,     3,     5,     1,     1,     0
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
     437,     0,     0,     0,     0,     8,     4,   437,   311,   318,
     312,   313,   315,   316,   314,   301,   317,   300,   437,   304,
       0,   294,   295,   376,   377,     0,   375,   378,     0,     0,
     405,     0,     0,   292,   437,   298,   299,   308,   309,     0,
     306,   403,     6,     0,     1,    13,    62,    58,    59,     0,
     216,    12,   213,   437,     0,     0,    80,    81,   437,   437,
       0,     0,   215,   217,   218,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       7,     9,    16,    17,    18,    19,    20,    21,    22,    23,
     437,    24,    25,    26,    27,    28,    29,    30,     0,    31,
      32,    33,    34,    35,    36,    10,   111,   113,   112,    14,
      11,   127,   128,   129,   130,   131,   132,     0,   219,   437,
     411,   396,   302,     0,   303,     0,     0,     3,   297,   293,
     437,   319,     0,     0,   277,   291,     0,   243,   225,   437,
     249,   437,   275,   271,   263,   240,   305,   310,   307,     0,
       0,   401,     5,    15,     0,   423,   214,     0,     0,   428,
       0,   437,     0,   296,     0,     0,     0,     0,    76,     0,
     437,   437,     0,     0,   437,   153,     0,     0,    60,    61,
       0,     0,    49,    47,    44,    45,   437,     0,   437,     0,
     437,   437,     0,   110,   437,   437,     0,     0,     0,     0,
       0,     0,   263,   437,     0,     0,   235,   341,   342,   343,
     344,   345,   346,   347,   233,     0,   228,   437,   234,   230,
     227,   406,   404,     0,   437,   277,     0,   220,   437,     0,
     271,   306,   222,   321,   238,     0,   236,     0,     0,     0,
     283,     0,     0,     0,     0,   335,     0,   331,   334,   332,
     239,   437,     0,   250,   276,   255,   289,   290,   264,   241,
     437,     0,   242,   437,     0,   273,   247,   272,   255,   278,
     410,   409,   408,   397,     0,   398,   422,   437,   431,     0,
      66,    43,   319,     0,   437,    68,     0,     0,     0,    72,
       0,     0,     0,    96,     0,     0,   149,     0,   437,   151,
       0,     0,   101,     0,     0,     0,   105,   244,   245,   246,
      40,     0,   102,   104,   399,     0,   400,    52,     0,    51,
       0,     0,   148,   142,     0,   437,     0,     0,     0,     0,
       0,     0,     0,   255,     0,   437,     0,   323,   437,   437,
     135,   307,   395,     0,   229,   232,   402,     0,   277,   271,
     306,     0,   263,   287,     0,   221,   224,   285,   273,     0,
     263,   278,   237,   320,     0,     0,   359,   360,   362,   361,
     363,   284,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   271,   306,   256,   437,     0,   288,     0,
     268,     0,     0,   281,     0,   248,   274,   279,     0,   251,
     407,     0,     0,     0,     0,   427,     0,     0,    67,    37,
      75,     0,     0,     0,     0,     0,     0,     0,   150,     0,
       0,   437,   437,     0,     0,   106,     0,   437,     0,     0,
       0,     0,     0,   140,    56,     0,     0,     0,     0,    77,
       0,   123,   437,     0,   306,     0,     0,   119,   437,     0,
     139,   365,     0,   364,   367,   437,     0,     0,   278,   266,
     437,   265,   279,     0,   336,     0,   291,     0,   437,   358,
     357,   353,   354,   352,   356,   355,   349,   348,   351,   350,
       0,   255,   257,   278,     0,   260,     0,   270,   269,   286,
     282,     0,   252,   280,   254,    64,    65,    63,   114,   432,
     433,   436,   435,   429,    41,    42,     0,    74,    71,    73,
     426,    91,   425,     0,    86,   437,   424,    90,     0,   435,
       0,     0,    97,   437,   186,   155,   154,     0,   213,     0,
       0,    48,    46,   437,    39,   103,   414,     0,   416,     0,
      55,     0,     0,   108,   437,   437,   437,     0,     0,   326,
       0,   325,   328,   437,   437,     0,   116,   118,   115,     0,
     120,   160,   179,     0,     0,     0,     0,   217,     0,   204,
     205,   197,   206,   177,   202,   198,   196,   199,   200,   201,
     203,   178,   174,   175,   162,   168,   172,   171,     0,     0,
     163,   164,   167,   173,   165,   169,   166,   176,     0,   219,
     437,   133,   231,   226,   223,   267,   337,     0,   290,     0,
       0,     0,   258,     0,   262,   261,   253,     0,     0,     0,
     437,     0,   381,     0,   384,     0,     0,     0,     0,    88,
     437,     0,   152,   214,   437,     0,    99,     0,    98,     0,
       0,     0,   412,     0,   437,     0,    50,   143,   144,   147,
     146,   141,   145,     0,     0,     0,    79,     0,   437,     0,
     437,   319,   437,   126,     0,   437,   437,     0,   157,   188,
     187,   189,     0,     0,     0,   156,     0,     0,     0,   306,
     379,   366,   368,     0,   380,     0,   339,   338,     0,   333,
     259,   434,   430,    38,     0,   437,     0,    82,   435,    93,
      87,   437,     0,     0,    95,    69,     0,     0,   107,   421,
     419,   420,   415,   417,     0,    53,    54,     0,    57,    78,
     330,   327,   329,   324,   124,     0,     0,     0,     0,     0,
     391,   437,     0,     0,   161,     0,     0,   437,     0,     0,
     437,     0,   437,   192,   307,   170,   437,   373,   372,   374,
     437,   370,     0,   340,     0,     0,   437,    94,     0,    89,
     437,    84,    70,   100,   418,   413,     0,   125,     0,   389,
     390,   392,     0,   385,   386,   121,   117,   437,     0,   437,
       0,   136,   437,     0,     0,     0,     0,   190,   437,   369,
       0,     0,    92,   382,     0,    83,     0,   109,   387,   388,
       0,   394,   122,     0,     0,   437,     0,   437,   437,   437,
     212,   437,     0,   194,   195,   371,   137,   134,     0,   383,
      85,   393,   158,   437,   181,     0,   437,     0,     0,   180,
       0,   193,   138,   182,     0,   207,   208,   185,   437,   437,
     191,   209,   211,   319,   184,   183,     0,   210
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     3,     4,    80,    81,    82,   506,   569,   570,   571,
     572,    87,   317,   318,   573,    89,   545,    90,    91,   574,
      93,   575,    95,   576,   508,   167,   577,    98,   578,   514,
     414,   579,   292,   580,   301,   189,   312,   190,   581,   582,
     583,   584,   106,   558,   446,   107,   108,   109,   110,   111,
     685,   449,   817,   585,   586,   544,   651,   321,   587,   115,
     421,   298,   588,   735,   667,   589,   590,   591,   592,   593,
     594,   595,   811,   788,   812,   596,   824,   833,   597,   598,
     226,   227,   355,   228,   215,   216,   344,   217,   137,   138,
     306,   339,   253,   140,   229,   142,   201,    32,    33,   245,
     163,    35,    36,    37,    38,   236,   237,   336,   550,   551,
     721,   473,   247,   248,   452,   453,   600,   681,   682,   750,
      39,   683,   834,   663,   729,   770,   771,   120,   278,   315,
      40,   151,    41,   539,   642,   249,   517,   158,   279,   503,
     232
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -634
static const short yypact[] =
{
     413,  1068,  2933,    51,  2508,  -634,  -634,   124,  -634,  -634,
    -634,  -634,  -634,  -634,  -634,  -634,  -634,  -634,   124,  -634,
      16,  -634,  -634,  -634,  -634,    40,  -634,  -634,   -29,   172,
    -634,   213,  3396,   489,   109,   489,  -634,  -634,  1164,    40,
    -634,   -46,  -634,   224,  -634,   230,  -634,  -634,  -634,   275,
    -634,  -634,   332,   319,  2976,   328,  -634,  -634,   319,   343,
     373,   379,  -634,  -634,  -634,   384,   101,   292,   419,   144,
     430,   568,   383,  3228,  3228,   479,   488,   332,   516,   474,
    -634,  -634,  -634,  -634,  -634,  -634,  -634,  -634,  -634,  -634,
     319,  -634,  -634,  -634,  -634,  -634,  -634,  -634,   620,  -634,
    -634,  -634,  -634,  -634,  -634,  -634,  -634,  -634,  -634,  -634,
    -634,  -634,  -634,  -634,  -634,  -634,  -634,  3270,  -634,  3102,
    -634,  -634,  -634,   339,  -634,    39,   526,  -634,   489,  -634,
    2269,    74,  1526,   485,   133,   209,    40,  -634,  -634,   347,
     145,   347,   329,   289,   460,  -634,  -634,  -634,  -634,   552,
      59,  -634,  -634,  -634,   132,  -634,   226,   132,   132,  -634,
     523,     6,   733,  -634,   238,    40,   559,   587,  -634,   132,
    3144,  3186,    40,   569,    70,  -634,   572,   612,  -634,  -634,
     132,   623,  -634,  -634,  -634,   639,  3186,   619,   165,   615,
     633,   132,   332,   639,  3186,  3186,    40,   332,   112,   176,
     132,    54,   579,    78,   797,   394,  -634,  -634,  -634,  -634,
    -634,  -634,  -634,  -634,  -634,   599,  -634,   637,  -634,  -634,
    -634,  -634,   -46,   603,  2359,   300,   631,  -634,   651,   663,
     325,   614,  -634,  -634,  -634,   733,  -634,  2226,  2226,   676,
    -634,  2226,  2226,  2226,  2226,   682,  1200,  -634,  -634,   639,
    -634,  2359,    40,   377,   329,  -634,  -634,   598,  -634,  -634,
    3186,  1626,  -634,  3186,  1726,   133,   377,   329,   627,   652,
    -634,  -634,   -46,  -634,   688,   639,  -634,  -634,   191,   690,
    -634,  -634,   724,   179,   347,  -634,   700,   706,   713,   705,
     506,   729,   725,  -634,   738,   742,  -634,    40,  -634,  -634,
     753,   759,  -634,   764,   770,  3228,  -634,  -634,  -634,  -634,
    -634,  3228,  -634,  -634,  -634,   774,  -634,  -634,   562,   312,
     776,   691,  -634,  -634,   110,   -10,   242,   242,   780,   726,
      42,   786,   176,   741,   652,   324,   785,  -634,  2413,   843,
    -634,   330,  -634,  3102,  -634,  -634,  -634,   526,   473,   549,
     743,   519,  -634,  -634,  3186,  -634,  -634,  -634,   473,   589,
     748,   242,  -634,  1490,  1181,  3312,  -634,  -634,  -634,  -634,
    -634,  -634,  2226,  2226,  2226,  2226,  2226,  2226,  2226,  2226,
    2226,  2226,  2226,   850,    48,  -634,  3186,  1826,  -634,   817,
    -634,  1242,   818,  -634,  1267,   377,   329,   869,   176,   377,
    -634,   290,  2594,   132,  1067,  -634,   793,   820,  -634,  -634,
    -634,   465,   256,  1006,   819,  3186,   733,   815,  -634,   831,
    2680,  -634,   611,  3228,   541,   836,   832,   633,   117,   837,
     132,  3312,   840,  -634,  -634,   245,   242,   176,    97,  -634,
     857,  -634,   866,   848,   726,   851,   441,  -634,   331,  1435,
    -634,  -634,   849,  -634,  -634,   637,    40,   748,  -634,  -634,
     651,  -634,   473,   600,  2226,  1926,  2026,    -8,   109,  1252,
     898,  1132,  1226,   997,   674,   674,   574,   574,  -634,  -634,
     642,   748,  -634,   176,   858,  -634,  1327,  -634,  -634,  -634,
    -634,   176,   377,   329,   377,  -634,  -634,   639,  -634,  -634,
     859,  -634,   312,   860,  -634,  -634,  1435,  -634,  -634,   639,
    -634,  -634,  -634,   863,  -634,   241,   639,  -634,   852,    30,
     722,   256,  -634,   241,  -634,  -634,  -634,  2766,   332,  3354,
     349,  -634,  -634,  3186,  -634,  -634,   221,   790,  -634,   823,
    -634,   870,   871,  -634,   917,  -634,   241,   263,   176,   864,
      88,  -634,  -634,   835,  3186,   733,  -634,  -634,  -634,   879,
    -634,  -634,  -634,   875,   853,   861,   865,   804,   552,  -634,
    -634,  -634,  -634,  -634,  -634,  -634,  -634,  -634,  -634,  -634,
    -634,  -634,  -634,  -634,  -634,  -634,  -634,  -634,   876,  1435,
    -634,  -634,  -634,  -634,  -634,  -634,  -634,  -634,  3019,   877,
     867,  -634,  -634,  -634,  -634,  -634,  1490,  2226,  2464,  2226,
     891,   902,  -634,   716,  -634,  -634,   377,   132,   132,   892,
    3186,   905,   872,   570,  -634,  1067,   212,   132,   909,  -634,
     241,   910,  -634,   639,   126,   733,  -634,  3228,  -634,   914,
     944,    91,  -634,    92,  3102,   308,  -634,  -634,  -634,  -634,
    -634,  -634,  -634,  3312,  2852,   922,  -634,  2126,   866,   402,
    3186,   724,   884,  -634,   931,   843,  3186,  1435,  -634,  -634,
    -634,  -634,   552,   937,   733,  -634,  3312,   509,   400,   935,
    -634,   938,  -634,    35,  -634,  1435,  1490,  1490,  2226,  -634,
    -634,  -634,  -634,  -634,   940,  3186,   942,  -634,   639,   941,
    -634,   241,   608,   570,  -634,  -634,   945,   946,  -634,  -634,
     221,  -634,   221,  -634,   903,  -634,  -634,   830,  -634,  -634,
    -634,  -634,  1490,  -634,  -634,   441,   943,   947,    40,   580,
    -634,   347,   441,   953,  -634,  1435,   958,  3186,   441,   207,
    2413,   979,   113,  -634,   961,  -634,   867,  -634,  -634,  -634,
     867,  -634,   969,  1490,   977,   982,  3186,  -634,   981,  -634,
     241,  -634,  -634,  -634,  -634,  -634,   990,  -634,   590,  -634,
     983,  -634,   994,  -634,  -634,  -634,  -634,   347,   988,  3186,
    1003,  -634,  3186,  1009,  1010,  1011,  1008,  -634,   733,  -634,
      40,   755,  -634,  -634,  1012,  -634,  1013,  -634,  -634,  -634,
      40,  -634,  -634,  1435,  1014,   241,  1016,  3186,  3186,   835,
    -634,   733,  1015,  -634,  -634,  -634,  -634,  -634,   441,  -634,
    -634,  -634,  -634,   241,  -634,   601,   241,  1020,  1021,  -634,
    1023,  -634,  -634,  -634,   484,  -634,  -634,  -634,   241,   241,
    -634,  -634,  -634,   724,  -634,  -634,  1024,  -634
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
    -634,  -634,  -267,  -634,  -634,  -634,  -634,     5,    21,    33,
      36,  -634,   650,  -634,    37,  -634,  -634,  -634,  -634,    43,
    -634,    44,  -634,    45,  -634,  -634,    50,  -634,    52,  -501,
    -488,    56,  -634,    57,  -634,  -290,   628,   -72,    60,    64,
      65,    71,   517,  -633,   395,  -634,  -634,  -634,  -634,   520,
    -634,  -634,  -634,    -2,    -1,  -634,  -634,  -634,    79,  -634,
    -634,  -634,  -498,  -634,  -634,  -634,   521,  -634,  -634,    85,
    -634,  -634,  -634,  -634,   252,  -634,  -634,  -410,  -634,    10,
     581,   873,   606,    25,   428,  -634,   621,   731,  -106,   607,
    -634,    67,   630,  -202,   -17,  -122,    32,   -22,  -634,   740,
      28,   -27,  -634,  1048,  -634,  -276,  -634,  -634,  -634,   448,
    -634,   795,  -103,  -634,  -634,  -634,  -634,  -634,   366,  -634,
     -40,   367,  -436,   307,  -634,  -634,   318,  1101,   -91,  -634,
     594,  -170,   -79,  -634,  -215,   796,   592,    87,  -104,  -394,
       0
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -438
static const short yytable[] =
{
       5,   187,   112,   113,   118,   128,   406,   121,   619,    83,
     402,   129,   254,   146,   117,   426,   218,   141,   121,   520,
     629,   267,  -397,   351,   609,    84,    31,    43,   359,    34,
      34,   420,   628,   259,   145,   262,   276,    85,     7,   196,
      86,    88,     7,     7,   149,     7,   222,    92,    94,    96,
     282,    44,   346,   159,    97,   123,    99,     7,   159,   168,
     100,   101,     7,   274,   102,   150,   143,   280,   103,   104,
     270,   272,   119,   286,  -398,   105,   302,   205,   290,   623,
     482,   335,   125,   114,   233,   330,   223,   631,   119,   116,
     159,   675,   767,   610,   710,   712,   747,   748,   749,   776,
     314,   139,   400,   254,     7,   781,   146,   328,   267,   331,
     655,   234,     7,   257,   297,   325,   276,   662,   155,   219,
     536,   658,   697,    28,   351,   359,   659,    30,    28,   482,
      28,   221,    30,   530,    30,   273,     7,   483,   155,   145,
     130,   145,    28,   396,   214,   165,    30,    34,   178,   135,
     787,   271,   119,   131,   527,   332,   132,   434,    34,   463,
     705,   121,   230,   252,   251,   200,    28,   256,     7,   734,
      30,   308,   172,   133,   121,   235,   260,   197,   407,     7,
     132,   179,     7,   711,   713,   832,   548,   752,   309,    28,
     313,   316,   261,    30,   703,   119,   130,    28,    34,    34,
      28,    30,   761,   337,    30,   537,   119,   330,   119,   538,
     134,   757,   132,   326,    34,     7,   135,   345,   136,   135,
     143,    28,    34,    34,   403,    30,   254,   267,   356,   284,
     327,   699,   276,   447,   463,   404,   396,   778,   782,   427,
     218,   273,   252,   283,   155,     7,   700,   127,     7,    21,
      22,   155,    34,    28,   126,   307,   349,    30,   152,     7,
     510,   267,   155,   277,    28,   758,   134,    28,    30,   276,
     285,    30,   135,   283,   136,   493,   283,     5,   654,    34,
     326,    21,    22,   383,   145,   252,   135,   283,    34,   388,
     511,    34,     7,   512,   495,   174,   155,   656,     5,   499,
      28,   501,   362,     7,    30,   822,   154,   456,   783,   621,
     501,   640,   715,   199,   135,   327,   135,   448,   276,   135,
     251,   136,   518,   153,   796,   121,   541,   496,     7,   175,
      28,   130,   641,    28,    30,   121,   132,    30,   155,   145,
     493,   454,   560,   513,    28,   716,   199,   132,    30,   431,
     157,   136,   135,   510,   136,   155,   130,   199,   441,   164,
     263,  -322,   437,   135,   450,   136,    34,  -437,   214,   825,
     327,    34,   132,   662,   166,   131,   264,    28,   220,   460,
      28,    30,    34,   636,    30,   727,   512,   184,    28,   155,
     265,   131,    30,   637,   451,   133,   467,     7,   252,   559,
     112,   113,   118,   742,   169,     7,   119,    83,   386,   136,
     170,   133,   117,    28,    34,   171,   837,    30,   112,   113,
     118,     5,   118,    84,   387,    83,   358,   313,   844,   845,
     117,   340,   529,   283,   136,    85,   724,   743,    86,    88,
     522,    84,   552,    34,   608,    92,    94,    96,   145,   599,
     177,   141,    97,    85,    99,   345,    86,    88,   100,   101,
     356,   180,   102,    92,    94,    96,   103,   104,   145,   507,
      97,   155,    99,   105,   555,   556,   100,   101,   557,   515,
     102,   114,    28,   523,   103,   104,    30,   116,    28,   673,
      28,   105,    30,   622,    30,   764,   250,   765,   256,   114,
     143,   622,   546,   199,   224,   116,   599,     1,     2,   135,
     191,   136,     7,   691,   692,   624,    23,    24,   841,   192,
     132,   842,   501,   624,   622,   112,   113,   118,   843,    21,
      22,   622,    83,    26,    27,   139,   518,   117,   412,   413,
     740,   218,   649,   650,   118,     5,   624,   194,    84,   269,
     260,   459,     7,   624,   653,     7,   195,   281,   678,   447,
      85,    34,   288,    86,    88,   707,   261,   846,    23,    24,
      92,    94,    96,   741,   510,   531,   155,    97,   532,    99,
     224,   128,    34,   100,   101,    26,    27,   102,   630,   599,
     289,   103,   104,   736,   429,   430,   132,    28,   105,   181,
     684,    30,   182,   296,   511,   183,   114,   512,   622,   299,
     199,     7,   116,   205,   773,   300,   135,   774,   136,   124,
     260,   461,   665,     7,   798,   775,   303,   799,   144,    50,
     624,   260,   605,   148,   121,   835,   261,    28,   836,   283,
     388,    30,   759,   448,   219,   276,   528,   261,    34,   310,
     358,   198,   112,   113,   118,     7,   305,   513,   552,    83,
     173,   176,   730,   353,   117,   145,   311,   599,   334,   214,
     343,   802,    34,   386,   612,    84,    62,    63,    64,   622,
     381,   382,   342,   330,   354,   599,   347,    85,    34,   387,
      86,    88,   202,   701,    34,   357,    28,    92,    94,    96,
      30,   624,   706,   361,    97,   135,    99,   365,    28,   199,
     100,   101,    30,   370,   102,   135,   397,   136,   103,   104,
     401,   199,   405,    34,   231,   105,   725,   135,   255,   136,
     258,   145,   408,   114,   233,   599,     7,   268,   622,   116,
      28,   738,   121,   409,    30,   410,   684,   386,   690,   411,
     684,   293,   294,   398,   626,   627,   202,   416,     7,   287,
     624,   252,   415,   387,   283,    34,   295,   304,    34,   760,
     417,   784,   327,   266,   433,   320,   418,   145,   379,   380,
     381,   382,   144,   622,    34,   422,   283,   622,   814,   816,
     323,   423,   329,   255,   162,   333,   424,   124,   202,   341,
       7,   622,   425,   599,   622,   624,   428,    34,   432,   624,
      34,   814,   435,   188,   188,   436,   622,   622,   350,   352,
     439,    28,   442,   624,   360,    30,   624,   504,   338,   202,
     440,   266,   458,     7,   199,    34,    34,   462,   624,   624,
     135,   389,   136,    28,   392,   384,   385,    30,   156,   487,
     489,   521,   524,     7,   505,   813,   199,   204,   818,   255,
       7,   740,   135,   255,   136,   525,   660,   533,   185,   549,
     534,   540,     7,   193,   543,    21,    22,   329,   813,   661,
     553,   251,   554,    21,    22,    28,   601,   131,   330,    30,
     614,   419,   617,   618,   620,   395,   625,   132,   199,   399,
     251,   643,   645,   621,   135,   644,   136,   133,   657,   646,
     666,   445,   668,   672,   674,  -159,   132,   669,    28,   443,
     352,   352,    30,   688,   438,   670,   255,   246,   255,   671,
     693,   199,   444,   680,   689,    50,   695,   135,    28,   136,
     696,   702,    30,   457,   704,    28,   708,   709,   728,    30,
     275,   358,   528,   275,   275,   352,   719,    28,   491,   252,
     275,    30,   395,   731,   399,   275,   252,   484,   737,   745,
     491,   746,   754,   756,   627,   768,   275,   481,   252,   762,
     763,   769,    62,    63,    64,   777,   766,   275,   319,   779,
     786,   255,   255,   324,   275,   450,   275,   374,   375,   376,
     377,   378,   379,   380,   381,   382,   202,   791,    79,   273,
     202,   792,   155,   480,   793,   795,   800,   207,   208,   209,
     210,   211,   212,   213,   797,   801,   803,   492,   494,   202,
     352,   255,   363,   364,   255,   805,   366,   367,   368,   369,
     807,   808,   810,   809,   819,   188,   823,   820,   826,   831,
     603,   188,   838,   839,   500,   535,   391,   840,   847,   394,
     732,   647,   144,   830,   648,   652,   604,   480,   322,     6,
     492,     7,   714,   155,   455,   611,   602,   255,   207,   208,
     209,   210,   211,   212,   213,   255,   147,     8,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    19,   377,
     378,   379,   380,   381,   382,   468,   723,    20,    21,    22,
      23,    24,   789,   613,   639,   202,   829,   790,   821,   122,
       0,   616,   638,     0,     0,     0,    25,    26,    27,     0,
       0,     0,     0,     0,     0,   664,     0,     0,     0,     0,
       0,     0,   255,     0,     0,     0,     0,     0,     0,   202,
       0,     0,     0,     0,     0,     0,    28,     0,     0,    29,
      30,     0,     0,   188,     0,     0,     0,   469,   470,   471,
     472,   542,   474,   475,   476,   477,   478,   479,   613,     0,
       0,     0,   486,     8,     9,    10,    11,    12,    13,    14,
       0,    16,   679,     0,     0,     0,     0,   497,     0,   275,
     502,   694,     0,     0,     0,     0,     0,   509,   516,   519,
       0,     0,     0,   464,     0,     0,     0,     0,     0,     0,
     202,     0,     0,     0,     0,     0,   275,     0,     0,   202,
       0,   547,   375,   376,   377,   378,   379,   380,   381,   382,
       0,   726,     0,     0,     0,     0,     0,   733,   371,     0,
       0,     0,     0,   202,     0,     0,     0,     0,     0,   606,
       0,   479,     0,     0,     0,     0,     0,     0,   202,   635,
       0,   202,   744,     0,     0,     0,   755,   751,   372,   373,
     374,   375,   465,   377,   378,   379,   380,   381,   466,     0,
     488,     0,     0,     0,     0,     0,   202,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,     0,     0,
       0,   202,     0,     0,     0,   490,     0,   516,   780,     0,
       0,   785,   772,     0,   633,     0,   516,   376,   377,   378,
     379,   380,   381,   382,   444,     0,     0,   794,   677,   372,
     373,   374,   375,   376,   377,   378,   379,   380,   381,   382,
     373,   374,   375,   376,   377,   378,   379,   380,   381,   382,
     804,     0,     0,   806,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   381,   382,   615,     0,   188,     0,     0,
       0,     0,   202,     0,   815,   202,     0,     0,   827,   828,
       0,     0,     0,   717,   772,     0,     0,     0,     0,     0,
       0,     0,   686,     0,   687,   202,     0,     0,     0,     0,
       0,     0,     0,   275,   275,     0,   739,     0,     0,   516,
       0,   698,     0,   275,   372,   373,   374,   375,   376,   377,
     378,   379,   380,   381,   382,     0,   561,     0,  -437,    46,
       0,     0,     0,     0,    49,     0,     0,     0,     0,     0,
       0,     0,   722,    50,  -437,  -437,  -437,  -437,  -437,  -437,
    -437,  -437,  -437,  -437,  -437,  -437,     0,     0,     0,   562,
      52,     0,     0,  -437,     0,  -437,  -437,  -437,  -437,     0,
       0,     0,     0,   753,     0,    54,    55,    56,    57,   563,
      59,    60,    61,  -437,  -437,  -437,   564,   565,   566,   516,
      62,   567,    64,     0,    65,    66,     0,     0,     0,    70,
       0,    72,    73,    74,    75,    76,    77,     0,     0,     0,
       0,    78,     0,  -437,     0,     0,    79,  -437,  -437,     7,
       0,     0,   155,     0,     0,     0,     0,   207,   208,   209,
     210,   211,   212,   213,   568,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,   238,     0,     0,
       0,     0,     0,     0,     0,     0,    21,    22,    23,    24,
       0,   239,     0,     0,   240,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    25,    26,    27,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    28,     0,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     7,
     241,   242,   155,     0,   243,   244,     0,   207,   208,   209,
     210,   211,   212,   213,     0,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,   238,     0,     0,
       0,     0,     0,     0,     0,     0,    21,    22,    23,    24,
       0,   239,     0,     0,   390,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    25,    26,    27,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    28,     0,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     7,
     241,   242,   155,     0,   243,   244,     0,   207,   208,   209,
     210,   211,   212,   213,     0,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,   238,     0,     0,
       0,     0,     0,     0,     0,     0,    21,    22,    23,    24,
       0,   239,     0,     0,   393,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    25,    26,    27,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    28,     0,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     7,
     241,   242,   155,     0,   243,   244,     0,   207,   208,   209,
     210,   211,   212,   213,     0,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,   238,     0,     0,
       0,     0,     0,     0,     0,     0,    21,    22,    23,    24,
       0,   239,     0,     0,   485,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    25,    26,    27,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    28,     0,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     7,
     241,   242,   155,     0,   243,   244,     0,   207,   208,   209,
     210,   211,   212,   213,     0,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,   238,   607,     0,
       0,     0,     0,     0,     0,     0,    21,    22,    23,    24,
       0,   239,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    25,    26,    27,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    28,     0,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     7,
     241,   242,   155,     0,   243,   244,     0,   207,   208,   209,
     210,   211,   212,   213,     0,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,   238,     0,     0,
       0,     0,     0,     0,     0,     0,    21,    22,    23,    24,
       0,   239,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    25,    26,    27,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    28,     0,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     7,
     241,   242,   155,   135,   243,   244,   720,   207,   208,   209,
     210,   211,   212,   213,     0,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,   238,     0,     0,
       0,     0,     0,     0,     0,     0,    21,    22,    23,    24,
       0,   239,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    25,    26,    27,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    28,     0,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     7,
     241,   242,   155,     0,   243,   244,     0,   207,   208,   209,
     210,   211,   212,   213,     0,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,   238,     0,     0,
       0,     0,     0,     0,     0,     0,    21,    22,    23,    24,
       0,   239,     7,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    25,    26,    27,     0,     8,     9,
      10,    11,    12,    13,    14,    15,    16,    17,    18,    19,
     224,     0,     0,     0,     0,     0,     0,     0,    20,    21,
      22,    23,    24,     0,    28,     0,   132,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,    25,    26,    27,
     241,   242,     0,     0,   243,   244,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    28,     0,     0,
      29,    30,     7,     0,     0,     0,     0,     0,     0,     0,
     225,     0,     0,     0,     0,     0,   135,     0,     8,     9,
      10,    11,    12,    13,    14,    15,    16,    17,    18,    19,
     224,     0,     0,     0,     0,     0,     0,     0,    20,    21,
      22,    23,    24,     0,     0,     0,   132,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     7,    25,    26,    27,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,     0,     0,     0,    28,     0,     0,
      29,    30,    20,    21,    22,    23,    24,     0,     0,     0,
     348,     0,     0,     0,     0,     0,   135,     7,     0,     0,
       0,    25,    26,    27,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,     0,     0,     0,     0,     0,
       0,    28,     0,     0,    29,    30,    23,    24,    -2,    45,
       0,  -437,    46,     0,   326,    47,    48,    49,     0,     0,
     135,     0,    25,    26,    27,     0,    50,  -437,  -437,  -437,
    -437,  -437,  -437,  -437,  -437,  -437,  -437,  -437,  -437,     0,
       0,     0,    51,    52,     0,     0,     0,     0,  -437,  -437,
    -437,  -437,    28,     0,    53,     0,    30,     0,    54,    55,
      56,    57,    58,    59,    60,    61,  -437,  -437,  -437,     0,
       0,   135,     0,    62,    63,    64,     0,    65,    66,    67,
      68,    69,    70,    71,    72,    73,    74,    75,    76,    77,
       0,     0,     0,     0,    78,    45,  -437,  -437,    46,    79,
    -437,    47,    48,    49,     0,     0,     0,     0,     0,     0,
       0,     0,    50,  -437,  -437,  -437,  -437,  -437,  -437,  -437,
    -437,  -437,  -437,  -437,  -437,     0,     0,     0,    51,    52,
       0,     0,   498,     0,  -437,  -437,  -437,  -437,     0,     0,
      53,     0,     0,     0,    54,    55,    56,    57,    58,    59,
      60,    61,  -437,  -437,  -437,     0,     0,     0,     0,    62,
      63,    64,     0,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,     0,     0,     0,     0,
      78,    45,  -437,  -437,    46,    79,  -437,    47,    48,    49,
       0,     0,     0,     0,     0,     0,     0,     0,    50,  -437,
    -437,  -437,  -437,  -437,  -437,  -437,  -437,  -437,  -437,  -437,
    -437,     0,     0,     0,    51,    52,     0,     0,   526,     0,
    -437,  -437,  -437,  -437,     0,     0,    53,     0,     0,     0,
      54,    55,    56,    57,    58,    59,    60,    61,  -437,  -437,
    -437,     0,     0,     0,     0,    62,    63,    64,     0,    65,
      66,    67,    68,    69,    70,    71,    72,    73,    74,    75,
      76,    77,     0,     0,     0,     0,    78,    45,  -437,  -437,
      46,    79,  -437,    47,    48,    49,     0,     0,     0,     0,
       0,     0,     0,     0,    50,  -437,  -437,  -437,  -437,  -437,
    -437,  -437,  -437,  -437,  -437,  -437,  -437,     0,     0,     0,
      51,    52,     0,     0,   632,     0,  -437,  -437,  -437,  -437,
       0,     0,    53,     0,     0,     0,    54,    55,    56,    57,
      58,    59,    60,    61,  -437,  -437,  -437,     0,     0,     0,
       0,    62,    63,    64,     0,    65,    66,    67,    68,    69,
      70,    71,    72,    73,    74,    75,    76,    77,     0,     0,
       0,     0,    78,    45,  -437,  -437,    46,    79,  -437,    47,
      48,    49,     0,     0,     0,     0,     0,     0,     0,     0,
      50,  -437,  -437,  -437,  -437,  -437,  -437,  -437,  -437,  -437,
    -437,  -437,  -437,     0,     0,     0,    51,    52,     0,     0,
       0,     0,  -437,  -437,  -437,  -437,     0,     0,    53,     0,
     718,     0,    54,    55,    56,    57,    58,    59,    60,    61,
    -437,  -437,  -437,     0,     0,     0,     0,    62,    63,    64,
       0,    65,    66,    67,    68,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    42,     0,     7,     0,    78,     0,
    -437,     0,     0,    79,  -437,     0,     0,     0,     0,     0,
       0,     0,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,     0,     0,     0,     0,     0,     0,
       0,     0,    20,    21,    22,    23,    24,   160,     0,   161,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    25,    26,    27,     0,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    21,    22,    23,    24,
       0,    28,     7,     0,    29,    30,     0,     0,     0,     0,
       0,     0,     0,     0,    25,    26,    27,     0,     8,     9,
      10,    11,    12,    13,    14,    15,    16,    17,    18,    19,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    21,
      22,    23,    24,     0,    28,     0,     0,     0,    30,     0,
       0,     0,     0,     0,     0,     0,     0,   203,    26,    27,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     7,     0,    28,   206,     0,
       0,    30,   676,   207,   208,   209,   210,   211,   212,   213,
       0,     8,     9,    10,    11,    12,    13,    14,    15,    16,
      17,    18,    19,     0,     0,     0,     0,     0,     0,     0,
       0,    20,    21,    22,    23,    24,     0,     7,     0,     0,
       0,     0,     0,     0,     0,   291,     0,     0,     0,     0,
      25,    26,    27,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,     0,     0,     0,     0,     0,
       0,     0,     0,    20,    21,    22,    23,    24,     0,     7,
      28,     0,     0,    29,    30,     0,     0,     0,     0,     0,
       0,     0,    25,    26,    27,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,     0,     0,     0,
       0,     0,     0,     0,     0,    20,    21,    22,    23,    24,
       0,     7,    28,     0,     0,    29,    30,     0,     0,     0,
       0,     0,     0,     0,    25,    26,    27,     8,     9,    10,
      11,    12,    13,    14,    15,    16,    17,    18,    19,   186,
       0,     0,     0,     0,     0,     0,     0,     0,    21,    22,
      23,    24,     0,     7,    28,     0,     0,    29,    30,     0,
       0,     0,     0,     0,     0,     0,    25,    26,    27,     8,
       9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      21,    22,    23,    24,     0,     7,    28,     0,     0,     0,
      30,     0,     0,     0,     0,     0,     0,     0,   203,    26,
      27,     8,     9,    10,    11,    12,    13,    14,    15,    16,
      17,    18,    19,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    21,    22,    23,    24,     0,   634,    28,     0,
       0,     0,    30,     0,     0,     0,     0,     0,     0,     0,
      25,    26,    27,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    21,    22,    23,    24,     0,     7,
      28,     0,     0,     0,    30,     0,     0,     0,     0,     0,
       0,     0,    25,    26,    27,     8,     9,    10,    11,    12,
      13,    14,    15,    16,    17,    18,    19,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,    23,    24,
       0,     0,    28,     0,     0,     0,    30,     0,     0,     0,
       0,     0,     0,     0,    25,    26,    27,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    28,     0,     0,     0,    30
};

static const short yycheck[] =
{
       0,    73,     4,     4,     4,    32,   282,     7,   506,     4,
     277,    33,   134,    35,     4,   305,   119,    34,    18,   413,
     521,   143,    32,   225,    32,     4,     1,     2,   230,     1,
       2,   298,   520,   139,    34,   141,     6,     4,     3,    79,
       4,     4,     3,     3,    90,     3,   125,     4,     4,     4,
      44,     0,   222,    53,     4,    39,     4,     3,    58,    59,
       4,     4,     3,   154,     4,   111,    34,   158,     4,     4,
     149,   150,    82,   164,    44,     4,   180,   117,   169,   515,
      32,     3,   111,     4,    10,    31,   126,   523,    82,     4,
      90,   589,   725,   101,     3,     3,    61,    62,    63,   732,
     191,    34,   272,   225,     3,   738,   128,   198,   230,   200,
     546,    37,     3,   135,    44,     3,     6,   553,     6,   119,
       3,    33,   623,    88,   326,   327,    38,    92,    88,    32,
      88,    92,    92,   423,    92,     3,     3,    89,     6,   139,
      31,   141,    88,   265,   119,    58,    92,   119,     4,   107,
      37,    92,    82,    44,   421,   101,    47,    47,   130,   361,
      34,   161,   130,   109,    31,    98,    88,   135,     3,   667,
      92,   188,    71,    64,   174,   101,    31,    90,   284,     3,
      47,    37,     3,    92,    92,   818,    89,   685,   188,    88,
     190,   191,    47,    92,   630,    82,    31,    88,   170,   171,
      88,    92,   703,   203,    92,    88,    82,    31,    82,    92,
     101,   699,    47,   101,   186,     3,   107,   217,   109,   107,
     188,    88,   194,   195,    33,    92,   348,   349,   228,   162,
     198,   625,     6,   339,   436,    44,   358,   735,    31,   311,
     343,     3,   109,    31,     6,     3,    34,    34,     3,    40,
      41,     6,   224,    88,    82,   188,   224,    92,    34,     3,
       4,   383,     6,    37,    88,   701,   101,    88,    92,     6,
      32,    92,   107,    31,   109,   397,    31,   277,   545,   251,
     101,    40,    41,   251,   284,   109,   107,    31,   260,   257,
      34,   263,     3,    37,     4,     3,     6,    34,   298,   403,
      88,   404,   235,     3,    92,   803,    31,   347,   101,    68,
     413,    90,     4,   101,   107,   283,   107,   339,     6,   107,
      31,   109,   413,    93,   760,   325,   430,    37,     3,    37,
      88,    31,   111,    88,    92,   335,    47,    92,     6,   339,
     462,   341,   448,    87,    88,    37,   101,    47,    92,    37,
      31,   109,   107,     4,   109,     6,    31,   101,    34,    31,
      31,    37,   330,   107,    34,   109,   338,    37,   343,   805,
     338,   343,    47,   809,    31,    44,    47,    88,    39,   354,
      88,    92,   354,    34,    92,   661,    37,     4,    88,     6,
     101,    44,    92,    44,    64,    64,   364,     3,   109,    68,
     402,   402,   402,     3,    31,     3,    82,   402,    31,   109,
      31,    64,   402,    88,   386,    31,   826,    92,   420,   420,
     420,   421,   422,   402,    47,   420,   101,   427,   838,   839,
     420,    37,   422,    31,   109,   402,    34,    37,   402,   402,
     415,   420,   442,   415,   466,   402,   402,   402,   448,   449,
      31,   468,   402,   420,   402,   455,   420,   420,   402,   402,
     460,    31,   402,   420,   420,   420,   402,   402,   468,     4,
     420,     6,   420,   402,    33,    34,   420,   420,    37,   412,
     420,   402,    88,   416,   420,   420,    92,   402,    88,   568,
      88,   420,    92,   515,    92,   710,    11,   712,   466,   420,
     468,   523,   435,   101,    31,   420,   506,    94,    95,   107,
      31,   109,     3,   617,   618,   515,    42,    43,    34,    31,
      47,    37,   625,   523,   546,   527,   527,   527,    44,    40,
      41,   553,   527,    59,    60,   468,   627,   527,    32,    33,
      31,   644,   544,   544,   544,   545,   546,    31,   527,    89,
      31,    32,     3,   553,   544,     3,    82,    34,   598,   665,
     527,   533,     3,   527,   527,   637,    47,   843,    42,    43,
     527,   527,   527,    64,     4,    34,     6,   527,    37,   527,
      31,   608,   554,   527,   527,    59,    60,   527,   521,   589,
       3,   527,   527,   672,    32,    33,    47,    88,   527,    31,
     600,    92,    34,    34,    34,    37,   527,    37,   630,    37,
     101,     3,   527,   653,    34,     3,   107,    37,   109,    25,
      31,    32,   555,     3,    34,   731,     3,    37,    34,    18,
     630,    31,    32,    39,   634,    34,    47,    88,    37,    31,
     608,    92,    34,   665,   644,     6,    35,    47,   620,    34,
     101,    31,   654,   654,   654,     3,    37,    87,   658,   654,
      66,    67,   662,    32,   654,   665,    33,   667,    89,   644,
      33,   777,   644,    31,    32,   654,    65,    66,    67,   701,
     106,   107,    83,    31,    33,   685,    83,   654,   660,    47,
     654,   654,    98,   626,   666,    32,    88,   654,   654,   654,
      92,   701,   635,    89,   654,   107,   654,    31,    88,   101,
     654,   654,    92,    31,   654,   107,    89,   109,   654,   654,
      32,   101,    32,   695,   130,   654,   659,   107,   134,   109,
     136,   731,    32,   654,    10,   735,     3,   143,   760,   654,
      88,   674,   742,    37,    92,    32,   746,    31,    32,    44,
     750,   170,   171,   101,    32,    33,   162,    32,     3,   165,
     760,   109,    33,    47,    31,   737,   172,   186,   740,   702,
      32,   739,   740,   143,    83,   194,    34,   777,   104,   105,
     106,   107,   188,   805,   756,    32,    31,   809,   788,    34,
     196,    32,   198,   199,    54,   201,    32,   203,   204,   205,
       3,   823,    32,   803,   826,   805,    32,   779,    32,   809,
     782,   811,    32,    73,    74,    89,   838,   839,   224,   225,
      34,    88,    37,   823,   230,    92,   826,    34,    31,   235,
      89,   201,    89,     3,   101,   807,   808,    89,   838,   839,
     107,   260,   109,    88,   263,   251,   252,    92,    52,    32,
      32,    32,    37,     3,    34,   788,   101,   117,   791,   265,
       3,    31,   107,   269,   109,    34,    31,    31,    72,     3,
      38,    34,     3,    77,    34,    40,    41,   283,   811,    44,
      32,    31,    31,    40,    41,    88,    37,    44,    31,    92,
      32,   297,    33,    33,    31,   265,    44,    47,   101,   269,
      31,   111,    32,    68,   107,    82,   109,    64,    44,    38,
      31,    68,    37,   109,    38,    38,    47,    64,    88,   338,
     326,   327,    92,    32,   330,    64,   332,   132,   334,    64,
      38,   101,   338,    66,    32,    18,    31,   107,    88,   109,
      68,    32,    92,   349,    34,    88,    32,     3,    64,    92,
     154,   101,    35,   157,   158,   361,    34,    88,   101,   109,
     164,    92,   332,    32,   334,   169,   109,   386,    31,    34,
     101,    33,    32,    31,    33,    32,   180,   383,   109,    34,
      34,    34,    65,    66,    67,    32,    83,   191,   192,    31,
      11,   397,   398,   197,   198,    34,   200,    99,   100,   101,
     102,   103,   104,   105,   106,   107,   412,    38,    91,     3,
     416,    34,     6,   383,    32,    34,    33,    11,    12,    13,
      14,    15,    16,    17,    34,    31,    38,   397,   398,   435,
     436,   437,   237,   238,   440,    32,   241,   242,   243,   244,
      31,    31,    34,    32,    32,   305,    32,    34,    32,    34,
     456,   311,    32,    32,   404,   427,   261,    34,    34,   264,
     665,   544,   468,   811,   544,   544,   460,   437,   195,     1,
     440,     3,   644,     6,   343,   468,   455,   483,    11,    12,
      13,    14,    15,    16,    17,   491,    38,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,   102,
     103,   104,   105,   106,   107,   365,   658,    39,    40,    41,
      42,    43,   746,   483,   533,   521,   809,   750,   800,    18,
      -1,   491,   530,    -1,    -1,    -1,    58,    59,    60,    -1,
      -1,    -1,    -1,    -1,    -1,   554,    -1,    -1,    -1,    -1,
      -1,    -1,   548,    -1,    -1,    -1,    -1,    -1,    -1,   555,
      -1,    -1,    -1,    -1,    -1,    -1,    88,    -1,    -1,    91,
      92,    -1,    -1,   423,    -1,    -1,    -1,   372,   373,   374,
     375,   431,   377,   378,   379,   380,   381,   382,   548,    -1,
      -1,    -1,   387,    19,    20,    21,    22,    23,    24,    25,
      -1,    27,   598,    -1,    -1,    -1,    -1,   401,    -1,   403,
     404,   620,    -1,    -1,    -1,    -1,    -1,   411,   412,   413,
      -1,    -1,    -1,    32,    -1,    -1,    -1,    -1,    -1,    -1,
     626,    -1,    -1,    -1,    -1,    -1,   430,    -1,    -1,   635,
      -1,   435,   100,   101,   102,   103,   104,   105,   106,   107,
      -1,   660,    -1,    -1,    -1,    -1,    -1,   666,    48,    -1,
      -1,    -1,    -1,   659,    -1,    -1,    -1,    -1,    -1,   464,
      -1,   466,    -1,    -1,    -1,    -1,    -1,    -1,   674,   529,
      -1,   677,   678,    -1,    -1,    -1,   695,   683,    97,    98,
      99,   100,   101,   102,   103,   104,   105,   106,   107,    -1,
      48,    -1,    -1,    -1,    -1,    -1,   702,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,    -1,    -1,
      -1,   717,    -1,    -1,    -1,    48,    -1,   521,   737,    -1,
      -1,   740,   728,    -1,   528,    -1,   530,   101,   102,   103,
     104,   105,   106,   107,   740,    -1,    -1,   756,   598,    97,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
      98,    99,   100,   101,   102,   103,   104,   105,   106,   107,
     779,    -1,    -1,   782,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    48,    -1,   637,    -1,    -1,
      -1,    -1,   788,    -1,   790,   791,    -1,    -1,   807,   808,
      -1,    -1,    -1,   653,   800,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   607,    -1,   609,   811,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,   617,   618,    -1,   676,    -1,    -1,   623,
      -1,   625,    -1,   627,    97,    98,    99,   100,   101,   102,
     103,   104,   105,   106,   107,    -1,     1,    -1,     3,     4,
      -1,    -1,    -1,    -1,     9,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,   657,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    -1,    -1,    -1,    34,
      35,    -1,    -1,    38,    -1,    40,    41,    42,    43,    -1,
      -1,    -1,    -1,   688,    -1,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,   703,
      65,    66,    67,    -1,    69,    70,    -1,    -1,    -1,    74,
      -1,    76,    77,    78,    79,    80,    81,    -1,    -1,    -1,
      -1,    86,    -1,    88,    -1,    -1,    91,    92,    93,     3,
      -1,    -1,     6,    -1,    -1,    -1,    -1,    11,    12,    13,
      14,    15,    16,    17,   109,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    40,    41,    42,    43,
      -1,    45,    -1,    -1,    48,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    58,    59,    60,    97,    98,    99,
     100,   101,   102,   103,   104,   105,   106,   107,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    88,    -1,    -1,    -1,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,
     104,   105,     6,    -1,   108,   109,    -1,    11,    12,    13,
      14,    15,    16,    17,    -1,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    40,    41,    42,    43,
      -1,    45,    -1,    -1,    48,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    58,    59,    60,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    88,    -1,    -1,    -1,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,
     104,   105,     6,    -1,   108,   109,    -1,    11,    12,    13,
      14,    15,    16,    17,    -1,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    40,    41,    42,    43,
      -1,    45,    -1,    -1,    48,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    58,    59,    60,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    88,    -1,    -1,    -1,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,
     104,   105,     6,    -1,   108,   109,    -1,    11,    12,    13,
      14,    15,    16,    17,    -1,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    40,    41,    42,    43,
      -1,    45,    -1,    -1,    48,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    58,    59,    60,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    88,    -1,    -1,    -1,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,
     104,   105,     6,    -1,   108,   109,    -1,    11,    12,    13,
      14,    15,    16,    17,    -1,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    40,    41,    42,    43,
      -1,    45,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    58,    59,    60,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    88,    -1,    -1,    -1,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,
     104,   105,     6,    -1,   108,   109,    -1,    11,    12,    13,
      14,    15,    16,    17,    -1,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    40,    41,    42,    43,
      -1,    45,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    58,    59,    60,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    88,    -1,    -1,    -1,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,
     104,   105,     6,   107,   108,   109,    10,    11,    12,    13,
      14,    15,    16,    17,    -1,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    40,    41,    42,    43,
      -1,    45,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    58,    59,    60,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    88,    -1,    -1,    -1,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,     3,
     104,   105,     6,    -1,   108,   109,    -1,    11,    12,    13,
      14,    15,    16,    17,    -1,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    40,    41,    42,    43,
      -1,    45,     3,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    58,    59,    60,    -1,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    39,    40,
      41,    42,    43,    -1,    88,    -1,    47,    -1,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    58,    59,    60,
     104,   105,    -1,    -1,   108,   109,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    88,    -1,    -1,
      91,    92,     3,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
     101,    -1,    -1,    -1,    -1,    -1,   107,    -1,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      31,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    39,    40,
      41,    42,    43,    -1,    -1,    -1,    47,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,     3,    58,    59,    60,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    -1,    -1,    -1,    88,    -1,    -1,
      91,    92,    39,    40,    41,    42,    43,    -1,    -1,    -1,
     101,    -1,    -1,    -1,    -1,    -1,   107,     3,    -1,    -1,
      -1,    58,    59,    60,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    -1,    -1,    -1,    -1,
      -1,    88,    -1,    -1,    91,    92,    42,    43,     0,     1,
      -1,     3,     4,    -1,   101,     7,     8,     9,    -1,    -1,
     107,    -1,    58,    59,    60,    -1,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    -1,
      -1,    -1,    34,    35,    -1,    -1,    -1,    -1,    40,    41,
      42,    43,    88,    -1,    46,    -1,    92,    -1,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    -1,
      -1,   107,    -1,    65,    66,    67,    -1,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      -1,    -1,    -1,    -1,    86,     1,    88,     3,     4,    91,
      92,     7,     8,     9,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    -1,    -1,    34,    35,
      -1,    -1,    38,    -1,    40,    41,    42,    43,    -1,    -1,
      46,    -1,    -1,    -1,    50,    51,    52,    53,    54,    55,
      56,    57,    58,    59,    60,    -1,    -1,    -1,    -1,    65,
      66,    67,    -1,    69,    70,    71,    72,    73,    74,    75,
      76,    77,    78,    79,    80,    81,    -1,    -1,    -1,    -1,
      86,     1,    88,     3,     4,    91,    92,     7,     8,     9,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    -1,    -1,    34,    35,    -1,    -1,    38,    -1,
      40,    41,    42,    43,    -1,    -1,    46,    -1,    -1,    -1,
      50,    51,    52,    53,    54,    55,    56,    57,    58,    59,
      60,    -1,    -1,    -1,    -1,    65,    66,    67,    -1,    69,
      70,    71,    72,    73,    74,    75,    76,    77,    78,    79,
      80,    81,    -1,    -1,    -1,    -1,    86,     1,    88,     3,
       4,    91,    92,     7,     8,     9,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    -1,    -1,
      34,    35,    -1,    -1,    38,    -1,    40,    41,    42,    43,
      -1,    -1,    46,    -1,    -1,    -1,    50,    51,    52,    53,
      54,    55,    56,    57,    58,    59,    60,    -1,    -1,    -1,
      -1,    65,    66,    67,    -1,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    -1,    -1,
      -1,    -1,    86,     1,    88,     3,     4,    91,    92,     7,
       8,     9,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    -1,    -1,    34,    35,    -1,    -1,
      -1,    -1,    40,    41,    42,    43,    -1,    -1,    46,    -1,
      48,    -1,    50,    51,    52,    53,    54,    55,    56,    57,
      58,    59,    60,    -1,    -1,    -1,    -1,    65,    66,    67,
      -1,    69,    70,    71,    72,    73,    74,    75,    76,    77,
      78,    79,    80,    81,     1,    -1,     3,    -1,    86,    -1,
      88,    -1,    -1,    91,    92,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    39,    40,    41,    42,    43,     1,    -1,     3,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    58,    59,    60,    -1,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    40,    41,    42,    43,
      -1,    88,     3,    -1,    91,    92,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    58,    59,    60,    -1,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    40,
      41,    42,    43,    -1,    88,    -1,    -1,    -1,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    58,    59,    60,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,     3,    -1,    88,     6,    -1,
      -1,    92,    93,    11,    12,    13,    14,    15,    16,    17,
      -1,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    39,    40,    41,    42,    43,    -1,     3,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    11,    -1,    -1,    -1,    -1,
      58,    59,    60,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    39,    40,    41,    42,    43,    -1,     3,
      88,    -1,    -1,    91,    92,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    58,    59,    60,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    39,    40,    41,    42,    43,
      -1,     3,    88,    -1,    -1,    91,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    58,    59,    60,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    40,    41,
      42,    43,    -1,     3,    88,    -1,    -1,    91,    92,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    58,    59,    60,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      40,    41,    42,    43,    -1,     3,    88,    -1,    -1,    -1,
      92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    58,    59,
      60,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    40,    41,    42,    43,    -1,     3,    88,    -1,
      -1,    -1,    92,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      58,    59,    60,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    40,    41,    42,    43,    -1,     3,
      88,    -1,    -1,    -1,    92,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    58,    59,    60,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    42,    43,
      -1,    -1,    88,    -1,    -1,    -1,    92,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    58,    59,    60,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    88,    -1,    -1,    -1,    92
};

/* YYSTOS[STATE-NUM] -- The (internal number of the) accessing
   symbol of state STATE-NUM.  */
static const unsigned char yystos[] =
{
       0,    94,    95,   113,   114,   252,     1,     3,    19,    20,
      21,    22,    23,    24,    25,    26,    27,    28,    29,    30,
      39,    40,    41,    42,    43,    58,    59,    60,    88,    91,
      92,   195,   209,   210,   212,   213,   214,   215,   216,   232,
     242,   244,     1,   195,     0,     1,     4,     7,     8,     9,
      18,    34,    35,    46,    50,    51,    52,    53,    54,    55,
      56,    57,    65,    66,    67,    69,    70,    71,    72,    73,
      74,    75,    76,    77,    78,    79,    80,    81,    86,    91,
     115,   116,   117,   119,   120,   121,   122,   123,   126,   127,
     129,   130,   131,   132,   133,   134,   135,   138,   139,   140,
     143,   145,   150,   151,   152,   153,   154,   157,   158,   159,
     160,   161,   165,   166,   170,   171,   181,   191,   252,    82,
     239,   252,   239,    39,   242,   111,    82,    34,   213,   209,
      31,    44,    47,    64,   101,   107,   109,   200,   201,   203,
     205,   206,   207,   208,   242,   252,   209,   215,   242,    90,
     111,   243,    34,    93,    31,     6,   247,    31,   249,   252,
       1,     3,   211,   212,    31,   249,    31,   137,   252,    31,
      31,    31,    71,   242,     3,    37,   242,    31,     4,    37,
      31,    31,    34,    37,     4,   247,    31,   149,   211,   147,
     149,    31,    31,   247,    31,    82,   232,   249,    31,   101,
     203,   208,   242,    58,   211,   232,     6,    11,    12,    13,
      14,    15,    16,    17,   195,   196,   197,   199,   224,   252,
      39,    92,   244,   232,    31,   101,   192,   193,   195,   206,
     208,   242,   252,    10,    37,   101,   217,   218,    31,    45,
      48,   104,   105,   108,   109,   211,   223,   224,   225,   247,
      11,    31,   109,   204,   207,   242,   208,   209,   242,   200,
      31,    47,   200,    31,    47,   101,   204,   207,   242,    89,
     244,    92,   244,     3,   240,   247,     6,    37,   240,   250,
     240,    34,    44,    31,   203,    32,   240,   242,     3,     3,
     240,    11,   144,   192,   192,   242,    34,    44,   173,    37,
       3,   146,   250,     3,   192,    37,   202,   203,   206,   252,
      34,    33,   148,   252,   240,   241,   252,   124,   125,   247,
     192,   169,   193,   242,   247,     3,   101,   208,   240,   242,
      31,   240,   101,   242,    89,     3,   219,   252,    31,   203,
      37,   242,    83,    33,   198,   252,   243,    83,   101,   208,
     242,   205,   242,    32,    33,   194,   252,    32,   101,   205,
     242,    89,   203,   223,   223,    31,   223,   223,   223,   223,
      31,    48,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   208,   242,   242,    31,    47,   208,   192,
      48,   223,   192,    48,   223,   204,   207,    89,   101,   204,
     243,    32,   114,    33,    44,    32,   217,   200,    32,    37,
      32,    44,    32,    33,   142,    33,    32,    32,    34,   242,
     114,   172,    32,    32,    32,    32,   147,   149,    32,    32,
      33,    37,    32,    83,    47,    32,    89,   208,   242,    34,
      89,    34,    37,   192,   242,    68,   156,   200,   209,   163,
      34,    64,   226,   227,   252,   199,   232,   242,    89,    32,
     195,    32,    89,   205,    32,   101,   107,   208,   211,   223,
     223,   223,   223,   223,   223,   223,   223,   223,   223,   223,
     204,   242,    32,    89,   192,    48,   223,    32,    48,    32,
      48,   101,   204,   207,   204,     4,    37,   247,    38,   250,
     124,   224,   247,   251,    34,    34,   118,     4,   136,   247,
       4,    34,    37,    87,   141,   203,   247,   248,   240,   247,
     251,    32,   195,   203,    37,    34,    38,   114,    35,   191,
     147,    34,    37,    31,    38,   148,     3,    88,    92,   245,
      34,   250,   211,    34,   167,   128,   203,   247,    89,     3,
     220,   221,   252,    32,    31,    33,    34,    37,   155,    68,
     200,     1,    34,    54,    61,    62,    63,    66,   109,   119,
     120,   121,   122,   126,   131,   133,   135,   138,   140,   143,
     145,   150,   151,   152,   153,   165,   166,   170,   174,   177,
     178,   179,   180,   181,   182,   183,   187,   190,   191,   252,
     228,    37,   198,   242,   194,    32,   223,    32,   209,    32,
     101,   201,    32,   204,    32,    48,   204,    33,    33,   174,
      31,    68,   209,   234,   252,    44,    32,    33,   142,   141,
     203,   234,    38,   247,     3,   211,    34,    44,   248,   192,
      90,   111,   246,   111,    82,    32,    38,   154,   161,   165,
     166,   168,   178,   191,   114,   234,    34,    44,    33,    38,
      31,    44,   234,   235,   192,   203,    31,   176,    37,    64,
      64,    64,   109,   244,    38,   174,    93,   211,   232,   242,
      66,   229,   230,   233,   252,   162,   223,   223,    32,    32,
      32,   250,   250,    38,   192,    31,    68,   141,   247,   251,
      34,   203,    32,   234,    34,    34,   203,   149,    32,     3,
       3,    92,     3,    92,   196,     4,    37,   211,    48,    34,
      10,   222,   223,   221,    34,   203,   192,   217,    64,   236,
     252,    32,   156,   192,   174,   175,   244,    31,   203,   211,
      31,    64,     3,    37,   242,    34,    33,    61,    62,    63,
     231,   242,   174,   223,    32,   192,    31,   142,   234,    34,
     203,   141,    34,    34,   246,   246,    83,   155,    32,    34,
     237,   238,   242,    34,    37,   200,   155,    32,   174,    31,
     192,   155,    31,   101,   208,   192,    11,    37,   185,   230,
     233,    38,    34,    32,   192,    34,   234,    34,    34,    37,
      33,    31,   200,    38,   192,    32,   192,    31,    31,    32,
      34,   184,   186,   203,   252,   242,    34,   164,   203,    32,
      34,   238,   174,    32,   188,   234,    32,   192,   192,   235,
     186,    34,   155,   189,   234,    34,    37,   189,    32,    32,
      34,    34,    37,    44,   189,   189,   217,    34
};

#if ! defined (YYSIZE_T) && defined (__SIZE_TYPE__)
# define YYSIZE_T __SIZE_TYPE__
#endif
#if ! defined (YYSIZE_T) && defined (size_t)
# define YYSIZE_T size_t
#endif
#if ! defined (YYSIZE_T)
# if defined (__STDC__) || defined (__cplusplus)
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# endif
#endif
#if ! defined (YYSIZE_T)
# define YYSIZE_T unsigned int
#endif

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		(-2)
#define YYEOF		0

#define YYACCEPT	goto yyacceptlab
#define YYABORT		goto yyabortlab
#define YYERROR		goto yyerrlab1

/* Like YYERROR except do call yyerror.  This remains here temporarily
   to ease the transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */

#define YYFAIL		goto yyerrlab

#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)					\
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    {								\
      yychar = (Token);						\
      yylval = (Value);						\
      yytoken = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { 								\
      yyerror ("syntax error: cannot back up");\
      YYERROR;							\
    }								\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

/* YYLLOC_DEFAULT -- Compute the default location (before the actions
   are run).  */

#ifndef YYLLOC_DEFAULT
# define YYLLOC_DEFAULT(Current, Rhs, N)         \
  Current.first_line   = Rhs[1].first_line;      \
  Current.first_column = Rhs[1].first_column;    \
  Current.last_line    = Rhs[N].last_line;       \
  Current.last_column  = Rhs[N].last_column;
#endif

/* YYLEX -- calling `yylex' with the right arguments.  */

#ifdef YYLEX_PARAM
# define YYLEX yylex (YYLEX_PARAM)
#else
# define YYLEX yylex ()
#endif

/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)			\
do {						\
  if (yydebug)					\
    YYFPRINTF Args;				\
} while (0)

# define YYDSYMPRINT(Args)			\
do {						\
  if (yydebug)					\
    yysymprint Args;				\
} while (0)

# define YYDSYMPRINTF(Title, Token, Value, Location)		\
do {								\
  if (yydebug)							\
    {								\
      YYFPRINTF (stderr, "%s ", Title);				\
      yysymprint (stderr, 					\
                  Token, Value);	\
      YYFPRINTF (stderr, "\n");					\
    }								\
} while (0)

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (cinluded).                                                   |
`------------------------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_stack_print (short *bottom, short *top)
#else
static void
yy_stack_print (bottom, top)
    short *bottom;
    short *top;
#endif
{
  YYFPRINTF (stderr, "Stack now");
  for (/* Nothing. */; bottom <= top; ++bottom)
    YYFPRINTF (stderr, " %d", *bottom);
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)				\
do {								\
  if (yydebug)							\
    yy_stack_print ((Bottom), (Top));				\
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yy_reduce_print (int yyrule)
#else
static void
yy_reduce_print (yyrule)
    int yyrule;
#endif
{
  int yyi;
  unsigned int yylineno = yyrline[yyrule];
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %u), ",
             yyrule - 1, yylineno);
  /* Print the symbols being reduced, and their result.  */
  for (yyi = yyprhs[yyrule]; 0 <= yyrhs[yyi]; yyi++)
    YYFPRINTF (stderr, "%s ", yytname [yyrhs[yyi]]);
  YYFPRINTF (stderr, "-> %s\n", yytname [yyr1[yyrule]]);
}

# define YY_REDUCE_PRINT(Rule)		\
do {					\
  if (yydebug)				\
    yy_reduce_print (Rule);		\
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args)
# define YYDSYMPRINT(Args)
# define YYDSYMPRINTF(Title, Token, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef	YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   SIZE_MAX < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#if YYMAXDEPTH == 0
# undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif



#if YYERROR_VERBOSE

# ifndef yystrlen
#  if defined (__GLIBC__) && defined (_STRING_H)
#   define yystrlen strlen
#  else
/* Return the length of YYSTR.  */
static YYSIZE_T
#   if defined (__STDC__) || defined (__cplusplus)
yystrlen (const char *yystr)
#   else
yystrlen (yystr)
     const char *yystr;
#   endif
{
  register const char *yys = yystr;

  while (*yys++ != '\0')
    continue;

  return yys - yystr - 1;
}
#  endif
# endif

# ifndef yystpcpy
#  if defined (__GLIBC__) && defined (_STRING_H) && defined (_GNU_SOURCE)
#   define yystpcpy stpcpy
#  else
/* Copy YYSRC to YYDEST, returning the address of the terminating '\0' in
   YYDEST.  */
static char *
#   if defined (__STDC__) || defined (__cplusplus)
yystpcpy (char *yydest, const char *yysrc)
#   else
yystpcpy (yydest, yysrc)
     char *yydest;
     const char *yysrc;
#   endif
{
  register char *yyd = yydest;
  register const char *yys = yysrc;

  while ((*yyd++ = *yys++) != '\0')
    continue;

  return yyd - 1;
}
#  endif
# endif

#endif /* !YYERROR_VERBOSE */



#if YYDEBUG
/*--------------------------------.
| Print this symbol on YYOUTPUT.  |
`--------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yysymprint (FILE *yyoutput, int yytype, YYSTYPE *yyvaluep)
#else
static void
yysymprint (yyoutput, yytype, yyvaluep)
    FILE *yyoutput;
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  if (yytype < YYNTOKENS)
    {
      YYFPRINTF (yyoutput, "token %s (", yytname[yytype]);
# ifdef YYPRINT
      YYPRINT (yyoutput, yytoknum[yytype], *yyvaluep);
# endif
    }
  else
    YYFPRINTF (yyoutput, "nterm %s (", yytname[yytype]);

  switch (yytype)
    {
      default:
        break;
    }
  YYFPRINTF (yyoutput, ")");
}

#endif /* ! YYDEBUG */
/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

#if defined (__STDC__) || defined (__cplusplus)
static void
yydestruct (int yytype, YYSTYPE *yyvaluep)
#else
static void
yydestruct (yytype, yyvaluep)
    int yytype;
    YYSTYPE *yyvaluep;
#endif
{
  /* Pacify ``unused variable'' warnings.  */
  (void) yyvaluep;

  switch (yytype)
    {

      default:
        break;
    }
}


/* Prevent warnings from -Wmissing-prototypes.  */

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM);
# else
int yyparse ();
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int yyparse (void);
#else
int yyparse ();
#endif
#endif /* ! YYPARSE_PARAM */



/* The lookahead symbol.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;

/* Number of syntax errors so far.  */
int yynerrs;



/*----------.
| yyparse.  |
`----------*/

#ifdef YYPARSE_PARAM
# if defined (__STDC__) || defined (__cplusplus)
int yyparse (void *YYPARSE_PARAM)
# else
int yyparse (YYPARSE_PARAM)
  void *YYPARSE_PARAM;
# endif
#else /* ! YYPARSE_PARAM */
#if defined (__STDC__) || defined (__cplusplus)
int
yyparse (void)
#else
int
yyparse ()

#endif
#endif
{
  
  register int yystate;
  register int yyn;
  int yyresult;
  /* Number of tokens to shift before error messages enabled.  */
  int yyerrstatus;
  /* Lookahead token as an internal (translated) token number.  */
  int yytoken = 0;

  /* Three stacks and their tools:
     `yyss': related to states,
     `yyvs': related to semantic values,
     `yyls': related to locations.

     Refer to the stacks thru separate pointers, to allow yyoverflow
     to reallocate them elsewhere.  */

  /* The state stack.  */
  short	yyssa[YYINITDEPTH];
  short *yyss = yyssa;
  register short *yyssp;

  /* The semantic value stack.  */
  YYSTYPE yyvsa[YYINITDEPTH];
  YYSTYPE *yyvs = yyvsa;
  register YYSTYPE *yyvsp;



#define YYPOPSTACK   (yyvsp--, yyssp--)

  YYSIZE_T yystacksize = YYINITDEPTH;

  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;


  /* When reducing, the number of symbols on the RHS of the reduced
     rule.  */
  int yylen;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss;
  yyvsp = yyvs;

  goto yysetstate;

/*------------------------------------------------------------.
| yynewstate -- Push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
 yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed. so pushing a state here evens the stacks.
     */
  yyssp++;

 yysetstate:
  *yyssp = yystate;

  if (yyss + yystacksize - 1 <= yyssp)
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYSIZE_T yysize = yyssp - yyss + 1;

#ifdef yyoverflow
      {
	/* Give user a chance to reallocate the stack. Use copies of
	   these so that the &'s don't force the real ones into
	   memory.  */
	YYSTYPE *yyvs1 = yyvs;
	short *yyss1 = yyss;


	/* Each stack pointer address is followed by the size of the
	   data in use in that stack, in bytes.  This used to be a
	   conditional around just the two extra args, but that might
	   be undefined if yyoverflow is a macro.  */
	yyoverflow ("parser stack overflow",
		    &yyss1, yysize * sizeof (*yyssp),
		    &yyvs1, yysize * sizeof (*yyvsp),

		    &yystacksize);

	yyss = yyss1;
	yyvs = yyvs1;
      }
#else /* no yyoverflow */
# ifndef YYSTACK_RELOCATE
      goto yyoverflowlab;
# else
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
	goto yyoverflowlab;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
	yystacksize = YYMAXDEPTH;

      {
	short *yyss1 = yyss;
	union yyalloc *yyptr =
	  (union yyalloc *) YYSTACK_ALLOC (YYSTACK_BYTES (yystacksize));
	if (! yyptr)
	  goto yyoverflowlab;
	YYSTACK_RELOCATE (yyss);
	YYSTACK_RELOCATE (yyvs);

#  undef YYSTACK_RELOCATE
	if (yyss1 != yyssa)
	  YYSTACK_FREE (yyss1);
      }
# endif
#endif /* no yyoverflow */

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;


      YYDPRINTF ((stderr, "Stack size increased to %lu\n",
		  (unsigned long int) yystacksize));

      if (yyss + yystacksize - 1 <= yyssp)
	YYABORT;
    }

  YYDPRINTF ((stderr, "Entering state %d\n", yystate));

  goto yybackup;

/*-----------.
| yybackup.  |
`-----------*/
yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYPACT_NINF)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either YYEMPTY or YYEOF or a valid lookahead symbol.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token: "));
      yychar = YYLEX;
    }

  if (yychar <= YYEOF)
    {
      yychar = yytoken = YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YYDSYMPRINTF ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yyn == 0 || yyn == YYTABLE_NINF)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */
  YYDPRINTF ((stderr, "Shifting token %s, ", yytname[yytoken]));

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;


  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  yystate = yyn;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- Do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     `$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
        case 2:
#line 1018 "parser.y"
    {
		   Setattr(yyvsp[0].node,"classes",classes); 
		   Setattr(yyvsp[0].node,"name",ModuleName);
		   
		   if ((!module_node) && ModuleName) {
		     module_node = new_node("module");
		     Setattr(module_node,"name",ModuleName);
		   }
		   Setattr(yyvsp[0].node,"module",module_node);
		   check_extensions();
	           top = yyvsp[0].node;
               }
    break;

  case 3:
#line 1030 "parser.y"
    {
                 top = Getattr(yyvsp[-1].p,"type");
               }
    break;

  case 4:
#line 1033 "parser.y"
    {
                 top = 0;
               }
    break;

  case 5:
#line 1036 "parser.y"
    {
                 top = yyvsp[-1].p;
               }
    break;

  case 6:
#line 1039 "parser.y"
    {
                 top = 0;
               }
    break;

  case 7:
#line 1044 "parser.y"
    {  
                   appendChild(yyvsp[-1].node,yyvsp[0].node);
                   yyval.node = yyvsp[-1].node;
               }
    break;

  case 8:
#line 1048 "parser.y"
    {
                   yyval.node = new_node("top");
               }
    break;

  case 9:
#line 1053 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 10:
#line 1054 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 11:
#line 1055 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 12:
#line 1056 "parser.y"
    { yyval.node = 0; }
    break;

  case 13:
#line 1057 "parser.y"
    {
                  yyval.node = 0;
		  if (!Swig_error_count()) {
		    static int last_error_line = -1;
		    if (last_error_line != cparse_line) {
		      Swig_error(cparse_file, cparse_line,"Syntax error in input.\n");
		      last_error_line = cparse_line;
		      skip_decl();
		    }
		  }
               }
    break;

  case 14:
#line 1069 "parser.y"
    { 
                  if (yyval.node) {
   		      add_symbols(yyval.node);
                  }
                  yyval.node = yyvsp[0].node; 
	       }
    break;

  case 15:
#line 1085 "parser.y"
    {
                  yyval.node = 0;
                  skip_decl();
               }
    break;

  case 16:
#line 1095 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 17:
#line 1096 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 18:
#line 1097 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 19:
#line 1098 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 20:
#line 1099 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 21:
#line 1100 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 22:
#line 1101 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 23:
#line 1102 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 24:
#line 1103 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 25:
#line 1104 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 26:
#line 1105 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 27:
#line 1106 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 28:
#line 1107 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 29:
#line 1108 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 30:
#line 1109 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 31:
#line 1110 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 32:
#line 1111 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 33:
#line 1112 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 34:
#line 1113 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 35:
#line 1114 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 36:
#line 1115 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 37:
#line 1122 "parser.y"
    {
               Node *cls;
	       String *clsname;
	       cplus_mode = CPLUS_PUBLIC;
	       if (!classes) classes = NewHash();
	       if (!extendhash) extendhash = NewHash();
	       clsname = make_class_name(yyvsp[-1].str);
	       cls = Getattr(classes,clsname);
	       if (!cls) {
		 /* No previous definition. Create a new scope */
		 Node *am = Getattr(extendhash,clsname);
		 if (!am) {
		   Swig_symbol_newscope();
		   Swig_symbol_setscopename(yyvsp[-1].str);
		   prev_symtab = 0;
		 } else {
		   prev_symtab = Swig_symbol_setscope(Getattr(am,"symtab"));
		 }
		 current_class = 0;
	       } else {
		 /* Previous class definition.  Use its symbol table */
		 prev_symtab = Swig_symbol_setscope(Getattr(cls,"symtab"));
		 current_class = cls;
		 extendmode = 1;
	       }
	       Classprefix = NewString(yyvsp[-1].str);
	       Namespaceprefix= Swig_symbol_qualifiedscopename(0);
	       Delete(clsname);
	     }
    break;

  case 38:
#line 1150 "parser.y"
    {
               String *clsname;
	       extendmode = 0;
               yyval.node = new_node("extend");
	       Setattr(yyval.node,"symtab",Swig_symbol_popscope());
	       if (prev_symtab) {
		 Swig_symbol_setscope(prev_symtab);
	       }
	       Namespaceprefix = Swig_symbol_qualifiedscopename(0);
               clsname = make_class_name(yyvsp[-4].str);
	       Setattr(yyval.node,"name",clsname);

	       /* Mark members as extend */

	       Swig_tag_nodes(yyvsp[-1].node,"feature:extend",(char*) "1");
	       if (current_class) {
		 /* We add the extension to the previously defined class */
		 appendChild(yyval.node,yyvsp[-1].node);
		 appendChild(current_class,yyval.node);
	       } else {
		 /* We store the extensions in the extensions hash */
		 Node *am = Getattr(extendhash,clsname);
		 if (am) {
		   /* Append the members to the previous extend methods */
		   appendChild(am,yyvsp[-1].node);
		 } else {
		   appendChild(yyval.node,yyvsp[-1].node);
		   Setattr(extendhash,clsname,yyval.node);
		 }
	       }
	       current_class = 0;
	       Delete(Classprefix);
	       Delete(clsname);
	       Classprefix = 0;
	       prev_symtab = 0;
	       yyval.node = 0;

	     }
    break;

  case 39:
#line 1194 "parser.y"
    {
                    yyval.node = new_node("apply");
                    Setattr(yyval.node,"pattern",Getattr(yyvsp[-3].p,"pattern"));
		    appendChild(yyval.node,yyvsp[-1].p);
               }
    break;

  case 40:
#line 1204 "parser.y"
    {
		 yyval.node = new_node("clear");
		 appendChild(yyval.node,yyvsp[-1].p);
               }
    break;

  case 41:
#line 1215 "parser.y"
    {
		   if ((yyvsp[-1].dtype.type != T_ERROR) && (yyvsp[-1].dtype.type != T_SYMBOL)) {
		     yyval.node = new_node("constant");
		     Setattr(yyval.node,"name",yyvsp[-3].id);
		     Setattr(yyval.node,"type",NewSwigType(yyvsp[-1].dtype.type));
		     Setattr(yyval.node,"value",yyvsp[-1].dtype.val);
		     if (yyvsp[-1].dtype.rawval) Setattr(yyval.node,"rawval", yyvsp[-1].dtype.rawval);
		     Setattr(yyval.node,"storage","%constant");
		     Setattr(yyval.node,"feature:immutable","1");
		     add_symbols(yyval.node);
		   } else {
		     if (yyvsp[-1].dtype.type == T_ERROR) {
		       Swig_warning(WARN_PARSE_UNSUPPORTED_VALUE,cparse_file,cparse_line,"Unsupported constant value (ignored)\n");
		     }
		     yyval.node = 0;
		   }

	       }
    break;

  case 42:
#line 1234 "parser.y"
    {
		 if ((yyvsp[-1].dtype.type != T_ERROR) && (yyvsp[-1].dtype.type != T_SYMBOL)) {
		   SwigType_push(yyvsp[-3].type,yyvsp[-2].decl.type);
		   /* Sneaky callback function trick */
		   if (SwigType_isfunction(yyvsp[-3].type)) {
		     SwigType_add_pointer(yyvsp[-3].type);
		   }
		   yyval.node = new_node("constant");
		   Setattr(yyval.node,"name",yyvsp[-2].decl.id);
		   Setattr(yyval.node,"type",yyvsp[-3].type);
		   Setattr(yyval.node,"value",yyvsp[-1].dtype.val);
		   if (yyvsp[-1].dtype.rawval) Setattr(yyval.node,"rawval", yyvsp[-1].dtype.rawval);
		   Setattr(yyval.node,"storage","%constant");
		   Setattr(yyval.node,"feature:immutable","1");
		   add_symbols(yyval.node);
		 } else {
		     if (yyvsp[-1].dtype.type == T_ERROR) {
		       Swig_warning(WARN_PARSE_UNSUPPORTED_VALUE,cparse_file,cparse_line,"Unsupported constant value\n");
		     }
		   yyval.node = 0;
		 }
               }
    break;

  case 43:
#line 1256 "parser.y"
    {
		 Swig_warning(WARN_PARSE_BAD_VALUE,cparse_file,cparse_line,"Bad constant value (ignored).\n");
		 yyval.node = 0;
	       }
    break;

  case 44:
#line 1267 "parser.y"
    {
		 char temp[64];
		 Replace(yyvsp[0].str,"$file",cparse_file, DOH_REPLACE_ANY);
		 sprintf(temp,"%d", cparse_line);
		 Replace(yyvsp[0].str,"$line",temp,DOH_REPLACE_ANY);
		 Printf(stderr,"%s\n", yyvsp[0].str);
		 Delete(yyvsp[0].str);
                 yyval.node = 0;
	       }
    break;

  case 45:
#line 1276 "parser.y"
    {
		 char temp[64];
		 String *s = NewString(yyvsp[0].id);
		 Replace(s,"$file",cparse_file, DOH_REPLACE_ANY);
		 sprintf(temp,"%d", cparse_line);
		 Replace(s,"$line",temp,DOH_REPLACE_ANY);
		 Printf(stderr,"%s\n", s);
		 Delete(s);
                 yyval.node = 0;
               }
    break;

  case 46:
#line 1295 "parser.y"
    {
                    skip_balanced('{','}');
		    yyval.node = 0;
		    Swig_warning(WARN_DEPRECATED_EXCEPT,cparse_file, cparse_line, "%%except is deprecated.  Use %%exception instead.\n");
	       }
    break;

  case 47:
#line 1301 "parser.y"
    {
                    skip_balanced('{','}');
		    yyval.node = 0;
		    Swig_warning(WARN_DEPRECATED_EXCEPT,cparse_file, cparse_line, "%%except is deprecated.  Use %%exception instead.\n");
               }
    break;

  case 48:
#line 1307 "parser.y"
    {
		 yyval.node = 0;
		 Swig_warning(WARN_DEPRECATED_EXCEPT,cparse_file, cparse_line, "%%except is deprecated.  Use %%exception instead.\n");
               }
    break;

  case 49:
#line 1312 "parser.y"
    {
		 yyval.node = 0;
		 Swig_warning(WARN_DEPRECATED_EXCEPT,cparse_file, cparse_line, "%%except is deprecated.  Use %%exception instead.\n");
	       }
    break;

  case 50:
#line 1323 "parser.y"
    {		 
                 yyval.node = NewHash();
                 Setattr(yyval.node,"value",yyvsp[-3].id);
		 Setattr(yyval.node,"type",yyvsp[-1].type);
               }
    break;

  case 51:
#line 1330 "parser.y"
    {
                 yyval.node = NewHash();
                 Setattr(yyval.node,"value",yyvsp[0].id);
              }
    break;

  case 52:
#line 1334 "parser.y"
    {
                yyval.node = yyvsp[0].node;
              }
    break;

  case 53:
#line 1339 "parser.y"
    {
                   Hash *p = yyvsp[-2].node;
		   yyval.node = new_node("fragment");
		   Setattr(yyval.node,"value",Getattr(yyvsp[-4].node,"value"));
		   Setattr(yyval.node,"type",Getattr(yyvsp[-4].node,"type"));
		   Setattr(yyval.node,"section",Getattr(p,"name"));
		   Setattr(yyval.node,"kwargs",nextSibling(p));
		   Setattr(yyval.node,"code",yyvsp[0].str);
                 }
    break;

  case 54:
#line 1348 "parser.y"
    {
		   Hash *p = yyvsp[-2].node;
                   skip_balanced('{','}');
		   yyval.node = new_node("fragment");
		   Setattr(yyval.node,"value",Getattr(yyvsp[-4].node,"value"));
		   Setattr(yyval.node,"type",Getattr(yyvsp[-4].node,"type"));
		   Setattr(yyval.node,"section",Getattr(p,"name"));
		   Setattr(yyval.node,"kwargs",nextSibling(p));
		   Delitem(scanner_ccode,0);
		   Delitem(scanner_ccode,DOH_END);
		   Setattr(yyval.node,"code",Copy(scanner_ccode));
                 }
    break;

  case 55:
#line 1360 "parser.y"
    {
		   yyval.node = new_node("fragment");
		   Setattr(yyval.node,"value",Getattr(yyvsp[-2].node,"value"));
		   Setattr(yyval.node,"type",Getattr(yyvsp[-2].node,"type"));
		   Setattr(yyval.node,"emitonly","1");
		 }
    break;

  case 56:
#line 1373 "parser.y"
    {
                     yyvsp[-3].loc.filename = Swig_copy_string(cparse_file);
		     yyvsp[-3].loc.line = cparse_line;
		     cparse_file = Swig_copy_string(yyvsp[-1].id);
		     cparse_line = 0;
               }
    break;

  case 57:
#line 1378 "parser.y"
    {
                     yyval.node = yyvsp[-1].node;
		     cparse_file = yyvsp[-6].loc.filename;
		     cparse_line = yyvsp[-6].loc.line;
		     if (strcmp(yyvsp[-6].loc.type,"include") == 0) set_nodeType(yyval.node,"include");
		     if (strcmp(yyvsp[-6].loc.type,"import") == 0) set_nodeType(yyval.node,"import");
		     Setattr(yyval.node,"name",yyvsp[-4].id);
		     /* Search for the module (if any) */
		     {
			 Node *n = firstChild(yyval.node);
			 while (n) {
			     if (Strcmp(nodeType(n),"module") == 0) {
				 Setattr(yyval.node,"module",Getattr(n,"name"));
				 break;
			     }
			     n = nextSibling(n);
			 }
		     }
		     Setattr(yyval.node,"options",yyvsp[-5].node);
               }
    break;

  case 58:
#line 1400 "parser.y"
    { yyval.loc.type = (char *) "include"; }
    break;

  case 59:
#line 1401 "parser.y"
    { yyval.loc.type = (char *) "import"; }
    break;

  case 60:
#line 1408 "parser.y"
    {
                 String *cpps;
		 if (Namespaceprefix) {
		   Swig_error(cparse_file, cparse_start_line, "%%inline directive inside a namespace is disallowed.\n");

		   yyval.node = 0;
		 } else {
		   yyval.node = new_node("insert");
		   Setattr(yyval.node,"code",yyvsp[0].str);
		   /* Need to run through the preprocessor */
		   Setline(yyvsp[0].str,cparse_start_line);
		   Setfile(yyvsp[0].str,cparse_file);
		   Seek(yyvsp[0].str,0,SEEK_SET);
		   cpps = Preprocessor_parse(yyvsp[0].str);
		   start_inline(Char(cpps), cparse_start_line);
		   Delete(yyvsp[0].str);
		   Delete(cpps);
		 }
		 
	       }
    break;

  case 61:
#line 1428 "parser.y"
    {
                 String *cpps;
		 skip_balanced('{','}');
		 if (Namespaceprefix) {
		   Swig_error(cparse_file, cparse_start_line, "%%inline directive inside a namespace is disallowed.\n");
		   
		   yyval.node = 0;
		 } else {
                   yyval.node = new_node("insert");
		   Delitem(scanner_ccode,0);
		   Delitem(scanner_ccode,DOH_END);
		   Setattr(yyval.node,"code", Copy(scanner_ccode));
		   cpps=Copy(scanner_ccode);
		   start_inline(Char(cpps), cparse_start_line);
		   Delete(cpps);
		 }
               }
    break;

  case 62:
#line 1455 "parser.y"
    {
                 yyval.node = new_node("insert");
		 Setattr(yyval.node,"code",yyvsp[0].str);
	       }
    break;

  case 63:
#line 1459 "parser.y"
    {
		 String *code = NewString("");
		 yyval.node = new_node("insert");
		 Setattr(yyval.node,"section",yyvsp[-2].id);
		 Setattr(yyval.node,"code",code);
		 if (Swig_insert_file(yyvsp[0].id,code) < 0) {
		   Swig_error(cparse_file, cparse_line, "Couldn't find '%s'.\n", yyvsp[0].id);
		   yyval.node = 0;
		 } 
               }
    break;

  case 64:
#line 1469 "parser.y"
    {
		 yyval.node = new_node("insert");
		 Setattr(yyval.node,"section",yyvsp[-2].id);
		 Setattr(yyval.node,"code",yyvsp[0].str);
               }
    break;

  case 65:
#line 1474 "parser.y"
    {
                 skip_balanced('{','}');
		 yyval.node = new_node("insert");
		 Setattr(yyval.node,"section",yyvsp[-2].id);
		 Delitem(scanner_ccode,0);
		 Delitem(scanner_ccode,DOH_END);
		 Setattr(yyval.node,"code", Copy(scanner_ccode));
	       }
    break;

  case 66:
#line 1489 "parser.y"
    {
                 yyval.node = new_node("module");
		 Setattr(yyval.node,"name",yyvsp[0].id);
		 if (yyvsp[-1].node) Setattr(yyval.node,"options",yyvsp[-1].node);
		 if (yyvsp[-1].node && Getattr(yyvsp[-1].node,"directors") && Getattr(yyvsp[-1].node,"dirprot"))
		   dirprot_mode = 1;
		 if (!ModuleName) ModuleName = NewString(yyvsp[0].id);
		 if (!module_node) module_node = yyval.node;
	       }
    break;

  case 67:
#line 1505 "parser.y"
    {
                 yyrename = NewString(yyvsp[-1].id);
		 yyval.node = 0;
               }
    break;

  case 68:
#line 1509 "parser.y"
    {
                   yyval.node = 0;
		   Swig_error(cparse_file,cparse_line,"Missing argument to %%name directive.\n");
	       }
    break;

  case 69:
#line 1521 "parser.y"
    {
                 yyval.node = new_node("native");
		 Setattr(yyval.node,"name",yyvsp[-4].id);
		 Setattr(yyval.node,"wrap:name",yyvsp[-1].id);
	         add_symbols(yyval.node);
	       }
    break;

  case 70:
#line 1527 "parser.y"
    {
		 if (!SwigType_isfunction(yyvsp[-1].decl.type)) {
		   Swig_error(cparse_file,cparse_line,"%%native declaration '%s' is not a function.\n", yyvsp[-1].decl.id);
		   yyval.node = 0;
		 } else {
		     Delete(SwigType_pop_function(yyvsp[-1].decl.type));
		     /* Need check for function here */
		     SwigType_push(yyvsp[-2].type,yyvsp[-1].decl.type);
		     yyval.node = new_node("native");
	             Setattr(yyval.node,"name",yyvsp[-5].id);
		     Setattr(yyval.node,"wrap:name",yyvsp[-1].decl.id);
		     Setattr(yyval.node,"type",yyvsp[-2].type);
		     Setattr(yyval.node,"parms",yyvsp[-1].decl.parms);
		     Setattr(yyval.node,"decl",yyvsp[-1].decl.type);
		 }
	         add_symbols(yyval.node);
	       }
    break;

  case 71:
#line 1553 "parser.y"
    {
                 yyval.node = new_node("pragma");
		 Setattr(yyval.node,"lang",yyvsp[-3].id);
		 Setattr(yyval.node,"name",yyvsp[-2].id);
		 Setattr(yyval.node,"value",yyvsp[0].str);
	       }
    break;

  case 72:
#line 1559 "parser.y"
    {
		yyval.node = new_node("pragma");
		Setattr(yyval.node,"lang",yyvsp[-1].id);
		Setattr(yyval.node,"name",yyvsp[0].id);
	      }
    break;

  case 73:
#line 1566 "parser.y"
    { yyval.str = NewString(yyvsp[0].id); }
    break;

  case 74:
#line 1567 "parser.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 75:
#line 1570 "parser.y"
    { yyval.id = yyvsp[-1].id; }
    break;

  case 76:
#line 1571 "parser.y"
    { yyval.id = (char *) "swig"; }
    break;

  case 77:
#line 1579 "parser.y"
    {
                    SwigType *t = yyvsp[-2].decl.type;
		    if (!Len(t)) t = 0;
		    if (yyvsp[-3].ivalue) {
		      rename_add(yyvsp[-2].decl.id,t,yyvsp[-1].id);
		    } else {
		      namewarn_add(yyvsp[-2].decl.id,t,yyvsp[-1].id);
		    }
		    yyval.node = 0;
		    scanner_clear_rename();
              }
    break;

  case 78:
#line 1590 "parser.y"
    {
		String *fixname;
		SwigType *t = yyvsp[-2].decl.type;
		fixname = feature_identifier_fix(yyvsp[-2].decl.id);
		if (!Len(t)) t = 0;
		/* Special declarator check */
		if (t) {
		  if (yyvsp[-1].dtype.qualifier) SwigType_push(t,yyvsp[-1].dtype.qualifier);
		  if (SwigType_isfunction(t)) {
		    SwigType *decl = SwigType_pop_function(t);
		    if (SwigType_ispointer(t)) {
		      String *nname = NewStringf("*%s",fixname);
		      if (yyvsp[-6].ivalue) {
			rename_add(Char(nname),decl,yyvsp[-4].id);
		      } else {
			namewarn_add(Char(nname),decl,yyvsp[-4].id);
		      }
		      Delete(nname);
		    } else {
		      if (yyvsp[-6].ivalue) {
			rename_add(Char(fixname),decl,yyvsp[-4].id);
		      } else {
			namewarn_add(Char(fixname),decl,yyvsp[-4].id);
		      }
		    }
		  } else if (SwigType_ispointer(t)) {
		    String *nname = NewStringf("*%s",fixname);
		    if (yyvsp[-6].ivalue) {
		      rename_add(Char(nname),0,yyvsp[-4].id);
		    } else {
		      namewarn_add(Char(nname),0,yyvsp[-4].id);
		    }
		    Delete(nname);
		  }
		} else {
		  if (yyvsp[-6].ivalue) {
		    rename_add(Char(fixname),0,yyvsp[-4].id);
		  } else {
		    namewarn_add(Char(fixname),0,yyvsp[-4].id);
		  }
		}
                yyval.node = 0;
		scanner_clear_rename();
              }
    break;

  case 79:
#line 1634 "parser.y"
    {
		if (yyvsp[-5].ivalue) {
		  rename_add(yyvsp[-1].id,0,yyvsp[-3].id);
		} else {
		  namewarn_add(yyvsp[-1].id,0,yyvsp[-3].id);
		}
		yyval.node = 0;
		scanner_clear_rename();
              }
    break;

  case 80:
#line 1645 "parser.y"
    {
		    yyval.ivalue = 1;
                }
    break;

  case 81:
#line 1648 "parser.y"
    {
                    yyval.ivalue = 0;
                }
    break;

  case 82:
#line 1675 "parser.y"
    {
                    String *val = yyvsp[0].str ? NewString(yyvsp[0].str) : NewString("1");
                    new_feature(yyvsp[-4].id, val, 0, yyvsp[-2].decl.id, yyvsp[-2].decl.type, yyvsp[-2].decl.parms, yyvsp[-1].dtype.qualifier);
                    yyval.node = 0;
                  }
    break;

  case 83:
#line 1680 "parser.y"
    {
                    String *val = Len(yyvsp[-4].id) ? NewString(yyvsp[-4].id) : 0;
                    new_feature(yyvsp[-6].id, val, 0, yyvsp[-2].decl.id, yyvsp[-2].decl.type, yyvsp[-2].decl.parms, yyvsp[-1].dtype.qualifier);
                    yyval.node = 0;
                  }
    break;

  case 84:
#line 1685 "parser.y"
    {
                    String *val = yyvsp[0].str ? NewString(yyvsp[0].str) : NewString("1");
                    new_feature(yyvsp[-5].id, val, yyvsp[-4].node, yyvsp[-2].decl.id, yyvsp[-2].decl.type, yyvsp[-2].decl.parms, yyvsp[-1].dtype.qualifier);
                    yyval.node = 0;
                  }
    break;

  case 85:
#line 1690 "parser.y"
    {
                    String *val = Len(yyvsp[-5].id) ? NewString(yyvsp[-5].id) : 0;
                    new_feature(yyvsp[-7].id, val, yyvsp[-4].node, yyvsp[-2].decl.id, yyvsp[-2].decl.type, yyvsp[-2].decl.parms, yyvsp[-1].dtype.qualifier);
                    yyval.node = 0;
                  }
    break;

  case 86:
#line 1697 "parser.y"
    {
                    String *val = yyvsp[0].str ? NewString(yyvsp[0].str) : NewString("1");
                    new_feature(yyvsp[-2].id, val, 0, 0, 0, 0, 0);
                    yyval.node = 0;
                  }
    break;

  case 87:
#line 1702 "parser.y"
    {
                    String *val = Len(yyvsp[-2].id) ? NewString(yyvsp[-2].id) : 0;
                    new_feature(yyvsp[-4].id, val, 0, 0, 0, 0, 0);
                    yyval.node = 0;
                  }
    break;

  case 88:
#line 1707 "parser.y"
    {
                    String *val = yyvsp[0].str ? NewString(yyvsp[0].str) : NewString("1");
                    new_feature(yyvsp[-3].id, val, yyvsp[-2].node, 0, 0, 0, 0);
                    yyval.node = 0;
                  }
    break;

  case 89:
#line 1712 "parser.y"
    {
                    String *val = Len(yyvsp[-3].id) ? NewString(yyvsp[-3].id) : 0;
                    new_feature(yyvsp[-5].id, val, yyvsp[-2].node, 0, 0, 0, 0);
                    yyval.node = 0;
                  }
    break;

  case 90:
#line 1719 "parser.y"
    { yyval.str = yyvsp[0].str; }
    break;

  case 91:
#line 1720 "parser.y"
    { yyval.str = 0; }
    break;

  case 92:
#line 1721 "parser.y"
    { yyval.str = yyvsp[-2].pl; }
    break;

  case 93:
#line 1724 "parser.y"
    {
		  yyval.node = NewHash();
		  Setattr(yyval.node,"name",yyvsp[-2].id);
		  Setattr(yyval.node,"value",yyvsp[0].id);
                }
    break;

  case 94:
#line 1729 "parser.y"
    {
		  yyval.node = NewHash();
		  Setattr(yyval.node,"name",yyvsp[-3].id);
		  Setattr(yyval.node,"value",yyvsp[-1].id);
                  set_nextSibling(yyval.node,yyvsp[0].node);
                }
    break;

  case 95:
#line 1739 "parser.y"
    {
                 Parm *val;
		 String *name;
		 SwigType *t;
                 if (!features_hash) features_hash = NewHash();
		 if (Namespaceprefix) name = NewStringf("%s::%s", Namespaceprefix, yyvsp[-2].decl.id);
		 else name = NewString(yyvsp[-2].decl.id);
		 val = yyvsp[-4].pl;
		 if (yyvsp[-2].decl.parms) {
		   Setmeta(val,"parms",yyvsp[-2].decl.parms);
		 }
		 t = yyvsp[-2].decl.type;
		 if (!Len(t)) t = 0;
		 if (t) {
		   if (yyvsp[-1].dtype.qualifier) SwigType_push(t,yyvsp[-1].dtype.qualifier);
		   if (SwigType_isfunction(t)) {
		     SwigType *decl = SwigType_pop_function(t);
		     if (SwigType_ispointer(t)) {
		       String *nname = NewStringf("*%s",name);
		       Swig_feature_set(features_hash, nname, decl, "feature:varargs", val, 0);
		       Delete(nname);
		     } else {
		       Swig_feature_set(features_hash, name, decl, "feature:varargs", val, 0);
		     }
		   } else if (SwigType_ispointer(t)) {
		     String *nname = NewStringf("*%s",name);
		     Swig_feature_set(features_hash,nname,0,"feature:varargs",val, 0);
		     Delete(nname);
		   }
		 } else {
		   Swig_feature_set(features_hash,name,0,"feature:varargs",val, 0);
		 }
		 Delete(name);
		 yyval.node = 0;
              }
    break;

  case 96:
#line 1775 "parser.y"
    { yyval.pl = yyvsp[0].pl; }
    break;

  case 97:
#line 1776 "parser.y"
    { 
		  int i;
		  int n;
		  Parm *p;
		  n = atoi(Char(yyvsp[-2].dtype.val));
		  if (n <= 0) {
		    Swig_error(cparse_file, cparse_line,"Argument count in %%varargs must be positive.\n");
		    yyval.pl = 0;
		  } else {
		    yyval.pl = Copy(yyvsp[0].p);
		    Setattr(yyval.pl,"name","VARARGS_SENTINEL");
		    for (i = 0; i < n; i++) {
		      p = Copy(yyvsp[0].p);
		      set_nextSibling(p,yyval.pl);
		      yyval.pl = p;
		    }
		  }
                }
    break;

  case 98:
#line 1805 "parser.y"
    {
		   yyval.node = 0;
		   if (yyvsp[-3].tmap.op) {
		     yyval.node = new_node("typemap");
		     Setattr(yyval.node,"method",yyvsp[-3].tmap.op);
		     Setattr(yyval.node,"code",NewString(yyvsp[0].str));
		     if (yyvsp[-3].tmap.kwargs) {
		       Setattr(yyval.node,"kwargs", yyvsp[-3].tmap.kwargs);
		     }
		     appendChild(yyval.node,yyvsp[-1].p);
		   }
	       }
    break;

  case 99:
#line 1817 "parser.y"
    {
		 yyval.node = 0;
		 if (yyvsp[-3].tmap.op) {
		   yyval.node = new_node("typemap");
		   Setattr(yyval.node,"method",yyvsp[-3].tmap.op);
		   appendChild(yyval.node,yyvsp[-1].p);
		 }
	       }
    break;

  case 100:
#line 1825 "parser.y"
    {
		   yyval.node = 0;
		   if (yyvsp[-5].tmap.op) {
		     yyval.node = new_node("typemapcopy");
		     Setattr(yyval.node,"method",yyvsp[-5].tmap.op);
		     Setattr(yyval.node,"pattern", Getattr(yyvsp[-1].p,"pattern"));
		     appendChild(yyval.node,yyvsp[-3].p);
		   }
	       }
    break;

  case 101:
#line 1838 "parser.y"
    {
		 Hash *p;
		 String *name;
		 p = nextSibling(yyvsp[0].node);
		 if (p && (!Getattr(p,"value"))) {
		   /* two argument typemap form */
		   name = Getattr(yyvsp[0].node,"name");
		   if (!name || (Strcmp(name,typemap_lang))) {
		     yyval.tmap.op = 0;
		     yyval.tmap.kwargs = 0;
		   } else {
		     yyval.tmap.op = Getattr(p,"name");
		     yyval.tmap.kwargs = nextSibling(p);
		   }
		 } else {
		   /* one-argument typemap-form */
		   yyval.tmap.op = Getattr(yyvsp[0].node,"name");
		   yyval.tmap.kwargs = p;
		 }
                }
    break;

  case 102:
#line 1860 "parser.y"
    {
                 yyval.p = yyvsp[-1].p;
		 set_nextSibling(yyval.p,yyvsp[0].p);
		}
    break;

  case 103:
#line 1866 "parser.y"
    {
                 yyval.p = yyvsp[-1].p;
		 set_nextSibling(yyval.p,yyvsp[0].p);
                }
    break;

  case 104:
#line 1870 "parser.y"
    { yyval.p = 0;}
    break;

  case 105:
#line 1873 "parser.y"
    {
		  SwigType_push(yyvsp[-1].type,yyvsp[0].decl.type);
		  yyval.p = new_node("typemapitem");
		  Setattr(yyval.p,"pattern",NewParm(yyvsp[-1].type,yyvsp[0].decl.id));
		  Setattr(yyval.p,"parms", yyvsp[0].decl.parms);
		  /*		  $$ = NewParm($1,$2.id);
				  Setattr($$,"parms",$2.parms); */
                }
    break;

  case 106:
#line 1881 "parser.y"
    {
                  yyval.p = new_node("typemapitem");
		  Setattr(yyval.p,"pattern",yyvsp[-1].pl);
		  /*		  Setattr($$,"multitype",$2); */
               }
    break;

  case 107:
#line 1886 "parser.y"
    {
		 yyval.p = new_node("typemapitem");
		 Setattr(yyval.p,"pattern", yyvsp[-4].pl);
		 /*                 Setattr($$,"multitype",$2); */
		 Setattr(yyval.p,"parms",yyvsp[-1].pl);
               }
    break;

  case 108:
#line 1898 "parser.y"
    {
                   yyval.node = new_node("types");
		   Setattr(yyval.node,"parms",yyvsp[-2].pl);
               }
    break;

  case 109:
#line 1908 "parser.y"
    {
                  Parm *p, *tp;
		  Node *n;
		  Node *nspace = 0, *nspace_inner = 0;
		  Node *tnode = 0;
		  Symtab *tscope = 0;
		  int     specialized = 0;
		  yyval.node = 0;

		  tscope = Swig_symbol_current();          /* Get the current scope */

		  /* If the template name is qualified.  We need to create or lookup namespace entries */
		  if (Swig_scopename_check(yyvsp[-4].str)) {
		    String *prefix, *base;
		    Node   *ns;
		    prefix = Swig_scopename_prefix(yyvsp[-4].str);
		    base = Swig_scopename_last(yyvsp[-4].str);
		    
		    /* Try to locate the scope */
		    ns = Swig_symbol_clookup(prefix,0);
		    if (!ns) {
		      Swig_error(cparse_file,cparse_line,"Undefined scope '%s'\n", prefix);
		    } else {
		      if (Strcmp(nodeType(ns),"namespace") != 0) {
			Swig_error(cparse_file,cparse_line,"'%s' is not defined as namespace.\n", prefix);
			ns = 0;
		      } else {
			/*			Swig_symbol_setscope(Getattr(ns,"symtab"));
						Namespaceprefix = Swig_symbol_qualifiedscopename(0); */
		      }
		    }

		    if (ns && Namespaceprefix) {
		      Swig_error(cparse_file,cparse_line,
				 "Can't instantiate template '%s' inside namespace '%s'.\n"
				 "Suggest moving %%template outside the namespace.\n", yyvsp[-4].str, Namespaceprefix);

		    }
		    
		    /* Create namespace nodes to enclose the template declaration */
		    if (ns) {
		      List *scopes;
		      String *sname;
		      Iterator si;
		      String *name = NewString(prefix);
		      scopes = NewList();
		      while (name) {
			String *tprefix;
			String *base = Swig_scopename_last(name);
			Insert(scopes,0,base);
			tprefix = Swig_scopename_prefix(name);
			Delete(name);
			name = tprefix;
		      }
		      for (si = First(scopes); si.item; si = Next(si)) {
			Node *ns1,*ns2;
			sname = si.item;
			ns1 = Swig_symbol_clookup(sname,0);
			assert(ns1);
			if (Strcmp(nodeType(ns1),"namespace") == 0) {
			  if (Getattr(ns1,"alias")) {
			    ns1 = Getattr(ns1,"namespace");
			  }
			} else {
			  assert(0);
			}
			ns2 = new_node("namespace");
			Setattr(ns2,"name",sname);
			Setattr(ns2,"symtab", Getattr(ns1,"symtab"));
			add_symbols(ns2);
			Swig_symbol_setscope(Getattr(ns1,"symtab"));
			Namespaceprefix = Swig_symbol_qualifiedscopename(0);
			if (nspace_inner) {
			  appendChild(nspace_inner,ns2);
			}
			nspace_inner = ns2;
			if (!nspace) nspace = ns2;
		      }
		      yyvsp[-4].str = base;
		    }
		  }

		  n = Swig_cparse_template_locate(yyvsp[-4].str,yyvsp[-2].p);

		  /* Patch the argument types to respect namespaces */
		  p = yyvsp[-2].p;
		  while (p) {
		    if (!Getattr(p,"value")) {
		      SwigType *ty = Getattr(p,"type");
		      if (ty) {
			ty = Swig_symbol_type_qualify(ty,0);
			/*			ty = Swig_symbol_typedef_reduce(ty,0); */
			Setattr(p,"type",ty);
		      }
		    }
		    p = nextSibling(p);
		  }
		  /* Look for the template */

		  if (n && (Strcmp(nodeType(n),"template") == 0)) {
		    Parm *tparms = Getattr(n,"templateparms");
		    if (!tparms) {
		      specialized = 1;
		    }
		    if (!specialized && ((ParmList_len(yyvsp[-2].p) > ParmList_len(tparms)))) {
		      Swig_error(cparse_file, cparse_line, "Too many template parameters. Maximum of %d.\n", ParmList_len(tparms));
		    } else if (!specialized && ((ParmList_len(yyvsp[-2].p) < ParmList_numrequired(tparms)))) {
		      Swig_error(cparse_file, cparse_line, "Not enough template parameters specified. %d required.\n", ParmList_numrequired(tparms));
		    } else {
		      int  def_supplied = 0;
		      /* Expand the template */
		      ParmList *temparms;
		      if (specialized) temparms = CopyParmList(yyvsp[-2].p);
		      else temparms = CopyParmList(tparms);

		      /* Create typedef's and arguments */
		      p = yyvsp[-2].p;
		      tp = temparms;
		      while (p) {
			String *value = Getattr(p,"value");
			if (def_supplied) {
			  Setattr(p,"default","1");
			}
			if (value) {
			  Setattr(tp,"value",value);
			} else {
			  SwigType *ty = Getattr(p,"type");
			  if (ty) {
			    Setattr(tp,"type",ty);
			  }
			  Delattr(tp,"value");
			}
			p = nextSibling(p);
			tp = nextSibling(tp);
			if (!p && tp) {
			  p = tp;
			  def_supplied = 1;
			}
		      }

		      yyval.node = copy_node(n);
		      /* We need to set the node name based on name used to instantiate */
		      Setattr(yyval.node,"name",Copy(yyvsp[-4].str));
		      if (!specialized) {
			Delattr(yyval.node,"sym:typename");
		      } else {
			Setattr(yyval.node,"sym:typename","1");
		      }
		      if (yyvsp[-6].id) {
			Swig_cparse_template_expand(yyval.node,yyvsp[-6].id,temparms);
			Setattr(yyval.node,"sym:name",yyvsp[-6].id);
		      } else {
			static int cnt = 0;
			String *nname = NewStringf("__dummy_%d__", cnt++);
			Swig_cparse_template_expand(yyval.node,nname,temparms);
			Setattr(yyval.node,"sym:name",nname);
			if (!Swig_template_extmode()) {
			  Setattr(yyval.node,"feature:ignore","1");
			} else {
			  Setattr(yyval.node,"feature:onlychildren",
				  "typemap,typemapitem,typemapcopy,typedef,types,fragment");
			}
		      }
		      Delattr(yyval.node,"templatetype");
		      Setattr(yyval.node,"template",n);
		      tnode = yyval.node;
		      Setfile(yyval.node,cparse_file);
		      Setline(yyval.node,cparse_line);
		      Delete(temparms);
		      
		      add_symbols_copy(yyval.node);
		      if (Strcmp(nodeType(yyval.node),"class") == 0) {

			/* Identify pure abstract methods */
			Setattr(yyval.node,"abstract", pure_abstract(firstChild(yyval.node)));
			
                        /* Set up inheritance in symbol table */
			{
			  Symtab  *csyms;
 			  List *baselist = Getattr(yyval.node,"baselist");
			  csyms = Swig_symbol_current();
			  Swig_symbol_setscope(Getattr(yyval.node,"symtab"));
			  if (baselist) {
			    List *bases = make_inherit_list(Getattr(yyval.node,"name"),baselist);
			    if (bases) {
			      Iterator s;
			      for (s = First(bases); s.item; s = Next(s)) {
				Symtab *st = Getattr(s.item,"symtab");
				if (st) {
				  Swig_symbol_inherit(st);
				}
			      }
			    }
			  }
			  Swig_symbol_setscope(csyms);
			}

			/* Merge in addmethods for this class */
			
			/* !!! This may be broken.  We may have to  add the addmethods at the beginning of
			   the class */
			
			if (extendhash) {
			  String *clsname;
			  Node *am;
			  if (Namespaceprefix) {
			    clsname = NewStringf("%s::%s", Namespaceprefix, Getattr(yyval.node,"name"));
			  } else {
			    clsname = Getattr(yyval.node,"name");
			  }
			  am = Getattr(extendhash,clsname);
			  if (am) {
			    Symtab *st = Swig_symbol_current();
			    Swig_symbol_setscope(Getattr(yyval.node,"symtab"));
			    /*			    Printf(stdout,"%s: %s %x %x\n", Getattr($$,"name"), clsname, Swig_symbol_current(), Getattr($$,"symtab")); */
			    merge_extensions(yyval.node,am);
			    Swig_symbol_setscope(st);
			    appendChild(yyval.node,am);
			    Delattr(extendhash,clsname);
			  }
			}
			/* Add to classes hash */
			if (!classes) classes = NewHash();

			{
			  if (Namespaceprefix) {
			    String *temp = NewStringf("%s::%s", Namespaceprefix, Getattr(yyval.node,"name"));
			    Setattr(classes,temp,yyval.node);
			  } else {
			    Setattr(classes,Swig_symbol_qualifiedscopename(yyval.node),yyval.node);
			  }
			}
		      }
		    }
		    if (yyval.node && nspace) {
		      appendChild(nspace_inner,yyval.node);
		      yyval.node = nspace;
		    }
		  }
   	          Swig_symbol_setscope(tscope);
		  Namespaceprefix = Swig_symbol_qualifiedscopename(0);

                }
    break;

  case 110:
#line 2158 "parser.y"
    {
		  Swig_warning(0,cparse_file, cparse_line,"%s\n", yyvsp[0].id);
		  yyval.node = 0;
               }
    break;

  case 111:
#line 2168 "parser.y"
    {
                    yyval.node = yyvsp[0].node; 
                    if (yyval.node) {
   		      add_symbols(yyval.node);
   	            }
                }
    break;

  case 112:
#line 2174 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 113:
#line 2175 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 114:
#line 2179 "parser.y"
    { 
		  if (Strcmp(yyvsp[-3].id,"C") == 0) {
		    yyval.node = new_node("extern");
		    Setattr(yyval.node,"name",yyvsp[-3].id);
		    appendChild(yyval.node,firstChild(yyvsp[-1].node));
		  } else {
		     Swig_warning(WARN_PARSE_UNDEFINED_EXTERN,cparse_file, cparse_line,"Unrecognized extern type \"%s\" (ignored).\n", yyvsp[-3].id);
		     yyval.node = 0;
		  }
                }
    break;

  case 115:
#line 2195 "parser.y"
    {
              yyval.node = new_node("cdecl");
	      if (yyvsp[-1].dtype.qualifier) SwigType_push(yyvsp[-2].decl.type,yyvsp[-1].dtype.qualifier);
	      Setattr(yyval.node,"type",yyvsp[-3].type);
	      Setattr(yyval.node,"storage",yyvsp[-4].id);
	      Setattr(yyval.node,"name",yyvsp[-2].decl.id);
	      Setattr(yyval.node,"decl",yyvsp[-2].decl.type);
	      Setattr(yyval.node,"parms",yyvsp[-2].decl.parms);
	      Setattr(yyval.node,"value",yyvsp[-1].dtype.val);
	      Setattr(yyval.node,"throws",yyvsp[-1].dtype.throws);
	      if (!yyvsp[0].node) {
		if (Len(scanner_ccode)) {
		  Setattr(yyval.node,"code",Copy(scanner_ccode));
		}
	      } else {
		Node *n = yyvsp[0].node;
		/* Inherit attributes */
		while (n) {
		  Setattr(n,"type",Copy(yyvsp[-3].type));
		  Setattr(n,"storage",yyvsp[-4].id);
		  n = nextSibling(n);
		}
	      }
	      if (yyvsp[-1].dtype.bitfield) {
		Setattr(yyval.node,"bitfield", yyvsp[-1].dtype.bitfield);
	      }

	      /* Look for "::" declarations (ignored) */
	      if (Strstr(yyvsp[-2].decl.id,"::")) {
		if (Namespaceprefix) {
		  /* This is a special case. If the scope name of the declaration exactly
                     matches that of the declaration, then we will allow it. Otherwise, delete. */
		  String *p = Swig_scopename_prefix(yyvsp[-2].decl.id);
		  if (Strcmp(p,Namespaceprefix) == 0) {
		    Setattr(yyval.node,"name",Swig_scopename_last(yyvsp[-2].decl.id));
		    set_nextSibling(yyval.node,yyvsp[0].node);
		  } else {
		    Delete(yyval.node);
		    yyval.node = yyvsp[0].node;
		  }
		  Delete(p);
		} else {
		  Delete(yyval.node);
		  yyval.node = yyvsp[0].node;
		}
	      } else {
		set_nextSibling(yyval.node,yyvsp[0].node);
	      }
           }
    break;

  case 116:
#line 2248 "parser.y"
    { 
                   yyval.node = 0;
                   Clear(scanner_ccode); 
               }
    break;

  case 117:
#line 2252 "parser.y"
    {
		 yyval.node = new_node("cdecl");
		 if (yyvsp[-1].dtype.qualifier) SwigType_push(yyvsp[-2].decl.type,yyvsp[-1].dtype.qualifier);
		 Setattr(yyval.node,"name",yyvsp[-2].decl.id);
		 Setattr(yyval.node,"decl",yyvsp[-2].decl.type);
		 Setattr(yyval.node,"parms",yyvsp[-2].decl.parms);
		 Setattr(yyval.node,"value",yyvsp[-1].dtype.val);
		 Setattr(yyval.node,"throws",yyvsp[-1].dtype.throws);
		 if (yyvsp[-1].dtype.bitfield) {
		   Setattr(yyval.node,"bitfield", yyvsp[-1].dtype.bitfield);
		 }
		 if (!yyvsp[0].node) {
		   if (Len(scanner_ccode)) {
		     Setattr(yyval.node,"code",Copy(scanner_ccode));
		   }
		 } else {
		   set_nextSibling(yyval.node,yyvsp[0].node);
		 }
	       }
    break;

  case 118:
#line 2271 "parser.y"
    { 
                   skip_balanced('{','}');
                   yyval.node = 0;
               }
    break;

  case 119:
#line 2277 "parser.y"
    { 
                   yyval.dtype = yyvsp[0].dtype; 
                   yyval.dtype.qualifier = 0;
		   yyval.dtype.throws = 0;
              }
    break;

  case 120:
#line 2282 "parser.y"
    { 
                   yyval.dtype = yyvsp[0].dtype; 
		   yyval.dtype.qualifier = yyvsp[-1].str;
		   yyval.dtype.throws = 0;
	      }
    break;

  case 121:
#line 2287 "parser.y"
    { 
		   yyval.dtype = yyvsp[0].dtype; 
                   yyval.dtype.qualifier = 0;
		   yyval.dtype.throws = yyvsp[-2].pl;
              }
    break;

  case 122:
#line 2292 "parser.y"
    { 
                   yyval.dtype = yyvsp[0].dtype; 
                   yyval.dtype.qualifier = yyvsp[-5].str;
		   yyval.dtype.throws = yyvsp[-2].pl;
              }
    break;

  case 123:
#line 2304 "parser.y"
    {
		   SwigType *ty = 0;
		   yyval.node = new_node("enumforward");
		   ty = NewStringf("enum %s", yyvsp[-1].id);
		   Setattr(yyval.node,"name",yyvsp[-1].id);
		   Setattr(yyval.node,"type",ty);
		   Setattr(yyval.node,"sym:weak", "1");
		   add_symbols(yyval.node);
	      }
    break;

  case 124:
#line 2319 "parser.y"
    {
		  SwigType *ty = 0;
                  yyval.node = new_node("enum");
		  ty = NewStringf("enum %s", yyvsp[-4].id);
		  Setattr(yyval.node,"name",yyvsp[-4].id);
		  Setattr(yyval.node,"type",ty);
		  appendChild(yyval.node,yyvsp[-2].node);
		  add_symbols(yyval.node);       /* Add to tag space */
		  add_symbols(yyvsp[-2].node);       /* Add enum values to id space */
	       }
    break;

  case 125:
#line 2330 "parser.y"
    {
		 Node *n;
		 SwigType *ty = 0;
		 String   *unnamed = 0;
		 int       unnamedinstance = 0;

		 yyval.node = new_node("enum");
		 if (yyvsp[-5].id) {
		   Setattr(yyval.node,"name",yyvsp[-5].id);
		   ty = NewStringf("enum %s", yyvsp[-5].id);
		 } else if (yyvsp[-1].decl.id) {
		   unnamed = make_unnamed();
		   ty = NewStringf("enum %s", unnamed);
		   Setattr(yyval.node,"unnamed",unnamed);
                   /* name is not set for unnamed enum instances, e.g. enum { foo } Instance; */
		   if (yyvsp[-7].id && Cmp(yyvsp[-7].id,"typedef") == 0) {
		     Setattr(yyval.node,"name",yyvsp[-1].decl.id);
                   } else {
                     unnamedinstance = 1;
                   }
		   Setattr(yyval.node,"storage",yyvsp[-7].id);
		 }
		 if (yyvsp[-1].decl.id && Cmp(yyvsp[-7].id,"typedef") == 0) {
		   Setattr(yyval.node,"tdname",yyvsp[-1].decl.id);
                   Setattr(yyval.node,"allows_typedef","1");
                 }
		 appendChild(yyval.node,yyvsp[-3].node);
		 n = new_node("cdecl");
		 Setattr(n,"type",ty);
		 Setattr(n,"name",yyvsp[-1].decl.id);
		 Setattr(n,"storage",yyvsp[-7].id);
		 Setattr(n,"decl",yyvsp[-1].decl.type);
		 Setattr(n,"parms",yyvsp[-1].decl.parms);
		 Setattr(n,"unnamed",unnamed);

                 if (unnamedinstance) {
		   Setattr(yyval.node,"unnamedinstance","1");
		   Setattr(n,"unnamedinstance","1");
                 }
		 if (yyvsp[0].node) {
		   Node *p = yyvsp[0].node;
		   set_nextSibling(n,p);
		   while (p) {
		     Setattr(p,"type",Copy(ty));
		     Setattr(p,"unnamed",unnamed);
		     Setattr(p,"storage",yyvsp[-7].id);
		     p = nextSibling(p);
		   }
		 } else {
		   if (Len(scanner_ccode)) {
		     Setattr(n,"code",Copy(scanner_ccode));
		   }
		 }

                 /* Ensure that typedef enum ABC {foo} XYZ; uses XYZ for sym:name, like structs.
                  * Note that class_rename/yyrename are bit of a mess so used this simple approach to change the name. */
                 if (yyvsp[-1].decl.id && yyvsp[-5].id && Cmp(yyvsp[-7].id,"typedef") == 0) {
                   Setattr(yyval.node, "parser:makename", NewString(yyvsp[-1].decl.id));
                 }

		 add_symbols(yyval.node);       /* Add enum to tag space */
		 set_nextSibling(yyval.node,n);

		 add_symbols(yyvsp[-3].node);       /* Add enum values to id space */
	         add_symbols(n);
	       }
    break;

  case 126:
#line 2398 "parser.y"
    {
                   /* This is a sick hack.  If the ctor_end has parameters,
                      and the parms paremeter only has 1 parameter, this
                      could be a declaration of the form:

                         type (id)(parms)

			 Otherwise it's an error. */
                    int err = 0;
                    yyval.node = 0;

		    if ((ParmList_len(yyvsp[-2].pl) == 1) && (!Swig_scopename_check(yyvsp[-4].type))) {
		      SwigType *ty = Getattr(yyvsp[-2].pl,"type");
		      String *name = Getattr(yyvsp[-2].pl,"name");
		      err = 1;
		      if (!name) {
			yyval.node = new_node("cdecl");
			Setattr(yyval.node,"type",yyvsp[-4].type);
			Setattr(yyval.node,"storage",yyvsp[-5].id);
			Setattr(yyval.node,"name",ty);

			if (yyvsp[0].decl.have_parms) {
			  SwigType *decl = NewString("");
			  SwigType_add_function(decl,yyvsp[0].decl.parms);
			  Setattr(yyval.node,"decl",decl);
			  Setattr(yyval.node,"parms",yyvsp[0].decl.parms);
			  if (Len(scanner_ccode)) {
			    Setattr(yyval.node,"code",Copy(scanner_ccode));
			  }
			}
			if (yyvsp[0].decl.defarg) {
			  Setattr(yyval.node,"value",yyvsp[0].decl.defarg);
			}
			Setattr(yyval.node,"throws",yyvsp[0].decl.throws);
			err = 0;
		      }
		    }
		    if (err) {
		      Swig_error(cparse_file,cparse_line,"Syntax error in input.\n");
		    }
                }
    break;

  case 127:
#line 2445 "parser.y"
    {  yyval.node = yyvsp[0].node; }
    break;

  case 128:
#line 2446 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 129:
#line 2447 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 130:
#line 2448 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 131:
#line 2449 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 132:
#line 2450 "parser.y"
    { yyval.node = 0; }
    break;

  case 133:
#line 2456 "parser.y"
    {
                   List *bases = 0;
                   class_rename = make_name(yyvsp[-2].str,0);
		   Classprefix = NewString(yyvsp[-2].str);
		   /* Deal with inheritance  */
		   if (yyvsp[-1].bases) {
		     bases = make_inherit_list(yyvsp[-2].str,yyvsp[-1].bases);
		   }
		   if (SwigType_istemplate(yyvsp[-2].str)) {
		     String *fbase, *tbase, *prefix;
		     prefix = SwigType_templateprefix(yyvsp[-2].str);
		     if (Namespaceprefix) {
		       fbase = NewStringf("%s::%s", Namespaceprefix,yyvsp[-2].str);
		       tbase = NewStringf("%s::%s", Namespaceprefix, prefix);
		     } else {
		       fbase = Copy(yyvsp[-2].str);
		       tbase = Copy(prefix);
		     }
		     rename_inherit(tbase,fbase);
		     Delete(fbase);
		     Delete(tbase);
		     Delete(prefix);
		   }
                   if (strcmp(yyvsp[-3].id,"class") == 0) {
		     cplus_mode = CPLUS_PRIVATE;
		   } else {
		     cplus_mode = CPLUS_PUBLIC;
		   }
		   Swig_symbol_newscope();
		   Swig_symbol_setscopename(yyvsp[-2].str);
		   if (bases) {
		     Iterator s;
		     for (s = First(bases); s.item; s = Next(s)) {
		       Symtab *st = Getattr(s.item,"symtab");
		       if (st) {
			 Swig_symbol_inherit(st); 
		       }
		     }
		   }
		   Namespaceprefix = Swig_symbol_qualifiedscopename(0);
		   cparse_start_line = cparse_line;

		   /* If there are active template parameters, we need to make sure they are
                      placed in the class symbol table so we can catch shadows */

		   if (template_parameters) {
		     Parm *tp = template_parameters;
		     while(tp) {
		       Node *tn = new_node("templateparm");
		       Setattr(tn,"name",Getattr(tp,"name"));
		       Swig_symbol_cadd(Copy(Getattr(tp,"name")),tn);
		       tp = nextSibling(tp);
		     }
		   }
		   inclass = 1;
               }
    break;

  case 134:
#line 2511 "parser.y"
    {
		 Node *p;
		 SwigType *ty;
		 inclass = 0;
		 yyval.node = new_node("class");
		 Setline(yyval.node,cparse_start_line);
		 Setattr(yyval.node,"name",yyvsp[-6].str);
		 Setattr(yyval.node,"kind",yyvsp[-7].id);
		 Setattr(yyval.node,"baselist",yyvsp[-5].bases);
		 Setattr(yyval.node,"allows_typedef","1");
		 /* Check for pure-abstract class */
		 Setattr(yyval.node,"abstract", pure_abstract(yyvsp[-2].node));
		 
		 /* This bit of code merges in a previously defined %extend directive (if any) */
		 if (extendhash) {
		   String *clsname = Swig_symbol_qualifiedscopename(0);
		   Node *am = Getattr(extendhash,clsname);
		   if (am) {
		     merge_extensions(yyval.node,am);
		     appendChild(yyval.node,am);
		     Delattr(extendhash,clsname);
		   }
		   Delete(clsname);
		 }
		 if (!classes) classes = NewHash();
		 Setattr(classes,Swig_symbol_qualifiedscopename(0),yyval.node);

		 appendChild(yyval.node,yyvsp[-2].node);
		 p = yyvsp[0].node;
		 if (p) {
		   set_nextSibling(yyval.node,p);
		 }
		 
		 if (cparse_cplusplus) {
		   ty = NewString(yyvsp[-6].str);
		 } else {
		   ty = NewStringf("%s %s", yyvsp[-7].id,yyvsp[-6].str);
		 }
		 while (p) {
		   Setattr(p,"storage",yyvsp[-8].id);
		   Setattr(p,"type",ty);
		   p = nextSibling(p);
		 }
		 /* Dump nested classes */
		 {
		   String *name = yyvsp[-6].str;
		   if (yyvsp[0].node) {
		     SwigType *decltype = Getattr(yyvsp[0].node,"decl");
		     if (Cmp(yyvsp[-8].id,"typedef") == 0) {
		       if (!decltype || !Len(decltype)) {
			 name = Getattr(yyvsp[0].node,"name");
			 Setattr(yyval.node,"tdname",Copy(name));

			 /* Use typedef name as class name */
			 if (class_rename && (Strcmp(class_rename,yyvsp[-6].str) == 0)) {
			   class_rename = NewString(name);
			 }
			 if (!Getattr(classes,name)) {
			   Setattr(classes,name,yyval.node);
			 }
			 Setattr(yyval.node,"decl",decltype);
		       }
		     }
		   }
		   appendChild(yyval.node,dump_nested(Char(name)));
		 }
		 Setattr(yyval.node,"symtab",Swig_symbol_popscope());

		 yyrename = NewString(class_rename);
		 Classprefix = 0;
		 Namespaceprefix = Swig_symbol_qualifiedscopename(0);

		 add_symbols(yyval.node);
		 add_symbols(yyvsp[0].node);
	       }
    break;

  case 135:
#line 2589 "parser.y"
    {
	       class_rename = make_name(0,0);
	       if (strcmp(yyvsp[-1].id,"class") == 0) {
		 cplus_mode = CPLUS_PRIVATE;
	       } else {
		 cplus_mode = CPLUS_PUBLIC;
	       }
	       Swig_symbol_newscope();
	       cparse_start_line = cparse_line;
	       inclass = 1;
	       Classprefix = NewString("");
	       Namespaceprefix = Swig_symbol_qualifiedscopename(0);
             }
    break;

  case 136:
#line 2601 "parser.y"
    {
	       String *unnamed;
	       Node *n;
	       Classprefix = 0;
	       inclass = 0;
	       unnamed = make_unnamed();
	       yyval.node = new_node("class");
	       Setline(yyval.node,cparse_start_line);
	       Setattr(yyval.node,"kind",yyvsp[-6].id);
	       Setattr(yyval.node,"storage",yyvsp[-7].id);
	       Setattr(yyval.node,"unnamed",unnamed);
	       Setattr(yyval.node,"allows_typedef","1");

	       /* Check for pure-abstract class */
	       Setattr(yyval.node,"abstract", pure_abstract(yyvsp[-3].node));

	       n = new_node("cdecl");
	       Setattr(n,"name",yyvsp[-1].decl.id);
	       Setattr(n,"unnamed",unnamed);
	       Setattr(n,"type",unnamed);
	       Setattr(n,"decl",yyvsp[-1].decl.type);
	       Setattr(n,"parms",yyvsp[-1].decl.parms);
	       Setattr(n,"storage",yyvsp[-7].id);
	       if (yyvsp[0].node) {
		 Node *p = yyvsp[0].node;
		 set_nextSibling(n,p);
		 while (p) {
		   Setattr(p,"unnamed",unnamed);
		   Setattr(p,"type",Copy(unnamed));
		   Setattr(p,"storage",yyvsp[-7].id);
		   p = nextSibling(p);
		 }
	       }
	       set_nextSibling(yyval.node,n);
	       {
		 /* If a proper typedef name was given, we'll use it to set the scope name */
		 String *name = 0;
		 if (yyvsp[-7].id && (strcmp(yyvsp[-7].id,"typedef") == 0)) {
		   if (!Len(yyvsp[-1].decl.type)) {	
		     name = yyvsp[-1].decl.id;
		     Setattr(yyval.node,"tdname",name);
		     Setattr(yyval.node,"name",name);
		     Swig_symbol_setscopename(name);

		     /* If a proper name given, we use that as the typedef, not unnamed */
		     Clear(unnamed);
		     Append(unnamed, name);
		     
		     n = nextSibling(n);
		     set_nextSibling(yyval.node,n);

		     /* Check for previous extensions */
		     if (extendhash) {
		       String *clsname = Swig_symbol_qualifiedscopename(0);
		       Node *am = Getattr(extendhash,clsname);
		       if (am) {
			 /* Merge the extension into the symbol table */
			 merge_extensions(yyval.node,am);
			 appendChild(yyval.node,am);
			 Delattr(extendhash,clsname);
		       }
		       Delete(clsname);
		     }
		     if (!classes) classes = NewHash();
		     Setattr(classes,Swig_symbol_qualifiedscopename(0),yyval.node);
		   } else {
		     Swig_symbol_setscopename((char*)"<unnamed>");
		   }
		 }
		 appendChild(yyval.node,yyvsp[-3].node);
		 appendChild(yyval.node,dump_nested(Char(name)));
	       }
	       /* Pop the scope */
	       Setattr(yyval.node,"symtab",Swig_symbol_popscope());
	       if (class_rename) {
		 yyrename = NewString(class_rename);
	       }
	       Namespaceprefix = Swig_symbol_qualifiedscopename(0);
	       add_symbols(yyval.node);
	       add_symbols(n);
              }
    break;

  case 137:
#line 2684 "parser.y"
    { yyval.node = 0; }
    break;

  case 138:
#line 2685 "parser.y"
    {
                        yyval.node = new_node("cdecl");
                        Setattr(yyval.node,"name",yyvsp[-1].decl.id);
                        Setattr(yyval.node,"decl",yyvsp[-1].decl.type);
                        Setattr(yyval.node,"parms",yyvsp[-1].decl.parms);
			set_nextSibling(yyval.node,yyvsp[0].node);
                    }
    break;

  case 139:
#line 2697 "parser.y"
    {
              if (yyvsp[-3].id && (Strcmp(yyvsp[-3].id,"friend") == 0)) {
		/* Ignore */
                yyval.node = 0; 
	      } else {
		yyval.node = new_node("classforward");
		Setattr(yyval.node,"kind",yyvsp[-2].id);
		Setattr(yyval.node,"name",yyvsp[-1].str);
		Setattr(yyval.node,"sym:weak", "1");
		add_symbols(yyval.node);
	      }
             }
    break;

  case 140:
#line 2715 "parser.y"
    { template_parameters = yyvsp[-1].tparms; }
    break;

  case 141:
#line 2715 "parser.y"
    {
		      String *tname = 0;
		      int     error = 0;

                      template_parameters = 0;
                      yyval.node = yyvsp[0].node;
		      if (yyval.node) tname = Getattr(yyval.node,"name");
		      
		      /* Check if the class is a template specialization */
		      if ((yyval.node) && (Strstr(tname,"<")) && (Strncmp(tname,"operator ",9) != 0)) {
			/* If a specialization.  Check if defined. */
			Node *tempn = 0;
			{
			  String *tbase = SwigType_templateprefix(tname);
			  tempn = Swig_symbol_clookup_local(tbase,0);
			  if (!tempn || (Strcmp(nodeType(tempn),"template") != 0)) {
			    Swig_warning(WARN_PARSE_TEMPLATE_SP_UNDEF, Getfile(yyval.node),Getline(yyval.node),"Specialization of non-template '%s'.\n", tbase);
			    tempn = 0;
			    error = 1;
			  }
			  Delete(tbase);
			}
			Setattr(yyval.node,"specialization","1");
			Setattr(yyval.node,"templatetype",nodeType(yyval.node));
			set_nodeType(yyval.node,"template");
			/* Template partial specialization */
			if (tempn && (yyvsp[-3].tparms) && (yyvsp[0].node)) {
			  List   *tlist;
			  String *targs = SwigType_templateargs(tname);
			  tlist = SwigType_parmlist(targs);
			  /*			  Printf(stdout,"targs = '%s' %s\n", targs, tlist); */
			  if (!Getattr(yyval.node,"sym:weak")) {
			    Setattr(yyval.node,"sym:typename","1");
			  }
			  
			  if (Len(tlist) != ParmList_len(Getattr(tempn,"templateparms"))) {
			    Swig_error(Getfile(yyval.node),Getline(yyval.node),"Inconsistent argument count in template partial specialization. %d %d\n", Len(tlist), ParmList_len(Getattr(tempn,"templateparms")));
			    
			  } else {

			  /* This code builds the argument list for the partial template
                             specialization.  This is a little hairy, but the idea is as
                             follows:

                             $3 contains a list of arguments supplied for the template.
                             For example template<class T>.

                             tlist is a list of the specialization arguments--which may be
                             different.  For example class<int,T>.

                             tp is a copy of the arguments in the original template definition.
     
                             The patching algorithm walks through the list of supplied
                             arguments ($3), finds the position in the specialization arguments
                             (tlist), and then patches the name in the argument list of the
                             original template.
			  */

			  {
			    String *pn;
			    Parm *p, *p1;
			    int i, nargs;
			    Parm *tp = CopyParmList(Getattr(tempn,"templateparms"));
			    nargs = Len(tlist);
			    p = yyvsp[-3].tparms;
			    while (p) {
			      for (i = 0; i < nargs; i++){
				pn = Getattr(p,"name");
				if (Strcmp(pn,SwigType_base(Getitem(tlist,i))) == 0) {
				  int j;
				  Parm *p1 = tp;
				  for (j = 0; j < i; j++) {
				    p1 = nextSibling(p1);
				  }
				  Setattr(p1,"name",pn);
				  Setattr(p1,"partialarg","1");
				}
			      }
			      p = nextSibling(p);
			    }
			    p1 = tp;
			    i = 0;
			    while (p1) {
			      if (!Getattr(p1,"partialarg")) {
				Delattr(p1,"name");
				Setattr(p1,"type", Getitem(tlist,i));
			      } 
			      i++;
			      p1 = nextSibling(p1);
			    }
			    Setattr(yyval.node,"templateparms",tp);
			  }
#if 0
			  /* Patch the parameter list */
			  if (tempn) {
			    Parm *p,*p1;
			    ParmList *tp = CopyParmList(Getattr(tempn,"templateparms"));
			    p = yyvsp[-3].tparms;
			    p1 = tp;
			    while (p && p1) {
			      String *pn = Getattr(p,"name");
			      Printf(stdout,"pn = '%s'\n", pn);
			      if (pn) Setattr(p1,"name",pn);
			      else Delattr(p1,"name");
			      pn = Getattr(p,"type");
			      if (pn) Setattr(p1,"type",pn);
			      p = nextSibling(p);
			      p1 = nextSibling(p1);
			    }
			    Setattr(yyval.node,"templateparms",tp);
			  } else {
			    Setattr(yyval.node,"templateparms",yyvsp[-3].tparms);
			  }
#endif
			  Delattr(yyval.node,"specialization");
			  Setattr(yyval.node,"partialspecialization","1");
			  /* Create a specialized name for matching */
			  {
			    Parm *p = yyvsp[-3].tparms;
			    String *fname = NewString(Getattr(yyval.node,"name"));
			    String *ffname = 0;

			    char   tmp[32];
			    int    i;
			    while (p) {
			      String *n = Getattr(p,"name");
			      if (!n) {
				p = nextSibling(p);
				continue;
			      }
			      for (i = 0; i < Len(tlist); i++) {
				if (Strstr(Getitem(tlist,i),n)) {
				  sprintf(tmp,"$%d",i+1);
				  Replaceid(fname,n,tmp);
				}
			      }
			      p = nextSibling(p);
			    }
			    /* Patch argument names with typedef */
			    {
			      Iterator tt;
			      List *tparms = SwigType_parmlist(fname);
			      ffname = SwigType_templateprefix(fname);
			      Append(ffname,"<(");
			      for (tt = First(tparms); tt.item; ) {
				SwigType *ttr = Swig_symbol_typedef_reduce(tt.item,0);
				ttr = Swig_symbol_type_qualify(ttr,0);
				Append(ffname,ttr);
				tt = Next(tt);
				if (tt.item) Putc(',',ffname);
			      }
			      Append(ffname,")>");
			    }
			    {
			      String *partials = Getattr(tempn,"partials");
			      if (!partials) {
				partials = NewList();
				Setattr(tempn,"partials",partials);
			      }
			      /*			      Printf(stdout,"partial: fname = '%s', '%s'\n", fname, Swig_symbol_typedef_reduce(fname,0)); */
			      Append(partials,ffname);
			    }
			    Setattr(yyval.node,"partialargs",ffname);
			    Swig_symbol_cadd(ffname,yyval.node);
			  }
			  }
			  Delete(tlist);
			  Delete(targs);
			} else {
			  /* Need to resolve exact specialization name */
			  /* This needs to be rewritten */
			  List *tparms;
			  String *fname;
			  Iterator tt;
			  fname = SwigType_templateprefix(tname);
			  tparms = SwigType_parmlist(tname);
			  Append(fname,"<(");
			  for (tt = First(tparms); tt.item; ) {
			    SwigType *ttr = Swig_symbol_typedef_reduce(tt.item,0);
			    ttr = Swig_symbol_type_qualify(ttr,0);
			    Append(fname,ttr);
			    tt = Next(tt);
			    if (tt.item) Putc(',',fname);
			  }
			  Append(fname,")>");
			  Swig_symbol_cadd(fname,yyval.node);
			}
		      }  else if (yyval.node) {
			Setattr(yyval.node,"templatetype",nodeType(yyvsp[0].node));
			set_nodeType(yyval.node,"template");
			Setattr(yyval.node,"templateparms", yyvsp[-3].tparms);
			if (!Getattr(yyval.node,"sym:weak")) {
			  Setattr(yyval.node,"sym:typename","1");
			}
			add_symbols(yyval.node);
			/* We also place a fully parameterized version in the symbol table */
			{
			  Parm *p;
			  String *fname = NewStringf("%s<(",Getattr(yyval.node,"name"));
			  p = yyvsp[-3].tparms;
			  while (p) {
			    String *n = Getattr(p,"name");
			    if (!n) n = Getattr(p,"type");
			    Printf(fname,"%s", n);
			    p = nextSibling(p);
			    if (p) Putc(',',fname);
			  }
			  Printf(fname,")>");
			  Swig_symbol_cadd(fname,yyval.node);
			}
		      }
		      if (error) yyval.node = 0;
                  }
    break;

  case 142:
#line 2928 "parser.y"
    {
		  Swig_warning(WARN_PARSE_EXPLICIT_TEMPLATE, cparse_file, cparse_line, "Explicit template instantiation ignored.\n");
                   yyval.node = 0; 
                }
    break;

  case 143:
#line 2934 "parser.y"
    {
		  yyval.node = yyvsp[0].node;
                }
    break;

  case 144:
#line 2937 "parser.y"
    {
                   yyval.node = yyvsp[0].node;
                }
    break;

  case 145:
#line 2940 "parser.y"
    {
                   yyval.node = yyvsp[0].node;
                }
    break;

  case 146:
#line 2943 "parser.y"
    {
		  yyval.node = 0;
                }
    break;

  case 147:
#line 2946 "parser.y"
    {
                  yyval.node = yyvsp[0].node;
                }
    break;

  case 148:
#line 2951 "parser.y"
    {
		   /* Rip out the parameter names */
		  Parm *p = yyvsp[0].pl;
		  yyval.tparms = yyvsp[0].pl;

		  while (p) {
		    String *name = Getattr(p,"name");
		    if (!name) {
		      /* Hmmm. Maybe it's a 'class T' parameter */
		      char *type = Char(Getattr(p,"type"));
		      /* Template template parameter */
		      if (strncmp(type,"template<class> ",16) == 0) {
			type += 16;
		      }
		      if ((strncmp(type,"class ",6) == 0) || (strncmp(type,"typename ", 9) == 0)) {
			char *t = strchr(type,' ');
			Setattr(p,"name", t+1);
		      } else {
			/*
			 Swig_error(cparse_file, cparse_line, "Missing template parameter name\n");
			 $$.rparms = 0;
			 $$.parms = 0;
			 break; */
		      }
		    }
		    p = nextSibling(p);
		  }
                 }
    break;

  case 149:
#line 2983 "parser.y"
    {
                  yyval.node = new_node("using");
		  Setattr(yyval.node,"uname",yyvsp[-1].str);
		  Setattr(yyval.node,"name", Swig_scopename_last(yyvsp[-1].str));
		  add_symbols(yyval.node);
             }
    break;

  case 150:
#line 2989 "parser.y"
    {
	       Node *n = Swig_symbol_clookup(yyvsp[-1].str,0);
	       if (!n) {
		 Swig_error(cparse_file, cparse_line, "Nothing known about namespace '%s'\n", yyvsp[-1].str);
		 yyval.node = 0;
	       } else {

		 while (Strcmp(nodeType(n),"using") == 0) {
		   n = Getattr(n,"node");
		 }
		 if (n) {
		   if (Strcmp(nodeType(n),"namespace") == 0) {
		     yyval.node = new_node("using");
		     Setattr(yyval.node,"node",n);
		     Setattr(yyval.node,"namespace", yyvsp[-1].str);
		     Swig_symbol_inherit(Getattr(n,"symtab"));
		   } else {
		     Swig_error(cparse_file, cparse_line, "'%s' is not a namespace.\n", yyvsp[-1].str);
		     yyval.node = 0;
		   }
		 } else {
		   yyval.node = 0;
		 }
	       }
             }
    break;

  case 151:
#line 3016 "parser.y"
    { 
                Hash *h;
                yyvsp[-2].node = Swig_symbol_current();
		h = Swig_symbol_clookup(yyvsp[-1].str,0);
		if (h && (Strcmp(nodeType(h),"namespace") == 0)) {
		  if (Getattr(h,"alias")) {
		    h = Getattr(h,"namespace");
		    Swig_warning(WARN_PARSE_NAMESPACE_ALIAS, cparse_file, cparse_line, "Namespace alias '%s' not allowed here. Assuming '%s'\n",
				 yyvsp[-1].str, Getattr(h,"name"));
		    yyvsp[-1].str = Getattr(h,"name");
		  }
		  Swig_symbol_setscope(Getattr(h,"symtab"));
		} else {
		  Swig_symbol_newscope();
		  Swig_symbol_setscopename(yyvsp[-1].str);
		}
		Namespaceprefix = Swig_symbol_qualifiedscopename(0);
             }
    break;

  case 152:
#line 3033 "parser.y"
    {
                Node *n = yyvsp[-1].node;
		set_nodeType(n,"namespace");
		Setattr(n,"name",yyvsp[-4].str);
                Setattr(n,"symtab", Swig_symbol_popscope());
		Swig_symbol_setscope(yyvsp[-5].node);
		yyval.node = n;
		Namespaceprefix = Swig_symbol_qualifiedscopename(0);
		add_symbols(yyval.node);
             }
    break;

  case 153:
#line 3043 "parser.y"
    {
	       Hash *h;
	       yyvsp[-1].node = Swig_symbol_current();
	       h = Swig_symbol_clookup((char *)"",0);
	       if (h && (Strcmp(nodeType(h),"namespace") == 0)) {
		 Swig_symbol_setscope(Getattr(h,"symtab"));
	       } else {
		 Swig_symbol_newscope();
		 Swig_symbol_setscopename("__unnamed__");
	       }
	       Namespaceprefix = Swig_symbol_qualifiedscopename(0);
             }
    break;

  case 154:
#line 3054 "parser.y"
    {
	       yyval.node = yyvsp[-1].node;
	       set_nodeType(yyval.node,"namespace");
	       Setattr(yyval.node,"unnamed","1");
	       Setattr(yyval.node,"symtab", Swig_symbol_popscope());
	       Swig_symbol_setscope(yyvsp[-4].node);
	       Namespaceprefix = Swig_symbol_qualifiedscopename(0);
	       add_symbols(yyval.node);
             }
    break;

  case 155:
#line 3063 "parser.y"
    {
	       /* Namespace alias */
	       Node *n;
	       yyval.node = new_node("namespace");
	       Setattr(yyval.node,"name",yyvsp[-3].id);
	       Setattr(yyval.node,"alias",yyvsp[-1].str);
	       n = Swig_symbol_clookup(yyvsp[-1].str,0);
	       if (!n) {
		 Swig_error(cparse_file, cparse_line, "Unknown namespace '%s'\n", yyvsp[-1].str);
		 yyval.node = 0;
	       } else {
		 if (Strcmp(nodeType(n),"namespace") != 0) {
		   Swig_error(cparse_file, cparse_line, "'%s' is not a namespace\n",yyvsp[-1].str);
		   yyval.node = 0;
		 } else {
		   while (Getattr(n,"alias")) {
		     n = Getattr(n,"namespace");
		   }
		   Setattr(yyval.node,"namespace",n);
		   add_symbols(yyval.node);
		   /* Set up a scope alias */
		   Swig_symbol_alias(yyvsp[-3].id,Getattr(n,"symtab"));
		 }
	       }
             }
    break;

  case 156:
#line 3090 "parser.y"
    {
                   yyval.node = yyvsp[-1].node;
		   if (yyval.node) {
		     Node *p = yyval.node;
		     Node *pp =0;
		     while (p) {
		       pp = p;
		       p = nextSibling(p);
		     }
		     set_nextSibling(pp,yyvsp[0].node);
		   } else {
		     yyval.node = yyvsp[0].node;
		   }
             }
    break;

  case 157:
#line 3104 "parser.y"
    { 
                  if (cplus_mode != CPLUS_PUBLIC) {
		     Swig_error(cparse_file,cparse_line,"%%extend can only be used in a public section\n");
		  }
             }
    break;

  case 158:
#line 3108 "parser.y"
    {
	       yyval.node = new_node("extend");
	       Swig_tag_nodes(yyvsp[-2].node,"feature:extend",(char*) "1");
	       appendChild(yyval.node,yyvsp[-2].node);
	       set_nextSibling(yyval.node,yyvsp[0].node);
	     }
    break;

  case 159:
#line 3114 "parser.y"
    { yyval.node = 0;}
    break;

  case 160:
#line 3115 "parser.y"
    {
	       skip_decl();
		   {
		     static int last_error_line = -1;
		     if (last_error_line != cparse_line) {
		       Swig_error(cparse_file, cparse_line,"Syntax error in input.\n");
		       last_error_line = cparse_line;
		     }
		   }
	     }
    break;

  case 161:
#line 3124 "parser.y"
    { 
                yyval.node = yyvsp[0].node;
             }
    break;

  case 162:
#line 3135 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 163:
#line 3136 "parser.y"
    { 
                 yyval.node = yyvsp[0].node; 
		 if (extendmode) {
		   String *symname;
		   symname= make_name(Getattr(yyval.node,"name"), Getattr(yyval.node,"decl"));
		   if (Strcmp(symname,Getattr(yyval.node,"name")) == 0) {
		     /* No renaming operation.  Set name to class name */
		     yyrename = NewString(Getattr(current_class,"sym:name"));
		   } else {
		     yyrename = symname;
		   }
		 }
		 add_symbols(yyval.node);
             }
    break;

  case 164:
#line 3150 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 165:
#line 3151 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 166:
#line 3152 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 167:
#line 3153 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 168:
#line 3154 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 169:
#line 3155 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 170:
#line 3156 "parser.y"
    { yyval.node = 0; }
    break;

  case 171:
#line 3157 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 172:
#line 3158 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 173:
#line 3159 "parser.y"
    { yyval.node = 0; }
    break;

  case 174:
#line 3160 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 175:
#line 3161 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 176:
#line 3162 "parser.y"
    { yyval.node = 0; }
    break;

  case 177:
#line 3163 "parser.y"
    {yyval.node = yyvsp[0].node; }
    break;

  case 178:
#line 3164 "parser.y"
    {yyval.node = yyvsp[0].node; }
    break;

  case 179:
#line 3165 "parser.y"
    { yyval.node = 0; }
    break;

  case 180:
#line 3174 "parser.y"
    {
              if (Classprefix) {
		 SwigType *decl = NewString("");
		 yyval.node = new_node("constructor");
		 Setattr(yyval.node,"name",yyvsp[-4].type);
		 Setattr(yyval.node,"parms",yyvsp[-2].pl);
		 SwigType_add_function(decl,yyvsp[-2].pl);
		 Setattr(yyval.node,"decl",decl);
		 Setattr(yyval.node,"throws",yyvsp[0].decl.throws);
		 if (Len(scanner_ccode)) {
		   Setattr(yyval.node,"code",Copy(scanner_ccode));
		 }
		 Setattr(yyval.node,"feature:new","1");
	      } else {
		yyval.node = 0;
              }
              }
    break;

  case 181:
#line 3195 "parser.y"
    {
               yyval.node = new_node("destructor");
	       Setattr(yyval.node,"name",NewStringf("~%s",yyvsp[-4].str));
	       if (Len(scanner_ccode)) {
		 Setattr(yyval.node,"code",Copy(scanner_ccode));
	       }
	       {
		 String *decl = NewString("");
		 SwigType_add_function(decl,yyvsp[-2].pl);
		 Setattr(yyval.node,"decl",decl);
	       }
	       add_symbols(yyval.node);
	      }
    break;

  case 182:
#line 3211 "parser.y"
    {
		yyval.node = new_node("destructor");
	       /* Check for template names.  If the class is a template
		  and the constructor is missing the template part, we
		  add it */
	       {
		 char *c = Strstr(Classprefix,"<");
		 if (c) {
		   if (!Strstr(yyvsp[-4].str,"<")) {
		     yyvsp[-4].str = NewStringf("%s%s",yyvsp[-4].str,c);
		   }
		 }
	       }
		Setattr(yyval.node,"storage","virtual");
		Setattr(yyval.node,"name",NewStringf("~%s",yyvsp[-4].str));
		if (yyvsp[0].dtype.val) {
		  Setattr(yyval.node,"value","0");
		}
		if (Len(scanner_ccode)) {
		  Setattr(yyval.node,"code",Copy(scanner_ccode));
		}
		{
		  String *decl = NewString("");
		  SwigType_add_function(decl,yyvsp[-2].pl);
		  Setattr(yyval.node,"decl",decl);
		}

		add_symbols(yyval.node);
	      }
    break;

  case 183:
#line 3244 "parser.y"
    {
                 yyval.node = new_node("cdecl");
                 Setattr(yyval.node,"type",yyvsp[-5].type);
		 Setattr(yyval.node,"name",yyvsp[-6].str);

		 SwigType_add_function(yyvsp[-4].type,yyvsp[-2].pl);
		 if (yyvsp[0].dtype.qualifier) {
		   SwigType_push(yyvsp[-4].type,yyvsp[0].dtype.qualifier);
		 }
		 Setattr(yyval.node,"decl",yyvsp[-4].type);
		 Setattr(yyval.node,"parms",yyvsp[-2].pl);
		 Setattr(yyval.node,"conversion_operator","1");
		 add_symbols(yyval.node);
              }
    break;

  case 184:
#line 3258 "parser.y"
    {
		 SwigType *decl;
                 yyval.node = new_node("cdecl");
                 Setattr(yyval.node,"type",yyvsp[-5].type);
		 Setattr(yyval.node,"name",yyvsp[-6].str);
		 decl = NewString("");
		 SwigType_add_reference(decl);
		 SwigType_add_function(decl,yyvsp[-2].pl);
		 if (yyvsp[0].dtype.qualifier) {
		   SwigType_push(decl,yyvsp[0].dtype.qualifier);
		 }
		 Setattr(yyval.node,"decl",decl);
		 Setattr(yyval.node,"parms",yyvsp[-2].pl);
		 Setattr(yyval.node,"conversion_operator","1");
		 add_symbols(yyval.node);
	       }
    break;

  case 185:
#line 3275 "parser.y"
    {
		String *t = NewString("");
		yyval.node = new_node("cdecl");
		Setattr(yyval.node,"type",yyvsp[-4].type);
		Setattr(yyval.node,"name",yyvsp[-5].str);
		SwigType_add_function(t,yyvsp[-2].pl);
		if (yyvsp[0].dtype.qualifier) {
		  SwigType_push(t,yyvsp[0].dtype.qualifier);
		}
		Setattr(yyval.node,"decl",t);
		Setattr(yyval.node,"parms",yyvsp[-2].pl);
		Setattr(yyval.node,"conversion_operator","1");
		add_symbols(yyval.node);
              }
    break;

  case 186:
#line 3293 "parser.y"
    {
                 skip_balanced('{','}');
                 yyval.node = 0;
               }
    break;

  case 187:
#line 3300 "parser.y"
    { 
                yyval.node = new_node("access");
		Setattr(yyval.node,"kind","public");
                cplus_mode = CPLUS_PUBLIC;
              }
    break;

  case 188:
#line 3307 "parser.y"
    { 
                yyval.node = new_node("access");
                Setattr(yyval.node,"kind","private");
		cplus_mode = CPLUS_PRIVATE;
	      }
    break;

  case 189:
#line 3315 "parser.y"
    { 
		yyval.node = new_node("access");
		Setattr(yyval.node,"kind","protected");
		cplus_mode = CPLUS_PROTECTED;
	      }
    break;

  case 190:
#line 3338 "parser.y"
    { cparse_start_line = cparse_line; skip_balanced('{','}');
	      }
    break;

  case 191:
#line 3339 "parser.y"
    {
	        yyval.node = 0;
		if (cplus_mode == CPLUS_PUBLIC) {
		  if (yyvsp[-1].decl.id) {
		    if (strcmp(yyvsp[-5].id,"class") == 0) {
		      Swig_warning(WARN_PARSE_NESTED_CLASS, cparse_file, cparse_line, "Nested classes not currently supported (ignored).\n");
		      /* Generate some code for a new class */
		    } else {
		      Nested *n = (Nested *) malloc(sizeof(Nested));
		      n->code = NewString("");
		      Printv(n->code, "typedef ", yyvsp[-5].id, " ",
			     Char(scanner_ccode), " $classname_", yyvsp[-1].decl.id, ";\n", NIL);

		      n->name = Swig_copy_string(yyvsp[-1].decl.id);
		      n->line = cparse_start_line;
		      n->type = NewString("");
		      n->kind = yyvsp[-5].id;
		      SwigType_push(n->type, yyvsp[-1].decl.type);
		      n->next = 0;
		      add_nested(n);
		    }
		  } else {
		    Swig_warning(WARN_PARSE_NESTED_CLASS, cparse_file, cparse_line, "Nested %s not currently supported (ignored).\n", yyvsp[-5].id);
		  }
		}
	      }
    break;

  case 192:
#line 3367 "parser.y"
    { cparse_start_line = cparse_line; skip_balanced('{','}');
              }
    break;

  case 193:
#line 3368 "parser.y"
    {
	        yyval.node = 0;
		if (cplus_mode == CPLUS_PUBLIC) {
		  if (strcmp(yyvsp[-4].id,"class") == 0) {
		    Swig_warning(WARN_PARSE_NESTED_CLASS,cparse_file, cparse_line,"Nested class not currently supported (ignored)\n");
		    /* Generate some code for a new class */
		  } else if (yyvsp[-1].decl.id) {
		    /* Generate some code for a new class */
		    Nested *n = (Nested *) malloc(sizeof(Nested));
		    n->code = NewString("");
		    Printv(n->code, "typedef ", yyvsp[-4].id, " " ,
			    Char(scanner_ccode), " $classname_", yyvsp[-1].decl.id, ";\n",NIL);
		    n->name = Swig_copy_string(yyvsp[-1].decl.id);
		    n->line = cparse_start_line;
		    n->type = NewString("");
		    n->kind = yyvsp[-4].id;
		    SwigType_push(n->type,yyvsp[-1].decl.type);
		    n->next = 0;
		    add_nested(n);
		  } else {
		    Swig_warning(WARN_PARSE_NESTED_CLASS, cparse_file, cparse_line, "Nested %s not currently supported (ignored).\n", yyvsp[-4].id);
		  }
		}
	      }
    break;

  case 194:
#line 3394 "parser.y"
    { yyval.decl = yyvsp[0].decl;}
    break;

  case 195:
#line 3395 "parser.y"
    { yyval.decl.id = 0; }
    break;

  case 196:
#line 3401 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 197:
#line 3404 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 198:
#line 3408 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 199:
#line 3411 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 200:
#line 3412 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 201:
#line 3413 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 202:
#line 3414 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 203:
#line 3415 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 204:
#line 3416 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 205:
#line 3417 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 206:
#line 3418 "parser.y"
    { yyval.node = yyvsp[0].node; }
    break;

  case 207:
#line 3421 "parser.y"
    {
	            Clear(scanner_ccode);
               }
    break;

  case 208:
#line 3424 "parser.y"
    { skip_balanced('{','}'); }
    break;

  case 209:
#line 3427 "parser.y"
    { 
                     Clear(scanner_ccode);
                     yyval.dtype.val = 0;
                     yyval.dtype.qualifier = yyvsp[-1].dtype.qualifier;
                     yyval.dtype.bitfield = 0;
                     yyval.dtype.throws = yyvsp[-1].dtype.throws;
                }
    break;

  case 210:
#line 3434 "parser.y"
    { 
                     Clear(scanner_ccode);
                     yyval.dtype.val = yyvsp[-1].dtype.val;
                     yyval.dtype.qualifier = yyvsp[-3].dtype.qualifier;
                     yyval.dtype.bitfield = 0;
                     yyval.dtype.throws = yyvsp[-3].dtype.throws; 
               }
    break;

  case 211:
#line 3441 "parser.y"
    { 
                     skip_balanced('{','}');
                     yyval.dtype.val = 0;
                     yyval.dtype.qualifier = yyvsp[-1].dtype.qualifier;
                     yyval.dtype.bitfield = 0;
                     yyval.dtype.throws = yyvsp[-1].dtype.throws; 
               }
    break;

  case 212:
#line 3451 "parser.y"
    { }
    break;

  case 213:
#line 3457 "parser.y"
    { yyval.id = "extern"; }
    break;

  case 214:
#line 3458 "parser.y"
    { 
                   if (strcmp(yyvsp[0].id,"C") == 0) {
		     yyval.id = "externc";
		   } else {
		     Swig_warning(WARN_PARSE_UNDEFINED_EXTERN,cparse_file, cparse_line,"Unrecognized extern type \"%s\" (ignored).\n", yyvsp[0].id);
		     yyval.id = 0;
		   }
               }
    break;

  case 215:
#line 3466 "parser.y"
    { yyval.id = "static"; }
    break;

  case 216:
#line 3467 "parser.y"
    { yyval.id = "typedef"; }
    break;

  case 217:
#line 3468 "parser.y"
    { yyval.id = "virtual"; }
    break;

  case 218:
#line 3469 "parser.y"
    { yyval.id = "friend"; }
    break;

  case 219:
#line 3470 "parser.y"
    { yyval.id = 0; }
    break;

  case 220:
#line 3477 "parser.y"
    {
                 Parm *p;
		 yyval.pl = yyvsp[0].pl;
		 p = yyvsp[0].pl;
                 while (p) {
		   Replace(Getattr(p,"type"),"typename ", "", DOH_REPLACE_ANY);
		   p = nextSibling(p);
                 }
               }
    break;

  case 221:
#line 3488 "parser.y"
    {
		  if (1) { 
		    set_nextSibling(yyvsp[-1].p,yyvsp[0].pl);
		    yyval.pl = yyvsp[-1].p;
		  } else {
		    yyval.pl = yyvsp[0].pl;
		  }
		}
    break;

  case 222:
#line 3496 "parser.y"
    { yyval.pl = 0; }
    break;

  case 223:
#line 3499 "parser.y"
    {
                 set_nextSibling(yyvsp[-1].p,yyvsp[0].pl);
		 yyval.pl = yyvsp[-1].p;
                }
    break;

  case 224:
#line 3503 "parser.y"
    { yyval.pl = 0; }
    break;

  case 225:
#line 3507 "parser.y"
    {
                   SwigType_push(yyvsp[-1].type,yyvsp[0].decl.type);
		   yyval.p = NewParm(yyvsp[-1].type,yyvsp[0].decl.id);
		   Setfile(yyval.p,cparse_file);
		   Setline(yyval.p,cparse_line);
		   if (yyvsp[0].decl.defarg) {
		     Setattr(yyval.p,"value",yyvsp[0].decl.defarg);
		   }
		}
    break;

  case 226:
#line 3517 "parser.y"
    {
                  yyval.p = NewParm(NewStringf("template<class> %s %s", yyvsp[-1].id,yyvsp[0].str), 0);
		  Setfile(yyval.p,cparse_file);
		  Setline(yyval.p,cparse_line);
                }
    break;

  case 227:
#line 3522 "parser.y"
    {
		  SwigType *t = NewString("v(...)");
		  yyval.p = NewParm(t, 0);
		  Setfile(yyval.p,cparse_file);
		  Setline(yyval.p,cparse_line);
		}
    break;

  case 228:
#line 3530 "parser.y"
    {
                 Parm *p;
		 yyval.p = yyvsp[0].p;
		 p = yyvsp[0].p;
                 while (p) {
		   if (Getattr(p,"type")) {
		     Replace(Getattr(p,"type"),"typename ", "", DOH_REPLACE_ANY);
		   }
		   p = nextSibling(p);
                 }
               }
    break;

  case 229:
#line 3543 "parser.y"
    {
		  if (1) { 
		    set_nextSibling(yyvsp[-1].p,yyvsp[0].p);
		    yyval.p = yyvsp[-1].p;
		  } else {
		    yyval.p = yyvsp[0].p;
		  }
		}
    break;

  case 230:
#line 3551 "parser.y"
    { yyval.p = 0; }
    break;

  case 231:
#line 3554 "parser.y"
    {
                 set_nextSibling(yyvsp[-1].p,yyvsp[0].p);
		 yyval.p = yyvsp[-1].p;
                }
    break;

  case 232:
#line 3558 "parser.y"
    { yyval.p = 0; }
    break;

  case 233:
#line 3562 "parser.y"
    {
		  yyval.p = yyvsp[0].p;
		  {
		    /* We need to make a possible adjustment for integer parameters. */
		    SwigType *type;
		    Node     *n = 0;

		    while (!n) {
		      type = Getattr(yyvsp[0].p,"type");
		      n = Swig_symbol_clookup(type,0);     /* See if we can find a node that matches the typename */
		      if ((n) && (Strcmp(nodeType(n),"cdecl") == 0)) {
			SwigType *decl = Getattr(n,"decl");
			if (!SwigType_isfunction(decl)) {
			  String *value = Getattr(n,"value");
			  if (value) {
			    Setattr(yyvsp[0].p,"type",Copy(value));
			    n = 0;
			  }
			}
		      } else {
			break;
		      }
		    }
		  }
		  
               }
    break;

  case 234:
#line 3588 "parser.y"
    {
                  yyval.p = NewParm(0,0);
                  Setfile(yyval.p,cparse_file);
		  Setline(yyval.p,cparse_line);
		  Setattr(yyval.p,"value",yyvsp[0].dtype.val);
               }
    break;

  case 235:
#line 3594 "parser.y"
    {
                  yyval.p = NewParm(0,0);
                  Setfile(yyval.p,cparse_file);
		  Setline(yyval.p,cparse_line);
		  Setattr(yyval.p,"value",NewString(yyvsp[0].id));
               }
    break;

  case 236:
#line 3602 "parser.y"
    { 
                  yyval.dtype = yyvsp[0].dtype; 
		  if (yyvsp[0].dtype.type == T_ERROR) {
		    Swig_warning(WARN_PARSE_BAD_DEFAULT,cparse_file, cparse_line, "Can't set default argument (ignored)\n");
		    yyval.dtype.val = 0;
		    yyval.dtype.rawval = 0;
		    yyval.dtype.bitfield = 0;
		    yyval.dtype.throws = 0;
		  }
               }
    break;

  case 237:
#line 3612 "parser.y"
    {
		 Node *n = Swig_symbol_clookup(yyvsp[0].decl.id,0);
		 if (n) {
		   String *q = Swig_symbol_qualified(n);
		   if (Getattr(n,"access")) {
		     if (cplus_mode == CPLUS_PUBLIC) {
		       Swig_warning(WARN_PARSE_PRIVATE, cparse_file, cparse_line,"'%s' is private in this context.\n", yyvsp[0].decl.id);
		       Swig_warning(WARN_PARSE_BAD_DEFAULT, cparse_file, cparse_line,"Can't set default argument value (ignored)\n");
		     }
		     yyval.dtype.val = 0;
		   } else {
		     if (q) {
		       String *temp = NewStringf("%s::%s", q, Getattr(n,"name"));
		       yyval.dtype.val = NewStringf("&%s", SwigType_str(yyvsp[0].decl.type,temp));
		       Delete(q);
		       Delete(temp);
		     } else {
		       yyval.dtype.val = NewStringf("&%s", SwigType_str(yyvsp[0].decl.type,yyvsp[0].decl.id));
		     }
		   }
		 } else {
		   yyval.dtype.val = NewStringf("&%s",SwigType_str(yyvsp[0].decl.type,yyvsp[0].decl.id));
		 }
		 yyval.dtype.rawval = 0;
		 yyval.dtype.type = T_USER;
		 yyval.dtype.bitfield = 0;
		 yyval.dtype.throws = 0;
	       }
    break;

  case 238:
#line 3640 "parser.y"
    {
		 skip_balanced('{','}');
		 yyval.dtype.val = 0;
		 yyval.dtype.rawval = 0;
                 yyval.dtype.type = T_INT;
		 yyval.dtype.bitfield = 0;
		 yyval.dtype.throws = 0;
	       }
    break;

  case 239:
#line 3648 "parser.y"
    { 
		 yyval.dtype.val = 0;
		 yyval.dtype.rawval = 0;
		 yyval.dtype.type = 0;
		 yyval.dtype.bitfield = yyvsp[0].dtype.val;
		 yyval.dtype.throws = 0;
	       }
    break;

  case 240:
#line 3655 "parser.y"
    {
                 yyval.dtype.val = 0;
                 yyval.dtype.rawval = 0;
                 yyval.dtype.type = T_INT;
		 yyval.dtype.bitfield = 0;
		 yyval.dtype.throws = 0;
               }
    break;

  case 241:
#line 3664 "parser.y"
    {
                 yyval.decl = yyvsp[-1].decl;
		 yyval.decl.defarg = yyvsp[0].dtype.rawval ? yyvsp[0].dtype.rawval : yyvsp[0].dtype.val;
            }
    break;

  case 242:
#line 3668 "parser.y"
    {
              yyval.decl = yyvsp[-1].decl;
	      yyval.decl.defarg = yyvsp[0].dtype.rawval ? yyvsp[0].dtype.rawval : yyvsp[0].dtype.val;
            }
    break;

  case 243:
#line 3672 "parser.y"
    {
   	      yyval.decl.type = 0;
              yyval.decl.id = 0;
	      yyval.decl.defarg = yyvsp[0].dtype.rawval ? yyvsp[0].dtype.rawval : yyvsp[0].dtype.val;
            }
    break;

  case 244:
#line 3679 "parser.y"
    {
                 yyval.decl = yyvsp[0].decl;
		 if (SwigType_isfunction(yyvsp[0].decl.type)) {
		   Delete(SwigType_pop_function(yyvsp[0].decl.type));
		 } else if (SwigType_isarray(yyvsp[0].decl.type)) {
		   SwigType *ta = SwigType_pop_arrays(yyvsp[0].decl.type);
		   if (SwigType_isfunction(yyvsp[0].decl.type)) {
		     Delete(SwigType_pop_function(yyvsp[0].decl.type));
		   } else {
		     yyval.decl.parms = 0;
		   }
		   SwigType_push(yyvsp[0].decl.type,ta);
		   Delete(ta);
		 } else {
		   yyval.decl.parms = 0;
		 }
            }
    break;

  case 245:
#line 3696 "parser.y"
    {
              yyval.decl = yyvsp[0].decl;
	      if (SwigType_isfunction(yyvsp[0].decl.type)) {
		Delete(SwigType_pop_function(yyvsp[0].decl.type));
	      } else if (SwigType_isarray(yyvsp[0].decl.type)) {
		SwigType *ta = SwigType_pop_arrays(yyvsp[0].decl.type);
		if (SwigType_isfunction(yyvsp[0].decl.type)) {
		  Delete(SwigType_pop_function(yyvsp[0].decl.type));
		} else {
		  yyval.decl.parms = 0;
		}
		SwigType_push(yyvsp[0].decl.type,ta);
		Delete(ta);
	      } else {
		yyval.decl.parms = 0;
	      }
            }
    break;

  case 246:
#line 3713 "parser.y"
    {
   	      yyval.decl.type = 0;
              yyval.decl.id = 0;
	      yyval.decl.parms = 0;
	      }
    break;

  case 247:
#line 3721 "parser.y"
    {
              yyval.decl = yyvsp[0].decl;
	      if (yyval.decl.type) {
		SwigType_push(yyvsp[-1].type,yyval.decl.type);
		Delete(yyval.decl.type);
	      }
	      yyval.decl.type = yyvsp[-1].type;
           }
    break;

  case 248:
#line 3729 "parser.y"
    {
              yyval.decl = yyvsp[0].decl;
	      SwigType_add_reference(yyvsp[-2].type);
              if (yyval.decl.type) {
		SwigType_push(yyvsp[-2].type,yyval.decl.type);
		Delete(yyval.decl.type);
	      }
	      yyval.decl.type = yyvsp[-2].type;
           }
    break;

  case 249:
#line 3738 "parser.y"
    {
              yyval.decl = yyvsp[0].decl;
	      if (!yyval.decl.type) yyval.decl.type = NewString("");
           }
    break;

  case 250:
#line 3742 "parser.y"
    { 
	     yyval.decl = yyvsp[0].decl;
	     yyval.decl.type = NewString("");
	     SwigType_add_reference(yyval.decl.type);
	     if (yyvsp[0].decl.type) {
	       SwigType_push(yyval.decl.type,yyvsp[0].decl.type);
	       Delete(yyvsp[0].decl.type);
	     }
           }
    break;

  case 251:
#line 3751 "parser.y"
    { 
	     SwigType *t = NewString("");

	     yyval.decl = yyvsp[0].decl;
	     SwigType_add_memberpointer(t,yyvsp[-2].str);
	     if (yyval.decl.type) {
	       SwigType_push(t,yyval.decl.type);
	       Delete(yyval.decl.type);
	     }
	     yyval.decl.type = t;
	     }
    break;

  case 252:
#line 3762 "parser.y"
    { 
	     SwigType *t = NewString("");
	     yyval.decl = yyvsp[0].decl;
	     SwigType_add_memberpointer(t,yyvsp[-2].str);
	     SwigType_push(yyvsp[-3].type,t);
	     if (yyval.decl.type) {
	       SwigType_push(yyvsp[-3].type,yyval.decl.type);
	       Delete(yyval.decl.type);
	     }
	     yyval.decl.type = yyvsp[-3].type;
	     Delete(t);
	   }
    break;

  case 253:
#line 3774 "parser.y"
    { 
	     yyval.decl = yyvsp[0].decl;
	     SwigType_add_memberpointer(yyvsp[-4].type,yyvsp[-3].str);
	     SwigType_add_reference(yyvsp[-4].type);
	     if (yyval.decl.type) {
	       SwigType_push(yyvsp[-4].type,yyval.decl.type);
	       Delete(yyval.decl.type);
	     }
	     yyval.decl.type = yyvsp[-4].type;
	   }
    break;

  case 254:
#line 3784 "parser.y"
    { 
	     SwigType *t = NewString("");
	     yyval.decl = yyvsp[0].decl;
	     SwigType_add_memberpointer(t,yyvsp[-3].str);
	     SwigType_add_reference(t);
	     if (yyval.decl.type) {
	       SwigType_push(t,yyval.decl.type);
	       Delete(yyval.decl.type);
	     } 
	     yyval.decl.type = t;
	   }
    break;

  case 255:
#line 3797 "parser.y"
    {
                /* Note: This is non-standard C.  Template declarator is allowed to follow an identifier */
                 yyval.decl.id = Char(yyvsp[0].str);
		 yyval.decl.type = 0;
		 yyval.decl.parms = 0;
		 yyval.decl.have_parms = 0;
                  }
    break;

  case 256:
#line 3804 "parser.y"
    {
                  yyval.decl.id = Char(NewStringf("~%s",yyvsp[0].str));
                  yyval.decl.type = 0;
                  yyval.decl.parms = 0;
                  yyval.decl.have_parms = 0;
                  }
    break;

  case 257:
#line 3812 "parser.y"
    {
                  yyval.decl.id = Char(yyvsp[-1].str);
                  yyval.decl.type = 0;
                  yyval.decl.parms = 0;
                  yyval.decl.have_parms = 0;
                  }
    break;

  case 258:
#line 3828 "parser.y"
    {
		    yyval.decl = yyvsp[-1].decl;
		    if (yyval.decl.type) {
		      SwigType_push(yyvsp[-2].type,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = yyvsp[-2].type;
                  }
    break;

  case 259:
#line 3836 "parser.y"
    {
		    SwigType *t;
		    yyval.decl = yyvsp[-1].decl;
		    t = NewString("");
		    SwigType_add_memberpointer(t,yyvsp[-3].str);
		    if (yyval.decl.type) {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = t;
		    }
    break;

  case 260:
#line 3847 "parser.y"
    { 
		    SwigType *t;
		    yyval.decl = yyvsp[-2].decl;
		    t = NewString("");
		    SwigType_add_array(t,(char*)"");
		    if (yyval.decl.type) {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = t;
                  }
    break;

  case 261:
#line 3858 "parser.y"
    { 
		    SwigType *t;
		    yyval.decl = yyvsp[-3].decl;
		    t = NewString("");
		    SwigType_add_array(t,yyvsp[-1].dtype.val);
		    if (yyval.decl.type) {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = t;
                  }
    break;

  case 262:
#line 3869 "parser.y"
    {
		    SwigType *t;
                    yyval.decl = yyvsp[-3].decl;
		    t = NewString("");
		    SwigType_add_function(t,yyvsp[-1].pl);
		    if (!yyval.decl.have_parms) {
		      yyval.decl.parms = yyvsp[-1].pl;
		      yyval.decl.have_parms = 1;
		    }
		    if (!yyval.decl.type) {
		      yyval.decl.type = t;
		    } else {
		      SwigType_push(t, yyval.decl.type);
		      Delete(yyval.decl.type);
		      yyval.decl.type = t;
		    }
		  }
    break;

  case 263:
#line 3888 "parser.y"
    {
                /* Note: This is non-standard C.  Template declarator is allowed to follow an identifier */
                 yyval.decl.id = Char(yyvsp[0].str);
		 yyval.decl.type = 0;
		 yyval.decl.parms = 0;
		 yyval.decl.have_parms = 0;
                  }
    break;

  case 264:
#line 3896 "parser.y"
    {
                  yyval.decl.id = Char(NewStringf("~%s",yyvsp[0].str));
                  yyval.decl.type = 0;
                  yyval.decl.parms = 0;
                  yyval.decl.have_parms = 0;
                  }
    break;

  case 265:
#line 3913 "parser.y"
    {
		    yyval.decl = yyvsp[-1].decl;
		    if (yyval.decl.type) {
		      SwigType_push(yyvsp[-2].type,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = yyvsp[-2].type;
                  }
    break;

  case 266:
#line 3921 "parser.y"
    {
                    yyval.decl = yyvsp[-1].decl;
		    if (!yyval.decl.type) {
		      yyval.decl.type = NewString("");
		    }
		    SwigType_add_reference(yyval.decl.type);
                  }
    break;

  case 267:
#line 3928 "parser.y"
    {
		    SwigType *t;
		    yyval.decl = yyvsp[-1].decl;
		    t = NewString("");
		    SwigType_add_memberpointer(t,yyvsp[-3].str);
		    if (yyval.decl.type) {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = t;
		    }
    break;

  case 268:
#line 3939 "parser.y"
    { 
		    SwigType *t;
		    yyval.decl = yyvsp[-2].decl;
		    t = NewString("");
		    SwigType_add_array(t,(char*)"");
		    if (yyval.decl.type) {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = t;
                  }
    break;

  case 269:
#line 3950 "parser.y"
    { 
		    SwigType *t;
		    yyval.decl = yyvsp[-3].decl;
		    t = NewString("");
		    SwigType_add_array(t,yyvsp[-1].dtype.val);
		    if (yyval.decl.type) {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = t;
                  }
    break;

  case 270:
#line 3961 "parser.y"
    {
		    SwigType *t;
                    yyval.decl = yyvsp[-3].decl;
		    t = NewString("");
		    SwigType_add_function(t,yyvsp[-1].pl);
		    if (!yyval.decl.have_parms) {
		      yyval.decl.parms = yyvsp[-1].pl;
		      yyval.decl.have_parms = 1;
		    }
		    if (!yyval.decl.type) {
		      yyval.decl.type = t;
		    } else {
		      SwigType_push(t, yyval.decl.type);
		      Delete(yyval.decl.type);
		      yyval.decl.type = t;
		    }
		  }
    break;

  case 271:
#line 3980 "parser.y"
    {
		    yyval.decl.type = yyvsp[0].type;
                    yyval.decl.id = 0;
		    yyval.decl.parms = 0;
		    yyval.decl.have_parms = 0;
                  }
    break;

  case 272:
#line 3986 "parser.y"
    { 
                     yyval.decl = yyvsp[0].decl;
                     SwigType_push(yyvsp[-1].type,yyvsp[0].decl.type);
		     yyval.decl.type = yyvsp[-1].type;
		     Delete(yyvsp[0].decl.type);
                  }
    break;

  case 273:
#line 3992 "parser.y"
    {
		    yyval.decl.type = yyvsp[-1].type;
		    SwigType_add_reference(yyval.decl.type);
		    yyval.decl.id = 0;
		    yyval.decl.parms = 0;
		    yyval.decl.have_parms = 0;
		  }
    break;

  case 274:
#line 3999 "parser.y"
    {
		    yyval.decl = yyvsp[0].decl;
		    SwigType_add_reference(yyvsp[-2].type);
		    if (yyval.decl.type) {
		      SwigType_push(yyvsp[-2].type,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = yyvsp[-2].type;
                  }
    break;

  case 275:
#line 4008 "parser.y"
    {
		    yyval.decl = yyvsp[0].decl;
                  }
    break;

  case 276:
#line 4011 "parser.y"
    {
		    yyval.decl = yyvsp[0].decl;
		    yyval.decl.type = NewString("");
		    SwigType_add_reference(yyval.decl.type);
		    if (yyvsp[0].decl.type) {
		      SwigType_push(yyval.decl.type,yyvsp[0].decl.type);
		      Delete(yyvsp[0].decl.type);
		    }
                  }
    break;

  case 277:
#line 4020 "parser.y"
    { 
                    yyval.decl.id = 0;
                    yyval.decl.parms = 0;
		    yyval.decl.have_parms = 0;
                    yyval.decl.type = NewString("");
		    SwigType_add_reference(yyval.decl.type);
                  }
    break;

  case 278:
#line 4027 "parser.y"
    { 
		    yyval.decl.type = NewString("");
                    SwigType_add_memberpointer(yyval.decl.type,yyvsp[-1].str);
                    yyval.decl.id = 0;
                    yyval.decl.parms = 0;
		    yyval.decl.have_parms = 0;
      	          }
    break;

  case 279:
#line 4034 "parser.y"
    { 
		    SwigType *t = NewString("");
                    yyval.decl.type = yyvsp[-2].type;
		    yyval.decl.id = 0;
		    yyval.decl.parms = 0;
		    yyval.decl.have_parms = 0;
		    SwigType_add_memberpointer(t,yyvsp[-1].str);
		    SwigType_push(yyval.decl.type,t);
		    Delete(t);
                  }
    break;

  case 280:
#line 4044 "parser.y"
    { 
		    yyval.decl = yyvsp[0].decl;
		    SwigType_add_memberpointer(yyvsp[-3].type,yyvsp[-2].str);
		    if (yyval.decl.type) {
		      SwigType_push(yyvsp[-3].type,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = yyvsp[-3].type;
                  }
    break;

  case 281:
#line 4055 "parser.y"
    { 
		    SwigType *t;
		    yyval.decl = yyvsp[-2].decl;
		    t = NewString("");
		    SwigType_add_array(t,(char*)"");
		    if (yyval.decl.type) {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = t;
                  }
    break;

  case 282:
#line 4066 "parser.y"
    { 
		    SwigType *t;
		    yyval.decl = yyvsp[-3].decl;
		    t = NewString("");
		    SwigType_add_array(t,yyvsp[-1].dtype.val);
		    if (yyval.decl.type) {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		    }
		    yyval.decl.type = t;
                  }
    break;

  case 283:
#line 4077 "parser.y"
    { 
		    yyval.decl.type = NewString("");
		    yyval.decl.id = 0;
		    yyval.decl.parms = 0;
		    yyval.decl.have_parms = 0;
		    SwigType_add_array(yyval.decl.type,(char*)"");
                  }
    break;

  case 284:
#line 4084 "parser.y"
    { 
		    yyval.decl.type = NewString("");
		    yyval.decl.id = 0;
		    yyval.decl.parms = 0;
		    yyval.decl.have_parms = 0;
		    SwigType_add_array(yyval.decl.type,yyvsp[-1].dtype.val);
		  }
    break;

  case 285:
#line 4091 "parser.y"
    {
                    yyval.decl = yyvsp[-1].decl;
		  }
    break;

  case 286:
#line 4094 "parser.y"
    {
		    SwigType *t;
                    yyval.decl = yyvsp[-3].decl;
		    t = NewString("");
                    SwigType_add_function(t,yyvsp[-1].pl);
		    if (!yyval.decl.type) {
		      yyval.decl.type = t;
		    } else {
		      SwigType_push(t,yyval.decl.type);
		      Delete(yyval.decl.type);
		      yyval.decl.type = t;
		    }
		    if (!yyval.decl.have_parms) {
		      yyval.decl.parms = yyvsp[-1].pl;
		      yyval.decl.have_parms = 1;
		    }
		  }
    break;

  case 287:
#line 4111 "parser.y"
    {
                    yyval.decl.type = NewString("");
                    SwigType_add_function(yyval.decl.type,yyvsp[-1].pl);
		    yyval.decl.parms = yyvsp[-1].pl;
		    yyval.decl.have_parms = 1;
		    yyval.decl.id = 0;
                  }
    break;

  case 288:
#line 4121 "parser.y"
    { 
               yyval.type = NewString("");
               SwigType_add_pointer(yyval.type);
	       SwigType_push(yyval.type,yyvsp[-1].str);
	       SwigType_push(yyval.type,yyvsp[0].type);
	       Delete(yyvsp[0].type);
           }
    break;

  case 289:
#line 4128 "parser.y"
    {
	     yyval.type = NewString("");
	     SwigType_add_pointer(yyval.type);
	     SwigType_push(yyval.type,yyvsp[0].type);
	     Delete(yyvsp[0].type);
	     }
    break;

  case 290:
#line 4134 "parser.y"
    { 
	     	yyval.type = NewString("");	
		SwigType_add_pointer(yyval.type);
	        SwigType_push(yyval.type,yyvsp[0].str);
           }
    break;

  case 291:
#line 4139 "parser.y"
    {
	      yyval.type = NewString("");
	      SwigType_add_pointer(yyval.type);
           }
    break;

  case 292:
#line 4145 "parser.y"
    { 
                  yyval.str = NewString("");
	          SwigType_add_qualifier(yyval.str,yyvsp[0].id);
               }
    break;

  case 293:
#line 4149 "parser.y"
    { 
                  yyval.str = yyvsp[0].str; 
                  SwigType_add_qualifier(yyval.str,yyvsp[-1].id);
               }
    break;

  case 294:
#line 4155 "parser.y"
    { yyval.id = "const"; }
    break;

  case 295:
#line 4156 "parser.y"
    { yyval.id = "volatile"; }
    break;

  case 296:
#line 4162 "parser.y"
    {
                   yyval.type = yyvsp[0].type;
                   Replace(yyval.type,"typename ","", DOH_REPLACE_ANY);
                }
    break;

  case 297:
#line 4168 "parser.y"
    {
                   yyval.type = yyvsp[0].type;
	           SwigType_push(yyval.type,yyvsp[-1].str);
               }
    break;

  case 298:
#line 4172 "parser.y"
    { yyval.type = yyvsp[0].type; }
    break;

  case 299:
#line 4175 "parser.y"
    { yyval.type = yyvsp[0].type;
                  /* Printf(stdout,"primitive = '%s'\n", $$);*/
                }
    break;

  case 300:
#line 4178 "parser.y"
    { yyval.type = yyvsp[0].type; }
    break;

  case 301:
#line 4179 "parser.y"
    { yyval.type = yyvsp[0].type; }
    break;

  case 302:
#line 4180 "parser.y"
    { yyval.type = NewStringf("%s%s",yyvsp[-1].type,yyvsp[0].id); }
    break;

  case 303:
#line 4181 "parser.y"
    { yyval.type = NewStringf("enum %s", yyvsp[0].str); }
    break;

  case 304:
#line 4182 "parser.y"
    { yyval.type = yyvsp[0].type; }
    break;

  case 305:
#line 4183 "parser.y"
    {
		  yyval.type = yyvsp[-1].type;
	          SwigType_push(yyval.type,yyvsp[0].str);
     	       }
    break;

  case 306:
#line 4188 "parser.y"
    {
		  yyval.type = yyvsp[0].str;
               }
    break;

  case 307:
#line 4191 "parser.y"
    { 
		 yyval.type = NewStringf("%s %s", yyvsp[-1].id, yyvsp[0].str);
               }
    break;

  case 308:
#line 4196 "parser.y"
    {
		 if (!yyvsp[0].ptype.type) yyvsp[0].ptype.type = NewString("int");
		 if (yyvsp[0].ptype.us) {
		   yyval.type = NewStringf("%s %s", yyvsp[0].ptype.us, yyvsp[0].ptype.type);
		   Delete(yyvsp[0].ptype.us);
                   Delete(yyvsp[0].ptype.type);
		 } else {
                   yyval.type = yyvsp[0].ptype.type;
		 }
		 if (Cmp(yyval.type,"signed int") == 0) {
		   Delete(yyval.type);
		   yyval.type = NewString("int");
                 } else if (Cmp(yyval.type,"signed long") == 0) {
		   Delete(yyval.type);
                   yyval.type = NewString("long");
                 } else if (Cmp(yyval.type,"signed short") == 0) {
		   Delete(yyval.type);
		   yyval.type = NewString("short");
		 } else if (Cmp(yyval.type,"signed long long") == 0) {
		   Delete(yyval.type);
		   yyval.type = NewString("long long");
		 }
               }
    break;

  case 309:
#line 4221 "parser.y"
    { 
                 yyval.ptype = yyvsp[0].ptype;
               }
    break;

  case 310:
#line 4224 "parser.y"
    {
                    if (yyvsp[-1].ptype.us && yyvsp[0].ptype.us) {
		      Swig_error(cparse_file, cparse_line, "Extra %s specifier.\n", yyvsp[0].ptype.us);
		    }
                    yyval.ptype = yyvsp[0].ptype;
                    if (yyvsp[-1].ptype.us) yyval.ptype.us = yyvsp[-1].ptype.us;
		    if (yyvsp[-1].ptype.type) {
		      if (!yyvsp[0].ptype.type) yyval.ptype.type = yyvsp[-1].ptype.type;
		      else {
			int err = 0;
			if ((Cmp(yyvsp[-1].ptype.type,"long") == 0)) {
			  if ((Cmp(yyvsp[0].ptype.type,"long") == 0) || (Cmp(yyvsp[0].ptype.type,"double") == 0)) {
			    yyval.ptype.type = NewStringf("long %s", yyvsp[0].ptype.type);
			  } else if (Cmp(yyvsp[0].ptype.type,"int") == 0) {
			    yyval.ptype.type = yyvsp[-1].ptype.type;
			  } else {
			    err = 1;
			  }
			} else if ((Cmp(yyvsp[-1].ptype.type,"short")) == 0) {
			  if (Cmp(yyvsp[0].ptype.type,"int") == 0) {
			    yyval.ptype.type = yyvsp[-1].ptype.type;
			  } else {
			    err = 1;
			  }
			} else if (Cmp(yyvsp[-1].ptype.type,"int") == 0) {
			  yyval.ptype.type = yyvsp[0].ptype.type;
			} else if (Cmp(yyvsp[-1].ptype.type,"double") == 0) {
			  if (Cmp(yyvsp[0].ptype.type,"long") == 0) {
			    yyval.ptype.type = NewString("long double");
			  } else {
			    err = 1;
			  }
			}
			if (err) {
			  Swig_error(cparse_file, cparse_line, "Extra %s specifier.\n", yyvsp[-1].ptype.type);
			}
		      }
		    }
               }
    break;

  case 311:
#line 4266 "parser.y"
    { 
		    yyval.ptype.type = NewString("int");
                    yyval.ptype.us = 0;
               }
    break;

  case 312:
#line 4270 "parser.y"
    { 
                    yyval.ptype.type = NewString("short");
                    yyval.ptype.us = 0;
                }
    break;

  case 313:
#line 4274 "parser.y"
    { 
                    yyval.ptype.type = NewString("long");
                    yyval.ptype.us = 0;
                }
    break;

  case 314:
#line 4278 "parser.y"
    { 
                    yyval.ptype.type = NewString("char");
                    yyval.ptype.us = 0;
                }
    break;

  case 315:
#line 4282 "parser.y"
    { 
                    yyval.ptype.type = NewString("float");
                    yyval.ptype.us = 0;
                }
    break;

  case 316:
#line 4286 "parser.y"
    { 
                    yyval.ptype.type = NewString("double");
                    yyval.ptype.us = 0;
                }
    break;

  case 317:
#line 4290 "parser.y"
    { 
                    yyval.ptype.us = NewString("signed");
                    yyval.ptype.type = 0;
                }
    break;

  case 318:
#line 4294 "parser.y"
    { 
                    yyval.ptype.us = NewString("unsigned");
                    yyval.ptype.type = 0;
                }
    break;

  case 319:
#line 4300 "parser.y"
    { /* scanner_check_typedef(); */ }
    break;

  case 320:
#line 4300 "parser.y"
    {
                   yyval.dtype = yyvsp[0].dtype;
		   if (yyval.dtype.type == T_STRING) {
		     yyval.dtype.rawval = NewStringf("\"%(escape)s\"",yyval.dtype.val);
		   } else {
		     yyval.dtype.rawval = 0;
		   }
		   yyval.dtype.bitfield = 0;
		   yyval.dtype.throws = 0;
		   scanner_ignore_typedef();
                }
    break;

  case 321:
#line 4319 "parser.y"
    {
                   yyval.dtype.val = NewString(yyvsp[0].str);
		   /*		   $$.rawval = NewStringf("\'%(escape)s\'",$$.val); */
		   /*		   Printf(stdout,"rawval = '%s'\n", $$.rawval); */
		   if (Len(yyval.dtype.val)) {
		     yyval.dtype.rawval = NewStringf("\'%(escape)s\'", yyval.dtype.val);
		   } else {
		     yyval.dtype.rawval = NewString("\'\\0'");
		   }
		   yyval.dtype.type = T_CHAR;
		   yyval.dtype.bitfield = 0;
		   yyval.dtype.throws = 0;
		 }
    break;

  case 322:
#line 4336 "parser.y"
    { yyval.id = yyvsp[0].id; }
    break;

  case 323:
#line 4337 "parser.y"
    { yyval.id = (char *) 0;}
    break;

  case 324:
#line 4340 "parser.y"
    { 

                  /* Ignore if there is a trailing comma in the enum list */
                  if (yyvsp[0].node) {
                    Node *leftSibling = Getattr(yyvsp[-2].node,"_last");
                    if (!leftSibling) {
                      leftSibling=yyvsp[-2].node;
                    }
                    set_nextSibling(leftSibling,yyvsp[0].node);
                    Setattr(yyvsp[-2].node,"_last",yyvsp[0].node);
                  }
		  yyval.node = yyvsp[-2].node;
               }
    break;

  case 325:
#line 4353 "parser.y"
    { 
                   yyval.node = yyvsp[0].node; 
                   if (yyvsp[0].node) {
                     Setattr(yyvsp[0].node,"_last",yyvsp[0].node);
                   }
               }
    break;

  case 326:
#line 4361 "parser.y"
    {
		   yyval.node = new_node("enumitem");
		   Setattr(yyval.node,"name",yyvsp[0].id);
		   Setattr(yyval.node,"type",NewSwigType(T_INT));
		   Setattr(yyval.node,"feature:immutable","1");
		 }
    break;

  case 327:
#line 4367 "parser.y"
    {
		   yyval.node = new_node("enumitem");
		   Setattr(yyval.node,"name",yyvsp[-2].id);
		   Setattr(yyval.node,"enumvalue", yyvsp[0].dtype.val);
	           if (yyvsp[0].dtype.type == T_CHAR) {
		     Setattr(yyval.node,"value",yyvsp[0].dtype.val);
		     Setattr(yyval.node,"type",NewSwigType(T_CHAR));
		   } else {
		     Setattr(yyval.node,"value",yyvsp[-2].id);
		     Setattr(yyval.node,"type",NewSwigType(T_INT));
		   }
		   Setattr(yyval.node,"feature:immutable","1");
                 }
    break;

  case 328:
#line 4380 "parser.y"
    { yyval.node = 0; }
    break;

  case 329:
#line 4383 "parser.y"
    {
                   yyval.dtype = yyvsp[0].dtype;
		   if ((yyval.dtype.type != T_INT) && (yyval.dtype.type != T_UINT) &&
		       (yyval.dtype.type != T_LONG) && (yyval.dtype.type != T_ULONG) &&
		       (yyval.dtype.type != T_SHORT) && (yyval.dtype.type != T_USHORT) &&
		       (yyval.dtype.type != T_SCHAR) && (yyval.dtype.type != T_UCHAR)) {
		     Swig_error(cparse_file,cparse_line,"Type error. Expecting an int\n");
		   }
                }
    break;

  case 330:
#line 4392 "parser.y"
    {
                   yyval.dtype.val  = NewString(yyvsp[0].str);
		   yyval.dtype.type = T_INT;
		 }
    break;

  case 331:
#line 4403 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 332:
#line 4404 "parser.y"
    { 
		    yyval.dtype.val = NewString(yyvsp[0].id); 
                    yyval.dtype.type = T_STRING; 
               }
    break;

  case 333:
#line 4408 "parser.y"
    {
  		  SwigType_push(yyvsp[-2].type,yyvsp[-1].decl.type);
		  yyval.dtype.val = NewStringf("sizeof(%s)",SwigType_str(yyvsp[-2].type,0));
		  yyval.dtype.type = T_INT;
               }
    break;

  case 334:
#line 4413 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 335:
#line 4414 "parser.y"
    {
		 Node *n;
		 yyval.dtype.val = yyvsp[0].type;
		 yyval.dtype.type = T_INT;
		 /* Check if value is in scope */
		 n = Swig_symbol_clookup(yyvsp[0].type,0);
		 if (n) {
		   if (Getattr(n,"access") && (cplus_mode == CPLUS_PUBLIC)) {
		     Swig_warning(WARN_PARSE_PRIVATE,cparse_file, cparse_line, "'%s' is private in this context.\n", yyvsp[0].type);
		     yyval.dtype.type = T_ERROR;
		   } else {
		     /* A band-aid for enum values used in expressions. */
		     if (Strcmp(nodeType(n),"enumitem") == 0) {
		       String *q = Swig_symbol_qualified(n);
		       if (q) {
			 yyval.dtype.val = NewStringf("%s::%s", q, Getattr(n,"name"));
			 Delete(q);
		       }
		     }
		   }
		 }
               }
    break;

  case 336:
#line 4438 "parser.y"
    {
   	            yyval.dtype.val = NewStringf("(%s)",yyvsp[-1].dtype.val);
		    yyval.dtype.type = yyvsp[-1].dtype.type;
   	       }
    break;

  case 337:
#line 4445 "parser.y"
    {
                 yyval.dtype = yyvsp[0].dtype;
		 if (yyvsp[0].dtype.type != T_STRING) {
		   yyval.dtype.val = NewStringf("(%s) %s", SwigType_str(yyvsp[-2].dtype.val,0), yyvsp[0].dtype.val);
		 }
 	       }
    break;

  case 338:
#line 4451 "parser.y"
    {
                 yyval.dtype = yyvsp[0].dtype;
		 if (yyvsp[0].dtype.type != T_STRING) {
		   SwigType_push(yyvsp[-3].dtype.val,yyvsp[-2].type);
		   yyval.dtype.val = NewStringf("(%s) %s", SwigType_str(yyvsp[-3].dtype.val,0), yyvsp[0].dtype.val);
		 }
 	       }
    break;

  case 339:
#line 4458 "parser.y"
    {
                 yyval.dtype = yyvsp[0].dtype;
		 if (yyvsp[0].dtype.type != T_STRING) {
		   SwigType_add_reference(yyvsp[-3].dtype.val);
		   yyval.dtype.val = NewStringf("(%s) %s", SwigType_str(yyvsp[-3].dtype.val,0), yyvsp[0].dtype.val);
		 }
 	       }
    break;

  case 340:
#line 4465 "parser.y"
    {
                 yyval.dtype = yyvsp[0].dtype;
		 if (yyvsp[0].dtype.type != T_STRING) {
		   SwigType_push(yyvsp[-4].dtype.val,yyvsp[-3].type);
		   SwigType_add_reference(yyvsp[-4].dtype.val);
		   yyval.dtype.val = NewStringf("(%s) %s", SwigType_str(yyvsp[-4].dtype.val,0), yyvsp[0].dtype.val);
		 }
 	       }
    break;

  case 341:
#line 4475 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 342:
#line 4476 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 343:
#line 4477 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 344:
#line 4478 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 345:
#line 4479 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 346:
#line 4480 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 347:
#line 4481 "parser.y"
    { yyval.dtype = yyvsp[0].dtype; }
    break;

  case 348:
#line 4484 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s+%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 349:
#line 4488 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s-%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 350:
#line 4492 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s*%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 351:
#line 4496 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s/%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 352:
#line 4500 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s&%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 353:
#line 4504 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s|%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 354:
#line 4508 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s^%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 355:
#line 4512 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s<<%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 356:
#line 4516 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s>>%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = promote(yyvsp[-2].dtype.type,yyvsp[0].dtype.type);
	       }
    break;

  case 357:
#line 4520 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s&&%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = T_INT;
	       }
    break;

  case 358:
#line 4524 "parser.y"
    {
		 yyval.dtype.val = NewStringf("%s||%s",yyvsp[-2].dtype.val,yyvsp[0].dtype.val);
		 yyval.dtype.type = T_INT;
	       }
    break;

  case 359:
#line 4528 "parser.y"
    {
		 yyval.dtype.val = NewStringf("-%s",yyvsp[0].dtype.val);
		 yyval.dtype.type = yyvsp[0].dtype.type;
	       }
    break;

  case 360:
#line 4532 "parser.y"
    {
                 yyval.dtype.val = NewStringf("+%s",yyvsp[0].dtype.val);
		 yyval.dtype.type = yyvsp[0].dtype.type;
  	       }
    break;

  case 361:
#line 4536 "parser.y"
    {
		 yyval.dtype.val = NewStringf("~%s",yyvsp[0].dtype.val);
		 yyval.dtype.type = yyvsp[0].dtype.type;
	       }
    break;

  case 362:
#line 4540 "parser.y"
    {
                 yyval.dtype.val = NewStringf("!%s",yyvsp[0].dtype.val);
		 yyval.dtype.type = T_INT;
	       }
    break;

  case 363:
#line 4544 "parser.y"
    {
                 skip_balanced('(',')');
		 if (SwigType_istemplate(yyvsp[-1].type)) {
		   yyvsp[-1].type = SwigType_namestr(yyvsp[-1].type);
		 }
		 yyval.dtype.val = NewStringf("%s%s",yyvsp[-1].type,scanner_ccode);
		 Clear(scanner_ccode);
		 yyval.dtype.type = T_INT;
               }
    break;

  case 364:
#line 4555 "parser.y"
    {
		 yyval.bases = yyvsp[0].bases;
               }
    break;

  case 365:
#line 4560 "parser.y"
    { inherit_list = 1; }
    break;

  case 366:
#line 4560 "parser.y"
    { yyval.bases = yyvsp[0].bases; inherit_list = 0; }
    break;

  case 367:
#line 4561 "parser.y"
    { yyval.bases = 0; }
    break;

  case 368:
#line 4564 "parser.y"
    {
	           yyval.bases = NewList();
	           if (yyvsp[0].node) Append(yyval.bases,yyvsp[0].node);
               }
    break;

  case 369:
#line 4569 "parser.y"
    {
                   yyval.bases = yyvsp[-2].bases;
                   if (yyvsp[0].node) Append(yyval.bases,yyvsp[0].node);
               }
    break;

  case 370:
#line 4575 "parser.y"
    {
                 if (last_cpptype && (Strcmp(last_cpptype,"struct") != 0)) {
                     Swig_warning(WARN_PARSE_NO_ACCESS,cparse_file, cparse_line,"No access specifier given for base class %s (ignored).\n",yyvsp[0].str);
   		     yyval.node = (char *) 0;
                 } else {
		   yyval.node = yyvsp[0].str;
		   Setfile(yyval.node,cparse_file);
		   Setline(yyval.node,cparse_line);
		 }
               }
    break;

  case 371:
#line 4585 "parser.y"
    {
		 yyval.node = 0;
	         if (strcmp(yyvsp[-2].id,"public") == 0) {
		   yyval.node = yyvsp[0].str;
		   Setfile(yyval.node, cparse_file);
		   Setline(yyval.node, cparse_line);
		 } else {
		   Swig_warning(WARN_PARSE_PRIVATE_INHERIT, cparse_file, cparse_line, "%s inheritance ignored.\n", yyvsp[-2].id);
		 }
               }
    break;

  case 372:
#line 4597 "parser.y"
    { yyval.id = (char*)"public"; }
    break;

  case 373:
#line 4598 "parser.y"
    { yyval.id = (char*)"private"; }
    break;

  case 374:
#line 4599 "parser.y"
    { yyval.id = (char*)"protected"; }
    break;

  case 375:
#line 4603 "parser.y"
    { 
                   yyval.id = (char*)"class"; 
		   if (!inherit_list) last_cpptype = yyval.id;
               }
    break;

  case 376:
#line 4607 "parser.y"
    { 
                   yyval.id = (char*)"struct"; 
		   if (!inherit_list) last_cpptype = yyval.id;
               }
    break;

  case 377:
#line 4611 "parser.y"
    {
                   yyval.id = (char*)"union"; 
		   if (!inherit_list) last_cpptype = yyval.id;
               }
    break;

  case 378:
#line 4615 "parser.y"
    { 
                   yyval.id = (char *)"typename"; 
		   if (!inherit_list) last_cpptype = yyval.id;
               }
    break;

  case 381:
#line 4625 "parser.y"
    {
                    yyval.dtype.qualifier = yyvsp[0].str;
                    yyval.dtype.throws = 0;
               }
    break;

  case 382:
#line 4629 "parser.y"
    {
                    yyval.dtype.qualifier = 0;
                    yyval.dtype.throws = yyvsp[-1].pl;
               }
    break;

  case 383:
#line 4633 "parser.y"
    {
                    yyval.dtype.qualifier = yyvsp[-4].str;
                    yyval.dtype.throws = yyvsp[-1].pl;
               }
    break;

  case 384:
#line 4637 "parser.y"
    { 
                    yyval.dtype.qualifier = 0; 
                    yyval.dtype.throws = 0;
               }
    break;

  case 385:
#line 4643 "parser.y"
    { 
                    Clear(scanner_ccode); 
                    yyval.decl.have_parms = 0; 
                    yyval.decl.defarg = 0; 
		    yyval.decl.throws = yyvsp[-2].dtype.throws;
               }
    break;

  case 386:
#line 4649 "parser.y"
    { 
                    skip_balanced('{','}'); 
                    yyval.decl.have_parms = 0; 
                    yyval.decl.defarg = 0; 
                    yyval.decl.throws = yyvsp[-2].dtype.throws;
               }
    break;

  case 387:
#line 4655 "parser.y"
    { 
                    Clear(scanner_ccode); 
                    yyval.decl.parms = yyvsp[-2].pl; 
                    yyval.decl.have_parms = 1; 
                    yyval.decl.defarg = 0; 
		    yyval.decl.throws = 0;
               }
    break;

  case 388:
#line 4662 "parser.y"
    {
                    skip_balanced('{','}'); 
                    yyval.decl.parms = yyvsp[-2].pl; 
                    yyval.decl.have_parms = 1; 
                    yyval.decl.defarg = 0; 
                    yyval.decl.throws = 0;
               }
    break;

  case 389:
#line 4669 "parser.y"
    { 
                    yyval.decl.have_parms = 0; 
                    yyval.decl.defarg = yyvsp[-1].dtype.val; 
                    yyval.decl.throws = 0;
               }
    break;

  case 394:
#line 4684 "parser.y"
    {
	            skip_balanced('(',')');
                    Clear(scanner_ccode);
            	}
    break;

  case 395:
#line 4690 "parser.y"
    { 
                     String *s = NewString("");
                     SwigType_add_template(s,yyvsp[-1].p);
                     yyval.id = Char(s);
		     scanner_last_id(1);
                 }
    break;

  case 396:
#line 4696 "parser.y"
    { yyval.id = (char*)"";  }
    break;

  case 397:
#line 4699 "parser.y"
    { yyval.id = yyvsp[0].id; }
    break;

  case 398:
#line 4700 "parser.y"
    { yyval.id = yyvsp[0].id; }
    break;

  case 399:
#line 4703 "parser.y"
    { yyval.id = yyvsp[0].id; }
    break;

  case 400:
#line 4704 "parser.y"
    { yyval.id = 0; }
    break;

  case 401:
#line 4707 "parser.y"
    { 
                  yyval.str = 0;
		  if (!yyval.str) yyval.str = NewStringf("%s%s", yyvsp[-1].str,yyvsp[0].str);
      	          Delete(yyvsp[0].str);
               }
    break;

  case 402:
#line 4712 "parser.y"
    { 
		 yyval.str = NewStringf("::%s%s",yyvsp[-1].str,yyvsp[0].str);
                 Delete(yyvsp[0].str);
               }
    break;

  case 403:
#line 4716 "parser.y"
    {
		 yyval.str = NewString(yyvsp[0].str);
   	       }
    break;

  case 404:
#line 4719 "parser.y"
    {
		 yyval.str = NewStringf("::%s",yyvsp[0].str);
               }
    break;

  case 405:
#line 4722 "parser.y"
    {
                 yyval.str = NewString(yyvsp[0].str);
	       }
    break;

  case 406:
#line 4725 "parser.y"
    {
                 yyval.str = NewStringf("::%s",yyvsp[0].str);
               }
    break;

  case 407:
#line 4730 "parser.y"
    {
                   yyval.str = NewStringf("::%s%s",yyvsp[-1].str,yyvsp[0].str);
		   Delete(yyvsp[0].str);
               }
    break;

  case 408:
#line 4734 "parser.y"
    {
                   yyval.str = NewStringf("::%s",yyvsp[0].str);
               }
    break;

  case 409:
#line 4737 "parser.y"
    {
                   yyval.str = NewStringf("::%s",yyvsp[0].str);
               }
    break;

  case 410:
#line 4744 "parser.y"
    {
		 yyval.str = NewStringf("::~%s",yyvsp[0].str);
               }
    break;

  case 411:
#line 4750 "parser.y"
    {
                  yyval.str = NewStringf("%s%s",yyvsp[-1].id,yyvsp[0].id);
		  /*		  if (Len($2)) {
		    scanner_last_id(1);
		    } */
              }
    break;

  case 412:
#line 4759 "parser.y"
    { 
                  yyval.str = 0;
		  if (!yyval.str) yyval.str = NewStringf("%s%s", yyvsp[-1].id,yyvsp[0].str);
      	          Delete(yyvsp[0].str);
               }
    break;

  case 413:
#line 4764 "parser.y"
    { 
		 yyval.str = NewStringf("::%s%s",yyvsp[-1].id,yyvsp[0].str);
                 Delete(yyvsp[0].str);
               }
    break;

  case 414:
#line 4768 "parser.y"
    {
		 yyval.str = NewString(yyvsp[0].id);
   	       }
    break;

  case 415:
#line 4771 "parser.y"
    {
		 yyval.str = NewStringf("::%s",yyvsp[0].id);
               }
    break;

  case 416:
#line 4774 "parser.y"
    {
                 yyval.str = NewString(yyvsp[0].str);
	       }
    break;

  case 417:
#line 4777 "parser.y"
    {
                 yyval.str = NewStringf("::%s",yyvsp[0].str);
               }
    break;

  case 418:
#line 4782 "parser.y"
    {
                   yyval.str = NewStringf("::%s%s",yyvsp[-1].id,yyvsp[0].str);
		   Delete(yyvsp[0].str);
               }
    break;

  case 419:
#line 4786 "parser.y"
    {
                   yyval.str = NewStringf("::%s",yyvsp[0].id);
               }
    break;

  case 420:
#line 4789 "parser.y"
    {
                   yyval.str = NewStringf("::%s",yyvsp[0].str);
               }
    break;

  case 421:
#line 4792 "parser.y"
    {
		 yyval.str = NewStringf("::~%s",yyvsp[0].id);
               }
    break;

  case 422:
#line 4798 "parser.y"
    { 
                   yyval.id = (char *) malloc(strlen(yyvsp[-1].id)+strlen(yyvsp[0].id)+1);
                   strcpy(yyval.id,yyvsp[-1].id);
                   strcat(yyval.id,yyvsp[0].id);
               }
    break;

  case 423:
#line 4803 "parser.y"
    { yyval.id = yyvsp[0].id;}
    break;

  case 424:
#line 4806 "parser.y"
    {
		 yyval.str = NewString(yyvsp[0].id);
               }
    break;

  case 425:
#line 4809 "parser.y"
    {
                  skip_balanced('{','}');
		  yyval.str = NewString(scanner_ccode);
               }
    break;

  case 426:
#line 4813 "parser.y"
    {
		 yyval.str = yyvsp[0].str;
              }
    break;

  case 427:
#line 4818 "parser.y"
    {
                  Hash *n;
                  yyval.node = NewHash();
                  n = yyvsp[-1].node;
                  while(n) {
                     String *name, *value;
                     name = Getattr(n,"name");
                     value = Getattr(n,"value");
		     if (!value) value = (String *) "1";
                     Setattr(yyval.node,name, value);
		     n = nextSibling(n);
		  }
               }
    break;

  case 428:
#line 4831 "parser.y"
    { yyval.node = 0; }
    break;

  case 429:
#line 4835 "parser.y"
    {
		 yyval.node = NewHash();
		 Setattr(yyval.node,"name",yyvsp[-2].id);
		 Setattr(yyval.node,"value",yyvsp[0].id);
               }
    break;

  case 430:
#line 4840 "parser.y"
    {
		 yyval.node = NewHash();
		 Setattr(yyval.node,"name",yyvsp[-4].id);
		 Setattr(yyval.node,"value",yyvsp[-2].id);
		 set_nextSibling(yyval.node,yyvsp[0].node);
               }
    break;

  case 431:
#line 4846 "parser.y"
    {
                 yyval.node = NewHash();
                 Setattr(yyval.node,"name",yyvsp[0].id);
	       }
    break;

  case 432:
#line 4850 "parser.y"
    {
                 yyval.node = NewHash();
                 Setattr(yyval.node,"name",yyvsp[-2].id);
                 set_nextSibling(yyval.node,yyvsp[0].node);
               }
    break;

  case 433:
#line 4855 "parser.y"
    {
                 yyval.node = yyvsp[0].node;
		 Setattr(yyval.node,"name",yyvsp[-2].id);
               }
    break;

  case 434:
#line 4859 "parser.y"
    {
                 yyval.node = yyvsp[-2].node;
		 Setattr(yyval.node,"name",yyvsp[-4].id);
		 set_nextSibling(yyval.node,yyvsp[0].node);
               }
    break;

  case 435:
#line 4866 "parser.y"
    {
		 yyval.id = yyvsp[0].id;
               }
    break;

  case 436:
#line 4869 "parser.y"
    {
                 yyval.id = Char(yyvsp[0].dtype.val);
               }
    break;


    }

/* Line 991 of yacc.c.  */
#line 8463 "y.tab.c"

  yyvsp -= yylen;
  yyssp -= yylen;


  YY_STACK_PRINT (yyss, yyssp);

  *++yyvsp = yyval;


  /* Now `shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTOKENS] + *yyssp;
  if (0 <= yystate && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTOKENS];

  goto yynewstate;


/*------------------------------------.
| yyerrlab -- here on detecting error |
`------------------------------------*/
yyerrlab:
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
#if YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (YYPACT_NINF < yyn && yyn < YYLAST)
	{
	  YYSIZE_T yysize = 0;
	  int yytype = YYTRANSLATE (yychar);
	  char *yymsg;
	  int yyx, yycount;

	  yycount = 0;
	  /* Start YYX at -YYN if negative to avoid negative indexes in
	     YYCHECK.  */
	  for (yyx = yyn < 0 ? -yyn : 0;
	       yyx < (int) (sizeof (yytname) / sizeof (char *)); yyx++)
	    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
	      yysize += yystrlen (yytname[yyx]) + 15, yycount++;
	  yysize += yystrlen ("syntax error, unexpected ") + 1;
	  yysize += yystrlen (yytname[yytype]);
	  yymsg = (char *) YYSTACK_ALLOC (yysize);
	  if (yymsg != 0)
	    {
	      char *yyp = yystpcpy (yymsg, "syntax error, unexpected ");
	      yyp = yystpcpy (yyp, yytname[yytype]);

	      if (yycount < 5)
		{
		  yycount = 0;
		  for (yyx = yyn < 0 ? -yyn : 0;
		       yyx < (int) (sizeof (yytname) / sizeof (char *));
		       yyx++)
		    if (yycheck[yyx + yyn] == yyx && yyx != YYTERROR)
		      {
			const char *yyq = ! yycount ? ", expecting " : " or ";
			yyp = yystpcpy (yyp, yyq);
			yyp = yystpcpy (yyp, yytname[yyx]);
			yycount++;
		      }
		}
	      yyerror (yymsg);
	      YYSTACK_FREE (yymsg);
	    }
	  else
	    yyerror ("syntax error; also virtual memory exhausted");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror ("syntax error");
    }



  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
	 error, discard it.  */

      /* Return failure if at end of input.  */
      if (yychar == YYEOF)
        {
	  /* Pop the error token.  */
          YYPOPSTACK;
	  /* Pop the rest of the stack.  */
	  while (yyss < yyssp)
	    {
	      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
	      yydestruct (yystos[*yyssp], yyvsp);
	      YYPOPSTACK;
	    }
	  YYABORT;
        }

      YYDSYMPRINTF ("Error: discarding", yytoken, &yylval, &yylloc);
      yydestruct (yytoken, &yylval);
      yychar = YYEMPTY;

    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab2;


/*----------------------------------------------------.
| yyerrlab1 -- error raised explicitly by an action.  |
`----------------------------------------------------*/
yyerrlab1:

  /* Suppress GCC warning that yyerrlab1 is unused when no action
     invokes YYERROR.  */
#if defined (__GNUC_MINOR__) && 2093 <= (__GNUC__ * 1000 + __GNUC_MINOR__) \
    && !defined __cplusplus
  __attribute__ ((__unused__))
#endif


  goto yyerrlab2;


/*---------------------------------------------------------------.
| yyerrlab2 -- pop states until the error token can be shifted.  |
`---------------------------------------------------------------*/
yyerrlab2:
  yyerrstatus = 3;	/* Each real token shifted decrements this.  */

  for (;;)
    {
      yyn = yypact[yystate];
      if (yyn != YYPACT_NINF)
	{
	  yyn += YYTERROR;
	  if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYTERROR)
	    {
	      yyn = yytable[yyn];
	      if (0 < yyn)
		break;
	    }
	}

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
	YYABORT;

      YYDSYMPRINTF ("Error: popping", yystos[*yyssp], yyvsp, yylsp);
      yydestruct (yystos[yystate], yyvsp);
      yyvsp--;
      yystate = *--yyssp;

      YY_STACK_PRINT (yyss, yyssp);
    }

  if (yyn == YYFINAL)
    YYACCEPT;

  YYDPRINTF ((stderr, "Shifting error token, "));

  *++yyvsp = yylval;


  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturn;

/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturn;

#ifndef yyoverflow
/*----------------------------------------------.
| yyoverflowlab -- parser overflow comes here.  |
`----------------------------------------------*/
yyoverflowlab:
  yyerror ("parser stack overflow");
  yyresult = 2;
  /* Fall through.  */
#endif

yyreturn:
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif
  return yyresult;
}


#line 4876 "parser.y"


SwigType *Swig_cparse_type(String *s) {
   String *ns;
   ns = NewStringf("%s;",s);
   Seek(ns,0,SEEK_SET);
   scanner_file(ns);
   top = 0;
   scanner_next_token(PARSETYPE);
   yyparse();
   /*   Printf(stdout,"typeparse: '%s' ---> '%s'\n", s, top); */
   return top;
}


Parm *Swig_cparse_parm(String *s) {
   String *ns;
   ns = NewStringf("%s;",s);
   Seek(ns,0,SEEK_SET);
   scanner_file(ns);
   top = 0;
   scanner_next_token(PARSEPARM);
   yyparse();
   /*   Printf(stdout,"typeparse: '%s' ---> '%s'\n", s, top); */
   return top;
}










