# __init__.py for cruftremover
# Copyright (C) 2008  Canonical, Ltd.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, version 3 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


VERSION = "1.10.4"


# Set up gettext. This needs to be before the import statements below
# so that if any modules call it right after importing, they find
# setup_gettext.

def setup_gettext():
    """Set up gettext for a module.

    Return a method to be used for looking up translations. Usage:

      import cruftremover
      _ = cruftremover.setup_gettext()

    """

    import gettext
    import os

    domain = 'cruftremover'
    localedir = os.environ.get('LOCPATH', None)
    t = gettext.translation(domain, localedir=localedir, fallback=True)
    return t.ugettext


from cruft import Cruft
from package_cruft import PackageCruft
from exc import CruftRemoverException as Exception, UnimplementedMethod
from plugin import Plugin, PluginManager
from app import Application
from ui import UserInterface
from ui_cli import CommandLineUserInterface
from ui_gtk import GtkUserInterface
from state import State
from terminalsize import get_terminal_size


# The following is a kludge to silence python-apt's warning about
# the API being unstable.
import warnings
warnings.filterwarnings("ignore", "apt API not stable yet", FutureWarning)
import apt
