# app_tests.py - unit tests for app.py
# Copyright (C) 2008  Canonical, Ltd.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, version 3 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


import unittest

import cruftremover


class MockUI(object):

    def __init__(self, testcase, app, pm):
        self.testcase = testcase
        
    def run(self, options, args):
        self.testcase.ui_ran = True


class MockApt(object):

    def __init__(self):
        self._depcache = self
        
    def ReadPinFile(self, filename):
        pass

    def Cache(self):
        return self


class ApplicationTests(unittest.TestCase):

    def setUp(self):
        self.app = cruftremover.Application(apt=MockApt())
        
    def testSetsUpAndReturnsState(self):
        self.assert_(self.app.state)

    def testSetsUpAptCacheWhenRequested(self):
        self.assertNotEqual(self.app.apt_cache, None)

    def testSetsOptionDefaultsCorrectly(self):
        options, args = self.app.parse_options(args=[])
        self.assertEqual(args, [])
        self.assertEqual(options.all, None)
        self.assertEqual(options.state_file, 
                         "/var/lib/cruft-remover/state.dat")
        self.assertEqual(options.no_act, None)

    def testAcceptsDashDashAllOption(self):
        options, args = self.app.parse_options(args=["--all"])
        self.assertEqual(options.all, True)

    def testAcceptsDashDashStateFileOption(self):
        options, args = self.app.parse_options(args=["--state-file=foo"])
        self.assertEqual(options.state_file, "foo")

    def testAcceptsDashDashNoActOption(self):
        options, args = self.app.parse_options(args=["--no-act"])
        self.assertEqual(options.no_act, True)

    def testRunsUserInterface(self):

        def pm_class(app, plugin_dirs):
            self.pm_ran = True

        def ui_class(app, pm):
            return MockUI(self, app, pm)

        self.pm_ran = False
        self.ui_ran = False
        self.app.run(ui_class=ui_class, plugin_manager_class=pm_class)
        self.assert_(self.ui_ran)
