# unsupported_plugin.py - remove packages no longer supported by Canonical
# Copyright (C) 2008  Canonical, Ltd.
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, version 3 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.


import os

import cruftremover
_ = cruftremover.setup_gettext()


class UnsupportedPackagesPlugin(cruftremover.Plugin):

    """cruft-remover plugin to find packages no longer supported by Canonical.
    
    An unsupported package is one that is no longer available in the
    archive.
    
    Unfortunately, this heuristic is unable to treat packages installed
    manually (via dpkg), or from sources (such as PPAs) that are no longer
    in sources.list.

    """
    
    description = _("Package is no longer supported: it is no longer in the "
                    "package archive. (It may also have been installed from "
                    "an unofficial archive that is no longer available. In "
                    "that case you may want to keep it.)")

    def is_supported(self, pkg):
    	"""Is a package supported?"""

        # FIXME: we do not have a way right now to tell if a package
        #        got manually installed or comes from a source (e.g. a PPA)
        #        that was once part of the system and later got disabled

    	if not pkg.isInstalled:
    	    return True
        if pkg.installedDownloadable or pkg.candidateDownloadable:
            return True
        if len(pkg._pkg.VersionList) > 1:
            # if there is just a single version and that is not
            # downloadable anymore, then its cruft this avoids cases
            # where the user has e.g. a newer version installed from a
            # ppa that is no longer downloadable, but the main archive
            # has the version still
            return True
        return False

    def get_cruft(self):
        for pkg in self.app.apt_cache:
            if not self.is_supported(pkg):
                yield cruftremover.PackageCruft(pkg, self.description)
