#include <tagcoll/experiments.h>
#include <tagcoll/Serializer.h>
#include <tagcoll/TextFormat.h>
#include <tagcoll/StdioParserInput.h>

#include <iostream>

using namespace std;
using namespace tagcoll;

int main (int argc, char *argv[])
{
	try {
		// Install the handler for unexpected exceptions
		wibble::exception::InstallUnexpected installUnexpected;
		Graph<string, string> graph;
		StdioParserInput in(stdin, "(stdin)");

		textformat::parse(in, consumer(graph));

		graph.buildGraphs("graph-dist1", 1);

		//TextFormat<string, string> writer(conv, conv, stdout);
		//graph.output(writer);

		return 0;
	} catch (std::exception& e) {
		cerr << e.what() << endl;
		return 1;
	}
}

// vim:set ts=4 sw=4:
