/*
 * QtTelepathy, the Tapioca Qt4 Telepathy Client Library
 * Copyright (C) 2006 by Tobias Hunger <tobias.hunger@basyskom.de>
 * Copyright (C) 2006 by INdT
 *  @author Andre Moreira Magalhaes <andre.magalhaes@indt.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef QTTELEPATHY_CHANNELTYPETEXT_H
#define QTTELEPATHY_CHANNELTYPETEXT_H

#include <QtCore/QList>
#include <QtCore/QString>
#include <QtDBus/QDBusArgument>
#include <QtTelepathy/Common/BaseTypes>

namespace org {
namespace freedesktop {
namespace Telepathy {

enum TextMessageType {
    CHANNEL_TEXT_MESSAGE_TYPE_NORMAL     = 0,
    CHANNEL_TEXT_MESSAGE_TYPE_ACTION     = 1,
    CHANNEL_TEXT_MESSAGE_TYPE_NOTICE     = 2,
    CHANNEL_TEXT_MESSAGE_TYPE_AUTO_REPLY = 3
};
typedef QList<uint> TextMessageTypeList;

enum TextMessageFlag {
    CHANNEL_TEXT_MESSAGE_FLAG_NONE      = 0x00000000,
    CHANNEL_TEXT_MESSAGE_FLAG_TRUNCATED = 0x00000001,
    CHANNEL_TEXT_MESSAGE_FLAG_ALL       = 0xFFFFFFFF
};
Q_DECLARE_FLAGS(TextMessageFlags, TextMessageFlag)

class TextMessageInfo
{
public:
    uint id;
    quint32 timestamp;
    uint contactHandle;
    uint type;
    uint flags;
    QString message;
};
typedef QList<TextMessageInfo> TextMessageInfoList;

} // namespace Telepathy
} // namespace freedesktop
} // namespace org

Q_DECLARE_METATYPE(org::freedesktop::Telepathy::TextMessageInfo)
Q_DECLARE_METATYPE(org::freedesktop::Telepathy::TextMessageInfoList)

Q_DECLARE_OPERATORS_FOR_FLAGS(org::freedesktop::Telepathy::TextMessageFlags)

const QDBusArgument &operator>>(const QDBusArgument &argument, org::freedesktop::Telepathy::TextMessageInfo &info);
QDBusArgument &operator<<(QDBusArgument &argument, const org::freedesktop::Telepathy::TextMessageInfo &info);

#endif

