/* -*- Mode: javascript; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*-
/* ***** BEGIN LICENSE BLOCK *****
 *	 Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 * 
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is edsintegration.
 *
 * The Initial Developer of the Original Code is
 * Mozilla Corp.
 * Portions created by the Initial Developer are Copyright (C) 2011
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 * Mike Conley <mconley@mozilla.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 * 
 * ***** END LICENSE BLOCK ***** */

var EXPORTED_SYMBOLS = [ "LibGLib" ];

const Cu = Components.utils;
const Cc = Components.classes;
const Ci = Components.interfaces;

Cu.import("resource://gre/modules/ctypes.jsm");
Cu.import("resource://gre/modules/Services.jsm");
Cu.import("resource://gre/modules/XPCOMUtils.jsm");
Cu.import("resource://edsintegration/libgobject-ctypes.jsm");

XPCOMUtils.defineLazyGetter(this, "GSList", function() {
  var gslist = ctypes.StructType("GSList");
  gslist.define([{data: gpointer}, {next: gslist.ptr}]);
  return gslist;
});

XPCOMUtils.defineLazyGetter(this, "GList", function() {
  var glist = ctypes.StructType("GList");
  glist.define([{data: gpointer}, {next: glist.ptr}, {prev: glist.ptr}]);
  return glist;
});

XPCOMUtils.defineLazyGetter(this, "gboolean", function() {
  return ctypes.int;
});

XPCOMUtils.defineLazyGetter(this, "gchar", function() {
  return ctypes.char;
});

XPCOMUtils.defineLazyGetter(this, "guchar", function() {
  return ctypes.unsigned_char;
});

XPCOMUtils.defineLazyGetter(this, "gint", function() {
  return ctypes.int;
});

XPCOMUtils.defineLazyGetter(this, "glong", function() {
  return ctypes.long;
});

XPCOMUtils.defineLazyGetter(this, "guint", function() {
  return ctypes.unsigned_int;
});

XPCOMUtils.defineLazyGetter(this, "gpointer", function() {
  return ctypes.voidptr_t;
});

XPCOMUtils.defineLazyGetter(this, "gsize", function() {
  return ctypes.unsigned_long;
});

XPCOMUtils.defineLazyGetter(this, "gconstpointer", function() {
  // Points to data that should not be changed.  We can't really
  // do that with JS-Ctypes, but if we keep the name, hopefully we
  // won't do anything dumb.
  return ctypes.voidptr_t;
});

XPCOMUtils.defineLazyGetter(this, "gulong", function() {
  return ctypes.unsigned_long;
});

XPCOMUtils.defineLazyGetter(this, "GCallback", function() {
  var GCallback = ctypes.FunctionType(ctypes.default_abi,
                             ctypes.void_t,
                             [gpointer, gpointer, gpointer]);

  if (!GCallback)
    throw "GCallback is unavailable";
  return GCallback.ptr;
});

XPCOMUtils.defineLazyGetter(this, "GBooleanCallback", function() {
  var GBooleanCallback = ctypes.FunctionType(ctypes.default_abi,
                             gboolean,
                             [gpointer, gpointer, gpointer]);
  if (!GBooleanCallback)
    throw "GBooleanCallback is unavailable";
  return GBooleanCallback.ptr;
});


XPCOMUtils.defineLazyGetter(this, "GClosureNotify", function() {
  return ctypes.voidptr_t;
});

XPCOMUtils.defineLazyGetter(this, "GConnectFlags", function() {
  return ctypes.unsigned_int;
});

XPCOMUtils.defineLazyGetter(this, "GError", function() {
  return ctypes.StructType("GError", [ {domain: GQuark}, {code: gint}, {message: gchar.ptr} ]);
});

XPCOMUtils.defineLazyGetter(this, "GObject", function() {
  return ctypes.StructType("GObject");
});

XPCOMUtils.defineLazyGetter(this, "GQuark", function() {
  return ctypes.uint32_t;
});

XPCOMUtils.defineLazyGetter(this, "GType", function() {
  return gsize;
});

XPCOMUtils.defineLazyGetter(this, "FALSE", function() {
  return 0;
});

XPCOMUtils.defineLazyGetter(this, "TRUE", function() {
  return 1;
});


XPCOMUtils.defineLazyGetter(this, "g_boxed_free", function() {
  var g_boxed_free =
    libgobject.declare("g_boxed_free",
                       ctypes.default_abi,
                       ctypes.void_t,
                       GType,
                       gpointer);
  if (!g_boxed_free)
    throw "g_boxed_free is unavailable";

  return g_boxed_free;
});


XPCOMUtils.defineLazyGetter(this, "g_error_copy", function() {
  var g_error_copy =
    libgobject.declare("g_error_copy",
                       ctypes.default_abi,
                       GError.ptr,
                       GError.ptr);
  if (!g_error_copy)
    throw "g_error_copy is unavailable";

  return g_error_copy;
});


XPCOMUtils.defineLazyGetter(this, "g_error_free", function() {
  var g_error_free =
    libgobject.declare("g_error_free",
                       ctypes.default_abi,
                       ctypes.void_t,
                       GError.ptr);
  if (!g_error_free)
    throw "g_error_free is unavailable";

  return g_error_free;
});


XPCOMUtils.defineLazyGetter(this, "g_error_matches", function() {
  var g_error_matches =
    libgobject.declare("g_error_matches",
                       ctypes.default_abi,
                       gboolean,
                       GError.ptr,
                       GQuark,
                       gint);

  if (!g_error_matches)
    throw "g_error_matches is unavailable";

  return g_error_matches;
});


XPCOMUtils.defineLazyGetter(this, "g_object_ref", function() {
  var g_object_ref =
    libgobject.declare("g_object_ref",
                       ctypes.default_abi,
                       gpointer,
                       gpointer);
  if (!g_object_ref)
    throw "g_object_ref is unavailable";

  return g_object_ref;
});

XPCOMUtils.defineLazyGetter(this, "g_object_unref", function() {
  var g_object_unref =
    libgobject.declare("g_object_unref",
                       ctypes.default_abi,
                       ctypes.void_t,
                       ctypes.void_t.ptr);
  if (!g_object_unref)
    throw "g_object_unref is unavailable";

  return g_object_unref;
});

XPCOMUtils.defineLazyGetter(this, "g_list_append", function() {
  var g_list_append =
    libgobject.declare("g_list_append",
                       ctypes.default_abi,
                       GList.ptr,
                       GList.ptr,
                       gpointer);
  if (!g_list_append)
    throw "g_list_append is unavailable";

  return g_list_append;
});

XPCOMUtils.defineLazyGetter(this, "g_list_concat", function() {
  var g_list_concat =
    libgobject.declare("g_list_concat",
                       ctypes.default_abi,
                       GList.ptr,
                       GList.ptr,
                       GList.ptr);
  if (!g_list_concat)
    throw "g_list_concat is unavailable";

  return g_list_concat;
});

XPCOMUtils.defineLazyGetter(this, "g_list_delete_link", function() {
  var g_list_delete_link =
    libgobject.declare("g_list_delete_link",
                       ctypes.default_abi,
                       GList.ptr,
                       GList.ptr,
                       GList.ptr);
  if (!g_list_delete_link)
    throw "g_list_delete_link is unavailable";

  return g_list_delete_link;
});


XPCOMUtils.defineLazyGetter(this, "g_list_free", function() {
  var g_list_free =
    libgobject.declare("g_list_free",
                       ctypes.default_abi,
                       ctypes.void_t,
                       GList.ptr);
  if (!g_list_free)
    throw "g_list_free is unavailable";

  return g_list_free;
});


XPCOMUtils.defineLazyGetter(this, "g_list_length", function() {
  var g_list_length =
    libgobject.declare("g_list_length",
                       ctypes.default_abi,
                       ctypes.void_t,
                       GList.ptr);
  if (!g_list_length)
    throw "g_list_length is unavailable";

  return g_list_length;
});


XPCOMUtils.defineLazyGetter(this, "g_free", function() {
  var g_free =
    libgobject.declare("g_free",
                       ctypes.default_abi,
                       ctypes.void_t,
                       ctypes.void_t.ptr);
  if (!g_free)
    throw "g_free is unavailable";

  return g_free;
});

XPCOMUtils.defineLazyGetter(this, "g_signal_connect_data", function() {
  var g_signal_connect_data =
    libgobject.declare("g_signal_connect_data",
                       ctypes.default_abi,
                       gulong,
                       gpointer,
                       gchar.ptr,
                       ctypes.void_t.ptr,
                       gpointer,
                       GClosureNotify,
                       GConnectFlags);
  if (!g_signal_connect_data)
    throw "g_signal_connect_data is unavailable";

  return g_signal_connect_data;
});

XPCOMUtils.defineLazyGetter(this, "g_signal_handler_disconnect", function() {
  var g_signal_handler_disconnect =
    libgobject.declare("g_signal_handler_disconnect",
                       ctypes.default_abi,
                       ctypes.void_t,
                       gpointer,
                       gulong);

  if (!g_signal_handler_disconnect)
    throw "g_signal_handler_disconnect is unavailable";

  return g_signal_handler_disconnect;
});


var LibGLib = {
  TRUE: TRUE,
  FALSE: FALSE,
  GBooleanCallback: GBooleanCallback,
  GCallback: GCallback,
  GClosureNotify: GClosureNotify,
  GConnectFlags: GConnectFlags,
  GError: GError,
  GList: GList,
  GObject: GObject,
  GQuark: GQuark,
  GType: GType,
  GSList: GSList,
  gboolean: gboolean,
  gchar: gchar,
  gconstpointer: gconstpointer,
  gint: gint,
  gpointer: gpointer,
  gsize: gsize,
  guchar: guchar,
  gulong: gulong,
  guint: guint, 

  g_boxed_free: function LGL_g_boxed_free(aGType, aPtr) {
    return g_boxed_free(aGType, aPtr);
  },

  g_error_copy: function LGL_g_error_copy(aErrPtr) {
    return g_error_copy(aErrPtr);
  },

  g_error_free: function LGL_g_error_free(aErrPtr) {
    return g_error_free(aErrPtr);
  },

  g_error_matches: function LGL_g_error_matches(aErrPtr, aGQuark,
                                                aCode) {
    return g_error_matches(aErrPtr, aGQuark, aCode) == LibGLib.TRUE;
  },

  g_object_ref: function LGL_g_object_ref(aPointer) {
    if (aPointer.isNull())
      throw("Attempted to add reference to null pointer.");
    return g_object_ref(aPointer);
  },

  g_object_unref: function LGL_g_object_unref(aPointer) {
    if (aPointer.isNull())
      throw("Attempted to dereference a null pointer.");
    g_object_unref(aPointer);
  },

  g_signal_connect: function LBL_g_signal_connect(instance,
                                                  detailed_signal,
                                                  handler,
                                                  data)
  {
    return g_signal_connect_data(instance, detailed_signal,
                                 handler, data, null, 0);
  },

  g_signal_handler_disconnect: function(aInstance, aSignalId) {
    return g_signal_handler_disconnect(aInstance, aSignalId);
  },

  g_list_append: function LBL_g_list_append(aGListPtr, aData) {
    return g_list_append(aGListPtr, aData);
  },

  g_list_concat: function LBL_g_list_concat(aGListPtr, aGListPtr2) {
    return g_list_concat(aGListPtr, aGListPtr2);
  },

  g_list_delete_link: function LBL_g_list_delete_link(aGListPtr, aGListPtr2) {
    return g_list_delete_link(aGListPtr, aGListPtr2);
  },


  g_list_free: function LBL_g_list_free(aGListPtr) {
    g_list_free(aGListPtr);
  },

  g_list_length: function LBL_g_list_length(aGListPtr) {
    return g_list_length(aGListPtr);
  },

  g_free: function LBL_g_free(aPtr) {
    g_free(aPtr);
  },

  g_int_to_pointer: function LBL_g_int_to_pointer(aInt) {
      aInt = gint(aInt);
      let aLong = ctypes.cast(aInt, glong);
      let aPointer = ctypes.cast(aLong, gpointer);
      return aPointer;
   },
}
