#!/usr/bin/perl -w

package KeyboardNames;

%models = (
    'A4Tech KB-21' => 'a4techKB21',
    'A4Tech KBS-8' => 'a4techKBS8',
    'ACPI Standard' => 'acpi',
    'Acer AirKey V' => 'airkey',
    'Acer TravelMate 800' => 'acer_tm_800',
    'Advance Scorpius KI' => 'scorpius',
    'Amiga' => 'amiga',
    'Atari TT' => 'ataritt',
    'Azona RF2300 wireless Internet Keyboard' => 'azonaRF2300',
    'BTC 5090' => 'btc5090',
    'BTC 5113RF Multimedia' => 'btc5113rf',
    'BTC 5126T' => 'btc5126t',
    'BTC 9000' => 'btc9000',
    'BTC 9000A' => 'btc9000a',
    'BTC 9001AH' => 'btc9001ah',
    'Brazilian ABNT2' => 'abnt2',
    'Brother Internet Keyboard' => 'brother',
    'Cherry Blue Line CyBo@rd' => 'cherryblue',
    'Cherry Blue Line CyBo@rd (alternate option)' => 'cherrybluea',
    'Cherry CyBo@rd USB-Hub' => 'cherrycyboard',
    'Cherry CyMotion Master Linux' => 'cymotionlinux',
    'Cherry CyMotion Master XPress' => 'cherryblueb',
    'Chicony Internet Keyboard' => 'chicony',
    'Chicony KB-9885' => 'chicony9885',
    'Compaq Easy Access Keyboard' => 'compaqeak8',
    'Compaq Internet Keyboard (13 keys)' => 'compaqik13',
    'Compaq Internet Keyboard (18 keys)' => 'compaqik18',
    'Compaq Internet Keyboard (7 keys)' => 'compaqik7',
    'Compaq iPaq Keyboard' => 'ipaq',
    'DTK2000' => 'dtk2000',
    'Dell' => 'dell',
    'Dell 101-key PC' => 'dell101',
    'Dell USB Multimedia Keybard' => 'dellusbmm',
    'Dexxa Wireless Desktop Keyboard' => 'dexxa',
    'Diamond 9801 / 9802 series' => 'diamond',
    'Ennyah DKB-1008' => 'ennyah_dkb1008',
    'Everex STEPnote' => 'everex',
    'Generic 101-key PC' => 'pc101',
    'Generic 102-key (Intl) PC' => 'pc102',
    'Generic 104-key PC' => 'pc104',
    'Generic 105-key (Intl) PC' => 'pc105',
    'Genius Comfy KB-12e' => 'geniuscomfy',
    'Genius Comfy KB-16M / Genius MM Keyboard KWD-910' => 'genius',
    'Genius Comfy KB-21e-Scroll' => 'geniuscomfy2',
    'Gyration' => 'gyration',
    'Hewlett-Packard Internet Keyboard' => 'hpi6',
    'Hewlett-Packard Omnibook 500 FA' => 'hp500fa',
    'Hewlett-Packard Omnibook 5xx' => 'hp5xx',
    'Hewlett-Packard Omnibook 6000/6100' => 'hp6000',
    'Hewlett-Packard Omnibook XE3 GC' => 'hpxe3gc',
    'Hewlett-Packard Omnibook XE3 GF' => 'hpxe3gf',
    'Hewlett-Packard Omnibook XT1000' => 'hpxt1000',
    'Hewlett-Packard Pavilion ZT11xx' => 'hpzt11xx',
    'Hewlett-Packard SK-2501 Multimedia Keyboard' => 'hp2501',
    'Hewlett-Packard SK-2505 Internet Keyboard' => 'hp2505',
    'Honeywell Euroboard' => 'honeywell_euroboard',
    'IBM Rapid Access' => 'rapidaccess',
    'IBM Rapid Access II' => 'rapidaccess2',
    'IBM Rapid Access II (alternate option)' => 'rapidaccess2a',
    'IBM ThinkPad 560Z/600/600E/A22E' => 'thinkpad',
    'Japanese 106-key' => 'jp106',
    'Keytronic FlexPro' => 'flexpro',
    'Laptop/notebook Compaq (eg. Armada) Laptop Keyboard' => 'armada',
    'Laptop/notebook Compaq (eg. Presario) Internet Keyboard' => 'presario',
    'Laptop/notebook Dell Inspiron 6xxx/8xxx' => 'inspiron',
    'Laptop/notebook eMachines m68xx' => 'emachines',
    'Logitech Access Keyboard' => 'logiaccess',
    'Logitech Cordless Desktop' => 'ltcd',
    'Logitech Cordless Desktop Navigator' => 'logicdn',
    'Logitech Cordless Desktop Optical' => 'logicdo',
    'Logitech Cordless Desktop Pro' => 'logicdp',
    'Logitech Cordless Desktop Pro (alternate option)' => 'logicdpa',
    'Logitech Cordless Desktop Pro (alternate option2)' => 'logicdpa2',
    'Logitech Cordless Desktop iTouch' => 'logicdit',
    'Logitech Cordless Freedom/Desktop Navigator' => 'logicfn',
    'Logitech Deluxe Access Keyboard' => 'logidak',
    'Logitech Internet Keyboard' => 'logiik',
    'Logitech Internet Navigator Keyboard' => 'logiink',
    'Logitech Ultra-X Keyboard' => 'logiultrax',
    'Logitech iTouch' => 'itouch',
    'Logitech iTouch Cordless Keyboard (model Y-RB6)' => 'logiitc',
    'Logitech iTouch keyboard Internet Navigator' => 'itouchin',
    'Macintosh' => 'macintosh',
    'Macintosh Old' => 'macintosh_old',
    'Memorex MX1998' => 'mx1998',
    'Memorex MX2500 EZ-Access Keyboard' => 'mx2500',
    'Memorex MX2750' => 'mx2750',
    'Microsoft Internet Keyboard' => 'microsoftinet',
    'Microsoft Internet Keyboard Pro, Swedish' => 'microsoftprose',
    'Microsoft Natural' => 'microsoft',
    'Microsoft Natural Keyboard Pro / Microsoft Internet Keyboard Pro' => 'microsoftpro',
    'Microsoft Natural Keyboard Pro OEM' => 'microsoftprooem',
    'Microsoft Natural Keyboard Pro USB / Microsoft Internet Keyboard Pro' => 'microsoftprousb',
    'Microsoft Office Keyboard' => 'microsoftoffice',
    'Microsoft Wireless Multimedia Keyboard 1.0A' => 'microsoftmult',
    'Northgate OmniKey 101' => 'omnikey101',
    'Oretec MCK-800 MM/Internet keyboard' => 'oretec',
    'PC-98xx Series' => 'pc98',
    'Power G5' => 'power_g5',
    'PowerPC PS/2' => 'powerpcps2',
    'Propeller Voyager (KTEZ-1000)' => 'propeller',
    'QTronix Scorpius 98N+' => 'qtronix',
    'SILVERCREST Multimedia Wireless Keyboard' => 'silvercrest',
    'SK-1300' => 'sk1300',
    'SK-2500' => 'sk2500',
    'SK-6200' => 'sk6200',
    'SK-7100' => 'sk7100',
    'SVEN Ergonomic 2500' => 'sven',
    'Samsung SDM 4500P' => 'samsung4500',
    'Samsung SDM 4510P' => 'samsung4510',
    'Sun Type 4' => 'sun4',
    'Sun Type 5' => 'sun5',
    'Super Power Multimedia Keyboard' => 'sp_inet',
    'Symplon PaceBook (tablet PC)' => 'symplon',
    'Toshiba Satellite S3000' => 'toshiba_s3000',
    'Trust Direct Access Keyboard' => 'trustda',
    'Trust Wireless Keyboard Classic' => 'trust',
    'Winbook Model XP5' => 'winbook',
    'Yahoo! Internet Keyboard' => 'yahoo',
);

%layouts = (
    'Afghanistan' => 'af',
    'Albania' => 'al',
    'Andorra' => 'ad',
    'Arabic' => 'ara',
    'Armenia' => 'am',
    'Azerbaijan' => 'az',
    'Bangladesh' => 'bd',
    'Belarus' => 'by',
    'Belgium' => 'be',
    'Bhutan' => 'bt',
    'Bosnia and Herzegovina' => 'ba',
    'Brazil' => 'br',
    'Bulgaria' => 'bg',
    'Cambodia' => 'kh',
    'Canada' => 'ca',
    'Croatia' => 'hr',
    'Czechia' => 'cz',
    'Denmark' => 'dk',
    'Esperanto' => 'epo',
    'Estonia' => 'ee',
    'Faroe Islands' => 'fo',
    'Finland' => 'fi',
    'France' => 'fr',
    'Georgia' => 'ge',
    'Germany' => 'de',
    'Ghana' => 'gh',
    'Greece' => 'gr',
    'Hungary' => 'hu',
    'Iceland' => 'is',
    'India' => 'in',
    'Iran' => 'ir',
    'Ireland' => 'ie',
    'Israel' => 'il',
    'Italy' => 'it',
    'Japan' => 'jp',
    'Kazakhstan' => 'kz',
    'Kyrgyzstan' => 'kg',
    'Laos' => 'la',
    'Latin American' => 'latam',
    'Latvia' => 'lv',
    'Lithuania' => 'lt',
    'Macedonia' => 'mk',
    'Maldives' => 'mv',
    'Malta' => 'mt',
    'Maori' => 'mao',
    'Mongolia' => 'mn',
    'Myanmar' => 'mm',
    'Netherlands' => 'nl',
    'Norway' => 'no',
    'PC-98xx Series' => 'nec_vndr/jp',
    'Pakistan' => 'pk',
    'Poland' => 'pl',
    'Portugal' => 'pt',
    'Romania' => 'ro',
    'Russia' => 'ru',
    'Serbia and Montenegro' => 'cs',
    'Slovakia' => 'sk',
    'Slovenia' => 'si',
    'South Africa' => 'za',
    'Spain' => 'es',
    'Sri Lanka' => 'lk',
    'Sweden' => 'se',
    'Switzerland' => 'ch',
    'Syria' => 'sy',
    'Tajikistan' => 'tj',
    'Thailand' => 'th',
    'Turkey' => 'tr',
    'U.S. English' => 'us',
    'Ukraine' => 'ua',
    'United Kingdom' => 'gb',
    'Uzbekistan' => 'uz',
    'Vietnam' => 'vn',
);

%variants = (
    'af' => {
	'Pashto' => 'ps',
	'Southern Uzbek' => 'uz',
    },
    'am' => {
	'Phonetic' => 'phonetic',
    },
    'ara' => {
	'azerty' => 'azerty',
	'azerty/digits' => 'azerty_digits',
	'digits' => 'digits',
	'qwerty' => 'qwerty',
	'qwerty/digits' => 'qwerty_digits',
    },
    'az' => {
	'Cyrillic' => 'cyrillic',
    },
    'ba' => {
	'US keyboard with Bosnian digraphs' => 'unicodeus',
	'US keyboard with Bosnian letters' => 'us',
	'Use Bosnian digraphs' => 'unicode',
	'Use guillemots for quotes' => 'alternatequotes',
    },
    'bd' => {
	'Probhat' => 'probhat',
    },
    'be' => {
	'Eliminate dead keys' => 'nodeadkeys',
	'ISO Alternate' => 'iso-alternate',
	'Sun dead keys' => 'sundeadkeys',
    },
    'bg' => {
	'Phonetic' => 'phonetic',
    },
    'br' => {
	'Eliminate dead keys' => 'nodeadkeys',
    },
    'by' => {
	'Latin' => 'latin',
	'Winkeys' => 'winkeys',
    },
    'ca' => {
	'French (legacy)' => 'fr-legacy',
	'French Dvorak' => 'fr-dvorak',
	'Inuktitut' => 'ike',
	'Multilingual' => 'multix',
	'Multilingual, first part' => 'multi',
	'Multilingual, second part' => 'multi-2gr',
    },
    'ch' => {
	'French' => 'fr',
	'French, Sun dead keys' => 'fr_sundeadkeys',
	'French, eliminate dead keys' => 'fr_nodeadkeys',
	'German, Sun dead keys' => 'de_sundeadkeys',
	'German, eliminate dead keys' => 'de_nodeadkeys',
    },
    'cs' => {
	'Latin' => 'latin',
	'Latin Unicode' => 'latinunicode',
	'Latin Unicode qwerty' => 'latinunicodeyz',
	'Latin qwerty' => 'latinyz',
	'Latin with guillemots' => 'latinalternatequotes',
	'With guillemots' => 'alternatequotes',
	'Z and ZHE swapped' => 'yz',
    },
    'cz' => {
	'With <\|> key' => 'bksl',
	'qwerty' => 'qwerty',
	'qwerty, extended Backslash' => 'qwerty_bksl',
    },
    'de' => {
	'Dead acute' => 'deadacute',
	'Dead grave acute' => 'deadgraveacute',
	'Dvorak' => 'dvorak',
	'Eliminate dead keys' => 'nodeadkeys',
	'Romanian keyboard with German letters' => 'ro',
	'Romanian keyboard with German letters, eliminate dead keys' => 'ro_nodeadkeys',
	'Sun dead keys' => 'sundeadkeys',
    },
    'dk' => {
	'Eliminate dead keys' => 'nodeadkeys',
    },
    'ee' => {
	'Dvorak' => 'dvorak',
	'Eliminate dead keys' => 'nodeadkeys',
    },
    'es' => {
	'Catalan variant with middle-dot L' => 'cat',
	'Dvorak' => 'dvorak',
	'Eliminate dead keys' => 'nodeadkeys',
	'Sun dead keys' => 'sundeadkeys',
    },
    'fi' => {
	'Eliminate dead keys' => 'nodeadkeys',
	'Northern Saami' => 'smi',
    },
    'fo' => {
	'Eliminate dead keys' => 'nodeadkeys',
    },
    'fr' => {
	'Alternative' => 'latin9',
	'Alternative, Sun dead keys' => 'latin9_sundeadkeys',
	'Alternative, eliminate dead keys' => 'latin9_nodeadkeys',
	'Dvorak' => 'dvorak',
	'Eliminate dead keys' => 'nodeadkeys',
	'Sun dead keys' => 'sundeadkeys',
    },
    'gb' => {
	'Dvorak' => 'dvorak',
	'International (with dead keys)' => 'intl',
    },
    'ge' => {
	'Russian' => 'ru',
    },
    'gh' => {
	'Akan' => 'akan',
	'Ewe' => 'ewe',
	'Fula' => 'fula',
	'Ga' => 'ga',
	'Hausa' => 'hausa',
	'Multilingual' => 'generic',
    },
    'gr' => {
	'Eliminate dead keys' => 'nodeadkeys',
	'Extended' => 'extended',
	'Polytonic' => 'polytonic',
    },
    'hr' => {
	'US keyboard with Croatian digraphs' => 'unicodeus',
	'US keyboard with Croatian letters' => 'us',
	'Use Croatian digraphs' => 'unicode',
	'Use guillemots for quotes' => 'alternatequotes',
    },
    'hu' => {
	'101/qwerty/comma/Dead keys' => '101_qwerty_comma_dead',
	'101/qwerty/comma/Eliminate dead keys' => '101_qwerty_comma_nodead',
	'101/qwerty/dot/Dead keys' => '101_qwerty_dot_dead',
	'101/qwerty/dot/Eliminate dead keys' => '101_qwerty_dot_nodead',
	'101/qwertz/comma/Dead keys' => '101_qwertz_comma_dead',
	'101/qwertz/comma/Eliminate dead keys' => '101_qwertz_comma_nodead',
	'101/qwertz/dot/Dead keys' => '101_qwertz_dot_dead',
	'101/qwertz/dot/Eliminate dead keys' => '101_qwertz_dot_nodead',
	'102/qwerty/comma/Dead keys' => '102_qwerty_comma_dead',
	'102/qwerty/comma/Eliminate dead keys' => '102_qwerty_comma_nodead',
	'102/qwerty/dot/Dead keys' => '102_qwerty_dot_dead',
	'102/qwerty/dot/Eliminate dead keys' => '102_qwerty_dot_nodead',
	'102/qwertz/comma/Dead keys' => '102_qwertz_comma_dead',
	'102/qwertz/comma/Eliminate dead keys' => '102_qwertz_comma_nodead',
	'102/qwertz/dot/Dead keys' => '102_qwertz_dot_dead',
	'102/qwertz/dot/Eliminate dead keys' => '102_qwertz_dot_nodead',
	'Eliminate dead keys' => 'nodeadkeys',
	'Standard' => 'standard',
	'qwerty' => 'qwerty',
    },
    'ie' => {
	'CloGaelach' => 'CloGaelach',
	'Ogham' => 'ogam',
	'Ogham IS434' => 'ogam_is434',
	'UnicodeExpert' => 'UnicodeExpert',
    },
    'il' => {
	'Phonetic' => 'phonetic',
	'lyx' => 'lyx',
	'si1452' => 'si1452',
    },
    'in' => {
	'Bengali' => 'ben',
	'Bengali Probhat' => 'ben_probhat',
	'Gujarati' => 'guj',
	'Gurmukhi' => 'guru',
	'Kannada' => 'kan',
	'Malayalam' => 'mal',
	'Oriya' => 'ori',
	'Tamil' => 'tam',
	'Tamil TAB Typewriter' => 'tam_TAB',
	'Tamil TSCII Typewriter' => 'tam_TSCII',
	'Tamil Unicode' => 'tam_unicode',
	'Telugu' => 'tel',
	'Urdu' => 'urd',
    },
    'ir' => {
	'Keypad' => 'keypad',
	'Pro' => 'pro',
	'Pro Keypad' => 'pro_keypad',
    },
    'is' => {
	'Eliminate dead keys' => 'nodeadkeys',
	'Sun dead keys' => 'Sundeadkeys',
    },
    'it' => {
	'Eliminate dead keys' => 'nodeadkeys',
    },
    'kz' => {
	'Kazakh with Russian' => 'kazrus',
	'Russian with Kazakh' => 'ruskaz',
    },
    'latam' => {
	'Eliminate dead keys' => 'nodeadkeys',
	'Sun dead keys' => 'sundeadkeys',
    },
    'lk' => {
	'Tamil TAB Typewriter' => 'tam_TAB',
	'Tamil Unicode' => 'tam_unicode',
    },
    'lt' => {
	'Standard' => 'std',
	'US keyboard with Lithuanian letters' => 'us',
    },
    'lv' => {
	'Apostrophe () variant' => 'apostrophe',
	'F-letter (F) variant' => 'fkey',
	'Tilde (~) variant' => 'tilde',
    },
    'mk' => {
	'Eliminate dead keys' => 'nodeadkeys',
    },
    'mt' => {
	'US keyboard with Maltian letters' => 'us',
    },
    'nl' => {
	'Sun dead keys' => 'sundeadkeys',
    },
    'no' => {
	'Dvorak' => 'dvorak',
	'Eliminate dead keys' => 'nodeadkeys',
	'Northern Saami' => 'smi',
	'Northern Saami, eliminate dead keys' => 'smi_nodeadkeys',
    },
    'pl' => {
	'Dvorak' => 'dvorak',
	'Dvorak, Polish quotes on key "1/!"' => 'dvorak_altquotes',
	'Dvorak, Polish quotes on quotemark key' => 'dvorak_quotes',
	'qwertz' => 'qwertz',
    },
    'pt' => {
	'Eliminate dead keys' => 'nodeadkeys',
	'Sun dead keys' => 'sundeadkeys',
    },
    'ro' => {
	'Standard' => 'std',
	'Winkeys' => 'winkeys',
    },
    'ru' => {
	'Phonetic' => 'phonetic',
	'Tatar' => 'tt',
	'Typewriter' => 'typewriter',
	'Winkeys' => 'winkeys',
    },
    'se' => {
	'Dvorak' => 'dvorak',
	'Eliminate dead keys' => 'nodeadkeys',
	'Northern Saami' => 'smi',
	'Russian phonetic' => 'rus',
	'Russian phonetic, eliminate dead keys' => 'rus_nodeadkeys',
    },
    'si' => {
	'US keyboard with Slovenian digraphs' => 'unicodeus',
	'US keyboard with Slovenian letters' => 'us',
	'Use Slovenian digraphs' => 'unicode',
	'Use guillemots for quotes' => 'alternatequotes',
    },
    'sk' => {
	'Extended Backslash' => 'bksl',
	'qwerty' => 'qwerty',
	'qwerty, extended Backslash' => 'qwerty_bksl',
    },
    'sy' => {
	'Syriac' => 'syc',
	'Syriac phonetic' => 'syc_phonetic',
    },
    'th' => {
	'Pattachote' => 'pat',
	'TIS-820.2538' => 'tis',
    },
    'tr' => {
	'(F)' => 'f',
	'Alt-Q' => 'alt',
	'Sun dead keys' => 'sundeadkeys',
    },
    'ua' => {
	'Phonetic' => 'phonetic',
	'Standard RSTU' => 'rstu',
	'Standard RSTU on Russian layout' => 'rstu_ru',
	'Typewriter' => 'typewriter',
	'Winkeys' => 'winkeys',
    },
    'us' => {
	'Alternative international (former us_intl)' => 'alt-intl',
	'Dvorak' => 'dvorak',
	'International (with dead keys)' => 'intl',
	'Left handed Dvorak' => 'dvorak-l',
	'Right handed Dvorak' => 'dvorak-r',
	'Russian phonetic' => 'rus',
    },
);

1;
