# -*- coding: utf-8 -*-
# Author: Manuel de la Pena <manuel@canonical.com>
#
# Copyright 2011 Canonical Ltd.
#
# This program is free software: you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 3, as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranties of
# MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
# PURPOSE.  See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program.  If not, see <http://www.gnu.org/licenses/>.
"""Test the interaction of the view with the auto generated code."""

from unittest import TestCase
from mocker import MATCH, Mocker

from ubuntu_sso.qt.gui import (
    ChooseSignInPage,
    CurrentUserSignInPage,
    EmailVerificationPage,
    ErrorPage,
    Header,
    SetupAccountPage,
    SuccessPage,
    TosPage)
# in linux we will be having a pylint warning because the code is not
# compiled since we are just targeting windows with it, later
# in the iteration we can work on using it on kde
# pylint: disable=F0401,E0611
from ubuntu_sso.qt.choose_sign_in_ui import Ui_ChooseSignInPage
from ubuntu_sso.qt.current_user_sign_in_ui import Ui_CurrentUserSignInPage
from ubuntu_sso.qt.email_verification_ui import Ui_EmailVerificationPage
from ubuntu_sso.qt.error_message_ui import Ui_ErrorPage
from ubuntu_sso.qt.terms_and_conditions_ui import Ui_TosPage
from ubuntu_sso.qt.setup_account_ui import Ui_SetUpAccountPage
from ubuntu_sso.qt.success_message_ui import Ui_SuccessPage
# pylint: enable=F0401


class FakeController(object):
    """A fake controller for the tests."""

    # pylint: disable=C0103
    def setupUi(self, view):
        """Fake the setup."""
    # pylint: enable=C0103


class ChooseSignInPageTestCase(TestCase):
    """Test the ChooseSignInPage."""

    def setUp(self):
        """Set up the tests."""
        super(ChooseSignInPageTestCase, self).setUp()
        self.ui = Ui_ChooseSignInPage()
        self.controller = FakeController()
        self.widget = ChooseSignInPage(self.ui, self.controller)

    def tearDown(self):
        self.widget.close()

    def test_constructor(self):
        """Test the constructor of the class."""
        # used a mocked ui for this
        mocker = Mocker()
        ui = mocker.mock()
        controller = mocker.mock()
        ui.setupUi(MATCH(lambda x: isinstance(x, ChooseSignInPage)))
        controller.setupUi(MATCH(lambda x: isinstance(x, ChooseSignInPage)))
        mocker.replay()
        self.widget = ChooseSignInPage(self.ui, self.controller)

    def test_next_id(self):
        """Test the nextId method."""
        next_id = 1
        self.widget.next = next_id
        self.assertEqual(next_id, self.widget.nextId())


class CurrentUserSignInPageTestCase(TestCase):
    """Test the CurrentUserSignInPage."""

    def setUp(self):
        """Set up the tests."""
        super(CurrentUserSignInPageTestCase, self).setUp()
        self.ui = Ui_CurrentUserSignInPage()
        self.controller = FakeController()
        self.widget = CurrentUserSignInPage(self.ui, self.controller)

    def test_constructor(self):
        """Test the constructor of the class."""
        mocker = Mocker()
        ui = mocker.mock()
        controller = mocker.mock()
        ui.setupUi(MATCH(lambda x: isinstance(x, CurrentUserSignInPage)))
        controller.setupUi(MATCH(lambda x: isinstance(x,
                                                      CurrentUserSignInPage)))
        mocker.replay()
        self.widget = ChooseSignInPage(self.ui, self.controller)


class EmailVerificationPageTestCase(TestCase):
    """Test the EmailVerificationPage."""

    def setUp(self):
        """Set up the tests."""
        super(EmailVerificationPageTestCase, self).setUp()
        self.ui = Ui_EmailVerificationPage()
        self.controller = FakeController()
        self.widget = EmailVerificationPage(self.ui, self.controller)

    def test_constructor(self):
        """Test the constructor of the class."""
        mocker = Mocker()
        ui = mocker.mock()
        controller = mocker.mock()
        ui.setupUi(MATCH(lambda x: isinstance(x, EmailVerificationPage)))
        controller.setupUi(MATCH(lambda x: isinstance(x,
                                                      EmailVerificationPage)))
        mocker.replay()
        self.widget = EmailVerificationPage(self.ui, self.controller)


class TosPageTestCase(TestCase):
    """Test the TosPage."""

    def setUp(self):
        """Set up the tests."""
        super(TosPageTestCase, self).setUp()
        self.ui = Ui_TosPage()
        self.controller = FakeController()
        self.widget = TosPage(self.ui, self.controller)

    def test_constructor(self):
        """Test the constructor of the class."""
        mocker = Mocker()
        ui = mocker.mock()
        controller = mocker.mock()
        ui.setupUi(MATCH(lambda x: isinstance(x, TosPage)))
        controller.setupUi(MATCH(lambda x: isinstance(x, TosPage)))
        mocker.replay()
        self.widget = TosPage(self.ui, self.controller)

    def test_next_id(self):
        """Test the nextId method."""
        self.assertEqual(-1, self.widget.nextId())


class SetUpAccountPageTestCase(TestCase):
    """Test the SetUpAccountPage."""

    def setUp(self):
        """Set up the tests."""
        super(SetUpAccountPageTestCase, self).setUp()
        self.ui = Ui_SetUpAccountPage()
        self.controller = FakeController()
        self.widget = SetupAccountPage(self.ui, self.controller)

    def test_constructor(self):
        """Test the constrcutor of the class."""
        mocker = Mocker()
        ui = mocker.mock()
        controller = mocker.mock()
        ui.setupUi(MATCH(lambda x: isinstance(x, SetupAccountPage)))
        controller.setupUi(MATCH(lambda x: isinstance(x, SetupAccountPage)))
        mocker.replay()
        self.widget = SetupAccountPage(self.ui, self.controller)

    def test_next_id(self):
        """Test the newxtId method."""
        next_id = 1
        self.widget.next = next_id
        self.assertEqual(next_id, self.widget.nextId())


class SuccessPageTestCase(TestCase):
    """Test that the correct widgets are used."""

    def setUp(self):
        """Setup tests."""
        super(SuccessPageTestCase, self).setUp()
        self.ui = Ui_SuccessPage()
        self.controller = FakeController()
        self.widget = SuccessPage(self.ui, self.controller)

    def test_constructor(self):
        """Test that the constructor works as expected."""
        mocker = Mocker()
        ui = mocker.mock()
        controller = mocker.mock()
        ui.setupUi(MATCH(lambda x: isinstance(x, SuccessPage)))
        controller.setupUi(MATCH(lambda x: isinstance(x, SuccessPage)))
        mocker.replay()
        self.widget = SuccessPage(self.ui, self.controller)


class ErrorPageTestCase(TestCase):
    """Test that the correct widgets are used."""

    def setUp(self):
        """Setup tests."""
        super(ErrorPageTestCase, self).setUp()
        self.ui = Ui_ErrorPage()
        self.controller = FakeController()
        self.widget = ErrorPage(self.ui, self.controller)

    def test_constructor(self):
        """Test that the constructor works as expected."""
        mocker = Mocker()
        ui = mocker.mock()
        controller = mocker.mock()
        ui.setupUi(MATCH(lambda x: isinstance(x, ErrorPage)))
        controller.setupUi(MATCH(lambda x: isinstance(x, ErrorPage)))
        mocker.replay()
        self.widget = ErrorPage(self.ui, self.controller)


class HeaderTest(TestCase):
    """Tests for injected Header in each Wizard Page."""

    def setUp(self):
        """Setup test."""
        super(HeaderTest, self).setUp()
        self.header = Header()

    def test_label_state(self):
        """Check the title and subtitle properties."""
        self.assertTrue(self.header.title_label.wordWrap())
        self.assertTrue(self.header.subtitle_label.wordWrap())
        self.assertFalse(self.header.title_label.isVisible())
        self.assertFalse(self.header.subtitle_label.isVisible())

    def test_set_title(self):
        """Check if set_title works ok, showing the widget if necessary."""
        self.header.set_title('title')
        self.assertEqual(self.header.title_label.text(), 'title')
        self.header.show()
        self.assertTrue(self.header.title_label.isVisible())
        self.header.hide()

    def test_set_empty_title(self):
        """Check if the widget is hidden for empty title."""
        self.header.set_title('')
        self.assertFalse(self.header.title_label.isVisible())

    def test_set_subtitle(self):
        """Check if set_subtitle works ok, showing the widget if necessary."""
        self.header.set_subtitle('subtitle')
        self.assertEqual(self.header.subtitle_label.text(), 'subtitle')
        self.header.show()
        self.assertTrue(self.header.subtitle_label.isVisible())
        self.header.hide()

    def test_set_empty_subtitle(self):
        """Check if the widget is hidden for empty subtitle."""
        self.header.set_title('')
        self.assertFalse(self.header.title_label.isVisible())
