//netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
const Cc = Components.classes;
const Ci = Components.interfaces
const Cu = Components.utils;

Cu.import("resource://gre/modules/ctypes.jsm");

var consoleService = Cc["@mozilla.org/consoleservice;1"].getService(Ci.nsIConsoleService);

var UnityXIDHelper = function () {
    var self = this;

    self.xidgetter = null;
    self.getxid = null;

    try {
	self.xidgetter = ctypes.open("libufe-xidgetter.so.0");
    } catch (e) {
	try {
	    this.xidgetter = ctypes.open("/usr/local/lib/libufe-xidgetter.so.0");
	} catch (e) {
	    this.xidgetter = ctypes.open("/usr/lib/libufe-xidgetter.so.0");
	}
    }

    self.getxid = self.xidgetter.declare("get_base_window_xid", ctypes.default_abi,
					 ctypes.uint32_t, ctypes.voidptr_t);

    self.getNativeHandle = function (win) {
	var baseWindow;
	var nsIInterfaceRequestor;

	nsIInterfaceRequestor = win.QueryInterface(Ci.nsIInterfaceRequestor)
    	    .getInterface (Ci.nsIWebNavigation)
    	    .QueryInterface (Ci.nsIDocShellTreeItem)
    	    .treeOwner
    	    .QueryInterface (Ci.nsIInterfaceRequestor);

    	if ("nsIBaseWindow_UBUNTU_ONLY" in Ci) { // For Ubuntu patched pre-17 versions of firefox
    	    baseWindow = nsIInterfaceRequestor.getInterface(Ci.nsIBaseWindow_UBUNTU_ONLY);
    	} else { // For Firefox 17
    	    baseWindow = nsIInterfaceRequestor.getInterface(Ci.nsIBaseWindow);
    	}
    	return baseWindow.nativeHandle;
    };

    self.setWindowXID = function (window, uwa, unityContext) {
    	try {
    	    var nativeHandle = self.getNativeHandle (window);
	    consoleService.logStringMessage(nativeHandle);
	    // firefox gives us a STRING representation of the pointer. So we convert it to an int.
	    // I'm not really sure this works.
    	    var xid = self.getxid (ctypes.voidptr_t (parseInt (nativeHandle, 16)));
    	    uwa.context_set_view_window (unityContext, xid);
    	} catch (e) {
	    consoleService.logStringMessage("Unity Extension, error setting context XID: " + e.toString());
	}
    }
};

var EXPORTED_SYMBOLS=["UnityXIDHelper"];
