/* folder.c generated by valac 0.16.1, the Vala compiler
 * generated from folder.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>


#define UNITY_FILES_LENS_TYPE_BOOKMARKS (unity_files_lens_bookmarks_get_type ())
#define UNITY_FILES_LENS_BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_FILES_LENS_TYPE_BOOKMARKS, UnityFilesLensBookmarks))
#define UNITY_FILES_LENS_BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_FILES_LENS_TYPE_BOOKMARKS, UnityFilesLensBookmarksClass))
#define UNITY_FILES_LENS_IS_BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_FILES_LENS_TYPE_BOOKMARKS))
#define UNITY_FILES_LENS_IS_BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_FILES_LENS_TYPE_BOOKMARKS))
#define UNITY_FILES_LENS_BOOKMARKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_FILES_LENS_TYPE_BOOKMARKS, UnityFilesLensBookmarksClass))

typedef struct _UnityFilesLensBookmarks UnityFilesLensBookmarks;
typedef struct _UnityFilesLensBookmarksClass UnityFilesLensBookmarksClass;
typedef struct _UnityFilesLensBookmarksPrivate UnityFilesLensBookmarksPrivate;

#define UNITY_FILES_LENS_TYPE_BOOKMARK (unity_files_lens_bookmark_get_type ())
#define UNITY_FILES_LENS_BOOKMARK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_FILES_LENS_TYPE_BOOKMARK, UnityFilesLensBookmark))
#define UNITY_FILES_LENS_BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_FILES_LENS_TYPE_BOOKMARK, UnityFilesLensBookmarkClass))
#define UNITY_FILES_LENS_IS_BOOKMARK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_FILES_LENS_TYPE_BOOKMARK))
#define UNITY_FILES_LENS_IS_BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_FILES_LENS_TYPE_BOOKMARK))
#define UNITY_FILES_LENS_BOOKMARK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_FILES_LENS_TYPE_BOOKMARK, UnityFilesLensBookmarkClass))

typedef struct _UnityFilesLensBookmark UnityFilesLensBookmark;
typedef struct _UnityFilesLensBookmarkClass UnityFilesLensBookmarkClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))
typedef struct _UnityFilesLensBookmarkPrivate UnityFilesLensBookmarkPrivate;

#define UNITY_FILES_LENS_TYPE_DEVICES (unity_files_lens_devices_get_type ())
#define UNITY_FILES_LENS_DEVICES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_FILES_LENS_TYPE_DEVICES, UnityFilesLensDevices))
#define UNITY_FILES_LENS_DEVICES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_FILES_LENS_TYPE_DEVICES, UnityFilesLensDevicesClass))
#define UNITY_FILES_LENS_IS_DEVICES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_FILES_LENS_TYPE_DEVICES))
#define UNITY_FILES_LENS_IS_DEVICES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_FILES_LENS_TYPE_DEVICES))
#define UNITY_FILES_LENS_DEVICES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_FILES_LENS_TYPE_DEVICES, UnityFilesLensDevicesClass))

typedef struct _UnityFilesLensDevices UnityFilesLensDevices;
typedef struct _UnityFilesLensDevicesClass UnityFilesLensDevicesClass;
typedef struct _UnityFilesLensDevicesPrivate UnityFilesLensDevicesPrivate;

#define UNITY_FILES_LENS_TYPE_DEVICE (unity_files_lens_device_get_type ())
#define UNITY_FILES_LENS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_FILES_LENS_TYPE_DEVICE, UnityFilesLensDevice))
#define UNITY_FILES_LENS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_FILES_LENS_TYPE_DEVICE, UnityFilesLensDeviceClass))
#define UNITY_FILES_LENS_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_FILES_LENS_TYPE_DEVICE))
#define UNITY_FILES_LENS_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_FILES_LENS_TYPE_DEVICE))
#define UNITY_FILES_LENS_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_FILES_LENS_TYPE_DEVICE, UnityFilesLensDeviceClass))

typedef struct _UnityFilesLensDevice UnityFilesLensDevice;
typedef struct _UnityFilesLensDeviceClass UnityFilesLensDeviceClass;
typedef struct _UnityFilesLensDevicePrivate UnityFilesLensDevicePrivate;

struct _UnityFilesLensBookmarks {
	GObject parent_instance;
	UnityFilesLensBookmarksPrivate * priv;
};

struct _UnityFilesLensBookmarksClass {
	GObjectClass parent_class;
};

struct _UnityFilesLensBookmarksPrivate {
	GList* bookmarks;
	gchar* bookmarks_file;
	GFileMonitor* monitor;
};

struct _UnityFilesLensBookmark {
	GObject parent_instance;
	UnityFilesLensBookmarkPrivate * priv;
};

struct _UnityFilesLensBookmarkClass {
	GObjectClass parent_class;
};

struct _UnityFilesLensBookmarkPrivate {
	gchar* _uri;
	gchar* _icon;
	gchar* _mimetype;
	gchar* _display_name;
	gchar* _dnd_uri;
	GList* index_terms;
};

struct _UnityFilesLensDevices {
	GObject parent_instance;
	UnityFilesLensDevicesPrivate * priv;
};

struct _UnityFilesLensDevicesClass {
	GObjectClass parent_class;
};

struct _UnityFilesLensDevicesPrivate {
	GList* devices;
	GVolumeMonitor* volume_monitor;
};

struct _UnityFilesLensDevice {
	GObject parent_instance;
	UnityFilesLensDevicePrivate * priv;
};

struct _UnityFilesLensDeviceClass {
	GObjectClass parent_class;
};

struct _UnityFilesLensDevicePrivate {
	GVolume* _volume;
	gchar* _name;
	gchar* _uri;
	GIcon* _icon;
	gchar* _icon_name;
	gchar* _display_name;
	gchar* _dnd_uri;
	GList* index_terms_;
};


static gpointer unity_files_lens_bookmarks_parent_class = NULL;
static gpointer unity_files_lens_bookmark_parent_class = NULL;
static gpointer unity_files_lens_devices_parent_class = NULL;
static gpointer unity_files_lens_device_parent_class = NULL;

GType unity_files_lens_bookmarks_get_type (void) G_GNUC_CONST;
GType unity_files_lens_bookmark_get_type (void) G_GNUC_CONST;
#define UNITY_FILES_LENS_BOOKMARKS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_FILES_LENS_TYPE_BOOKMARKS, UnityFilesLensBookmarksPrivate))
enum  {
	UNITY_FILES_LENS_BOOKMARKS_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
UnityFilesLensBookmarks* unity_files_lens_bookmarks_new (void);
UnityFilesLensBookmarks* unity_files_lens_bookmarks_construct (GType object_type);
static void unity_files_lens_bookmarks_update (UnityFilesLensBookmarks* self);
static void ___lambda3_ (UnityFilesLensBookmarks* self, GFileMonitor* mon, GFile* file, GFile* other_file, GFileMonitorEvent event_type);
static void ____lambda3__g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
UnityFilesLensBookmark* unity_files_lens_bookmark_new (const gchar* uri, const gchar* mimetype, const gchar* display_name);
UnityFilesLensBookmark* unity_files_lens_bookmark_construct (GType object_type, const gchar* uri, const gchar* mimetype, const gchar* display_name);
static GList* unity_files_lens_bookmarks_filter_bookmarks (UnityFilesLensBookmarks* self, GList* bm_list);
const gchar* unity_files_lens_bookmark_get_uri (UnityFilesLensBookmark* self);
GList* unity_files_lens_bookmarks_list (UnityFilesLensBookmarks* self);
GList* unity_files_lens_bookmarks_prefix_search (UnityFilesLensBookmarks* self, const gchar* search);
gchar* unity_files_lens_utils_normalize_string (const gchar* input);
GList* unity_files_lens_bookmark_get_index_terms (UnityFilesLensBookmark* self);
gboolean unity_files_lens_bookmarks_launch_if_bookmark (UnityFilesLensBookmarks* self, const gchar* uri, GError** error);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
static void unity_files_lens_bookmarks_finalize (GObject* obj);
#define UNITY_FILES_LENS_BOOKMARK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_FILES_LENS_TYPE_BOOKMARK, UnityFilesLensBookmarkPrivate))
enum  {
	UNITY_FILES_LENS_BOOKMARK_DUMMY_PROPERTY,
	UNITY_FILES_LENS_BOOKMARK_URI,
	UNITY_FILES_LENS_BOOKMARK_ICON,
	UNITY_FILES_LENS_BOOKMARK_MIMETYPE,
	UNITY_FILES_LENS_BOOKMARK_DISPLAY_NAME,
	UNITY_FILES_LENS_BOOKMARK_DND_URI
};
gchar* unity_files_lens_utils_get_icon_for_uri (const gchar* uri, const gchar* mimetype);
gboolean unity_files_lens_bookmark_is_bookmark_uri (const gchar* uri);
gchar* unity_files_lens_bookmark_uri_from_bookmark (const gchar* uri);
void unity_files_lens_bookmark_set_uri (UnityFilesLensBookmark* self, const gchar* value);
const gchar* unity_files_lens_bookmark_get_icon (UnityFilesLensBookmark* self);
void unity_files_lens_bookmark_set_icon (UnityFilesLensBookmark* self, const gchar* value);
const gchar* unity_files_lens_bookmark_get_mimetype (UnityFilesLensBookmark* self);
void unity_files_lens_bookmark_set_mimetype (UnityFilesLensBookmark* self, const gchar* value);
const gchar* unity_files_lens_bookmark_get_display_name (UnityFilesLensBookmark* self);
void unity_files_lens_bookmark_set_display_name (UnityFilesLensBookmark* self, const gchar* value);
const gchar* unity_files_lens_bookmark_get_dnd_uri (UnityFilesLensBookmark* self);
void unity_files_lens_bookmark_set_dnd_uri (UnityFilesLensBookmark* self, const gchar* value);
static void unity_files_lens_bookmark_finalize (GObject* obj);
static void _vala_unity_files_lens_bookmark_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_files_lens_bookmark_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType unity_files_lens_devices_get_type (void) G_GNUC_CONST;
GType unity_files_lens_device_get_type (void) G_GNUC_CONST;
#define UNITY_FILES_LENS_DEVICES_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_FILES_LENS_TYPE_DEVICES, UnityFilesLensDevicesPrivate))
enum  {
	UNITY_FILES_LENS_DEVICES_DUMMY_PROPERTY
};
UnityFilesLensDevices* unity_files_lens_devices_new (void);
UnityFilesLensDevices* unity_files_lens_devices_construct (GType object_type);
static void unity_files_lens_devices_update (UnityFilesLensDevices* self);
static void __lambda5_ (UnityFilesLensDevices* self, GVolumeMonitor* mon, GVolume* volume);
static void ___lambda5__g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self);
static void __lambda6_ (UnityFilesLensDevices* self, GVolumeMonitor* mon, GVolume* volume);
static void ___lambda6__g_volume_monitor_volume_removed (GVolumeMonitor* _sender, GVolume* volume, gpointer self);
static void __lambda7_ (UnityFilesLensDevices* self, GVolumeMonitor* mon, GVolume* volume);
static void ___lambda7__g_volume_monitor_volume_changed (GVolumeMonitor* _sender, GVolume* volume, gpointer self);
UnityFilesLensDevice* unity_files_lens_device_new (GVolume* volume);
UnityFilesLensDevice* unity_files_lens_device_construct (GType object_type, GVolume* volume);
GList* unity_files_lens_devices_list (UnityFilesLensDevices* self);
GList* unity_files_lens_devices_search (UnityFilesLensDevices* self, const gchar* search);
GList* unity_files_lens_device_get_index_terms (UnityFilesLensDevice* self);
gboolean unity_files_lens_devices_launch_if_device (UnityFilesLensDevices* self, const gchar* uri, GError** error);
gboolean unity_files_lens_device_is_device_uri (const gchar* uri);
const gchar* unity_files_lens_device_get_uri (UnityFilesLensDevice* self);
void unity_files_lens_device_mount_and_open (UnityFilesLensDevice* self, GError** error);
UnityFilesLensDevice* unity_files_lens_devices_get_device_from_uri (UnityFilesLensDevices* self, const gchar* uri);
static void unity_files_lens_devices_finalize (GObject* obj);
#define UNITY_FILES_LENS_DEVICE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_FILES_LENS_TYPE_DEVICE, UnityFilesLensDevicePrivate))
enum  {
	UNITY_FILES_LENS_DEVICE_DUMMY_PROPERTY,
	UNITY_FILES_LENS_DEVICE_VOLUME,
	UNITY_FILES_LENS_DEVICE_NAME,
	UNITY_FILES_LENS_DEVICE_URI,
	UNITY_FILES_LENS_DEVICE_ICON,
	UNITY_FILES_LENS_DEVICE_ICON_NAME,
	UNITY_FILES_LENS_DEVICE_DISPLAY_NAME,
	UNITY_FILES_LENS_DEVICE_DND_URI
};
static gboolean unity_files_lens_device_is_mounted (UnityFilesLensDevice* self);
static void unity_files_lens_device_open_in_file_manager (UnityFilesLensDevice* self, GError** error);
GVolume* unity_files_lens_device_get_volume (UnityFilesLensDevice* self);
static void ___lambda4_ (UnityFilesLensDevice* self, GObject* obj, GAsyncResult* res);
const gchar* unity_files_lens_device_get_display_name (UnityFilesLensDevice* self);
static void ____lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gchar* unity_files_lens_device_get_volume_uri (UnityFilesLensDevice* self);
GFile* unity_files_lens_device_get_root_file (UnityFilesLensDevice* self);
void unity_files_lens_device_set_volume (UnityFilesLensDevice* self, GVolume* value);
const gchar* unity_files_lens_device_get_name (UnityFilesLensDevice* self);
void unity_files_lens_device_set_name (UnityFilesLensDevice* self, const gchar* value);
void unity_files_lens_device_set_uri (UnityFilesLensDevice* self, const gchar* value);
GIcon* unity_files_lens_device_get_icon (UnityFilesLensDevice* self);
void unity_files_lens_device_set_icon (UnityFilesLensDevice* self, GIcon* value);
const gchar* unity_files_lens_device_get_icon_name (UnityFilesLensDevice* self);
void unity_files_lens_device_set_icon_name (UnityFilesLensDevice* self, const gchar* value);
void unity_files_lens_device_set_display_name (UnityFilesLensDevice* self, const gchar* value);
const gchar* unity_files_lens_device_get_dnd_uri (UnityFilesLensDevice* self);
void unity_files_lens_device_set_dnd_uri (UnityFilesLensDevice* self, const gchar* value);
static void unity_files_lens_device_finalize (GObject* obj);
static void _vala_unity_files_lens_device_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_files_lens_device_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void ___lambda3_ (UnityFilesLensBookmarks* self, GFileMonitor* mon, GFile* file, GFile* other_file, GFileMonitorEvent event_type) {
	g_return_if_fail (mon != NULL);
	g_return_if_fail (file != NULL);
	g_debug ("folder.vala:41: Bookmarks changed. Updating.");
	unity_files_lens_bookmarks_update (self);
	g_signal_emit_by_name (self, "changed");
}


static void ____lambda3__g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	___lambda3_ (self, _sender, file, other_file, event_type);
}


UnityFilesLensBookmarks* unity_files_lens_bookmarks_construct (GType object_type) {
	UnityFilesLensBookmarks * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	self = (UnityFilesLensBookmarks*) g_object_new (object_type, NULL);
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat (_tmp1_, "/.gtk-bookmarks", NULL);
	_g_free0 (self->priv->bookmarks_file);
	self->priv->bookmarks_file = _tmp2_;
	unity_files_lens_bookmarks_update (self);
	{
		const gchar* _tmp3_;
		GFile* _tmp4_ = NULL;
		GFile* _tmp5_;
		GFileMonitor* _tmp6_ = NULL;
		GFileMonitor* _tmp7_;
		GFileMonitor* _tmp8_;
		GFileMonitor* _tmp9_;
		GFileMonitor* _tmp10_;
		_tmp3_ = self->priv->bookmarks_file;
		_tmp4_ = g_file_new_for_path (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_file_monitor (_tmp5_, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		_tmp8_ = _tmp7_;
		if (_inner_error_ != NULL) {
			goto __catch11_g_error;
		}
		_g_object_unref0 (self->priv->monitor);
		self->priv->monitor = _tmp8_;
		_tmp9_ = self->priv->monitor;
		g_file_monitor_set_rate_limit (_tmp9_, 2000);
		_tmp10_ = self->priv->monitor;
		g_signal_connect_object (_tmp10_, "changed", (GCallback) ____lambda3__g_file_monitor_changed, self, 0);
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = self->priv->bookmarks_file;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_warning ("folder.vala:46: Failed to install file monitor on %s. Bookmarks monito" \
"ring disabled: %s", _tmp11_, _tmp13_);
		_g_error_free0 (e);
	}
	__finally11:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


UnityFilesLensBookmarks* unity_files_lens_bookmarks_new (void) {
	return unity_files_lens_bookmarks_construct (UNITY_FILES_LENS_TYPE_BOOKMARKS);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void unity_files_lens_bookmarks_update (UnityFilesLensBookmarks* self) {
	gchar* contents = NULL;
	gchar* desktop_uri = NULL;
	gboolean has_desktop_in_favourites;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* desktop_file;
	GFile* _tmp2_;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_ = NULL;
	gchar** favorites;
	gint favorites_length1;
	gint _favorites_size_;
	gchar* _tmp11_;
	gchar* mimetype;
	gchar** _tmp12_;
	gint _tmp12__length1;
	gboolean _tmp43_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	__g_list_free__g_object_unref0_0 (self->priv->bookmarks);
	self->priv->bookmarks = NULL;
	has_desktop_in_favourites = FALSE;
	_tmp0_ = g_get_user_special_dir (G_USER_DIRECTORY_DESKTOP);
	_tmp1_ = g_file_new_for_path (_tmp0_);
	desktop_file = _tmp1_;
	_tmp2_ = desktop_file;
	_tmp3_ = g_file_get_uri (_tmp2_);
	_g_free0 (desktop_uri);
	desktop_uri = _tmp3_;
	{
		const gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		_tmp4_ = self->priv->bookmarks_file;
		g_file_get_contents (_tmp4_, &_tmp5_, NULL, &_inner_error_);
		_g_free0 (contents);
		contents = _tmp5_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch12_g_file_error;
			}
			_g_object_unref0 (desktop_file);
			_g_free0 (desktop_uri);
			_g_free0 (contents);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally12;
	__catch12_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("folder.vala:65: Failed to read favorites: %s", _tmp7_);
		_g_error_free0 (e);
		_g_object_unref0 (desktop_file);
		_g_free0 (desktop_uri);
		_g_free0 (contents);
		return;
	}
	__finally12:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (desktop_file);
		_g_free0 (desktop_uri);
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = contents;
	_tmp10_ = _tmp9_ = g_strsplit (_tmp8_, "\n", 0);
	favorites = _tmp10_;
	favorites_length1 = _vala_array_length (_tmp9_);
	_favorites_size_ = favorites_length1;
	_tmp11_ = g_strdup ("inode/directory");
	mimetype = _tmp11_;
	_tmp12_ = favorites;
	_tmp12__length1 = favorites_length1;
	{
		gchar** uri_collection = NULL;
		gint uri_collection_length1 = 0;
		gint _uri_collection_size_ = 0;
		gint uri_it = 0;
		uri_collection = _tmp12_;
		uri_collection_length1 = _tmp12__length1;
		for (uri_it = 0; uri_it < _tmp12__length1; uri_it = uri_it + 1) {
			gchar* _tmp13_;
			gchar* uri = NULL;
			_tmp13_ = g_strdup (uri_collection[uri_it]);
			uri = _tmp13_;
			{
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				gboolean _tmp16_ = FALSE;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				gchar** _tmp20_;
				gchar** _tmp21_ = NULL;
				gchar** parts;
				gint parts_length1;
				gint _parts_size_;
				gchar* display_name = NULL;
				gchar** _tmp22_;
				gint _tmp22__length1;
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				const gchar* _tmp39_;
				UnityFilesLensBookmark* _tmp40_;
				UnityFilesLensBookmark* bookmark;
				UnityFilesLensBookmark* _tmp41_;
				UnityFilesLensBookmark* _tmp42_;
				_tmp14_ = uri;
				if (g_strcmp0 (_tmp14_, "") == 0) {
					_g_free0 (uri);
					continue;
				}
				_tmp15_ = uri;
				_tmp16_ = g_str_has_prefix (_tmp15_, "x-nautilus-desktop:");
				if (_tmp16_) {
					_g_free0 (uri);
					continue;
				}
				_tmp17_ = uri;
				_tmp18_ = desktop_uri;
				if (g_strcmp0 (_tmp17_, _tmp18_) == 0) {
					has_desktop_in_favourites = TRUE;
				}
				_tmp19_ = uri;
				_tmp21_ = _tmp20_ = g_strsplit (_tmp19_, " ", 2);
				parts = _tmp21_;
				parts_length1 = _vala_array_length (_tmp20_);
				_parts_size_ = parts_length1;
				_tmp22_ = parts;
				_tmp22__length1 = parts_length1;
				if (_tmp22__length1 == 1) {
					const gchar* _tmp23_;
					gchar* _tmp24_ = NULL;
					const gchar* _tmp25_;
					gchar* _tmp26_ = NULL;
					_tmp23_ = uri;
					_tmp24_ = g_uri_unescape_string (_tmp23_, NULL);
					_g_free0 (display_name);
					display_name = _tmp24_;
					_tmp25_ = display_name;
					_tmp26_ = g_filename_display_basename (_tmp25_);
					_g_free0 (display_name);
					display_name = _tmp26_;
				} else {
					gchar** _tmp27_;
					gint _tmp27__length1;
					_tmp27_ = parts;
					_tmp27__length1 = parts_length1;
					if (_tmp27__length1 == 2) {
						gchar** _tmp28_;
						gint _tmp28__length1;
						const gchar* _tmp29_;
						gchar* _tmp30_;
						gchar** _tmp31_;
						gint _tmp31__length1;
						const gchar* _tmp32_;
						gchar* _tmp33_;
						_tmp28_ = parts;
						_tmp28__length1 = parts_length1;
						_tmp29_ = _tmp28_[0];
						_tmp30_ = g_strdup (_tmp29_);
						_g_free0 (uri);
						uri = _tmp30_;
						_tmp31_ = parts;
						_tmp31__length1 = parts_length1;
						_tmp32_ = _tmp31_[1];
						_tmp33_ = g_strdup (_tmp32_);
						_g_free0 (display_name);
						display_name = _tmp33_;
					} else {
						const gchar* _tmp34_;
						const gchar* _tmp35_;
						gchar* _tmp36_;
						_tmp34_ = uri;
						g_warning ("folder.vala:98: Internal error computing display name for favorite '%s" \
"'", _tmp34_);
						_tmp35_ = uri;
						_tmp36_ = g_strdup (_tmp35_);
						_g_free0 (display_name);
						display_name = _tmp36_;
					}
				}
				_tmp37_ = uri;
				_tmp38_ = mimetype;
				_tmp39_ = display_name;
				_tmp40_ = unity_files_lens_bookmark_new (_tmp37_, _tmp38_, _tmp39_);
				bookmark = _tmp40_;
				_tmp41_ = bookmark;
				_tmp42_ = _g_object_ref0 (_tmp41_);
				self->priv->bookmarks = g_list_append (self->priv->bookmarks, _tmp42_);
				_g_object_unref0 (bookmark);
				_g_free0 (display_name);
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (uri);
			}
		}
	}
	_tmp43_ = has_desktop_in_favourites;
	if (!_tmp43_) {
		GFile* _tmp44_;
		gchar* _tmp45_ = NULL;
		gchar* _tmp46_;
		gchar* _tmp47_ = NULL;
		gchar* _tmp48_;
		gchar* desktop_display_name;
		const gchar* _tmp49_;
		const gchar* _tmp50_;
		const gchar* _tmp51_;
		UnityFilesLensBookmark* _tmp52_;
		UnityFilesLensBookmark* desktop_bookmark;
		UnityFilesLensBookmark* _tmp53_;
		UnityFilesLensBookmark* _tmp54_;
		_tmp44_ = desktop_file;
		_tmp45_ = g_file_get_parse_name (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = g_path_get_basename (_tmp46_);
		_tmp48_ = _tmp47_;
		_g_free0 (_tmp46_);
		desktop_display_name = _tmp48_;
		_tmp49_ = desktop_uri;
		_tmp50_ = mimetype;
		_tmp51_ = desktop_display_name;
		_tmp52_ = unity_files_lens_bookmark_new (_tmp49_, _tmp50_, _tmp51_);
		desktop_bookmark = _tmp52_;
		_tmp53_ = desktop_bookmark;
		_tmp54_ = _g_object_ref0 (_tmp53_);
		self->priv->bookmarks = g_list_append (self->priv->bookmarks, _tmp54_);
		_g_object_unref0 (desktop_bookmark);
		_g_free0 (desktop_display_name);
	}
	_g_free0 (mimetype);
	favorites = (_vala_array_free (favorites, favorites_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (desktop_file);
	_g_free0 (desktop_uri);
	_g_free0 (contents);
}


static GList* unity_files_lens_bookmarks_filter_bookmarks (UnityFilesLensBookmarks* self, GList* bm_list) {
	GList* result = NULL;
	GList* _result_;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = NULL;
	_tmp0_ = bm_list;
	{
		GList* bookmark_collection = NULL;
		GList* bookmark_it = NULL;
		bookmark_collection = _tmp0_;
		for (bookmark_it = bookmark_collection; bookmark_it != NULL; bookmark_it = bookmark_it->next) {
			UnityFilesLensBookmark* _tmp1_;
			UnityFilesLensBookmark* bookmark = NULL;
			_tmp1_ = _g_object_ref0 ((UnityFilesLensBookmark*) bookmark_it->data);
			bookmark = _tmp1_;
			{
				UnityFilesLensBookmark* _tmp2_;
				const gchar* _tmp3_;
				const gchar* _tmp4_;
				GFile* _tmp5_ = NULL;
				GFile* f;
				gboolean _tmp6_ = FALSE;
				GFile* _tmp7_;
				gboolean _tmp8_ = FALSE;
				gboolean _tmp11_;
				UnityFilesLensBookmark* _tmp12_;
				UnityFilesLensBookmark* _tmp13_;
				_tmp2_ = bookmark;
				_tmp3_ = unity_files_lens_bookmark_get_uri (_tmp2_);
				_tmp4_ = _tmp3_;
				_tmp5_ = g_file_new_for_uri (_tmp4_);
				f = _tmp5_;
				_tmp7_ = f;
				_tmp8_ = g_file_is_native (_tmp7_);
				if (_tmp8_) {
					GFile* _tmp9_;
					gboolean _tmp10_ = FALSE;
					_tmp9_ = f;
					_tmp10_ = g_file_query_exists (_tmp9_, NULL);
					_tmp6_ = !_tmp10_;
				} else {
					_tmp6_ = FALSE;
				}
				_tmp11_ = _tmp6_;
				if (_tmp11_) {
					_g_object_unref0 (f);
					_g_object_unref0 (bookmark);
					continue;
				}
				_tmp12_ = bookmark;
				_tmp13_ = _g_object_ref0 (_tmp12_);
				_result_ = g_list_prepend (_result_, _tmp13_);
				_g_object_unref0 (f);
				_g_object_unref0 (bookmark);
			}
		}
	}
	_result_ = g_list_reverse (_result_);
	result = _result_;
	return result;
}


GList* unity_files_lens_bookmarks_list (UnityFilesLensBookmarks* self) {
	GList* result = NULL;
	GList* _tmp0_;
	GList* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->bookmarks;
	_tmp1_ = unity_files_lens_bookmarks_filter_bookmarks (self, _tmp0_);
	result = _tmp1_;
	return result;
}


GList* unity_files_lens_bookmarks_prefix_search (UnityFilesLensBookmarks* self, const gchar* search) {
	GList* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* prefix;
	GList* matches;
	GList* _tmp2_;
	GList* _tmp12_;
	GList* _tmp13_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (search != NULL, NULL);
	_tmp0_ = search;
	_tmp1_ = unity_files_lens_utils_normalize_string (_tmp0_);
	prefix = _tmp1_;
	matches = NULL;
	_tmp2_ = self->priv->bookmarks;
	{
		GList* bookmark_collection = NULL;
		GList* bookmark_it = NULL;
		bookmark_collection = _tmp2_;
		for (bookmark_it = bookmark_collection; bookmark_it != NULL; bookmark_it = bookmark_it->next) {
			UnityFilesLensBookmark* _tmp3_;
			UnityFilesLensBookmark* bookmark = NULL;
			_tmp3_ = _g_object_ref0 ((UnityFilesLensBookmark*) bookmark_it->data);
			bookmark = _tmp3_;
			{
				UnityFilesLensBookmark* _tmp4_;
				GList* _tmp5_ = NULL;
				_tmp4_ = bookmark;
				_tmp5_ = unity_files_lens_bookmark_get_index_terms (_tmp4_);
				{
					GList* term_collection = NULL;
					GList* term_it = NULL;
					term_collection = _tmp5_;
					for (term_it = term_collection; term_it != NULL; term_it = term_it->next) {
						gchar* _tmp6_;
						gchar* term = NULL;
						_tmp6_ = g_strdup ((const gchar*) term_it->data);
						term = _tmp6_;
						{
							const gchar* _tmp7_;
							const gchar* _tmp8_;
							gboolean _tmp9_ = FALSE;
							_tmp7_ = term;
							_tmp8_ = prefix;
							_tmp9_ = g_str_has_prefix (_tmp7_, _tmp8_);
							if (_tmp9_) {
								UnityFilesLensBookmark* _tmp10_;
								UnityFilesLensBookmark* _tmp11_;
								_tmp10_ = bookmark;
								_tmp11_ = _g_object_ref0 (_tmp10_);
								matches = g_list_append (matches, _tmp11_);
								_g_free0 (term);
								break;
							}
							_g_free0 (term);
						}
					}
				}
				_g_object_unref0 (bookmark);
			}
		}
	}
	_tmp12_ = matches;
	_tmp13_ = unity_files_lens_bookmarks_filter_bookmarks (self, _tmp12_);
	result = _tmp13_;
	__g_list_free__g_object_unref0_0 (matches);
	_g_free0 (prefix);
	return result;
}


static const gchar* string_offset (const gchar* self, glong offset) {
	const gchar* result = NULL;
	glong _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = offset;
	result = (const gchar*) (((gchar*) self) + _tmp0_);
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


gboolean unity_files_lens_bookmarks_launch_if_bookmark (UnityFilesLensBookmarks* self, const gchar* uri, GError** error) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GAppInfo* _tmp2_ = NULL;
	GAppInfo* launcher;
	const gchar* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GAppInfo* _tmp5_;
	GList* uris;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GAppInfo* _tmp11_;
	GList* _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = uri;
	_tmp1_ = g_str_has_prefix (_tmp0_, "bookmark:");
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = g_app_info_get_default_for_type ("inode/directory", TRUE);
	launcher = _tmp2_;
	_tmp3_ = uri;
	_tmp4_ = string_offset (_tmp3_, (glong) 9);
	uri = _tmp4_;
	_tmp5_ = launcher;
	if (_tmp5_ == NULL) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		GError* _tmp8_;
		_tmp6_ = uri;
		g_warning ("folder.vala:201: No default handler for inode/directory. Unable to ope" \
"n bookmark '%s'", _tmp6_);
		_tmp7_ = uri;
		_tmp8_ = g_error_new (G_IO_ERROR, G_IO_ERROR_FAILED, "No default handler for inode/directory. Unable to open bookmark '%s'", _tmp7_);
		_inner_error_ = _tmp8_;
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (launcher);
		return FALSE;
	}
	uris = NULL;
	_tmp9_ = uri;
	_tmp10_ = g_strdup (_tmp9_);
	uris = g_list_append (uris, _tmp10_);
	_tmp11_ = launcher;
	_tmp12_ = uris;
	g_app_info_launch_uris (_tmp11_, _tmp12_, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		__g_list_free__g_free0_0 (uris);
		_g_object_unref0 (launcher);
		return FALSE;
	}
	result = TRUE;
	__g_list_free__g_free0_0 (uris);
	_g_object_unref0 (launcher);
	return result;
}


static void unity_files_lens_bookmarks_class_init (UnityFilesLensBookmarksClass * klass) {
	unity_files_lens_bookmarks_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityFilesLensBookmarksPrivate));
	G_OBJECT_CLASS (klass)->finalize = unity_files_lens_bookmarks_finalize;
	g_signal_new ("changed", UNITY_FILES_LENS_TYPE_BOOKMARKS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void unity_files_lens_bookmarks_instance_init (UnityFilesLensBookmarks * self) {
	self->priv = UNITY_FILES_LENS_BOOKMARKS_GET_PRIVATE (self);
}


static void unity_files_lens_bookmarks_finalize (GObject* obj) {
	UnityFilesLensBookmarks * self;
	self = UNITY_FILES_LENS_BOOKMARKS (obj);
	__g_list_free__g_object_unref0_0 (self->priv->bookmarks);
	_g_free0 (self->priv->bookmarks_file);
	_g_object_unref0 (self->priv->monitor);
	G_OBJECT_CLASS (unity_files_lens_bookmarks_parent_class)->finalize (obj);
}


GType unity_files_lens_bookmarks_get_type (void) {
	static volatile gsize unity_files_lens_bookmarks_type_id__volatile = 0;
	if (g_once_init_enter (&unity_files_lens_bookmarks_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityFilesLensBookmarksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_files_lens_bookmarks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityFilesLensBookmarks), 0, (GInstanceInitFunc) unity_files_lens_bookmarks_instance_init, NULL };
		GType unity_files_lens_bookmarks_type_id;
		unity_files_lens_bookmarks_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityFilesLensBookmarks", &g_define_type_info, 0);
		g_once_init_leave (&unity_files_lens_bookmarks_type_id__volatile, unity_files_lens_bookmarks_type_id);
	}
	return unity_files_lens_bookmarks_type_id__volatile;
}


UnityFilesLensBookmark* unity_files_lens_bookmark_construct (GType object_type, const gchar* uri, const gchar* mimetype, const gchar* display_name) {
	UnityFilesLensBookmark * self = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	const gchar* _tmp14_;
	gchar* _tmp15_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (mimetype != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	_tmp0_ = uri;
	_tmp1_ = g_strconcat ("bookmark:", _tmp0_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = uri;
	_tmp4_ = mimetype;
	_tmp5_ = unity_files_lens_utils_get_icon_for_uri (_tmp3_, _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = mimetype;
	_tmp8_ = display_name;
	_tmp9_ = uri;
	self = (UnityFilesLensBookmark*) g_object_new (object_type, "uri", _tmp2_, "icon", _tmp6_, "mimetype", _tmp7_, "display-name", _tmp8_, "dnd-uri", _tmp9_, NULL);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp2_);
	__g_list_free__g_free0_0 (self->priv->index_terms);
	self->priv->index_terms = NULL;
	_tmp10_ = uri;
	_tmp11_ = g_path_get_basename (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = unity_files_lens_utils_normalize_string (_tmp12_);
	self->priv->index_terms = g_list_append (self->priv->index_terms, _tmp13_);
	_g_free0 (_tmp12_);
	_tmp14_ = display_name;
	_tmp15_ = unity_files_lens_utils_normalize_string (_tmp14_);
	self->priv->index_terms = g_list_append (self->priv->index_terms, _tmp15_);
	return self;
}


UnityFilesLensBookmark* unity_files_lens_bookmark_new (const gchar* uri, const gchar* mimetype, const gchar* display_name) {
	return unity_files_lens_bookmark_construct (UNITY_FILES_LENS_TYPE_BOOKMARK, uri, mimetype, display_name);
}


GList* unity_files_lens_bookmark_get_index_terms (UnityFilesLensBookmark* self) {
	GList* result = NULL;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->index_terms;
	result = _tmp0_;
	return result;
}


gboolean unity_files_lens_bookmark_is_bookmark_uri (const gchar* uri) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = uri;
	_tmp1_ = g_str_has_prefix (_tmp0_, "bookmark:");
	result = _tmp1_;
	return result;
}


static glong string_strnlen (gchar* str, glong maxlen) {
	glong result = 0L;
	gchar* _tmp0_;
	glong _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* end;
	gchar* _tmp3_;
	_tmp0_ = str;
	_tmp1_ = maxlen;
	_tmp2_ = memchr (_tmp0_, 0, (gsize) _tmp1_);
	end = _tmp2_;
	_tmp3_ = end;
	if (_tmp3_ == NULL) {
		glong _tmp4_;
		_tmp4_ = maxlen;
		result = _tmp4_;
		return result;
	} else {
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = end;
		_tmp6_ = str;
		result = (glong) (_tmp5_ - _tmp6_);
		return result;
	}
}


static gchar* string_substring (const gchar* self, glong offset, glong len) {
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp1_;
	gboolean _tmp3_;
	glong _tmp9_;
	glong _tmp15_;
	glong _tmp18_;
	glong _tmp19_;
	glong _tmp20_;
	glong _tmp21_;
	glong _tmp22_;
	gchar* _tmp23_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = offset;
	if (_tmp1_ >= ((glong) 0)) {
		glong _tmp2_;
		_tmp2_ = len;
		_tmp0_ = _tmp2_ >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		glong _tmp4_;
		glong _tmp5_;
		glong _tmp6_ = 0L;
		_tmp4_ = offset;
		_tmp5_ = len;
		_tmp6_ = string_strnlen ((gchar*) self, _tmp4_ + _tmp5_);
		string_length = _tmp6_;
	} else {
		gint _tmp7_;
		gint _tmp8_;
		_tmp7_ = strlen (self);
		_tmp8_ = _tmp7_;
		string_length = (glong) _tmp8_;
	}
	_tmp9_ = offset;
	if (_tmp9_ < ((glong) 0)) {
		glong _tmp10_;
		glong _tmp11_;
		glong _tmp12_;
		_tmp10_ = string_length;
		_tmp11_ = offset;
		offset = _tmp10_ + _tmp11_;
		_tmp12_ = offset;
		g_return_val_if_fail (_tmp12_ >= ((glong) 0), NULL);
	} else {
		glong _tmp13_;
		glong _tmp14_;
		_tmp13_ = offset;
		_tmp14_ = string_length;
		g_return_val_if_fail (_tmp13_ <= _tmp14_, NULL);
	}
	_tmp15_ = len;
	if (_tmp15_ < ((glong) 0)) {
		glong _tmp16_;
		glong _tmp17_;
		_tmp16_ = string_length;
		_tmp17_ = offset;
		len = _tmp16_ - _tmp17_;
	}
	_tmp18_ = offset;
	_tmp19_ = len;
	_tmp20_ = string_length;
	g_return_val_if_fail ((_tmp18_ + _tmp19_) <= _tmp20_, NULL);
	_tmp21_ = offset;
	_tmp22_ = len;
	_tmp23_ = g_strndup (((gchar*) self) + _tmp21_, (gsize) _tmp22_);
	result = _tmp23_;
	return result;
}


gchar* unity_files_lens_bookmark_uri_from_bookmark (const gchar* uri) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = uri;
	_tmp1_ = string_substring (_tmp0_, (glong) 9, (glong) (-1));
	result = _tmp1_;
	return result;
}


const gchar* unity_files_lens_bookmark_get_uri (UnityFilesLensBookmark* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uri;
	result = _tmp0_;
	return result;
}


void unity_files_lens_bookmark_set_uri (UnityFilesLensBookmark* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_uri);
	self->priv->_uri = _tmp1_;
	g_object_notify ((GObject *) self, "uri");
}


const gchar* unity_files_lens_bookmark_get_icon (UnityFilesLensBookmark* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}


void unity_files_lens_bookmark_set_icon (UnityFilesLensBookmark* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_icon);
	self->priv->_icon = _tmp1_;
	g_object_notify ((GObject *) self, "icon");
}


const gchar* unity_files_lens_bookmark_get_mimetype (UnityFilesLensBookmark* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_mimetype;
	result = _tmp0_;
	return result;
}


void unity_files_lens_bookmark_set_mimetype (UnityFilesLensBookmark* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_mimetype);
	self->priv->_mimetype = _tmp1_;
	g_object_notify ((GObject *) self, "mimetype");
}


const gchar* unity_files_lens_bookmark_get_display_name (UnityFilesLensBookmark* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	result = _tmp0_;
	return result;
}


void unity_files_lens_bookmark_set_display_name (UnityFilesLensBookmark* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_display_name);
	self->priv->_display_name = _tmp1_;
	g_object_notify ((GObject *) self, "display-name");
}


const gchar* unity_files_lens_bookmark_get_dnd_uri (UnityFilesLensBookmark* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_dnd_uri;
	result = _tmp0_;
	return result;
}


void unity_files_lens_bookmark_set_dnd_uri (UnityFilesLensBookmark* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_dnd_uri);
	self->priv->_dnd_uri = _tmp1_;
	g_object_notify ((GObject *) self, "dnd-uri");
}


static void unity_files_lens_bookmark_class_init (UnityFilesLensBookmarkClass * klass) {
	unity_files_lens_bookmark_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityFilesLensBookmarkPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_files_lens_bookmark_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_files_lens_bookmark_set_property;
	G_OBJECT_CLASS (klass)->finalize = unity_files_lens_bookmark_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILES_LENS_BOOKMARK_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILES_LENS_BOOKMARK_ICON, g_param_spec_string ("icon", "icon", "icon", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILES_LENS_BOOKMARK_MIMETYPE, g_param_spec_string ("mimetype", "mimetype", "mimetype", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILES_LENS_BOOKMARK_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILES_LENS_BOOKMARK_DND_URI, g_param_spec_string ("dnd-uri", "dnd-uri", "dnd-uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void unity_files_lens_bookmark_instance_init (UnityFilesLensBookmark * self) {
	self->priv = UNITY_FILES_LENS_BOOKMARK_GET_PRIVATE (self);
}


static void unity_files_lens_bookmark_finalize (GObject* obj) {
	UnityFilesLensBookmark * self;
	self = UNITY_FILES_LENS_BOOKMARK (obj);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_icon);
	_g_free0 (self->priv->_mimetype);
	_g_free0 (self->priv->_display_name);
	_g_free0 (self->priv->_dnd_uri);
	__g_list_free__g_free0_0 (self->priv->index_terms);
	G_OBJECT_CLASS (unity_files_lens_bookmark_parent_class)->finalize (obj);
}


GType unity_files_lens_bookmark_get_type (void) {
	static volatile gsize unity_files_lens_bookmark_type_id__volatile = 0;
	if (g_once_init_enter (&unity_files_lens_bookmark_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityFilesLensBookmarkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_files_lens_bookmark_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityFilesLensBookmark), 0, (GInstanceInitFunc) unity_files_lens_bookmark_instance_init, NULL };
		GType unity_files_lens_bookmark_type_id;
		unity_files_lens_bookmark_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityFilesLensBookmark", &g_define_type_info, 0);
		g_once_init_leave (&unity_files_lens_bookmark_type_id__volatile, unity_files_lens_bookmark_type_id);
	}
	return unity_files_lens_bookmark_type_id__volatile;
}


static void _vala_unity_files_lens_bookmark_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityFilesLensBookmark * self;
	self = UNITY_FILES_LENS_BOOKMARK (object);
	switch (property_id) {
		case UNITY_FILES_LENS_BOOKMARK_URI:
		g_value_set_string (value, unity_files_lens_bookmark_get_uri (self));
		break;
		case UNITY_FILES_LENS_BOOKMARK_ICON:
		g_value_set_string (value, unity_files_lens_bookmark_get_icon (self));
		break;
		case UNITY_FILES_LENS_BOOKMARK_MIMETYPE:
		g_value_set_string (value, unity_files_lens_bookmark_get_mimetype (self));
		break;
		case UNITY_FILES_LENS_BOOKMARK_DISPLAY_NAME:
		g_value_set_string (value, unity_files_lens_bookmark_get_display_name (self));
		break;
		case UNITY_FILES_LENS_BOOKMARK_DND_URI:
		g_value_set_string (value, unity_files_lens_bookmark_get_dnd_uri (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_files_lens_bookmark_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityFilesLensBookmark * self;
	self = UNITY_FILES_LENS_BOOKMARK (object);
	switch (property_id) {
		case UNITY_FILES_LENS_BOOKMARK_URI:
		unity_files_lens_bookmark_set_uri (self, g_value_get_string (value));
		break;
		case UNITY_FILES_LENS_BOOKMARK_ICON:
		unity_files_lens_bookmark_set_icon (self, g_value_get_string (value));
		break;
		case UNITY_FILES_LENS_BOOKMARK_MIMETYPE:
		unity_files_lens_bookmark_set_mimetype (self, g_value_get_string (value));
		break;
		case UNITY_FILES_LENS_BOOKMARK_DISPLAY_NAME:
		unity_files_lens_bookmark_set_display_name (self, g_value_get_string (value));
		break;
		case UNITY_FILES_LENS_BOOKMARK_DND_URI:
		unity_files_lens_bookmark_set_dnd_uri (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void __lambda5_ (UnityFilesLensDevices* self, GVolumeMonitor* mon, GVolume* volume) {
	g_return_if_fail (mon != NULL);
	g_return_if_fail (volume != NULL);
	unity_files_lens_devices_update (self);
	g_signal_emit_by_name (self, "changed");
}


static void ___lambda5__g_volume_monitor_volume_added (GVolumeMonitor* _sender, GVolume* volume, gpointer self) {
	__lambda5_ (self, _sender, volume);
}


static void __lambda6_ (UnityFilesLensDevices* self, GVolumeMonitor* mon, GVolume* volume) {
	g_return_if_fail (mon != NULL);
	g_return_if_fail (volume != NULL);
	unity_files_lens_devices_update (self);
	g_signal_emit_by_name (self, "changed");
}


static void ___lambda6__g_volume_monitor_volume_removed (GVolumeMonitor* _sender, GVolume* volume, gpointer self) {
	__lambda6_ (self, _sender, volume);
}


static void __lambda7_ (UnityFilesLensDevices* self, GVolumeMonitor* mon, GVolume* volume) {
	g_return_if_fail (mon != NULL);
	g_return_if_fail (volume != NULL);
	unity_files_lens_devices_update (self);
	g_signal_emit_by_name (self, "changed");
}


static void ___lambda7__g_volume_monitor_volume_changed (GVolumeMonitor* _sender, GVolume* volume, gpointer self) {
	__lambda7_ (self, _sender, volume);
}


UnityFilesLensDevices* unity_files_lens_devices_construct (GType object_type) {
	UnityFilesLensDevices * self = NULL;
	GVolumeMonitor* _tmp0_ = NULL;
	GVolumeMonitor* _tmp1_;
	GVolumeMonitor* _tmp2_;
	GVolumeMonitor* _tmp3_;
	self = (UnityFilesLensDevices*) g_object_new (object_type, NULL);
	_tmp0_ = g_volume_monitor_get ();
	_g_object_unref0 (self->priv->volume_monitor);
	self->priv->volume_monitor = _tmp0_;
	unity_files_lens_devices_update (self);
	_tmp1_ = self->priv->volume_monitor;
	g_signal_connect_object (_tmp1_, "volume-added", (GCallback) ___lambda5__g_volume_monitor_volume_added, self, 0);
	_tmp2_ = self->priv->volume_monitor;
	g_signal_connect_object (_tmp2_, "volume-removed", (GCallback) ___lambda6__g_volume_monitor_volume_removed, self, 0);
	_tmp3_ = self->priv->volume_monitor;
	g_signal_connect_object (_tmp3_, "volume-changed", (GCallback) ___lambda7__g_volume_monitor_volume_changed, self, 0);
	return self;
}


UnityFilesLensDevices* unity_files_lens_devices_new (void) {
	return unity_files_lens_devices_construct (UNITY_FILES_LENS_TYPE_DEVICES);
}


static void unity_files_lens_devices_update (UnityFilesLensDevices* self) {
	GVolumeMonitor* _tmp0_;
	GList* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	__g_list_free__g_object_unref0_0 (self->priv->devices);
	self->priv->devices = NULL;
	_tmp0_ = self->priv->volume_monitor;
	_tmp1_ = g_volume_monitor_get_volumes (_tmp0_);
	{
		GList* volume_collection = NULL;
		GList* volume_it = NULL;
		volume_collection = _tmp1_;
		for (volume_it = volume_collection; volume_it != NULL; volume_it = volume_it->next) {
			GVolume* _tmp2_;
			GVolume* volume = NULL;
			_tmp2_ = _g_object_ref0 ((GVolume*) volume_it->data);
			volume = _tmp2_;
			{
				GVolume* _tmp3_;
				gchar* _tmp4_ = NULL;
				gchar* label;
				GVolume* _tmp5_;
				gchar* _tmp6_ = NULL;
				gchar* uuid;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				const gchar* _tmp9_;
				gboolean _tmp13_;
				gboolean _tmp20_;
				GVolume* _tmp21_;
				UnityFilesLensDevice* _tmp22_;
				UnityFilesLensDevice* device;
				UnityFilesLensDevice* _tmp23_;
				UnityFilesLensDevice* _tmp24_;
				_tmp3_ = volume;
				_tmp4_ = g_volume_get_identifier (_tmp3_, G_VOLUME_IDENTIFIER_KIND_LABEL);
				label = _tmp4_;
				_tmp5_ = volume;
				_tmp6_ = g_volume_get_identifier (_tmp5_, G_VOLUME_IDENTIFIER_KIND_UUID);
				uuid = _tmp6_;
				_tmp9_ = label;
				if (_tmp9_ == NULL) {
					_tmp8_ = TRUE;
				} else {
					const gchar* _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					_tmp10_ = label;
					_tmp11_ = strlen (_tmp10_);
					_tmp12_ = _tmp11_;
					_tmp8_ = _tmp12_ == 0;
				}
				_tmp13_ = _tmp8_;
				if (_tmp13_) {
					gboolean _tmp14_ = FALSE;
					const gchar* _tmp15_;
					gboolean _tmp19_;
					_tmp15_ = uuid;
					if (_tmp15_ == NULL) {
						_tmp14_ = TRUE;
					} else {
						const gchar* _tmp16_;
						gint _tmp17_;
						gint _tmp18_;
						_tmp16_ = uuid;
						_tmp17_ = strlen (_tmp16_);
						_tmp18_ = _tmp17_;
						_tmp14_ = _tmp18_ == 0;
					}
					_tmp19_ = _tmp14_;
					_tmp7_ = _tmp19_;
				} else {
					_tmp7_ = FALSE;
				}
				_tmp20_ = _tmp7_;
				if (_tmp20_) {
					_g_free0 (uuid);
					_g_free0 (label);
					_g_object_unref0 (volume);
					continue;
				}
				_tmp21_ = volume;
				_tmp22_ = unity_files_lens_device_new (_tmp21_);
				device = _tmp22_;
				_tmp23_ = device;
				_tmp24_ = _g_object_ref0 (_tmp23_);
				self->priv->devices = g_list_append (self->priv->devices, _tmp24_);
				_g_object_unref0 (device);
				_g_free0 (uuid);
				_g_free0 (label);
				_g_object_unref0 (volume);
			}
		}
		__g_list_free__g_object_unref0_0 (volume_collection);
	}
}


GList* unity_files_lens_devices_list (UnityFilesLensDevices* self) {
	GList* result = NULL;
	GList* _result_;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = NULL;
	_tmp0_ = self->priv->devices;
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
		device_collection = _tmp0_;
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
			UnityFilesLensDevice* _tmp1_;
			UnityFilesLensDevice* device = NULL;
			_tmp1_ = _g_object_ref0 ((UnityFilesLensDevice*) device_it->data);
			device = _tmp1_;
			{
				UnityFilesLensDevice* _tmp2_;
				UnityFilesLensDevice* _tmp3_;
				_tmp2_ = device;
				_tmp3_ = _g_object_ref0 (_tmp2_);
				_result_ = g_list_append (_result_, _tmp3_);
				_g_object_unref0 (device);
			}
		}
	}
	result = _result_;
	return result;
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


GList* unity_files_lens_devices_search (UnityFilesLensDevices* self, const gchar* search) {
	GList* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* normalized_search;
	GList* matches;
	GList* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (search != NULL, NULL);
	_tmp0_ = search;
	_tmp1_ = unity_files_lens_utils_normalize_string (_tmp0_);
	normalized_search = _tmp1_;
	matches = NULL;
	_tmp2_ = self->priv->devices;
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
		device_collection = _tmp2_;
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
			UnityFilesLensDevice* _tmp3_;
			UnityFilesLensDevice* device = NULL;
			_tmp3_ = _g_object_ref0 ((UnityFilesLensDevice*) device_it->data);
			device = _tmp3_;
			{
				UnityFilesLensDevice* _tmp4_;
				GList* _tmp5_ = NULL;
				_tmp4_ = device;
				_tmp5_ = unity_files_lens_device_get_index_terms (_tmp4_);
				{
					GList* term_collection = NULL;
					GList* term_it = NULL;
					term_collection = _tmp5_;
					for (term_it = term_collection; term_it != NULL; term_it = term_it->next) {
						gchar* _tmp6_;
						gchar* term = NULL;
						_tmp6_ = g_strdup ((const gchar*) term_it->data);
						term = _tmp6_;
						{
							const gchar* _tmp7_;
							const gchar* _tmp8_;
							gboolean _tmp9_ = FALSE;
							_tmp7_ = term;
							_tmp8_ = normalized_search;
							_tmp9_ = string_contains (_tmp7_, _tmp8_);
							if (_tmp9_) {
								UnityFilesLensDevice* _tmp10_;
								UnityFilesLensDevice* _tmp11_;
								_tmp10_ = device;
								_tmp11_ = _g_object_ref0 (_tmp10_);
								matches = g_list_append (matches, _tmp11_);
								_g_free0 (term);
								break;
							}
							_g_free0 (term);
						}
					}
				}
				_g_object_unref0 (device);
			}
		}
	}
	result = matches;
	_g_free0 (normalized_search);
	return result;
}


gboolean unity_files_lens_devices_launch_if_device (UnityFilesLensDevices* self, const gchar* uri, GError** error) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GList* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = uri;
	_tmp1_ = unity_files_lens_device_is_device_uri (_tmp0_);
	if (!_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->priv->devices;
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
		device_collection = _tmp2_;
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
			UnityFilesLensDevice* _tmp3_;
			UnityFilesLensDevice* device = NULL;
			_tmp3_ = _g_object_ref0 ((UnityFilesLensDevice*) device_it->data);
			device = _tmp3_;
			{
				UnityFilesLensDevice* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp4_ = device;
				_tmp5_ = unity_files_lens_device_get_uri (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = uri;
				if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
					UnityFilesLensDevice* _tmp8_;
					_tmp8_ = device;
					unity_files_lens_device_mount_and_open (_tmp8_, &_inner_error_);
					if (_inner_error_ != NULL) {
						g_propagate_error (error, _inner_error_);
						_g_object_unref0 (device);
						return FALSE;
					}
					result = TRUE;
					_g_object_unref0 (device);
					return result;
				}
				_g_object_unref0 (device);
			}
		}
	}
	result = FALSE;
	return result;
}


UnityFilesLensDevice* unity_files_lens_devices_get_device_from_uri (UnityFilesLensDevices* self, const gchar* uri) {
	UnityFilesLensDevice* result = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GList* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = uri;
	_tmp1_ = unity_files_lens_device_is_device_uri (_tmp0_);
	if (!_tmp1_) {
		result = NULL;
		return result;
	}
	_tmp2_ = self->priv->devices;
	{
		GList* device_collection = NULL;
		GList* device_it = NULL;
		device_collection = _tmp2_;
		for (device_it = device_collection; device_it != NULL; device_it = device_it->next) {
			UnityFilesLensDevice* _tmp3_;
			UnityFilesLensDevice* device = NULL;
			_tmp3_ = _g_object_ref0 ((UnityFilesLensDevice*) device_it->data);
			device = _tmp3_;
			{
				UnityFilesLensDevice* _tmp4_;
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp4_ = device;
				_tmp5_ = unity_files_lens_device_get_uri (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = uri;
				if (g_strcmp0 (_tmp6_, _tmp7_) == 0) {
					result = device;
					return result;
				}
				_g_object_unref0 (device);
			}
		}
	}
	result = NULL;
	return result;
}


static void unity_files_lens_devices_class_init (UnityFilesLensDevicesClass * klass) {
	unity_files_lens_devices_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityFilesLensDevicesPrivate));
	G_OBJECT_CLASS (klass)->finalize = unity_files_lens_devices_finalize;
	g_signal_new ("changed", UNITY_FILES_LENS_TYPE_DEVICES, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void unity_files_lens_devices_instance_init (UnityFilesLensDevices * self) {
	self->priv = UNITY_FILES_LENS_DEVICES_GET_PRIVATE (self);
}


static void unity_files_lens_devices_finalize (GObject* obj) {
	UnityFilesLensDevices * self;
	self = UNITY_FILES_LENS_DEVICES (obj);
	__g_list_free__g_object_unref0_0 (self->priv->devices);
	_g_object_unref0 (self->priv->volume_monitor);
	G_OBJECT_CLASS (unity_files_lens_devices_parent_class)->finalize (obj);
}


GType unity_files_lens_devices_get_type (void) {
	static volatile gsize unity_files_lens_devices_type_id__volatile = 0;
	if (g_once_init_enter (&unity_files_lens_devices_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityFilesLensDevicesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_files_lens_devices_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityFilesLensDevices), 0, (GInstanceInitFunc) unity_files_lens_devices_instance_init, NULL };
		GType unity_files_lens_devices_type_id;
		unity_files_lens_devices_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityFilesLensDevices", &g_define_type_info, 0);
		g_once_init_leave (&unity_files_lens_devices_type_id__volatile, unity_files_lens_devices_type_id);
	}
	return unity_files_lens_devices_type_id__volatile;
}


UnityFilesLensDevice* unity_files_lens_device_construct (GType object_type, GVolume* volume) {
	UnityFilesLensDevice * self = NULL;
	GVolume* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* name;
	GVolume* _tmp2_;
	GIcon* _tmp3_ = NULL;
	GIcon* icon;
	GIcon* _tmp4_;
	gchar* _tmp5_ = NULL;
	gchar* icon_name;
	GVolume* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* label;
	GVolume* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* uuid;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar* id;
	GVolume* _tmp27_;
	const gchar* _tmp28_;
	GIcon* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_ = NULL;
	g_return_val_if_fail (volume != NULL, NULL);
	_tmp0_ = volume;
	_tmp1_ = g_volume_get_name (_tmp0_);
	name = _tmp1_;
	_tmp2_ = volume;
	_tmp3_ = g_volume_get_icon (_tmp2_);
	icon = _tmp3_;
	_tmp4_ = icon;
	_tmp5_ = g_icon_to_string (_tmp4_);
	icon_name = _tmp5_;
	_tmp6_ = volume;
	_tmp7_ = g_volume_get_identifier (_tmp6_, G_VOLUME_IDENTIFIER_KIND_LABEL);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		gchar* _tmp10_;
		_tmp10_ = g_strdup ("");
		_g_free0 (_tmp8_);
		_tmp8_ = _tmp10_;
	}
	_tmp11_ = _tmp8_;
	_tmp12_ = g_strdup (_tmp11_);
	label = _tmp12_;
	_tmp13_ = volume;
	_tmp14_ = g_volume_get_identifier (_tmp13_, G_VOLUME_IDENTIFIER_KIND_UUID);
	_tmp15_ = _tmp14_;
	_tmp16_ = _tmp15_;
	if (_tmp16_ == NULL) {
		gchar* _tmp17_;
		_tmp17_ = g_strdup ("");
		_g_free0 (_tmp15_);
		_tmp15_ = _tmp17_;
	}
	_tmp18_ = _tmp15_;
	_tmp19_ = g_strdup (_tmp18_);
	uuid = _tmp19_;
	_tmp20_ = g_strconcat ("device://", uuid, NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat (_tmp21_, "-", NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = label;
	_tmp25_ = g_strconcat (_tmp23_, _tmp24_, NULL);
	_tmp26_ = _tmp25_;
	_g_free0 (_tmp23_);
	_g_free0 (_tmp21_);
	id = _tmp26_;
	_tmp27_ = volume;
	_tmp28_ = name;
	_tmp29_ = icon;
	_tmp30_ = icon_name;
	_tmp31_ = name;
	self = (UnityFilesLensDevice*) g_object_new (object_type, "volume", _tmp27_, "name", _tmp28_, "uri", id, "icon", _tmp29_, "icon-name", _tmp30_, "display-name", _tmp31_, "dnd-uri", id, NULL);
	__g_list_free__g_free0_0 (self->priv->index_terms_);
	self->priv->index_terms_ = NULL;
	_tmp32_ = name;
	_tmp33_ = unity_files_lens_utils_normalize_string (_tmp32_);
	self->priv->index_terms_ = g_list_append (self->priv->index_terms_, _tmp33_);
	_g_free0 (id);
	_g_free0 (uuid);
	_g_free0 (_tmp15_);
	_g_free0 (label);
	_g_free0 (_tmp8_);
	_g_free0 (icon_name);
	_g_object_unref0 (icon);
	_g_free0 (name);
	return self;
}


UnityFilesLensDevice* unity_files_lens_device_new (GVolume* volume) {
	return unity_files_lens_device_construct (UNITY_FILES_LENS_TYPE_DEVICE, volume);
}


GList* unity_files_lens_device_get_index_terms (UnityFilesLensDevice* self) {
	GList* result = NULL;
	GList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->index_terms_;
	result = _tmp0_;
	return result;
}


gboolean unity_files_lens_device_is_device_uri (const gchar* uri) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = uri;
	_tmp1_ = g_str_has_prefix (_tmp0_, "device://");
	result = _tmp1_;
	return result;
}


static void ___lambda4_ (UnityFilesLensDevice* self, GObject* obj, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (res != NULL);
	{
		GVolume* _tmp0_;
		GAsyncResult* _tmp1_;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
		_tmp0_ = self->priv->_volume;
		_tmp1_ = res;
		_tmp2_ = g_volume_mount_finish (_tmp0_, _tmp1_, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch13_g_error;
		}
		if (_tmp3_) {
			unity_files_lens_device_open_in_file_manager (self, &_inner_error_);
			if (_inner_error_ != NULL) {
				goto __catch13_g_error;
			}
		}
	}
	goto __finally13;
	__catch13_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = self->priv->_display_name;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("folder.vala:413: Failed to mount %s: %s", _tmp4_, _tmp6_);
		_g_error_free0 (e);
	}
	__finally13:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void ____lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	___lambda4_ (self, source_object, res);
	g_object_unref (self);
}


void unity_files_lens_device_mount_and_open (UnityFilesLensDevice* self, GError** error) {
	gboolean _tmp0_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = unity_files_lens_device_is_mounted (self);
	if (_tmp0_) {
		unity_files_lens_device_open_in_file_manager (self, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	} else {
		GVolume* _tmp1_;
		_tmp1_ = self->priv->_volume;
		g_volume_mount (_tmp1_, G_MOUNT_MOUNT_NONE, NULL, NULL, ____lambda4__gasync_ready_callback, g_object_ref (self));
	}
}


static gboolean unity_files_lens_device_is_mounted (UnityFilesLensDevice* self) {
	gboolean result = FALSE;
	GVolume* _tmp0_;
	GMount* _tmp1_ = NULL;
	GMount* mount;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_volume;
	_tmp1_ = g_volume_get_mount (_tmp0_);
	mount = _tmp1_;
	result = mount != NULL;
	_g_object_unref0 (mount);
	return result;
}


static void unity_files_lens_device_open_in_file_manager (UnityFilesLensDevice* self, GError** error) {
	gboolean _tmp0_ = FALSE;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = unity_files_lens_device_is_mounted (self);
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = unity_files_lens_device_get_volume_uri (self);
	_tmp2_ = _tmp1_;
	g_app_info_launch_default_for_uri (_tmp2_, NULL, &_inner_error_);
	_g_free0 (_tmp2_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static gchar* unity_files_lens_device_get_volume_uri (UnityFilesLensDevice* self) {
	gchar* result = NULL;
	GFile* _tmp0_ = NULL;
	GFile* root;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = unity_files_lens_device_get_root_file (self);
	root = _tmp0_;
	_tmp1_ = root;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_object_unref0 (root);
		return result;
	}
	_tmp2_ = root;
	_tmp3_ = g_file_get_uri (_tmp2_);
	result = _tmp3_;
	_g_object_unref0 (root);
	return result;
}


GFile* unity_files_lens_device_get_root_file (UnityFilesLensDevice* self) {
	GFile* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = unity_files_lens_device_is_mounted (self);
	if (_tmp0_) {
		GVolume* _tmp1_;
		GMount* _tmp2_ = NULL;
		GMount* mount;
		GMount* _tmp3_;
		GMount* _tmp4_;
		GFile* _tmp5_ = NULL;
		_tmp1_ = self->priv->_volume;
		_tmp2_ = g_volume_get_mount (_tmp1_);
		mount = _tmp2_;
		_tmp3_ = mount;
		if (_tmp3_ == NULL) {
			result = NULL;
			_g_object_unref0 (mount);
			return result;
		}
		_tmp4_ = mount;
		_tmp5_ = g_mount_get_root (_tmp4_);
		result = _tmp5_;
		_g_object_unref0 (mount);
		return result;
	} else {
		GVolume* _tmp6_;
		GFile* _tmp7_ = NULL;
		_tmp6_ = self->priv->_volume;
		_tmp7_ = g_volume_get_activation_root (_tmp6_);
		result = _tmp7_;
		return result;
	}
}


GVolume* unity_files_lens_device_get_volume (UnityFilesLensDevice* self) {
	GVolume* result;
	GVolume* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_volume;
	result = _tmp0_;
	return result;
}


void unity_files_lens_device_set_volume (UnityFilesLensDevice* self, GVolume* value) {
	GVolume* _tmp0_;
	GVolume* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_volume);
	self->priv->_volume = _tmp1_;
	g_object_notify ((GObject *) self, "volume");
}


const gchar* unity_files_lens_device_get_name (UnityFilesLensDevice* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}


void unity_files_lens_device_set_name (UnityFilesLensDevice* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_name);
	self->priv->_name = _tmp1_;
	g_object_notify ((GObject *) self, "name");
}


const gchar* unity_files_lens_device_get_uri (UnityFilesLensDevice* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_uri;
	result = _tmp0_;
	return result;
}


void unity_files_lens_device_set_uri (UnityFilesLensDevice* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_uri);
	self->priv->_uri = _tmp1_;
	g_object_notify ((GObject *) self, "uri");
}


GIcon* unity_files_lens_device_get_icon (UnityFilesLensDevice* self) {
	GIcon* result;
	GIcon* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon;
	result = _tmp0_;
	return result;
}


void unity_files_lens_device_set_icon (UnityFilesLensDevice* self, GIcon* value) {
	GIcon* _tmp0_;
	GIcon* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_icon);
	self->priv->_icon = _tmp1_;
	g_object_notify ((GObject *) self, "icon");
}


const gchar* unity_files_lens_device_get_icon_name (UnityFilesLensDevice* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_icon_name;
	result = _tmp0_;
	return result;
}


void unity_files_lens_device_set_icon_name (UnityFilesLensDevice* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_icon_name);
	self->priv->_icon_name = _tmp1_;
	g_object_notify ((GObject *) self, "icon-name");
}


const gchar* unity_files_lens_device_get_display_name (UnityFilesLensDevice* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display_name;
	result = _tmp0_;
	return result;
}


void unity_files_lens_device_set_display_name (UnityFilesLensDevice* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_display_name);
	self->priv->_display_name = _tmp1_;
	g_object_notify ((GObject *) self, "display-name");
}


const gchar* unity_files_lens_device_get_dnd_uri (UnityFilesLensDevice* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_dnd_uri;
	result = _tmp0_;
	return result;
}


void unity_files_lens_device_set_dnd_uri (UnityFilesLensDevice* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_dnd_uri);
	self->priv->_dnd_uri = _tmp1_;
	g_object_notify ((GObject *) self, "dnd-uri");
}


static void unity_files_lens_device_class_init (UnityFilesLensDeviceClass * klass) {
	unity_files_lens_device_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityFilesLensDevicePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_files_lens_device_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_files_lens_device_set_property;
	G_OBJECT_CLASS (klass)->finalize = unity_files_lens_device_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILES_LENS_DEVICE_VOLUME, g_param_spec_object ("volume", "volume", "volume", g_volume_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILES_LENS_DEVICE_NAME, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILES_LENS_DEVICE_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILES_LENS_DEVICE_ICON, g_param_spec_object ("icon", "icon", "icon", G_TYPE_ICON, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILES_LENS_DEVICE_ICON_NAME, g_param_spec_string ("icon-name", "icon-name", "icon-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILES_LENS_DEVICE_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILES_LENS_DEVICE_DND_URI, g_param_spec_string ("dnd-uri", "dnd-uri", "dnd-uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void unity_files_lens_device_instance_init (UnityFilesLensDevice * self) {
	self->priv = UNITY_FILES_LENS_DEVICE_GET_PRIVATE (self);
}


static void unity_files_lens_device_finalize (GObject* obj) {
	UnityFilesLensDevice * self;
	self = UNITY_FILES_LENS_DEVICE (obj);
	_g_object_unref0 (self->priv->_volume);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_uri);
	_g_object_unref0 (self->priv->_icon);
	_g_free0 (self->priv->_icon_name);
	_g_free0 (self->priv->_display_name);
	_g_free0 (self->priv->_dnd_uri);
	__g_list_free__g_free0_0 (self->priv->index_terms_);
	G_OBJECT_CLASS (unity_files_lens_device_parent_class)->finalize (obj);
}


GType unity_files_lens_device_get_type (void) {
	static volatile gsize unity_files_lens_device_type_id__volatile = 0;
	if (g_once_init_enter (&unity_files_lens_device_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityFilesLensDeviceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_files_lens_device_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityFilesLensDevice), 0, (GInstanceInitFunc) unity_files_lens_device_instance_init, NULL };
		GType unity_files_lens_device_type_id;
		unity_files_lens_device_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityFilesLensDevice", &g_define_type_info, 0);
		g_once_init_leave (&unity_files_lens_device_type_id__volatile, unity_files_lens_device_type_id);
	}
	return unity_files_lens_device_type_id__volatile;
}


static void _vala_unity_files_lens_device_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityFilesLensDevice * self;
	self = UNITY_FILES_LENS_DEVICE (object);
	switch (property_id) {
		case UNITY_FILES_LENS_DEVICE_VOLUME:
		g_value_set_object (value, unity_files_lens_device_get_volume (self));
		break;
		case UNITY_FILES_LENS_DEVICE_NAME:
		g_value_set_string (value, unity_files_lens_device_get_name (self));
		break;
		case UNITY_FILES_LENS_DEVICE_URI:
		g_value_set_string (value, unity_files_lens_device_get_uri (self));
		break;
		case UNITY_FILES_LENS_DEVICE_ICON:
		g_value_set_object (value, unity_files_lens_device_get_icon (self));
		break;
		case UNITY_FILES_LENS_DEVICE_ICON_NAME:
		g_value_set_string (value, unity_files_lens_device_get_icon_name (self));
		break;
		case UNITY_FILES_LENS_DEVICE_DISPLAY_NAME:
		g_value_set_string (value, unity_files_lens_device_get_display_name (self));
		break;
		case UNITY_FILES_LENS_DEVICE_DND_URI:
		g_value_set_string (value, unity_files_lens_device_get_dnd_uri (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_files_lens_device_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityFilesLensDevice * self;
	self = UNITY_FILES_LENS_DEVICE (object);
	switch (property_id) {
		case UNITY_FILES_LENS_DEVICE_VOLUME:
		unity_files_lens_device_set_volume (self, g_value_get_object (value));
		break;
		case UNITY_FILES_LENS_DEVICE_NAME:
		unity_files_lens_device_set_name (self, g_value_get_string (value));
		break;
		case UNITY_FILES_LENS_DEVICE_URI:
		unity_files_lens_device_set_uri (self, g_value_get_string (value));
		break;
		case UNITY_FILES_LENS_DEVICE_ICON:
		unity_files_lens_device_set_icon (self, g_value_get_object (value));
		break;
		case UNITY_FILES_LENS_DEVICE_ICON_NAME:
		unity_files_lens_device_set_icon_name (self, g_value_get_string (value));
		break;
		case UNITY_FILES_LENS_DEVICE_DISPLAY_NAME:
		unity_files_lens_device_set_display_name (self, g_value_get_string (value));
		break;
		case UNITY_FILES_LENS_DEVICE_DND_URI:
		unity_files_lens_device_set_dnd_uri (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



