/*
 * Copyright (C) 2012 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Pawel Stolowski <pawel.stolowski@canonical.com>
 */

namespace Unity.VideoLens
{
  public class RemoteUri
  {
    public string uri { get; set; }
    public string title { get; set; }
    public string icon { get; set; }
    public string details_uri { get; set; }

    public RemoteUri (string uri, string title, string icon, string details_uri)
    {
      this.uri = uri;
      this.title = title;
      this.icon = icon;
      this.details_uri = details_uri;
    }

    public static RemoteUri? from_rawuri (string raw_uri)
    {
      RemoteUri uri = null;
      string[] args = raw_uri.split ("lens-meta://", 4);
      if (args.length == 4)
      {
        uri = new RemoteUri (args[0], args[1], args[2], args[3]);
      }
      return uri;
    }

    public string to_rawuri ()
    {
      return string.join ("lens-meta://", uri, title, icon, details_uri);
    }
  }
}