/* utils.c generated by valac, the Vala compiler
 * generated from utils.vala, do not modify */

/*
 * Copyright (C) 2010 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <unity.h>
#include <gio/gio.h>
#include <gee.h>
#include <dee.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define UNITY_APPLICATIONS_PLACE_TYPE_RESULTS_COLUMN (unity_applications_place_results_column_get_type ())

typedef enum  {
	UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_URI = 0,
	UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_ICON_HINT,
	UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_GROUP_ID,
	UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_MIMETYPE,
	UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_DISPLAY_NAME,
	UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_COMMENT
} UnityApplicationsPlaceResultsColumn;



char* unity_applications_place_utils_get_desktop_id_for_actor (const char* actor);
GAppInfo* unity_applications_place_utils_get_app_info_for_actor (const char* actor);
gboolean unity_applications_place_utils_check_actor_has_category (const char* actor, GeeSet* categories);
gboolean unity_applications_place_utils_search_has_really_changed (UnityPlaceSearch* old_search, UnityPlaceSearch* new_search);
GType unity_applications_place_results_column_get_type (void) G_GNUC_CONST;
void unity_applications_place_utils_apply_uri_filter (GeeSet* valid_uris, DeeResultSet* filter_set);
static int _vala_strcmp0 (const char * str1, const char * str2);



GAppInfo* unity_applications_place_utils_get_app_info_for_actor (const char* actor) {
	GAppInfo* result = NULL;
	char* desktop_id;
	UnityAppInfoManager* _tmp0_;
	GAppInfo* _tmp1_;
	g_return_val_if_fail (actor != NULL, NULL);
	desktop_id = unity_applications_place_utils_get_desktop_id_for_actor (actor);
	result = (_tmp1_ = unity_app_info_manager_lookup (_tmp0_ = unity_app_info_manager_get_instance (), desktop_id), _g_object_unref0 (_tmp0_), _tmp1_);
	_g_free0 (desktop_id);
	return result;
	_g_free0 (desktop_id);
}


gboolean unity_applications_place_utils_check_actor_has_category (const char* actor, GeeSet* categories) {
	gboolean result = FALSE;
	UnityAppInfoManager* appman;
	char* desktop_id;
	GAppInfo* appinfo;
	GeeList* actor_cats;
	g_return_val_if_fail (actor != NULL, FALSE);
	if (categories == NULL) {
		result = FALSE;
		return result;
	}
	appman = unity_app_info_manager_get_instance ();
	desktop_id = unity_applications_place_utils_get_desktop_id_for_actor (actor);
	appinfo = unity_app_info_manager_lookup (appman, desktop_id);
	if (appinfo == NULL) {
		result = FALSE;
		_g_object_unref0 (appinfo);
		_g_free0 (desktop_id);
		_g_object_unref0 (appman);
		return result;
	}
	actor_cats = unity_app_info_manager_get_categories (appman, desktop_id);
	if (actor_cats == NULL) {
		result = FALSE;
		_g_object_unref0 (actor_cats);
		_g_object_unref0 (appinfo);
		_g_free0 (desktop_id);
		_g_object_unref0 (appman);
		return result;
	}
	{
		GeeIterator* _cat_it;
		_cat_it = gee_iterable_iterator ((GeeIterable*) actor_cats);
		while (TRUE) {
			char* cat;
			if (!gee_iterator_next (_cat_it)) {
				break;
			}
			cat = (char*) gee_iterator_get (_cat_it);
			if (gee_collection_contains ((GeeCollection*) categories, cat)) {
				result = TRUE;
				_g_free0 (cat);
				_g_object_unref0 (_cat_it);
				_g_object_unref0 (actor_cats);
				_g_object_unref0 (appinfo);
				_g_free0 (desktop_id);
				_g_object_unref0 (appman);
				return result;
			}
			_g_free0 (cat);
		}
		_g_object_unref0 (_cat_it);
	}
	result = FALSE;
	_g_object_unref0 (actor_cats);
	_g_object_unref0 (appinfo);
	_g_free0 (desktop_id);
	_g_object_unref0 (appman);
	return result;
}


static char* string_substring (const char* self, glong offset, glong len) {
	char* result = NULL;
	glong string_length;
	const char* start;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (offset < 0) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= 0, NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < 0) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	start = g_utf8_offset_to_pointer (self, offset);
	result = g_strndup (start, ((gchar*) g_utf8_offset_to_pointer (start, len)) - ((gchar*) start));
	return result;
}


char* unity_applications_place_utils_get_desktop_id_for_actor (const char* actor) {
	char* result = NULL;
	g_return_val_if_fail (actor != NULL, NULL);
	if (g_str_has_prefix (actor, "application://")) {
		char* _tmp0_;
		char* _tmp1_;
		result = (_tmp1_ = g_strdup (_tmp0_ = string_substring (actor, (glong) 14, -1)), _g_free0 (_tmp0_), _tmp1_);
		return result;
	} else {
		if (g_str_has_prefix (actor, "app://")) {
			char* _tmp2_;
			char* _tmp3_;
			result = (_tmp3_ = g_strdup (_tmp2_ = string_substring (actor, (glong) 6, -1)), _g_free0 (_tmp2_), _tmp3_);
			return result;
		} else {
			if (g_str_has_prefix (actor, "/")) {
				GFile* f;
				f = g_file_new_for_path (actor);
				result = g_file_get_basename (f);
				_g_object_unref0 (f);
				return result;
			}
		}
	}
	result = g_strdup (actor);
	return result;
}


static char* string_strip (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


gboolean unity_applications_place_utils_search_has_really_changed (UnityPlaceSearch* old_search, UnityPlaceSearch* new_search) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	char* s1;
	char* s2;
	if (old_search == NULL) {
		_tmp0_ = new_search == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	s1 = NULL;
	s2 = NULL;
	if (old_search == NULL) {
		char* _tmp1_;
		gboolean _tmp2_ = FALSE;
		s1 = (_tmp1_ = unity_place_search_get_search_string (new_search), _g_free0 (s1), _tmp1_);
		if (s1 == NULL) {
			_tmp2_ = TRUE;
		} else {
			char* _tmp3_;
			_tmp2_ = _vala_strcmp0 (_tmp3_ = string_strip (s1), "") == 0;
			_g_free0 (_tmp3_);
		}
		if (_tmp2_) {
			result = FALSE;
			_g_free0 (s2);
			_g_free0 (s1);
			return result;
		} else {
			result = TRUE;
			_g_free0 (s2);
			_g_free0 (s1);
			return result;
		}
	} else {
		if (new_search == NULL) {
			char* _tmp4_;
			gboolean _tmp5_ = FALSE;
			s2 = (_tmp4_ = unity_place_search_get_search_string (old_search), _g_free0 (s2), _tmp4_);
			if (s2 == NULL) {
				_tmp5_ = TRUE;
			} else {
				char* _tmp6_;
				_tmp5_ = _vala_strcmp0 (_tmp6_ = string_strip (s2), "") == 0;
				_g_free0 (_tmp6_);
			}
			if (_tmp5_) {
				result = FALSE;
				_g_free0 (s2);
				_g_free0 (s1);
				return result;
			} else {
				result = TRUE;
				_g_free0 (s2);
				_g_free0 (s1);
				return result;
			}
		} else {
			char* _tmp7_;
			char* _tmp8_;
			s1 = (_tmp7_ = unity_place_search_get_search_string (new_search), _g_free0 (s1), _tmp7_);
			s2 = (_tmp8_ = unity_place_search_get_search_string (old_search), _g_free0 (s2), _tmp8_);
			if (s1 == NULL) {
				gboolean _tmp9_ = FALSE;
				if (s2 == NULL) {
					_tmp9_ = TRUE;
				} else {
					char* _tmp10_;
					_tmp9_ = _vala_strcmp0 (_tmp10_ = string_strip (s2), "") == 0;
					_g_free0 (_tmp10_);
				}
				if (_tmp9_) {
					result = FALSE;
					_g_free0 (s2);
					_g_free0 (s1);
					return result;
				} else {
					result = TRUE;
					_g_free0 (s2);
					_g_free0 (s1);
					return result;
				}
			} else {
				if (s2 == NULL) {
					gboolean _tmp11_ = FALSE;
					if (s1 == NULL) {
						_tmp11_ = TRUE;
					} else {
						char* _tmp12_;
						_tmp11_ = _vala_strcmp0 (_tmp12_ = string_strip (s1), "") == 0;
						_g_free0 (_tmp12_);
					}
					if (_tmp11_) {
						result = FALSE;
						_g_free0 (s2);
						_g_free0 (s1);
						return result;
					} else {
						result = TRUE;
						_g_free0 (s2);
						_g_free0 (s1);
						return result;
					}
				} else {
					char* _tmp14_;
					char* _tmp13_;
					gboolean _tmp15_;
					result = (_tmp15_ = _vala_strcmp0 (_tmp13_ = string_strip (s1), _tmp14_ = string_strip (s2)) != 0, _g_free0 (_tmp14_), _g_free0 (_tmp13_), _tmp15_);
					_g_free0 (s2);
					_g_free0 (s1);
					return result;
				}
			}
		}
	}
	_g_free0 (s2);
	_g_free0 (s1);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void unity_applications_place_utils_apply_uri_filter (GeeSet* valid_uris, DeeResultSet* filter_set) {
	DeeModel* model;
	guint n_removed;
	g_return_if_fail (valid_uris != NULL);
	g_return_if_fail (filter_set != NULL);
	model = _g_object_ref0 (dee_result_set_get_model (filter_set));
	n_removed = (guint) 0;
	{
		DeeResultSet* _row_it;
		DeeModelIter* row;
		_row_it = _vala_dee_result_set_iterator (filter_set);
		row = NULL;
		while (TRUE) {
			if (!((row = _vala_dee_result_set_next_value (_row_it)) != NULL)) {
				break;
			}
			if (!gee_collection_contains ((GeeCollection*) valid_uris, dee_model_get_string (model, row, (guint) UNITY_APPLICATIONS_PLACE_RESULTS_COLUMN_URI))) {
				dee_model_remove (model, row);
				n_removed++;
			}
		}
		_g_object_unref0 (_row_it);
	}
	g_debug ("utils.vala:143: Removed %u rows from result set", n_removed);
	_g_object_unref0 (model);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




