/* folder.c generated by valac 0.11.7, the Vala compiler
 * generated from folder.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gstdio.h>


#define UNITY_FILES_PLACE_TYPE_BOOKMARKS (unity_files_place_bookmarks_get_type ())
#define UNITY_FILES_PLACE_BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_FILES_PLACE_TYPE_BOOKMARKS, UnityFilesPlaceBookmarks))
#define UNITY_FILES_PLACE_BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_FILES_PLACE_TYPE_BOOKMARKS, UnityFilesPlaceBookmarksClass))
#define UNITY_FILES_PLACE_IS_BOOKMARKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_FILES_PLACE_TYPE_BOOKMARKS))
#define UNITY_FILES_PLACE_IS_BOOKMARKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_FILES_PLACE_TYPE_BOOKMARKS))
#define UNITY_FILES_PLACE_BOOKMARKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_FILES_PLACE_TYPE_BOOKMARKS, UnityFilesPlaceBookmarksClass))

typedef struct _UnityFilesPlaceBookmarks UnityFilesPlaceBookmarks;
typedef struct _UnityFilesPlaceBookmarksClass UnityFilesPlaceBookmarksClass;
typedef struct _UnityFilesPlaceBookmarksPrivate UnityFilesPlaceBookmarksPrivate;

#define UNITY_FILES_PLACE_TYPE_BOOKMARK (unity_files_place_bookmark_get_type ())
#define UNITY_FILES_PLACE_BOOKMARK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_FILES_PLACE_TYPE_BOOKMARK, UnityFilesPlaceBookmark))
#define UNITY_FILES_PLACE_BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_FILES_PLACE_TYPE_BOOKMARK, UnityFilesPlaceBookmarkClass))
#define UNITY_FILES_PLACE_IS_BOOKMARK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_FILES_PLACE_TYPE_BOOKMARK))
#define UNITY_FILES_PLACE_IS_BOOKMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_FILES_PLACE_TYPE_BOOKMARK))
#define UNITY_FILES_PLACE_BOOKMARK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_FILES_PLACE_TYPE_BOOKMARK, UnityFilesPlaceBookmarkClass))

typedef struct _UnityFilesPlaceBookmark UnityFilesPlaceBookmark;
typedef struct _UnityFilesPlaceBookmarkClass UnityFilesPlaceBookmarkClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UnityFilesPlaceBookmarkPrivate UnityFilesPlaceBookmarkPrivate;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

struct _UnityFilesPlaceBookmarks {
	GObject parent_instance;
	UnityFilesPlaceBookmarksPrivate * priv;
};

struct _UnityFilesPlaceBookmarksClass {
	GObjectClass parent_class;
};

struct _UnityFilesPlaceBookmarksPrivate {
	GList* bookmarks;
	gchar* bookmarks_file;
	GFileMonitor* monitor;
};

struct _UnityFilesPlaceBookmark {
	GObject parent_instance;
	UnityFilesPlaceBookmarkPrivate * priv;
};

struct _UnityFilesPlaceBookmarkClass {
	GObjectClass parent_class;
};

struct _UnityFilesPlaceBookmarkPrivate {
	gchar* _uri;
	gchar* _icon;
	gchar* _mimetype;
	gchar* _display_name;
	GList* index_terms;
};


static gpointer unity_files_place_bookmarks_parent_class = NULL;
static gpointer unity_files_place_bookmark_parent_class = NULL;

GType unity_files_place_bookmarks_get_type (void) G_GNUC_CONST;
GType unity_files_place_bookmark_get_type (void) G_GNUC_CONST;
#define UNITY_FILES_PLACE_BOOKMARKS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_FILES_PLACE_TYPE_BOOKMARKS, UnityFilesPlaceBookmarksPrivate))
enum  {
	UNITY_FILES_PLACE_BOOKMARKS_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
UnityFilesPlaceBookmarks* unity_files_place_bookmarks_new (void);
UnityFilesPlaceBookmarks* unity_files_place_bookmarks_construct (GType object_type);
static void unity_files_place_bookmarks_update (UnityFilesPlaceBookmarks* self);
static void _lambda0_ (GFileMonitor* mon, GFile* file, GFile* other_file, GFileMonitorEvent event_type, UnityFilesPlaceBookmarks* self);
static void __lambda0__g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self);
UnityFilesPlaceBookmark* unity_files_place_bookmark_new (const gchar* uri, const gchar* mimetype, const gchar* display_name);
UnityFilesPlaceBookmark* unity_files_place_bookmark_construct (GType object_type, const gchar* uri, const gchar* mimetype, const gchar* display_name);
GList* unity_files_place_bookmarks_list (UnityFilesPlaceBookmarks* self);
GList* unity_files_place_bookmarks_prefix_search (UnityFilesPlaceBookmarks* self, const gchar* search);
gchar* unity_files_place_utils_normalize_string (const gchar* input);
GList* unity_files_place_bookmark_get_index_terms (UnityFilesPlaceBookmark* self);
static void unity_files_place_bookmarks_finalize (GObject* obj);
#define UNITY_FILES_PLACE_BOOKMARK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_FILES_PLACE_TYPE_BOOKMARK, UnityFilesPlaceBookmarkPrivate))
enum  {
	UNITY_FILES_PLACE_BOOKMARK_DUMMY_PROPERTY,
	UNITY_FILES_PLACE_BOOKMARK_URI,
	UNITY_FILES_PLACE_BOOKMARK_ICON,
	UNITY_FILES_PLACE_BOOKMARK_MIMETYPE,
	UNITY_FILES_PLACE_BOOKMARK_DISPLAY_NAME
};
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
gchar* unity_files_place_utils_get_icon_for_uri (const gchar* uri, const gchar* mimetype);
const gchar* unity_files_place_bookmark_get_uri (UnityFilesPlaceBookmark* self);
void unity_files_place_bookmark_set_uri (UnityFilesPlaceBookmark* self, const gchar* value);
const gchar* unity_files_place_bookmark_get_icon (UnityFilesPlaceBookmark* self);
void unity_files_place_bookmark_set_icon (UnityFilesPlaceBookmark* self, const gchar* value);
const gchar* unity_files_place_bookmark_get_mimetype (UnityFilesPlaceBookmark* self);
void unity_files_place_bookmark_set_mimetype (UnityFilesPlaceBookmark* self, const gchar* value);
const gchar* unity_files_place_bookmark_get_display_name (UnityFilesPlaceBookmark* self);
void unity_files_place_bookmark_set_display_name (UnityFilesPlaceBookmark* self, const gchar* value);
static void unity_files_place_bookmark_finalize (GObject* obj);
static void _vala_unity_files_place_bookmark_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_files_place_bookmark_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _lambda0_ (GFileMonitor* mon, GFile* file, GFile* other_file, GFileMonitorEvent event_type, UnityFilesPlaceBookmarks* self) {
	g_return_if_fail (mon != NULL);
	g_return_if_fail (file != NULL);
	g_debug ("folder.vala:41: Bookmarks changed. Updating.");
	unity_files_place_bookmarks_update (self);
	g_signal_emit_by_name (self, "changed");
}


static void __lambda0__g_file_monitor_changed (GFileMonitor* _sender, GFile* file, GFile* other_file, GFileMonitorEvent event_type, gpointer self) {
	_lambda0_ (_sender, file, other_file, event_type, self);
}


UnityFilesPlaceBookmarks* unity_files_place_bookmarks_construct (GType object_type) {
	UnityFilesPlaceBookmarks * self = NULL;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	GFile* _tmp4_;
	GFileMonitor* _tmp5_ = NULL;
	GFileMonitor* _tmp6_;
	GFileMonitor* _tmp7_;
	GFileMonitor* _tmp8_;
	GError * _inner_error_ = NULL;
	self = (UnityFilesPlaceBookmarks*) g_object_new (object_type, NULL);
	_tmp0_ = g_get_home_dir ();
	_tmp1_ = string_to_string (_tmp0_);
	_tmp2_ = g_strconcat (_tmp1_, "/.gtk-bookmarks", NULL);
	_g_free0 (self->priv->bookmarks_file);
	self->priv->bookmarks_file = _tmp2_;
	unity_files_place_bookmarks_update (self);
	_tmp3_ = g_file_new_for_path (self->priv->bookmarks_file);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_file_monitor (_tmp4_, G_FILE_MONITOR_NONE, NULL, &_inner_error_);
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp4_);
	_tmp7_ = _tmp6_;
	if (_inner_error_ != NULL) {
		goto __catch10_g_error;
	}
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (self->priv->monitor);
	self->priv->monitor = _tmp8_;
	g_file_monitor_set_rate_limit (self->priv->monitor, 2000);
	g_signal_connect_object (self->priv->monitor, "changed", (GCallback) __lambda0__g_file_monitor_changed, self, 0);
	goto __finally10;
	__catch10_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("folder.vala:46: Failed to install file monitor on %s. Bookmarks monito" \
"ring disabled: %s", self->priv->bookmarks_file, e->message);
		_g_error_free0 (e);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


UnityFilesPlaceBookmarks* unity_files_place_bookmarks_new (void) {
	return unity_files_place_bookmarks_construct (UNITY_FILES_PLACE_TYPE_BOOKMARKS);
}


static void unity_files_place_bookmarks_update (UnityFilesPlaceBookmarks* self) {
	gchar* contents = NULL;
	gchar* _tmp0_ = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** favorites;
	gint favorites_length1;
	gint _favorites_size_;
	gchar* _tmp3_;
	gchar* mimetype;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	__g_list_free__g_object_unref0_0 (self->priv->bookmarks);
	self->priv->bookmarks = NULL;
	g_file_get_contents (self->priv->bookmarks_file, &_tmp0_, NULL, &_inner_error_);
	_g_free0 (contents);
	contents = _tmp0_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_FILE_ERROR) {
			goto __catch11_g_file_error;
		}
		_g_free0 (contents);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	goto __finally11;
	__catch11_g_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("folder.vala:60: Failed to read favorites: %s", e->message);
		_g_error_free0 (e);
		_g_free0 (contents);
		return;
	}
	__finally11:
	if (_inner_error_ != NULL) {
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp2_ = _tmp1_ = g_strsplit (contents, "\n", 0);
	favorites = _tmp2_;
	favorites_length1 = _vala_array_length (_tmp1_);
	_favorites_size_ = _vala_array_length (_tmp1_);
	_tmp3_ = g_strdup ("inode/directory");
	mimetype = _tmp3_;
	{
		gchar** uri_collection;
		int uri_collection_length1;
		int uri_it;
		uri_collection = favorites;
		uri_collection_length1 = favorites_length1;
		for (uri_it = 0; uri_it < favorites_length1; uri_it = uri_it + 1) {
			gchar* _tmp4_;
			gchar* uri;
			_tmp4_ = g_strdup (uri_collection[uri_it]);
			uri = _tmp4_;
			{
				gchar** _tmp5_;
				gchar** _tmp6_ = NULL;
				gchar** parts;
				gint parts_length1;
				gint _parts_size_;
				gchar* display_name = NULL;
				UnityFilesPlaceBookmark* _tmp12_ = NULL;
				UnityFilesPlaceBookmark* bookmark;
				UnityFilesPlaceBookmark* _tmp13_;
				if (g_strcmp0 (uri, "") == 0) {
					_g_free0 (uri);
					continue;
				}
				_tmp6_ = _tmp5_ = g_strsplit (uri, " ", 2);
				parts = _tmp6_;
				parts_length1 = _vala_array_length (_tmp5_);
				_parts_size_ = _vala_array_length (_tmp5_);
				if (parts_length1 == 1) {
					gchar* _tmp7_ = NULL;
					gchar* _tmp8_ = NULL;
					_tmp7_ = g_uri_unescape_string (uri, NULL);
					_g_free0 (display_name);
					display_name = _tmp7_;
					_tmp8_ = g_filename_display_basename (display_name);
					_g_free0 (display_name);
					display_name = _tmp8_;
				} else {
					if (parts_length1 == 2) {
						gchar* _tmp9_;
						gchar* _tmp10_;
						_tmp9_ = g_strdup (parts[0]);
						_g_free0 (uri);
						uri = _tmp9_;
						_tmp10_ = g_strdup (parts[1]);
						_g_free0 (display_name);
						display_name = _tmp10_;
					} else {
						gchar* _tmp11_;
						g_warning ("folder.vala:88: Internal error computing display name for favorite '%s" \
"'", uri);
						_tmp11_ = g_strdup (uri);
						_g_free0 (display_name);
						display_name = _tmp11_;
					}
				}
				_tmp12_ = unity_files_place_bookmark_new (uri, mimetype, display_name);
				bookmark = _tmp12_;
				_tmp13_ = _g_object_ref0 (bookmark);
				self->priv->bookmarks = g_list_append (self->priv->bookmarks, _tmp13_);
				_g_object_unref0 (bookmark);
				_g_free0 (display_name);
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (uri);
			}
		}
	}
	_g_free0 (mimetype);
	favorites = (_vala_array_free (favorites, favorites_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (contents);
}


GList* unity_files_place_bookmarks_list (UnityFilesPlaceBookmarks* self) {
	GList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->bookmarks;
	return result;
}


GList* unity_files_place_bookmarks_prefix_search (UnityFilesPlaceBookmarks* self, const gchar* search) {
	GList* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* prefix;
	GList* matches;
	GList* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (search != NULL, NULL);
	_tmp0_ = unity_files_place_utils_normalize_string (search);
	prefix = _tmp0_;
	matches = NULL;
	{
		GList* bookmark_collection;
		GList* bookmark_it;
		bookmark_collection = self->priv->bookmarks;
		for (bookmark_it = bookmark_collection; bookmark_it != NULL; bookmark_it = bookmark_it->next) {
			UnityFilesPlaceBookmark* _tmp1_;
			UnityFilesPlaceBookmark* bookmark;
			_tmp1_ = _g_object_ref0 ((UnityFilesPlaceBookmark*) bookmark_it->data);
			bookmark = _tmp1_;
			{
				GList* _tmp2_ = NULL;
				_tmp2_ = unity_files_place_bookmark_get_index_terms (bookmark);
				{
					GList* term_collection;
					GList* term_it;
					term_collection = _tmp2_;
					for (term_it = term_collection; term_it != NULL; term_it = term_it->next) {
						gchar* _tmp3_;
						gchar* term;
						_tmp3_ = g_strdup ((const gchar*) term_it->data);
						term = _tmp3_;
						{
							gboolean _tmp4_;
							_tmp4_ = g_str_has_prefix (term, prefix);
							if (_tmp4_) {
								UnityFilesPlaceBookmark* _tmp5_;
								_tmp5_ = _g_object_ref0 (bookmark);
								matches = g_list_append (matches, _tmp5_);
								_g_free0 (term);
								break;
							}
							_g_free0 (term);
						}
					}
				}
				_g_object_unref0 (bookmark);
			}
		}
	}
	_tmp6_ = matches;
	matches = NULL;
	result = _tmp6_;
	__g_list_free__g_object_unref0_0 (matches);
	_g_free0 (prefix);
	return result;
}


static void unity_files_place_bookmarks_class_init (UnityFilesPlaceBookmarksClass * klass) {
	unity_files_place_bookmarks_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityFilesPlaceBookmarksPrivate));
	G_OBJECT_CLASS (klass)->finalize = unity_files_place_bookmarks_finalize;
	g_signal_new ("changed", UNITY_FILES_PLACE_TYPE_BOOKMARKS, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void unity_files_place_bookmarks_instance_init (UnityFilesPlaceBookmarks * self) {
	self->priv = UNITY_FILES_PLACE_BOOKMARKS_GET_PRIVATE (self);
}


static void unity_files_place_bookmarks_finalize (GObject* obj) {
	UnityFilesPlaceBookmarks * self;
	self = UNITY_FILES_PLACE_BOOKMARKS (obj);
	__g_list_free__g_object_unref0_0 (self->priv->bookmarks);
	_g_free0 (self->priv->bookmarks_file);
	_g_object_unref0 (self->priv->monitor);
	G_OBJECT_CLASS (unity_files_place_bookmarks_parent_class)->finalize (obj);
}


GType unity_files_place_bookmarks_get_type (void) {
	static volatile gsize unity_files_place_bookmarks_type_id__volatile = 0;
	if (g_once_init_enter (&unity_files_place_bookmarks_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityFilesPlaceBookmarksClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_files_place_bookmarks_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityFilesPlaceBookmarks), 0, (GInstanceInitFunc) unity_files_place_bookmarks_instance_init, NULL };
		GType unity_files_place_bookmarks_type_id;
		unity_files_place_bookmarks_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityFilesPlaceBookmarks", &g_define_type_info, 0);
		g_once_init_leave (&unity_files_place_bookmarks_type_id__volatile, unity_files_place_bookmarks_type_id);
	}
	return unity_files_place_bookmarks_type_id__volatile;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


UnityFilesPlaceBookmark* unity_files_place_bookmark_construct (GType object_type, const gchar* uri, const gchar* mimetype, const gchar* display_name) {
	UnityFilesPlaceBookmark * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (mimetype != NULL, NULL);
	g_return_val_if_fail (display_name != NULL, NULL);
	_tmp0_ = unity_files_place_utils_get_icon_for_uri (uri, mimetype);
	_tmp1_ = _tmp0_;
	self = (UnityFilesPlaceBookmark*) g_object_new (object_type, "uri", uri, "icon", _tmp1_, "mimetype", mimetype, "display-name", display_name, NULL);
	_g_free0 (_tmp1_);
	__g_list_free__g_free0_0 (self->priv->index_terms);
	self->priv->index_terms = NULL;
	_tmp2_ = g_path_get_basename (uri);
	_tmp3_ = _tmp2_;
	_tmp4_ = unity_files_place_utils_normalize_string (_tmp3_);
	self->priv->index_terms = g_list_append (self->priv->index_terms, _tmp4_);
	_g_free0 (_tmp3_);
	_tmp5_ = unity_files_place_utils_normalize_string (display_name);
	self->priv->index_terms = g_list_append (self->priv->index_terms, _tmp5_);
	return self;
}


UnityFilesPlaceBookmark* unity_files_place_bookmark_new (const gchar* uri, const gchar* mimetype, const gchar* display_name) {
	return unity_files_place_bookmark_construct (UNITY_FILES_PLACE_TYPE_BOOKMARK, uri, mimetype, display_name);
}


GList* unity_files_place_bookmark_get_index_terms (UnityFilesPlaceBookmark* self) {
	GList* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->index_terms;
	return result;
}


const gchar* unity_files_place_bookmark_get_uri (UnityFilesPlaceBookmark* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_uri;
	return result;
}


void unity_files_place_bookmark_set_uri (UnityFilesPlaceBookmark* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_uri);
	self->priv->_uri = _tmp0_;
	g_object_notify ((GObject *) self, "uri");
}


const gchar* unity_files_place_bookmark_get_icon (UnityFilesPlaceBookmark* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_icon;
	return result;
}


void unity_files_place_bookmark_set_icon (UnityFilesPlaceBookmark* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_icon);
	self->priv->_icon = _tmp0_;
	g_object_notify ((GObject *) self, "icon");
}


const gchar* unity_files_place_bookmark_get_mimetype (UnityFilesPlaceBookmark* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_mimetype;
	return result;
}


void unity_files_place_bookmark_set_mimetype (UnityFilesPlaceBookmark* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_mimetype);
	self->priv->_mimetype = _tmp0_;
	g_object_notify ((GObject *) self, "mimetype");
}


const gchar* unity_files_place_bookmark_get_display_name (UnityFilesPlaceBookmark* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_display_name;
	return result;
}


void unity_files_place_bookmark_set_display_name (UnityFilesPlaceBookmark* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_display_name);
	self->priv->_display_name = _tmp0_;
	g_object_notify ((GObject *) self, "display-name");
}


static void unity_files_place_bookmark_class_init (UnityFilesPlaceBookmarkClass * klass) {
	unity_files_place_bookmark_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityFilesPlaceBookmarkPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_files_place_bookmark_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_files_place_bookmark_set_property;
	G_OBJECT_CLASS (klass)->finalize = unity_files_place_bookmark_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILES_PLACE_BOOKMARK_URI, g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILES_PLACE_BOOKMARK_ICON, g_param_spec_string ("icon", "icon", "icon", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILES_PLACE_BOOKMARK_MIMETYPE, g_param_spec_string ("mimetype", "mimetype", "mimetype", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILES_PLACE_BOOKMARK_DISPLAY_NAME, g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void unity_files_place_bookmark_instance_init (UnityFilesPlaceBookmark * self) {
	self->priv = UNITY_FILES_PLACE_BOOKMARK_GET_PRIVATE (self);
}


static void unity_files_place_bookmark_finalize (GObject* obj) {
	UnityFilesPlaceBookmark * self;
	self = UNITY_FILES_PLACE_BOOKMARK (obj);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_icon);
	_g_free0 (self->priv->_mimetype);
	_g_free0 (self->priv->_display_name);
	__g_list_free__g_free0_0 (self->priv->index_terms);
	G_OBJECT_CLASS (unity_files_place_bookmark_parent_class)->finalize (obj);
}


GType unity_files_place_bookmark_get_type (void) {
	static volatile gsize unity_files_place_bookmark_type_id__volatile = 0;
	if (g_once_init_enter (&unity_files_place_bookmark_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityFilesPlaceBookmarkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_files_place_bookmark_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityFilesPlaceBookmark), 0, (GInstanceInitFunc) unity_files_place_bookmark_instance_init, NULL };
		GType unity_files_place_bookmark_type_id;
		unity_files_place_bookmark_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityFilesPlaceBookmark", &g_define_type_info, 0);
		g_once_init_leave (&unity_files_place_bookmark_type_id__volatile, unity_files_place_bookmark_type_id);
	}
	return unity_files_place_bookmark_type_id__volatile;
}


static void _vala_unity_files_place_bookmark_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityFilesPlaceBookmark * self;
	self = UNITY_FILES_PLACE_BOOKMARK (object);
	switch (property_id) {
		case UNITY_FILES_PLACE_BOOKMARK_URI:
		g_value_set_string (value, unity_files_place_bookmark_get_uri (self));
		break;
		case UNITY_FILES_PLACE_BOOKMARK_ICON:
		g_value_set_string (value, unity_files_place_bookmark_get_icon (self));
		break;
		case UNITY_FILES_PLACE_BOOKMARK_MIMETYPE:
		g_value_set_string (value, unity_files_place_bookmark_get_mimetype (self));
		break;
		case UNITY_FILES_PLACE_BOOKMARK_DISPLAY_NAME:
		g_value_set_string (value, unity_files_place_bookmark_get_display_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_files_place_bookmark_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityFilesPlaceBookmark * self;
	self = UNITY_FILES_PLACE_BOOKMARK (object);
	switch (property_id) {
		case UNITY_FILES_PLACE_BOOKMARK_URI:
		unity_files_place_bookmark_set_uri (self, g_value_get_string (value));
		break;
		case UNITY_FILES_PLACE_BOOKMARK_ICON:
		unity_files_place_bookmark_set_icon (self, g_value_get_string (value));
		break;
		case UNITY_FILES_PLACE_BOOKMARK_MIMETYPE:
		unity_files_place_bookmark_set_mimetype (self, g_value_get_string (value));
		break;
		case UNITY_FILES_PLACE_BOOKMARK_DISPLAY_NAME:
		unity_files_place_bookmark_set_display_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



