/* url-checker.c generated by valac 0.11.7, the Vala compiler
 * generated from url-checker.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define UNITY_FILES_PLACE_TYPE_URL_CHECKER (unity_files_place_url_checker_get_type ())
#define UNITY_FILES_PLACE_URL_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_FILES_PLACE_TYPE_URL_CHECKER, UnityFilesPlaceUrlChecker))
#define UNITY_FILES_PLACE_URL_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_FILES_PLACE_TYPE_URL_CHECKER, UnityFilesPlaceUrlCheckerClass))
#define UNITY_FILES_PLACE_IS_URL_CHECKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_FILES_PLACE_TYPE_URL_CHECKER))
#define UNITY_FILES_PLACE_IS_URL_CHECKER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_FILES_PLACE_TYPE_URL_CHECKER))
#define UNITY_FILES_PLACE_URL_CHECKER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_FILES_PLACE_TYPE_URL_CHECKER, UnityFilesPlaceUrlCheckerClass))

typedef struct _UnityFilesPlaceUrlChecker UnityFilesPlaceUrlChecker;
typedef struct _UnityFilesPlaceUrlCheckerClass UnityFilesPlaceUrlCheckerClass;
typedef struct _UnityFilesPlaceUrlCheckerPrivate UnityFilesPlaceUrlCheckerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __g_list_free__g_regex_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_regex_unref0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _UnityFilesPlaceUrlChecker {
	GObject parent_instance;
	UnityFilesPlaceUrlCheckerPrivate * priv;
};

struct _UnityFilesPlaceUrlCheckerClass {
	GObjectClass parent_class;
};

struct _UnityFilesPlaceUrlCheckerPrivate {
	gchar* _icon;
	GList* regexes;
};


static gpointer unity_files_place_url_checker_parent_class = NULL;

GType unity_files_place_url_checker_get_type (void) G_GNUC_CONST;
#define UNITY_FILES_PLACE_URL_CHECKER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_FILES_PLACE_TYPE_URL_CHECKER, UnityFilesPlaceUrlCheckerPrivate))
enum  {
	UNITY_FILES_PLACE_URL_CHECKER_DUMMY_PROPERTY,
	UNITY_FILES_PLACE_URL_CHECKER_ICON
};
static void _g_regex_unref0_ (gpointer var);
static void _g_list_free__g_regex_unref0_ (GList* self);
UnityFilesPlaceUrlChecker* unity_files_place_url_checker_new (void);
UnityFilesPlaceUrlChecker* unity_files_place_url_checker_construct (GType object_type);
static void unity_files_place_url_checker_set_icon (UnityFilesPlaceUrlChecker* self, const gchar* value);
gchar* unity_files_place_url_checker_check_url (UnityFilesPlaceUrlChecker* self, const gchar* sample);
const gchar* unity_files_place_url_checker_get_icon (UnityFilesPlaceUrlChecker* self);
static void unity_files_place_url_checker_finalize (GObject* obj);
static void _vala_unity_files_place_url_checker_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_files_place_url_checker_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static void _g_regex_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_regex_unref (var), NULL));
}


static void _g_list_free__g_regex_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_regex_unref0_, NULL);
	g_list_free (self);
}


UnityFilesPlaceUrlChecker* unity_files_place_url_checker_construct (GType object_type) {
	UnityFilesPlaceUrlChecker * self = NULL;
	GThemedIcon* _tmp0_ = NULL;
	GThemedIcon* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GRegex* _tmp4_ = NULL;
	GRegex* _tmp5_;
	GRegex* _tmp6_ = NULL;
	GRegex* _tmp7_;
	GRegex* _tmp8_ = NULL;
	GRegex* _tmp9_;
	GRegex* _tmp10_ = NULL;
	GRegex* _tmp11_;
	GError * _inner_error_ = NULL;
	self = (UnityFilesPlaceUrlChecker*) g_object_new (object_type, NULL);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("web-browser");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_icon_to_string ((GIcon*) _tmp1_);
	_tmp3_ = _tmp2_;
	unity_files_place_url_checker_set_icon (self, _tmp3_);
	_g_free0 (_tmp3_);
	_g_object_unref0 (_tmp1_);
	__g_list_free__g_regex_unref0_0 (self->priv->regexes);
	self->priv->regexes = NULL;
	_tmp4_ = g_regex_new (".+\\...+", 0, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch14_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->priv->regexes = g_list_prepend (self->priv->regexes, _tmp5_);
	_tmp6_ = g_regex_new ("www.*", 0, 0, &_inner_error_);
	_tmp7_ = _tmp6_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch14_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->priv->regexes = g_list_prepend (self->priv->regexes, _tmp7_);
	_tmp8_ = g_regex_new ("http://.+", 0, 0, &_inner_error_);
	_tmp9_ = _tmp8_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch14_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->priv->regexes = g_list_prepend (self->priv->regexes, _tmp9_);
	_tmp10_ = g_regex_new ("https://.+", 0, 0, &_inner_error_);
	_tmp11_ = _tmp10_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch14_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	self->priv->regexes = g_list_prepend (self->priv->regexes, _tmp11_);
	goto __finally14;
	__catch14_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("url-checker.vala:41: Error compiling regular expressions for URL match" \
"ing. URL launching will not work: %s", e->message);
		_g_error_free0 (e);
	}
	__finally14:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


UnityFilesPlaceUrlChecker* unity_files_place_url_checker_new (void) {
	return unity_files_place_url_checker_construct (UNITY_FILES_PLACE_TYPE_URL_CHECKER);
}


static gpointer _g_regex_ref0 (gpointer self) {
	return self ? g_regex_ref (self) : NULL;
}


gchar* unity_files_place_url_checker_check_url (UnityFilesPlaceUrlChecker* self, const gchar* sample) {
	gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sample != NULL, NULL);
	{
		GList* regex_collection;
		GList* regex_it;
		regex_collection = self->priv->regexes;
		for (regex_it = regex_collection; regex_it != NULL; regex_it = regex_it->next) {
			GRegex* _tmp0_;
			GRegex* regex;
			_tmp0_ = _g_regex_ref0 ((GRegex*) regex_it->data);
			regex = _tmp0_;
			{
				gboolean _tmp1_;
				_tmp1_ = g_regex_match (regex, sample, 0, NULL);
				if (_tmp1_) {
					gchar* _tmp2_ = NULL;
					gboolean _tmp3_;
					_tmp3_ = g_str_has_prefix (sample, "http");
					if (_tmp3_) {
						gchar* _tmp4_;
						_tmp4_ = g_strdup (sample);
						_g_free0 (_tmp2_);
						_tmp2_ = _tmp4_;
					} else {
						gchar* _tmp5_;
						_tmp5_ = g_strconcat ("http://", sample, NULL);
						_g_free0 (_tmp2_);
						_tmp2_ = _tmp5_;
					}
					result = _tmp2_;
					_g_regex_unref0 (regex);
					return result;
				}
				_g_regex_unref0 (regex);
			}
		}
	}
	result = NULL;
	return result;
}


const gchar* unity_files_place_url_checker_get_icon (UnityFilesPlaceUrlChecker* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_icon;
	return result;
}


static void unity_files_place_url_checker_set_icon (UnityFilesPlaceUrlChecker* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_icon);
	self->priv->_icon = _tmp0_;
	g_object_notify ((GObject *) self, "icon");
}


static void unity_files_place_url_checker_class_init (UnityFilesPlaceUrlCheckerClass * klass) {
	unity_files_place_url_checker_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityFilesPlaceUrlCheckerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_files_place_url_checker_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_files_place_url_checker_set_property;
	G_OBJECT_CLASS (klass)->finalize = unity_files_place_url_checker_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_FILES_PLACE_URL_CHECKER_ICON, g_param_spec_string ("icon", "icon", "icon", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void unity_files_place_url_checker_instance_init (UnityFilesPlaceUrlChecker * self) {
	self->priv = UNITY_FILES_PLACE_URL_CHECKER_GET_PRIVATE (self);
}


static void unity_files_place_url_checker_finalize (GObject* obj) {
	UnityFilesPlaceUrlChecker * self;
	self = UNITY_FILES_PLACE_URL_CHECKER (obj);
	_g_free0 (self->priv->_icon);
	__g_list_free__g_regex_unref0_0 (self->priv->regexes);
	G_OBJECT_CLASS (unity_files_place_url_checker_parent_class)->finalize (obj);
}


GType unity_files_place_url_checker_get_type (void) {
	static volatile gsize unity_files_place_url_checker_type_id__volatile = 0;
	if (g_once_init_enter (&unity_files_place_url_checker_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityFilesPlaceUrlCheckerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_files_place_url_checker_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityFilesPlaceUrlChecker), 0, (GInstanceInitFunc) unity_files_place_url_checker_instance_init, NULL };
		GType unity_files_place_url_checker_type_id;
		unity_files_place_url_checker_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityFilesPlaceUrlChecker", &g_define_type_info, 0);
		g_once_init_leave (&unity_files_place_url_checker_type_id__volatile, unity_files_place_url_checker_type_id);
	}
	return unity_files_place_url_checker_type_id__volatile;
}


static void _vala_unity_files_place_url_checker_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityFilesPlaceUrlChecker * self;
	self = UNITY_FILES_PLACE_URL_CHECKER (object);
	switch (property_id) {
		case UNITY_FILES_PLACE_URL_CHECKER_ICON:
		g_value_set_string (value, unity_files_place_url_checker_get_icon (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_files_place_url_checker_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityFilesPlaceUrlChecker * self;
	self = UNITY_FILES_PLACE_URL_CHECKER (object);
	switch (property_id) {
		case UNITY_FILES_PLACE_URL_CHECKER_ICON:
		unity_files_place_url_checker_set_icon (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



