/* application-controller.c generated by valac 0.10.0, the Vala compiler
 * generated from application-controller.vala, do not modify */

/*
 *      application-controller.vala
 *      Copyright (C) 2010 Canonical Ltd
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 3 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *      MA 02110-1301, USA.
 *
 *
 *      Authored by Gordon Allott <gord.allott@canonical.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <unity.h>
#include <libdbusmenu-glib/client.h>
#include <libdbusmenu-glib/menuitem-proxy.h>
#include <libdbusmenu-glib/menuitem.h>
#include <libdbusmenu-glib/server.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <libbamf/libbamf.h>
#include <clutk/clutk.h>
#include <glib/gstdio.h>
#include <gtk/gtk.h>
#include <libindicator/indicator.h>
#include <libindicator/indicator-object.h>
#include <libindicator/indicator-service.h>
#include <libindicator/indicator-service-manager.h>
#include <libindicator/indicator-desktop-shortcuts.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <gio/gdesktopappinfo.h>
#include <gio/gio.h>


#define UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER (unity_launcher_scroller_child_controller_get_type ())
#define UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER, UnityLauncherScrollerChildController))
#define UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER, UnityLauncherScrollerChildControllerClass))
#define UNITY_LAUNCHER_IS_SCROLLER_CHILD_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER))
#define UNITY_LAUNCHER_IS_SCROLLER_CHILD_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER))
#define UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER, UnityLauncherScrollerChildControllerClass))

typedef struct _UnityLauncherScrollerChildController UnityLauncherScrollerChildController;
typedef struct _UnityLauncherScrollerChildControllerClass UnityLauncherScrollerChildControllerClass;
typedef struct _UnityLauncherScrollerChildControllerPrivate UnityLauncherScrollerChildControllerPrivate;

#define UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER (unity_launcher_quicklist_controller_get_type ())
#define UNITY_LAUNCHER_QUICKLIST_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER, UnityLauncherQuicklistController))
#define UNITY_LAUNCHER_QUICKLIST_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER, UnityLauncherQuicklistControllerClass))
#define UNITY_LAUNCHER_IS_QUICKLIST_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER))
#define UNITY_LAUNCHER_IS_QUICKLIST_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER))
#define UNITY_LAUNCHER_QUICKLIST_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_QUICKLIST_CONTROLLER, UnityLauncherQuicklistControllerClass))

typedef struct _UnityLauncherQuicklistController UnityLauncherQuicklistController;
typedef struct _UnityLauncherQuicklistControllerClass UnityLauncherQuicklistControllerClass;

#define UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER_MENU_STATE (unity_launcher_scroller_child_controller_menu_state_get_type ())

#define UNITY_LAUNCHER_TYPE_APPLICATION_CONTROLLER (unity_launcher_application_controller_get_type ())
#define UNITY_LAUNCHER_APPLICATION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_APPLICATION_CONTROLLER, UnityLauncherApplicationController))
#define UNITY_LAUNCHER_APPLICATION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_APPLICATION_CONTROLLER, UnityLauncherApplicationControllerClass))
#define UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_APPLICATION_CONTROLLER))
#define UNITY_LAUNCHER_IS_APPLICATION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_APPLICATION_CONTROLLER))
#define UNITY_LAUNCHER_APPLICATION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_APPLICATION_CONTROLLER, UnityLauncherApplicationControllerClass))

typedef struct _UnityLauncherApplicationController UnityLauncherApplicationController;
typedef struct _UnityLauncherApplicationControllerClass UnityLauncherApplicationControllerClass;
typedef struct _UnityLauncherApplicationControllerPrivate UnityLauncherApplicationControllerPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_free0(var) ((var == NULL) ? NULL : (var = (g_key_file_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define UNITY_LAUNCHER_TYPE_SCROLLER_CHILD (unity_launcher_scroller_child_get_type ())
#define UNITY_LAUNCHER_SCROLLER_CHILD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, UnityLauncherScrollerChild))
#define UNITY_LAUNCHER_SCROLLER_CHILD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, UnityLauncherScrollerChildClass))
#define UNITY_LAUNCHER_IS_SCROLLER_CHILD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD))
#define UNITY_LAUNCHER_IS_SCROLLER_CHILD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD))
#define UNITY_LAUNCHER_SCROLLER_CHILD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_SCROLLER_CHILD, UnityLauncherScrollerChildClass))

typedef struct _UnityLauncherScrollerChild UnityLauncherScrollerChild;
typedef struct _UnityLauncherScrollerChildClass UnityLauncherScrollerChildClass;

#define UNITY_LAUNCHER_TYPE_APPLICATION_QUICKLIST_CONTROLLER (unity_launcher_application_quicklist_controller_get_type ())
#define UNITY_LAUNCHER_APPLICATION_QUICKLIST_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_LAUNCHER_TYPE_APPLICATION_QUICKLIST_CONTROLLER, UnityLauncherApplicationQuicklistController))
#define UNITY_LAUNCHER_APPLICATION_QUICKLIST_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_LAUNCHER_TYPE_APPLICATION_QUICKLIST_CONTROLLER, UnityLauncherApplicationQuicklistControllerClass))
#define UNITY_LAUNCHER_IS_APPLICATION_QUICKLIST_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_LAUNCHER_TYPE_APPLICATION_QUICKLIST_CONTROLLER))
#define UNITY_LAUNCHER_IS_APPLICATION_QUICKLIST_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_LAUNCHER_TYPE_APPLICATION_QUICKLIST_CONTROLLER))
#define UNITY_LAUNCHER_APPLICATION_QUICKLIST_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_LAUNCHER_TYPE_APPLICATION_QUICKLIST_CONTROLLER, UnityLauncherApplicationQuicklistControllerClass))

typedef struct _UnityLauncherApplicationQuicklistController UnityLauncherApplicationQuicklistController;
typedef struct _UnityLauncherApplicationQuicklistControllerClass UnityLauncherApplicationQuicklistControllerClass;
#define _g_array_free0(var) ((var == NULL) ? NULL : (var = (g_array_free (var, TRUE), NULL)))
typedef struct _UnityLauncherScrollerChildPrivate UnityLauncherScrollerChildPrivate;

#define UNITY_LAUNCHER_TYPE_PIN_TYPE (unity_launcher_pin_type_get_type ())
typedef struct _Block8Data Block8Data;
typedef struct _Block6Data Block6Data;
#define __g_list_free_g_object_unref0(var) ((var == NULL) ? NULL : (var = (_g_list_free_g_object_unref (var), NULL)))
typedef struct _Block9Data Block9Data;
typedef struct _Block7Data Block7Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	UNITY_LAUNCHER_APP_TYPE_ERROR_NO_DESKTOP_FILE
} UnityLauncherAppTypeError;
#define UNITY_LAUNCHER_APP_TYPE_ERROR unity_launcher_app_type_error_quark ()
typedef void (*UnityLauncherScrollerChildControllermenu_cb) (DbusmenuMenuitem* menu, void* user_data);
typedef enum  {
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_NO_MENU,
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_LABEL,
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_MENU,
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_MENU_STATE_MENU_CLOSE_WHEN_LEAVE
} UnityLauncherScrollerChildControllerMenuState;

struct _UnityLauncherScrollerChildController {
	GObject parent_instance;
	UnityLauncherScrollerChildControllerPrivate * priv;
	UnityLauncherScrollerChildControllerMenuState menu_state;
	guint32 last_press_time;
	gboolean button_down;
	float click_start_pos_x;
	float click_start_pos_y;
	gint drag_sensitivity;
};

struct _UnityLauncherScrollerChildControllerClass {
	GObjectClass parent_class;
	void (*get_menu_actions) (UnityLauncherScrollerChildController* self, UnityLauncherScrollerChildControllermenu_cb callback, void* callback_target);
	void (*get_menu_navigation) (UnityLauncherScrollerChildController* self, UnityLauncherScrollerChildControllermenu_cb callback, void* callback_target);
	void (*activate) (UnityLauncherScrollerChildController* self);
	UnityLauncherQuicklistController* (*get_menu_controller) (UnityLauncherScrollerChildController* self);
	gboolean (*can_drag) (UnityLauncherScrollerChildController* self);
};

struct _UnityLauncherApplicationController {
	UnityLauncherScrollerChildController parent_instance;
	UnityLauncherApplicationControllerPrivate * priv;
	gboolean is_favorite;
};

struct _UnityLauncherApplicationControllerClass {
	UnityLauncherScrollerChildControllerClass parent_class;
};

struct _UnityLauncherApplicationControllerPrivate {
	char* _desktop_file;
	GKeyFile* desktop_keyfile;
	char* icon_name;
	BamfApplication* app;
	DbusmenuClient* menu_client;
	DbusmenuMenuitem* cached_menu;
	gint menu_items_realized_counter;
	char* _fav_id;
};

typedef enum  {
	UNITY_LAUNCHER_PIN_TYPE_UNPINNED,
	UNITY_LAUNCHER_PIN_TYPE_PINNED,
	UNITY_LAUNCHER_PIN_TYPE_ALWAYS,
	UNITY_LAUNCHER_PIN_TYPE_NEVER
} UnityLauncherPinType;

struct _UnityLauncherScrollerChild {
	CtkActor parent_instance;
	UnityLauncherScrollerChildPrivate * priv;
	UnityLauncherPinType pin_type;
	gboolean do_not_render;
	UnityLauncherScrollerChildController* controller;
	float grabbed_push;
	UnityUnityIcon* processed_icon;
};

struct _UnityLauncherScrollerChildClass {
	CtkActorClass parent_class;
};

struct _Block8Data {
	int _ref_count_;
	Block6Data * _data6_;
	DbusmenuMenuitem* menu;
};

struct _Block6Data {
	int _ref_count_;
	Block7Data * _data7_;
	char* path;
	char* remote_address;
};

struct _Block9Data {
	int _ref_count_;
	Block7Data * _data7_;
	char* local_nick;
};

struct _Block7Data {
	int _ref_count_;
	UnityLauncherApplicationController * self;
	IndicatorDesktopShortcuts* shortcuts;
	UnityLauncherScrollerChildControllermenu_cb callback;
	gpointer callback_target;
};


static gpointer unity_launcher_application_controller_parent_class = NULL;

GQuark unity_launcher_app_type_error_quark (void);
GType unity_launcher_scroller_child_controller_get_type (void) G_GNUC_CONST;
GType unity_launcher_quicklist_controller_get_type (void) G_GNUC_CONST;
GType unity_launcher_scroller_child_controller_menu_state_get_type (void) G_GNUC_CONST;
GType unity_launcher_application_controller_get_type (void) G_GNUC_CONST;
#define UNITY_LAUNCHER_APPLICATION_CONTROLLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_LAUNCHER_TYPE_APPLICATION_CONTROLLER, UnityLauncherApplicationControllerPrivate))
enum  {
	UNITY_LAUNCHER_APPLICATION_CONTROLLER_DUMMY_PROPERTY,
	UNITY_LAUNCHER_APPLICATION_CONTROLLER_DESKTOP_FILE,
	UNITY_LAUNCHER_APPLICATION_CONTROLLER_FAV_ID
};
GType unity_launcher_scroller_child_get_type (void) G_GNUC_CONST;
UnityLauncherApplicationController* unity_launcher_application_controller_new (const char* desktop_file_, UnityLauncherScrollerChild* child_);
UnityLauncherApplicationController* unity_launcher_application_controller_construct (GType object_type, const char* desktop_file_, UnityLauncherScrollerChild* child_);
static void unity_launcher_application_controller_set_desktop_file (UnityLauncherApplicationController* self, const char* value);
static void unity_launcher_application_controller_load_desktop_file_info (UnityLauncherApplicationController* self);
static UnityLauncherQuicklistController* unity_launcher_application_controller_real_get_menu_controller (UnityLauncherScrollerChildController* base);
UnityLauncherApplicationQuicklistController* unity_launcher_application_quicklist_controller_new (UnityLauncherScrollerChildController* scroller_child);
UnityLauncherApplicationQuicklistController* unity_launcher_application_quicklist_controller_construct (GType object_type, UnityLauncherScrollerChildController* scroller_child);
GType unity_launcher_application_quicklist_controller_get_type (void) G_GNUC_CONST;
void unity_launcher_application_controller_closed (UnityLauncherApplicationController* self);
gboolean unity_launcher_application_controller_is_sticky (UnityLauncherApplicationController* self);
void unity_launcher_application_controller_set_sticky (UnityLauncherApplicationController* self, gboolean is_sticky);
const char* unity_launcher_application_controller_get_desktop_file (UnityLauncherApplicationController* self);
const char* unity_launcher_application_controller_get_fav_id (UnityLauncherApplicationController* self);
void unity_launcher_application_controller_close_windows (UnityLauncherApplicationController* self);
void unity_launcher_application_controller_set_priority (UnityLauncherApplicationController* self, float priority);
float unity_launcher_application_controller_get_priority (UnityLauncherApplicationController* self, GError** error);
static void unity_launcher_application_controller_on_favorite_added (UnityLauncherApplicationController* self, const char* uid);
UnityLauncherScrollerChild* unity_launcher_scroller_child_controller_get_child (UnityLauncherScrollerChildController* self);
GType unity_launcher_pin_type_get_type (void) G_GNUC_CONST;
static void unity_launcher_application_controller_on_favorite_removed (UnityLauncherApplicationController* self, const char* uid);
static void unity_launcher_application_controller_real_get_menu_actions (UnityLauncherScrollerChildController* base, UnityLauncherScrollerChildControllermenu_cb callback, void* callback_target);
static void _lambda77_ (Block6Data* _data6_);
static void _lambda78_ (Block8Data* _data8_);
static void __lambda78__dbusmenu_menuitem_realized (DbusmenuMenuitem* _sender, gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (Block8Data* _data8_);
static void __lambda77__dbusmenu_client_layout_updated (DbusmenuClient* _sender, gpointer self);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
static void _g_list_free_g_object_unref (GList* self);
static void _lambda79_ (guint timestamp, Block9Data* _data9_);
static void __lambda79__dbusmenu_menuitem_item_activated (DbusmenuMenuitem* _sender, guint object, gpointer self);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (Block9Data* _data9_);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
static void unity_launcher_application_controller_real_get_menu_navigation (UnityLauncherScrollerChildController* base, UnityLauncherScrollerChildControllermenu_cb callback, void* callback_target);
static void _lambda80_ (guint timestamp, UnityLauncherApplicationController* self);
static void __lambda80__dbusmenu_menuitem_item_activated (DbusmenuMenuitem* _sender, guint object, gpointer self);
static void _lambda81_ (guint timestamp, UnityLauncherApplicationController* self);
static void __lambda81__dbusmenu_menuitem_item_activated (DbusmenuMenuitem* _sender, guint object, gpointer self);
static gint unity_launcher_application_controller_order_app_windows (void* a, void* b);
static void unity_launcher_application_controller_real_activate (UnityLauncherScrollerChildController* base);
void unity_launcher_scroller_child_set_activating (UnityLauncherScrollerChild* self, gboolean value);
static gboolean unity_launcher_application_controller_on_launch_timeout (UnityLauncherApplicationController* self);
static gboolean _unity_launcher_application_controller_on_launch_timeout_gsource_func (gpointer self);
void unity_launcher_application_controller_attach_application (UnityLauncherApplicationController* self, BamfApplication* application);
void unity_launcher_scroller_child_set_running (UnityLauncherScrollerChild* self, gboolean value);
void unity_launcher_scroller_child_set_active (UnityLauncherScrollerChild* self, gboolean value);
static void unity_launcher_application_controller_on_app_running_changed (UnityLauncherApplicationController* self, gboolean running);
static void _unity_launcher_application_controller_on_app_running_changed_bamf_view_running_changed (BamfView* _sender, gboolean object, gpointer self);
static void unity_launcher_application_controller_on_app_active_changed (UnityLauncherApplicationController* self, gboolean active);
static void _unity_launcher_application_controller_on_app_active_changed_bamf_view_active_changed (BamfView* _sender, gboolean object, gpointer self);
void unity_launcher_application_controller_detach_application (UnityLauncherApplicationController* self);
static void _unity_launcher_application_controller_detach_application_bamf_view_closed (BamfView* _sender, gpointer self);
static void unity_launcher_application_controller_on_app_urgant_changed (UnityLauncherApplicationController* self, gboolean urgancy);
static void _unity_launcher_application_controller_on_app_urgant_changed_bamf_view_urgent_changed (BamfView* _sender, gboolean object, gpointer self);
static void _lambda82_ (gboolean value, UnityLauncherApplicationController* self);
void unity_launcher_scroller_child_controller_set_hide (UnityLauncherScrollerChildController* self, gboolean value);
static void __lambda82__bamf_view_user_visible_changed (BamfView* _sender, gboolean object, gpointer self);
void unity_launcher_scroller_child_controller_set_name (UnityLauncherScrollerChildController* self, const char* value);
const char* unity_launcher_scroller_child_controller_get_name (UnityLauncherScrollerChildController* self);
void unity_launcher_scroller_child_controller_load_icon_from_icon_name (UnityLauncherScrollerChildController* self, const char* icon_name);
void unity_launcher_scroller_child_set_needs_attention (UnityLauncherScrollerChild* self, gboolean value);
gboolean unity_launcher_application_controller_debug_is_application_attached (UnityLauncherApplicationController* self);
void unity_launcher_application_controller_set_fav_id (UnityLauncherApplicationController* self, const char* value);
static void _unity_launcher_application_controller_on_favorite_added_unity_favorites_favorite_added (UnityFavorites* _sender, const char* uid, gpointer self);
static void _unity_launcher_application_controller_on_favorite_removed_unity_favorites_favorite_removed (UnityFavorites* _sender, const char* uid, gpointer self);
static GObject * unity_launcher_application_controller_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_launcher_application_controller_finalize (GObject* obj);
static void unity_launcher_application_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void unity_launcher_application_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark unity_launcher_app_type_error_quark (void) {
	return g_quark_from_static_string ("unity_launcher_app_type_error-quark");
}


UnityLauncherApplicationController* unity_launcher_application_controller_construct (GType object_type, const char* desktop_file_, UnityLauncherScrollerChild* child_) {
	UnityLauncherApplicationController * self;
	g_return_val_if_fail (child_ != NULL, NULL);
	self = (UnityLauncherApplicationController*) g_object_new (object_type, "child", child_, NULL);
	if (desktop_file_ != NULL) {
		unity_launcher_application_controller_set_desktop_file (self, desktop_file_);
		unity_launcher_application_controller_load_desktop_file_info (self);
	}
	return self;
}


UnityLauncherApplicationController* unity_launcher_application_controller_new (const char* desktop_file_, UnityLauncherScrollerChild* child_) {
	return unity_launcher_application_controller_construct (UNITY_LAUNCHER_TYPE_APPLICATION_CONTROLLER, desktop_file_, child_);
}


static UnityLauncherQuicklistController* unity_launcher_application_controller_real_get_menu_controller (UnityLauncherScrollerChildController* base) {
	UnityLauncherApplicationController * self;
	UnityLauncherQuicklistController* result = NULL;
	UnityLauncherQuicklistController* new_menu;
	self = (UnityLauncherApplicationController*) base;
	new_menu = (UnityLauncherQuicklistController*) unity_launcher_application_quicklist_controller_new ((UnityLauncherScrollerChildController*) self);
	result = new_menu;
	return result;
}


void unity_launcher_application_controller_closed (UnityLauncherApplicationController* self) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (!unity_launcher_application_controller_is_sticky (self)) {
		_tmp0_ = BAMF_IS_APPLICATION (self->priv->app) == FALSE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		g_signal_emit_by_name ((UnityLauncherScrollerChildController*) self, "request-removal");
	}
}


void unity_launcher_application_controller_set_sticky (UnityLauncherApplicationController* self, gboolean is_sticky) {
	gboolean _tmp0_ = FALSE;
	UnityFavorites* favorites;
	g_return_if_fail (self != NULL);
	if (_vala_strcmp0 (self->priv->_desktop_file, "") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->_desktop_file == NULL;
	}
	if (_tmp0_) {
		return;
	}
	favorites = unity_favorites_get_default ();
	if (is_sticky) {
		unity_favorites_set_string (favorites, unity_launcher_application_controller_get_fav_id (self), "type", "application");
		unity_favorites_set_string (favorites, unity_launcher_application_controller_get_fav_id (self), "desktop_file", self->priv->_desktop_file);
		unity_favorites_add_favorite (favorites, unity_launcher_application_controller_get_fav_id (self));
	} else {
		unity_favorites_remove_favorite (favorites, unity_launcher_application_controller_get_fav_id (self));
	}
	_g_object_unref0 (favorites);
}


gboolean unity_launcher_application_controller_is_sticky (UnityLauncherApplicationController* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	UnityFavorites* favorites;
	g_return_val_if_fail (self != NULL, FALSE);
	if (_vala_strcmp0 (self->priv->_desktop_file, "") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->_desktop_file == NULL;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	favorites = unity_favorites_get_default ();
	result = unity_favorites_is_favorite (favorites, unity_launcher_application_controller_get_fav_id (self));
	_g_object_unref0 (favorites);
	return result;
}


void unity_launcher_application_controller_close_windows (UnityLauncherApplicationController* self) {
	g_return_if_fail (self != NULL);
	if (BAMF_IS_APPLICATION (self->priv->app)) {
		GArray* xids;
		xids = bamf_application_get_xids (self->priv->app);
		unity_shell_close_xids (unity_global_shell, xids);
		_g_array_free0 (xids);
	}
}


void unity_launcher_application_controller_set_priority (UnityLauncherApplicationController* self, float priority) {
	gboolean _tmp0_ = FALSE;
	UnityFavorites* favorites;
	g_return_if_fail (self != NULL);
	if (_vala_strcmp0 (self->priv->_desktop_file, "") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->_desktop_file == NULL;
	}
	if (_tmp0_) {
		return;
	}
	favorites = unity_favorites_get_default ();
	unity_favorites_set_float (favorites, unity_launcher_application_controller_get_fav_id (self), "priority", priority);
	_g_object_unref0 (favorites);
}


float unity_launcher_application_controller_get_priority (UnityLauncherApplicationController* self, GError** error) {
	float result = 0.0F;
	gboolean _tmp0_ = FALSE;
	UnityFavorites* favorites;
	float* _tmp1_;
	float _tmp2_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0.0F);
	if (_vala_strcmp0 (self->priv->_desktop_file, "") == 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->_desktop_file == NULL;
	}
	if (_tmp0_) {
		_inner_error_ = g_error_new_literal (UNITY_LAUNCHER_APP_TYPE_ERROR, UNITY_LAUNCHER_APP_TYPE_ERROR_NO_DESKTOP_FILE, "There is no desktop file for this app, can't get priority");
		{
			if (_inner_error_->domain == UNITY_LAUNCHER_APP_TYPE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0.0F;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0.0F;
			}
		}
	}
	favorites = unity_favorites_get_default ();
	result = (_tmp2_ = *(_tmp1_ = unity_favorites_get_float (favorites, unity_launcher_application_controller_get_fav_id (self), "priority")), _g_free0 (_tmp1_), _tmp2_);
	_g_object_unref0 (favorites);
	return result;
	_g_object_unref0 (favorites);
}


static void unity_launcher_application_controller_on_favorite_added (UnityLauncherApplicationController* self, const char* uid) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (uid != NULL);
	if (_vala_strcmp0 (uid, unity_launcher_application_controller_get_fav_id (self)) == 0) {
		self->is_favorite = TRUE;
		unity_launcher_scroller_child_controller_get_child ((UnityLauncherScrollerChildController*) self)->pin_type = UNITY_LAUNCHER_PIN_TYPE_PINNED;
	}
}


static gboolean string_contains (const char* self, const char* needle) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	result = strstr (self, needle) != NULL;
	return result;
}


static void unity_launcher_application_controller_on_favorite_removed (UnityLauncherApplicationController* self, const char* uid) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (uid != NULL);
	if (_vala_strcmp0 (uid, unity_launcher_application_controller_get_fav_id (self)) == 0) {
		self->is_favorite = FALSE;
		unity_launcher_scroller_child_controller_get_child ((UnityLauncherScrollerChildController*) self)->pin_type = UNITY_LAUNCHER_PIN_TYPE_UNPINNED;
		unity_launcher_application_controller_closed (self);
		if (string_contains (self->priv->_desktop_file, ".local")) {
			g_remove (self->priv->_desktop_file);
		}
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static const char* string_to_string (const char* self) {
	const char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void _lambda78_ (Block8Data* _data8_) {
	Block6Data* _data6_;
	Block7Data* _data7_;
	UnityLauncherApplicationController * self;
	_data6_ = _data8_->_data6_;
	_data7_ = _data6_->_data7_;
	self = _data7_->self;
	self->priv->menu_items_realized_counter = self->priv->menu_items_realized_counter - 1;
	if (self->priv->menu_items_realized_counter < 1) {
		_data7_->callback (_data8_->menu, _data7_->callback_target);
	}
}


static void __lambda78__dbusmenu_menuitem_realized (DbusmenuMenuitem* _sender, gpointer self) {
	_lambda78_ (self);
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (Block8Data* _data8_) {
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		block6_data_unref (_data8_->_data6_);
		_g_object_unref0 (_data8_->menu);
		g_slice_free (Block8Data, _data8_);
	}
}


static void _lambda77_ (Block6Data* _data6_) {
	Block7Data* _data7_;
	UnityLauncherApplicationController * self;
	Block8Data* _data8_;
	DbusmenuMenuitem* _tmp0_;
	GList* menu_items;
	_data7_ = _data6_->_data7_;
	self = _data7_->self;
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->_data6_ = block6_data_ref (_data6_);
	_data8_->menu = dbusmenu_client_get_root (self->priv->menu_client);
	self->priv->cached_menu = (_tmp0_ = _g_object_ref0 (_data8_->menu), _g_object_unref0 (self->priv->cached_menu), _tmp0_);
	if (DBUSMENU_IS_MENUITEM (_data8_->menu) == FALSE) {
		char* _tmp1_;
		g_warning ("application-controller.vala:198: %s", _tmp1_ = g_strconcat ("Didn't get a menu for path: ", string_to_string (_data6_->path), " - address: ", string_to_string (_data6_->remote_address), NULL));
		_g_free0 (_tmp1_);
	}
	menu_items = dbusmenu_menuitem_get_children (_data8_->menu);
	self->priv->menu_items_realized_counter = (gint) g_list_length (menu_items);
	{
		GList* menuitem_collection;
		GList* menuitem_it;
		menuitem_collection = menu_items;
		for (menuitem_it = menuitem_collection; menuitem_it != NULL; menuitem_it = menuitem_it->next) {
			DbusmenuMenuitem* menuitem;
			menuitem = _g_object_ref0 ((DbusmenuMenuitem*) menuitem_it->data);
			{
				g_signal_connect_data (menuitem, "realized", (GCallback) __lambda78__dbusmenu_menuitem_realized, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
				_g_object_unref0 (menuitem);
			}
		}
	}
	block8_data_unref (_data8_);
}


static void __lambda77__dbusmenu_client_layout_updated (DbusmenuClient* _sender, gpointer self) {
	_lambda77_ (self);
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		block7_data_unref (_data6_->_data7_);
		_g_free0 (_data6_->remote_address);
		_g_free0 (_data6_->path);
		g_slice_free (Block6Data, _data6_);
	}
}


static void _g_list_free_g_object_unref (GList* self) {
	g_list_foreach (self, (GFunc) g_object_unref, NULL);
	g_list_free (self);
}


static void _lambda79_ (guint timestamp, Block9Data* _data9_) {
	Block7Data* _data7_;
	UnityLauncherApplicationController * self;
	_data7_ = _data9_->_data7_;
	self = _data7_->self;
	indicator_desktop_shortcuts_nick_exec (_data7_->shortcuts, _data9_->local_nick);
}


static void __lambda79__dbusmenu_menuitem_item_activated (DbusmenuMenuitem* _sender, guint object, gpointer self) {
	_lambda79_ (object, self);
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (Block9Data* _data9_) {
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		block7_data_unref (_data9_->_data7_);
		_g_free0 (_data9_->local_nick);
		g_slice_free (Block9Data, _data9_);
	}
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (Block7Data* _data7_) {
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		_g_object_unref0 (_data7_->self);
		_g_object_unref0 (_data7_->shortcuts);
		g_slice_free (Block7Data, _data7_);
	}
}


static void unity_launcher_application_controller_real_get_menu_actions (UnityLauncherScrollerChildController* base, UnityLauncherScrollerChildControllermenu_cb callback, void* callback_target) {
	UnityLauncherApplicationController * self;
	Block7Data* _data7_;
	gboolean _tmp3_ = FALSE;
	gint nicks_length1;
	gint _nicks_size_;
	char** _tmp5_;
	char** _tmp4_;
	char** nicks;
	DbusmenuMenuitem* root;
	self = (UnityLauncherApplicationController*) base;
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_data7_->callback = callback;
	_data7_->callback_target = callback_target;
	if (BAMF_IS_APPLICATION (self->priv->app)) {
		GList* views;
		views = bamf_view_get_children ((BamfView*) self->priv->app);
		{
			GList* view_collection;
			GList* view_it;
			view_collection = views;
			for (view_it = view_collection; view_it != NULL; view_it = view_it->next) {
				BamfView* view;
				view = _g_object_ref0 ((BamfView*) view_it->data);
				{
					if (BAMF_IS_INDICATOR (view)) {
						Block6Data* _data6_;
						BamfView* _tmp0_;
						BamfView* _tmp1_;
						DbusmenuClient* _tmp2_;
						_data6_ = g_slice_new0 (Block6Data);
						_data6_->_ref_count_ = 1;
						_data6_->_data7_ = block7_data_ref (_data7_);
						_data6_->path = g_strdup (bamf_indicator_get_dbus_menu_path ((_tmp0_ = view, BAMF_IS_INDICATOR (_tmp0_) ? ((BamfIndicator*) _tmp0_) : NULL)));
						_data6_->remote_address = g_strdup (bamf_indicator_get_remote_address ((_tmp1_ = view, BAMF_IS_INDICATOR (_tmp1_) ? ((BamfIndicator*) _tmp1_) : NULL)));
						self->priv->menu_client = (_tmp2_ = dbusmenu_client_new (_data6_->remote_address, _data6_->path), _g_object_unref0 (self->priv->menu_client), _tmp2_);
						g_signal_connect_data (self->priv->menu_client, "layout-updated", (GCallback) __lambda77__dbusmenu_client_layout_updated, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
						block6_data_unref (_data6_);
					}
					_g_object_unref0 (view);
				}
			}
		}
		__g_list_free_g_object_unref0 (views);
	}
	if (_vala_strcmp0 (self->priv->_desktop_file, "") == 0) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = self->priv->_desktop_file == NULL;
	}
	if (_tmp3_) {
		_data7_->callback (NULL, _data7_->callback_target);
	}
	_data7_->shortcuts = indicator_desktop_shortcuts_new (self->priv->_desktop_file, "Unity");
	nicks = (_tmp5_ = _tmp4_ = indicator_desktop_shortcuts_get_nicks (_data7_->shortcuts), nicks_length1 = _vala_array_length (_tmp4_), _nicks_size_ = nicks_length1, _tmp5_);
	if (nicks_length1 < 1) {
		_data7_->callback (NULL, _data7_->callback_target);
	}
	root = dbusmenu_menuitem_new ();
	dbusmenu_menuitem_set_root (root, TRUE);
	{
		char** nick_collection;
		int nick_collection_length1;
		int nick_it;
		nick_collection = nicks;
		nick_collection_length1 = nicks_length1;
		for (nick_it = 0; nick_it < nicks_length1; nick_it = nick_it + 1) {
			char* nick;
			nick = g_strdup (nick_collection[nick_it]);
			{
				Block9Data* _data9_;
				const char* name;
				char* local_name;
				DbusmenuMenuitem* shortcut_item;
				_data9_ = g_slice_new0 (Block9Data);
				_data9_->_ref_count_ = 1;
				_data9_->_data7_ = block7_data_ref (_data7_);
				_data9_->local_nick = g_strdup (nick);
				name = indicator_desktop_shortcuts_nick_get_name (_data7_->shortcuts, _data9_->local_nick);
				local_name = g_strdup (name);
				shortcut_item = dbusmenu_menuitem_new ();
				dbusmenu_menuitem_property_set (shortcut_item, DBUSMENU_MENUITEM_PROP_LABEL, local_name);
				dbusmenu_menuitem_property_set_bool (shortcut_item, DBUSMENU_MENUITEM_PROP_ENABLED, TRUE);
				dbusmenu_menuitem_property_set_bool (shortcut_item, DBUSMENU_MENUITEM_PROP_VISIBLE, TRUE);
				g_signal_connect_data (shortcut_item, "item-activated", (GCallback) __lambda79__dbusmenu_menuitem_item_activated, block9_data_ref (_data9_), (GClosureNotify) block9_data_unref, 0);
				dbusmenu_menuitem_child_append (root, shortcut_item);
				_g_object_unref0 (shortcut_item);
				_g_free0 (local_name);
				_g_free0 (nick);
				block9_data_unref (_data9_);
			}
		}
	}
	_data7_->callback (root, _data7_->callback_target);
	_g_object_unref0 (root);
	block7_data_unref (_data7_);
}


static void _lambda80_ (guint timestamp, UnityLauncherApplicationController* self) {
	unity_launcher_application_controller_set_sticky (self, !unity_launcher_application_controller_is_sticky (self));
}


static void __lambda80__dbusmenu_menuitem_item_activated (DbusmenuMenuitem* _sender, guint object, gpointer self) {
	_lambda80_ (object, self);
}


static void _lambda81_ (guint timestamp, UnityLauncherApplicationController* self) {
	if (BAMF_IS_APPLICATION (self->priv->app)) {
		GArray* xids;
		xids = bamf_application_get_xids (self->priv->app);
		unity_shell_close_xids (unity_global_shell, xids);
		_g_array_free0 (xids);
	}
}


static void __lambda81__dbusmenu_menuitem_item_activated (DbusmenuMenuitem* _sender, guint object, gpointer self) {
	_lambda81_ (object, self);
}


static void unity_launcher_application_controller_real_get_menu_navigation (UnityLauncherScrollerChildController* base, UnityLauncherScrollerChildControllermenu_cb callback, void* callback_target) {
	UnityLauncherApplicationController * self;
	DbusmenuMenuitem* root;
	gboolean _tmp0_ = FALSE;
	self = (UnityLauncherApplicationController*) base;
	root = dbusmenu_menuitem_new ();
	dbusmenu_menuitem_set_root (root, TRUE);
	if (self->priv->_desktop_file != NULL) {
		_tmp0_ = _vala_strcmp0 (self->priv->_desktop_file, "") != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		DbusmenuMenuitem* pinning_item;
		pinning_item = dbusmenu_menuitem_new ();
		if (BAMF_IS_APPLICATION (self->priv->app)) {
			dbusmenu_menuitem_property_set (pinning_item, DBUSMENU_MENUITEM_PROP_LABEL, _ ("Keep in Launcher"));
			dbusmenu_menuitem_property_set (pinning_item, DBUSMENU_MENUITEM_PROP_TOGGLE_TYPE, DBUSMENU_MENUITEM_TOGGLE_CHECK);
			if (unity_launcher_application_controller_is_sticky (self)) {
				dbusmenu_menuitem_property_set_int (pinning_item, DBUSMENU_MENUITEM_PROP_TOGGLE_STATE, DBUSMENU_MENUITEM_TOGGLE_STATE_CHECKED);
			} else {
				dbusmenu_menuitem_property_set_int (pinning_item, DBUSMENU_MENUITEM_PROP_TOGGLE_STATE, DBUSMENU_MENUITEM_TOGGLE_STATE_UNCHECKED);
			}
		} else {
			dbusmenu_menuitem_property_set (pinning_item, DBUSMENU_MENUITEM_PROP_LABEL, _ ("Remove from launcher"));
		}
		dbusmenu_menuitem_property_set_bool (pinning_item, DBUSMENU_MENUITEM_PROP_ENABLED, TRUE);
		dbusmenu_menuitem_property_set_bool (pinning_item, DBUSMENU_MENUITEM_PROP_VISIBLE, TRUE);
		g_signal_connect_object (pinning_item, "item-activated", (GCallback) __lambda80__dbusmenu_menuitem_item_activated, self, 0);
		dbusmenu_menuitem_child_append (root, pinning_item);
		_g_object_unref0 (pinning_item);
	}
	if (BAMF_IS_APPLICATION (self->priv->app)) {
		DbusmenuMenuitem* app_item;
		app_item = dbusmenu_menuitem_new ();
		dbusmenu_menuitem_property_set (app_item, DBUSMENU_MENUITEM_PROP_LABEL, _ ("Quit"));
		dbusmenu_menuitem_property_set_bool (app_item, DBUSMENU_MENUITEM_PROP_ENABLED, TRUE);
		dbusmenu_menuitem_property_set_bool (app_item, DBUSMENU_MENUITEM_PROP_VISIBLE, TRUE);
		g_signal_connect_object (app_item, "item-activated", (GCallback) __lambda81__dbusmenu_menuitem_item_activated, self, 0);
		dbusmenu_menuitem_child_append (root, app_item);
		_g_object_unref0 (app_item);
	}
	callback (root, callback_target);
	_g_object_unref0 (root);
}


static gint unity_launcher_application_controller_order_app_windows (void* a, void* b) {
	gint result = 0;
	void* _tmp0_;
	BamfWindow* awin;
	void* _tmp1_;
	BamfWindow* bwin;
	gboolean aurgent;
	gboolean burgent;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (BAMF_IS_WINDOW (a), 0);
	g_return_val_if_fail (BAMF_IS_WINDOW (b), 0);
	awin = (_tmp0_ = a, BAMF_IS_WINDOW (_tmp0_) ? ((BamfWindow*) _tmp0_) : NULL);
	bwin = (_tmp1_ = b, BAMF_IS_WINDOW (_tmp1_) ? ((BamfWindow*) _tmp1_) : NULL);
	aurgent = bamf_view_is_urgent ((BamfView*) awin);
	burgent = bamf_view_is_urgent ((BamfView*) bwin);
	if (aurgent) {
		_tmp2_ = !burgent;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = 1;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		if (!aurgent) {
			_tmp3_ = burgent;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = -1;
			return result;
		} else {
			if (bamf_window_last_active (awin) > bamf_window_last_active (bwin)) {
				result = 1;
				return result;
			} else {
				if (bamf_window_last_active (awin) < bamf_window_last_active (bwin)) {
					result = -1;
					return result;
				} else {
					result = 0;
					return result;
				}
			}
		}
	}
}


static gboolean _unity_launcher_application_controller_on_launch_timeout_gsource_func (gpointer self) {
	gboolean result;
	result = unity_launcher_application_controller_on_launch_timeout (self);
	return result;
}


static void unity_launcher_application_controller_real_activate (UnityLauncherScrollerChildController* base) {
	UnityLauncherApplicationController * self;
	GError * _inner_error_ = NULL;
	self = (UnityLauncherApplicationController*) base;
	if (BAMF_IS_APPLICATION (self->priv->app)) {
		if (bamf_view_is_active ((BamfView*) self->priv->app)) {
			if (unity_shell_get_mode (unity_global_shell) == UNITY_SHELL_MODE_MINIMIZED) {
				GArray* xids;
				xids = bamf_application_get_xids (self->priv->app);
				unity_shell_expose_xids (unity_global_shell, xids);
				_g_array_free0 (xids);
			}
		} else {
			if (bamf_view_is_running ((BamfView*) self->priv->app)) {
				GList* windows;
				windows = bamf_application_get_windows (self->priv->app);
				windows = g_list_sort (windows, (GCompareFunc) unity_launcher_application_controller_order_app_windows);
				unity_shell_show_window (unity_global_shell, bamf_window_get_xid ((BamfWindow*) g_list_nth_data (windows, g_list_length (windows) - 1)));
			}
		}
	} else {
		GdkAppLaunchContext* context;
		context = gdk_app_launch_context_new ();
		{
			GDesktopAppInfo* appinfo;
			appinfo = g_desktop_app_info_new_from_filename (self->priv->_desktop_file);
			gdk_app_launch_context_set_screen (context, gdk_display_get_default_screen (gdk_display_get_default ()));
			gdk_app_launch_context_set_timestamp (context, (guint32) GDK_CURRENT_TIME);
			g_app_info_launch ((GAppInfo*) appinfo, NULL, (GAppLaunchContext*) context, &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (appinfo);
				goto __catch45_g_error;
			}
			unity_launcher_scroller_child_set_activating (unity_launcher_scroller_child_controller_get_child ((UnityLauncherScrollerChildController*) self), TRUE);
			g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 8, _unity_launcher_application_controller_on_launch_timeout_gsource_func, g_object_ref (self), g_object_unref);
			_g_object_unref0 (appinfo);
		}
		goto __finally45;
		__catch45_g_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			{
				g_warning ("application-controller.vala:385: %s", e->message);
				_g_error_free0 (e);
			}
		}
		__finally45:
		if (_inner_error_ != NULL) {
			_g_object_unref0 (context);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (context);
	}
	unity_shell_hide_unity (unity_global_shell);
}


static gboolean unity_launcher_application_controller_on_launch_timeout (UnityLauncherApplicationController* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	unity_launcher_scroller_child_set_activating (unity_launcher_scroller_child_controller_get_child ((UnityLauncherScrollerChildController*) self), FALSE);
	result = FALSE;
	return result;
}


static void _unity_launcher_application_controller_on_app_running_changed_bamf_view_running_changed (BamfView* _sender, gboolean object, gpointer self) {
	unity_launcher_application_controller_on_app_running_changed (self, object);
}


static void _unity_launcher_application_controller_on_app_active_changed_bamf_view_active_changed (BamfView* _sender, gboolean object, gpointer self) {
	unity_launcher_application_controller_on_app_active_changed (self, object);
}


static void _unity_launcher_application_controller_detach_application_bamf_view_closed (BamfView* _sender, gpointer self) {
	unity_launcher_application_controller_detach_application (self);
}


static void _unity_launcher_application_controller_on_app_urgant_changed_bamf_view_urgent_changed (BamfView* _sender, gboolean object, gpointer self) {
	unity_launcher_application_controller_on_app_urgant_changed (self, object);
}


static void _lambda82_ (gboolean value, UnityLauncherApplicationController* self) {
	unity_launcher_scroller_child_controller_set_hide ((UnityLauncherScrollerChildController*) self, !value);
}


static void __lambda82__bamf_view_user_visible_changed (BamfView* _sender, gboolean object, gpointer self) {
	_lambda82_ (object, self);
}


void unity_launcher_application_controller_attach_application (UnityLauncherApplicationController* self, BamfApplication* application) {
	BamfApplication* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	gboolean _tmp3_ = FALSE;
	char* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (application != NULL);
	self->priv->app = (_tmp0_ = _g_object_ref0 (application), _g_object_unref0 (self->priv->app), _tmp0_);
	unity_launcher_application_controller_set_desktop_file (self, _tmp1_ = g_strdup (bamf_application_get_desktop_file (self->priv->app)));
	_g_free0 (_tmp1_);
	unity_launcher_scroller_child_set_running (unity_launcher_scroller_child_controller_get_child ((UnityLauncherScrollerChildController*) self), bamf_view_is_running ((BamfView*) self->priv->app));
	unity_launcher_scroller_child_set_active (unity_launcher_scroller_child_controller_get_child ((UnityLauncherScrollerChildController*) self), bamf_view_is_active ((BamfView*) self->priv->app));
	unity_launcher_scroller_child_set_activating (unity_launcher_scroller_child_controller_get_child ((UnityLauncherScrollerChildController*) self), FALSE);
	g_signal_connect_object ((BamfView*) self->priv->app, "running-changed", (GCallback) _unity_launcher_application_controller_on_app_running_changed_bamf_view_running_changed, self, 0);
	g_signal_connect_object ((BamfView*) self->priv->app, "active-changed", (GCallback) _unity_launcher_application_controller_on_app_active_changed_bamf_view_active_changed, self, 0);
	g_signal_connect_object ((BamfView*) self->priv->app, "closed", (GCallback) _unity_launcher_application_controller_detach_application_bamf_view_closed, self, 0);
	g_signal_connect_object ((BamfView*) self->priv->app, "urgent-changed", (GCallback) _unity_launcher_application_controller_on_app_urgant_changed_bamf_view_urgent_changed, self, 0);
	g_signal_connect_object ((BamfView*) self->priv->app, "user-visible-changed", (GCallback) __lambda82__bamf_view_user_visible_changed, self, 0);
	unity_launcher_scroller_child_controller_set_name ((UnityLauncherScrollerChildController*) self, _tmp2_ = bamf_view_get_name ((BamfView*) self->priv->app));
	_g_free0 (_tmp2_);
	if (unity_launcher_scroller_child_controller_get_name ((UnityLauncherScrollerChildController*) self) == NULL) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = _vala_strcmp0 (unity_launcher_scroller_child_controller_get_name ((UnityLauncherScrollerChildController*) self), "") == 0;
	}
	if (_tmp3_) {
		char* _tmp4_;
		g_warning ("application-controller.vala:413: %s", _tmp4_ = g_strconcat ("Bamf returned null for app.get_name (): ", string_to_string (self->priv->_desktop_file), NULL));
		_g_free0 (_tmp4_);
	}
	self->priv->icon_name = (_tmp5_ = bamf_view_get_icon ((BamfView*) self->priv->app), _g_free0 (self->priv->icon_name), _tmp5_);
	unity_launcher_scroller_child_controller_load_icon_from_icon_name ((UnityLauncherScrollerChildController*) self, self->priv->icon_name);
}


void unity_launcher_application_controller_detach_application (UnityLauncherApplicationController* self) {
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	BamfApplication* _tmp4_;
	g_return_if_fail (self != NULL);
	g_signal_parse_name ("running-changed", BAMF_TYPE_VIEW, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((BamfView*) self->priv->app, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _unity_launcher_application_controller_on_app_running_changed_bamf_view_running_changed, self);
	g_signal_parse_name ("active-changed", BAMF_TYPE_VIEW, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((BamfView*) self->priv->app, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _unity_launcher_application_controller_on_app_active_changed_bamf_view_active_changed, self);
	g_signal_parse_name ("urgent-changed", BAMF_TYPE_VIEW, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((BamfView*) self->priv->app, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _unity_launcher_application_controller_on_app_urgant_changed_bamf_view_urgent_changed, self);
	g_signal_parse_name ("closed", BAMF_TYPE_VIEW, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((BamfView*) self->priv->app, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _unity_launcher_application_controller_detach_application_bamf_view_closed, self);
	self->priv->app = (_tmp4_ = NULL, _g_object_unref0 (self->priv->app), _tmp4_);
	unity_launcher_scroller_child_set_running (unity_launcher_scroller_child_controller_get_child ((UnityLauncherScrollerChildController*) self), FALSE);
	unity_launcher_scroller_child_set_active (unity_launcher_scroller_child_controller_get_child ((UnityLauncherScrollerChildController*) self), FALSE);
	unity_launcher_scroller_child_set_needs_attention (unity_launcher_scroller_child_controller_get_child ((UnityLauncherScrollerChildController*) self), FALSE);
	unity_launcher_application_controller_closed (self);
}


gboolean unity_launcher_application_controller_debug_is_application_attached (UnityLauncherApplicationController* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->app != NULL;
	return result;
}


static void unity_launcher_application_controller_on_app_running_changed (UnityLauncherApplicationController* self, gboolean running) {
	g_return_if_fail (self != NULL);
	unity_launcher_scroller_child_set_running (unity_launcher_scroller_child_controller_get_child ((UnityLauncherScrollerChildController*) self), running);
	if (!running) {
		unity_launcher_application_controller_detach_application (self);
	}
}


static void unity_launcher_application_controller_on_app_active_changed (UnityLauncherApplicationController* self, gboolean active) {
	g_return_if_fail (self != NULL);
	unity_launcher_scroller_child_set_active (unity_launcher_scroller_child_controller_get_child ((UnityLauncherScrollerChildController*) self), active);
}


static void unity_launcher_application_controller_on_app_urgant_changed (UnityLauncherApplicationController* self, gboolean urgancy) {
	g_return_if_fail (self != NULL);
	unity_launcher_scroller_child_set_needs_attention (unity_launcher_scroller_child_controller_get_child ((UnityLauncherScrollerChildController*) self), urgancy);
}


static void unity_launcher_application_controller_load_desktop_file_info (UnityLauncherApplicationController* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GKeyFile* _tmp0_;
		self->priv->desktop_keyfile = (_tmp0_ = g_key_file_new (), _g_key_file_free0 (self->priv->desktop_keyfile), _tmp0_);
		g_key_file_load_from_file (self->priv->desktop_keyfile, self->priv->_desktop_file, G_KEY_FILE_NONE, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch46_g_error;
		}
	}
	goto __finally46;
	__catch46_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("application-controller.vala:465: could not load desktop file: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally46:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		char* _tmp1_;
		char* _tmp2_;
		_tmp1_ = g_key_file_get_string (self->priv->desktop_keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_ICON, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch47_g_error;
		}
		self->priv->icon_name = (_tmp2_ = _tmp1_, _g_free0 (self->priv->icon_name), _tmp2_);
		unity_launcher_scroller_child_controller_load_icon_from_icon_name ((UnityLauncherScrollerChildController*) self, self->priv->icon_name);
	}
	goto __finally47;
	__catch47_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("application-controller.vala:475: could not load icon name from desktop" \
" file: %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally47:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		char* _tmp3_;
		char* _tmp4_;
		_tmp3_ = g_key_file_get_locale_string (self->priv->desktop_keyfile, G_KEY_FILE_DESKTOP_GROUP, G_KEY_FILE_DESKTOP_KEY_NAME, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch48_g_error;
		}
		unity_launcher_scroller_child_controller_set_name ((UnityLauncherScrollerChildController*) self, _tmp4_ = _tmp3_);
		_g_free0 (_tmp4_);
	}
	goto __finally48;
	__catch48_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_warning ("application-controller.vala:484: could not load name from desktop file" \
": %s", e->message);
			_g_error_free0 (e);
		}
	}
	__finally48:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		char* _tmp5_;
		char* _tmp6_;
		_tmp5_ = g_key_file_get_locale_string (self->priv->desktop_keyfile, G_KEY_FILE_DESKTOP_GROUP, "X-GNOME-FullName", NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch49_g_error;
		}
		unity_launcher_scroller_child_controller_set_name ((UnityLauncherScrollerChildController*) self, _tmp6_ = _tmp5_);
		_g_free0 (_tmp6_);
	}
	goto __finally49;
	__catch49_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (e);
		}
	}
	__finally49:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


const char* unity_launcher_application_controller_get_desktop_file (UnityLauncherApplicationController* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_desktop_file;
	return result;
}


static void unity_launcher_application_controller_set_desktop_file (UnityLauncherApplicationController* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_desktop_file = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_desktop_file), _tmp0_);
	g_object_notify ((GObject *) self, "desktop-file");
}


const char* unity_launcher_application_controller_get_fav_id (UnityLauncherApplicationController* self) {
	const char* result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	if (_vala_strcmp0 (self->priv->_fav_id, "") == 0) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		if (self->priv->_fav_id == NULL) {
			_tmp2_ = _vala_strcmp0 (self->priv->_desktop_file, "") != 0;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			_tmp1_ = self->priv->_desktop_file != NULL;
		} else {
			_tmp1_ = FALSE;
		}
		_tmp0_ = _tmp1_;
	}
	if (_tmp0_) {
		char* filepath;
		char* _tmp3_;
		filepath = g_path_get_basename (self->priv->_desktop_file);
		self->priv->_fav_id = (_tmp3_ = g_strconcat ("app-", filepath, NULL), _g_free0 (self->priv->_fav_id), _tmp3_);
		_g_free0 (filepath);
	}
	result = self->priv->_fav_id;
	return result;
}


void unity_launcher_application_controller_set_fav_id (UnityLauncherApplicationController* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_fav_id = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_fav_id), _tmp0_);
	g_object_notify ((GObject *) self, "fav-id");
}


static void _unity_launcher_application_controller_on_favorite_added_unity_favorites_favorite_added (UnityFavorites* _sender, const char* uid, gpointer self) {
	unity_launcher_application_controller_on_favorite_added (self, uid);
}


static void _unity_launcher_application_controller_on_favorite_removed_unity_favorites_favorite_removed (UnityFavorites* _sender, const char* uid, gpointer self) {
	unity_launcher_application_controller_on_favorite_removed (self, uid);
}


static GObject * unity_launcher_application_controller_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityLauncherApplicationController * self;
	parent_class = G_OBJECT_CLASS (unity_launcher_application_controller_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_LAUNCHER_APPLICATION_CONTROLLER (obj);
	{
		UnityFavorites* favorites;
		favorites = unity_favorites_get_default ();
		g_signal_connect_object (favorites, "favorite-added", (GCallback) _unity_launcher_application_controller_on_favorite_added_unity_favorites_favorite_added, self, 0);
		g_signal_connect_object (favorites, "favorite-removed", (GCallback) _unity_launcher_application_controller_on_favorite_removed_unity_favorites_favorite_removed, self, 0);
		self->is_favorite = unity_launcher_application_controller_is_sticky (self);
		unity_launcher_scroller_child_controller_get_child ((UnityLauncherScrollerChildController*) self)->pin_type = UNITY_LAUNCHER_PIN_TYPE_UNPINNED;
		if (unity_launcher_application_controller_is_sticky (self)) {
			unity_launcher_scroller_child_controller_get_child ((UnityLauncherScrollerChildController*) self)->pin_type = UNITY_LAUNCHER_PIN_TYPE_PINNED;
		}
		_g_object_unref0 (favorites);
	}
	return obj;
}


static void unity_launcher_application_controller_class_init (UnityLauncherApplicationControllerClass * klass) {
	unity_launcher_application_controller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityLauncherApplicationControllerPrivate));
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_CLASS (klass)->get_menu_controller = unity_launcher_application_controller_real_get_menu_controller;
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_CLASS (klass)->get_menu_actions = unity_launcher_application_controller_real_get_menu_actions;
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_CLASS (klass)->get_menu_navigation = unity_launcher_application_controller_real_get_menu_navigation;
	UNITY_LAUNCHER_SCROLLER_CHILD_CONTROLLER_CLASS (klass)->activate = unity_launcher_application_controller_real_activate;
	G_OBJECT_CLASS (klass)->get_property = unity_launcher_application_controller_get_property;
	G_OBJECT_CLASS (klass)->set_property = unity_launcher_application_controller_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_launcher_application_controller_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_launcher_application_controller_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_APPLICATION_CONTROLLER_DESKTOP_FILE, g_param_spec_string ("desktop-file", "desktop-file", "desktop-file", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_LAUNCHER_APPLICATION_CONTROLLER_FAV_ID, g_param_spec_string ("fav-id", "fav-id", "fav-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_launcher_application_controller_instance_init (UnityLauncherApplicationController * self) {
	self->priv = UNITY_LAUNCHER_APPLICATION_CONTROLLER_GET_PRIVATE (self);
	self->priv->app = NULL;
	self->priv->_fav_id = g_strdup ("");
	self->is_favorite = FALSE;
}


static void unity_launcher_application_controller_finalize (GObject* obj) {
	UnityLauncherApplicationController * self;
	self = UNITY_LAUNCHER_APPLICATION_CONTROLLER (obj);
	{
	}
	_g_free0 (self->priv->_desktop_file);
	_g_key_file_free0 (self->priv->desktop_keyfile);
	_g_free0 (self->priv->icon_name);
	_g_object_unref0 (self->priv->app);
	_g_object_unref0 (self->priv->menu_client);
	_g_object_unref0 (self->priv->cached_menu);
	_g_free0 (self->priv->_fav_id);
	G_OBJECT_CLASS (unity_launcher_application_controller_parent_class)->finalize (obj);
}


GType unity_launcher_application_controller_get_type (void) {
	static volatile gsize unity_launcher_application_controller_type_id__volatile = 0;
	if (g_once_init_enter (&unity_launcher_application_controller_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityLauncherApplicationControllerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_launcher_application_controller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityLauncherApplicationController), 0, (GInstanceInitFunc) unity_launcher_application_controller_instance_init, NULL };
		GType unity_launcher_application_controller_type_id;
		unity_launcher_application_controller_type_id = g_type_register_static (UNITY_LAUNCHER_TYPE_SCROLLER_CHILD_CONTROLLER, "UnityLauncherApplicationController", &g_define_type_info, 0);
		g_once_init_leave (&unity_launcher_application_controller_type_id__volatile, unity_launcher_application_controller_type_id);
	}
	return unity_launcher_application_controller_type_id__volatile;
}


static void unity_launcher_application_controller_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityLauncherApplicationController * self;
	self = UNITY_LAUNCHER_APPLICATION_CONTROLLER (object);
	switch (property_id) {
		case UNITY_LAUNCHER_APPLICATION_CONTROLLER_DESKTOP_FILE:
		g_value_set_string (value, unity_launcher_application_controller_get_desktop_file (self));
		break;
		case UNITY_LAUNCHER_APPLICATION_CONTROLLER_FAV_ID:
		g_value_set_string (value, unity_launcher_application_controller_get_fav_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void unity_launcher_application_controller_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityLauncherApplicationController * self;
	self = UNITY_LAUNCHER_APPLICATION_CONTROLLER (object);
	switch (property_id) {
		case UNITY_LAUNCHER_APPLICATION_CONTROLLER_DESKTOP_FILE:
		unity_launcher_application_controller_set_desktop_file (self, g_value_get_string (value));
		break;
		case UNITY_LAUNCHER_APPLICATION_CONTROLLER_FAV_ID:
		unity_launcher_application_controller_set_fav_id (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




