#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <glade/glade.h>   
#include <libintl.h>
#include <sys/wait.h>

#include "update-notifier.h"
#include "update.h"

#define UPGRADE_CHECKER PACKAGE_LIB_DIR"/update-notifier/apt-check"

char* actions[][2] = {
   { "/usr/bin/update-manager", N_("Show updates") },
   { "/usr/sbin/synaptic --upgrade-mode --non-interactive --hide-main-window", N_("Install all updates") },
   { "/usr/sbin/synaptic", N_("Package Manager") },
   { "/usr/sbin/synaptic --update-at-startup --non-interactive --hide-main-window", N_("Update package list now") },
   { NULL, NULL }
};




static gboolean
button_release_cb (GtkWidget *widget, 
		   GdkEventButton *event, 
		   TrayApplet *ta)
{
        int index;
	if (event->button == 1 && event->type == GDK_BUTTON_RELEASE) {
   	        index = gconf_client_get_int((GConfClient*)(ta->user_data),
					     GCONF_KEY_DEFAULT_ACTION, NULL);
		//g_print("%s %s\n",actions[index][0],actions[index][1]);
		invoke_with_gksu (actions[index][0], _(actions[index][1]));
	}
	return TRUE;
}

static gboolean
button_press_cb (GtkWidget *widget,
		 GdkEventButton *event,
		 TrayApplet *un)
{
	if (event->button == 3) {
		gtk_menu_popup (GTK_MENU (un->menu), NULL, NULL, NULL, NULL,
				event->button, event->time);
	}
	return TRUE;
}

void
update_trayicon_update_tooltip (TrayApplet *ta, int num_upgrades)
{
   //g_print("update_tooltip: %p %p %p\n", ta, ta->tooltip, ta->eventbox);
   gchar *updates;
   gchar *explanation;

   updates=g_strdup_printf(ngettext("There is %i update available",
				    "There are %i updates available",
				    num_upgrades),
			   num_upgrades);
   explanation = _("Press this icon to show the updates.");

   gtk_tooltips_set_tip(GTK_TOOLTIPS(ta->tooltip), 
			GTK_WIDGET (ta->eventbox), 
			updates, explanation);
   g_free(updates);
}


void 
cb_action(GObject *self, void *user_data)
{
   TrayApplet *un = user_data;
	
   int i = (int)g_object_get_data(G_OBJECT(self), "action");
   invoke_with_gksu (actions[i][0], _(actions[i][1]));

   gconf_client_set_int(un->user_data, GCONF_KEY_DEFAULT_ACTION, i, NULL);
}

void cb_preferences(GObject *self, void *user_data)
{
   invoke_with_gksu("/usr/bin/gnome-software-properties",
		    _("Software preferences"));    
}

void
update_trayicon_create_menu(TrayApplet *ta)
{
	GtkWidget *menuitem;
	GtkAccelGroup *accelgroup;
	int i;

	ta->menu = gtk_menu_new ();

	for(i=0;actions[i][0]!=NULL;i++) {
	   menuitem = gtk_menu_item_new_with_label (_(actions[i][1]));
	   gtk_menu_shell_append (GTK_MENU_SHELL (ta->menu), menuitem);
	   g_object_set_data(G_OBJECT(menuitem), "action", (void*)i);
	   g_signal_connect(G_OBJECT(menuitem), "activate", 
			    G_CALLBACK(cb_action), ta);
	}

	menuitem = gtk_separator_menu_item_new();
	gtk_menu_shell_append (GTK_MENU_SHELL (ta->menu), menuitem);

	menuitem = gtk_image_menu_item_new_from_stock (GTK_STOCK_PREFERENCES, accelgroup);
	gtk_menu_shell_append (GTK_MENU_SHELL (ta->menu), menuitem);
	g_signal_connect(G_OBJECT(menuitem), "activate", 
			 G_CALLBACK(cb_preferences), (void*)ta);

	gtk_widget_show_all (ta->menu);
}

/* this tells the trayicon that apt is downloading something */
void update_apt_is_running(TrayApplet *ta, gboolean is_running)
{
   //  we make the icon insensitive, because we can't make the
   //  EggTrayIcon insensitive (otherwise we don't get a tooltip)
   // FIXME: we need block menu events
   gtk_widget_set_sensitive(GTK_WIDGET(ta->icon), !is_running);
   if(is_running) {
      gtk_tooltips_set_tip(GTK_TOOLTIPS(ta->tooltip), 
			   GTK_WIDGET (ta->eventbox),
			   _("Package Manager is working"),"");
   }
}

/*
 * this function is called when no changes are detected in
 * /var/lib/apt/lists or /var/lib/apt/lists/partial for TIMEOUT_APT_GET_UPDATE
*/
gboolean update_timer_finished(gpointer data)
{
   //g_print("update_time_check()\n");
   UpgradeNotifier *un = (UpgradeNotifier*)data;
   update_apt_is_running(un->update, FALSE);
   update_check(un->update);
   un->update_finished_timer = 0;

   /* return FALSE to remove source */
   return FALSE; 
}

gboolean
update_check (TrayApplet *ta)
{
   int num_upgrades = 0;
   int exit_status = 0;
   gboolean res = FALSE;
   GError error;

   char *cmd[] = { UPGRADE_CHECKER, NULL };
   char *ret;

   if(g_spawn_sync(NULL, cmd, NULL,  
		   G_SPAWN_STDOUT_TO_DEV_NULL, 
		   NULL, NULL, NULL, &ret,
		   &exit_status, &error)) {
      // read the value from childs stderr
      num_upgrades = atoi(ret);
      g_free(ret);
   } else
      g_warning("Error launching %s", UPGRADE_CHECKER);
   
   if (num_upgrades == 0) {
      gtk_widget_hide(GTK_WIDGET(ta->tray_icon));
   } else {
      update_trayicon_update_tooltip(ta, num_upgrades);
      gtk_widget_show(GTK_WIDGET(ta->tray_icon));
   }
   //g_print("upgrades: %i\n", un->num_upgrades);

   return TRUE;
}


void update_tray_icon_init(TrayApplet *ta)
{
	// get gconf
	ta->user_data = gconf_client_get_default();

        g_signal_connect (G_OBJECT(ta->tray_icon),
			  "button-release-event",
			  G_CALLBACK (button_release_cb),
			  ta);
	g_signal_connect (G_OBJECT(ta->tray_icon),
			  "button-press-event",
			  G_CALLBACK (button_press_cb),
			  ta);

	/* Menu initialization */
	update_trayicon_create_menu (ta);

	/* Check for updates for the first time */
	update_check (ta);
}
