/* update-notifier.h
 * Copyright (C) 2004 Michiel Sikkes <michiel@eyesopened.nl>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __UPGRADE_NOTIFIER_H__
#define __UPGRADE_NOTIFIER_H__

#include <gnome.h>
#include <gconf/gconf.h>
#include <gconf/gconf-client.h>
#include <fam.h>
#include "eggtrayicon.h"

#define CLIPBOARD_NAME 	"UPGRADE_NOTIFIER_SELECTION"
#define GCONF_KEY_DEFAULT_ACTION "/apps/update-notifier/default_action"
#define GCONF_KEY_NO_UPDATE_NOTIFICATIONS "/apps/update-notifier/no_show_notifications"

#define HOOKS_DIR "/var/lib/update-notifier/user.d/"

void invoke_with_gksu(gchar *cmd, gchar *descr);


typedef struct _TrayApplet TrayApplet;
struct _TrayApplet 
{
   EggTrayIcon *tray_icon;
   GtkWidget *icon;
   GtkWidget *eventbox;
   GtkTooltips *tooltip;
   GtkWidget *menu;

   void *user_data;
};

typedef struct _UpgradeNotifier UpgradeNotifier;
struct _UpgradeNotifier
{
   TrayApplet *update;
   TrayApplet *hook;

   GConfClient *gconf;
   FAMConnection fc;
   guint update_finished_timer; 

   FAMRequest frq_apt[10];
   FAMRequest frq_hooks;
   
   // bool if we have a dbus connection
   gboolean dbus_connection;
   
   int num_upgrades;
};

#endif /* __UPGRADE_NOTIFIER_H__ */
