#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <ctype.h>


#include "rfc822.h"

#include <glib.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>



void strvacat(char *buf, size_t maxlen, ...)
{
        va_list ap;
        char *str;
        size_t len = strlen(buf);

        va_start(ap, maxlen);

        while (1)
        {
                str = va_arg(ap, char *);
                if (str == NULL)
                        break;
                if (len + strlen(str) > maxlen)
                        break;
                strcat(buf, str);
                len += strlen(str);
        }
        va_end(ap);
}

void strunescape(const char *inbuf, char *outbuf, const size_t maxlen, const int quote)
{
        const char *p = inbuf;
        int i = 0;
        while (*p != 0 && i < maxlen-1)
        {
                /*  Debconf only escapes \n  */
                if (*p == '\\')
                {
                        if (*(p+1) == 'n')
                        {
                                outbuf[i++] = '\n';
                                p += 2;
                        }
                        else if (quote != 0 && (*(p+1) == '"' || *(p+1) == '\\'))
                        {
                                outbuf[i++] = *(p+1);
                                p += 2;
                        }
                        else
                                outbuf[i++] = *p++;
                }
                else
                        outbuf[i++] = *p++;
        }
        outbuf[i] = 0;
}

static char *unescapestr(const char *in)
{
    static char buf[8192];
    if (in == 0) return 0;
    strunescape(in, buf, sizeof(buf), 0);
    return buf;
}

/*
 * Function: rfc822db_parse_stanza
 * Input: a FILE pointer to an open readable file containing a stanza in rfc822 
 *    format.
 * Output: a pointer to a dynamically allocated rfc822_header structure
 * Description: parse a stanza from file into the returned header struct
 * Assumptions: no lines are over 8192 bytes long.
 */

struct rfc822_header* rfc822_parse_stanza(FILE *file)
{
    struct rfc822_header *head, **tail, *cur;
    char buf[8192];

    head = NULL;
    tail = &head;
    cur = NULL;

    /*    fprintf(stderr,"rfc822db_parse_stanza(file)\n");*/
    while (fgets(buf, sizeof(buf), file))
    {
        char *tmp = buf;

        if (*tmp == '\n')
            break;

	if (buf[strlen(buf)-1] == '\n') 
	   buf[strlen(buf)-1] = '\0';

        if (isspace(*tmp))
        {
            /* continuation line, just append it */
            int len;

            if (cur == NULL)
                break; /* should report an error here */

            len = strlen(cur->value) + strlen(tmp) + 2;

            cur->value = realloc(cur->value, len);
	    // tmp+1 here because we don't want the space appear in the enty
            strvacat(cur->value, len, "\n", tmp+1, NULL);
        } 
        else 
        {
            while (*tmp != 0 && *tmp != ':')
                tmp++;
            *tmp++ = '\0';

            cur = g_new0(struct rfc822_header,1);
            if (cur == NULL)
                return NULL;
            cur->header = strdup(buf);

            while (isspace(*tmp))
                tmp++;

            cur->value = strdup(unescapestr(tmp));

            *tail = cur;
            tail = &cur->next;
        }
    }

    return head;
}


char *rfc822_header_lookup(struct rfc822_header *list, const char* key)
{
/*    fprintf(stderr,"rfc822db_header_lookup(list,key=%s)\n",key);*/
    while (list && (strcasecmp(key, list->header) != 0))
        list = list->next;
    if (!list)
        return NULL;
/*    fprintf(stderr,"rfc822db_header_lookup returning: '%s'\n", list->value);*/
    return list->value;
}


void rfc822_header_free_all(struct rfc822_header *list)
{
   while (list) { 
      struct rfc822_header *now = list;
      g_free(list->header);
      g_free(list->value);

      list = list->next;
      g_free(now);
   }
}
