/* armeb-linux.kernel.vmlinux.h
   created from armeb-linux.kernel.vmlinux.bin, 15160 (0x3b38) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2009 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2009 Laszlo Molnar
   Copyright (C) 2000-2009 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ml1050@users.sourceforge.net>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_ARMEB_LINUX_KERNEL_VMLINUX_SIZE    15160
#define STUB_ARMEB_LINUX_KERNEL_VMLINUX_ADLER32 0xfc1b3101
#define STUB_ARMEB_LINUX_KERNEL_VMLINUX_CRC32   0x40d1de90

unsigned char stub_armeb_linux_kernel_vmlinux[15160] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  2,  1, 97,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   0,  1,  0, 40,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0, 18,244,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,
/* 0x0030 */   0, 29,  0, 26,225,160, 16,  2,225,160, 32,  0,225,160,  0, 14,
/* 0x0040 */ 229, 33,192,  4,233, 33, 32, 15,227,160, 48,  0,225,160,208,  1,
/* 0x0050 */ 229,159, 16, 20,229, 45, 48,  4,229,159, 48, 16,229,141, 48,  8,
/* 0x0060 */ 226,141, 48,  8,235,255,255,254,234,  0,  0, 14,  0,  0,  0,  0,
/* 0x0070 */   0,  0,  0,  0,227, 80,  0,  0, 26,  0,  0, 14,229,157,  0, 12,
/* 0x0080 */ 229,157, 16,  8,227,160, 32,  0,227,160, 48,  0,235,255,255,254,
/* 0x0090 */ 232,157,112, 15,225,160,  0,  2,225,160,240, 14,226,  3, 48,255,
/* 0x00a0 */ 227, 83,  0, 80,227, 83,  0, 81, 17,160,240, 14,225,176, 17, 33,
/* 0x00b0 */  19, 80,  0,  0,  1,160,240, 14,226, 65, 16,  1,231,144, 33,  1,
/* 0x00c0 */ 226,  2, 52, 15,227, 83,  4, 11, 26,  0,  0, 12,226,  2, 52,255,
/* 0x00d0 */ 224, 66, 32,  1,227,194, 36,255,225,130, 32,  3,231,128, 33,  1,
/* 0x00e0 */ 227, 81,  0,  0, 26,  0,  0,  2,225,160,240, 14,224,129, 16,  0,
/* 0x00f0 */ 233, 45, 64, 62,227,224, 80,  0,227,160, 65,  2,234,  0,  0, 23,
/* 0x0100 */ 232,189,  0, 26,224, 64,  0,  1,224, 66, 32,  3,229,132, 32,  0,
/* 0x0110 */ 232,189,128, 48,224,148, 64,  4, 17,160,240, 14,228,208, 64,  1,
/* 0x0120 */ 224,164, 64,  4,225,176, 76,  4,225,160,240, 14,227,160, 16,  1,
/* 0x0130 */ 225,160,192, 14,235,  0,  0,  8,224,177, 16,  1,235,  0,  0,  8,
/* 0x0140 */  58,  0,  0, 16,225,160,240, 12,228,208, 48,  1,228,194, 48,  1,
/* 0x0150 */ 235,  0,  0,  8, 42,  0,  0, 21,235,  0,  0, 14,226, 81, 48,  3,
/* 0x0160 */ 227,160, 16,  0, 58,  0,  0, 33,228,208, 80,  1,225,133, 84,  3,
/* 0x0170 */ 225,240, 80,  5, 10,  0,  0,  3,235,  0,  0,  8,224,177, 16,  1,
/* 0x0180 */ 235,  0,  0,  8,224,177, 16,  1, 26,  0,  0, 40,235,  0,  0, 14,
/* 0x0190 */ 226,129, 16,  2,227,117, 12, 13, 50,129, 16,  1,231,210, 48,  5,
/* 0x01a0 */ 226, 81, 16,  1,228,194, 48,  1, 42,  0,  0, 42,234,  0,  0, 23,
/* 0x01b0 */ 233, 45, 64,252,224,129,112,  0,227,224, 80,  0,227,160, 65,  2,
/* 0x01c0 */ 234,  0,  0, 14,232,189,  0, 24,224, 64,  0,  7,224, 66, 32,  3,
/* 0x01d0 */ 229,132, 32,  0,232,189,128,240,228,208, 64,  1,224,164, 64,  4,
/* 0x01e0 */ 225,176, 76,  4,225,160,240, 14,228,208, 48,  1,228,194, 48,  1,
/* 0x01f0 */ 224,148, 64,  4, 11,  0,  0,  8, 42,  0,  0, 12,227,160, 16,  1,
/* 0x0200 */ 234,  0,  0, 23,226, 65, 16,  1,224,148, 64,  4, 11,  0,  0,  8,
/* 0x0210 */ 224,177, 16,  1,224,148, 64,  4, 11,  0,  0,  8,224,177, 16,  1,
/* 0x0220 */ 224,148, 64,  4, 11,  0,  0,  8, 58,  0,  0, 19,226, 81, 48,  3,
/* 0x0230 */ 227,160, 16,  0, 58,  0,  0, 38,228,208, 80,  1,225,133, 84,  3,
/* 0x0240 */ 225,240, 80,  5, 10,  0,  0,  3,225,176, 80,197,234,  0,  0, 40,
/* 0x0250 */ 224,148, 64,  4, 11,  0,  0,  8,224,177, 16,  1,224,148, 64,  4,
/* 0x0260 */  11,  0,  0,  8,224,177, 16,  1, 26,  0,  0, 53,227,160, 16,  1,
/* 0x0270 */ 224,148, 64,  4, 11,  0,  0,  8,224,177, 16,  1,224,148, 64,  4,
/* 0x0280 */  11,  0,  0,  8, 58,  0,  0, 46,226,129, 16,  2,226,129, 16,  1,
/* 0x0290 */ 227,117, 12,  5, 50,129, 16,  1,229,210, 48,  0,231,210, 48,  5,
/* 0x02a0 */ 228,194, 48,  1,226, 81, 16,  1, 26,  0,  0, 57,234,  0,  0, 14,
/* 0x02b0 */ 233, 45, 64,252,224,129,112,  0,227,224, 80,  0,227,160, 65,  2,
/* 0x02c0 */ 234,  0,  0, 14,232,189,  0, 24,224, 64,  0,  7,224, 66, 32,  3,
/* 0x02d0 */ 229,132, 32,  0,232,189,128,240,228,208, 64,  1,224,164, 64,  4,
/* 0x02e0 */ 225,176, 76,  4,225,160,240, 14,228,208, 48,  1,228,194, 48,  1,
/* 0x02f0 */ 224,148, 64,  4, 11,  0,  0,  8, 42,  0,  0, 12,227,160, 16,  1,
/* 0x0300 */ 234,  0,  0, 23,226, 65, 16,  1,224,148, 64,  4, 11,  0,  0,  8,
/* 0x0310 */ 224,161, 16,  1,224,148, 64,  4, 11,  0,  0,  8,224,161, 16,  1,
/* 0x0320 */ 224,148, 64,  4, 11,  0,  0,  8, 58,  0,  0, 19,226, 81, 48,  3,
/* 0x0330 */ 227,160, 16,  0, 58,  0,  0, 39,228,208, 80,  1,225,133, 84,  3,
/* 0x0340 */ 225,240, 80,  5, 10,  0,  0,  3,225,176, 80,197, 42,  0,  0, 54,
/* 0x0350 */ 234,  0,  0, 42,224,148, 64,  4, 11,  0,  0,  8, 42,  0,  0, 54,
/* 0x0360 */ 227,160, 16,  1,224,148, 64,  4, 11,  0,  0,  8, 42,  0,  0, 54,
/* 0x0370 */ 224,148, 64,  4, 11,  0,  0,  8,224,161, 16,  1,224,148, 64,  4,
/* 0x0380 */  11,  0,  0,  8, 58,  0,  0, 46,226,129, 16,  4,234,  0,  0, 58,
/* 0x0390 */ 224,148, 64,  4, 11,  0,  0,  8,224,161, 16,  1,226,129, 16,  2,
/* 0x03a0 */ 227,117, 12,  5, 50,129, 16,  1,224,130, 48,  1,229, 83, 48,  1,
/* 0x03b0 */ 231,210, 48,  5,228,194, 48,  1,226, 81, 16,  1, 26,  0,  0, 62,
/* 0x03c0 */ 234,  0,  0, 14,229,221,192,  0,227, 92,  0, 14, 26,255,255,254,
/* 0x03d0 */ 233, 45, 72,  0,229,208,176,  0,227,160,204,  6,225,160,177,171,
/* 0x03e0 */ 225,160,203, 28,225,160,176, 13,226,140,205, 58,224, 77,208, 12,
/* 0x03f0 */ 229,147,192,  0,229,141, 48,  8,229,141,192,  4,229,141, 32,  0,
/* 0x0400 */ 226,141, 48, 12,227,160,192,  0,228,131,192,  4,225, 83,  0, 11,
/* 0x0410 */  26,  0,  0, 15,226,141, 48, 12,226, 65, 32,  2,225,160, 16,  0,
/* 0x0420 */ 228,209,192,  1,226, 12,192,  7,229,205,192, 18,228,209,192,  1,
/* 0x0430 */ 225,160,  2, 44,229,205,  0, 17,226, 12,192, 15,229,205,192, 16,
/* 0x0440 */ 226,141,  0, 16,235,  0,  0, 33,225,160,208, 11,232,189,136,  0,
/* 0x0450 */ 233, 45, 79,240,226, 77,208, 48,229,141, 48,  0,229,208, 48,  0,
/* 0x0460 */ 229,208, 80,  2,229,208,224,  1,229,157,192,  0,229,141, 48, 20,
/* 0x0470 */ 229,157, 48, 92,227,160, 64,  0,229,140, 64,  0,229,131, 64,  0,
/* 0x0480 */ 229,157,192, 20,229,208, 48,  1,224,140, 48,  3,227,160,204,  3,
/* 0x0490 */ 225,160,195, 28,227,160, 48,  1,225,160,238, 19,225,160, 53, 19,
/* 0x04a0 */ 226,140,206,115,226, 67, 48,  1,226, 78,224,  1,226,128,  0,  4,
/* 0x04b0 */ 226,140,192,  6,229,141, 16,  4,229,141, 48, 12,229,141,224, 16,
/* 0x04c0 */ 229,141,  0,  8,234,  0,  0, 31,229,157,  0,  8,227,160, 27,  1,
/* 0x04d0 */ 225,131, 16,176,225, 84,  0, 12,225,160, 48,132,226,132, 64,  1,
/* 0x04e0 */  26,  0,  0, 28,229,157, 48,  4,227,160, 96,  0,224,131,144,  2,
/* 0x04f0 */ 225,160,224,  3,225,160, 32,  6,229,157, 80,  4,224,101, 48,  9,
/* 0x0500 */ 225, 82,  0,  3,226,142,224,  1, 10,  0,  2, 73,231,210, 48,  5,
/* 0x0510 */ 226,130, 32,  1,227, 82,  0,  5,225,131,100,  6, 26,  0,  0, 40,
/* 0x0520 */ 227,160,176,  0,227,160,192,  1,225,160,112, 11,227,224,  0,  0,
/* 0x0530 */ 229,141,192, 44,229,141,176, 24,229,141,192, 28,229,141,192, 32,
/* 0x0540 */ 229,141,192, 36,234,  0,  2, 57,227,224,132,255,225, 80,  0,  8,
/* 0x0550 */ 138,  0,  0, 68,225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,
/* 0x0560 */ 225,160,  4,  0,225,131,100,  6,229,157, 16, 12,229,157, 32, 24,
/* 0x0570 */ 224, 11,160,  1,225,160, 18,  2,224,138, 48,  1,225,160, 80,131,
/* 0x0580 */ 229,157, 48,  8,225,147,192,181,225,160, 53,160,224,  4,  3,156,
/* 0x0590 */ 225, 86,  0,  4, 42,  0,  0,185,229,157,  0, 20,226, 96, 48,  8,
/* 0x05a0 */ 225,160, 51, 87,229,157, 16, 16,224, 11, 32,  1,224,131, 48, 18,
/* 0x05b0 */ 229,157,  0,  8,227,160, 44,  6,224, 34,  2,147,229,157, 16, 24,
/* 0x05c0 */ 226,108, 59,  2,227, 81,  0,  6,224,140, 50,195,226,130,142,230,
/* 0x05d0 */ 225,128, 48,181,226,136,128, 12,209,160,  0,  4,211,160, 16,  1,
/* 0x05e0 */ 218,  0,  0,164,229,157, 32, 44,229,157, 80, 84,224, 98, 48, 11,
/* 0x05f0 */ 231,213,112,  3,225,160,  0,  4,227,160, 16,  1,225,160,112,135,
/* 0x0600 */ 226,  7, 92,  1,225,160,160,129,224,136, 48,133,224,131, 48, 10,
/* 0x0610 */ 227, 80,  4,  1,226,131, 76,  2,226,129,192,  1, 42,  0,  0,119,
/* 0x0620 */ 225, 94,  0,  9,225,160,  4,  0, 10,  0,  2, 73,228,222, 48,  1,
/* 0x0630 */ 225,131,100,  6,225,212, 48,176,225,160, 37,160,224,129, 16, 12,
/* 0x0640 */ 224, 12,  2,147,226, 99, 43,  2,225, 86,  0, 12,224,131, 34,194,
/* 0x0650 */ 224, 67, 50,163, 42,  0,  0,135,227, 85,  0,  0,225,160,  0, 12,
/* 0x0660 */ 225,196, 32,176,225,160, 16, 10, 10,  0,  0,140,225,160,  0, 12,
/* 0x0670 */ 234,  0,  0,164,227, 85,  0,  0,225,196, 48,176,224,108, 96,  6,
/* 0x0680 */ 224,108,  0,  0, 10,  0,  0,164,227, 81,  0,255,202,  0,  0,168,
/* 0x0690 */ 234,  0,  0,105,227, 80,  4,  1,224,129, 16,  3, 42,  0,  0,151,
/* 0x06a0 */ 225, 94,  0,  9,225,160,  4,  0, 10,  0,  2, 73,228,222, 48,  1,
/* 0x06b0 */ 225,131,100,  6,225,152, 48,180,225,160, 37,160,224, 12,  2,147,
/* 0x06c0 */ 226, 99, 43,  2,225, 86,  0, 12,224, 67, 82,163,224,131, 50,194,
/* 0x06d0 */  49,136, 48,180, 33,136, 80,180,224,108,  0,  0, 49,160, 16,  4,
/* 0x06e0 */  49,160,  0, 12, 32,108, 96,  6,227, 81,  0,255,225,160, 64,129,
/* 0x06f0 */ 226,129, 48,  1,218,  0,  0,143,229,157,192, 24,226,  1,112,255,
/* 0x0700 */ 227, 92,  0,  3,229,157, 16, 84,211,160, 32,  0,231,193,112, 11,
/* 0x0710 */ 226,139,176,  1,213,141, 32, 24,218,  0,  2, 57,229,157, 48, 24,
/* 0x0720 */ 227, 83,  0,  9,197,157, 80, 24,210, 67, 48,  3,194, 69, 80,  6,
/* 0x0730 */ 213,141, 48, 24,197,141, 80, 24,234,  0,  2, 57,224, 76, 50,172,
/* 0x0740 */ 224,100, 32,  0,229,157,192,  8,225, 82,  0,  8,225,140, 48,181,
/* 0x0750 */ 224,100, 96,  6,138,  0,  0,197,225, 94,  0,  9, 10,  0,  2, 73,
/* 0x0760 */ 228,222, 48,  1,225,160, 36,  2,225,131,100,  6,229,157,  0,  8,
/* 0x0770 */ 229,157, 48, 24,224,128,112,131,226,135, 13,  6,225,208,192,176,
/* 0x0780 */ 225,160, 53,162,224,  4,  3,156,225, 86,  0,  4, 42,  0,  0,225,
/* 0x0790 */ 229,157, 32, 24,229,157, 80,  8,227, 82,  0,  6,226,108, 59,  2,
/* 0x07a0 */ 226,133, 30,102,195,160, 32,  3,229,157, 80, 32,211,160, 32,  0,
/* 0x07b0 */ 224,140, 50,195,229,141, 32, 24,229,157,192, 28,229,157, 32, 44,
/* 0x07c0 */ 229,141, 80, 36,226,129, 16,  4,225,160, 80,  4,229,141,192, 32,
/* 0x07d0 */ 229,141, 32, 28,225,192, 48,176,234,  0,  1, 98,224,100, 32,  2,
/* 0x07e0 */ 224, 76, 50,172,225, 82,  0,  8,225,192, 48,176,224,100, 96,  6,
/* 0x07f0 */ 138,  0,  0,236,225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,
/* 0x0800 */ 225,160, 36,  2,225,131,100,  6,226,135, 95,102,225,213,192,176,
/* 0x0810 */ 225,160, 53,162,224,  4,  3,156,225, 86,  0,  4, 42,  0,  1, 26,
/* 0x0820 */ 226,108, 59,  2,224,140, 50,195,225, 84,  0,  8,225,197, 48,176,
/* 0x0830 */ 138,  0,  0,252,225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,
/* 0x0840 */ 225,160, 68,  4,225,131,100,  6,229,157, 80,  8,224,133, 48,129,
/* 0x0850 */ 224,131, 48,138,226,131, 30, 30,225,209,192,176,225,160, 53,164,
/* 0x0860 */ 224,  2,  3,156,225, 86,  0,  2, 32, 98, 96,  6, 32, 76, 50,172,
/* 0x0870 */  32, 98, 80,  4, 42,  0,  1, 50,226,108, 59,  2,224,140, 50,195,
/* 0x0880 */ 227, 91,  0,  0,225,193, 48,176, 10,  0,  2, 73,229,157,192, 44,
/* 0x0890 */ 229,157, 16, 24,229,157,  0, 84,224,108, 48, 11,231,208,112,  3,
/* 0x08a0 */ 227, 81,  0,  6,195,160, 16, 11,211,160, 16,  9,229,141, 16, 24,
/* 0x08b0 */ 231,192,112, 11,225,160,  0,  2,226,139,176,  1,234,  0,  2, 57,
/* 0x08c0 */ 224,100, 32,  2,224, 76, 50,172,225, 82,  0,  8,225,197, 48,176,
/* 0x08d0 */ 224,100, 96,  6,138,  0,  1, 37,225, 94,  0,  9, 10,  0,  2, 73,
/* 0x08e0 */ 228,222, 48,  1,225,160, 36,  2,225,131,100,  6,226,135, 30, 27,
/* 0x08f0 */ 225,209,192,176,225,160, 53,162,224,  4,  3,156,225, 86,  0,  4,
/* 0x0900 */  42,  0,  1, 52,229,157, 80, 44,226,108, 59,  2,229,157, 32, 28,
/* 0x0910 */ 224,140, 50,195,229,141, 80, 28,225,160, 80,  4,229,141, 32, 44,
/* 0x0920 */ 225,193, 48,176,234,  0,  1, 90,224,100, 32,  2,224, 76, 50,172,
/* 0x0930 */ 225, 82,  0,  8,225,193, 48,176,224,100, 96,  6,138,  0,  1, 63,
/* 0x0940 */ 225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,225,160, 36,  2,
/* 0x0950 */ 225,131,100,  6,226,135, 31,114,225,209,192,176,225,160, 53,162,
/* 0x0960 */ 224,  4,  3,156,225, 86,  0,  4, 42,  0,  1, 78,226,108, 59,  2,
/* 0x0970 */ 229,157, 32, 32,224,140, 50,195,229,157,  0, 44,229,157,192, 28,
/* 0x0980 */ 225,160, 80,  4,229,141,192, 32,229,141,  0, 28,234,  0,  1, 49,
/* 0x0990 */ 224, 76, 50,172,225,193, 48,176,229,157,192, 44,226,141, 16, 32,
/* 0x09a0 */ 232,145,  0, 10,224,100, 80,  2,229,157, 32, 28,229,141, 16, 36,
/* 0x09b0 */ 229,141, 32, 32,229,141,192, 28,229,141, 48, 44,224,100, 96,  6,
/* 0x09c0 */ 229,157, 32, 24,229,157,  0,  8,227, 82,  0,  6,195,160, 32, 11,
/* 0x09d0 */ 211,160, 32,  8,226,128, 30,166,229,141, 32, 24,226,129, 16,  8,
/* 0x09e0 */ 227,224,116,255,225, 85,  0,  7,138,  0,  1,106,225, 94,  0,  9,
/* 0x09f0 */  10,  0,  2, 73,228,222, 48,  1,225,160, 84,  5,225,131,100,  6,
/* 0x0a00 */ 225,209,192,176,225,160, 53,165,224,  4,  3,156,225, 86,  0,  4,
/* 0x0a10 */  42,  0,  1,120,224,129, 34, 10,226,108, 59,  2,224,140, 50,195,
/* 0x0a20 */ 226,130, 80,  4,225,160,  0,  4,227,160,160,  3,227,160,128,  0,
/* 0x0a30 */ 225,193, 48,176,234,  0,  1,152,224,100, 32,  5,224, 76, 50,172,
/* 0x0a40 */ 225, 82,  0,  7,224,100, 96,  6,225,193, 48,176,138,  0,  1,131,
/* 0x0a50 */ 225, 94,  0,  9, 10,  0,  2, 73,228,222, 48,  1,225,160, 36,  2,
/* 0x0a60 */ 225,131,100,  6,225,209,192,178,225,160, 53,162,224,  4,  3,156,
/* 0x0a70 */ 225, 86,  0,  4, 42,  0,  1,145,224,129, 34, 10,226,108, 59,  2,
/* 0x0a80 */ 224,140, 50,195,226,130, 95, 65,225,160,  0,  4,227,160,160,  3,
/* 0x0a90 */ 227,160,128,  8,225,193, 48,178,234,  0,  1,152,224, 76, 50,172,
/* 0x0aa0 */ 225,193, 48,178,224,100, 96,  6,224,100,  0,  2,226,129, 95,129,
/* 0x0ab0 */ 227,160,160,  8,227,160,128, 16,225,160,112, 10,227,160, 16,  1,
/* 0x0ac0 */ 226,129, 48,  1,227, 80,  4,  1,225,160, 64,129,224,129, 16,  3,
/* 0x0ad0 */  42,  0,  1,164,225, 94,  0,  9,225,160,  4,  0, 10,  0,  2, 73,
/* 0x0ae0 */ 228,222, 48,  1,225,131,100,  6,225,149, 48,180,225,160, 37,160,
/* 0x0af0 */ 224, 12,  2,147,226, 99, 43,  2,225, 86,  0, 12,224,131, 34,194,
/* 0x0b00 */ 224, 67, 50,163,224,108,  0,  0, 49,160, 16,  4, 49,160,  0, 12,
/* 0x0b10 */  49,133, 32,180, 32,108, 96,  6, 33,133, 48,180,226, 87,112,  1,
/* 0x0b20 */  26,  0,  1,154,227,160, 32,  1,224, 65, 58, 18,229,157, 80, 24,
/* 0x0b30 */ 224,131, 48,  8,227, 85,  0,  3,229,141, 48, 40,202,  0,  2, 36,
/* 0x0b40 */ 229,157,192,  8,227, 83,  0,  3,163,160, 48,  3,224,140, 51,131,
/* 0x0b50 */ 226,131, 94, 54,225,160,112,  2,227,160,128,  6,226,135, 48,  1,
/* 0x0b60 */ 227, 80,  4,  1,225,160, 64,135,224,135,112,  3, 42,  0,  1,203,
/* 0x0b70 */ 225, 94,  0,  9,225,160,  4,  0, 10,  0,  2, 73,228,222, 48,  1,
/* 0x0b80 */ 225,131,100,  6,225,149, 48,180,225,160, 37,160,224, 12,  2,147,
/* 0x0b90 */ 226, 99, 43,  2,225, 86,  0, 12,224,131, 34,194,224, 67, 50,163,
/* 0x0ba0 */ 224,108,  0,  0, 49,160,112,  4, 49,160,  0, 12, 49,133, 32,180,
/* 0x0bb0 */  32,108, 96,  6, 33,133, 48,180,226, 88,128,  1, 26,  0,  1,193,
/* 0x0bc0 */ 226, 71, 32, 64,227, 82,  0,  3,209,160, 80,  2,218,  0,  2, 30,
/* 0x0bd0 */ 225,160, 64,194,227, 82,  0, 13,226,  2, 48,  1,226, 68,112,  1,
/* 0x0be0 */ 227,131,192,  2,194, 68, 64,  5,193,160, 32,  8,202,  0,  1,237,
/* 0x0bf0 */ 225,160, 87, 28,229,157, 16,  8,224,129, 48,133,224, 67, 48,130,
/* 0x0c00 */ 226,131, 78, 85,226,132, 64, 14,234,  0,  2,  1,227, 80,  4,  1,
/* 0x0c10 */ 226,130, 32,  1, 42,  0,  1,245,225, 94,  0,  9,225,160,  4,  0,
/* 0x0c20 */  10,  0,  2, 73,228,222, 48,  1,225,131,100,  6,225,160,  0,160,
/* 0x0c30 */ 225, 86,  0,  0,225,160,192,140, 32, 96, 96,  6, 35,140,192,  1,
/* 0x0c40 */ 225, 82,  0,  4, 26,  0,  1,237,229,157, 32,  8,226,130, 77, 25,
/* 0x0c50 */ 226,132, 64,  4,225,160, 82, 12,227,160,112,  4,227,160,160,  1,
/* 0x0c60 */ 225,160,128, 10,227, 80,  4,  1,225,160, 16,136,226,136,192,  1,
/* 0x0c70 */  42,  0,  2, 12,225, 94,  0,  9,225,160,  4,  0, 10,  0,  2, 73,
/* 0x0c80 */ 228,222, 48,  1,225,131,100,  6,225,148, 48,177,225,160, 37,160,
/* 0x0c90 */ 224,136,128, 12,224, 12,  2,147,226, 99, 43,  2,225, 86,  0, 12,
/* 0x0ca0 */ 224,131, 34,194,224, 67, 50,163, 33,133, 80, 10, 49,160,128,  1,
/* 0x0cb0 */  49,160,  0, 12, 49,132, 32,177, 33,132, 48,177, 32,108, 96,  6,
/* 0x0cc0 */  32,108,  0,  0,226, 87,112,  1,225,160,160,138, 26,  0,  2,  3,
/* 0x0cd0 */ 226,149, 80,  1,229,141, 80, 44, 10,  0,  2, 60,229,157, 48, 24,
/* 0x0ce0 */ 226,131, 48,  7,229,141, 48, 24,229,157, 80, 44,225, 85,  0, 11,
/* 0x0cf0 */ 138,  0,  2, 73,229,157,192, 40,229,157, 16, 84,224,101, 48, 11,
/* 0x0d00 */ 226,140, 32,  2,224,129, 64,  3,224,129,192, 11,226, 82, 32,  1,
/* 0x0d10 */ 229,157, 80, 88,  3,160, 48,  0, 19,160, 48,  1,226,139,176,  1,
/* 0x0d20 */ 225, 91,  0,  5, 35,160, 48,  0, 50,  3, 48,  1,228,212,112,  1,
/* 0x0d30 */ 227, 83,  0,  0,228,204,112,  1, 26,  0,  2, 45,229,157,192, 88,
/* 0x0d40 */ 225, 91,  0, 12, 58,  0,  0, 60,227, 80,  4,  1, 42,  0,  2, 65,
/* 0x0d50 */ 225, 94,  0,  9, 10,  0,  2, 73,226,142,224,  1,229,157,  0,  4,
/* 0x0d60 */ 229,157, 16,  0,229,157, 32, 92,224, 96, 48, 14,227,160,  0,  0,
/* 0x0d70 */ 229,129, 48,  0,229,130,176,  0,234,  0,  2, 74,227,160,  0,  1,
/* 0x0d80 */ 226,141,208, 48,232,189,143,240,233, 45, 79,248,224,130,192,  1,
/* 0x0d90 */ 229,157,144, 40,229,157,112, 44,225,160,128,  1,224,135,160,  9,
/* 0x0da0 */ 226,128,176,  4,229,208, 96,  0,229,208, 80,  1,229,208, 64,  2,
/* 0x0db0 */ 224,133,224,  6,227,224,112,  0,225,224, 85, 23,225,224, 68, 23,
/* 0x0dc0 */ 227,160, 48,  1,227,160, 32,  1,227,160, 16,  1,227,160,  0,  1,
/* 0x0dd0 */ 233, 45, 95,255,227,160, 96,  0,229,141, 96, 28,227,160, 44,  3,
/* 0x0de0 */ 225,160, 46, 18,226,130, 32, 54,226,130, 44,  7,225,160, 16, 11,
/* 0x0df0 */ 227,160, 11,  1,227,128,  3,  1,228,129,  0,  4,226, 82, 32,  2,
/* 0x0e00 */ 202,  0,  0, 26,226,136,  0,  5,235,  0,  1,  5,225, 80,  0,  8,
/* 0x0e10 */  26,  0,  0, 30,229,157, 48, 36,229,157, 32, 16,224, 73, 64,  3,
/* 0x0e20 */ 224,  4,  0,  2,229,141,  0, 44,224,128,  2,  6,226,139, 16,  0,
/* 0x0e30 */ 235,  0,  1,  9, 26,  0,  0, 80,229,157, 48, 20,229,157, 32, 24,
/* 0x0e40 */ 224,  3, 48,  4,229,221,  0, 28,225,160, 50, 19,226, 98, 32,  8,
/* 0x0e50 */ 224,131, 50, 48,226,139,160,108,224,131, 48,131,226,138,172, 14,
/* 0x0e60 */ 227,160,  0,  1,224,138,164,131,227, 86,  0,  7, 58,  0,  0, 69,
/* 0x0e70 */ 229,157, 16,  0,231, 89, 80,  1,225,160, 80,133,226,138, 28,  2,
/* 0x0e80 */ 226,  5, 76,  1,224,129, 16,132,235,  0,  1, 11,226,  0, 48,  1,
/* 0x0e90 */ 225, 83,  4, 36, 26,  0,  0, 71,227, 80, 12,  1, 58,  0,  0, 58,
/* 0x0ea0 */ 234,  0,  0, 73,225,160, 16, 10,235,  0,  1, 11,227, 80, 12,  1,
/* 0x0eb0 */  58,  0,  0, 69,227,160, 48,  6,227, 86,  0, 10, 51,160, 48,  3,
/* 0x0ec0 */ 227, 86,  0,  4, 49,160, 48,  6,224, 70, 96,  3,234,  0,  0,112,
/* 0x0ed0 */ 226,139, 29,  6,235,  0,  1,  8, 26,  0,  0, 95,229,157, 48,  8,
/* 0x0ee0 */ 229,157, 32,  4,229,157, 16,  0,229,141, 48, 12,229,141, 32,  8,
/* 0x0ef0 */ 229,141, 16,  4,227, 86,  0,  7,227,160, 96,  3, 51,160, 96,  0,
/* 0x0f00 */ 226,139,160,100,226,138,172,  6,234,  0,  0,135,226,139, 31,102,
/* 0x0f10 */ 235,  0,  1,  8, 26,  0,  0,114,229,157, 48, 44,226,139, 30, 30,
/* 0x0f20 */ 224,131,  2,  6,235,  0,  1,  9, 26,  0,  0,130,227, 86,  0,  7,
/* 0x0f30 */ 227,160, 96, 11, 51,160, 96,  9,229,157, 48, 36,229,157, 16,  0,
/* 0x0f40 */ 224, 73, 64,  3,225, 84,  0,  1, 58,  0,  0,253,231, 89,  0,  1,
/* 0x0f50 */ 228,201,  0,  1,234,  0,  0,237,226,139, 30, 27,235,  0,  1,  8,
/* 0x0f60 */ 229,157, 64,  4, 10,  0,  0,127,226,139, 31,114,235,  0,  1,  8,
/* 0x0f70 */ 229,157, 64,  8, 10,  0,  0,125,229,157, 48,  8,229,157, 64, 12,
/* 0x0f80 */ 229,141, 48, 12,229,157, 48,  4,229,141, 48,  8,229,157, 16,  0,
/* 0x0f90 */ 229,141, 64,  0,229,141, 16,  4,227, 86,  0,  7,227,160, 96, 11,
/* 0x0fa0 */  51,160, 96,  8,226,139,160,104,226,138,172, 10,226,138, 16,  0,
/* 0x0fb0 */ 235,  0,  1, 10, 26,  0,  0,144,229,157, 48, 44,226,138, 80,  4,
/* 0x0fc0 */ 227,160, 32,  0,224,133, 82,  3,227,160, 64,  8,234,  0,  0,156,
/* 0x0fd0 */ 226,138, 16,  2,235,  0,  1, 10, 26,  0,  0,153,229,157, 48, 44,
/* 0x0fe0 */ 226,138, 95, 65,227,160, 32,  8,224,133, 82,  3,227,160, 64,  8,
/* 0x0ff0 */ 234,  0,  0,156,226,138, 95,129,227,160, 32, 16,227,160, 76,  1,
/* 0x1000 */ 229,141, 32, 52,227,160,  0,  1,225,160, 16,  5,235,  0,  1, 11,
/* 0x1010 */ 224, 80, 48,  4, 58,  0,  0,158,229,157, 80, 52,224,133, 80,  3,
/* 0x1020 */ 229,141, 80, 52,229,157, 16,  0,227, 86,  0,  4, 42,  0,  0,225,
/* 0x1030 */ 226,134, 96,  7,227, 85,  0,  4, 35,160, 80,  3,224,139, 83,133,
/* 0x1040 */ 226,133, 94, 54,227,160,  0,  1,227,160, 64, 64,225,160, 16,  5,
/* 0x1050 */ 235,  0,  1, 11,224, 80, 48,  4, 58,  0,  0,175,229,141, 48, 44,
/* 0x1060 */ 227, 83,  0,  4, 58,  0,  0,221,225,160, 64,163,226, 68, 64,  1,
/* 0x1070 */ 226,  3, 16,  1,227,129, 16,  2,227, 83,  0, 14, 42,  0,  0,194,
/* 0x1080 */ 225,160, 20, 17,226,139,160, 94,224, 65, 48,  3,226,138,172,  5,
/* 0x1090 */ 224,138,160,131,234,  0,  0,206,226, 68, 64,  4,235,  0,  0,255,
/* 0x10a0 */ 225,160,112,167,225, 92,  0,  7, 32, 76,192,  7,224,161, 16,  1,
/* 0x10b0 */ 226, 84, 64,  1, 26,  0,  0,195,226,139,160, 68,226,138,172,  6,
/* 0x10c0 */ 225,160, 18,  1,227,160, 64,  4,229,141, 16,  0,227,160, 80,  1,
/* 0x10d0 */ 227,160,  0,  1,225,160, 16, 10,235,  0,  1, 11,227, 16,  0,  1,
/* 0x10e0 */  10,  0,  0,216,229,157, 16,  0,225,129, 16,  5,229,141, 16,  0,
/* 0x10f0 */ 225,160, 80,133,226, 84, 64,  1, 26,  0,  0,209,229,157, 16,  0,
/* 0x1100 */ 234,  0,  0,222,229,157, 16, 44,226,145, 16,  1,229,141, 16,  0,
/* 0x1110 */ 229,157, 80, 52,229,157, 48, 36,226,133, 80,  2,224, 73, 48,  3,
/* 0x1120 */ 225, 81,  0,  3,138,  0,  0,253,229,157, 32, 40,231, 89,  0,  1,
/* 0x1130 */ 228,201,  0,  1,225, 89,  0,  2, 42,  0,  0,241,226, 85, 80,  1,
/* 0x1140 */  26,  0,  0,231,229,205,  0, 28,229,157, 32, 40,225, 89,  0,  2,
/* 0x1150 */  58,  0,  0, 33,235,  0,  0,255,227,160,  0,  0,229,157, 32, 32,
/* 0x1160 */ 224, 72, 48,  2,229,157, 32, 56,229,130, 48,  0,229,157, 32, 36,
/* 0x1170 */ 224, 73, 48,  2,229,157, 32,104,229,130, 48,  0,226,141,208, 60,
/* 0x1180 */ 232,189,143,240,227,160,  0,  1,234,  0,  0,243,227, 87,  4,  1,
/* 0x1190 */  33,160,240, 14,229,157, 48, 48,225,160,116,  7,225, 83,  0,  8,
/* 0x11a0 */  10,  0,  0,253,228,216, 48,  1,225,131,196, 12,225,160,240, 14,
/* 0x11b0 */ 225,160,  0,  6,224,129, 16,128,227,160,  0,  0,224,129, 16,128,
/* 0x11c0 */ 227, 87,  4,  1,225,160, 32, 14, 59,  0,  1,  1,225,209, 48,176,
/* 0x11d0 */ 225,160,229,167,224, 14, 14,147,225, 92,  0, 14, 49,160,112, 14,
/* 0x11e0 */  32, 71,112, 14, 50, 99,235,  2, 32, 76,192, 14, 48,131, 50,174,
/* 0x11f0 */  32, 67, 50,163,224,176,  0,  0,225,193, 48,176,225,160,240,  2,
/* 0x1200 */  85, 80, 88, 33,161,216,208,213,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1210 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0, 45,
/* 0x1220 */ 102,105,108,101, 32,102,111,114,109, 97,116, 32,101,108,102, 51,
/* 0x1230 */  50, 45, 98,105,103, 97,114,109, 10, 10, 83,101, 99,116,105,111,
/* 0x1240 */ 110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32,
/* 0x1250 */  32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32,
/* 0x1260 */  86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32,
/* 0x1270 */  32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,
/* 0x1280 */ 103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 76, 73,
/* 0x1290 */  78, 85, 88, 48, 48, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x12a0 */  48, 48, 52, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x12b0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x12c0 */  51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x12d0 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x12e0 */  78, 76, 89, 10, 32, 32, 49, 32, 76, 73, 78, 85, 88, 48, 49, 48,
/* 0x12f0 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 52, 32, 32,
/* 0x1300 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1310 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 55, 99, 32, 32, 50, 42,
/* 0x1320 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x1330 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32,
/* 0x1340 */  50, 32, 76, 73, 78, 85, 88, 48, 50, 48, 32, 32, 32, 32, 32, 32,
/* 0x1350 */  48, 48, 48, 48, 48, 48, 48, 99, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1360 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1370 */  48, 48, 48, 48, 57, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1380 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x1390 */  10, 32, 32, 51, 32, 99,116,111,107, 51, 50, 46, 48, 48, 32, 32,
/* 0x13a0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48,
/* 0x13b0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x13c0 */  32, 48, 48, 48, 48, 48, 48, 57, 99, 32, 32, 50, 42, 42, 48, 32,
/* 0x13d0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,
/* 0x13e0 */  78, 76, 89, 10, 32, 32, 52, 32, 99,116,111,107, 51, 50, 46, 53,
/* 0x13f0 */  48, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32,
/* 0x1400 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1410 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 97, 48, 32, 32, 50, 42,
/* 0x1420 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x1430 */  65, 68, 79, 78, 76, 89, 10, 32, 32, 53, 32, 99,116,111,107, 51,
/* 0x1440 */  50, 46, 53, 49, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1450 */  52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1460 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 97, 52, 32,
/* 0x1470 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x1480 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 54, 32, 99,116,
/* 0x1490 */ 111,107, 51, 50, 46, 49, 48, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x14a0 */  48, 48, 52, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x14b0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x14c0 */  97, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x14d0 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x14e0 */  78, 76, 89, 10, 32, 32, 55, 32, 76, 73, 78, 85, 88, 48, 51, 48,
/* 0x14f0 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1500 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1510 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48,101, 99, 32, 32, 50, 42,
/* 0x1520 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x1530 */  65, 68, 79, 78, 76, 89, 10, 32, 32, 56, 32, 78, 82, 86, 50, 66,
/* 0x1540 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 99,
/* 0x1550 */  52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1560 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,101, 99, 32,
/* 0x1570 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x1580 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x1590 */  10, 32, 32, 57, 32, 78, 82, 86, 50, 68, 32, 32, 32, 32, 32, 32,
/* 0x15a0 */  32, 32, 32, 48, 48, 48, 48, 48, 49, 48, 48, 32, 32, 48, 48, 48,
/* 0x15b0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x15c0 */  32, 48, 48, 48, 48, 48, 49, 98, 48, 32, 32, 50, 42, 42, 48, 32,
/* 0x15d0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x15e0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 48, 32, 78,
/* 0x15f0 */  82, 86, 50, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x1600 */  48, 48, 49, 49, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1610 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1620 */  50, 98, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1630 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x1640 */  79, 78, 76, 89, 10, 32, 49, 49, 32, 76, 90, 77, 65, 95, 69, 76,
/* 0x1650 */  70, 48, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 56, 99, 32,
/* 0x1660 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1670 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 51, 99, 52, 32, 32, 50,
/* 0x1680 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x1690 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x16a0 */  49, 50, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32,
/* 0x16b0 */  32, 48, 48, 48, 48, 48, 57, 51, 56, 32, 32, 48, 48, 48, 48, 48,
/* 0x16c0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x16d0 */  48, 48, 48, 48, 52, 53, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x16e0 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x16f0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 51, 32, 76, 90, 77,
/* 0x1700 */  65, 95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x1710 */  52, 55, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1720 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,100, 56,
/* 0x1730 */  56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1740 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x1750 */  76, 89, 10, 32, 49, 52, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51,
/* 0x1760 */  48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1770 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1780 */  48, 32, 32, 48, 48, 48, 48, 49, 50, 48, 48, 32, 32, 50, 42, 42,
/* 0x1790 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x17a0 */  68, 79, 78, 76, 89, 10, 32, 49, 53, 32, 85, 80, 88, 49, 72, 69,
/* 0x17b0 */  65, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50, 48,
/* 0x17c0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x17d0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 50, 48, 48, 32, 32,
/* 0x17e0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x17f0 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 83, 89, 77, 66, 79, 76, 32,
/* 0x1800 */  84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1810 */ 108, 32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 88, 48, 48, 48,
/* 0x1820 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 73, 78, 85, 88, 48,
/* 0x1830 */  48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x1840 */  32,100, 32, 32, 99,116,111,107, 51, 50, 46, 48, 48,  9, 48, 48,
/* 0x1850 */  48, 48, 48, 48, 48, 48, 32, 99,116,111,107, 51, 50, 46, 48, 48,
/* 0x1860 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x1870 */  32, 32, 99,116,111,107, 51, 50, 46, 49, 48,  9, 48, 48, 48, 48,
/* 0x1880 */  48, 48, 48, 48, 32, 99,116,111,107, 51, 50, 46, 49, 48, 10, 48,
/* 0x1890 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x18a0 */  76, 73, 78, 85, 88, 48, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x18b0 */  48, 32, 76, 73, 78, 85, 88, 48, 51, 48, 10, 48, 48, 48, 48, 48,
/* 0x18c0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50,
/* 0x18d0 */  66,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 66,
/* 0x18e0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x18f0 */  32, 32, 78, 82, 86, 50, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1900 */  32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1910 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 69,  9, 48, 48,
/* 0x1920 */  48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48,
/* 0x1930 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90,
/* 0x1940 */  77, 65, 95, 69, 76, 70, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x1950 */  48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48,
/* 0x1960 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90,
/* 0x1970 */  77, 65, 95, 68, 69, 67, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x1980 */  48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x1990 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90,
/* 0x19a0 */  77, 65, 95, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x19b0 */  48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x19c0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90,
/* 0x19d0 */  77, 65, 95, 68, 69, 67, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x19e0 */  48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48,
/* 0x19f0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 73,
/* 0x1a00 */  78, 85, 88, 48, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1a10 */  76, 73, 78, 85, 88, 48, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x1a20 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 73, 78, 85, 88, 48,
/* 0x1a30 */  50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 73, 78, 85,
/* 0x1a40 */  88, 48, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x1a50 */  32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46, 53, 48,  9,
/* 0x1a60 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 99,116,111,107, 51, 50, 46,
/* 0x1a70 */  53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x1a80 */  32,100, 32, 32, 99,116,111,107, 51, 50, 46, 53, 49,  9, 48, 48,
/* 0x1a90 */  48, 48, 48, 48, 48, 48, 32, 99,116,111,107, 51, 50, 46, 53, 49,
/* 0x1aa0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x1ab0 */  32, 32, 85, 80, 88, 49, 72, 69, 65, 68,  9, 48, 48, 48, 48, 48,
/* 0x1ac0 */  48, 48, 48, 32, 85, 80, 88, 49, 72, 69, 65, 68, 10, 48, 48, 48,
/* 0x1ad0 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x1ae0 */  78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 77, 69, 84,
/* 0x1af0 */  72, 79, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x1b00 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48,
/* 0x1b10 */  48, 48, 48, 32, 67, 79, 77, 80, 82, 69, 83, 83, 69, 68, 95, 76,
/* 0x1b20 */  69, 78, 71, 84, 72, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1b30 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48,
/* 0x1b40 */  48, 48, 48, 48, 48, 32, 85, 78, 67, 79, 77, 80, 82, 69, 83, 83,
/* 0x1b50 */  69, 68, 95, 76, 69, 78, 71, 84, 72, 10, 48, 48, 48, 48, 48, 48,
/* 0x1b60 */  48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,
/* 0x1b70 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,108,116,101,114,
/* 0x1b80 */  95, 99,116,111, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,
/* 0x1b90 */  32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48,
/* 0x1ba0 */  48, 48, 48, 48, 32,102,105,108,116,101,114, 95,105,100, 10, 48,
/* 0x1bb0 */  48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32,
/* 0x1bc0 */  78, 82, 86, 50, 66,  9, 48, 48, 48, 48, 48, 48, 99, 52, 32,117,
/* 0x1bd0 */  99,108, 95,110,114,118, 50, 98, 95,100,101, 99,111,109,112,114,
/* 0x1be0 */ 101,115,115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103,
/* 0x1bf0 */  32, 32, 32, 32, 32, 70, 32, 78, 82, 86, 50, 68,  9, 48, 48, 48,
/* 0x1c00 */  48, 48, 49, 48, 48, 32,117, 99,108, 95,110,114,118, 50,100, 95,
/* 0x1c10 */ 100,101, 99,111,109,112,114,101,115,115, 95, 56, 10, 48, 48, 48,
/* 0x1c20 */  48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32, 78, 82,
/* 0x1c30 */  86, 50, 69,  9, 48, 48, 48, 48, 48, 49, 49, 52, 32,117, 99,108,
/* 0x1c40 */  95,110,114,118, 50,101, 95,100,101, 99,111,109,112,114,101,115,
/* 0x1c50 */ 115, 95, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32,
/* 0x1c60 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  9,
/* 0x1c70 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 76,122,109, 97, 68,101, 99,
/* 0x1c80 */ 111,100,101, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x1c90 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 73, 78,
/* 0x1ca0 */  85, 88, 48, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x1cb0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1cc0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49,
/* 0x1cd0 */  52, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32, 32,
/* 0x1ce0 */  32, 32, 32, 32, 77, 69, 84, 72, 79, 68, 10, 48, 48, 48, 48, 48,
/* 0x1cf0 */  48, 51, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x1d00 */  32, 32, 32, 32, 32, 32, 76, 73, 78, 85, 88, 48, 51, 48, 10, 48,
/* 0x1d10 */  48, 48, 48, 48, 48, 51, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x1d20 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 73, 78, 85, 88, 48,
/* 0x1d30 */  48, 48, 10, 48, 48, 48, 48, 48, 48, 51, 56, 32, 82, 95, 65, 82,
/* 0x1d40 */  77, 95, 65, 66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32, 67, 79,
/* 0x1d50 */  77, 80, 82, 69, 83, 83, 69, 68, 95, 76, 69, 78, 71, 84, 72, 10,
/* 0x1d60 */  48, 48, 48, 48, 48, 48, 51, 99, 32, 82, 95, 65, 82, 77, 95, 65,
/* 0x1d70 */  66, 83, 51, 50, 32, 32, 32, 32, 32, 32, 32, 85, 78, 67, 79, 77,
/* 0x1d80 */  80, 82, 69, 83, 83, 69, 68, 95, 76, 69, 78, 71, 84, 72, 10, 48,
/* 0x1d90 */  48, 48, 48, 48, 48, 52, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x1da0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 73, 78, 85, 88, 48,
/* 0x1db0 */  48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x1dc0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 73, 78, 85,
/* 0x1dd0 */  88, 48, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x1de0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1df0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56,
/* 0x1e00 */  32, 82, 95, 65, 82, 77, 95, 65, 66, 83, 51, 50, 32, 32, 32, 32,
/* 0x1e10 */  32, 32, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 48, 48,
/* 0x1e20 */  48, 48, 48, 48, 48, 99, 32, 82, 95, 65, 82, 77, 95, 65, 66, 83,
/* 0x1e30 */  51, 50, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95,
/* 0x1e40 */ 105,100, 10, 48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 65, 82,
/* 0x1e50 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,
/* 0x1e60 */ 111,107, 51, 50, 46, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x1e70 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x1e80 */  91, 99,116,111,107, 51, 50, 46, 49, 48, 93, 58, 10, 79, 70, 70,
/* 0x1e90 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x1ea0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x1eb0 */  48, 48, 48, 48, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x1ec0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46,
/* 0x1ed0 */  49, 48, 10, 48, 48, 48, 48, 48, 48, 51, 99, 32, 82, 95, 65, 82,
/* 0x1ee0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,
/* 0x1ef0 */ 111,107, 51, 50, 46, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x1f00 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x1f10 */  91, 78, 82, 86, 50, 66, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x1f20 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1f30 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x1f40 */  49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x1f50 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48,
/* 0x1f60 */  48, 52, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x1f70 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48,
/* 0x1f80 */  48, 48, 53, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x1f90 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48,
/* 0x1fa0 */  48, 48, 48, 53, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x1fb0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48, 48,
/* 0x1fc0 */  48, 48, 48, 48, 54, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x1fd0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10, 48,
/* 0x1fe0 */  48, 48, 48, 48, 48, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x1ff0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66, 10,
/* 0x2000 */  48, 48, 48, 48, 48, 48, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2010 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 66,
/* 0x2020 */  10, 48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x2030 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x2040 */  66, 10, 48, 48, 48, 48, 48, 48, 56, 56, 32, 82, 95, 65, 82, 77,
/* 0x2050 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x2060 */  50, 66, 10, 48, 48, 48, 48, 48, 48, 56, 99, 32, 82, 95, 65, 82,
/* 0x2070 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x2080 */  86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 57, 52, 32, 82, 95, 65,
/* 0x2090 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x20a0 */  82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 57, 99, 32, 82, 95,
/* 0x20b0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x20c0 */  78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 97, 48, 32, 82,
/* 0x20d0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x20e0 */  32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 98, 99, 32,
/* 0x20f0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2100 */  32, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48, 99, 48,
/* 0x2110 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2120 */  32, 32, 32, 78, 82, 86, 50, 66, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x2130 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x2140 */  32, 91, 78, 82, 86, 50, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x2150 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2160 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x2170 */  48, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2180 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48,
/* 0x2190 */  48, 48, 52, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x21a0 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48,
/* 0x21b0 */  48, 48, 48, 52, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x21c0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48,
/* 0x21d0 */  48, 48, 48, 48, 53, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x21e0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48,
/* 0x21f0 */  48, 48, 48, 48, 48, 53, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2200 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10,
/* 0x2210 */  48, 48, 48, 48, 48, 48, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2220 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68,
/* 0x2230 */  10, 48, 48, 48, 48, 48, 48, 55, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x2240 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x2250 */  68, 10, 48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65, 82, 77,
/* 0x2260 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x2270 */  50, 68, 10, 48, 48, 48, 48, 48, 48, 56, 52, 32, 82, 95, 65, 82,
/* 0x2280 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x2290 */  86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 57, 52, 32, 82, 95, 65,
/* 0x22a0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x22b0 */  82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 57, 99, 32, 82, 95,
/* 0x22c0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x22d0 */  78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 97, 52, 32, 82,
/* 0x22e0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x22f0 */  32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 98, 48, 32,
/* 0x2300 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2310 */  32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 98, 56,
/* 0x2320 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2330 */  32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 99,
/* 0x2340 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2350 */  32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x2360 */ 100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2370 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48,
/* 0x2380 */  48,100, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2390 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48,
/* 0x23a0 */  48, 48,102, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x23b0 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48,
/* 0x23c0 */  48, 48, 48,102, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x23d0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 68, 10, 10, 82,
/* 0x23e0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x23f0 */  83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 69, 93, 58, 10, 79,
/* 0x2400 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x2410 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x2420 */  48, 48, 48, 48, 48, 48, 49, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2430 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69,
/* 0x2440 */  10, 48, 48, 48, 48, 48, 48, 52, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x2450 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x2460 */  69, 10, 48, 48, 48, 48, 48, 48, 52, 56, 32, 82, 95, 65, 82, 77,
/* 0x2470 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x2480 */  50, 69, 10, 48, 48, 48, 48, 48, 48, 53, 48, 32, 82, 95, 65, 82,
/* 0x2490 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x24a0 */  86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 53, 99, 32, 82, 95, 65,
/* 0x24b0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x24c0 */  82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 54, 56, 32, 82, 95,
/* 0x24d0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x24e0 */  78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 55, 52, 32, 82,
/* 0x24f0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2500 */  32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 55, 56, 32,
/* 0x2510 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2520 */  32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 56, 52,
/* 0x2530 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x2540 */  32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48, 57,
/* 0x2550 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2560 */  32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x2570 */  57, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x2580 */  32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48,
/* 0x2590 */  48, 97, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x25a0 */  32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48, 48,
/* 0x25b0 */  48, 48, 97, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x25c0 */  32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48, 48,
/* 0x25d0 */  48, 48, 48, 97, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x25e0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48, 48,
/* 0x25f0 */  48, 48, 48, 48, 98, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2600 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10, 48,
/* 0x2610 */  48, 48, 48, 48, 48, 98, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2620 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69, 10,
/* 0x2630 */  48, 48, 48, 48, 48, 48, 99, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x2640 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50, 69,
/* 0x2650 */  10, 48, 48, 48, 48, 48, 48,100, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x2660 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 50,
/* 0x2670 */  69, 10, 48, 48, 48, 48, 48, 48,100, 52, 32, 82, 95, 65, 82, 77,
/* 0x2680 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86,
/* 0x2690 */  50, 69, 10, 48, 48, 48, 48, 48, 48,100, 99, 32, 82, 95, 65, 82,
/* 0x26a0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78, 82,
/* 0x26b0 */  86, 50, 69, 10, 48, 48, 48, 48, 48, 48,101, 52, 32, 82, 95, 65,
/* 0x26c0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x26d0 */  82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 49, 48, 99, 32, 82, 95,
/* 0x26e0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x26f0 */  78, 82, 86, 50, 69, 10, 48, 48, 48, 48, 48, 49, 49, 48, 32, 82,
/* 0x2700 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x2710 */  32, 78, 82, 86, 50, 69, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x2720 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x2730 */  76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 93, 58, 10, 79, 70, 70,
/* 0x2740 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x2750 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x2760 */  48, 48, 48, 48, 48, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x2770 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2780 */  67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 52, 99, 32, 82, 95, 65,
/* 0x2790 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x27a0 */  90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x27b0 */  56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x27c0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10,
/* 0x27d0 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x27e0 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 69,
/* 0x27f0 */  67, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x2800 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2810 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 55, 52, 32,
/* 0x2820 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2830 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x2840 */  48, 48, 48, 57, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2850 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2860 */  50, 48, 10, 48, 48, 48, 48, 48, 48, 98, 56, 32, 82, 95, 65, 82,
/* 0x2870 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x2880 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 99,
/* 0x2890 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x28a0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x28b0 */  48, 48, 48, 48, 48,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x28c0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x28d0 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49, 48, 48, 32, 82, 95,
/* 0x28e0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x28f0 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x2900 */  49, 48, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2910 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x2920 */  10, 48, 48, 48, 48, 48, 49, 52, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x2930 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x2940 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 49, 57, 48, 32,
/* 0x2950 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2960 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x2970 */  48, 48, 49, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2980 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2990 */  50, 48, 10, 48, 48, 48, 48, 48, 49,100, 56, 32, 82, 95, 65, 82,
/* 0x29a0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x29b0 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 48,
/* 0x29c0 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x29d0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x29e0 */  48, 48, 48, 48, 50, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x29f0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x2a00 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 50, 48, 32, 82, 95,
/* 0x2a10 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2a20 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x2a30 */  50, 51, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2a40 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x2a50 */  10, 48, 48, 48, 48, 48, 50, 51, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x2a60 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x2a70 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 52, 48, 32,
/* 0x2a80 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2a90 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x2aa0 */  48, 48, 50, 52, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2ab0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2ac0 */  50, 48, 10, 48, 48, 48, 48, 48, 50, 53, 56, 32, 82, 95, 65, 82,
/* 0x2ad0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x2ae0 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50, 97,
/* 0x2af0 */  52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2b00 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x2b10 */  48, 48, 48, 48, 50, 99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2b20 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x2b30 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 50,101, 56, 32, 82, 95,
/* 0x2b40 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2b50 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x2b60 */  51, 48, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2b70 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x2b80 */  10, 48, 48, 48, 48, 48, 51, 48, 99, 32, 82, 95, 65, 82, 77, 95,
/* 0x2b90 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x2ba0 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 51, 99, 32,
/* 0x2bb0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2bc0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x2bd0 */  48, 48, 51, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2be0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2bf0 */  50, 48, 10, 48, 48, 48, 48, 48, 51, 97, 48, 32, 82, 95, 65, 82,
/* 0x2c00 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x2c10 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51, 97,
/* 0x2c20 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2c30 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x2c40 */  48, 48, 48, 48, 51, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2c50 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x2c60 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 51,101, 48, 32, 82, 95,
/* 0x2c70 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2c80 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x2c90 */  51,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2ca0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x2cb0 */  10, 48, 48, 48, 48, 48, 52, 50, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x2cc0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x2cd0 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 51, 56, 32,
/* 0x2ce0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2cf0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x2d00 */  48, 48, 52, 54, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2d10 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2d20 */  50, 48, 10, 48, 48, 48, 48, 48, 52, 56, 52, 32, 82, 95, 65, 82,
/* 0x2d30 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x2d40 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52, 56,
/* 0x2d50 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2d60 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x2d70 */  48, 48, 48, 48, 52, 98, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2d80 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x2d90 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 52,100, 52, 32, 82, 95,
/* 0x2da0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2db0 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x2dc0 */  52,101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2dd0 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x2de0 */  10, 48, 48, 48, 48, 48, 52,102, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x2df0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x2e00 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 49, 56, 32,
/* 0x2e10 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2e20 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x2e30 */  48, 48, 53, 51, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2e40 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2e50 */  50, 48, 10, 48, 48, 48, 48, 48, 53, 57, 56, 32, 82, 95, 65, 82,
/* 0x2e60 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x2e70 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53, 97,
/* 0x2e80 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2e90 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x2ea0 */  48, 48, 48, 48, 53, 99, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2eb0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x2ec0 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 53,101, 52, 32, 82, 95,
/* 0x2ed0 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2ee0 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x2ef0 */  53,102, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x2f00 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x2f10 */  10, 48, 48, 48, 48, 48, 54, 48, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x2f20 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x2f30 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54, 50, 52, 32,
/* 0x2f40 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x2f50 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x2f60 */  48, 48, 54, 52, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x2f70 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x2f80 */  50, 48, 10, 48, 48, 48, 48, 48, 54, 56, 48, 32, 82, 95, 65, 82,
/* 0x2f90 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x2fa0 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54, 56,
/* 0x2fb0 */  99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x2fc0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x2fd0 */  48, 48, 48, 48, 54,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x2fe0 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x2ff0 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 54,101, 99, 32, 82, 95,
/* 0x3000 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3010 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x3020 */  55, 49, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3030 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x3040 */  10, 48, 48, 48, 48, 48, 55, 50, 56, 32, 82, 95, 65, 82, 77, 95,
/* 0x3050 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x3060 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 54, 99, 32,
/* 0x3070 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x3080 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x3090 */  48, 48, 55, 55, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x30a0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x30b0 */  50, 48, 10, 48, 48, 48, 48, 48, 55, 57, 99, 32, 82, 95, 65, 82,
/* 0x30c0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x30d0 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55, 98,
/* 0x30e0 */  56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x30f0 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x3100 */  48, 48, 48, 48, 55, 99, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3110 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3120 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 55,100, 48, 32, 82, 95,
/* 0x3130 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3140 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x3150 */  55,102, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3160 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x3170 */  10, 48, 48, 48, 48, 48, 56, 50, 48, 32, 82, 95, 65, 82, 77, 95,
/* 0x3180 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x3190 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56, 50, 99, 32,
/* 0x31a0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x31b0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x31c0 */  48, 48, 56, 55, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52,
/* 0x31d0 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67,
/* 0x31e0 */  50, 48, 10, 48, 48, 48, 48, 48, 56, 56, 56, 32, 82, 95, 65, 82,
/* 0x31f0 */  77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90,
/* 0x3200 */  77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56, 97,
/* 0x3210 */  48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32,
/* 0x3220 */  32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48,
/* 0x3230 */  48, 48, 48, 48, 56,101, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67,
/* 0x3240 */  50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68,
/* 0x3250 */  69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 56,102, 52, 32, 82, 95,
/* 0x3260 */  65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3270 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48,
/* 0x3280 */  56,102, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32,
/* 0x3290 */  32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x32a0 */  10, 48, 48, 48, 48, 48, 57, 48, 52, 32, 82, 95, 65, 82, 77, 95,
/* 0x32b0 */  80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65,
/* 0x32c0 */  95, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 57, 50, 56, 32,
/* 0x32d0 */  82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32,
/* 0x32e0 */  32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 10, 82, 69,
/* 0x32f0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x3300 */  32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x3310 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x3320 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x3330 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 55, 56, 32, 82, 95, 65,
/* 0x3340 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x3350 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x3360 */  56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3370 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x3380 */  48, 48, 48, 48, 48, 48, 56, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3390 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x33a0 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 97, 56, 32, 82,
/* 0x33b0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x33c0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x33d0 */  48, 48, 97, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x33e0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x33f0 */  48, 10, 48, 48, 48, 48, 48, 48,101, 52, 32, 82, 95, 65, 82, 77,
/* 0x3400 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x3410 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 48, 48,
/* 0x3420 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3430 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x3440 */  48, 48, 48, 49, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3450 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x3460 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 49, 52, 32, 82, 95, 65,
/* 0x3470 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x3480 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49,
/* 0x3490 */  49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x34a0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x34b0 */  48, 48, 48, 48, 48, 49, 50, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x34c0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x34d0 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 50, 56, 32, 82,
/* 0x34e0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x34f0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x3500 */  48, 49, 52, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3510 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x3520 */  48, 10, 48, 48, 48, 48, 48, 49, 52, 99, 32, 82, 95, 65, 82, 77,
/* 0x3530 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x3540 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 53, 48,
/* 0x3550 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3560 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x3570 */  48, 48, 48, 49, 56, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3580 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x3590 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 56, 56, 32, 82, 95, 65,
/* 0x35a0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x35b0 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49,
/* 0x35c0 */  56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x35d0 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x35e0 */  48, 48, 48, 48, 48, 49, 57, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x35f0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x3600 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49, 97, 48, 32, 82,
/* 0x3610 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3620 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x3630 */  48, 49, 99, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3640 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x3650 */  48, 10, 48, 48, 48, 48, 48, 49, 99, 99, 32, 82, 95, 65, 82, 77,
/* 0x3660 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x3670 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49,100, 52,
/* 0x3680 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3690 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x36a0 */  48, 48, 48, 49,100, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x36b0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x36c0 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 49,101, 52, 32, 82, 95, 65,
/* 0x36d0 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x36e0 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 49,
/* 0x36f0 */ 101, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3700 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x3710 */  48, 48, 48, 48, 48, 50, 50, 56, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3720 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x3730 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 50, 99, 32, 82,
/* 0x3740 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3750 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x3760 */  48, 50, 52, 52, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3770 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x3780 */  48, 10, 48, 48, 48, 48, 48, 50, 52, 99, 32, 82, 95, 65, 82, 77,
/* 0x3790 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x37a0 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 53, 48,
/* 0x37b0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x37c0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x37d0 */  48, 48, 48, 50, 54, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x37e0 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x37f0 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 56, 52, 32, 82, 95, 65,
/* 0x3800 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x3810 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50,
/* 0x3820 */  56, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3830 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x3840 */  48, 48, 48, 48, 48, 50, 97, 52, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3850 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x3860 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50, 99, 56, 32, 82,
/* 0x3870 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3880 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x3890 */  48, 50,100, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x38a0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x38b0 */  48, 10, 48, 48, 48, 48, 48, 50,100, 99, 32, 82, 95, 65, 82, 77,
/* 0x38c0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x38d0 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 50,102, 52,
/* 0x38e0 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x38f0 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x3900 */  48, 48, 48, 51, 48, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3910 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x3920 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 49, 52, 32, 82, 95, 65,
/* 0x3930 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x3940 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51,
/* 0x3950 */  50, 99, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3960 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x3970 */  48, 48, 48, 48, 48, 51, 53, 48, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3980 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x3990 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 53, 56, 32, 82,
/* 0x39a0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x39b0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x39c0 */  48, 51, 55, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x39d0 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x39e0 */  48, 10, 48, 48, 48, 48, 48, 51, 55, 56, 32, 82, 95, 65, 82, 77,
/* 0x39f0 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x3a00 */  65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 57, 99,
/* 0x3a10 */  32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32,
/* 0x3a20 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48,
/* 0x3a30 */  48, 48, 48, 51, 98, 48, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50,
/* 0x3a40 */  52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x3a50 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 51, 98, 56, 32, 82, 95, 65,
/* 0x3a60 */  82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76,
/* 0x3a70 */  90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 51,
/* 0x3a80 */  99, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32,
/* 0x3a90 */  32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10,
/* 0x3aa0 */  48, 48, 48, 48, 48, 51, 99, 99, 32, 82, 95, 65, 82, 77, 95, 80,
/* 0x3ab0 */  67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95,
/* 0x3ac0 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 52, 48, 48, 32, 82,
/* 0x3ad0 */  95, 65, 82, 77, 95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32,
/* 0x3ae0 */  32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x3af0 */  48, 52, 49, 56, 32, 82, 95, 65, 82, 77, 95, 80, 67, 50, 52, 32,
/* 0x3b00 */  32, 32, 32, 32, 32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49,
/* 0x3b10 */  48, 10, 48, 48, 48, 48, 48, 52, 52, 48, 32, 82, 95, 65, 82, 77,
/* 0x3b20 */  95, 80, 67, 50, 52, 32, 32, 32, 32, 32, 32, 32, 32, 76, 90, 77,
/* 0x3b30 */  65, 95, 68, 69, 67, 49, 48, 10
};
