/* powerpc-darwin.dylib-entry.h
   created from powerpc-darwin.dylib-entry.bin, 8985 (0x2319) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2009 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2009 Laszlo Molnar
   Copyright (C) 2000-2009 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ml1050@users.sourceforge.net>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_POWERPC_DARWIN_DYLIB_ENTRY_SIZE    8985
#define STUB_POWERPC_DARWIN_DYLIB_ENTRY_ADLER32 0x992659f2
#define STUB_POWERPC_DARWIN_DYLIB_ENTRY_CRC32   0x3ceb5d64

unsigned char stub_powerpc_darwin_dylib_entry[8985] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  2,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   0,  1,  0, 20,  0,  0,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0, 26,112,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,
/* 0x0030 */   0, 22,  0, 19,124, 72,  2,166, 72,  0,  2,  1,124,  0, 41,236,
/* 0x0040 */ 125,168,  2,166, 40,  7,  0,  8, 64,130,  1, 60,144,166,  0,  0,
/* 0x0050 */ 124,132, 26, 20, 60,  0,128,  0, 61, 32,128,  0, 56, 99,255,255,
/* 0x0060 */  56,165,255,255, 57, 64,255,255, 72,  0,  1, 12, 57, 32,  0,  1,
/* 0x0070 */ 125, 41, 28, 44, 56, 99,  0,  4,124,  9,  0, 64,125, 41, 72, 20,
/* 0x0080 */  97, 41,  0,  1, 78,128,  0, 32,141,  3,  0,  1,157,  5,  0,  1,
/* 0x0090 */ 124,  9,  0, 64,125, 41, 74, 20, 65,162,255,213, 65,129,255,236,
/* 0x00a0 */  56,224,  0,  1, 72,  0,  0, 20, 56,231,255,255,125, 41, 72, 21,
/* 0x00b0 */  65,162,255,189,124,231, 57, 20,125, 41, 72, 21, 65,162,255,177,
/* 0x00c0 */ 124,231, 57, 20,124,  9,  0, 64,125, 41, 74, 20, 65,162,255,161,
/* 0x00d0 */  65,160,255,216, 57,  0,  0,  0, 52,231,255,253, 84,231, 64, 46,
/* 0x00e0 */  65,128,  0, 32,140, 67,  0,  1,124,234, 16,249,125, 74, 14,112,
/* 0x00f0 */  65,130,  0,  0,112, 66,  0,  1, 65,162,  0, 80, 72,  0,  0, 20,
/* 0x0100 */ 124,  9,  0, 64,125, 41, 74, 20, 65,162,255,101, 65,161,  0, 60,
/* 0x0110 */  57,  0,  0,  1,124,  9,  0, 64,125, 41, 74, 20, 65,162,255, 81,
/* 0x0120 */  65,161,  0, 40,125, 41, 72, 21, 65,162,255, 69,125,  8, 65, 20,
/* 0x0130 */ 124,  9,  0, 64,125, 41, 74, 20, 65,162,255, 53, 65,160,255,232,
/* 0x0140 */  57,  8,  0,  2, 72,  0,  0, 16,125, 41, 72, 21, 65,162,255, 33,
/* 0x0150 */ 125,  8, 65, 20, 32,234,250,255, 57,  8,  0,  2,125,  8,  1,148,
/* 0x0160 */ 124,234, 42, 20,125,  9,  3,166,141,  7,  0,  1,157,  5,  0,  1,
/* 0x0170 */  66,  0,255,248, 56,224,  1,  0,124,  7, 41,236,124,  7, 26, 44,
/* 0x0180 */  75,255,255, 16,124,  0, 41,236,125,168,  2,166, 40,  7,  0,  5,
/* 0x0190 */  64,130,  1, 32,144,166,  0,  0,124,132, 26, 20, 60,  0,128,  0,
/* 0x01a0 */  61, 32,128,  0, 56, 99,255,255, 56,165,255,255, 57, 64,255,255,
/* 0x01b0 */  72,  0,  0,240, 57, 32,  0,  1,125, 41, 28, 44, 56, 99,  0,  4,
/* 0x01c0 */ 124,  9,  0, 64,125, 41, 72, 20, 97, 41,  0,  1, 78,128,  0, 32,
/* 0x01d0 */ 141,  3,  0,  1,157,  5,  0,  1,124,  9,  0, 64,125, 41, 74, 20,
/* 0x01e0 */  65,162,255,213, 65,129,255,236, 56,224,  0,  1, 72,  0,  0, 20,
/* 0x01f0 */  56,231,255,255,125, 41, 72, 21, 65,162,255,189,124,231, 57, 21,
/* 0x0200 */ 125, 41, 72, 21, 65,162,255,177,124,231, 57, 21,124,  9,  0, 64,
/* 0x0210 */ 125, 41, 74, 20, 65,162,255,161, 65,160,255,216, 57,  0,  0,  0,
/* 0x0220 */  52,231,255,253, 84,231, 64, 46, 65,128,  0, 24,140, 67,  0,  1,
/* 0x0230 */ 124,234, 16,249,125, 74, 14,112, 65,130,  0,  0, 72,  0,  0, 12,
/* 0x0240 */ 125, 41, 72, 21, 65,162,255,113,125,  8, 65, 21,125, 41, 72, 21,
/* 0x0250 */  65,162,255,101,125,  8, 65, 21, 64,130,  0, 40, 57,  0,  0,  1,
/* 0x0260 */ 125, 41, 72, 21, 65,162,255, 81,125,  8, 65, 21,124,  9,  0, 64,
/* 0x0270 */ 125, 41, 74, 20, 65,162,255, 65, 65,160,255,232, 57,  8,  0,  2,
/* 0x0280 */  32,234,250,255, 57,  8,  0,  1,125,  8,  1,148,124,234, 42, 20,
/* 0x0290 */ 125,  9,  3,166,141,  7,  0,  1,157,  5,  0,  1, 66,  0,255,248,
/* 0x02a0 */  56,224,  1,  0,124,  7, 41,236,124,  7, 26, 44, 75,255,255, 44,
/* 0x02b0 */ 124,  0, 41,236,125,168,  2,166, 40,  7,  0,  2, 64,130,  0,228,
/* 0x02c0 */ 144,166,  0,  0,124,132, 26, 20, 60,  0,128,  0, 61, 32,128,  0,
/* 0x02d0 */  56, 99,255,255, 56,165,255,255, 57, 64,255,255, 72,  0,  0,180,
/* 0x02e0 */ 124,  9,  0, 64,125, 41, 72, 20, 76,162,  0, 32, 57, 32,  0,  1,
/* 0x02f0 */ 125, 41, 28, 44, 56, 99,  0,  4,124,  9,  0, 64,125, 41, 73, 20,
/* 0x0300 */  78,128,  0, 32,141,  3,  0,  1,157,  5,  0,  1, 75,255,255,213,
/* 0x0310 */  65,129,255,244, 56,224,  0,  1, 75,255,255,201,124,231, 57, 21,
/* 0x0320 */  75,255,255,193, 65,160,255,244, 52,231,255,253, 57,  0,  0,  0,
/* 0x0330 */  65,128,  0, 20,140, 67,  0,  1, 84,231, 64, 46,124,234, 16,249,
/* 0x0340 */  65,130,  0,  0, 75,255,255,157,125,  8, 65, 21, 75,255,255,149,
/* 0x0350 */ 125,  8, 65, 21, 56,224,  0,  1, 64,130,  0, 28, 56,224,  0,  3,
/* 0x0360 */  57,  0,  0,  1, 75,255,255,125,125,  8, 65, 21, 75,255,255,117,
/* 0x0370 */  65,160,255,244, 32, 74,242,255,125,  8, 57, 20,124,234, 42, 20,
/* 0x0380 */ 125,  9,  3,166,141,  7,  0,  1,157,  5,  0,  1, 66,  0,255,248,
/* 0x0390 */  56,224,  1,  0,124,  7, 41,236,124,  7, 26, 44, 75,255,255,112,
/* 0x03a0 */  40,  7,  0, 14, 64,130,  0, 32,124,  8,  2,166,124,201, 51,120,
/* 0x03b0 */ 129,  6,  0,  0,124,167, 43,120, 56,164,255,254, 56,131,  0,  2,
/* 0x03c0 */ 144,  1,  0,  8,136,  3,  0,  0, 84, 11,232,254, 84,  2,  7,126,
/* 0x03d0 */  56, 96,250,  0,124, 99, 88, 48, 56, 99,241,124,124, 38, 11,120,
/* 0x03e0 */ 124, 33, 26, 20, 84, 33,  0, 52, 56,  0,  0,  0,124,195, 51,120,
/* 0x03f0 */ 144,  9,  0,  0,148,  3,255,252,124,  1, 24, 64, 65,128,255,248,
/* 0x0400 */ 144,193,  0,  0,136,  4,255,255,144,225,  0,  8, 56,193,  0, 16,
/* 0x0410 */ 145, 33,  0, 12, 56, 97,  0, 20, 84, 11,225, 62, 84,  0,  7, 62,
/* 0x0420 */ 152, 67,  0,  2,153, 99,  0,  1,152,  3,  0,  0,124,  8,  2,166,
/* 0x0430 */ 148, 33,255,160,189,193,  0, 24,144,  1,  0,100, 59, 32,  0,  0,
/* 0x0440 */ 137, 67,  0,  2,137, 99,  0,  1,138, 67,  0,  0,147, 38,  0,  0,
/* 0x0450 */ 147, 41,  0,  0,136,  3,  0,  1,125, 40,  3,166,124, 18,  2, 20,
/* 0x0460 */  57, 32,  3,  0,125, 41,  0, 48, 56,  9,  7, 54,127,153,  0, 64,
/* 0x0470 */  57, 32,  0,  1,125, 43, 88, 48,125, 41, 80, 48, 57, 41,255,255,
/* 0x0480 */  57,107,255,255,145, 33,  0,  8,124,206, 51,120,124,147, 35,120,
/* 0x0490 */ 124,245, 59,120,125, 20, 67,120,145, 97,  0, 12, 59,  3,  0,  4,
/* 0x04a0 */  59,224,  0,  0, 58,224,  0,  0, 59, 64,  0,  1, 58, 32,  0,  1,
/* 0x04b0 */  58,  0,  0,  1, 57,224,  0,  1, 57, 32,  0,  0, 64,156,  0, 28,
/* 0x04c0 */ 124,  9,  3,166, 57, 96,  4,  0, 85, 32,  8, 60,125,120,  3, 46,
/* 0x04d0 */  57, 41,  0,  1, 66,  0,255,244,127,179, 42, 20,126,108,155,120,
/* 0x04e0 */  56,160,  0,  0, 57,  0,255,255, 57, 96,  0,  0,127,140,232,  0,
/* 0x04f0 */  57,107,  0,  1, 47, 11,  0,  4, 84,169, 64, 46, 65,158,  8,156,
/* 0x0500 */ 136, 12,  0,  0, 57,140,  0,  1,125, 37,  3,120, 64,153,255,224,
/* 0x0510 */ 127,153,160, 64, 64,156,  8,100, 62,192,  0,255, 98,214,255,255,
/* 0x0520 */ 128,  1,  0,  8,127,136,176, 64,127, 35,  0, 56, 86,224, 32, 54,
/* 0x0530 */ 124,  0, 26, 20, 84,  6,  8, 60, 65,157,  0, 32,127,140,232,  0,
/* 0x0540 */  65,158,  8, 88,137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120,
/* 0x0550 */  85,  8, 64, 46, 57,140,  0,  1,124,230,194, 46, 85,  0,170,254,
/* 0x0560 */ 125, 64, 57,214,127,133, 80, 64, 64,156,  1,172,128,  1,  0, 12,
/* 0x0570 */  47,151,  0,  6,127, 41,  0, 56, 32, 18,  0,  8,127,224,  6, 48,
/* 0x0580 */ 125, 41,144, 48,125, 41,  2, 20, 29, 41,  6,  0, 32,  7,  8,  0,
/* 0x0590 */ 124,  0, 46,112,124,  7,  2, 20,125, 56, 74, 20,124,  6,195, 46,
/* 0x05a0 */ 125, 72, 83,120, 56,201, 14,108, 56, 96,  0,  1, 64,157,  0,180,
/* 0x05b0 */ 124, 26,200, 80, 63, 96,  0,255,127,245,  0,174, 99,123,255,255,
/* 0x05c0 */  87,255,  8, 60, 87,252,  5,238,127,136,216, 64, 87,128,  8, 60,
/* 0x05d0 */  84,100,  8, 60,124,  6,  2, 20,127, 12,232,  0, 84,169, 64, 46,
/* 0x05e0 */ 124,224, 34, 20, 65,157,  0, 24, 65,154,  7,176,136, 12,  0,  0,
/* 0x05f0 */  85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,161,103,  2,  0,
/* 0x0600 */  85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,
/* 0x0610 */ 124,  0, 46,112, 85,105,217,126,124, 11,  2, 20, 47, 28,  0,  0,
/* 0x0620 */ 125,105, 88, 80,124,131, 35,120,125, 10, 64, 80, 64,156,  0, 20,
/* 0x0630 */ 176,  7,  2,  0,125, 72, 83,120, 65,186,  0, 24, 72,  0,  0, 28,
/* 0x0640 */ 177,103,  2,  0,124,170, 40, 80, 56,100,  0,  1, 65,154,  0, 12,
/* 0x0650 */  47,131,  0,255, 64,157,255,108, 47,131,  0,255, 65,157,  0,132,
/* 0x0660 */  63,224,  0,255, 99,255,255,255,127,136,248, 64, 84,103,  8, 60,
/* 0x0670 */ 127, 12,232,  0, 84,169, 64, 46,124,227, 59,120, 65,157,  0, 24,
/* 0x0680 */  65,154,  7, 24,136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x0690 */ 125, 37,  3,120,125,102, 58, 46, 85,  0,170,254,125, 64, 89,214,
/* 0x06a0 */  32, 11,  8,  0,127,133, 80, 64,124,  0, 46,112, 85,105,217,126,
/* 0x06b0 */ 124, 11,  2, 20,125, 10, 64, 80,125,105, 88, 80, 64,156,  0, 16,
/* 0x06c0 */ 125, 72, 83,120,124,  6, 59, 46, 72,  0,  0, 16,124,170, 40, 80,
/* 0x06d0 */ 125,102, 59, 46, 56,103,  0,  1, 47,131,  0,255, 64,157,255,140,
/* 0x06e0 */  47,151,  0,  3, 84,127,  6, 62,127,249,169,174, 59, 57,  0,  1,
/* 0x06f0 */  65,157,  0, 12, 58,224,  0,  0, 72,  0,  6,120, 47,151,  0,  9,
/* 0x0700 */  65,157,  0, 12, 58,247,255,253, 72,  0,  6,104, 58,247,255,250,
/* 0x0710 */  72,  0,  6, 96,125, 10, 64, 80,127,136,176, 64, 84,224,217,126,
/* 0x0720 */ 124,  0, 56, 80, 86,233,  8, 60,124,  6,195, 46,124,170, 40, 80,
/* 0x0730 */ 124,248, 74, 20, 65,157,  0, 32,127,140,232,  0, 65,158,  6, 92,
/* 0x0740 */ 137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46,
/* 0x0750 */  57,140,  0,  1,161,103,  1,128, 85,  0,170,254,125, 64, 89,214,
/* 0x0760 */ 127,133, 80, 64, 64,156,  0, 64, 32, 11,  8,  0, 47,151,  0,  6,
/* 0x0770 */ 124,  0, 46,112,124, 11,  2, 20,176,  7,  1,128,126, 15,131,120,
/* 0x0780 */ 125, 72, 83,120,126, 48,139,120, 56,  0,  0,  0,127, 81,211,120,
/* 0x0790 */  64,157,  0,  8, 56,  0,  0,  3,124, 23,  3,120, 56,216,  6,100,
/* 0x07a0 */  72,  0,  2, 24,125, 10, 64, 80,127,136,176, 64, 85, 96,217,126,
/* 0x07b0 */ 124,  0, 88, 80,124,170, 40, 80,176,  7,  1,128, 65,157,  0, 32,
/* 0x07c0 */ 127,140,232,  0, 65,158,  5,212,137, 44,  0,  0, 84,160, 64, 46,
/* 0x07d0 */ 124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,161,103,  1,152,
/* 0x07e0 */  85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0,188,
/* 0x07f0 */  32, 11,  8,  0,127,138,176, 64,124,  0, 46,112, 86,233, 40, 52,
/* 0x0800 */ 124, 11,  2, 20,125, 56, 74, 20, 84,107,  8, 60,176,  7,  1,152,
/* 0x0810 */ 125, 72, 83,120,124,233, 90, 20, 65,157,  0, 32,127,140,232,  0,
/* 0x0820 */  65,158,  5,120,137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120,
/* 0x0830 */  85, 72, 64, 46, 57,140,  0,  1,161,103,  1,224, 85,  0,170,254,
/* 0x0840 */ 125, 64, 89,214,127,133, 80, 64, 64,156,  0, 72, 32, 11,  8,  0,
/* 0x0850 */  47,153,  0,  0,124,  0, 46,112,124, 11,  2, 20,176,  7,  1,224,
/* 0x0860 */ 125, 72, 83,120, 65,158,  5, 52, 47,151,  0,  6, 57, 32,  0,  9,
/* 0x0870 */  64,157,  0,  8, 57, 32,  0, 11,124, 26,200, 80,127,245,  0,174,
/* 0x0880 */ 125, 55, 75,120,127,249,169,174, 59, 57,  0,  1, 72,  0,  4,228,
/* 0x0890 */  85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,125, 10, 64, 80,
/* 0x08a0 */ 176,  7,  1,224, 72,  0,  0,252,125, 10, 64, 80,127,136,176, 64,
/* 0x08b0 */  85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,176,  7,  1,152,
/* 0x08c0 */  65,157,  0, 32,127,140,232,  0, 65,158,  4,208,137, 44,  0,  0,
/* 0x08d0 */  84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x08e0 */ 161,103,  1,176, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,
/* 0x08f0 */  64,156,  0, 32, 32, 11,  8,  0,124,  0, 46,112,124, 11,  2, 20,
/* 0x0900 */ 125, 72, 83,120,126, 41,139,120,176,  7,  1,176, 72,  0,  0,140,
/* 0x0910 */ 125, 10, 64, 80,127,136,176, 64, 85, 96,217,126,124,  0, 88, 80,
/* 0x0920 */ 124,170, 40, 80,176,  7,  1,176, 65,157,  0, 32,127,140,232,  0,
/* 0x0930 */  65,158,  4,104,137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120,
/* 0x0940 */  85,  8, 64, 46, 57,140,  0,  1,161,103,  1,200, 85,  0,170,254,
/* 0x0950 */ 125, 64, 89,214,127,133, 80, 64, 64,156,  0, 32, 32, 11,  8,  0,
/* 0x0960 */ 124,  0, 46,112,124, 11,  2, 20,125, 72, 83,120,126,  9,131,120,
/* 0x0970 */ 176,  7,  1,200, 72,  0,  0, 32, 85, 96,217,126,124,  0, 88, 80,
/* 0x0980 */ 125,233,123,120,176,  7,  1,200,124,170, 40, 80,125, 10, 64, 80,
/* 0x0990 */ 126, 15,131,120,126, 48,139,120,127, 81,211,120,125, 58, 75,120,
/* 0x09a0 */  47,151,  0,  6, 56,  0,  0,  8, 64,157,  0,  8, 56,  0,  0, 11,
/* 0x09b0 */ 124, 23,  3,120, 56,216, 10,104,127,136,176, 64, 65,157,  0, 32,
/* 0x09c0 */ 127,140,232,  0, 65,158,  3,212,137, 44,  0,  0, 84,160, 64, 46,
/* 0x09d0 */ 124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,161,102,  0,  0,
/* 0x09e0 */  85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0, 48,
/* 0x09f0 */  32, 11,  8,  0, 84,105, 32, 54,125, 38, 74, 20,124,  0, 46,112,
/* 0x0a00 */ 124, 11,  2, 20,125, 72, 83,120, 56,137,  0,  4, 59,128,  0,  0,
/* 0x0a10 */  59, 96,  0,  3,176,  6,  0,  0, 72,  0,  0,156,125, 10, 64, 80,
/* 0x0a20 */ 127,136,176, 64, 85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,
/* 0x0a30 */ 176,  6,  0,  0, 65,157,  0, 32,127,140,232,  0, 65,158,  3, 92,
/* 0x0a40 */ 137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46,
/* 0x0a50 */  57,140,  0,  1,161,102,  0,  2, 85,  0,170,254,125, 64, 89,214,
/* 0x0a60 */ 127,133, 80, 64, 64,156,  0, 48, 32, 11,  8,  0, 84,105, 32, 54,
/* 0x0a70 */ 125, 38, 74, 20,124,  0, 46,112,124, 11,  2, 20,125, 72, 83,120,
/* 0x0a80 */  56,137,  1,  4, 59,128,  0,  8, 59, 96,  0,  3,176,  6,  0,  2,
/* 0x0a90 */  72,  0,  0, 36, 85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,
/* 0x0aa0 */ 176,  6,  0,  2,125, 10, 64, 80, 56,134,  2,  4, 59,128,  0, 16,
/* 0x0ab0 */  59, 96,  0,  8,127,105,  3,166, 63,224,  0,255, 99,255,255,255,
/* 0x0ac0 */  56, 96,  0,  1,127,136,248, 64, 84,103,  8, 60,127, 12,232,  0,
/* 0x0ad0 */  84,169, 64, 46,124,227, 59,120, 65,157,  0, 24, 65,154,  2,188,
/* 0x0ae0 */ 136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,
/* 0x0af0 */ 125,100, 58, 46, 85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,
/* 0x0b00 */ 127,133, 80, 64,124,  0, 46,112, 85,105,217,126,124, 11,  2, 20,
/* 0x0b10 */ 125, 10, 64, 80,125,105, 88, 80, 64,156,  0, 16,125, 72, 83,120,
/* 0x0b20 */ 124,  4, 59, 46, 72,  0,  0, 16,124,170, 40, 80, 56,103,  0,  1,
/* 0x0b30 */ 125,100, 59, 46, 66,  0,255,144, 56,  0,  0,  1, 47,151,  0,  3,
/* 0x0b40 */ 124,  0,216, 48,124, 96, 24, 80,124, 99,226, 20, 65,157,  1,232,
/* 0x0b50 */  47,131,  0,  3, 58,247,  0,  7,124,105, 27,120, 64,157,  0,  8,
/* 0x0b60 */  57, 32,  0,  3, 85, 41, 56, 48,125, 56, 74, 20, 56,201,  3, 96,
/* 0x0b70 */  57, 32,  0,  6,125, 41,  3,166, 63,224,  0,255, 99,255,255,255,
/* 0x0b80 */  56,128,  0,  1,127,136,248, 64, 84,135,  8, 60,127, 12,232,  0,
/* 0x0b90 */  84,169, 64, 46,124,228, 59,120, 65,157,  0, 24, 65,154,  1,252,
/* 0x0ba0 */ 136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,
/* 0x0bb0 */ 125,102, 58, 46, 85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,
/* 0x0bc0 */ 127,133, 80, 64,124,  0, 46,112, 85,105,217,126,124, 11,  2, 20,
/* 0x0bd0 */ 125, 10, 64, 80,125,105, 88, 80, 64,156,  0, 16,125, 72, 83,120,
/* 0x0be0 */ 124,  6, 59, 46, 72,  0,  0, 16,124,170, 40, 80, 56,135,  0,  1,
/* 0x0bf0 */ 125,102, 59, 46, 66,  0,255,144, 56,132,255,192, 47,132,  0,  3,
/* 0x0c00 */ 124,154, 35,120, 64,157,  1, 40, 47,132,  0, 13,124,137, 14,112,
/* 0x0c10 */  84,128,  7,254, 57,105,255,255, 96, 26,  0,  2,125,105,  3,166,
/* 0x0c20 */  65,157,  0, 32,127, 90, 88, 48, 87, 73,  8, 60,125, 56, 74, 20,
/* 0x0c30 */  84,128,  8, 60,125, 32, 72, 80, 56,201,  5, 94, 72,  0,  0,100,
/* 0x0c40 */  57, 41,255,251,125, 41,  3,166, 61, 96,  0,255, 97,107,255,255,
/* 0x0c50 */ 127,136, 88, 64,127, 12,232,  0, 84,169, 64, 46, 87, 90,  8, 60,
/* 0x0c60 */  65,157,  0, 24, 65,154,  1, 52,136, 12,  0,  0, 85,  8, 64, 46,
/* 0x0c70 */  57,140,  0,  1,125, 37,  3,120, 85,  8,248,126,127,133, 64, 64,
/* 0x0c80 */  65,156,  0, 12,124,168, 40, 80, 99, 90,  0,  1, 66,  0,255,196,
/* 0x0c90 */  56,  0,  0,  4,124,  9,  3,166, 87, 90, 32, 54, 56,216,  6, 68,
/* 0x0ca0 */  60,128,  0,255, 96,132,255,255, 59,128,  0,  1, 59,224,  0,  1,
/* 0x0cb0 */ 127,136, 32, 64, 87,231,  8, 60,127, 12,232,  0, 84,169, 64, 46,
/* 0x0cc0 */ 124,255, 59,120, 65,157,  0, 24, 65,154,  0,208,136, 12,  0,  0,
/* 0x0cd0 */  85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,125,102, 58, 46,
/* 0x0ce0 */  85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,
/* 0x0cf0 */ 124,  0, 46,112, 85,105,217,126,124, 11,  2, 20,125, 10, 64, 80,
/* 0x0d00 */ 125,105, 88, 80, 64,156,  0, 16,125, 72, 83,120,124,  6, 59, 46,
/* 0x0d10 */  72,  0,  0, 20,124,170, 40, 80, 59,231,  0,  1,125,102, 59, 46,
/* 0x0d20 */ 127, 90,227,120, 87,156,  8, 60, 66,  0,255,136, 55, 90,  0,  1,
/* 0x0d30 */  65,130,  0, 72,127,154,200, 64, 56, 99,  0,  2, 65,157,  0, 92,
/* 0x0d40 */ 124, 26,200, 80,127,245,  0,174, 56, 99,255,255,127,249,169,174,
/* 0x0d50 */  59, 57,  0,  1, 49, 99,255,255,125, 43, 25, 16,124, 20,200, 16,
/* 0x0d60 */ 124,  0,  1, 16,124,  0,  0,208,125, 43,  0, 57, 64,130,255,212,
/* 0x0d70 */ 127,153,160, 64, 65,156,247,172, 60,  0,  0,255, 96,  0,255,255,
/* 0x0d80 */ 127,136,  0, 64, 65,157,  0, 32,127,140,232,  0, 56, 96,  0,  1,
/* 0x0d90 */  65,158,  0, 40, 72,  0,  0, 12, 56, 96,  0,  1, 72,  0,  0, 28,
/* 0x0da0 */  57,140,  0,  1,125, 40,  2,166,124, 19, 96, 80,144, 14,  0,  0,
/* 0x0db0 */  56, 96,  0,  0,147, 41,  0,  0,128,  1,  0,100,185,193,  0, 24,
/* 0x0dc0 */ 124,  8,  3,166, 56, 33,  0, 96,124,  8,  2,166,148, 33,255,160,
/* 0x0dd0 */ 189,193,  0, 24,144,  1,  0,100, 59, 32,  0,  0,137, 67,  0,  2,
/* 0x0de0 */ 137, 99,  0,  1,138, 67,  0,  0,147, 38,  0,  0,147, 41,  0,  0,
/* 0x0df0 */ 136,  3,  0,  1,125, 40,  3,166,124, 18,  2, 20, 57, 32,  3,  0,
/* 0x0e00 */ 125, 41,  0, 48, 56,  9,  7, 54,127,153,  0, 64, 57, 32,  0,  1,
/* 0x0e10 */ 125, 43, 88, 48,125, 41, 80, 48, 57, 41,255,255, 57,107,255,255,
/* 0x0e20 */ 145, 33,  0,  8,124,206, 51,120,124,147, 35,120,124,245, 59,120,
/* 0x0e30 */ 125, 20, 67,120,145, 97,  0, 12, 59,  3,  0,  4, 59,224,  0,  0,
/* 0x0e40 */  58,224,  0,  0, 59, 64,  0,  1, 58, 32,  0,  1, 58,  0,  0,  1,
/* 0x0e50 */  57,224,  0,  1, 57, 32,  0,  0, 64,156,  0, 28,124,  9,  3,166,
/* 0x0e60 */  57, 96,  4,  0, 85, 32,  8, 60,125,120,  3, 46, 57, 41,  0,  1,
/* 0x0e70 */  66,  0,255,244,127,179, 42, 20,126,108,155,120, 56,160,  0,  0,
/* 0x0e80 */  57,  0,255,255, 57, 96,  0,  0,127,140,232,  0, 57,107,  0,  1,
/* 0x0e90 */  47, 11,  0,  4, 84,169, 64, 46, 65,158,  8,156,136, 12,  0,  0,
/* 0x0ea0 */  57,140,  0,  1,125, 37,  3,120, 64,153,255,224,127,153,160, 64,
/* 0x0eb0 */  64,156,  8,100, 62,192,  0,255, 98,214,255,255,128,  1,  0,  8,
/* 0x0ec0 */ 127,136,176, 64,127, 35,  0, 56, 86,224, 32, 54,124,  0, 26, 20,
/* 0x0ed0 */  84,  6,  8, 60, 65,157,  0, 32,127,140,232,  0, 65,158,  8, 88,
/* 0x0ee0 */ 137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46,
/* 0x0ef0 */  57,140,  0,  1,124,230,194, 46, 85,  0,170,254,125, 64, 57,214,
/* 0x0f00 */ 127,133, 80, 64, 64,156,  1,172,128,  1,  0, 12, 47,151,  0,  6,
/* 0x0f10 */ 127, 41,  0, 56, 32, 18,  0,  8,127,224,  6, 48,125, 41,144, 48,
/* 0x0f20 */ 125, 41,  2, 20, 29, 41,  6,  0, 32,  7,  8,  0,124,  0, 46,112,
/* 0x0f30 */ 124,  7,  2, 20,125, 56, 74, 20,124,  6,195, 46,125, 72, 83,120,
/* 0x0f40 */  56,201, 14,108, 56, 96,  0,  1, 64,157,  0,180,124, 26,200, 80,
/* 0x0f50 */  63, 96,  0,255,127,245,  0,174, 99,123,255,255, 87,255,  8, 60,
/* 0x0f60 */  87,252,  5,238,127,136,216, 64, 87,128,  8, 60, 84,100,  8, 60,
/* 0x0f70 */ 124,  6,  2, 20,127, 12,232,  0, 84,169, 64, 46,124,224, 34, 20,
/* 0x0f80 */  65,157,  0, 24, 65,154,  7,176,136, 12,  0,  0, 85,  8, 64, 46,
/* 0x0f90 */  57,140,  0,  1,125, 37,  3,120,161,103,  2,  0, 85,  0,170,254,
/* 0x0fa0 */ 125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,124,  0, 46,112,
/* 0x0fb0 */  85,105,217,126,124, 11,  2, 20, 47, 28,  0,  0,125,105, 88, 80,
/* 0x0fc0 */ 124,131, 35,120,125, 10, 64, 80, 64,156,  0, 20,176,  7,  2,  0,
/* 0x0fd0 */ 125, 72, 83,120, 65,186,  0, 24, 72,  0,  0, 28,177,103,  2,  0,
/* 0x0fe0 */ 124,170, 40, 80, 56,100,  0,  1, 65,154,  0, 12, 47,131,  0,255,
/* 0x0ff0 */  64,157,255,108, 47,131,  0,255, 65,157,  0,132, 63,224,  0,255,
/* 0x1000 */  99,255,255,255,127,136,248, 64, 84,103,  8, 60,127, 12,232,  0,
/* 0x1010 */  84,169, 64, 46,124,227, 59,120, 65,157,  0, 24, 65,154,  7, 24,
/* 0x1020 */ 136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,
/* 0x1030 */ 125,102, 58, 46, 85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,
/* 0x1040 */ 127,133, 80, 64,124,  0, 46,112, 85,105,217,126,124, 11,  2, 20,
/* 0x1050 */ 125, 10, 64, 80,125,105, 88, 80, 64,156,  0, 16,125, 72, 83,120,
/* 0x1060 */ 124,  6, 59, 46, 72,  0,  0, 16,124,170, 40, 80,125,102, 59, 46,
/* 0x1070 */  56,103,  0,  1, 47,131,  0,255, 64,157,255,140, 47,151,  0,  3,
/* 0x1080 */  84,127,  6, 62,127,249,169,174, 59, 57,  0,  1, 65,157,  0, 12,
/* 0x1090 */  58,224,  0,  0, 72,  0,  6,120, 47,151,  0,  9, 65,157,  0, 12,
/* 0x10a0 */  58,247,255,253, 72,  0,  6,104, 58,247,255,250, 72,  0,  6, 96,
/* 0x10b0 */ 125, 10, 64, 80,127,136,176, 64, 84,224,217,126,124,  0, 56, 80,
/* 0x10c0 */  86,233,  8, 60,124,  6,195, 46,124,170, 40, 80,124,248, 74, 20,
/* 0x10d0 */  65,157,  0, 32,127,140,232,  0, 65,158,  6, 92,137, 44,  0,  0,
/* 0x10e0 */  84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x10f0 */ 161,103,  1,128, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,
/* 0x1100 */  64,156,  0, 64, 32, 11,  8,  0, 47,151,  0,  6,124,  0, 46,112,
/* 0x1110 */ 124, 11,  2, 20,176,  7,  1,128,126, 15,131,120,125, 72, 83,120,
/* 0x1120 */ 126, 48,139,120, 56,  0,  0,  0,127, 81,211,120, 64,157,  0,  8,
/* 0x1130 */  56,  0,  0,  3,124, 23,  3,120, 56,216,  6,100, 72,  0,  2, 24,
/* 0x1140 */ 125, 10, 64, 80,127,136,176, 64, 85, 96,217,126,124,  0, 88, 80,
/* 0x1150 */ 124,170, 40, 80,176,  7,  1,128, 65,157,  0, 32,127,140,232,  0,
/* 0x1160 */  65,158,  5,212,137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120,
/* 0x1170 */  85,  8, 64, 46, 57,140,  0,  1,161,103,  1,152, 85,  0,170,254,
/* 0x1180 */ 125, 64, 89,214,127,133, 80, 64, 64,156,  0,188, 32, 11,  8,  0,
/* 0x1190 */ 127,138,176, 64,124,  0, 46,112, 86,233, 40, 52,124, 11,  2, 20,
/* 0x11a0 */ 125, 56, 74, 20, 84,107,  8, 60,176,  7,  1,152,125, 72, 83,120,
/* 0x11b0 */ 124,233, 90, 20, 65,157,  0, 32,127,140,232,  0, 65,158,  5,120,
/* 0x11c0 */ 137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120, 85, 72, 64, 46,
/* 0x11d0 */  57,140,  0,  1,161,103,  1,224, 85,  0,170,254,125, 64, 89,214,
/* 0x11e0 */ 127,133, 80, 64, 64,156,  0, 72, 32, 11,  8,  0, 47,153,  0,  0,
/* 0x11f0 */ 124,  0, 46,112,124, 11,  2, 20,176,  7,  1,224,125, 72, 83,120,
/* 0x1200 */  65,158,  5, 52, 47,151,  0,  6, 57, 32,  0,  9, 64,157,  0,  8,
/* 0x1210 */  57, 32,  0, 11,124, 26,200, 80,127,245,  0,174,125, 55, 75,120,
/* 0x1220 */ 127,249,169,174, 59, 57,  0,  1, 72,  0,  4,228, 85, 96,217,126,
/* 0x1230 */ 124,  0, 88, 80,124,170, 40, 80,125, 10, 64, 80,176,  7,  1,224,
/* 0x1240 */  72,  0,  0,252,125, 10, 64, 80,127,136,176, 64, 85, 96,217,126,
/* 0x1250 */ 124,  0, 88, 80,124,170, 40, 80,176,  7,  1,152, 65,157,  0, 32,
/* 0x1260 */ 127,140,232,  0, 65,158,  4,208,137, 44,  0,  0, 84,160, 64, 46,
/* 0x1270 */ 124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,161,103,  1,176,
/* 0x1280 */  85,  0,170,254,125, 64, 89,214,127,133, 80, 64, 64,156,  0, 32,
/* 0x1290 */  32, 11,  8,  0,124,  0, 46,112,124, 11,  2, 20,125, 72, 83,120,
/* 0x12a0 */ 126, 41,139,120,176,  7,  1,176, 72,  0,  0,140,125, 10, 64, 80,
/* 0x12b0 */ 127,136,176, 64, 85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,
/* 0x12c0 */ 176,  7,  1,176, 65,157,  0, 32,127,140,232,  0, 65,158,  4,104,
/* 0x12d0 */ 137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46,
/* 0x12e0 */  57,140,  0,  1,161,103,  1,200, 85,  0,170,254,125, 64, 89,214,
/* 0x12f0 */ 127,133, 80, 64, 64,156,  0, 32, 32, 11,  8,  0,124,  0, 46,112,
/* 0x1300 */ 124, 11,  2, 20,125, 72, 83,120,126,  9,131,120,176,  7,  1,200,
/* 0x1310 */  72,  0,  0, 32, 85, 96,217,126,124,  0, 88, 80,125,233,123,120,
/* 0x1320 */ 176,  7,  1,200,124,170, 40, 80,125, 10, 64, 80,126, 15,131,120,
/* 0x1330 */ 126, 48,139,120,127, 81,211,120,125, 58, 75,120, 47,151,  0,  6,
/* 0x1340 */  56,  0,  0,  8, 64,157,  0,  8, 56,  0,  0, 11,124, 23,  3,120,
/* 0x1350 */  56,216, 10,104,127,136,176, 64, 65,157,  0, 32,127,140,232,  0,
/* 0x1360 */  65,158,  3,212,137, 44,  0,  0, 84,160, 64, 46,124,  5, 75,120,
/* 0x1370 */  85,  8, 64, 46, 57,140,  0,  1,161,102,  0,  0, 85,  0,170,254,
/* 0x1380 */ 125, 64, 89,214,127,133, 80, 64, 64,156,  0, 48, 32, 11,  8,  0,
/* 0x1390 */  84,105, 32, 54,125, 38, 74, 20,124,  0, 46,112,124, 11,  2, 20,
/* 0x13a0 */ 125, 72, 83,120, 56,137,  0,  4, 59,128,  0,  0, 59, 96,  0,  3,
/* 0x13b0 */ 176,  6,  0,  0, 72,  0,  0,156,125, 10, 64, 80,127,136,176, 64,
/* 0x13c0 */  85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,176,  6,  0,  0,
/* 0x13d0 */  65,157,  0, 32,127,140,232,  0, 65,158,  3, 92,137, 44,  0,  0,
/* 0x13e0 */  84,160, 64, 46,124,  5, 75,120, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x13f0 */ 161,102,  0,  2, 85,  0,170,254,125, 64, 89,214,127,133, 80, 64,
/* 0x1400 */  64,156,  0, 48, 32, 11,  8,  0, 84,105, 32, 54,125, 38, 74, 20,
/* 0x1410 */ 124,  0, 46,112,124, 11,  2, 20,125, 72, 83,120, 56,137,  1,  4,
/* 0x1420 */  59,128,  0,  8, 59, 96,  0,  3,176,  6,  0,  2, 72,  0,  0, 36,
/* 0x1430 */  85, 96,217,126,124,  0, 88, 80,124,170, 40, 80,176,  6,  0,  2,
/* 0x1440 */ 125, 10, 64, 80, 56,134,  2,  4, 59,128,  0, 16, 59, 96,  0,  8,
/* 0x1450 */ 127,105,  3,166, 63,224,  0,255, 99,255,255,255, 56, 96,  0,  1,
/* 0x1460 */ 127,136,248, 64, 84,103,  8, 60,127, 12,232,  0, 84,169, 64, 46,
/* 0x1470 */ 124,227, 59,120, 65,157,  0, 24, 65,154,  2,188,136, 12,  0,  0,
/* 0x1480 */  85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,125,100, 58, 46,
/* 0x1490 */  85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,
/* 0x14a0 */ 124,  0, 46,112, 85,105,217,126,124, 11,  2, 20,125, 10, 64, 80,
/* 0x14b0 */ 125,105, 88, 80, 64,156,  0, 16,125, 72, 83,120,124,  4, 59, 46,
/* 0x14c0 */  72,  0,  0, 16,124,170, 40, 80, 56,103,  0,  1,125,100, 59, 46,
/* 0x14d0 */  66,  0,255,144, 56,  0,  0,  1, 47,151,  0,  3,124,  0,216, 48,
/* 0x14e0 */ 124, 96, 24, 80,124, 99,226, 20, 65,157,  1,232, 47,131,  0,  3,
/* 0x14f0 */  58,247,  0,  7,124,105, 27,120, 64,157,  0,  8, 57, 32,  0,  3,
/* 0x1500 */  85, 41, 56, 48,125, 56, 74, 20, 56,201,  3, 96, 57, 32,  0,  6,
/* 0x1510 */ 125, 41,  3,166, 63,224,  0,255, 99,255,255,255, 56,128,  0,  1,
/* 0x1520 */ 127,136,248, 64, 84,135,  8, 60,127, 12,232,  0, 84,169, 64, 46,
/* 0x1530 */ 124,228, 59,120, 65,157,  0, 24, 65,154,  1,252,136, 12,  0,  0,
/* 0x1540 */  85,  8, 64, 46, 57,140,  0,  1,125, 37,  3,120,125,102, 58, 46,
/* 0x1550 */  85,  0,170,254,125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,
/* 0x1560 */ 124,  0, 46,112, 85,105,217,126,124, 11,  2, 20,125, 10, 64, 80,
/* 0x1570 */ 125,105, 88, 80, 64,156,  0, 16,125, 72, 83,120,124,  6, 59, 46,
/* 0x1580 */  72,  0,  0, 16,124,170, 40, 80, 56,135,  0,  1,125,102, 59, 46,
/* 0x1590 */  66,  0,255,144, 56,132,255,192, 47,132,  0,  3,124,154, 35,120,
/* 0x15a0 */  64,157,  1, 40, 47,132,  0, 13,124,137, 14,112, 84,128,  7,254,
/* 0x15b0 */  57,105,255,255, 96, 26,  0,  2,125,105,  3,166, 65,157,  0, 32,
/* 0x15c0 */ 127, 90, 88, 48, 87, 73,  8, 60,125, 56, 74, 20, 84,128,  8, 60,
/* 0x15d0 */ 125, 32, 72, 80, 56,201,  5, 94, 72,  0,  0,100, 57, 41,255,251,
/* 0x15e0 */ 125, 41,  3,166, 61, 96,  0,255, 97,107,255,255,127,136, 88, 64,
/* 0x15f0 */ 127, 12,232,  0, 84,169, 64, 46, 87, 90,  8, 60, 65,157,  0, 24,
/* 0x1600 */  65,154,  1, 52,136, 12,  0,  0, 85,  8, 64, 46, 57,140,  0,  1,
/* 0x1610 */ 125, 37,  3,120, 85,  8,248,126,127,133, 64, 64, 65,156,  0, 12,
/* 0x1620 */ 124,168, 40, 80, 99, 90,  0,  1, 66,  0,255,196, 56,  0,  0,  4,
/* 0x1630 */ 124,  9,  3,166, 87, 90, 32, 54, 56,216,  6, 68, 60,128,  0,255,
/* 0x1640 */  96,132,255,255, 59,128,  0,  1, 59,224,  0,  1,127,136, 32, 64,
/* 0x1650 */  87,231,  8, 60,127, 12,232,  0, 84,169, 64, 46,124,255, 59,120,
/* 0x1660 */  65,157,  0, 24, 65,154,  0,208,136, 12,  0,  0, 85,  8, 64, 46,
/* 0x1670 */  57,140,  0,  1,125, 37,  3,120,125,102, 58, 46, 85,  0,170,254,
/* 0x1680 */ 125, 64, 89,214, 32, 11,  8,  0,127,133, 80, 64,124,  0, 46,112,
/* 0x1690 */  85,105,217,126,124, 11,  2, 20,125, 10, 64, 80,125,105, 88, 80,
/* 0x16a0 */  64,156,  0, 16,125, 72, 83,120,124,  6, 59, 46, 72,  0,  0, 20,
/* 0x16b0 */ 124,170, 40, 80, 59,231,  0,  1,125,102, 59, 46,127, 90,227,120,
/* 0x16c0 */  87,156,  8, 60, 66,  0,255,136, 55, 90,  0,  1, 65,130,  0, 72,
/* 0x16d0 */ 127,154,200, 64, 56, 99,  0,  2, 65,157,  0, 92,124, 26,200, 80,
/* 0x16e0 */ 127,245,  0,174, 56, 99,255,255,127,249,169,174, 59, 57,  0,  1,
/* 0x16f0 */  49, 99,255,255,125, 43, 25, 16,124, 20,200, 16,124,  0,  1, 16,
/* 0x1700 */ 124,  0,  0,208,125, 43,  0, 57, 64,130,255,212,127,153,160, 64,
/* 0x1710 */  65,156,247,172, 60,  0,  0,255, 96,  0,255,255,127,136,  0, 64,
/* 0x1720 */  65,157,  0, 32,127,140,232,  0, 56, 96,  0,  1, 65,158,  0, 40,
/* 0x1730 */  72,  0,  0, 12, 56, 96,  0,  1, 72,  0,  0, 28, 57,140,  0,  1,
/* 0x1740 */ 125, 40,  2,166,124, 19, 96, 80,144, 14,  0,  0, 56, 96,  0,  0,
/* 0x1750 */ 147, 41,  0,  0,128,  1,  0,100,185,193,  0, 24,124,  8,  3,166,
/* 0x1760 */  56, 33,  0, 96,128,161,  0, 12,128,225,  0,  8,128,165,  0,  0,
/* 0x1770 */ 128, 33,  0,  0,124,165, 58, 20,128,  1,  0,  8, 56,165,255,255,
/* 0x1780 */ 124,  8,  3,166,128,230,  0,  0,125,168,  3,166,124,100, 24, 80,
/* 0x1790 */ 124,135, 40, 80, 56, 99,  0,  1, 56,132,  0,  1,144,134,  0,  0,
/* 0x17a0 */  96,231,  0, 31,124,  0, 56,108,124,  7, 40, 64,124,  0, 63,172,
/* 0x17b0 */  56,231,  0, 32, 65,128,255,240,124,  0,  4,172, 76,  0,  1, 44,
/* 0x17c0 */  78,128,  0, 32,148, 65,255,136,188, 97,  0,  4,127,232,  2,166,
/* 0x17d0 */ 130,191,255,252,131,191,255,244, 86,181,  1,186,127,189,170, 20,
/* 0x17e0 */  58,181,255,252, 56, 96,  0,  0,127,164,235,120, 56,160,  0,  3,
/* 0x17f0 */  56,192, 16,  2, 56,224,255,255, 57,  0,  0,  0, 57, 32,  0,  0,
/* 0x1800 */  56,  0,  0,197, 68,  0,  0,  2, 56, 96,255,255,124,124, 27,120,
/* 0x1810 */  56,160,  1,136,124,169,  3,166,124,131,234, 20,124,117,250, 20,
/* 0x1820 */ 140,  3,255,255,156,  4,255,255, 66,  0,255,248,124,165,232, 80,
/* 0x1830 */ 124,136,  3,166,124,169,  3,166, 78,128,  0, 32,140,  3,255,255,
/* 0x1840 */ 156,  4,255,255, 66,  0,255,248,131,223,255,232,127,227,248, 80,
/* 0x1850 */ 127,228,250, 20,127,222, 26, 20,128, 95,255,236,127, 68, 18, 20,
/* 0x1860 */ 127, 99, 18, 20, 59,123,255,232,128, 90,  0,  4, 59, 90,  0, 12,
/* 0x1870 */ 127, 90, 18, 20,127, 88,211,120,127,121,219,120, 56,122,  0,  0,
/* 0x1880 */  72,  0,  0,189, 65,130,  0,104,127,123, 26, 20,124,119, 27,120,
/* 0x1890 */  56,122,  0,  4, 72,  0,  0,169,127, 90, 26, 20,124,118, 27,120,
/* 0x18a0 */  59, 90,  0, 12,150,225,255,248,127,232,  3,166, 56,120,  0, 12,
/* 0x18b0 */ 126,196,179,120,127, 37,203,120,124, 38, 11,120,136,248,  0,  8,
/* 0x18c0 */  56, 33,255,232, 78,128,  0, 33, 56, 33,  0, 32,136,216,  0,  9,
/* 0x18d0 */  40,  6,  0,  0, 65,130,255,160,136,184,  0, 10,128,152,  0,  0,
/* 0x18e0 */ 127, 35,203,120, 72,  0,  0,125, 75,255,255,140, 72,  0,  0, 29,
/* 0x18f0 */  68,  0,  0,  2, 56, 96,255,255,184, 65,  0,  0, 56, 33,  0,120,
/* 0x1900 */ 124, 72,  3,166, 78,128,  4, 32, 56, 64,  0,  6,124,104,  2,166,
/* 0x1910 */  56, 99,  0, 24,124, 73,  3,166,132, 67,255,252,148, 89,255,252,
/* 0x1920 */  66,  0,255,248,127, 40,  3,166,127,201,  3,166,127,131,227,120,
/* 0x1930 */ 127,164,235,120, 56,  0,  0, 73, 78,128,  0, 32,136, 67,  0,  3,
/* 0x1940 */ 137, 99,  0,  2, 81, 98, 68, 46,137, 99,  0,  1, 81, 98,130, 30,
/* 0x1950 */ 137, 99,  0,  0, 81, 98,192, 14,124, 67, 19,121, 78,128,  0, 32,
/* 0x1960 */  40,  6,  0,208, 76,130,  0, 32, 84,132,240,191, 77,130,  0, 32,
/* 0x1970 */  60,  0,  0, 16,124,  4,  0, 64, 65,128,  0,  8,124,  4,  3,120,
/* 0x1980 */  56,165,  1, 32,124,103, 27,120, 56, 99,255,252,124,137,  3,166,
/* 0x1990 */  72,  0,  0, 28, 84, 75,  2,186,125, 99, 88, 80,125,107, 58, 20,
/* 0x19a0 */  81, 98,  1,186,144, 67,  0,  0, 78, 64,  0, 32,132, 67,  0,  4,
/* 0x19b0 */  84, 75, 85,190,124, 11, 40, 64, 65,162,255,220, 66,  0,255,240,
/* 0x19c0 */  78,128,  0, 32, 75,255,254,  0,102,105,108,101, 32,102,111,114,
/* 0x19d0 */ 109, 97,116, 32,101,108,102, 51, 50, 45,112,111,119,101,114,112,
/* 0x19e0 */  99, 10, 10, 83,101, 99,116,105,111,110,115, 58, 10, 73,100,120,
/* 0x19f0 */  32, 78, 97,109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,
/* 0x1a00 */ 105,122,101, 32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32,
/* 0x1a10 */  32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 70,105,108,
/* 0x1a20 */ 101, 32,111,102,102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,
/* 0x1a30 */ 103,115, 10, 32, 32, 48, 32, 77, 65, 67, 79, 83, 48, 48, 48, 32,
/* 0x1a40 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 56, 32, 32, 48,
/* 0x1a50 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1a60 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 51, 52, 32, 32, 50, 42, 42,
/* 0x1a70 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x1a80 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 49,
/* 0x1a90 */  32, 78, 82, 86, 95, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48,
/* 0x1aa0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ab0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1ac0 */  48, 48, 48, 51, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x1ad0 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x1ae0 */  32, 32, 50, 32, 78, 82, 86, 50, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x1af0 */  32, 32, 48, 48, 48, 48, 48, 49, 52, 56, 32, 32, 48, 48, 48, 48,
/* 0x1b00 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1b10 */  48, 48, 48, 48, 48, 48, 51, 99, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1b20 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x1b30 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 51, 32, 78, 82,
/* 0x1b40 */  86, 50, 68, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x1b50 */  48, 49, 50, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1b60 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,
/* 0x1b70 */  56, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1b80 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x1b90 */  78, 76, 89, 10, 32, 32, 52, 32, 78, 82, 86, 50, 66, 32, 32, 32,
/* 0x1ba0 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,102, 48, 32, 32,
/* 0x1bb0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1bc0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 98, 48, 32, 32, 50, 42,
/* 0x1bd0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x1be0 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32,
/* 0x1bf0 */  53, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32,
/* 0x1c00 */  48, 48, 48, 48, 48, 48, 56, 99, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1c10 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1c20 */  48, 48, 48, 51, 97, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1c30 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x1c40 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 54, 32, 76, 90, 77, 65,
/* 0x1c50 */  95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48, 57,
/* 0x1c60 */  57, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1c70 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 52, 50, 99,
/* 0x1c80 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x1c90 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 55, 32, 76,
/* 0x1ca0 */  90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32, 32, 48, 48, 48,
/* 0x1cb0 */  48, 48, 57, 57, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1cc0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1cd0 */ 100, 99, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1ce0 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32,
/* 0x1cf0 */  56, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32,
/* 0x1d00 */  48, 48, 48, 48, 48, 48, 50, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1d10 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1d20 */  48, 48, 49, 55, 54, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1d30 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x1d40 */  10, 32, 32, 57, 32, 78, 82, 86, 95, 84, 65, 73, 76, 32, 32, 32,
/* 0x1d50 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 99, 32, 32, 48, 48, 48,
/* 0x1d60 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1d70 */  32, 48, 48, 48, 48, 49, 55, 56, 52, 32, 32, 50, 42, 42, 48, 32,
/* 0x1d80 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,
/* 0x1d90 */  78, 76, 89, 10, 32, 49, 48, 32, 67, 70, 76, 85, 83, 72, 32, 32,
/* 0x1da0 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 50, 52, 32, 32,
/* 0x1db0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1dc0 */  48, 48, 32, 32, 48, 48, 48, 48, 49, 55, 97, 48, 32, 32, 50, 42,
/* 0x1dd0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x1de0 */  65, 68, 79, 78, 76, 89, 10, 32, 49, 49, 32, 69, 76, 70, 77, 65,
/* 0x1df0 */  73, 78, 89, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e00 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1e10 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 55, 99, 52, 32,
/* 0x1e20 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x1e30 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 50, 32, 69, 76,
/* 0x1e40 */  70, 77, 65, 73, 78, 90, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x1e50 */  48, 50, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1e60 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 55,
/* 0x1e70 */  99, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1e80 */  84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 83, 89, 77,
/* 0x1e90 */  66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48,
/* 0x1ea0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65,
/* 0x1eb0 */  95, 68, 69, 67, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1ec0 */  76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48,
/* 0x1ed0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 95,
/* 0x1ee0 */  84, 65, 73, 76,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82,
/* 0x1ef0 */  86, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1f00 */ 108, 32, 32, 32, 32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 90,
/* 0x1f10 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 69, 76, 70, 77, 65, 73,
/* 0x1f20 */  78, 90, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x1f30 */  32,100, 32, 32, 77, 65, 67, 79, 83, 48, 48, 48,  9, 48, 48, 48,
/* 0x1f40 */  48, 48, 48, 48, 48, 32, 77, 65, 67, 79, 83, 48, 48, 48, 10, 48,
/* 0x1f50 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x1f60 */  78, 82, 86, 95, 72, 69, 65, 68,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x1f70 */  48, 32, 78, 82, 86, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48,
/* 0x1f80 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50,
/* 0x1f90 */  69,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 69,
/* 0x1fa0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x1fb0 */  32, 32, 78, 82, 86, 50, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1fc0 */  32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1fd0 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66,  9, 48, 48,
/* 0x1fe0 */  48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48,
/* 0x1ff0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90,
/* 0x2000 */  77, 65, 95, 69, 76, 70, 48, 48,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x2010 */  48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48,
/* 0x2020 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90,
/* 0x2030 */  77, 65, 95, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x2040 */  48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x2050 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90,
/* 0x2060 */  77, 65, 95, 68, 69, 67, 50, 48,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x2070 */  48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x2080 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 70,
/* 0x2090 */  76, 85, 83, 72,  9, 48, 48, 48, 48, 48, 48, 48, 48, 32, 67, 70,
/* 0x20a0 */  76, 85, 83, 72, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x20b0 */  32, 32, 32,100, 32, 32, 69, 76, 70, 77, 65, 73, 78, 89,  9, 48,
/* 0x20c0 */  48, 48, 48, 48, 48, 48, 48, 32, 69, 76, 70, 77, 65, 73, 78, 89,
/* 0x20d0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32,
/* 0x20e0 */  32, 32, 77, 65, 67, 79, 83, 48, 48, 48,  9, 48, 48, 48, 48, 48,
/* 0x20f0 */  48, 48, 48, 32, 95,115,116, 97,114,116, 10, 10, 82, 69, 76, 79,
/* 0x2100 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x2110 */  79, 82, 32, 91, 77, 65, 67, 79, 83, 48, 48, 48, 93, 58, 10, 79,
/* 0x2120 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x2130 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x2140 */  48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 80, 80, 67, 95, 82,
/* 0x2150 */  69, 76, 50, 52, 32, 32, 32, 32, 32, 32, 32, 69, 76, 70, 77, 65,
/* 0x2160 */  73, 78, 90, 43, 48,120, 48, 48, 48, 48, 48, 50, 48, 48, 10, 10,
/* 0x2170 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x2180 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 69, 93, 58, 10,
/* 0x2190 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x21a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x21b0 */  10, 48, 48, 48, 48, 48, 48, 98, 52, 32, 82, 95, 80, 80, 67, 95,
/* 0x21c0 */  82, 69, 76, 49, 52, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 95,
/* 0x21d0 */  84, 65, 73, 76, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x21e0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 82,
/* 0x21f0 */  86, 50, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x2200 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x2210 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 98, 52, 32,
/* 0x2220 */  82, 95, 80, 80, 67, 95, 82, 69, 76, 49, 52, 32, 32, 32, 32, 32,
/* 0x2230 */  32, 32, 78, 82, 86, 95, 84, 65, 73, 76, 10, 10, 82, 69, 76, 79,
/* 0x2240 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x2250 */  79, 82, 32, 91, 78, 82, 86, 50, 66, 93, 58, 10, 79, 70, 70, 83,
/* 0x2260 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x2270 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x2280 */  48, 48, 48, 57, 48, 32, 82, 95, 80, 80, 67, 95, 82, 69, 76, 49,
/* 0x2290 */  52, 32, 32, 32, 32, 32, 32, 32, 78, 82, 86, 95, 84, 65, 73, 76,
/* 0x22a0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x22b0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 69,
/* 0x22c0 */  76, 70, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x22d0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x22e0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x22f0 */  32, 82, 95, 80, 80, 67, 95, 82, 69, 76, 49, 52, 32, 32, 32, 32,
/* 0x2300 */  32, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 43, 48,120,
/* 0x2310 */  48, 48, 48, 48, 48, 48, 50, 48, 10
};
