/* hashset.c generated by valac, the Vala compiler
 * generated from hashset.vala, do not modify */

/* hashset.vala
 *
 * Copyright (C) 1995-1997  Peter Mattis, Spencer Kimball and Josh MacDonald
 * Copyright (C) 1997-2000  GLib Team and others
 * Copyright (C) 2007-2009  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>


#define VALA_TYPE_ITERABLE (vala_iterable_get_type ())
#define VALA_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ITERABLE, ValaIterable))
#define VALA_ITERABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ITERABLE, ValaIterableClass))
#define VALA_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ITERABLE))
#define VALA_IS_ITERABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ITERABLE))
#define VALA_ITERABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ITERABLE, ValaIterableClass))

typedef struct _ValaIterable ValaIterable;
typedef struct _ValaIterableClass ValaIterableClass;
typedef struct _ValaIterablePrivate ValaIterablePrivate;

#define VALA_TYPE_ITERATOR (vala_iterator_get_type ())
#define VALA_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_ITERATOR, ValaIterator))
#define VALA_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_ITERATOR, ValaIteratorClass))
#define VALA_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_ITERATOR))
#define VALA_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_ITERATOR))
#define VALA_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_ITERATOR, ValaIteratorClass))

typedef struct _ValaIterator ValaIterator;
typedef struct _ValaIteratorClass ValaIteratorClass;

#define VALA_TYPE_COLLECTION (vala_collection_get_type ())
#define VALA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_COLLECTION, ValaCollection))
#define VALA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_COLLECTION, ValaCollectionClass))
#define VALA_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_COLLECTION))
#define VALA_IS_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_COLLECTION))
#define VALA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_COLLECTION, ValaCollectionClass))

typedef struct _ValaCollection ValaCollection;
typedef struct _ValaCollectionClass ValaCollectionClass;
typedef struct _ValaCollectionPrivate ValaCollectionPrivate;

#define VALA_TYPE_SET (vala_set_get_type ())
#define VALA_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_SET, ValaSet))
#define VALA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_SET, ValaSetClass))
#define VALA_IS_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_SET))
#define VALA_IS_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_SET))
#define VALA_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_SET, ValaSetClass))

typedef struct _ValaSet ValaSet;
typedef struct _ValaSetClass ValaSetClass;
typedef struct _ValaSetPrivate ValaSetPrivate;

#define VALA_TYPE_HASH_SET (vala_hash_set_get_type ())
#define VALA_HASH_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_HASH_SET, ValaHashSet))
#define VALA_HASH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_HASH_SET, ValaHashSetClass))
#define VALA_IS_HASH_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_HASH_SET))
#define VALA_IS_HASH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_HASH_SET))
#define VALA_HASH_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_HASH_SET, ValaHashSetClass))

typedef struct _ValaHashSet ValaHashSet;
typedef struct _ValaHashSetClass ValaHashSetClass;
typedef struct _ValaHashSetPrivate ValaHashSetPrivate;
typedef struct _ValaHashSetNode ValaHashSetNode;

#define VALA_HASH_SET_TYPE_ITERATOR (vala_hash_set_iterator_get_type ())
#define VALA_HASH_SET_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_HASH_SET_TYPE_ITERATOR, ValaHashSetIterator))
#define VALA_HASH_SET_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_HASH_SET_TYPE_ITERATOR, ValaHashSetIteratorClass))
#define VALA_HASH_SET_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_HASH_SET_TYPE_ITERATOR))
#define VALA_HASH_SET_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_HASH_SET_TYPE_ITERATOR))
#define VALA_HASH_SET_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_HASH_SET_TYPE_ITERATOR, ValaHashSetIteratorClass))

typedef struct _ValaHashSetIterator ValaHashSetIterator;
typedef struct _ValaHashSetIteratorClass ValaHashSetIteratorClass;
#define _vala_hash_set_node_free0(var) ((var == NULL) ? NULL : (var = (vala_hash_set_node_free (var), NULL)))
typedef struct _ValaIteratorPrivate ValaIteratorPrivate;
typedef struct _ValaHashSetIteratorPrivate ValaHashSetIteratorPrivate;
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaIterable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaIterablePrivate * priv;
};

struct _ValaIterableClass {
	GTypeClass parent_class;
	void (*finalize) (ValaIterable *self);
	GType (*get_element_type) (ValaIterable* self);
	ValaIterator* (*iterator) (ValaIterable* self);
};

struct _ValaCollection {
	ValaIterable parent_instance;
	ValaCollectionPrivate * priv;
};

struct _ValaCollectionClass {
	ValaIterableClass parent_class;
	gboolean (*contains) (ValaCollection* self, gconstpointer item);
	gboolean (*add) (ValaCollection* self, gconstpointer item);
	gboolean (*remove) (ValaCollection* self, gconstpointer item);
	void (*clear) (ValaCollection* self);
	gint (*get_size) (ValaCollection* self);
};

struct _ValaSet {
	ValaCollection parent_instance;
	ValaSetPrivate * priv;
};

struct _ValaSetClass {
	ValaCollectionClass parent_class;
};

struct _ValaHashSet {
	ValaSet parent_instance;
	ValaHashSetPrivate * priv;
};

struct _ValaHashSetClass {
	ValaSetClass parent_class;
};

struct _ValaHashSetPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gint _array_size;
	gint _nnodes;
	ValaHashSetNode** _nodes;
	gint _nodes_length1;
	gint __nodes_size_;
	gint _stamp;
	GHashFunc _hash_func;
	GEqualFunc _equal_func;
};

struct _ValaHashSetNode {
	gpointer key;
	ValaHashSetNode* next;
	guint key_hash;
};

struct _ValaIterator {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaIteratorPrivate * priv;
};

struct _ValaIteratorClass {
	GTypeClass parent_class;
	void (*finalize) (ValaIterator *self);
	gboolean (*next) (ValaIterator* self);
	gpointer (*get) (ValaIterator* self);
};

struct _ValaHashSetIterator {
	ValaIterator parent_instance;
	ValaHashSetIteratorPrivate * priv;
};

struct _ValaHashSetIteratorClass {
	ValaIteratorClass parent_class;
};

struct _ValaHashSetIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	ValaHashSet* _set;
	gint _index;
	ValaHashSetNode* _node;
	gint _stamp;
};


static gpointer vala_hash_set_parent_class = NULL;
static gpointer vala_hash_set_iterator_parent_class = NULL;

gpointer vala_iterable_ref (gpointer instance);
void vala_iterable_unref (gpointer instance);
GParamSpec* vala_param_spec_iterable (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_iterable (GValue* value, gpointer v_object);
void vala_value_take_iterable (GValue* value, gpointer v_object);
gpointer vala_value_get_iterable (const GValue* value);
GType vala_iterable_get_type (void) G_GNUC_CONST;
gpointer vala_iterator_ref (gpointer instance);
void vala_iterator_unref (gpointer instance);
GParamSpec* vala_param_spec_iterator (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void vala_value_set_iterator (GValue* value, gpointer v_object);
void vala_value_take_iterator (GValue* value, gpointer v_object);
gpointer vala_value_get_iterator (const GValue* value);
GType vala_iterator_get_type (void) G_GNUC_CONST;
GType vala_collection_get_type (void) G_GNUC_CONST;
GType vala_set_get_type (void) G_GNUC_CONST;
GType vala_hash_set_get_type (void) G_GNUC_CONST;
static void vala_hash_set_node_free (ValaHashSetNode* self);
#define VALA_HASH_SET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_HASH_SET, ValaHashSetPrivate))
enum  {
	VALA_HASH_SET_DUMMY_PROPERTY
};
void vala_collection_clear (ValaCollection* self);
#define VALA_HASH_SET_MIN_SIZE 11
#define VALA_HASH_SET_MAX_SIZE 13845163
ValaHashSet* vala_hash_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GHashFunc hash_func, GEqualFunc equal_func);
ValaHashSet* vala_hash_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GHashFunc hash_func, GEqualFunc equal_func);
ValaSet* vala_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
void vala_hash_set_set_hash_func (ValaHashSet* self, GHashFunc value);
void vala_hash_set_set_equal_func (ValaHashSet* self, GEqualFunc value);
static ValaHashSetNode** vala_hash_set_lookup_node (ValaHashSet* self, gconstpointer key);
static gboolean vala_hash_set_real_contains (ValaCollection* base, gconstpointer key);
static GType vala_hash_set_real_get_element_type (ValaIterable* base);
static ValaIterator* vala_hash_set_real_iterator (ValaIterable* base);
static ValaHashSetIterator* vala_hash_set_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, ValaHashSet* set);
static ValaHashSetIterator* vala_hash_set_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, ValaHashSet* set);
static GType vala_hash_set_iterator_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean vala_hash_set_real_add (ValaCollection* base, gconstpointer key);
static ValaHashSetNode* vala_hash_set_node_new (gpointer k, guint hash);
static ValaHashSetNode* vala_hash_set_node_new (gpointer k, guint hash);
static void vala_hash_set_resize (ValaHashSet* self);
static gboolean vala_hash_set_real_remove (ValaCollection* base, gconstpointer key);
static void vala_hash_set_real_clear (ValaCollection* base);
static void vala_hash_set_node_instance_init (ValaHashSetNode * self);
#define VALA_HASH_SET_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_HASH_SET_TYPE_ITERATOR, ValaHashSetIteratorPrivate))
enum  {
	VALA_HASH_SET_ITERATOR_DUMMY_PROPERTY
};
ValaIterator* vala_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
static void vala_hash_set_iterator_set_set (ValaHashSetIterator* self, ValaHashSet* value);
static gboolean vala_hash_set_iterator_real_next (ValaIterator* base);
static gpointer vala_hash_set_iterator_real_get (ValaIterator* base);
static void vala_hash_set_iterator_finalize (ValaIterator* obj);
static void vala_hash_set_finalize (ValaIterable* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


ValaHashSet* vala_hash_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GHashFunc hash_func, GEqualFunc equal_func) {
	ValaHashSet* self = NULL;
	ValaHashSetNode** _tmp0_ = NULL;
	self = (ValaHashSet*) vala_set_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	vala_hash_set_set_hash_func (self, hash_func);
	vala_hash_set_set_equal_func (self, equal_func);
	self->priv->_array_size = VALA_HASH_SET_MIN_SIZE;
	_tmp0_ = g_new0 (ValaHashSetNode*, self->priv->_array_size + 1);
	self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) vala_hash_set_node_free), NULL);
	self->priv->_nodes = _tmp0_;
	self->priv->_nodes_length1 = self->priv->_array_size;
	self->priv->__nodes_size_ = self->priv->_array_size;
	return self;
}


ValaHashSet* vala_hash_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GHashFunc hash_func, GEqualFunc equal_func) {
	return vala_hash_set_construct (VALA_TYPE_HASH_SET, g_type, g_dup_func, g_destroy_func, hash_func, equal_func);
}


static ValaHashSetNode** vala_hash_set_lookup_node (ValaHashSet* self, gconstpointer key) {
	ValaHashSetNode** result = NULL;
	guint _tmp0_;
	guint hash_value;
	ValaHashSetNode** node;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_hash_func (key);
	hash_value = _tmp0_;
	node = &self->priv->_nodes[hash_value % self->priv->_array_size];
	while (TRUE) {
		gboolean _tmp1_ = FALSE;
		if ((*node) != NULL) {
			gboolean _tmp2_ = FALSE;
			if (hash_value != (*node)->key_hash) {
				_tmp2_ = TRUE;
			} else {
				gboolean _tmp3_;
				_tmp3_ = self->priv->_equal_func ((*node)->key, key);
				_tmp2_ = !_tmp3_;
			}
			_tmp1_ = _tmp2_;
		} else {
			_tmp1_ = FALSE;
		}
		if (!_tmp1_) {
			break;
		}
		node = &(*node)->next;
	}
	result = node;
	return result;
}


static gboolean vala_hash_set_real_contains (ValaCollection* base, gconstpointer key) {
	ValaHashSet * self;
	gboolean result = FALSE;
	ValaHashSetNode** _tmp0_ = NULL;
	ValaHashSetNode** node;
	self = (ValaHashSet*) base;
	_tmp0_ = vala_hash_set_lookup_node (self, key);
	node = _tmp0_;
	result = (*node) != NULL;
	return result;
}


static GType vala_hash_set_real_get_element_type (ValaIterable* base) {
	ValaHashSet * self;
	GType result = 0UL;
	self = (ValaHashSet*) base;
	result = self->priv->g_type;
	return result;
}


static ValaIterator* vala_hash_set_real_iterator (ValaIterable* base) {
	ValaHashSet * self;
	ValaIterator* result = NULL;
	ValaHashSetIterator* _tmp0_ = NULL;
	self = (ValaHashSet*) base;
	_tmp0_ = vala_hash_set_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
	result = (ValaIterator*) _tmp0_;
	return result;
}


static gboolean vala_hash_set_real_add (ValaCollection* base, gconstpointer key) {
	ValaHashSet * self;
	gboolean result = FALSE;
	ValaHashSetNode** _tmp0_ = NULL;
	ValaHashSetNode** node;
	self = (ValaHashSet*) base;
	_tmp0_ = vala_hash_set_lookup_node (self, key);
	node = _tmp0_;
	if ((*node) != NULL) {
		result = FALSE;
		return result;
	} else {
		guint _tmp1_;
		guint hash_value;
		gpointer _tmp2_;
		gconstpointer _tmp3_;
		ValaHashSetNode* _tmp4_ = NULL;
		_tmp1_ = self->priv->_hash_func (key);
		hash_value = _tmp1_;
		_tmp2_ = (_tmp3_ = key, ((_tmp3_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp3_) : self->priv->g_dup_func ((gpointer) _tmp3_));
		_tmp4_ = vala_hash_set_node_new (_tmp2_, hash_value);
		*node = _tmp4_;
		self->priv->_nnodes++;
		vala_hash_set_resize (self);
		self->priv->_stamp++;
		result = TRUE;
		return result;
	}
}


static gboolean vala_hash_set_real_remove (ValaCollection* base, gconstpointer key) {
	ValaHashSet * self;
	gboolean result = FALSE;
	ValaHashSetNode** _tmp0_ = NULL;
	ValaHashSetNode** node;
	self = (ValaHashSet*) base;
	_tmp0_ = vala_hash_set_lookup_node (self, key);
	node = _tmp0_;
	if ((*node) != NULL) {
		ValaHashSetNode* _tmp1_;
		ValaHashSetNode* next;
		ValaHashSetNode* _tmp2_;
		_tmp1_ = (*node)->next;
		(*node)->next = NULL;
		next = _tmp1_;
		(((*node)->key == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*node)->key = (self->priv->g_destroy_func ((*node)->key), NULL));
		(*node)->key = NULL;
		vala_hash_set_node_free (*node);
		_tmp2_ = next;
		next = NULL;
		*node = _tmp2_;
		self->priv->_nnodes--;
		vala_hash_set_resize (self);
		self->priv->_stamp++;
		result = TRUE;
		_vala_hash_set_node_free0 (next);
		return result;
	}
	result = FALSE;
	return result;
}


static void vala_hash_set_real_clear (ValaCollection* base) {
	ValaHashSet * self;
	self = (ValaHashSet*) base;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaHashSetNode* _tmp1_;
				ValaHashSetNode* node;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < self->priv->_array_size)) {
					break;
				}
				_tmp1_ = self->priv->_nodes[i];
				self->priv->_nodes[i] = NULL;
				node = _tmp1_;
				while (TRUE) {
					ValaHashSetNode* _tmp2_;
					ValaHashSetNode* next;
					ValaHashSetNode* _tmp3_;
					if (!(node != NULL)) {
						break;
					}
					_tmp2_ = node->next;
					node->next = NULL;
					next = _tmp2_;
					((node->key == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (node->key = (self->priv->g_destroy_func (node->key), NULL));
					node->key = NULL;
					_tmp3_ = next;
					next = NULL;
					_vala_hash_set_node_free0 (node);
					node = _tmp3_;
					_vala_hash_set_node_free0 (next);
				}
				_vala_hash_set_node_free0 (node);
			}
		}
	}
	self->priv->_nnodes = 0;
	vala_hash_set_resize (self);
}


static void vala_hash_set_resize (ValaHashSet* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->_array_size >= (3 * self->priv->_nnodes)) {
		_tmp1_ = self->priv->_array_size >= VALA_HASH_SET_MIN_SIZE;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if ((3 * self->priv->_array_size) <= self->priv->_nnodes) {
			_tmp2_ = self->priv->_array_size < VALA_HASH_SET_MAX_SIZE;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		guint _tmp3_;
		gint new_array_size;
		gint _tmp4_;
		ValaHashSetNode** _tmp5_ = NULL;
		ValaHashSetNode** new_nodes;
		gint new_nodes_length1;
		gint _new_nodes_size_;
		ValaHashSetNode** _tmp14_;
		_tmp3_ = g_spaced_primes_closest ((guint) self->priv->_nnodes);
		new_array_size = (gint) _tmp3_;
		_tmp4_ = CLAMP (new_array_size, VALA_HASH_SET_MIN_SIZE, VALA_HASH_SET_MAX_SIZE);
		new_array_size = _tmp4_;
		_tmp5_ = g_new0 (ValaHashSetNode*, new_array_size + 1);
		new_nodes = _tmp5_;
		new_nodes_length1 = new_array_size;
		_new_nodes_size_ = new_array_size;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp6_;
				_tmp6_ = TRUE;
				while (TRUE) {
					ValaHashSetNode* node = NULL;
					ValaHashSetNode* next;
					if (!_tmp6_) {
						i++;
					}
					_tmp6_ = FALSE;
					if (!(i < self->priv->_array_size)) {
						break;
					}
					next = NULL;
					{
						ValaHashSetNode* _tmp7_;
						gboolean _tmp8_;
						_tmp7_ = self->priv->_nodes[i];
						self->priv->_nodes[i] = NULL;
						_vala_hash_set_node_free0 (node);
						node = _tmp7_;
						_tmp8_ = TRUE;
						while (TRUE) {
							ValaHashSetNode* _tmp10_;
							guint hash_val;
							ValaHashSetNode* _tmp11_;
							ValaHashSetNode* _tmp12_;
							ValaHashSetNode* _tmp13_;
							if (!_tmp8_) {
								ValaHashSetNode* _tmp9_;
								_tmp9_ = next;
								next = NULL;
								_vala_hash_set_node_free0 (node);
								node = _tmp9_;
							}
							_tmp8_ = FALSE;
							if (!(node != NULL)) {
								break;
							}
							_tmp10_ = node->next;
							node->next = NULL;
							_vala_hash_set_node_free0 (next);
							next = _tmp10_;
							hash_val = node->key_hash % new_array_size;
							_tmp11_ = new_nodes[hash_val];
							new_nodes[hash_val] = NULL;
							_vala_hash_set_node_free0 (node->next);
							node->next = _tmp11_;
							_tmp12_ = node;
							node = NULL;
							_tmp13_ = _tmp12_;
							_vala_hash_set_node_free0 (new_nodes[hash_val]);
							new_nodes[hash_val] = _tmp13_;
						}
					}
					_vala_hash_set_node_free0 (next);
					_vala_hash_set_node_free0 (node);
				}
			}
		}
		_tmp14_ = new_nodes;
		new_nodes = NULL;
		self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) vala_hash_set_node_free), NULL);
		self->priv->_nodes = _tmp14_;
		self->priv->_nodes_length1 = new_nodes_length1;
		self->priv->__nodes_size_ = new_nodes_length1;
		self->priv->_array_size = new_array_size;
		new_nodes = (_vala_array_free (new_nodes, new_nodes_length1, (GDestroyNotify) vala_hash_set_node_free), NULL);
	}
}


static gint vala_hash_set_real_get_size (ValaCollection* base) {
	gint result;
	ValaHashSet* self;
	self = (ValaHashSet*) base;
	result = self->priv->_nnodes;
	return result;
}


void vala_hash_set_set_hash_func (ValaHashSet* self, GHashFunc value) {
	g_return_if_fail (self != NULL);
	self->priv->_hash_func = value;
}


void vala_hash_set_set_equal_func (ValaHashSet* self, GEqualFunc value) {
	g_return_if_fail (self != NULL);
	self->priv->_equal_func = value;
}


static ValaHashSetNode* vala_hash_set_node_new (gpointer k, guint hash) {
	ValaHashSetNode* self;
	gpointer _tmp0_;
	self = g_slice_new0 (ValaHashSetNode);
	vala_hash_set_node_instance_init (self);
	_tmp0_ = k;
	k = NULL;
	self->key = _tmp0_;
	self->key_hash = hash;
	return self;
}


static void vala_hash_set_node_instance_init (ValaHashSetNode * self) {
}


static void vala_hash_set_node_free (ValaHashSetNode* self) {
	_vala_hash_set_node_free0 (self->next);
	g_slice_free (ValaHashSetNode, self);
}


static ValaHashSetIterator* vala_hash_set_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, ValaHashSet* set) {
	ValaHashSetIterator* self = NULL;
	g_return_val_if_fail (set != NULL, NULL);
	self = (ValaHashSetIterator*) vala_iterator_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	vala_hash_set_iterator_set_set (self, set);
	return self;
}


static ValaHashSetIterator* vala_hash_set_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, ValaHashSet* set) {
	return vala_hash_set_iterator_construct (VALA_HASH_SET_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, set);
}


static gboolean vala_hash_set_iterator_real_next (ValaIterator* base) {
	ValaHashSetIterator * self;
	gboolean result = FALSE;
	self = (ValaHashSetIterator*) base;
	if (self->priv->_node != NULL) {
		self->priv->_node = self->priv->_node->next;
	}
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (self->priv->_node == NULL) {
			_tmp0_ = (self->priv->_index + 1) < self->priv->_set->priv->_array_size;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		self->priv->_index++;
		self->priv->_node = self->priv->_set->priv->_nodes[self->priv->_index];
	}
	result = self->priv->_node != NULL;
	return result;
}


static gpointer vala_hash_set_iterator_real_get (ValaIterator* base) {
	ValaHashSetIterator * self;
	gpointer result = NULL;
	gpointer _tmp0_;
	gconstpointer _tmp1_;
	self = (ValaHashSetIterator*) base;
	g_assert (self->priv->_stamp == self->priv->_set->priv->_stamp);
	g_assert (self->priv->_node != NULL);
	_tmp0_ = (_tmp1_ = self->priv->_node->key, ((_tmp1_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp1_) : self->priv->g_dup_func ((gpointer) _tmp1_));
	result = _tmp0_;
	return result;
}


static gpointer _vala_iterable_ref0 (gpointer self) {
	return self ? vala_iterable_ref (self) : NULL;
}


static void vala_hash_set_iterator_set_set (ValaHashSetIterator* self, ValaHashSet* value) {
	ValaHashSet* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_iterable_ref0 (value);
	_vala_iterable_unref0 (self->priv->_set);
	self->priv->_set = _tmp0_;
	self->priv->_stamp = self->priv->_set->priv->_stamp;
}


static void vala_hash_set_iterator_class_init (ValaHashSetIteratorClass * klass) {
	vala_hash_set_iterator_parent_class = g_type_class_peek_parent (klass);
	VALA_ITERATOR_CLASS (klass)->finalize = vala_hash_set_iterator_finalize;
	g_type_class_add_private (klass, sizeof (ValaHashSetIteratorPrivate));
	VALA_ITERATOR_CLASS (klass)->next = vala_hash_set_iterator_real_next;
	VALA_ITERATOR_CLASS (klass)->get = vala_hash_set_iterator_real_get;
}


static void vala_hash_set_iterator_instance_init (ValaHashSetIterator * self) {
	self->priv = VALA_HASH_SET_ITERATOR_GET_PRIVATE (self);
	self->priv->_index = -1;
	self->priv->_stamp = 0;
}


static void vala_hash_set_iterator_finalize (ValaIterator* obj) {
	ValaHashSetIterator * self;
	self = VALA_HASH_SET_ITERATOR (obj);
	_vala_iterable_unref0 (self->priv->_set);
	VALA_ITERATOR_CLASS (vala_hash_set_iterator_parent_class)->finalize (obj);
}


static GType vala_hash_set_iterator_get_type (void) {
	static volatile gsize vala_hash_set_iterator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_hash_set_iterator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaHashSetIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_hash_set_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaHashSetIterator), 0, (GInstanceInitFunc) vala_hash_set_iterator_instance_init, NULL };
		GType vala_hash_set_iterator_type_id;
		vala_hash_set_iterator_type_id = g_type_register_static (VALA_TYPE_ITERATOR, "ValaHashSetIterator", &g_define_type_info, 0);
		g_once_init_leave (&vala_hash_set_iterator_type_id__volatile, vala_hash_set_iterator_type_id);
	}
	return vala_hash_set_iterator_type_id__volatile;
}


static void vala_hash_set_class_init (ValaHashSetClass * klass) {
	vala_hash_set_parent_class = g_type_class_peek_parent (klass);
	VALA_ITERABLE_CLASS (klass)->finalize = vala_hash_set_finalize;
	g_type_class_add_private (klass, sizeof (ValaHashSetPrivate));
	VALA_COLLECTION_CLASS (klass)->contains = vala_hash_set_real_contains;
	VALA_ITERABLE_CLASS (klass)->get_element_type = vala_hash_set_real_get_element_type;
	VALA_ITERABLE_CLASS (klass)->iterator = vala_hash_set_real_iterator;
	VALA_COLLECTION_CLASS (klass)->add = vala_hash_set_real_add;
	VALA_COLLECTION_CLASS (klass)->remove = vala_hash_set_real_remove;
	VALA_COLLECTION_CLASS (klass)->clear = vala_hash_set_real_clear;
	VALA_COLLECTION_CLASS (klass)->get_size = vala_hash_set_real_get_size;
}


static void vala_hash_set_instance_init (ValaHashSet * self) {
	self->priv = VALA_HASH_SET_GET_PRIVATE (self);
	self->priv->_stamp = 0;
}


static void vala_hash_set_finalize (ValaIterable* obj) {
	ValaHashSet * self;
	self = VALA_HASH_SET (obj);
	vala_collection_clear ((ValaCollection*) self);
	self->priv->_nodes = (_vala_array_free (self->priv->_nodes, self->priv->_nodes_length1, (GDestroyNotify) vala_hash_set_node_free), NULL);
	VALA_ITERABLE_CLASS (vala_hash_set_parent_class)->finalize (obj);
}


/**
 * Hashtable implementation of the Set interface.
 */
GType vala_hash_set_get_type (void) {
	static volatile gsize vala_hash_set_type_id__volatile = 0;
	if (g_once_init_enter (&vala_hash_set_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaHashSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_hash_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaHashSet), 0, (GInstanceInitFunc) vala_hash_set_instance_init, NULL };
		GType vala_hash_set_type_id;
		vala_hash_set_type_id = g_type_register_static (VALA_TYPE_SET, "ValaHashSet", &g_define_type_info, 0);
		g_once_init_leave (&vala_hash_set_type_id__volatile, vala_hash_set_type_id);
	}
	return vala_hash_set_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



