// ==UserScript==
// @include       http://*.mail.yahoo.com/*
// @include       https://*.mail.yahoo.com/*
// @require       utils.js
// ==/UserScript==

window.Unity = external.getUnityObject(1);

function isCorrectPage() {
    var i, ids = ['inbox-count', 'Inbox'];

    for (i = 0; i < ids.length; i++) {
        if (!document.getElementById(ids[i])) {
            return false;
        }
    }

    return true;
}

function messagingIndicatorSetup() {
    var container = document.getElementById('Inbox');
    var checkMessangesCount = wrapCallback(function () {
        Unity.MessagingIndicator.clearIndicators();

        var i, count = document.getElementById('inbox-count').textContent;

        if (!count.length) {
            count = '0';
        }

        function activateNode() {
            launchClickEvent(this);
        }
        Unity.MessagingIndicator.showIndicator(_("Inbox"), { count: count,
                                                             callback: activateNode.bind(container) });

        var snapshot = document.evaluate('//ul[@id="custom-folders"]/li/a',
                                         document, null, XPathResult.UNORDERED_NODE_SNAPSHOT_TYPE, null);
        for (i = 0; i < snapshot.snapshotLength; i++) {
            var node = snapshot.snapshotItem(i);
            count = '0';
            if (node.lastChild.textContent.length) {
                count = node.lastChild.textContent;
            }

            if (node.firstChild.textContent.length) {
                Unity.MessagingIndicator.showIndicator(node.firstChild.textContent, { callback: activateNode.bind(node.parentNode),
                                                                                      count: count });
            }
        }
    });

    container.addEventListener('DOMSubtreeModified', checkMessangesCount, false);
    document.getElementById('custom-folders').addEventListener('DOMSubtreeModified', checkMessangesCount, false);

    checkMessangesCount();

    function composeNewMessage() {
        var compose = document.getElementById('main-btn-new').firstChild;

        launchClickEvent(compose);
    }
    Unity.MessagingIndicator.addAction(_("Compose New Message"),
                                       wrapCallback(composeNewMessage));
}

if (isCorrectPage()) {
    Unity.init({ name: 'Yahoo Mail',
                 domain: 'mail.yahoo.com',
		 homepage: 'https://mail.yahoo.com',
                 iconUrl: "icon://unity-webapps-yahoo-mail",
                 onInit: wrapCallback(messagingIndicatorSetup) });

}
