#!/usr/bin/python

import json
import optparse
import os
import polib
import re
import string
import urllib2
import sys

parser = optparse.OptionParser(usage="usage: %prog podir")

(options, args) = parser.parse_args()

if args == None or len(args) != 1:
	print("ERROR: not enough arguments");
	sys.exit(1)

podir = args[0]
result = {}
for root, dirs, files in os.walk(podir, topdown=False):
        for name in files:
                if re.search('\.po$', name) == None:
                        continue

                t = {}
                po = polib.pofile(os.path.join(root, name), autodetect_encoding=False, encoding="utf-8", wrapwidth=-1)
                for entry in po:
                        if entry.obsolete or entry.msgstr == '' or entry.msgstr == entry.msgid:
                                continue

                        t[entry.msgid] = entry.msgstr;
                match = re.search('^[^.]+', name)
                lang = match.string[match.start():match.end()]
                result[lang] = t

print urllib2.quote(json.dumps(result, sort_keys = True));
