/*
 * Decompiled with CFR 0.152.
 */
package writer2latex.util;

import java.util.Enumeration;
import java.util.Hashtable;
import writer2latex.util.Misc;
import writer2latex.util.SimpleInputBuffer;

public class ExportNameCollection {
    private Hashtable exportNames = new Hashtable();
    private String sPrefix;
    private boolean bAcceptNumbers;

    public ExportNameCollection(String sPrefix, boolean b) {
        this.sPrefix = sPrefix;
        this.bAcceptNumbers = b;
    }

    public ExportNameCollection(boolean b) {
        this("", b);
    }

    public Enumeration keys() {
        return this.exportNames.keys();
    }

    /*
     * WARNING - void declaration
     */
    public void addName(String sName) {
        char c;
        if (this.containsName(sName)) {
            return;
        }
        StringBuffer outbuf = new StringBuffer();
        SimpleInputBuffer inbuf = new SimpleInputBuffer(sName);
        if (this.bAcceptNumbers && inbuf.peekChar() >= '0' && inbuf.peekChar() <= '9') {
            outbuf.append('a');
        }
        while ((c = inbuf.peekChar()) != '\u0000') {
            void var4_4;
            if (var4_4 >= 97 && var4_4 <= 122 || var4_4 >= 65 && var4_4 <= 90) {
                outbuf.append(inbuf.getChar());
                continue;
            }
            if (var4_4 >= 48 && var4_4 <= 57) {
                if (this.bAcceptNumbers) {
                    outbuf.append(inbuf.getInteger());
                    continue;
                }
                outbuf.append(Misc.int2roman(Integer.parseInt(inbuf.getInteger())));
                continue;
            }
            inbuf.getChar();
        }
        String sExportName = outbuf.toString();
        while (this.exportNames.containsValue(sExportName)) {
            sExportName = sExportName + "a";
        }
        this.exportNames.put(sName, sExportName);
    }

    public String getExportName(String sName) {
        if (!this.containsName(sName)) {
            this.addName(sName);
        }
        return this.sPrefix + (String)this.exportNames.get(sName);
    }

    public boolean containsName(String sName) {
        return this.exportNames.containsKey(sName);
    }

    public boolean isEmpty() {
        return this.exportNames.size() == 0;
    }
}

