/* $Id: manager-plugin.h.in 21184 2006-04-23 17:11:27Z benny $ */
/*-
 * Copyright (c) 2002 Jasper Huijsmans <jasper@xfce.org>
 * Copyright (c) 2006 Benedikt Meurer <benny@xfce.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef MANAGER_PLUGIN_H
#define MANAGER_PLUGIN_H

#include <gtk/gtk.h>
#include <gmodule.h>
#include <libxfce4mcs/mcs-manager.h>

G_BEGIN_DECLS;

/* Xfce4 mcs plugin API version */
#define XFCE_MCS_PLUGIN_VERSION	2

#define SETTINGS_MANAGER_ICON_SIZE 48

typedef struct _McsPlugin McsPlugin;

typedef enum
{
  MCS_PLUGIN_INIT_OK,
  MCS_PLUGIN_INIT_ERROR
} McsPluginInitResult;

typedef void (*run_dialog_hook) (McsPlugin *plugin);

struct _McsPlugin
{
  /* the manager object */
  McsManager     *manager;

  /* the name of the plugin */
  gchar          *plugin_name;

  /* the icon for the plugin */
  GdkPixbuf      *icon;

  /* the caption of the plugin */
  gchar          *caption;

  /* callback function to show the dialog */
  run_dialog_hook run_dialog;
};

gchar *mcs_plugin_check_version (gint version);

#define MCS_PLUGIN_CHECK_INIT                                         \
G_MODULE_EXPORT const gchar *g_module_check_init (GModule *gmodule);  \
const gchar*                                                          \
g_module_check_init(GModule *gmodule)                                 \
{                                                                     \
  return mcs_plugin_check_version (XFCE_MCS_PLUGIN_VERSION);          \
}

/* prototype for plugin init function (should be implemented by plugin) */
G_MODULE_EXPORT McsPluginInitResult mcs_plugin_init (McsPlugin *plugin);

G_END_DECLS;

#endif /* !MANAGER_PLUGIN_H */
