/*
* Copyright (C) 2012 Canonical Ltd
*
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License version 3 as
* published by the Free Software Foundation.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*
*/

#ifndef _NODE_H
#define _NODE_H

#include <string>
#include <vector>
#include <memory>

namespace xpathselect
{
    /// Represents a node in the object tree. Provide an implementation of
    /// this class in your own code.
    class Node
    {
    public:
        typedef std::shared_ptr<Node> Ptr;

        /// Get the node's name.
        virtual std::string GetName() const =0;

        /// Get the node's full path
        virtual std::string GetPath() const =0;

        /// Return true if the node matches the property with the given name & value
        ///\note: All property values are treated as strings. It is the implementors
        /// responsibility to convert the value to the appropriate type.
        virtual bool MatchProperty(const std::string& name, const std::string& value) const =0;

        /// Return a list of the children of this node.
        virtual std::vector<Node::Ptr> Children() const =0;
    };

    /// NodeList is how we return lists of nodes.
    typedef std::vector<Node::Ptr> NodeList;
}

#endif
