#ifndef INCLUDED_DEFINES_H
#define INCLUDED_DEFINES_H

/*
 * Copyright (c) 1997 Ben Harrison, James E. Wilson, Robert A. Koeneke
 *
 * This software may be copied and distributed for educational, research,
 * and not for profit purposes provided that this copyright and statement
 * are included in all such copies.  Other copyrights may also apply.
 */


/*
 * Do not edit this file unless you know *exactly* what you are doing.
 *
 * Some of the values in this file were chosen to preserve game balance,
 * while others are hard-coded based on the format of old save-files, the
 * definition of arrays in various places, mathematical properties, fast
 * computation, storage limits, or the format of external text files.
 *
 * Changing some of these values will induce crashes or memory errors or
 * savefile mis-reads.  Most of the comments in this file are meant as
 * reminders, not complete descriptions, and even a complete knowledge
 * of the source may not be sufficient to fully understand the effects
 * of changing certain definitions.
 *
 * Lastly, note that the code does not always use the symbolic constants
 * below, and sometimes uses various hard-coded values that may not even
 * be defined in this file, but which may be related to definitions here.
 * This is of course bad programming practice, but nobody is perfect...
 *
 * You have been warned.
 */


/*
 * Name of the version/variant and its version string
 */
#define VERSION_NAME   "Angband"
#define SAVEFILE_NAME  "VNLA"

#ifdef BUILD_ID
# define VERSION_STRING "3.1.1 dev (" BUILD_ID ")"
#else
# define VERSION_STRING "3.1.1 dev"
#endif


/*
 * Current savefile version
 */
#define VERSION_MAJOR	3
#define VERSION_MINOR	0
#define VERSION_PATCH	14
#define VERSION_EXTRA	0

/*
 * Oldest version number that can still be imported
 */
#define OLD_VERSION_MAJOR	3
#define OLD_VERSION_MINOR	0
#define OLD_VERSION_PATCH	14


/*
 * Version of random artifact code.
 */
#define RANDART_VERSION	63


/*
 * Number of grids in each block (vertically)
 * Probably hard-coded to 11, see "generate.c"
 */
#define BLOCK_HGT	11

/*
 * Number of grids in each block (horizontally)
 * Probably hard-coded to 11, see "generate.c"
 */
#define BLOCK_WID	11


/*
 * Number of grids in each panel (vertically)
 * Must be a multiple of BLOCK_HGT
 */
#define PANEL_HGT	11

/*
 * Number of grids in each panel (horizontally)
 * Must be a multiple of BLOCK_WID
 */
#define PANEL_WID	(use_bigtile ? 16 : 33)

#define ROW_MAP			1
#define COL_MAP			13


/*
 * Number of grids in each screen (vertically)
 * Must be a multiple of PANEL_HGT (at least 2x)
 */
#define SCREEN_HGT	(Term->hgt - ROW_MAP - 1)

/*
 * Number of grids in each screen (horizontally)
 * Must be a multiple of PANEL_WID (at least 2x)
 */
#define SCREEN_WID	((Term->wid - COL_MAP - 1) / (use_bigtile ? 2 : 1))


/*
 * Number of grids in each dungeon (vertically)
 * Must be a multiple of SCREEN_HGT
 * Must be less or equal to 256
 */
#define DUNGEON_HGT		66

/*
 * Number of grids in each dungeon (horizontally)
 * Must be a multiple of SCREEN_WID
 * Must be less or equal to 256
 */
#define DUNGEON_WID		198

#define TOWN_WID 66
#define TOWN_HGT 22


/*
 * Maximum amount of Angband windows.
 */
#define ANGBAND_TERM_MAX 8


/* XXX Should be enums */

/*
 * Total number of stores (see "store.c", etc)
 */
#define MAX_STORES	8


/*
 * Store index definitions (see "store.c", etc)
 */
#define STORE_GENERAL	0
#define STORE_ARMOR		1
#define STORE_WEAPON	2
#define STORE_TEMPLE	3
#define STORE_ALCHEMY	4
#define STORE_MAGIC		5
#define STORE_B_MARKET	6
#define STORE_HOME		7

/*
 * Maximum number of player "sex" types (see "table.c", etc)
 */
#define MAX_SEXES            2


/*
 * Maximum amount of starting equipment
 */
#define MAX_START_ITEMS	5


/*
 * Number of tval/min-sval/max-sval slots per ego_item
 */
#define EGO_TVALS_MAX 3


/*
 * Hack -- Maximum number of quests
 */
#define MAX_Q_IDX	4

/*
 * Maximum number of high scores in the high score file
 */
#define MAX_HISCORES	100


/*
 * Maximum dungeon level.  The player can never reach this level
 * in the dungeon, and this value is used for various calculations
 * involving object and monster creation.  It must be at least 100.
 * Setting it below 128 may prevent the creation of some objects.
 */
#define MAX_DEPTH	128


/*
 * Maximum size of the "view" array (see "cave.c")
 * Note that the "view radius" will NEVER exceed 20, and even if the "view"
 * was octagonal, we would never require more than 1520 entries in the array.
 */
#define VIEW_MAX 1536

/*
 * Maximum size of the "temp" array (see "cave.c")
 * Note that we must be as large as "VIEW_MAX" for proper functioning
 * of the "update_view()" function, and we must also be as large as the
 * largest illuminatable room, but no room is larger than 800 grids.  We
 * must also be large enough to allow "good enough" use as a circular queue,
 * to calculate monster flow, but note that the flow code is "paranoid".
 */
#define TEMP_MAX 1536


/*
 * OPTION: Maximum number of macros (see "util.c")
 */
#define MACRO_MAX	512

/*
 * OPTION: Maximum number of autoinscriptions(see "object1.c")
 */
#define AUTOINSCRIPTIONS_MAX 216

/* History message types */
#define HISTORY_PLAYER_BIRTH     0x0001	/* Player was born */
#define HISTORY_ARTIFACT_UNKNOWN 0x0002	/* Player found but not IDd an artifact */
#define HISTORY_ARTIFACT_KNOWN   0x0004	/* Player has IDed an artifact */
#define HISTORY_ARTIFACT_LOST    0x0008	/* Player had an artifact and lost it */
#define HISTORY_PLAYER_DEATH     0x0010	/* Player has been slain */
#define HISTORY_SLAY_UNIQUE      0x0020	/* Player has slain a unique monster */
#define HISTORY_USER_INPUT       0x0040	/* User-added note */
#define HISTORY_SAVEFILE_IMPORT  0x0080	/* Added when an older version savefile is imported */
#define HISTORY_GAIN_LEVEL       0x0100	/* Player gained a level */
#define HISTORY_GENERIC          0x0200	/* Anything else not covered here (unused) */


/*
 * Store constants
 *
 * STORE_MAX_KEEP must be < STORE_INVEN_MAX.
 */
#define STORE_INVEN_MAX	24		/* Max number of discrete objs in inven */
#define STORE_TURNS		1000	/* Number of turns between turnovers */
#define STORE_SHUFFLE	25		/* 1/Chance (per day) of an owner changing */


/*
 * Misc constants
 */
#define TOWN_DAWN		10000	/* Number of turns from dawn to dawn XXX */
#define BREAK_GLYPH		550		/* Rune of protection resistance */
#define BTH_PLUS_ADJ    3       /* Adjust BTH per plus-to-hit */
#define MON_MULT_ADJ	8		/* High value slows multiplication */
#define MON_DRAIN_LIFE	2		/* Percent of player exp drained per hit */
#define USE_DEVICE      3		/* x> Harder devices x< Easier devices */

/*
 * There is a 1/20 (5%) chance of inflating the requested object level
 * during the creation of an object (see "get_obj_num()" in "object.c").
 * Lower values yield better objects more often.
 */
#define GREAT_OBJ	20

/*
 * There is a 1/20 (5%) chance that ego-items with an inflated base-level are
 * generated when an object is turned into an ego-item (see make_ego_item()
 * in object2.c). As above, lower values yield better ego-items more often.
 */
#define GREAT_EGO	20

/*
 * There is a 1/50 (2%) chance of inflating the requested monster level
 * during the creation of a monsters (see "get_mon_num()" in "monster.c").
 * Lower values yield harder monsters more often.
 */
#define NASTY_MON	50		/* 1/chance of inflated monster level */



/*
 * Refueling constants
 */
#define FUEL_TORCH	5000	/* Maximum amount of fuel in a torch */
#define FUEL_LAMP	15000   /* Maximum amount of fuel in a lantern */


/*
 * More maximum values
 */
#define MAX_SIGHT	20	/* Maximum view distance */
#define MAX_RANGE	18	/* Maximum range (spells, etc) */



/*
 * There is a 1/160 chance per round of creating a new monster
 */
#define MAX_M_ALLOC_CHANCE	160

/*
 * Normal levels get at least 14 monsters
 */
#define MIN_M_ALLOC_LEVEL	14

/*
 * The town starts out with 4 residents during the day
 */
#define MIN_M_ALLOC_TD		4

/*
 * The town starts out with 8 residents during the night
 */
#define MIN_M_ALLOC_TN		8


/*
 * A monster can only "multiply" (reproduce) if there are fewer than 100
 * monsters on the level capable of such spontaneous reproduction.  This
 * is a hack which prevents the "mon_list[]" array from exploding due to
 * reproducing monsters.  Messy, but necessary.
 */
#define MAX_REPRO	100


/*
 * Player constants
 */
#define PY_MAX_EXP	99999999L	/* Maximum exp */
#define PY_MAX_GOLD	999999999L	/* Maximum gold */
#define PY_MAX_LEVEL	50		/* Maximum level */

/*
 * Player "food" crucial values
 */
#define PY_FOOD_UPPER   20000   /* Upper limit on food counter */
#define PY_FOOD_MAX		15000	/* Food value (Bloated) */
#define PY_FOOD_FULL	10000	/* Food value (Normal) */
#define PY_FOOD_ALERT	2000	/* Food value (Hungry) */
#define PY_FOOD_WEAK	1000	/* Food value (Weak) */
#define PY_FOOD_FAINT	500		/* Food value (Fainting) */
#define PY_FOOD_STARVE	100		/* Food value (Starving) */

/*
 * Player regeneration constants
 */
#define PY_REGEN_NORMAL		197		/* Regen factor*2^16 when full */
#define PY_REGEN_WEAK		98		/* Regen factor*2^16 when weak */
#define PY_REGEN_FAINT		33		/* Regen factor*2^16 when fainting */
#define PY_REGEN_HPBASE		1442	/* Min amount hp regen*2^16 */
#define PY_REGEN_MNBASE		524		/* Min amount mana regen*2^16 */


/*
 * Maximum number of players spells
 */
#define PY_MAX_SPELLS 64

/*
 * Number of spells per book
 */
#define SPELLS_PER_BOOK 9

/*
 * Maximum number of spells per realm
 */
#define BOOKS_PER_REALM 9

/*
 * Maximum number realms
 */
#define MAX_REALMS 2


/*
 * Flags for player_type.spell_flags[]
 */
#define PY_SPELL_LEARNED    0x01 /* Spell has been learned */
#define PY_SPELL_WORKED     0x02 /* Spell has been successfully tried */
#define PY_SPELL_FORGOTTEN  0x04 /* Spell has been forgotten */


/*
 * Maximum number of "normal" pack slots, and the index of the "overflow"
 * slot, which can hold an item, but only temporarily, since it causes the
 * pack to "overflow", dropping the "last" item onto the ground.  Since this
 * value is used as an actual slot, it must be less than "INVEN_WIELD" (below).
 * Note that "INVEN_PACK" is probably hard-coded by its use in savefiles, and
 * by the fact that the screen can only show 23 items plus a one-line prompt.
 */
#define INVEN_PACK		23

/*
 * Indexes used for various "equipment" slots (hard-coded by savefiles, etc).
 */
#define INVEN_WIELD		24
#define INVEN_BOW       25
#define INVEN_LEFT      26
#define INVEN_RIGHT     27
#define INVEN_NECK      28
#define INVEN_LITE      29
#define INVEN_BODY      30
#define INVEN_OUTER     31
#define INVEN_ARM       32
#define INVEN_HEAD      33
#define INVEN_HANDS     34
#define INVEN_FEET      35

/*
 * Total number of inventory slots (hard-coded).
 */
#define INVEN_TOTAL		36


/*
 * Special return code corresponding to squelched items.
 */
#define ALL_SQUELCHED	101


/*
 * A "stack" of items is limited to less than 100 items (hard-coded).
 */
#define MAX_STACK_SIZE 100


/*
 * An item's pval (for charges, amount of gold, etc) is limited to s16b
 */
#define MAX_PVAL  32767
#define MIN_PVAL -32768


/*
 * Maximum number of objects allowed in a single dungeon grid.
 *
 * The main-screen has a minimum size of 24 rows, so we can always
 * display 23 objects + 1 header line.
 */
#define MAX_FLOOR_STACK			23


/*** Constants for accessing the player struct ***/

/*
 * Timed effects
 */
enum
{
	TMD_FAST = 0, TMD_SLOW, TMD_BLIND, TMD_PARALYZED, TMD_CONFUSED,
	TMD_AFRAID, TMD_IMAGE, TMD_POISONED, TMD_CUT, TMD_STUN, TMD_PROTEVIL,
	TMD_INVULN, TMD_HERO, TMD_SHERO, TMD_SHIELD, TMD_BLESSED, TMD_SINVIS,
	TMD_SINFRA, TMD_OPP_ACID, TMD_OPP_ELEC, TMD_OPP_FIRE, TMD_OPP_COLD,
	TMD_OPP_POIS, TMD_OPP_CONF, TMD_AMNESIA, TMD_TELEPATHY, TMD_STONESKIN,
	TMD_TERROR, TMD_SPRINT,

	TMD_MAX
};

/*
 * Skill indexes
 */
enum
{
	SKILL_DISARM,			/* Skill: Disarming */
	SKILL_DEVICE,			/* Skill: Magic Devices */
	SKILL_SAVE,				/* Skill: Saving throw */
	SKILL_STEALTH,			/* Skill: Stealth factor */
	SKILL_SEARCH,			/* Skill: Searching ability */
	SKILL_SEARCH_FREQUENCY,	/* Skill: Searching frequency */
	SKILL_TO_HIT_MELEE,		/* Skill: To hit (normal) */
	SKILL_TO_HIT_BOW,		/* Skill: To hit (shooting) */
	SKILL_TO_HIT_THROW,		/* Skill: To hit (throwing) */
	SKILL_DIGGING,			/* Skill: Digging */

	SKILL_MAX
};


/*
 * Indexes of the various "stats" (hard-coded by savefiles, etc).
 */
enum
{
	A_STR = 0,
	A_INT,
	A_WIS,
	A_DEX,
	A_CON,
	A_CHR,

	A_MAX
};


/*
 * Player sex constants (hard-coded by save-files, arrays, etc)
 */
#define SEX_FEMALE		0
#define SEX_MALE		1



/*** General index values ***/


/*
 * Legal restrictions for "summon_specific()"
 */
#define SUMMON_ANIMAL       11
#define SUMMON_SPIDER       12
#define SUMMON_HOUND        13
#define SUMMON_HYDRA        14
#define SUMMON_ANGEL        15
#define SUMMON_DEMON        16
#define SUMMON_UNDEAD       17
#define SUMMON_DRAGON       18
/* xxx */
#define SUMMON_HI_DEMON     26
#define SUMMON_HI_UNDEAD    27
#define SUMMON_HI_DRAGON    28
/* xxx */
#define SUMMON_WRAITH       31
#define SUMMON_UNIQUE       32
#define SUMMON_KIN          33
/* xxx */
#define SUMMON_MONSTER      41
#define SUMMON_MONSTERS     42


/*
 * Spell types used by project(), and related functions.
 */
#define GF_XXX1			1
#define GF_ARROW        2
#define GF_MISSILE      3
#define GF_MANA         4
#define GF_HOLY_ORB     5
#define GF_LITE_WEAK	6
#define GF_DARK_WEAK	7
#define GF_WATER        8
#define GF_PLASMA       9
#define GF_METEOR       10
#define GF_ICE          11
#define GF_GRAVITY      12
#define GF_INERTIA      13
#define GF_FORCE        14
#define GF_TIME         15
#define GF_ACID         16
#define GF_ELEC         17
#define GF_FIRE         18
#define GF_COLD         19
#define GF_POIS         20
#define GF_XXX2			21
#define GF_LITE         22
#define GF_DARK         23
#define GF_XXX3			24
#define GF_CONFUSION    25
#define GF_SOUND        26
#define GF_SHARD        27
#define GF_NEXUS        28
#define GF_NETHER       29
#define GF_CHAOS        30
#define GF_DISENCHANT   31
#define GF_XXX4			32
#define GF_KILL_WALL	33
#define GF_KILL_DOOR	34
#define GF_KILL_TRAP	35
#define GF_MAKE_WALL	36
#define GF_MAKE_DOOR	37
#define GF_MAKE_TRAP	38
#define GF_XXX5			39
#define GF_XXX6			40
#define GF_AWAY_UNDEAD	41
#define GF_AWAY_EVIL	42
#define GF_AWAY_ALL		43
#define GF_TURN_UNDEAD	44
#define GF_TURN_EVIL	45
#define GF_TURN_ALL		46
#define GF_DISP_UNDEAD	47
#define GF_DISP_EVIL	48
#define GF_DISP_ALL		49
#define GF_XXX7			50
#define GF_OLD_CLONE	51
#define GF_OLD_POLY		52
#define GF_OLD_HEAL		53
#define GF_OLD_SPEED	54
#define GF_OLD_SLOW		55
#define GF_OLD_CONF		56
#define GF_OLD_SLEEP	57
#define GF_OLD_DRAIN	58
#define GF_XXX8			59


/*
 * Some constants for the "learn" code
 *
 * Most of these come from the "SM_xxx" flags
 */
#define DRS_FREE		14
#define DRS_MANA		15
#define DRS_RES_ACID	16
#define DRS_RES_ELEC	17
#define DRS_RES_FIRE	18
#define DRS_RES_COLD	19
#define DRS_RES_POIS	20
#define DRS_RES_FEAR	21
#define DRS_RES_LITE	22
#define DRS_RES_DARK	23
#define DRS_RES_BLIND	24
#define DRS_RES_CONFU	25
#define DRS_RES_SOUND	26
#define DRS_RES_SHARD	27
#define DRS_RES_NEXUS	28
#define DRS_RES_NETHR	29
#define DRS_RES_CHAOS	30
#define DRS_RES_DISEN	31


/*
 * Keymap modes.
 */
enum
{
	KEYMAP_MODE_ORIG = 0,
	KEYMAP_MODE_ROGUE,

	KEYMAP_MODES		/* Total */
};



/*** Feature Indexes (see "lib/edit/terrain.txt") ***/

/* Nothing */
#define FEAT_NONE		0x00

/* Various */
#define FEAT_FLOOR		0x01
#define FEAT_INVIS		0x02
#define FEAT_GLYPH		0x03
#define FEAT_OPEN		0x04
#define FEAT_BROKEN		0x05
#define FEAT_LESS		0x06
#define FEAT_MORE		0x07

/* Shops */
#define FEAT_SHOP_HEAD	0x08
#define FEAT_SHOP_TAIL	0x0F

/* Traps */
#define FEAT_TRAP_HEAD	0x10
#define FEAT_TRAP_TAIL	0x1F

/* Doors */
#define FEAT_DOOR_HEAD	0x20
#define FEAT_DOOR_TAIL	0x2F

/* Extra */
#define FEAT_SECRET		0x30
#define FEAT_RUBBLE		0x31

/* Seams */
#define FEAT_MAGMA		0x32
#define FEAT_QUARTZ		0x33
#define FEAT_MAGMA_H	0x34
#define FEAT_QUARTZ_H	0x35
#define FEAT_MAGMA_K	0x36
#define FEAT_QUARTZ_K	0x37

/* Walls */
#define FEAT_WALL_EXTRA	0x38
#define FEAT_WALL_INNER	0x39
#define FEAT_WALL_OUTER	0x3A
#define FEAT_WALL_SOLID	0x3B
#define FEAT_PERM_EXTRA	0x3C
#define FEAT_PERM_INNER	0x3D
#define FEAT_PERM_OUTER	0x3E
#define FEAT_PERM_SOLID	0x3F



/*** Object origin kinds ***/

enum
{
	ORIGIN_NONE = 0,
	ORIGIN_MIXED,
	ORIGIN_BIRTH,
	ORIGIN_STORE,
	ORIGIN_FLOOR,
	ORIGIN_DROP,
	ORIGIN_DROP_UNKNOWN,
	ORIGIN_ACQUIRE,
	ORIGIN_CHEAT,
	ORIGIN_CHEST
};



/*** Important artifact indexes (see "lib/edit/artifact.txt") ***/

#define ART_POWER			13
#define ART_MORGOTH			34
#define ART_GROND			111
#define ART_PALANTIR			7

/*
 * Hack -- first "normal" artifact in the artifact list.  All of
 * the artifacts with indexes from 1 to 15 are "special" (lights,
 * rings, amulets), and the ones from 16 to 127 are "normal".
 */
#define ART_MIN_NORMAL		16



/*** Ego-Item indexes (see "lib/edit/ego_item.txt") ***/


/* Nothing */
/* xxx */
/* xxx */
/* xxx */

/* Body Armor */
#define EGO_RESIST_ACID		4
#define EGO_RESIST_ELEC		5
#define EGO_RESIST_FIRE		6
#define EGO_RESIST_COLD		7
#define EGO_RESISTANCE		8
#define EGO_ELVENKIND		9
#define EGO_ARMR_VULN		10
#define EGO_PERMANENCE		11
#define EGO_ARMR_DWARVEN	12
/* xxx */
/* xxx */
/* xxx */

/* Shields */
#define EGO_ENDURE_ACID		16
#define EGO_ENDURE_ELEC		17
#define EGO_ENDURE_FIRE		18
#define EGO_ENDURE_COLD		19
#define EGO_ENDURANCE		20
#define EGO_SHIELD_ELVENKIND	21
#define EGO_SHIELD_PRESERVATION	22
#define EGO_SHIELD_VULN		23

/* Crowns and Helms */
#define EGO_INTELLIGENCE	24
#define EGO_WISDOM			25
#define EGO_BEAUTY			26
#define EGO_MAGI			27
#define EGO_MIGHT			28
#define EGO_LORDLINESS		29
#define EGO_SEEING			30
#define EGO_INFRAVISION		31
#define EGO_LITE			32
#define EGO_TELEPATHY		33
#define EGO_REGENERATION	34
#define EGO_TELEPORTATION	35
#define EGO_STUPIDITY		36
#define EGO_NAIVETY			37
#define EGO_UGLINESS		38
#define EGO_SICKLINESS		39

/* Cloaks */
#define EGO_PROTECTION		40
#define EGO_STEALTH			41
#define EGO_AMAN			42
#define EGO_CLOAK_MAGI		43
#define EGO_ENVELOPING		44
#define EGO_VULNERABILITY	45
#define EGO_IRRITATION		46
/* xxx */

/* Gloves */
#define EGO_FREE_ACTION		48
#define EGO_SLAYING			49
#define EGO_AGILITY			50
#define EGO_POWER			51
#define EGO_GLOVES_THIEVERY	52
#define EGO_GAUNTLETS_COMBAT	53
#define EGO_WEAKNESS		54
#define EGO_CLUMSINESS		55

/* Boots */
#define EGO_SLOW_DESCENT	56
#define EGO_QUIET			57
#define EGO_MOTION			58
#define EGO_SPEED			59
#define EGO_STABILITY		60
#define EGO_NOISE			61
#define EGO_SLOWNESS		62
#define EGO_ANNOYANCE		63

/* Weapons */
#define EGO_HA				64
#define EGO_DF				65
#define EGO_BLESS_BLADE		66
#define EGO_GONDOLIN		67
#define EGO_WEST			68
#define EGO_ATTACKS			69
#define EGO_FURY			70
/* xxx */
#define EGO_BRAND_ACID		72
#define EGO_BRAND_ELEC		73
#define EGO_BRAND_FIRE		74
#define EGO_BRAND_COLD		75
#define EGO_BRAND_POIS		76
/* xxx */
/* xxx */
/* xxx */
#define EGO_SLAY_ANIMAL		80
#define EGO_SLAY_EVIL		81
#define EGO_SLAY_UNDEAD		82
#define EGO_SLAY_DEMON		83
#define EGO_SLAY_ORC		84
#define EGO_SLAY_TROLL		85
#define EGO_SLAY_GIANT		86
#define EGO_SLAY_DRAGON		87
#define EGO_KILL_ANIMAL		88
#define EGO_KILL_EVIL		89
#define EGO_KILL_UNDEAD		90
#define EGO_KILL_DEMON		83
#define EGO_KILL_ORC		84
#define EGO_KILL_TROLL		85
#define EGO_KILL_GIANT		86
#define EGO_KILL_DRAGON		95
/* xxx */
/* xxx */
/* xxx */
/* xxx */
#define EGO_DIGGING			100
#define EGO_DIGGER_EARTHQUAKE		101
#define EGO_MORGUL			102
/* xxx */

/* Bows */
#define EGO_ACCURACY		104
#define EGO_VELOCITY		105
#define EGO_BOW_LORIEN		106
#define EGO_CROSSBOW_HARAD	107
#define EGO_EXTRA_MIGHT		108
#define EGO_EXTRA_SHOTS		109
#define EGO_SLING_BUCKLAND	110
#define EGO_NAZGUL			111

/* Ammo */
#define EGO_HURT_ANIMAL		112
#define EGO_HURT_EVIL		113
#define EGO_HURT_UNDEAD		114
#define EGO_HURT_DEMON		115
#define EGO_HURT_ORC		116
#define EGO_HURT_TROLL		117
#define EGO_HURT_GIANT		118
#define EGO_HURT_DRAGON		119
#define EGO_AMMO_HOLY		120
#define EGO_AMMO_VENOM		121
#define EGO_FLAME			122
#define EGO_FROST			123
#define EGO_WOUNDING		124
#define EGO_BACKBITING		125
#define EGO_SHATTERED		126
#define EGO_BLASTED			127





/*** Monster AI stuff ***/

/*
 * Maximum flow depth when using "MONSTER_FLOW"
 */
#define MONSTER_FLOW_DEPTH 32



/*** Monster blow constants ***/


#define MONSTER_BLOW_MAX 4

/*
 * New monster blow methods
 */
#define RBM_HIT		1
#define RBM_TOUCH	2
#define RBM_PUNCH	3
#define RBM_KICK	4
#define RBM_CLAW	5
#define RBM_BITE	6
#define RBM_STING	7
#define RBM_XXX1	8
#define RBM_BUTT	9
#define RBM_CRUSH	10
#define RBM_ENGULF	11
#define RBM_XXX2	12
#define RBM_CRAWL	13
#define RBM_DROOL	14
#define RBM_SPIT	15
#define RBM_XXX3	16
#define RBM_GAZE	17
#define RBM_WAIL	18
#define RBM_SPORE	19
#define RBM_XXX4	20
#define RBM_BEG		21
#define RBM_INSULT	22
#define RBM_MOAN	23
#define RBM_XXX5	24


/*
 * New monster blow effects
 */
#define RBE_HURT		1
#define RBE_POISON		2
#define RBE_UN_BONUS	3
#define RBE_UN_POWER	4
#define RBE_EAT_GOLD	5
#define RBE_EAT_ITEM	6
#define RBE_EAT_FOOD	7
#define RBE_EAT_LITE	8
#define RBE_ACID		9
#define RBE_ELEC		10
#define RBE_FIRE		11
#define RBE_COLD		12
#define RBE_BLIND		13
#define RBE_CONFUSE		14
#define RBE_TERRIFY		15
#define RBE_PARALYZE	16
#define RBE_LOSE_STR	17
#define RBE_LOSE_INT	18
#define RBE_LOSE_WIS	19
#define RBE_LOSE_DEX	20
#define RBE_LOSE_CON	21
#define RBE_LOSE_CHR	22
#define RBE_LOSE_ALL	23
#define RBE_SHATTER		24
#define RBE_EXP_10		25
#define RBE_EXP_20		26
#define RBE_EXP_40		27
#define RBE_EXP_80		28
#define RBE_HALLU		29
#define RBE_MAX			RBE_HALLU


/*** Function flags ***/


/*
 * Bit flags for the "project()" function
 *
 *   NONE: No flags
 *   JUMP: Jump directly to the target location (this is a hack)
 *   BEAM: Work as a beam weapon (affect every grid passed through)
 *   THRU: Continue "through" the target (used for "bolts"/"beams")
 *   STOP: Stop as soon as we hit a monster (used for "bolts")
 *   GRID: Affect each grid in the "blast area" in some way
 *   ITEM: Affect each object in the "blast area" in some way
 *   KILL: Affect each monster in the "blast area" in some way
 *   HIDE: Hack -- disable "visual" feedback from projection
 */
#define PROJECT_NONE	0x00
#define PROJECT_JUMP	0x01
#define PROJECT_BEAM	0x02
#define PROJECT_THRU	0x04
#define PROJECT_STOP	0x08
#define PROJECT_GRID	0x10
#define PROJECT_ITEM	0x20
#define PROJECT_KILL	0x40
#define PROJECT_HIDE	0x80


/*
 * Bit flags for the "enchant()" function
 */
#define ENCH_TOHIT   0x01
#define ENCH_TODAM   0x02
#define ENCH_TOAC    0x04


/*
 * Bit flags for the "target_set" function
 *
 *	KILL: Target monsters
 *	LOOK: Describe grid fully
 *	XTRA: Currently unused flag
 *	GRID: Select from all grids
 */
#define TARGET_KILL		0x01
#define TARGET_LOOK		0x02
#define TARGET_XTRA		0x04
#define TARGET_GRID		0x08


/*
 * Bit flags for the "monster_desc" function
 */
#define MDESC_OBJE		0x01	/* Objective (or Reflexive) */
#define MDESC_POSS		0x02	/* Possessive (or Reflexive) */
#define MDESC_IND1		0x04	/* Indefinites for hidden monsters */
#define MDESC_IND2		0x08	/* Indefinites for visible monsters */
#define MDESC_PRO1		0x10	/* Pronominalize hidden monsters */
#define MDESC_PRO2		0x20	/* Pronominalize visible monsters */
#define MDESC_HIDE		0x40	/* Assume the monster is hidden */
#define MDESC_SHOW		0x80	/* Assume the monster is visible */


/*
 * Bit flags for the "get_item" function
 */
#define USE_EQUIP		0x01	/* Allow equip items */
#define USE_INVEN		0x02	/* Allow inven items */
#define USE_FLOOR		0x04	/* Allow floor items */
#define CAN_SQUELCH		0x08	/* Allow selection of all squelched items */
#define IS_HARMLESS		0x10	/* Ignore generic warning inscriptions */


/*** Player flags ***/


/*
 * Bit flags for the "p_ptr->notice" variable
 */
#define PN_COMBINE      0x00000001L	/* Combine the pack */
#define PN_REORDER      0x00000002L	/* Reorder the pack */
#define PN_AUTOINSCRIBE	0x00000004L	/* Autoinscribe items */
#define PN_PICKUP       0x00000008L	/* Pick stuff up */
#define PN_SQUELCH      0x00000010L	/* Squelch stuff */
/* xxx (many) */


/*
 * Bit flags for the "p_ptr->update" variable
 */
#define PU_BONUS		0x00000001L	/* Calculate bonuses */
#define PU_TORCH		0x00000002L	/* Calculate torch radius */
/* xxx (many) */
#define PU_HP			0x00000010L	/* Calculate chp and mhp */
#define PU_MANA			0x00000020L	/* Calculate csp and msp */
#define PU_SPELLS		0x00000040L	/* Calculate spells */
/* xxx (many) */
#define PU_FORGET_VIEW	0x00010000L	/* Forget field of view */
#define PU_UPDATE_VIEW	0x00020000L	/* Update field of view */
/* xxx (many) */
#define PU_FORGET_FLOW	0x00100000L	/* Forget flow data */
#define PU_UPDATE_FLOW	0x00200000L	/* Update flow data */
/* xxx (many) */
#define PU_MONSTERS		0x10000000L	/* Update monsters */
#define PU_DISTANCE		0x20000000L	/* Update distances */
/* xxx */
#define PU_PANEL		0x80000000L	/* Update panel */


/*
 * Bit flags for the "p_ptr->redraw" variable
 */
#define PR_MISC			0x00000001L	/* Display Race/Class */
#define PR_TITLE		0x00000002L	/* Display Title */
#define PR_LEV			0x00000004L	/* Display Level */
#define PR_EXP			0x00000008L	/* Display Experience */
#define PR_STATS		0x00000010L	/* Display Stats */
#define PR_ARMOR		0x00000020L	/* Display Armor */
#define PR_HP			0x00000040L	/* Display Hitpoints */
#define PR_MANA			0x00000080L	/* Display Mana */
#define PR_GOLD			0x00000100L	/* Display Gold */

#define PR_HEALTH		0x00000800L	/* Display Health Bar */
#define PR_SPEED		0x00001000L	/* Display Extra (Speed) */
#define PR_STUDY		0x00002000L	/* Display Extra (Study) */
#define PR_DEPTH		0x00004000L	/* Display Depth */
#define PR_STATUS		0x00008000L
#define PR_DTRAP		0x00010000L /* Trap detection indicator */
#define PR_STATE		0x00020000L	/* Display Extra (State) */
#define PR_MAP			0x00040000L	/* Redraw whole map */

#define PR_INVEN		0x00080000L /* Display inven/equip */
#define PR_EQUIP		0x00100000L /* Display equip/inven */
#define PR_MESSAGE		0x00200000L /* Display messages */
#define PR_MONSTER		0x00400000L /* Display monster recall */
#define PR_OBJECT		0x00800000L /* Display object recall */
#define PR_MONLIST		0x01000000L /* Display monster list */
#define PR_BUTTONS              0x02000000L     /* Display mouse buttons */
#define PR_ITEMLIST        0x04000000L /* Display item list */

/* Display Basic Info */
#define PR_BASIC \
	(PR_MISC | PR_TITLE | PR_STATS | PR_LEV |\
	 PR_EXP | PR_GOLD | PR_ARMOR | PR_HP |\
	 PR_MANA | PR_DEPTH | PR_HEALTH | PR_SPEED)

/* Display Extra Info */
#define PR_EXTRA \
	(PR_STATUS | PR_STATE | PR_STUDY)


/*
 * Bit flags for the "p_ptr->window" variable.
 */
#define PW_INVEN            0x00000001L /* Display inven/equip */
#define PW_EQUIP            0x00000002L /* Display equip/inven */
#define PW_PLAYER_0         0x00000004L /* Display player (basic) */
#define PW_PLAYER_1         0x00000008L /* Display player (extra) */
#define PW_PLAYER_2         0x00000010L /* Display player (compact) */
#define PW_MAP              0x00000020L /* Display dungeon map */
#define PW_MESSAGE          0x00000040L /* Display messages */
#define PW_OVERHEAD         0x00000080L /* Display overhead view */
#define PW_MONSTER          0x00000100L /* Display monster recall */
#define PW_OBJECT           0x00000200L /* Display object recall */
#define PW_MONLIST          0x00000400L /* Display monster list */
#define PW_STATUS           0x00000800L /* Display status */
#define PW_ITEMLIST         0x00001000L /* Display item list */
/* xxx */
#define PW_BORG_1           0x00004000L /* Display borg messages */
#define PW_BORG_2           0x00008000L /* Display borg status */


#define PW_MAX_FLAGS		16


/*** Cave flags ***/


/*
 * Special cave grid flags
 */
#define CAVE_MARK		0x01 	/* memorized feature */
#define CAVE_GLOW		0x02 	/* self-illuminating */
#define CAVE_ICKY		0x04 	/* part of a vault */
#define CAVE_ROOM		0x08 	/* part of a room */
#define CAVE_SEEN		0x10 	/* seen flag */
#define CAVE_VIEW		0x20 	/* view flag */
#define CAVE_TEMP		0x40 	/* temp flag */
#define CAVE_WALL		0x80 	/* wall flag */

#define CAVE2_DTRAP		0x01	/* trap detected grid */


/*** Object flags ***/


/*
 * Chest trap flags (see "tables.c")
 */
#define CHEST_LOSE_STR	0x01
#define CHEST_LOSE_CON	0x02
#define CHEST_POISON	0x04
#define CHEST_PARALYZE	0x08
#define CHEST_EXPLODE	0x10
#define CHEST_SUMMON	0x20


/*
 * Special object flags
 */
#define IDENT_SENSE     0x0001	/* Has been "sensed" */
#define IDENT_WORN      0x0002	/* Has been tried on */
#define IDENT_EMPTY     0x0004	/* Is known to be empty */
#define IDENT_KNOWN     0x0008	/* Fully known */
#define IDENT_STORE     0x0010	/* Item is in the inventory of a store */
#define IDENT_ATTACK	0x0020	/* Know combat dice/ac/bonuses */
#define IDENT_DEFENCE	0x0040	/* Know AC/etc bonuses */
#define IDENT_EFFECT	0x0080	/* Know item activation/effect */
/* xxx */
#define IDENT_INDESTRUCT	0x0200	/* Tried to destroy it and failed */
#define IDENT_EGO	0x0400	/* Know the ego */
/* ... */



/*
 * Some bit-flags for the "smart" field of "monster_type".
 *
 * Most of these map to the "TR1_xxx" flags.
 */
#define SM_OPP_ACID		0x00000001
#define SM_OPP_ELEC		0x00000002
#define SM_OPP_FIRE		0x00000004
#define SM_OPP_COLD		0x00000008
#define SM_OPP_POIS		0x00000010
#define SM_OPP_XXX1		0x00000020
#define SM_OPP_XXX2		0x00000040
#define SM_OPP_XXX3		0x00000080
#define SM_IMM_XXX5		0x00000100
#define SM_IMM_XXX6		0x00000200
#define SM_IMM_FREE		0x00000400
#define SM_IMM_MANA		0x00000800
#define SM_IMM_ACID		0x00001000
#define SM_IMM_ELEC		0x00002000
#define SM_IMM_FIRE		0x00004000
#define SM_IMM_COLD		0x00008000
#define SM_RES_ACID		0x00010000
#define SM_RES_ELEC		0x00020000
#define SM_RES_FIRE		0x00040000
#define SM_RES_COLD		0x00080000
#define SM_RES_POIS		0x00100000
#define SM_RES_FEAR		0x00200000
#define SM_RES_LITE		0x00400000
#define SM_RES_DARK		0x00800000
#define SM_RES_BLIND	0x01000000
#define SM_RES_CONFU	0x02000000
#define SM_RES_SOUND	0x04000000
#define SM_RES_SHARD	0x08000000
#define SM_RES_NEXUS	0x10000000
#define SM_RES_NETHR	0x20000000
#define SM_RES_CHAOS	0x40000000
#define SM_RES_DISEN	0x80000000


/*
 * flags1 contains all flags dependant on "pval" (e.g. stat bonuses),
 * plus all "extra attack damage" flags (SLAY_XXX and BRAND_XXX).
 *
 * flags2 contains all "resistances" (including "sustain" flags, immunity
 * flags, and resistance flags).
 *
 * flags3 contains everything else.
 */

#define TR0_STR             0x00000001L /* STR += "pval" */
#define TR0_INT             0x00000002L /* INT += "pval" */
#define TR0_WIS             0x00000004L /* WIS += "pval" */
#define TR0_DEX             0x00000008L /* DEX += "pval" */
#define TR0_CON             0x00000010L /* CON += "pval" */
#define TR0_CHR             0x00000020L /* CHR += "pval" */
#define TR0_XXX1            0x00000040L /* (reserved) */
#define TR0_XXX2            0x00000080L /* (reserved) */
#define TR0_STEALTH         0x00000100L /* Stealth += "pval" */
#define TR0_SEARCH          0x00000200L /* Search += "pval" */
#define TR0_INFRA           0x00000400L /* Infra += "pval" */
#define TR0_TUNNEL          0x00000800L /* Tunnel += "pval" */
#define TR0_SPEED           0x00001000L /* Speed += "pval" */
#define TR0_BLOWS           0x00002000L /* Blows += "pval" */
#define TR0_SHOTS           0x00004000L /* Shots += "pval" */
#define TR0_MIGHT           0x00008000L /* Might += "pval" */
#define TR0_SLAY_ANIMAL     0x00010000L /* Weapon slays animals */
#define TR0_SLAY_EVIL       0x00020000L /* Weapon slays evil */
#define TR0_SLAY_UNDEAD     0x00040000L /* Weapon slays undead */
#define TR0_SLAY_DEMON      0x00080000L /* Weapon slays demon */
#define TR0_SLAY_ORC        0x00100000L /* Weapon slays orc */
#define TR0_SLAY_TROLL      0x00200000L /* Weapon slays troll */
#define TR0_SLAY_GIANT      0x00400000L /* Weapon slays giant */
#define TR0_SLAY_DRAGON     0x00800000L /* Weapon slays dragon */
#define TR0_KILL_DRAGON     0x01000000L /* Weapon kills dragon */
#define TR0_KILL_DEMON      0x02000000L /* Weapon kills demon */
#define TR0_KILL_UNDEAD     0x04000000L /* Weapon "kills" undead */
#define TR0_BRAND_POIS      0x08000000L /* Weapon has poison brand */
#define TR0_BRAND_ACID      0x10000000L /* Weapon has acid brand */
#define TR0_BRAND_ELEC      0x20000000L /* Weapon has elec brand */
#define TR0_BRAND_FIRE      0x40000000L /* Weapon has fire brand */
#define TR0_BRAND_COLD      0x80000000L /* Weapon has cold brand */

#define TR1_SUST_STR        0x00000001L /* Sustain STR */
#define TR1_SUST_INT        0x00000002L /* Sustain INT */
#define TR1_SUST_WIS        0x00000004L /* Sustain WIS */
#define TR1_SUST_DEX        0x00000008L /* Sustain DEX */
#define TR1_SUST_CON        0x00000010L /* Sustain CON */
#define TR1_SUST_CHR        0x00000020L /* Sustain CHR */
#define TR1_VULN_ACID       0x00000040L /* Vulnerable to acid */
#define TR1_VULN_ELEC       0x00000080L /* Vulnerable to elec */
#define TR1_VULN_FIRE       0x00000100L /* Vulnerable to fire */
#define TR1_VULN_COLD       0x00000200L /* Vulnerable to cold */
#define TR1_XXX7            0x00000400L /* (reserved) */
#define TR1_XXX6            0x00000800L /* (reserved) */
#define TR1_IM_ACID         0x00001000L /* Immunity to acid */
#define TR1_IM_ELEC         0x00002000L /* Immunity to elec */
#define TR1_IM_FIRE         0x00004000L /* Immunity to fire */
#define TR1_IM_COLD         0x00008000L /* Immunity to cold */
#define TR1_RES_ACID        0x00010000L /* Resist acid */
#define TR1_RES_ELEC        0x00020000L /* Resist elec */
#define TR1_RES_FIRE        0x00040000L /* Resist fire */
#define TR1_RES_COLD        0x00080000L /* Resist cold */
#define TR1_RES_POIS        0x00100000L /* Resist poison */
#define TR1_RES_FEAR        0x00200000L /* Resist fear */
#define TR1_RES_LITE        0x00400000L /* Resist lite */
#define TR1_RES_DARK        0x00800000L /* Resist dark */
#define TR1_RES_BLIND       0x01000000L /* Resist blind */
#define TR1_RES_CONFU       0x02000000L /* Resist confusion */
#define TR1_RES_SOUND       0x04000000L /* Resist sound */
#define TR1_RES_SHARD       0x08000000L /* Resist shards */
#define TR1_RES_NEXUS       0x10000000L /* Resist nexus */
#define TR1_RES_NETHR       0x20000000L /* Resist nether */
#define TR1_RES_CHAOS       0x40000000L /* Resist chaos */
#define TR1_RES_DISEN       0x80000000L /* Resist disenchant */

#define TR2_SLOW_DIGEST     0x00000001L /* Slow digest */
#define TR2_FEATHER         0x00000002L /* Feather Falling */
#define TR2_LITE            0x00000004L /* Perma-Lite */
#define TR2_REGEN           0x00000008L /* Regeneration */
#define TR2_TELEPATHY       0x00000010L /* Telepathy */
#define TR2_SEE_INVIS       0x00000020L /* See Invis */
#define TR2_FREE_ACT        0x00000040L /* Free action */
#define TR2_HOLD_LIFE       0x00000080L /* Hold life */
#define TR2_NO_FUEL         0x00000100L /* Light source uses no fuel */
#define TR2_IMPAIR_HP       0x00000200L /* Impair HP recovery */
#define TR2_IMPAIR_MANA     0x00000400L /* Impair MP recovery */
#define TR2_AFRAID          0x00000800L
#define TR2_IMPACT          0x00001000L /* Earthquake blows */
#define TR2_TELEPORT        0x00002000L /* Random teleportation */
#define TR2_AGGRAVATE       0x00004000L /* Aggravate monsters */
#define TR2_DRAIN_EXP       0x00008000L /* Experience drain */
#define TR2_IGNORE_ACID     0x00010000L /* Item ignores Acid Damage */
#define TR2_IGNORE_ELEC     0x00020000L /* Item ignores Elec Damage */
#define TR2_IGNORE_FIRE     0x00040000L /* Item ignores Fire Damage */
#define TR2_IGNORE_COLD     0x00080000L /* Item ignores Cold Damage */
#define TR2_XXX5            0x00100000L /* (reserved) */
#define TR2_XXX6            0x00200000L /* (reserved) */
#define TR2_BLESSED         0x00400000L /* Item has been blessed */
#define TR2_XXX8            0x00800000L /* (was: activatable) */
#define TR2_INSTA_ART       0x01000000L /* Item makes an artifact */
#define TR2_EASY_KNOW       0x02000000L /* Item is known if aware */
#define TR2_HIDE_TYPE       0x04000000L /* Item hides description */
#define TR2_SHOW_MODS       0x08000000L /* Item shows Tohit/Todam */
#define TR2_XXX7            0x10000000L /* (reserved) */
#define TR2_LIGHT_CURSE     0x20000000L /* Item has Light Curse */
#define TR2_HEAVY_CURSE     0x40000000L /* Item has Heavy Curse */
#define TR2_PERMA_CURSE     0x80000000L /* Item has Perma Curse */


/*
 * Hack -- flag set 1 -- mask for "pval-dependant" flags.
 * Note that all "pval" dependant flags must be in "flags1".
 */
#define TR0_PVAL_MASK \
	(TR0_STR | TR0_INT | TR0_WIS | TR0_DEX | \
	 TR0_CON | TR0_CHR | TR0_XXX1 | TR0_XXX2 | \
	 TR0_STEALTH | TR0_SEARCH | TR0_INFRA | TR0_TUNNEL | \
	 TR0_SPEED | TR0_BLOWS | TR0_SHOTS | TR0_MIGHT)

/*
 * flag set for high resists
 */
#define TR1_HIGH_RESIST_MASK \
	(TR1_RES_POIS | TR1_RES_FEAR | TR1_RES_LITE | \
	 TR1_RES_DARK | TR1_RES_BLIND | TR1_RES_CONFU | \
	 TR1_RES_SOUND | TR1_RES_SHARD | TR1_RES_NEXUS | \
	 TR1_RES_NETHR | TR1_RES_CHAOS | TR1_RES_DISEN)

/*
 * Flag set 3 -- mask for "ignore element" flags.
 */
#define TR2_IGNORE_MASK \
	(TR2_IGNORE_ACID | TR2_IGNORE_ELEC | TR2_IGNORE_FIRE | \
	 TR2_IGNORE_COLD )

#define TR2_CURSE_MASK \
	(TR2_LIGHT_CURSE | TR2_HEAVY_CURSE | TR2_PERMA_CURSE)


/*
 * Subset of the above that are obvious to the player on wield
 */
#define TR0_OBVIOUS_MASK \
	(TR0_STR | TR0_INT | TR0_WIS | TR0_DEX | \
	 TR0_CON | TR0_CHR | TR0_STEALTH | \
	 TR0_INFRA | TR0_TUNNEL | TR0_SPEED | \
	 TR0_BLOWS | TR0_SHOTS | TR0_MIGHT | \
	 TR0_BRAND_POIS | TR0_BRAND_ELEC | \
	 TR0_BRAND_FIRE | TR0_BRAND_COLD | TR0_BRAND_ACID)

#define TR1_OBVIOUS_MASK \
	(0)

#define TR2_OBVIOUS_MASK \
	(TR2_LITE | TR2_SEE_INVIS | TR2_TELEPATHY | TR2_NO_FUEL | \
	 TR2_BLESSED | TR2_CURSE_MASK | TR2_AFRAID)

/*
 * Flag set 1 - masks for slays and brands
 */
#define TR0_SLAY_MASK \
	(TR0_SLAY_ANIMAL | TR0_SLAY_EVIL | TR0_SLAY_UNDEAD | TR0_SLAY_DEMON | \
	 TR0_SLAY_ORC | TR0_SLAY_TROLL | TR0_SLAY_GIANT | TR0_SLAY_DRAGON)

#define TR0_BRAND_MASK \
	(TR0_BRAND_POIS | TR0_BRAND_ACID | TR0_BRAND_ELEC | TR0_BRAND_FIRE | \
	 TR0_BRAND_COLD)

#define TR0_KILL_MASK \
	(TR0_KILL_DRAGON | TR0_KILL_DEMON | TR0_KILL_UNDEAD)

#define TR0_ALL_SLAYS \
	(TR0_SLAY_MASK | TR0_BRAND_MASK | TR0_KILL_MASK)
	
/*
 * Hack -- special "xtra" object flag info (type)
 */
#define OBJECT_XTRA_TYPE_NONE		0
#define OBJECT_XTRA_TYPE_SUSTAIN	1
#define OBJECT_XTRA_TYPE_RESIST		2
#define OBJECT_XTRA_TYPE_POWER		3


/*** Class flags ***/

#define CF_EXTRA_SHOT		0x00000001L	/* Extra shots */
#define CF_BRAVERY_30		0x00000002L	/* Gains resist fear at plev 30 */
#define CF_BLESS_WEAPON		0x00000004L	/* Requires blessed/hafted weapons */
#define CF_CUMBER_GLOVE		0x00000008L	/* Gloves disturb spellcasting */
#define CF_ZERO_FAIL		0x00000010L /* Fail rates can reach 0% */
#define CF_BEAM			0x00000020L /* Higher chance of spells beaming */
#define CF_CHOOSE_SPELLS	0x00000040L	/* Allow choice of spells */
#define CF_XXX9			0x00000080L
#define CF_PSEUDO_ID_IMPROV	0x00000100L /* Pseudo-id improves quicker with player-level */
#define CF_XXX10			0x00000200L
#define CF_XXX11			0x00000400L
#define CF_XXX12			0x00000800L
#define CF_XXX13			0x00001000L
#define CF_XXX14			0x00002000L
#define CF_XXX15			0x00004000L
#define CF_XXX16			0x00008000L
#define CF_XXX17			0x00010000L
#define CF_XXX18			0x00020000L
#define CF_XXX19			0x00040000L
#define CF_XXX20			0x00080000L
#define CF_XXX21			0x00100000L
#define CF_XXX22			0x00200000L
#define CF_XXX23			0x00400000L
#define CF_XXX24			0x00800000L
#define CF_XXX25			0x01000000L
#define CF_XXX26			0x02000000L
#define CF_XXX27			0x04000000L
#define CF_XXX28			0x08000000L
#define CF_XXX29			0x10000000L
#define CF_XXX30			0x20000000L
#define CF_XXX31			0x40000000L
#define CF_XXX32			0x80000000L


/*** Terrain flags ***/

enum
{
	FF_PWALK        = 0x00000001,
	FF_PPASS        = 0x00000002,
	FF_MWALK        = 0x00000004,
	FF_MPASS        = 0x00000008,
	FF_LOOK         = 0x00000010,
	FF_DIG          = 0x00000020,
	FF_DOOR         = 0x00000040,
	FF_EXIT_UP      = 0x00000080,
	FF_EXIT_DOWN    = 0x00000100,
	FF_PERM         = 0x00000200,
	FF_TRAP         = 0x00000400,
	FF_SHOP         = 0x00000800,
	FF_HIDDEN       = 0x00001000,
	FF_BORING       = 0x00002000
};




/*** Monster flags ***/


/*
 * Special Monster Flags (all temporary)
 */
#define MFLAG_VIEW	0x01	/* Monster is in line of sight */
/* xxx */
#define MFLAG_NICE	0x20	/* Monster is still being nice */
#define MFLAG_SHOW	0x40	/* Monster is recently memorized */
#define MFLAG_MARK	0x80	/* Monster is currently memorized */

/*
 * number of 32-bit bitmaps used for monster race
 */
#define RACE_FLAG_STRICT_UB 3
#define RACE_FLAG_SPELL_STRICT_UB 3

#define race_flags_differ(A,B) (0 != memcmp((A), (B), sizeof(u32b)*RACE_FLAG_STRICT_UB))
#define race_flags_differ_spell(A,B) (0 != memcmp((A), (B), sizeof(u32b)*RACE_FLAG_SPELL_STRICT_UB))
#define race_flags_assign(A,B) memmove((A), (B), sizeof(u32b)*RACE_FLAG_STRICT_UB)
#define race_flags_assign_spell(A, B) memmove((A), (B), sizeof(u32b)*RACE_FLAG_SPELL_STRICT_UB)

/*
 * New monster race bit flags
 */
#define RF0_UNIQUE			0x00000001	/* Unique Monster */
#define RF0_QUESTOR			0x00000002	/* Quest Monster */
#define RF0_MALE			0x00000004	/* Male gender */
#define RF0_FEMALE			0x00000008	/* Female gender */
#define RF0_CHAR_CLEAR		0x00000010	/* Absorbs symbol */
#define RF0_CHAR_MULTI		0x00000020	/* Changes symbol */
#define RF0_ATTR_CLEAR		0x00000040	/* Absorbs color */
#define RF0_ATTR_MULTI		0x00000080	/* Changes color */
#define RF0_FORCE_DEPTH		0x00000100	/* Start at "correct" depth */
#define RF0_XXX1		0x00000200
#define RF0_FORCE_SLEEP		0x00000400	/* Start out sleeping */
#define RF0_FORCE_EXTRA		0x00000800	/* Start out something */
#define RF0_FRIEND			0x00001000	/* Arrive with a friend */
#define RF0_FRIENDS			0x00002000	/* Arrive with some friends */
#define RF0_ESCORT			0x00004000	/* Arrive with an escort */
#define RF0_ESCORTS			0x00008000	/* Arrive with some escorts */
#define RF0_NEVER_BLOW		0x00010000	/* Never make physical blow */
#define RF0_NEVER_MOVE		0x00020000	/* Never make physical move */
#define RF0_RAND_25			0x00040000	/* Moves randomly (25%) */
#define RF0_RAND_50			0x00080000	/* Moves randomly (50%) */
#define RF0_ONLY_GOLD		0x00100000	/* Drop only gold */
#define RF0_ONLY_ITEM		0x00200000	/* Drop only items */
#define RF0_DROP_40			0x00400000	/* Drop an item/gold (40%) */
#define RF0_DROP_60			0x00800000	/* Drop an item/gold (60%) */
#define RF0_DROP_1		0x01000000	/* Drop 1 item/gold */
#define RF0_DROP_2		0x02000000	/* Drop 2 items/gold */
#define RF0_DROP_3		0x04000000	/* Drop 3 items/gold */
#define RF0_DROP_4		0x08000000	/* Drop 4 items/gold */
#define RF0_DROP_GOOD		0x10000000	/* Drop good items */
#define RF0_DROP_GREAT		0x20000000	/* Drop great items */
#define RF0_DROP_20		0x40000000	/* Drop an item/gold (20%) */
#define RF0_DROP_CHOSEN		0x80000000	/* Drop "chosen" items */

/*
 * New monster race bit flags
 */
#define RF1_STUPID			0x00000001	/* Monster is stupid */
#define RF1_SMART			0x00000002	/* Monster is smart */
#define RF1_XXX1			0x00000004	/* (?) */
#define RF1_XXX2			0x00000008	/* (?) */
#define RF1_INVISIBLE		0x00000010	/* Monster avoids vision */
#define RF1_COLD_BLOOD		0x00000020	/* Monster avoids infra */
#define RF1_EMPTY_MIND		0x00000040	/* Monster avoids telepathy */
#define RF1_WEIRD_MIND		0x00000080	/* Monster avoids telepathy? */
#define RF1_MULTIPLY		0x00000100	/* Monster reproduces */
#define RF1_REGENERATE		0x00000200	/* Monster regenerates */
#define RF1_XXX3			0x00000400	/* (?) */
#define RF1_XXX4			0x00000800	/* (?) */
#define RF1_POWERFUL		0x00001000	/* Monster has strong breath */
#define RF1_XXX5			0x00002000	/* (?) */
#define RF1_XXX7			0x00004000	/* (?) */
#define RF1_XXX6			0x00008000	/* (?) */
#define RF1_OPEN_DOOR		0x00010000	/* Monster can open doors */
#define RF1_BASH_DOOR		0x00020000	/* Monster can bash doors */
#define RF1_PASS_WALL		0x00040000	/* Monster can pass walls */
#define RF1_KILL_WALL		0x00080000	/* Monster can destroy walls */
#define RF1_MOVE_BODY		0x00100000	/* Monster can move monsters */
#define RF1_KILL_BODY		0x00200000	/* Monster can kill monsters */
#define RF1_TAKE_ITEM		0x00400000	/* Monster can pick up items */
#define RF1_KILL_ITEM		0x00800000	/* Monster can crush items */
#define RF1_BRAIN_1			0x01000000
#define RF1_BRAIN_2			0x02000000
#define RF1_BRAIN_3			0x04000000
#define RF1_BRAIN_4			0x08000000
#define RF1_BRAIN_5			0x10000000
#define RF1_BRAIN_6			0x20000000
#define RF1_BRAIN_7			0x40000000
#define RF1_BRAIN_8			0x80000000

/*
 * New monster race bit flags
 */
#define RF2_ORC				0x00000001	/* Orc */
#define RF2_TROLL			0x00000002	/* Troll */
#define RF2_GIANT			0x00000004	/* Giant */
#define RF2_DRAGON			0x00000008	/* Dragon */
#define RF2_DEMON			0x00000010	/* Demon */
#define RF2_UNDEAD			0x00000020	/* Undead */
#define RF2_EVIL			0x00000040	/* Evil */
#define RF2_ANIMAL			0x00000080	/* Animal */
#define RF2_METAL			0x00000100	/* Metal */
#define RF2_XXX2			0x00000200	/* (?) */
#define RF2_XXX3			0x00000400	/* Non-Vocal (?) */
#define RF2_XXX4			0x00000800	/* Non-Living (?) */
#define RF2_HURT_LITE		0x00001000	/* Hurt by lite */
#define RF2_HURT_ROCK		0x00002000	/* Hurt by rock remover */
#define RF2_HURT_FIRE		0x00004000	/* Hurt badly by fire */
#define RF2_HURT_COLD		0x00008000	/* Hurt badly by cold */
#define RF2_IM_ACID			0x00010000	/* Resist acid a lot */
#define RF2_IM_ELEC			0x00020000	/* Resist elec a lot */
#define RF2_IM_FIRE			0x00040000	/* Resist fire a lot */
#define RF2_IM_COLD			0x00080000	/* Resist cold a lot */
#define RF2_IM_POIS			0x00100000	/* Resist poison a lot */
#define RF2_XXX5			0x00200000	/* Immune to (?) */
#define RF2_RES_NETH		0x00400000	/* Resist nether a lot */
#define RF2_IM_WATER		0x00800000	/* Immune to water */
#define RF2_RES_PLAS		0x01000000	/* Resist plasma */
#define RF2_RES_NEXUS		0x02000000	/* Resist nexus */
#define RF2_RES_DISE		0x04000000	/* Resist disenchantment */
#define RF2_XXX6			0x08000000	/* Resist (?) */
#define RF2_NO_FEAR			0x10000000	/* Cannot be scared */
#define RF2_NO_STUN			0x20000000	/* Cannot be stunned */
#define RF2_NO_CONF			0x40000000	/* Cannot be confused */
#define RF2_NO_SLEEP		0x80000000	/* Cannot be slept */

/*
 * New monster race bit flags
 */
#define RSF0_SHRIEK          0x00000001 /* Shriek for help */
#define RSF0_XXX2            0x00000002 /* (?) */
#define RSF0_XXX3            0x00000004 /* (?) */
#define RSF0_XXX4            0x00000008 /* (?) */
#define RSF0_ARROW_1         0x00000010 /* Fire an arrow (light) */
#define RSF0_ARROW_2         0x00000020 /* Fire an arrow (heavy) */
#define RSF0_ARROW_3         0x00000040 /* Fire missiles (light) */
#define RSF0_ARROW_4         0x00000080 /* Fire missiles (heavy) */
#define RSF0_BR_ACID         0x00000100 /* Breathe Acid */
#define RSF0_BR_ELEC         0x00000200 /* Breathe Elec */
#define RSF0_BR_FIRE         0x00000400 /* Breathe Fire */
#define RSF0_BR_COLD         0x00000800 /* Breathe Cold */
#define RSF0_BR_POIS         0x00001000 /* Breathe Poison */
#define RSF0_BR_NETH         0x00002000 /* Breathe Nether */
#define RSF0_BR_LITE         0x00004000 /* Breathe Lite */
#define RSF0_BR_DARK         0x00008000 /* Breathe Dark */
#define RSF0_BR_CONF         0x00010000 /* Breathe Confusion */
#define RSF0_BR_SOUN         0x00020000 /* Breathe Sound */
#define RSF0_BR_CHAO         0x00040000 /* Breathe Chaos */
#define RSF0_BR_DISE         0x00080000 /* Breathe Disenchant */
#define RSF0_BR_NEXU         0x00100000 /* Breathe Nexus */
#define RSF0_BR_TIME         0x00200000 /* Breathe Time */
#define RSF0_BR_INER         0x00400000 /* Breathe Inertia */
#define RSF0_BR_GRAV         0x00800000 /* Breathe Gravity */
#define RSF0_BR_SHAR         0x01000000 /* Breathe Shards */
#define RSF0_BR_PLAS         0x02000000 /* Breathe Plasma */
#define RSF0_BR_WALL         0x04000000 /* Breathe Force */
#define RSF0_BR_MANA         0x08000000 /* Breathe Mana */
#define RSF0_XXX5            0x10000000
#define RSF0_XXX6            0x20000000
#define RSF0_XXX7            0x40000000
#define RSF0_BOULDER         0x80000000 /* Throw a boulder */

/*
 * New monster race bit flags
 */
#define RSF1_BA_ACID			0x00000001	/* Acid Ball */
#define RSF1_BA_ELEC			0x00000002	/* Elec Ball */
#define RSF1_BA_FIRE			0x00000004	/* Fire Ball */
#define RSF1_BA_COLD			0x00000008	/* Cold Ball */
#define RSF1_BA_POIS			0x00000010	/* Poison Ball */
#define RSF1_BA_NETH			0x00000020	/* Nether Ball */
#define RSF1_BA_WATE			0x00000040	/* Water Ball */
#define RSF1_BA_MANA			0x00000080	/* Mana Storm */
#define RSF1_BA_DARK			0x00000100	/* Darkness Storm */
#define RSF1_DRAIN_MANA		0x00000200	/* Drain Mana */
#define RSF1_MIND_BLAST		0x00000400	/* Blast Mind */
#define RSF1_BRAIN_SMASH		0x00000800	/* Smash Brain */
#define RSF1_CAUSE_1			0x00001000	/* Cause Light Wound */
#define RSF1_CAUSE_2			0x00002000	/* Cause Serious Wound */
#define RSF1_CAUSE_3			0x00004000	/* Cause Critical Wound */
#define RSF1_CAUSE_4			0x00008000	/* Cause Mortal Wound */
#define RSF1_BO_ACID			0x00010000	/* Acid Bolt */
#define RSF1_BO_ELEC			0x00020000	/* Elec Bolt (unused) */
#define RSF1_BO_FIRE			0x00040000	/* Fire Bolt */
#define RSF1_BO_COLD			0x00080000	/* Cold Bolt */
#define RSF1_BO_POIS			0x00100000	/* Poison Bolt (unused) */
#define RSF1_BO_NETH			0x00200000	/* Nether Bolt */
#define RSF1_BO_WATE			0x00400000	/* Water Bolt */
#define RSF1_BO_MANA			0x00800000	/* Mana Bolt */
#define RSF1_BO_PLAS			0x01000000	/* Plasma Bolt */
#define RSF1_BO_ICEE			0x02000000	/* Ice Bolt */
#define RSF1_MISSILE			0x04000000	/* Magic Missile */
#define RSF1_SCARE			0x08000000	/* Frighten Player */
#define RSF1_BLIND			0x10000000	/* Blind Player */
#define RSF1_CONF			0x20000000	/* Confuse Player */
#define RSF1_SLOW			0x40000000	/* Slow Player */
#define RSF1_HOLD			0x80000000	/* Paralyze Player */

/*
 * New monster race bit flags
 */
#define RSF2_HASTE           0x00000001 /* Speed self */
#define RSF2_XXX1            0x00000002 /* Speed a lot (?) */
#define RSF2_HEAL            0x00000004 /* Heal self */
#define RSF2_XXX2            0x00000008 /* Heal a lot (?) */
#define RSF2_BLINK           0x00000010 /* Teleport Short */
#define RSF2_TPORT           0x00000020 /* Teleport Long */
#define RSF2_XXX3            0x00000040 /* Move to Player (?) */
#define RSF2_XXX4            0x00000080 /* Move to Monster (?) */
#define RSF2_TELE_TO         0x00000100 /* Move player to monster */
#define RSF2_TELE_AWAY       0x00000200 /* Move player far away */
#define RSF2_TELE_LEVEL      0x00000400 /* Move player vertically */
#define RSF2_XXX5            0x00000800 /* Move player (?) */
#define RSF2_DARKNESS        0x00001000 /* Create Darkness */
#define RSF2_TRAPS           0x00002000 /* Create Traps */
#define RSF2_FORGET          0x00004000 /* Cause amnesia */
#define RSF2_XXX6            0x00008000 /* (?) */
#define RSF2_S_KIN           0x00010000 /* Summon Kin */
#define RSF2_S_HI_DEMON      0x00020000 /* Summon Greater Demons */
#define RSF2_S_MONSTER       0x00040000 /* Summon Monster */
#define RSF2_S_MONSTERS      0x00080000 /* Summon Monsters */
#define RSF2_S_ANIMAL        0x00100000 /* Summon Animals */
#define RSF2_S_SPIDER        0x00200000 /* Summon Spiders */
#define RSF2_S_HOUND         0x00400000 /* Summon Hounds */
#define RSF2_S_HYDRA         0x00800000 /* Summon Hydras */
#define RSF2_S_ANGEL         0x01000000 /* Summon Angel */
#define RSF2_S_DEMON         0x02000000 /* Summon Demon */
#define RSF2_S_UNDEAD        0x04000000 /* Summon Undead */
#define RSF2_S_DRAGON        0x08000000 /* Summon Dragon */
#define RSF2_S_HI_UNDEAD     0x10000000 /* Summon Greater Undead */
#define RSF2_S_HI_DRAGON     0x20000000 /* Summon Ancient Dragon */
#define RSF2_S_WRAITH        0x40000000 /* Summon Unique Wraith */
#define RSF2_S_UNIQUE        0x80000000 /* Summon Unique Monster */


/*
 * Some flags are obvious
 */
#define RF0_OBVIOUS_MASK \
	(RF0_UNIQUE | RF0_QUESTOR | RF0_MALE | RF0_FEMALE | \
	 RF0_FRIEND | RF0_FRIENDS | RF0_ESCORT | RF0_ESCORTS)

/*
 * "race" flags
 */
#define RF2_RACE_MASK \
	(RF2_ORC | RF2_TROLL | RF2_GIANT | RF2_DRAGON | \
	 RF2_DEMON | RF2_UNDEAD | RF2_EVIL | RF2_ANIMAL | RF2_METAL)


/*
 * Hack -- Bit masks to control what spells are considered
 */

/*
 * Choose "intelligent" spells when desperate
 */

#define RSF0_INT_MASK \
	(0L)

#define RSF1_INT_MASK \
	(RSF1_HOLD | RSF1_SLOW | RSF1_CONF | RSF1_BLIND | RSF1_SCARE)

#define RSF2_INT_MASK \
	(RSF2_BLINK |  RSF2_TPORT | RSF2_TELE_LEVEL | RSF2_TELE_AWAY | \
	 RSF2_HEAL | RSF2_HASTE | RSF2_TRAPS | \
	 RSF2_S_ANIMAL | RSF2_S_KIN | RSF2_S_MONSTER | RSF2_S_MONSTERS | \
	 RSF2_S_SPIDER | RSF2_S_HOUND | RSF2_S_HYDRA | \
	 RSF2_S_ANGEL | RSF2_S_DRAGON | RSF2_S_UNDEAD | RSF2_S_DEMON | \
	 RSF2_S_HI_DRAGON | RSF2_S_HI_UNDEAD | RSF2_S_HI_DEMON | \
	 RSF2_S_WRAITH | RSF2_S_UNIQUE)


/*
 * "Bolt" spells that may hurt fellow monsters
 */
#define RSF0_BOLT_MASK \
	(RSF0_ARROW_1 | RSF0_ARROW_2 | RSF0_ARROW_3 | RSF0_ARROW_4 | \
	 RSF0_BOULDER)

#define RSF1_BOLT_MASK \
	(RSF1_BO_ACID | RSF1_BO_ELEC | RSF1_BO_FIRE | RSF1_BO_COLD | \
	 RSF1_BO_POIS | RSF1_BO_NETH | RSF1_BO_WATE | RSF1_BO_MANA | \
	 RSF1_BO_PLAS | RSF1_BO_ICEE | RSF1_MISSILE)

#define RSF2_BOLT_MASK \
	(0L)

/*
 * Spells that allow the caster to escape
 */
#define RSF0_ESCAPE_MASK \
	(0L)

#define RSF1_ESCAPE_MASK \
	(0L)

#define RSF2_ESCAPE_MASK \
	(RSF2_BLINK | RSF2_TPORT | RSF2_TELE_AWAY | RSF2_TELE_LEVEL)


/*
 * Spells that hurt the player directly
 */
#define RSF0_ATTACK_MASK \
	(RSF0_ARROW_1 | RSF0_ARROW_2 | RSF0_ARROW_3 | RSF0_ARROW_4 | RSF0_BOULDER | \
	 RSF0_BR_ACID | RSF0_BR_ELEC | RSF0_BR_FIRE | RSF0_BR_COLD | RSF0_BR_POIS | \
	 RSF0_BR_NETH | RSF0_BR_LITE | RSF0_BR_DARK | RSF0_BR_CONF | RSF0_BR_SOUN | \
	 RSF0_BR_CHAO | RSF0_BR_DISE | RSF0_BR_NEXU | RSF0_BR_TIME | RSF0_BR_INER | \
	 RSF0_BR_GRAV | RSF0_BR_SHAR | RSF0_BR_PLAS | RSF0_BR_WALL | RSF0_BR_MANA)

#define RSF1_ATTACK_MASK \
	(RSF1_BA_ACID | RSF1_BA_ELEC | RSF1_BA_FIRE | RSF1_BA_COLD | RSF1_BA_POIS | \
	 RSF1_BA_NETH | RSF1_BA_WATE | RSF1_BA_MANA | RSF1_BA_DARK | \
	 RSF1_MIND_BLAST | RSF1_BRAIN_SMASH | RSF1_CAUSE_1 | RSF1_CAUSE_2 | \
	 RSF1_CAUSE_3 | RSF1_CAUSE_4 | RSF1_BO_ACID | RSF1_BO_ELEC | RSF1_BO_FIRE | \
	 RSF1_BO_COLD | RSF1_BO_POIS | RSF1_BO_NETH | RSF1_BO_WATE | RSF1_BO_MANA | \
	 RSF1_BO_PLAS | RSF1_BO_ICEE | RSF1_MISSILE)

#define RSF2_ATTACK_MASK \
	(0L)


/*
 * Summoning spells
 */
#define RSF0_SUMMON_MASK \
	(0L)

#define RSF1_SUMMON_MASK \
	(0L)

#define RSF2_SUMMON_MASK \
	(RSF2_S_KIN | RSF2_S_MONSTER | RSF2_S_MONSTERS | RSF2_S_ANIMAL | \
	 RSF2_S_SPIDER | RSF2_S_HOUND | RSF2_S_HYDRA | RSF2_S_ANGEL | \
	 RSF2_S_DEMON | RSF2_S_UNDEAD | RSF2_S_DRAGON | RSF2_S_HI_UNDEAD | \
	 RSF2_S_HI_DEMON | RSF2_S_HI_DRAGON | RSF2_S_WRAITH | RSF2_S_UNIQUE)


/*
 * Spells that improve the caster's tactical position
 */
#define RSF0_TACTIC_MASK \
	(0L)

#define RSF1_TACTIC_MASK \
	(0L)

#define RSF2_TACTIC_MASK \
	(RSF2_BLINK)


/*
 * Annoying spells
 */
#define RSF0_ANNOY_MASK \
	(RSF0_SHRIEK)

#define RSF1_ANNOY_MASK \
	(RSF1_DRAIN_MANA | RSF1_MIND_BLAST | RSF1_BRAIN_SMASH | RSF1_SCARE | \
	 RSF1_BLIND | RSF1_CONF | RSF1_SLOW | RSF1_HOLD)

#define RSF2_ANNOY_MASK \
	(RSF2_TELE_TO | RSF2_DARKNESS | RSF2_TRAPS | RSF2_FORGET)


/*
 * Spells that increase the caster's relative speed
 */
#define RSF0_HASTE_MASK \
	(0L)

#define RSF1_HASTE_MASK \
	(RSF1_SLOW | RSF1_HOLD)

#define RSF2_HASTE_MASK \
	(RSF2_HASTE)


/*
 * Healing spells
 */
#define RSF0_HEAL_MASK \
	(0L)

#define RSF1_HEAL_MASK \
	(0L)

#define RSF2_HEAL_MASK \
	(RSF2_HEAL)


/*
 * Innate spell-like effects
 */
#define RSF0_INNATE_MASK \
	(RSF0_SHRIEK | RSF0_ARROW_1 | RSF0_ARROW_2 | RSF0_ARROW_3 | RSF0_ARROW_4 | \
	 RSF0_BR_ACID | RSF0_BR_ELEC | RSF0_BR_FIRE | RSF0_BR_COLD | RSF0_BR_POIS | \
	 RSF0_BR_NETH | RSF0_BR_LITE | RSF0_BR_DARK | RSF0_BR_CONF | RSF0_BR_SOUN | \
	 RSF0_BR_CHAO | RSF0_BR_DISE | RSF0_BR_NEXU | RSF0_BR_TIME | RSF0_BR_INER | \
	 RSF0_BR_GRAV | RSF0_BR_SHAR | RSF0_BR_PLAS | RSF0_BR_WALL | RSF0_BR_MANA | \
	 RSF0_BOULDER)

#define RSF1_INNATE_MASK \
	(0L)

#define RSF2_INNATE_MASK \
	(0L)





/*** Macro Definitions ***/


/*
 * Hack -- The main "screen"
 */
#define term_screen	(angband_term[0])


/*
 * Determine if the attr and char should consider the item's flavor
 *
 * Identified scrolls should use their own tile.
 */
#define use_flavor_glyph(K) \
	((k_info[(K)].flavor) && \
	 !((k_info[(K)].tval == TV_SCROLL) && k_info[(K)].aware))

/*
 * Return the "attr" for a given item kind.
 * Use "flavor" if available.
 * Default to user definitions.
 */
#define object_kind_attr(K) \
	(use_flavor_glyph(K) ? \
	 (flavor_info[k_info[(K)].flavor].x_attr) : \
	 (k_info[(K)].x_attr))

/*
 * Return the "char" for a given item kind.
 * Use "flavor" if available.
 * Default to user definitions.
 */
#define object_kind_char(K) \
	(use_flavor_glyph(K) ? \
	 (flavor_info[k_info[(K)].flavor].x_char) : \
	 (k_info[(K)].x_char))

/*
 * Return the "attr" for a given item.
 * Use "flavor" if available.
 * Default to user definitions.
 */
#define object_attr(T) \
	(object_kind_attr((T)->k_idx))

/*
 * Return the "char" for a given item.
 * Use "flavor" if available.
 * Default to user definitions.
 */
#define object_char(T) \
	(object_kind_char((T)->k_idx))


/*
 * Return the "attr" for a given item.
 * Use "flavor" if available.
 * Use default definitions.
 */
#define object_attr_default(T) \
	((k_info[(T)->k_idx].flavor) ? \
	 (flavor_info[k_info[(T)->k_idx].flavor].d_attr) : \
	 (k_info[(T)->k_idx].d_attr))

/*
 * Return the "char" for a given item.
 * Use "flavor" if available.
 * Use default definitions.
 */
#define object_char_default(T) \
	((k_info[(T)->k_idx].flavor) ? \
	 (flavor_info[k_info[(T)->k_idx].flavor].d_char) : \
	 (k_info[(T)->k_idx].d_char))

/*
 * Artifacts use the "name1" field
 */
#define artifact_p(T) \
	((T)->name1 ? TRUE : FALSE)

/*
 * Ego-Items use the "name2" field
 */
#define ego_item_p(T) \
	((T)->name2 ? TRUE : FALSE)

/*
 * Cursed items.
 */
#define cursed_p(T) \
	((T)->flags[2] & (TR2_CURSE_MASK))

 /*
 * Rings and Amulets
 */
#define object_is_jewelry(T) \
	(((T)->tval == TV_RING) || ((T)->tval == TV_AMULET))


/*
 * Rings and Amulets
 */
#define object_is_jewelry(T) \
	(((T)->tval == TV_RING) || ((T)->tval == TV_AMULET))


/*
 * Convert an "attr"/"char" pair into a "pict" (P)
 */
#define PICT(A,C) \
	((((u16b)(A)) << 8) | ((byte)(C)))

/*
 * Convert a "pict" (P) into an "attr" (A)
 */
#define PICT_A(P) \
	((byte)((P) >> 8))

/*
 * Convert a "pict" (P) into an "char" (C)
 */
#define PICT_C(P) \
	((char)((byte)(P)))


/*
 * Convert a "location" (Y,X) into a "grid" (G)
 */
#define GRID(Y,X) \
	(256 * (Y) + (X))

/*
 * Convert a "grid" (G) into a "location" (Y)
 */
#define GRID_Y(G) \
	((int)((G) / 256U))

/*
 * Convert a "grid" (G) into a "location" (X)
 */
#define GRID_X(G) \
	((int)((G) % 256U))


/*
 * Convert a "key event" into a "location" (Y)
 */
#define KEY_GRID_Y(K) \
	((int) ((K.mousey - ROW_MAP) + Term->offset_y))

/*
 * Convert a "key event" into a "location" (X)
 */
#define KEY_GRID_X(K) \
	((int) (((K.mousex - COL_MAP) / (use_bigtile ? 2 : 1)) + Term->offset_x))


/*
 * Determines if a map location is "meaningful"
 */
#define in_bounds(Y,X) \
	(((unsigned)(Y) < (unsigned)(DUNGEON_HGT)) && \
	 ((unsigned)(X) < (unsigned)(DUNGEON_WID)))

/*
 * Determines if a map location is fully inside the outer walls
 * This is more than twice as expensive as "in_bounds()", but
 * often we need to exclude the outer walls from calculations.
 */
#define in_bounds_fully(Y,X) \
	(((Y) > 0) && ((Y) < DUNGEON_HGT-1) && \
	 ((X) > 0) && ((X) < DUNGEON_WID-1))


/*
 * Determines if a map location is currently "on screen"
 * Note that "panel_contains(Y,X)" always implies "in_bounds(Y,X)".
 * Pre-storing this into a cave_info flag would be nice.  XXX XXX
 */
#define panel_contains(Y,X) \
	(((unsigned)((Y) - Term->offset_y) < (unsigned)(SCREEN_HGT)) && \
	 ((unsigned)((X) - Term->offset_x) < (unsigned)(SCREEN_WID)))



/*
 * Determine if a "legal" grid is a "floor" grid
 *
 * Line 1 -- forbid doors, rubble, seams, walls
 *
 * Note the use of the new "CAVE_WALL" flag.
 */
#define cave_floor_bold(Y,X) \
	(!(cave_info[Y][X] & (CAVE_WALL)))

/*
 * Determine if a "legal" grid is a "clean" floor grid
 *
 * Line 1 -- forbid non-floors
 * Line 2 -- forbid normal objects
 */
#define cave_clean_bold(Y,X) \
	((cave_feat[Y][X] == FEAT_FLOOR) && \
	 (cave_o_idx[Y][X] == 0))

/*
 * Determine if a "legal" grid is an "empty" floor grid
 *
 * Line 1 -- forbid doors, rubble, seams, walls
 * Line 2 -- forbid player/monsters
 */
#define cave_empty_bold(Y,X) \
	(cave_floor_bold(Y,X) && \
	 (cave_m_idx[Y][X] == 0))

/*
 * Determine if a "legal" grid is an "naked" floor grid
 *
 * Line 1 -- forbid non-floors
 * Line 2 -- forbid normal objects
 * Line 3 -- forbid player/monsters
 */
#define cave_naked_bold(Y,X) \
	((cave_feat[Y][X] == FEAT_FLOOR) && \
	 (cave_o_idx[Y][X] == 0) && \
	 (cave_m_idx[Y][X] == 0))


/*
 * Determine if a "legal" grid is "permanent"
 *
 * Line 1 -- perma-walls
 * Line 2-3 -- stairs
 * Line 4-5 -- shop doors
 */
#define cave_perma_bold(Y,X) \
	((cave_feat[Y][X] >= FEAT_PERM_EXTRA) || \
	 ((cave_feat[Y][X] == FEAT_LESS) || \
	  (cave_feat[Y][X] == FEAT_MORE)) || \
	 ((cave_feat[Y][X] >= FEAT_SHOP_HEAD) && \
	  (cave_feat[Y][X] <= FEAT_SHOP_TAIL)))


/*
 * Determine if a "legal" grid is within "los" of the player
 *
 * Note the use of comparison to zero to force a "boolean" result
 */
#define player_has_los_bold(Y,X) \
	((cave_info[Y][X] & (CAVE_VIEW)) != 0)


/*
 * Determine if a "legal" grid can be "seen" by the player
 *
 * Note the use of comparison to zero to force a "boolean" result
 */
#define player_can_see_bold(Y,X) \
	((cave_info[Y][X] & (CAVE_SEEN)) != 0)


/*
 * Say whether it's daytime or not
 */
#define is_daytime() \
	(((turn % (10L * TOWN_DAWN)) < ((10L * TOWN_DAWN) / 2)) ? FALSE : TRUE)




/*
 * Maximum number of macro trigger names
 */
#define MAX_MACRO_TRIGGER 200
#define MAX_MACRO_MOD 12


/*** Hack ***/


/*
 * Available graphic modes
 */
#define GRAPHICS_NONE           0
#define GRAPHICS_ORIGINAL       1
#define GRAPHICS_ADAM_BOLT      2
#define GRAPHICS_DAVID_GERVAIS  3
#define GRAPHICS_PSEUDO         4


/*
 * List of commands that will be auto-repeated
 *
 * ToDo: This string should be user-configurable.
 */
#define AUTO_REPEAT_COMMANDS "TBDoc+"


/* player_type.noscore flags */
#define NOSCORE_WIZARD		0x0002
#define NOSCORE_DEBUG		0x0008
#define NOSCORE_BORG		0x0010

#endif /* !INCLUDED_DEFINES_H */


#define SCAN_INSTANT ((u32b) -1)
#define SCAN_OFF 0
#define SCAN_MACRO 45

#define MAX_ITEMLIST 256

/* Whether to learn egos and flavors with less than complete information */
#define EASY_LEARN 1
