// $Id: JasonsHugeTheme.java,v 1.4 2003/06/30 18:00:23 linus Exp $
// Copyright (c) 1996-99 The Regents of the University of California. All
// Rights Reserved. Permission to use, copy, modify, and distribute this
// software and its documentation without fee, and without a written
// agreement is hereby granted, provided that the above copyright notice
// and this paragraph appear in all copies.  This software program and
// documentation are copyrighted by The Regents of the University of
// California. The software program and documentation are supplied "AS
// IS", without any accompanying services from The Regents. The Regents
// does not warrant that the operation of the program will be
// uninterrupted or error-free. The end-user understands that the program
// was developed for research purposes and is advised not to rely
// exclusively on the program for any reason.  IN NO EVENT SHALL THE
// UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR DIRECT, INDIRECT,
// SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST PROFITS,
// ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF
// THE UNIVERSITY OF CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF
// SUCH DAMAGE. THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY
// WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
// MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. THE SOFTWARE
// PROVIDED HEREUNDER IS ON AN "AS IS" BASIS, AND THE UNIVERSITY OF
// CALIFORNIA HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE, SUPPORT,
// UPDATES, ENHANCEMENTS, OR MODIFICATIONS.

package org.argouml.ui;

import javax.swing.plaf.metal.*;
import javax.swing.plaf.*;
import javax.swing.*;
import java.awt.*;

/**
 * This class defines a variation on the default Metal Theme.
 */

public class JasonsHugeTheme extends MetalTheme {

    private final ColorUIResource primary1 = new ColorUIResource(102, 102, 153);
    private final ColorUIResource primary2 = new ColorUIResource(153, 153, 204);
    private final ColorUIResource primary3 = new ColorUIResource(204, 204, 255);
  
    private final ColorUIResource secondary1 =
	new ColorUIResource(102, 102, 102);
    private final ColorUIResource secondary2 =
	new ColorUIResource(153, 153, 153);
    private final ColorUIResource secondary3 =
	new ColorUIResource(204, 204, 204);
  
    private final FontUIResource controlFont =
	new FontUIResource("SansSerif", Font.BOLD, 16);
    private final FontUIResource systemFont =
	new FontUIResource("Dialog", Font.PLAIN, 16);
    private final FontUIResource windowTitleFont =
	new FontUIResource("SansSerif", Font.BOLD, 16);
    private final FontUIResource userFont =
	new FontUIResource("SansSerif", Font.PLAIN, 16);
    private final FontUIResource smallFont =
	new FontUIResource("Dialog", Font.PLAIN, 14);

    public String getName() { return "Very Large Fonts"; }

    // these are blue in Metal Default Theme
    protected ColorUIResource getPrimary1() { return primary1; } 
    protected ColorUIResource getPrimary2() { return primary2; }
    protected ColorUIResource getPrimary3() { return primary3; }
  
    // these are gray in Metal Default Theme
    protected ColorUIResource getSecondary1() { return secondary1; }
    protected ColorUIResource getSecondary2() { return secondary2; }
    protected ColorUIResource getSecondary3() { return secondary3; }
  
    public FontUIResource getControlTextFont() { return controlFont; }
    public FontUIResource getSystemTextFont() { return systemFont; }
    public FontUIResource getUserTextFont() { return userFont; }
    public FontUIResource getMenuTextFont() { return controlFont; }
    public FontUIResource getEmphasisTextFont() { return windowTitleFont; }
    public FontUIResource getSubTextFont() { return smallFont; }
  
    public FontUIResource getWindowTitleFont() { return windowTitleFont; }

}
