/*
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Ant", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
package org.aspectj.tools.ant.taskdefs;

import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.Path;


import java.io.File;

/**
 * Partial implementation of CompilerAdapter for ajc task.
 * The Javac interface does not support argfiles which are
 * typically necessary to compile under ajc, so this 
 * implementation is not documented, recommended, or supported.
 * See Apache request for enhancement 
 * <a href="http://nagoya.apache.org/bugzilla/show_bug.cgi?id=7542">
 * 7542</a>.
 * @see CompilerAdapter
 */
public class AjcCompilerAdapter implements CompilerAdapter {
    // Cannot extend Ajc because CompilerAdapter.execute() returns boolean.

    Ajc ajc = null;

    /** @see CompilerAdapter */
    public void setJavac(Javac javac) {
        if (null == javac) {
            throw new IllegalArgumentException("null javac");
        }
        Object task = javac.getProject().createTask("ajc"); 
        String err = null;
        if (null == task) {
            err = "ajc not defined - put ajc taskdef library on classpath";
        } else if (!(task instanceof Ajc)) {
            String name = task.getClass().getName();
            err = "Wrong class for Ajc task - ";
            if (name.equals(Ajc.class.getName())) {
                err = err + "second class loader - put ajc taskdef library "
                    + "only on system classpath via ant/lib";
            } else {
                err = err + name;
            }
        }
        if (null != err) {
            throw new Error(err);
        }

        Ajc tempAjc = (Ajc) task;
        Path srcDir = javac.getSrcdir();
        if (null != srcDir) {
            tempAjc.setSrcdir(srcDir);
        }
        File destDir = javac.getDestdir();
        if (null != destDir) {
            tempAjc.setDestdir(destDir.getPath());
        }
        Path classpath = javac.getClasspath();
        if (null != classpath) {
            tempAjc.setClasspath(classpath);
        }
        Path bootclasspath = javac.getBootclasspath();
        if (null != bootclasspath) {
            tempAjc.setBootclasspath(bootclasspath);
        }
        Path extDirs = javac.getExtdirs();
        if (null != extDirs) {
            tempAjc.setExtdirs(extDirs);
        }

        tempAjc.setFailonerror(javac.getFailonerror());
        tempAjc.setDeprecation(javac.getDeprecation()); // XXX unsupported
        tempAjc.setEncoding(javac.getEncoding());
        tempAjc.setDebug(javac.getDebug()); // XXX unsupported
        tempAjc.setOptimize(javac.getOptimize()); // XXX unsupported
        tempAjc.setDepend(javac.getDepend()?"on":"off"); // XXX unsupported
        tempAjc.setVerbose(javac.getVerbose()); 
        String target = javac.getTarget();
        if (null != target) {
            tempAjc.setTarget(target);
        }
        tempAjc.setIncludeantruntime(javac.getIncludeantruntime()); // XXX unsupported
        File[] files = javac.getFileList();
        if (null != files) {
            for (int i = 0; i < files.length; i++) {
                tempAjc.backdoorSetFile(files[i]);
            } 
        }
        ajc = tempAjc;
    }

    /** @see CompilerAdapter#execute() */
    public boolean execute() throws BuildException {
        if (null == ajc) {
            throw new BuildException("setJavac(Javac) not completed");
        }
        ajc.execute();
        // ajc = null; // XXX enforce one-shot?
        return true;
    }
}
