/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.org.eclipse.jdt.core.IClasspathEntry;
import org.aspectj.org.eclipse.jdt.core.ICompilationUnit;
import org.aspectj.org.eclipse.jdt.core.IJavaElement;
import org.aspectj.org.eclipse.jdt.core.IPackageFragment;
import org.aspectj.org.eclipse.jdt.core.IPackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.core.IType;
import org.aspectj.org.eclipse.jdt.core.JavaCore;
import org.aspectj.org.eclipse.jdt.core.JavaModelException;
import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.core.search.SearchEngine;
import org.aspectj.org.eclipse.jdt.core.search.TypeNameRequestor;
import org.aspectj.org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.aspectj.org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.aspectj.org.eclipse.jdt.internal.core.BinaryType;
import org.aspectj.org.eclipse.jdt.internal.core.IJavaElementRequestor;
import org.aspectj.org.eclipse.jdt.internal.core.JavaElementRequestor;
import org.aspectj.org.eclipse.jdt.internal.core.JavaProject;
import org.aspectj.org.eclipse.jdt.internal.core.PackageFragment;
import org.aspectj.org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.aspectj.org.eclipse.jdt.internal.core.SingleTypeRequestor;
import org.aspectj.org.eclipse.jdt.internal.core.SourceType;
import org.aspectj.org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.aspectj.org.eclipse.jdt.internal.core.util.HashtableOfArrayToObject;
import org.aspectj.org.eclipse.jdt.internal.core.util.Messages;
import org.aspectj.org.eclipse.jdt.internal.core.util.Util;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;

public class NameLookup
implements SuffixConstants {
    public static final int ACCEPT_CLASSES = 2;
    public static final int ACCEPT_INTERFACES = 4;
    public static final int ACCEPT_ENUMS = 8;
    public static final int ACCEPT_ANNOTATIONS = 16;
    public static final int ACCEPT_ALL = 30;
    public static boolean VERBOSE = false;
    protected IPackageFragmentRoot[] packageFragmentRoots;
    protected HashtableOfArrayToObject packageFragments;
    protected Map rootToResolvedEntries;
    protected HashMap unitsToLookInside;
    public long timeSpentInSeekTypesInSourcePackage = 0L;
    public long timeSpentInSeekTypesInBinaryPackage = 0L;

    public NameLookup(IPackageFragmentRoot[] packageFragmentRoots, HashtableOfArrayToObject packageFragments, ICompilationUnit[] workingCopies, Map rootToResolvedEntries) {
        long start = -1L;
        if (VERBOSE) {
            System.out.println(Thread.currentThread() + " BUILDING NameLoopkup");
            System.out.println(Thread.currentThread() + " -> pkg roots size: " + (packageFragmentRoots == null ? 0 : packageFragmentRoots.length));
            System.out.println(Thread.currentThread() + " -> pkgs size: " + (packageFragments == null ? 0 : packageFragments.size()));
            System.out.println(Thread.currentThread() + " -> working copy size: " + (workingCopies == null ? 0 : workingCopies.length));
            start = System.currentTimeMillis();
        }
        this.packageFragmentRoots = packageFragmentRoots;
        try {
            this.packageFragments = (HashtableOfArrayToObject)packageFragments.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (workingCopies != null) {
            this.unitsToLookInside = new HashMap();
            int i = 0;
            int length = workingCopies.length;
            while (i < length) {
                ICompilationUnit workingCopy = workingCopies[i];
                PackageFragment pkg = (PackageFragment)workingCopy.getParent();
                HashMap<String, Object> typeMap = (HashMap<String, Object>)this.unitsToLookInside.get(pkg);
                if (typeMap == null) {
                    typeMap = new HashMap<String, Object>();
                    this.unitsToLookInside.put(pkg, typeMap);
                }
                try {
                    IType[] types = workingCopy.getTypes();
                    int j = 0;
                    int typeLength = types.length;
                    while (j < typeLength) {
                        IType type = types[j];
                        String typeName = type.getElementName();
                        Object existing = typeMap.get(typeName);
                        if (existing == null) {
                            typeMap.put(typeName, type);
                        } else if (existing instanceof IType) {
                            typeMap.put(typeName, new IType[]{(IType)existing, type});
                        } else {
                            IType[] existingTypes = (IType[])existing;
                            int existingTypeLength = existingTypes.length;
                            IType[] iTypeArray = existingTypes;
                            existingTypes = new IType[existingTypeLength + 1];
                            System.arraycopy(iTypeArray, 0, existingTypes, 0, existingTypeLength);
                            existingTypes[existingTypeLength] = type;
                            typeMap.put(typeName, existingTypes);
                        }
                        ++j;
                    }
                }
                catch (JavaModelException types) {
                    // empty catch block
                }
                IPackageFragmentRoot root = (IPackageFragmentRoot)pkg.getParent();
                Object[] pkgName = pkg.names;
                Object existing = this.packageFragments.get(pkgName);
                if (existing == null) {
                    this.packageFragments.put(pkgName, root);
                } else if (existing instanceof PackageFragmentRoot) {
                    if (!existing.equals(root)) {
                        this.packageFragments.put(pkgName, new IPackageFragmentRoot[]{(PackageFragmentRoot)existing, root});
                    }
                } else {
                    IPackageFragmentRoot[] roots = (IPackageFragmentRoot[])existing;
                    int rootLength = roots.length;
                    boolean containsRoot = false;
                    int j = 0;
                    while (j < rootLength) {
                        if (roots[j].equals(root)) {
                            containsRoot = true;
                            break;
                        }
                        ++j;
                    }
                    if (containsRoot) {
                        IPackageFragmentRoot[] iPackageFragmentRootArray = roots;
                        roots = new IPackageFragmentRoot[rootLength + 1];
                        System.arraycopy(iPackageFragmentRootArray, 0, roots, 0, rootLength);
                        roots[rootLength] = root;
                        this.packageFragments.put(pkgName, roots);
                    }
                }
                ++i;
            }
        }
        this.rootToResolvedEntries = rootToResolvedEntries;
        if (VERBOSE) {
            System.out.println(Thread.currentThread() + " -> spent: " + (start - System.currentTimeMillis()) + "ms");
        }
    }

    protected boolean acceptType(IType type, int acceptFlags, boolean isSourceType) {
        if (acceptFlags == 0 || acceptFlags == 30) {
            return true;
        }
        try {
            int kind = isSourceType ? ((SourceTypeElementInfo)((SourceType)type).getElementInfo()).getKind() : ((IBinaryType)((BinaryType)type).getElementInfo()).getKind();
            switch (kind) {
                case 1: {
                    return (acceptFlags & 2) != 0;
                }
                case 2: {
                    return (acceptFlags & 4) != 0;
                }
                case 3: {
                    return (acceptFlags & 8) != 0;
                }
            }
            return (acceptFlags & 0x10) != 0;
        }
        catch (JavaModelException npe) {
            return false;
        }
    }

    private void findAllTypes(String prefix, boolean partialMatch, int acceptFlags, IJavaElementRequestor requestor) {
        int count = this.packageFragmentRoots.length;
        int i = 0;
        while (i < count) {
            block7: {
                if (requestor.isCanceled()) {
                    return;
                }
                IPackageFragmentRoot root = this.packageFragmentRoots[i];
                IJavaElement[] packages = null;
                try {
                    packages = root.getChildren();
                }
                catch (JavaModelException npe) {
                    break block7;
                }
                if (packages != null) {
                    int j = 0;
                    int packageCount = packages.length;
                    while (j < packageCount) {
                        if (requestor.isCanceled()) {
                            return;
                        }
                        this.seekTypes(prefix, (IPackageFragment)packages[j], partialMatch, acceptFlags, requestor);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    public ICompilationUnit findCompilationUnit(String qualifiedTypeName) {
        Object value;
        Object[] pkgName = CharOperation.NO_STRINGS;
        String cuName = qualifiedTypeName;
        int index = qualifiedTypeName.lastIndexOf(46);
        if (index != -1) {
            pkgName = Util.splitOn('.', qualifiedTypeName, 0, index);
            cuName = qualifiedTypeName.substring(index + 1);
        }
        if ((index = cuName.indexOf(36)) != -1) {
            cuName = cuName.substring(0, index);
        }
        if ((value = this.packageFragments.get(pkgName)) != null) {
            if (value instanceof PackageFragmentRoot) {
                return this.findCompilationUnit((String[])pkgName, cuName, (PackageFragmentRoot)value);
            }
            IPackageFragmentRoot[] roots = (IPackageFragmentRoot[])value;
            int i = 0;
            while (i < roots.length) {
                PackageFragmentRoot root = (PackageFragmentRoot)roots[i];
                ICompilationUnit cu = this.findCompilationUnit((String[])pkgName, cuName, root);
                if (cu != null) {
                    return cu;
                }
                ++i;
            }
        }
        return null;
    }

    private ICompilationUnit findCompilationUnit(String[] pkgName, String cuName, PackageFragmentRoot root) {
        if (!root.isArchive()) {
            PackageFragment pkg = root.getPackageFragment(pkgName);
            try {
                ICompilationUnit[] cus = pkg.getCompilationUnits();
                int j = 0;
                int length = cus.length;
                while (j < length) {
                    ICompilationUnit cu = cus[j];
                    if (Util.equalsIgnoreJavaLikeExtension(cu.getElementName(), cuName)) {
                        return cu;
                    }
                    ++j;
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return null;
    }

    public IPackageFragment findPackageFragment(IPath path) {
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException(Messages.path_mustBeAbsolute);
        }
        IResource possibleFragment = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (possibleFragment == null) {
            int i = 0;
            while (i < this.packageFragmentRoots.length) {
                block21: {
                    IPath rootPath;
                    int matchingCount;
                    IPackageFragmentRoot root = this.packageFragmentRoots[i];
                    if (root.isExternal() && (matchingCount = (rootPath = root.getPath()).matchingFirstSegments(path)) != 0) {
                        String name = path.toOSString();
                        name = name.substring(rootPath.toOSString().length() + 1, name.length());
                        name = name.replace(File.separatorChar, '.');
                        IJavaElement[] list = null;
                        try {
                            list = root.getChildren();
                        }
                        catch (JavaModelException npe) {
                            break block21;
                        }
                        int elementCount = list.length;
                        int j = 0;
                        while (j < elementCount) {
                            IPackageFragment packageFragment = (IPackageFragment)list[j];
                            if (this.nameMatches(name, packageFragment, false)) {
                                return packageFragment;
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
        } else {
            IJavaElement fromFactory = JavaCore.create(possibleFragment);
            if (fromFactory == null) {
                return null;
            }
            switch (fromFactory.getElementType()) {
                case 4: {
                    return (IPackageFragment)fromFactory;
                }
                case 2: {
                    JavaProject project = (JavaProject)fromFactory;
                    try {
                        IClasspathEntry entry = project.getClasspathEntryFor(path);
                        if (entry != null) {
                            IPackageFragmentRoot root = project.getPackageFragmentRoot(project.getResource());
                            IPackageFragmentRoot[] roots = (IPackageFragmentRoot[])this.packageFragments.get(CharOperation.NO_STRINGS);
                            if (roots == null) {
                                return null;
                            }
                            int i = 0;
                            while (i < roots.length) {
                                if (roots[i].equals(root)) {
                                    return ((PackageFragmentRoot)root).getPackageFragment(CharOperation.NO_STRINGS);
                                }
                                ++i;
                            }
                        }
                    }
                    catch (JavaModelException e) {
                        return null;
                    }
                    return null;
                }
                case 3: {
                    return ((PackageFragmentRoot)fromFactory).getPackageFragment(CharOperation.NO_STRINGS);
                }
            }
        }
        return null;
    }

    public IPackageFragment[] findPackageFragments(String name, boolean partialMatch) {
        if (partialMatch) {
            String[] splittedName = Util.splitOn('.', name, 0, name.length());
            IPackageFragment[] oneFragment = null;
            ArrayList<PackageFragment> pkgs = null;
            Object[][] keys = this.packageFragments.keyTable;
            int i = 0;
            int length = keys.length;
            while (i < length) {
                String[] pkgName = (String[])keys[i];
                if (pkgName != null && Util.startsWithIgnoreCase(pkgName, splittedName)) {
                    Object value = this.packageFragments.valueTable[i];
                    if (value instanceof PackageFragmentRoot) {
                        PackageFragment pkg = ((PackageFragmentRoot)value).getPackageFragment(pkgName);
                        if (oneFragment == null) {
                            oneFragment = new IPackageFragment[]{pkg};
                        } else {
                            if (pkgs == null) {
                                pkgs = new ArrayList<PackageFragment>();
                                pkgs.add((PackageFragment)oneFragment[0]);
                            }
                            pkgs.add(pkg);
                        }
                    } else {
                        IPackageFragmentRoot[] roots = (IPackageFragmentRoot[])value;
                        int j = 0;
                        int length2 = roots.length;
                        while (j < length2) {
                            PackageFragmentRoot root = (PackageFragmentRoot)roots[j];
                            PackageFragment pkg = root.getPackageFragment(pkgName);
                            if (oneFragment == null) {
                                oneFragment = new IPackageFragment[]{pkg};
                            } else {
                                if (pkgs == null) {
                                    pkgs = new ArrayList();
                                    pkgs.add((PackageFragment)oneFragment[0]);
                                }
                                pkgs.add(pkg);
                            }
                            ++j;
                        }
                    }
                }
                ++i;
            }
            if (pkgs == null) {
                return oneFragment;
            }
            int resultLength = pkgs.size();
            IPackageFragment[] result = new IPackageFragment[resultLength];
            pkgs.toArray(result);
            return result;
        }
        Object[] splittedName = Util.splitOn('.', name, 0, name.length());
        Object value = this.packageFragments.get(splittedName);
        if (value instanceof PackageFragmentRoot) {
            return new IPackageFragment[]{((PackageFragmentRoot)value).getPackageFragment((String[])splittedName)};
        }
        IPackageFragmentRoot[] roots = (IPackageFragmentRoot[])value;
        if (roots != null) {
            IPackageFragment[] result = new IPackageFragment[roots.length];
            int i = 0;
            while (i < roots.length) {
                result[i] = ((PackageFragmentRoot)roots[i]).getPackageFragment((String[])splittedName);
                ++i;
            }
            return result;
        }
        return null;
    }

    public IType findType(String typeName, String packageName, boolean partialMatch, int acceptFlags) {
        if (packageName == null || packageName.length() == 0) {
            packageName = "";
        } else if (typeName.length() > 0 && Character.isLowerCase(typeName.charAt(0)) && this.findPackageFragments(String.valueOf(packageName) + "." + typeName, false) != null) {
            return null;
        }
        JavaElementRequestor elementRequestor = new JavaElementRequestor();
        this.seekPackageFragments(packageName, false, elementRequestor);
        IPackageFragment[] packages = elementRequestor.getPackageFragments();
        int i = 0;
        int length = packages.length;
        while (i < length) {
            IType type = this.findType(typeName, packages[i], partialMatch, acceptFlags);
            if (type != null) {
                return type;
            }
            ++i;
        }
        return null;
    }

    private IType getMemberType(IType type, String name, int dot) {
        while (dot != -1) {
            int start;
            String typeName = name.substring(start, (dot = name.indexOf(46, start = dot + 1)) == -1 ? name.length() : dot);
            type = type.getType(typeName);
        }
        return type;
    }

    public IType findType(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags) {
        if (pkg == null) {
            return null;
        }
        SingleTypeRequestor typeRequestor = new SingleTypeRequestor();
        this.seekTypes(name, pkg, partialMatch, acceptFlags, typeRequestor);
        IType type = typeRequestor.getType();
        return type;
    }

    IType findSecondaryType(String typeName, IPackageFragment pkg, boolean partialMatch, final int acceptFlags) {
        try {
            final ArrayList paths = new ArrayList();
            TypeNameRequestor nameRequestor = new TypeNameRequestor(){

                public void acceptType(int modifiers, char[] packageName, char[] simpleTypeName, char[][] enclosingTypeNames, String path) {
                    if (enclosingTypeNames == null || enclosingTypeNames.length == 0) {
                        int kind = modifiers & 0x6200;
                        switch (kind) {
                            case 8192: 
                            case 8704: {
                                if ((acceptFlags & 0x10) == 0) break;
                                paths.add(path);
                                break;
                            }
                            case 16384: {
                                if ((acceptFlags & 8) == 0) break;
                                paths.add(path);
                                break;
                            }
                            case 512: {
                                if ((acceptFlags & 4) == 0) break;
                                paths.add(path);
                                break;
                            }
                            default: {
                                if ((acceptFlags & 2) == 0) break;
                                paths.add(path);
                            }
                        }
                    }
                }
            };
            int matchMode = partialMatch ? 1 : 0;
            int matchRule = !partialMatch ? matchMode | 8 : matchMode;
            new SearchEngine().searchAllTypeNames(pkg.getElementName().toCharArray(), typeName.toCharArray(), matchRule, 0, SearchEngine.createJavaSearchScope(new IJavaElement[]{pkg}, false), nameRequestor, 2, null);
            if (!paths.isEmpty()) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                int i = 0;
                int l = paths.size();
                while (i < l) {
                    String pathname = (String)paths.get(i);
                    if (Util.isJavaLikeFileName(pathname)) {
                        IFile file = workspace.getRoot().getFile(new Path(pathname));
                        ICompilationUnit unit = JavaCore.createCompilationUnitFrom(file);
                        return unit.getType(typeName);
                    }
                    ++i;
                }
            }
        }
        catch (JavaModelException javaModelException) {
        }
        catch (OperationCanceledException operationCanceledException) {
            // empty catch block
        }
        return null;
    }

    public IType findType(String name, boolean partialMatch, int acceptFlags) {
        int index = name.lastIndexOf(46);
        String className = null;
        String packageName = null;
        if (index == -1) {
            packageName = "";
            className = name;
        } else {
            packageName = name.substring(0, index);
            className = name.substring(index + 1);
        }
        return this.findType(className, packageName, partialMatch, acceptFlags);
    }

    protected boolean nameMatches(String searchName, IJavaElement element, boolean partialMatch) {
        if (partialMatch) {
            return element.getElementName().toLowerCase().startsWith(searchName);
        }
        return element.getElementName().equals(searchName);
    }

    protected boolean nameMatches(String searchName, ICompilationUnit cu, boolean partialMatch) {
        if (partialMatch) {
            return cu.getElementName().toLowerCase().startsWith(searchName);
        }
        return Util.equalsIgnoreJavaLikeExtension(cu.getElementName(), searchName);
    }

    public void seekPackageFragments(String name, boolean partialMatch, IJavaElementRequestor requestor) {
        block10: {
            Object value;
            Object[] splittedName;
            block11: {
                block9: {
                    if (!partialMatch) break block9;
                    String[] splittedName2 = Util.splitOn('.', name, 0, name.length());
                    Object[][] keys = this.packageFragments.keyTable;
                    int i = 0;
                    int length = keys.length;
                    while (i < length) {
                        if (requestor.isCanceled()) {
                            return;
                        }
                        String[] pkgName = (String[])keys[i];
                        if (pkgName != null && Util.startsWithIgnoreCase(pkgName, splittedName2)) {
                            Object value2 = this.packageFragments.valueTable[i];
                            if (value2 instanceof PackageFragmentRoot) {
                                PackageFragmentRoot root = (PackageFragmentRoot)value2;
                                requestor.acceptPackageFragment(root.getPackageFragment(pkgName));
                            } else {
                                IPackageFragmentRoot[] roots = (IPackageFragmentRoot[])value2;
                                int j = 0;
                                int length2 = roots.length;
                                while (j < length2) {
                                    if (requestor.isCanceled()) {
                                        return;
                                    }
                                    PackageFragmentRoot root = (PackageFragmentRoot)roots[j];
                                    requestor.acceptPackageFragment(root.getPackageFragment(pkgName));
                                    ++j;
                                }
                            }
                        }
                        ++i;
                    }
                    break block10;
                }
                splittedName = Util.splitOn('.', name, 0, name.length());
                value = this.packageFragments.get(splittedName);
                if (!(value instanceof PackageFragmentRoot)) break block11;
                requestor.acceptPackageFragment(((PackageFragmentRoot)value).getPackageFragment((String[])splittedName));
                break block10;
            }
            IPackageFragmentRoot[] roots = (IPackageFragmentRoot[])value;
            if (roots == null) break block10;
            int i = 0;
            int length = roots.length;
            while (i < length) {
                if (requestor.isCanceled()) {
                    return;
                }
                PackageFragmentRoot root = (PackageFragmentRoot)roots[i];
                requestor.acceptPackageFragment(root.getPackageFragment((String[])splittedName));
                ++i;
            }
        }
    }

    public void seekTypes(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags, IJavaElementRequestor requestor) {
        String matchName;
        String string = matchName = partialMatch ? name.toLowerCase() : name;
        if (pkg == null) {
            this.findAllTypes(matchName, partialMatch, acceptFlags, requestor);
            return;
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)pkg.getParent();
        try {
            int packageFlavor = root.getKind();
            switch (packageFlavor) {
                case 2: {
                    matchName = matchName.replace('.', '$');
                    this.seekTypesInBinaryPackage(matchName, pkg, partialMatch, acceptFlags, requestor);
                    break;
                }
                case 1: {
                    matchName = matchName.replace('$', '.');
                    this.seekTypesInSourcePackage(matchName, pkg, partialMatch, acceptFlags, requestor);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (JavaModelException e) {
            return;
        }
    }

    /*
     * Exception decompiling
     */
    protected void seekTypesInBinaryPackage(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags, IJavaElementRequestor requestor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [5 : 277->281)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected void seekTypesInSourcePackage(String name, IPackageFragment pkg, boolean partialMatch, int acceptFlags, IJavaElementRequestor requestor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 4[TRYBLOCK] [10 : 723->727)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void seekTypesInType(String prefix, int firstDot, IType type, IJavaElementRequestor requestor, int acceptFlags) {
        IType[] types = null;
        try {
            types = type.getTypes();
        }
        catch (JavaModelException npe) {
            return;
        }
        int length = types.length;
        if (length == 0) {
            return;
        }
        String memberPrefix = prefix;
        boolean isMemberTypePrefix = false;
        if (firstDot != -1) {
            memberPrefix = prefix.substring(0, firstDot);
            isMemberTypePrefix = true;
        }
        int i = 0;
        while (i < length) {
            if (requestor.isCanceled()) {
                return;
            }
            IType memberType = types[i];
            if (memberType.getElementName().toLowerCase().startsWith(memberPrefix)) {
                if (isMemberTypePrefix) {
                    String subPrefix = prefix.substring(firstDot + 1, prefix.length());
                    this.seekTypesInType(subPrefix, subPrefix.indexOf(46), memberType, requestor, acceptFlags);
                } else if (this.acceptType(memberType, acceptFlags, true)) {
                    requestor.acceptMemberType(memberType);
                }
            }
            ++i;
        }
    }

    protected void seekTypesInTopLevelType(String prefix, int firstDot, IType topLevelType, IJavaElementRequestor requestor, int acceptFlags) {
        if (!topLevelType.getElementName().toLowerCase().startsWith(prefix)) {
            return;
        }
        if (firstDot == -1) {
            if (this.acceptType(topLevelType, acceptFlags, true)) {
                requestor.acceptType(topLevelType);
            }
        } else {
            this.seekTypesInType(prefix, firstDot, topLevelType, requestor, acceptFlags);
        }
    }
}

