###############################################################################
#
# General mumbojumbo
#
###############################################################################

Name: atmel-firmware
Version: 1.0
Release: 1
Copyright: Distributable
Group: System Environment/Kernel
Vendor: Simon Kelley
Packager: Simon Kelley
Distribution: LSB
URL: http://www.thekelleys.org.uk/atmel
Source0: %{name}-%{version}.tar.gz
Requires: hotplug
BuildRoot: /var/tmp/%{name}-%{version}
Summary: Firmware for Atmel at76c50x wireless network chips.

%description
The drivers for Atmel at76c50x wireless network chipss in the
Linux 2.6.x kernel and at http://at76c503a.berlios.de/ do not 
include the firmware and this firmware needs to be loaded by 
the host on most cards using these chips. 
This package provides the firmware images which 
should be automatically loaded as needed by the hotplug system. It also 
provides a small loader utility which can be used to accomplish the 
same thing when hotplug is not in use. 

###############################################################################
#
# Build
#
###############################################################################

%prep
%setup -q
%build
gcc -o atmel_fwl atmel_fwl.c


###############################################################################
#
# Install
#
###############################################################################

%install
rm -rf $RPM_BUILD_ROOT

mkdir -p -m 755 $RPM_BUILD_ROOT/usr/sbin
mkdir -p -m 755 $RPM_BUILD_ROOT/usr/lib/hotplug/firmware
mkdir -p -m 755 $RPM_BUILD_ROOT/usr/share/man/man8
mkdir -p -m 755 $RPM_BUILD_ROOT/etc/pcmcia

cp images/* $RPM_BUILD_ROOT/usr/lib/hotplug/firmware
cp images.usb/* $RPM_BUILD_ROOT/usr/lib/hotplug/firmware
strip atmel_fwl
cp atmel_fwl $RPM_BUILD_ROOT/usr/sbin
cp atmel_fwl.8 $RPM_BUILD_ROOT/usr/share/man/man8
gzip $RPM_BUILD_ROOT/usr/share/man/man8/atmel_fwl.8
cp atmel.conf $RPM_BUILD_ROOT/etc/pcmcia

###############################################################################
#
# Clean up
#
###############################################################################

%clean
rm -rf $RPM_BUILD_ROOT


###############################################################################
#
# Post-install scriptlet
#
###############################################################################
# Remove files from old locations which may have been installed by
# the original tarball

%post
if test -f /etc/hotplug.d/firmware/atmel.hotplug; then
    echo "Removing old script /etc/hotplug.d/firmware/atmel.hotplug"
    rm -f /etc/hotplug.d/firmware/atmel.hotplug
fi

if test -d /usr/share/firmware/atmel_at76c50x; then
    echo "Removing old directory /usr/share/firmware/atmel_at76c50x";
    rm -rf /usr/share/firmware/atmel_at76c50x
fi

# Kick the cardmgr so it reads the new PCMCIA database entries.

if [ -f /var/run/cardmgr.pid ]; then
    kill -HUP `cat /var/run/cardmgr.pid`
fi

###############################################################################
#
# File list
#
###############################################################################

%files
%defattr(-,root,root)
%doc README COPYING 
%attr(0755,root,root) /usr/sbin/atmel_fwl
%attr(0644,root,root) /usr/share/man/man8/atmel_fwl.8.gz
%attr(0644,root,root) /etc/pcmcia/atmel.conf
/usr/lib/hotplug/firmware/


##############################################################################
#
# Changelog
#
##############################################################################

%changelog
*Thu May 13 2004 Simon Kelley <simon@thekelleys.org.uk>
- Updated license file.

*Sat Jan 17 2004 Simon Kelley <simon@thekelleys.org.uk>
- Renamed USB files to match PCMCIA ones.

*Wed Jan 14 2004 Simon Kelley <simon@thekelleys.org.uk>
- Added /etc/pcmcia/atmel.conf
- Added restart of PCMCIA system.
- Added USB firmware for Berlios driver.

* Sun Jan 4 2004 Simon Kelley <simon@thekelleys.org.uk>
- Initial version.
