#! /bin/sh
#
# atokx server start/stop script
#
# Written by Taku YASUI <tach@debian.or.jp>.

PATH=/usr/local/sbin:/usr/local/bin:/sbin:/bin:/usr/sbin:/usr/bin
DAEMON_ATOKX=/usr/lib/locale/ja/atokserver/atokmngdaemon
DAEMON_IIIMP=/usr/lib/im/htt
NAME_ATOKX=atokmngdaemon
NAME_IIIMP=htt
DESC="ATOKX server"

if [ ! -f /usr/lib/locale/ja/atokserver ]; then
    mkdir -p /usr/lib/locale/ja
    ln -sf /usr/lib/atokx/locale/ja/atokserver /usr/lib/locale/ja/atokserver
fi

test -f $DAEMON_ATOKX || exit 0
test -f $DAEMON_IIIMP || exit 0

set -e

case "$1" in
  start)
  	$0 fix-symlinks
	echo -n "Starting $DESC: "
	start-stop-daemon --start --quiet --background --exec $DAEMON_ATOKX
	echo -n "$NAME_ATOKX "
	start-stop-daemon --start --quiet --background --exec $DAEMON_IIIMP -- \
		-port 9010 -syslog -message_locale C >/dev/null 2>&1
	echo "$NAME_IIIMP."
	;;

  stop)
	echo -n "Stopping $DESC: "
	start-stop-daemon --stop --quiet --oknodo --name $NAME_IIIMP
	echo -n "$NAME_IIIMP "
	start-stop-daemon --stop --quiet --oknodo --name $NAME_ATOKX
	echo "$NAME_ATOKX."
	;;

  restart|force-reload)
	#
	#	If the "reload" option is implemented, move the "force-reload"
	#	option to the "reload" entry above. If not, "force-reload" is
	#	just the same as "restart".
	#
	$0 stop
	sleep 1
	$0 start
	;;

  fix-symlinks)
	# fix bloken symlinks caused by locales.
	# nothing to do
	;;

  *)
	N=/etc/init.d/atokx
	echo "Usage: $N {start|stop|restart|force-reload|fix-symlinks}" >&2
	exit 1
	;;
esac

exit 0
