/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included  with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.logger;

import org.apache.log.Logger;
import org.apache.log.Hierarchy;

/**
 * LogKitManager Interface.
 *
 * @deprecated we should use the new LoggerManager interface that directly
 *             supports the new framework Logger interface.
 *
 * @author <a href="mailto:giacomo@apache.org">Giacomo Pati</a>
 * @version CVS $Revision: 1.4 $ $Date: 2002/01/17 20:44:59 $
 */
public interface LogKitManager
{
    /**
     * Find a logger based on a category name.
     */
    Logger getLogger( String categoryName );

    /**
     * Retrieve Hierarchy for Loggers configured by the system.
     *
     * @return the Hierarchy
     */
    Hierarchy getHierarchy();
}
