/*
 * Copyright (C) The Apache Software Foundation. All rights reserved.
 *
 * This software is published under the terms of the Apache Software License
 * version 1.1, a copy of which has been included with this distribution in
 * the LICENSE.txt file.
 */
package org.apache.avalon.excalibur.i18n.test;

import java.util.Map;
import java.util.HashMap;

import org.apache.avalon.framework.configuration.Configuration;

import org.apache.avalon.excalibur.testcase.ExcaliburTestCase;
import org.apache.avalon.excalibur.i18n.BundleInfo;
import org.apache.avalon.excalibur.i18n.XmlBundle;
import org.apache.avalon.excalibur.i18n.BundleSelector;

/**
 * @author <a href="mailto:neeme@apache.org">Neeme Praks</a>
 * @version $Id: DefaultBundleLoaderTestCase.java,v 1.5 2001/12/11 09:53:35 jefft Exp $
 */
public class DefaultBundleLoaderTestCase extends ExcaliburTestCase {

    private BundleSelector bundleSelector;

    public DefaultBundleLoaderTestCase( String name ) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.bundleSelector = (BundleSelector) this.manager.lookup(BundleSelector.ROLE);
    }

    public void tearDown() throws Exception {
        manager.release(this.bundleSelector);
        this.bundleSelector = null;
        super.tearDown();
    }

    public void testLoading() throws Exception {
        this.bundleSelector.select("ee", "uu");
    }

    public static void main(String[] args) {
        ExcaliburTestCase test = new DefaultBundleLoaderTestCase("test");
        test.run();
    }
}
