/*
    Copyright (C) 2001-2003 Michael Niedermayer <michaelni@gmx.at>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef SWSCALE_H
#define SWSCALE_H

/**
 * @file swscale.h
 * @brief 
 *     external api for the swscale stuff
 */

#ifdef __cplusplus
extern "C" {
#endif

//MEANX: taken from mplayer
typedef enum { IMGFMT_RGB_MASK , IMGFMT_RGB , IMGFMT_RGB1  , IMGFMT_RGB4  , IMGFMT_RG4B  , IMGFMT_RGB8  , IMGFMT_RGB15 , IMGFMT_RGB16 , IMGFMT_RGB24 , IMGFMT_RGB32 , IMGFMT_BGR_MASK , IMGFMT_BGR , IMGFMT_BGR1 , IMGFMT_BGR4 , IMGFMT_BG4B , IMGFMT_BGR8 , IMGFMT_BGR15 , IMGFMT_BGR16 , IMGFMT_BGR24 , IMGFMT_BGR32 , IMGFMT_IS_RGB, IMGFMT_IS_BGR, IMGFMT_RGB_DEPTH, IMGFMT_BGR_DEPTH, IMGFMT_YVU9 , IMGFMT_IF09 , IMGFMT_YV12 , IMGFMT_I420 , IMGFMT_IYUV , IMGFMT_CLPL , IMGFMT_Y800 , IMGFMT_Y8   , IMGFMT_NV12 , IMGFMT_NV21 , IMGFMT_444P , IMGFMT_422P , IMGFMT_411P , IMGFMT_HM12 , IMGFMT_IUYV , IMGFMT_IY41 , IMGFMT_IYU1 , IMGFMT_IYU2 , IMGFMT_UYVY , IMGFMT_UYNV , IMGFMT_cyuv , IMGFMT_Y422 , IMGFMT_YUY2 , IMGFMT_YUNV , IMGFMT_YVYU , IMGFMT_Y41P , IMGFMT_Y211 , IMGFMT_Y41T , IMGFMT_Y42T , IMGFMT_V422 , IMGFMT_V655 , IMGFMT_CLJR , IMGFMT_YUVP , IMGFMT_UYVP , IMGFMT_MPEGPES , IMGFMT_ZRMJPEGNI  , IMGFMT_ZRMJPEGIT , IMGFMT_ZRMJPEGIB}BLAH; 

/* values for the flags, the stuff on the command line is different */
#define SWS_FAST_BILINEAR 1
#define SWS_BILINEAR 2
#define SWS_BICUBIC  4
#define SWS_X        8
#define SWS_POINT    0x10
#define SWS_AREA     0x20
#define SWS_BICUBLIN 0x40
#define SWS_GAUSS    0x80
#define SWS_SINC     0x100
#define SWS_LANCZOS  0x200
#define SWS_SPLINE   0x400

#define SWS_SRC_V_CHR_DROP_MASK		0x30000
#define SWS_SRC_V_CHR_DROP_SHIFT	16

#define SWS_PARAM_MASK			0x3FC0000
#define SWS_PARAM_SHIFT			18

#define SWS_PRINT_INFO		0x1000

//the following 3 flags are not completly implemented
//internal chrominace subsamling info
#define SWS_FULL_CHR_H_INT	0x2000
//input subsampling info
#define SWS_FULL_CHR_H_INP	0x4000
#define SWS_DIRECT_BGR		0x8000

#define SWS_CPU_CAPS_MMX   0x80000000
#define SWS_CPU_CAPS_MMX2  0x20000000
#define SWS_CPU_CAPS_3DNOW 0x40000000

#define SWS_MAX_REDUCE_CUTOFF 0.002

#define SWS_CS_ITU709		1
#define SWS_CS_FCC 		4
#define SWS_CS_ITU601		5
#define SWS_CS_ITU624		5
#define SWS_CS_SMPTE170M 	5
#define SWS_CS_SMPTE240M 	7
#define SWS_CS_DEFAULT 		5



// when used for filters they must have an odd number of elements
// coeffs cannot be shared between vectors
typedef struct {
	double *coeff;
	int length;
} SwsVector;

// vectors can be shared
typedef struct {
	SwsVector *lumH;
	SwsVector *lumV;
	SwsVector *chrH;
	SwsVector *chrV;
} SwsFilter;

struct SwsContext;

void sws_freeContext(struct SwsContext *swsContext);

struct SwsContext *sws_getContext(int srcW, int srcH, int srcFormat, int dstW, int dstH, int dstFormat, int flags,
			 SwsFilter *srcFilter, SwsFilter *dstFilter);
int sws_scale(struct SwsContext *context, uint8_t* src[], int srcStride[], int srcSliceY,
                           int srcSliceH, uint8_t* dst[], int dstStride[]);
int sws_scale_ordered(struct SwsContext *context, uint8_t* src[], int srcStride[], int srcSliceY,
                           int srcSliceH, uint8_t* dst[], int dstStride[]);


int sws_setColorspaceDetails(struct SwsContext *c, const int inv_table[4], int srcRange, const int table[4], int dstRange, int brightness, int contrast, int saturation);
int sws_getColorspaceDetails(struct SwsContext *c, int **inv_table, int *srcRange, int **table, int *dstRange, int *brightness, int *contrast, int *saturation);
SwsVector *sws_getGaussianVec(double variance, double quality);
SwsVector *sws_getConstVec(double c, int length);
SwsVector *sws_getIdentityVec(void);
void sws_scaleVec(SwsVector *a, double scalar);
void sws_normalizeVec(SwsVector *a, double height);
void sws_convVec(SwsVector *a, SwsVector *b);
void sws_addVec(SwsVector *a, SwsVector *b);
void sws_subVec(SwsVector *a, SwsVector *b);
void sws_shiftVec(SwsVector *a, int shift);
SwsVector *sws_cloneVec(SwsVector *a);

void sws_printVec(SwsVector *a);
void sws_freeVec(SwsVector *a);

SwsFilter *sws_getDefaultFilter(float lumaGBlur, float chromaGBlur, 
				float lumaSarpen, float chromaSharpen,
				float chromaHShift, float chromaVShift,
				int verbose);
void sws_freeFilter(SwsFilter *filter);

#ifdef __cplusplus
}
#endif

#endif
