/*
 * Decompiled with CFR 0.152.
 */
package gov.llnl.babel.backend.c;

import gov.llnl.babel.BabelConfiguration;
import gov.llnl.babel.backend.CodeGenerationException;
import gov.llnl.babel.backend.IOR;
import gov.llnl.babel.backend.Utilities;
import gov.llnl.babel.backend.c.ArrayMethods;
import gov.llnl.babel.backend.c.C;
import gov.llnl.babel.backend.writers.LanguageWriterForC;
import gov.llnl.babel.symbols.Enumeration;
import gov.llnl.babel.symbols.Extendable;
import gov.llnl.babel.symbols.Method;
import gov.llnl.babel.symbols.Package;
import gov.llnl.babel.symbols.Symbol;
import gov.llnl.babel.symbols.SymbolID;
import gov.llnl.babel.symbols.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;

public class StubHeader {
    private static final String SIDL_EXCEPTION = BabelConfiguration.getBaseExceptionClass();
    private static final String SIDL_EXCEPTION_INTERFACE = BabelConfiguration.getBaseExceptionInterface();
    public static final String s_epv = IOR.getEPVVar(0);
    public static final String s_self = "self";
    public static final String s_sepv_func = "_getSEPV()";
    public static final int DUMP_STATS = 0;
    public static final int SET_CHECKING = 1;
    public static final int SET_INTERCEPTORS = 2;
    private LanguageWriterForC d_writer;
    private boolean d_comment_all;

    public static void generateCode(Symbol symbol, LanguageWriterForC writer) throws CodeGenerationException {
        StubHeader header = new StubHeader(writer);
        header.generateCode(symbol);
    }

    public StubHeader(LanguageWriterForC writer) {
        this.d_writer = writer;
        this.d_comment_all = !BabelConfiguration.getInstance().getCommentLocalOnly();
    }

    public void generateCode(Symbol symbol) throws CodeGenerationException {
        block8: {
            block7: {
                if (symbol == null) break block7;
                if (symbol.getSymbolType() == 14) {
                    this.d_writer.skipIncludeGuard();
                }
                this.generatePrologue(symbol);
                switch (symbol.getSymbolType()) {
                    case 12: {
                        this.generateExtendable((Extendable)symbol);
                        break block8;
                    }
                    case 11: {
                        this.generateEnumeration((Enumeration)symbol);
                        break block8;
                    }
                    case 13: {
                        this.generateExtendable((Extendable)symbol);
                        break block8;
                    }
                    case 14: {
                        this.generatePackage((Package)symbol);
                        break block8;
                    }
                    default: {
                        throw new CodeGenerationException("Unsupported symbol type.");
                    }
                }
            }
            throw new CodeGenerationException("Unexpected null Symbol.");
        }
    }

    private void generatePrologue(Symbol sym) {
        SymbolID id = sym.getSymbolID();
        String header = C.getHeaderFile(id);
        this.d_writer.writeBanner(sym, header, false, "Client-side glue code for " + id.getFullName());
        this.d_writer.openHeaderGuard(header);
    }

    private void generateEpilogue(boolean closeExtern) {
        if (closeExtern) {
            this.d_writer.closeCxxExtern();
        }
        this.d_writer.closeHeaderGuard();
    }

    private void generateEnumeration(Enumeration enm) {
        SymbolID id = enm.getSymbolID();
        ArrayMethods ar = new ArrayMethods(id, true);
        this.d_writer.generateInclude(IOR.getHeaderFile(id), true);
        this.d_writer.println();
        this.d_writer.openCxxExtern();
        ar.generateHeader(this.d_writer);
        this.generateEpilogue(true);
    }

    private void generateExtendable(Extendable ext) throws CodeGenerationException {
        SymbolID id = ext.getSymbolID();
        this.d_writer.writeComment(ext, true);
        this.d_writer.println(IOR.getObjectName(id) + ";");
        this.d_writer.println(IOR.getArrayName(id) + ";");
        this.d_writer.print("typedef " + IOR.getObjectName(id) + "* ");
        this.d_writer.println(C.getObjectName(id) + ";");
        this.d_writer.println();
        this.generateIncludes(ext);
        this.d_writer.openCxxExtern();
        this.generateMethodPrototypes(ext);
        ArrayMethods ar = new ArrayMethods(id, false);
        ar.generateHeader(this.d_writer);
        this.generateEpilogue(true);
    }

    private void generatePackage(Package p) {
        SymbolID id = p.getSymbolID();
        ArrayList entries = Utilities.sort(p.getSymbols().keySet());
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            String include = C.getHeaderFile((SymbolID)i.next());
            this.d_writer.generateInclude(include, true);
        }
        this.d_writer.println();
        this.generateEpilogue(false);
    }

    private void generateIncludes(Extendable ext) throws CodeGenerationException {
        HashSet<SymbolID> includes = new HashSet<SymbolID>();
        Iterator i = ext.getMethods(true).iterator();
        while (i.hasNext()) {
            Method method = (Method)i.next();
            includes.addAll(method.getSymbolReferences());
            if (method.getThrows().isEmpty()) continue;
            Symbol symbol = Utilities.lookupSymbol(SIDL_EXCEPTION);
            includes.add(symbol.getSymbolID());
            symbol = Utilities.lookupSymbol(SIDL_EXCEPTION_INTERFACE);
            includes.add(symbol.getSymbolID());
        }
        this.d_writer.writeComment("Includes for all header dependencies.", false);
        this.d_writer.generateInclude("sidl_header.h", true);
        includes.remove(ext.getSymbolID());
        if (!includes.isEmpty()) {
            ArrayList entries = Utilities.sort(includes);
            Iterator i2 = entries.iterator();
            while (i2.hasNext()) {
                String header = C.getHeaderFile((SymbolID)i2.next());
                this.d_writer.generateInclude(header, true);
            }
            this.d_writer.println();
        }
        this.d_writer.generateInclude(C.getHeaderFile(Utilities.lookupSymbol("sidl.io.Serializer").getSymbolID()), true);
        this.d_writer.generateInclude(C.getHeaderFile(Utilities.lookupSymbol("sidl.io.Deserializer").getSymbolID()), true);
    }

    private void generateBuiltinPrototypes(SymbolID id, int stubType, boolean doStatic) throws CodeGenerationException {
        this.d_writer.writeComment(StubHeader.getBuiltinComment(stubType, doStatic), true);
        StubHeader.generateBuiltinSignature(this.d_writer, stubType, id, doStatic, ";");
        this.d_writer.println();
    }

    private void generateAssertionPrototypes(SymbolID id, boolean doStatic) throws CodeGenerationException {
        this.generateBuiltinPrototypes(id, 1, doStatic);
        this.generateBuiltinPrototypes(id, 0, doStatic);
    }

    private void generateMethodPrototypes(Extendable ext) throws CodeGenerationException {
        SymbolID id = ext.getSymbolID();
        if (!ext.isAbstract()) {
            this.d_writer.writeComment("Constructor function for the class.", true);
            this.d_writer.println(C.getSymbolObjectPtr(id));
            this.d_writer.println(C.getFullMethodName(id, "_create") + "(void);");
            this.d_writer.println();
            this.d_writer.writeComment("RMI constructor function for the class.", true);
            this.d_writer.println(C.getSymbolName(id));
            this.d_writer.println(C.getFullMethodName(id, "_createRemote") + "(const char *, sidl_BaseInterface *_ex);");
            this.d_writer.println();
        }
        boolean hasStatic = ext.hasStaticMethod(true);
        if (!ext.isAbstract() && !ext.isInterface()) {
            if (IOR.supportAssertions(ext)) {
                if (hasStatic) {
                    this.generateAssertionPrototypes(id, true);
                }
                this.generateAssertionPrototypes(id, false);
            }
            if (IOR.supportInterceptors(ext)) {
                if (hasStatic) {
                    this.generateBuiltinPrototypes(id, 2, true);
                }
                this.generateBuiltinPrototypes(id, 2, false);
            }
        }
        boolean isIfc = ext.isInterface();
        Collection methods = ext.getMethods(true);
        Iterator m = methods.iterator();
        while (m.hasNext()) {
            Method method = (Method)m.next();
            this.generateMethodSignature(id, isIfc, method, this.d_comment_all || ext.isLocal(method));
            this.d_writer.println();
        }
        this.d_writer.writeComment("Cast method for interface and class type conversions.", true);
        this.d_writer.println(C.getSymbolObjectPtr(id));
        this.d_writer.println(C.getFullMethodName(id, "_cast") + "(");
        this.d_writer.tab();
        this.d_writer.println("void* obj);");
        this.d_writer.backTab();
        this.d_writer.println();
        this.d_writer.writeComment("String cast method for interface and class type conversions.", true);
        this.d_writer.println("void*");
        this.d_writer.println(C.getFullMethodName(id, "_cast2") + "(");
        this.d_writer.tab();
        this.d_writer.println("void* obj,");
        this.d_writer.println("const char* type);");
        this.d_writer.backTab();
        this.d_writer.println();
        Method m_exec = C.getExecMethod();
        this.generateMethodSignature(id, isIfc, m_exec, true);
        m_exec = C.getSExecMethod();
        this.generateMethodSignature(id, isIfc, m_exec, true);
    }

    private void generateMethodSignature(SymbolID id, boolean isInterface, Method method, boolean docComment) throws CodeGenerationException {
        if (docComment) {
            this.d_writer.writeComment(method, true);
        }
        this.d_writer.println(StubHeader.getReturnString(method.getReturnType()));
        this.d_writer.print(C.getFullMethodName(id, method));
        this.d_writer.println("(");
        this.d_writer.tab();
        C.generateArgumentList(this.d_writer, s_self, isInterface, id, method, true, true, false, true, false, true, true);
        this.d_writer.println(");");
        this.d_writer.backTab();
    }

    private static String getReturnString(Type type) throws CodeGenerationException {
        return IOR.getReturnString(type, false, true);
    }

    public static String getBuiltinComment(int type, boolean doStatic) {
        String cmt = null;
        String desc = doStatic ? "static " : "";
        switch (type) {
            case 1: {
                cmt = "Method to set the " + desc + "assertion checking level.";
                break;
            }
            case 0: {
                cmt = "Method to dump " + desc + "assertion checking statistics.";
                break;
            }
            case 2: {
                cmt = "Method to enable/disable " + desc + "interceptor execution.";
            }
        }
        return cmt;
    }

    public static void generateBuiltinSignature(LanguageWriterForC lw, int type, SymbolID id, boolean doStatic, String terminator) {
        String suffix = doStatic ? "_static" : "";
        String basename = null;
        switch (type) {
            case 1: {
                basename = "_set_checking";
                break;
            }
            case 0: {
                basename = "_dump_stats";
                break;
            }
            case 2: {
                basename = "_set_interceptors";
            }
        }
        lw.println("void");
        lw.println(C.getFullMethodName(id, basename + suffix) + "(");
        lw.tab();
        if (!doStatic) {
            lw.println(C.getFullSelfDecl(id) + ",");
        }
        switch (type) {
            case 1: {
                lw.println("int32_t level,");
                lw.println("double  rate,");
                lw.println("int32_t resetCounters)" + terminator);
                break;
            }
            case 0: {
                lw.println("const char* filename)" + terminator);
                break;
            }
            case 2: {
                lw.println("int32_t on)" + terminator);
            }
        }
        lw.backTab();
    }

    public static String getBuiltinArgList(int type) {
        String args = null;
        switch (type) {
            case 1: {
                args = "level, rate, resetCounters";
                break;
            }
            case 0: {
                args = "filename";
                break;
            }
            case 2: {
                args = "on";
            }
        }
        return args;
    }

    public static String getDerefFunctionPtr(String baseName, boolean doStatic) {
        String base = doStatic ? s_sepv_func : "*self->" + s_epv;
        return "(" + base + "->" + IOR.getVectorEntry(baseName) + ")";
    }
}

