/*
 * File:          sidl_DFinder_jniStub.c
 * Symbol:        sidl.DFinder-v0.9.1
 * Symbol Type:   class
 * Babel Version: 0.10.2
 * Release:       $Name:  $
 * Revision:      @(#) $Id: $
 * Description:   Client-side JNI glue code for sidl.DFinder
 * 
 * Copyright (c) 2000-2002, The Regents of the University of California.
 * Produced at the Lawrence Livermore National Laboratory.
 * Written by the Components Team <components@llnl.gov>
 * All rights reserved.
 * 
 * This file is part of Babel. For more information, see
 * http://www.llnl.gov/CASC/components/. Please read the COPYRIGHT file
 * for Our Notice and the LICENSE file for the GNU Lesser General Public
 * License.
 * 
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License (as published by
 * the Free Software Foundation) version 2.1 dated February 1999.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the IMPLIED WARRANTY OF
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the terms and
 * conditions of the GNU Lesser General Public License for more details.
 * 
 * You should have recieved a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * WARNING: Automatically generated; changes will be lost
 * 
 * babel-version = 0.10.2
 */

#include "sidl_Java.h"
#include "sidl_Loader.h"
#include "sidl_String.h"
#include "sidl_DFinder_IOR.h"
#include "babel_config.h"

/*
 * Convert between jlong and void* pointers.
 */

#if (SIZEOF_VOID_P == 8)
#define JLONG_TO_POINTER(x) ((void*)(x))
#define POINTER_TO_JLONG(x) ((jlong)(x))
#else
#define JLONG_TO_POINTER(x) ((void*)(int32_t)(x))
#define POINTER_TO_JLONG(x) ((jlong)(int32_t)(x))
#endif

#ifndef NULL
#define NULL 0
#endif

/*
 * Function to extract IOR reference from the Java object.
 */

static struct sidl_DFinder__object* _get_ior(
  JNIEnv* env,
  jobject obj)
{
  void* ptr = NULL;
  static jmethodID mid = (jmethodID) NULL;

  if (mid == (jmethodID) NULL) {
    jclass cls = (*env)->GetObjectClass(env, obj);
    mid = (*env)->GetMethodID(env, cls, "_get_ior", "()J");
    (*env)->DeleteLocalRef(env, cls);
  }

  ptr = JLONG_TO_POINTER((*env)->CallLongMethod(env, obj, mid));
  return (struct sidl_DFinder__object*) ptr;
}

/*
 * External reference to IOR methods.
 */

static const struct sidl_DFinder__external* s_external = NULL;

/*
 * Create object instance and return reference.
 */

static jlong jni__create_ior(
  JNIEnv* env,
  jclass  cls)
{
  (void) env;
  (void) cls;
  return POINTER_TO_JLONG((*s_external->createObject)());
}

/*
 * Find a DLL containing the specified information for a sidl
 * class. This method searches through the files in set set path
 * looking for a shared library that contains the client-side or IOR
 * for a particular sidl class.
 * 
 * @param sidl_name  the fully qualified (long) name of the
 *                   class/interface to be found. Package names
 *                   are separated by period characters from each
 *                   other and the class/interface name.
 * @param target     to find a client-side binding, this is
 *                   normally the name of the language.
 *                   To find the implementation of a class
 *                   in order to make one, you should pass
 *                   the string "ior/impl" here.
 * @param lScope     this specifies whether the symbols should
 *                   be loaded into the global scope, a local
 *                   scope, or use the setting in the file.
 * @param lResolve   this specifies whether symbols should be
 *                   resolved as needed (LAZY), completely
 *                   resolved at load time (NOW), or use the
 *                   setting from the file.
 * @return a non-NULL object means the search was successful.
 *         The DLL has already been added.
 */

static jobject
jni_findLibrary(
  JNIEnv* env,
  jobject obj,
  jstring _arg_sidl_name,
  jstring _arg_target,
  jint _arg_lScope,
  jint _arg_lResolve)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_DFinder__object* _ior = NULL;
  char* _tmp_sidl_name = (char*) NULL;
  char* _tmp_target = (char*) NULL;
  enum sidl_Scope__enum _tmp_lScope = (enum sidl_Scope__enum) 0;
  enum sidl_Resolve__enum _tmp_lResolve = (enum sidl_Resolve__enum) 0;
  struct sidl_DLL__object* _ior_res = (struct sidl_DLL__object*) NULL;
  jobject _res = (jobject) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_sidl_name = sidl_Java_J2I_string(env, _arg_sidl_name);
  _tmp_target = sidl_Java_J2I_string(env, _arg_target);
  _tmp_lScope = (enum sidl_Scope__enum) _arg_lScope;
  _tmp_lResolve = (enum sidl_Resolve__enum) _arg_lResolve;

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_findLibrary))(
    _ior,
    _tmp_sidl_name,
    _tmp_target,
    _tmp_lScope,
    _tmp_lResolve);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_sidl_name);
  sidl_String_free(_tmp_target);
  _res = sidl_Java_I2J_cls(env, _ior_res, "sidl.DLL");

  return _res;
}

/*
 * Set the search path, which is a semi-colon separated sequence of
 * URIs as described in class <code>DLL</code>.  This method will
 * invalidate any existing search path.
 */

static void
jni_setSearchPath(
  JNIEnv* env,
  jobject obj,
  jstring _arg_path_name)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_DFinder__object* _ior = NULL;
  char* _tmp_path_name = (char*) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_path_name = sidl_Java_J2I_string(env, _arg_path_name);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_setSearchPath))(
    _ior,
    _tmp_path_name);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_path_name);
}

/*
 * Return the current search path.  If the search path has not been
 * set, then the search path will be taken from environment variable
 * SIDL_DLL_PATH.
 */

static jstring
jni_getSearchPath(
  JNIEnv* env,
  jobject obj)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_DFinder__object* _ior = NULL;
  char* _ior_res = (char*) NULL;
  jstring _res = (jstring) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);

  /*
   * Call the IOR method through the EPV.
   */

  _ior_res = (*(_ior->d_epv->f_getSearchPath))(
    _ior);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  _res = sidl_Java_I2J_string(env, _ior_res);
  sidl_String_free(_ior_res);

  return _res;
}

/*
 * Append the specified path fragment to the beginning of the
 * current search path.  If the search path has not yet been set
 * by a call to <code>setSearchPath</code>, then this fragment will
 * be appended to the path in environment variable SIDL_DLL_PATH.
 */

static void
jni_addSearchPath(
  JNIEnv* env,
  jobject obj,
  jstring _arg_path_fragment)
{
  /*
   * Declare return and temporary variables.
   */

  struct sidl_DFinder__object* _ior = NULL;
  char* _tmp_path_fragment = (char*) NULL;

  /*
   * Preprocess Java types and convert into IOR.
   */

  _ior = _get_ior(env, obj);
  _tmp_path_fragment = sidl_Java_J2I_string(env, _arg_path_fragment);

  /*
   * Call the IOR method through the EPV.
   */

  (*(_ior->d_epv->f_addSearchPath))(
    _ior,
    _tmp_path_fragment);

  /*
   * Postprocess OUT, INOUT, returns, and exceptions.
   */

  sidl_String_free(_tmp_path_fragment);
}

/*
 * Register JNI methods with the Java JVM.
 */

void sidl_DFinder__register(JNIEnv* env)
{
  JNINativeMethod methods[5];
  jclass cls;

  s_external = sidl_DFinder__externals();
  methods[0].name      = "_create_ior";
  methods[0].signature = "()J";
  methods[0].fnPtr     = (void *)jni__create_ior;
  methods[1].name      = "findLibrary";
  methods[1].signature = "(Ljava/lang/String;Ljava/lang/String;II)Lsidl/DLL;";
  methods[1].fnPtr     = (void *)jni_findLibrary;
  methods[2].name      = "setSearchPath";
  methods[2].signature = "(Ljava/lang/String;)V";
  methods[2].fnPtr     = (void *)jni_setSearchPath;
  methods[3].name      = "getSearchPath";
  methods[3].signature = "()Ljava/lang/String;";
  methods[3].fnPtr     = (void *)jni_getSearchPath;
  methods[4].name      = "addSearchPath";
  methods[4].signature = "(Ljava/lang/String;)V";
  methods[4].fnPtr     = (void *)jni_addSearchPath;


  cls = (*env)->FindClass(env, "sidl/DFinder");
  if (cls) {
    (*env)->RegisterNatives(env, cls, methods, 5);
    (*env)->DeleteLocalRef(env, cls);
  }
}
