c
c     File:       overloadtest.f
c     Copyright:  (c) 2001 The Regents of the University of California
c     Revision:   @(#) $Revision: 4434 $
c     Date:       $Date: 2005-03-17 09:05:29 -0800 (Thu, 17 Mar 2005) $
c     Description:Simple F77 overload test client
c
c

      subroutine starttest(number)
      implicit none
      integer*4 number
      integer*8 tracker
      call synch_RegOut_getInstance_f(tracker)
      call synch_RegOut_startPart_f(tracker, number)
      call synch_RegOut_deleteRef_f(tracker)
      end

      subroutine reporttest(test, number)
      implicit none
      integer*4 number
      integer*8 tracker
      logical test
      call synch_RegOut_getInstance_f(tracker)
      if (test) then
         call synch_RegOut_endPart_f(tracker, number, 0)
      else
         call synch_RegOut_endPart_f(tracker, number, 1)
      endif
      call synch_RegOut_deleteRef_f(tracker)
      number = number + 1
      end

      subroutine testnone(t, test)
      implicit none
      integer*4 test
      integer*8 t
      integer*4 retval

      retval = 0

      call starttest(test)
      call Overload_Test_getValue_f (t, retval)
      call reporttest(retval .eq. 1, test)
      end

      subroutine testone(t, test)
      implicit none
      character*80 s1, sretval
      integer*4 test
      integer*8 t, ae, ac, bc
      integer*4 i1, iretval
      double precision d1, dretval
      real f1, fretval
      logical b1, bretval
      complex fc, fcretval
      double complex dc, dcretval

      b1 = .true.
      d1 = 1.0d0
      f1 = 1.0
      i1 = 1
      fc = (1.1, 1.1)
      dc = (2.2d0, 2.2d0)
      s1 = 'AnException'

      call starttest(test)
      call Overload_Test_getValueBool_f (t, b1, bretval)
      call reporttest(bretval .eqv. b1, test)
      call starttest(test)
      call Overload_Test_getValueDouble_f (t, d1, dretval)
      call reporttest(dretval .eq. d1, test)
      call starttest(test)
      call Overload_Test_getValueDcomplex_f (t, dc, dcretval)
      call reporttest(dcretval .eq. dc, test)
      call starttest(test)
      call Overload_Test_getValueFloat_f (t, f1, fretval)
      call reporttest(fretval .eq. f1, test)
      call starttest(test)
      call Overload_Test_getValueFcomplex_f (t, fc, fcretval)
      call reporttest(fcretval .eq. fc, test)
      call starttest(test)
      call Overload_Test_getValueInt_f (t, i1, iretval)
      call reporttest(iretval .eq. i1, test)
      call starttest(test)
      call Overload_Test_getValueString_f (t, s1, sretval)
      call reporttest(sretval .eq. s1, test)

      call Overload_AnException__create_f(ae)
      call starttest(test)
      call Overload_Test_getValueException_f (t, ae, sretval)
      call reporttest(sretval .eq. s1, test)
      call Overload_AnException_deleteRef_f(ae)
      call Overload_AClass__create_f(ac)
      call starttest(test)
      call Overload_Test_getValueAClass_f (t, ac, iretval)
      call reporttest(iretval .eq. 2, test)
      call Overload_AClass_deleteRef_f(ac)
      call Overload_BClass__create_f(bc)
      call starttest(test)
      call Overload_Test_getValueBClass_f (t, bc, iretval)
      call reporttest(iretval .eq. 2, test)
      call Overload_BClass_deleteRef_f(bc)
      end

      subroutine testtwo(t, test)
      implicit none
      integer*4 test
      integer*8 t
      integer*4 i1, iretval
      double precision d1, dretval, did
      real f1

      d1 = 1.0d0
      i1 = 1
      did =2.0d0

      call starttest(test)
      call Overload_Test_getValueDoubleInt_f (t, d1, i1, dretval)
      call reporttest(dretval .eq. did, test)
      call starttest(test)
      call Overload_Test_getValueIntDouble_f (t, i1, d1, dretval)
      call reporttest(dretval .eq. did, test)
      end

      subroutine testthree(t, test)
      implicit none
      integer*8 t
      integer*4 i1
      integer*4 test
      double precision d1, difd, dretval
      real f1

      d1 = 1.0d0
      f1 = 1.0
      i1 = 1
      difd = 3.0d0

      call starttest(test)
      call Overload_Test_getValueDoubleIntFloat_f (t, d1, i1, f1, 
     $                                             dretval)
      call reporttest(dretval .eq. difd, test)
      call starttest(test)
      call Overload_Test_getValueIntDoubleFloat_f (t, i1, d1, f1, 
     $                                             dretval)
      call reporttest(dretval .eq. difd, test)
      call starttest(test)
      call Overload_Test_getValueDoubleFloatInt_f (t, d1, f1, i1, 
     $                                             dretval)
      call reporttest(dretval .eq. difd, test)
      call starttest(test)
      call Overload_Test_getValueIntFloatDouble_f (t, i1, f1, d1,
     $                                             dretval)
      call reporttest(dretval .eq. difd, test)
      call starttest(test)
      call Overload_Test_getValueFloatDoubleInt_f (t, f1, d1, i1,
     $                                             dretval)
      call reporttest(dretval .eq. difd, test)
      call starttest(test)
      call Overload_Test_getValueFloatIntDouble_f (t, f1, i1, d1,
     $                                             dretval)
      call reporttest(dretval .eq. difd, test)
      end


      program overloadtest
      implicit none
      integer*4 test
      integer*8 t, tracker

      call synch_RegOut_getInstance_f(tracker)
      call synch_RegOut_setExpectations_f(tracker, 19)
      call Overload_Test__create_f (t)

      test = 1

      call synch_RegOut_writeComment_f(tracker,
     $     'No Argument test             ')
      call testnone(t, test)
      call synch_RegOut_writeComment_f(tracker,
     $     'Single Argument tests        ')
      call testone(t, test)
      call synch_RegOut_writeComment_f(tracker,
     $     'Double Argument tests        ')
      call testtwo(t, test)
      call synch_RegOut_writeComment_f(tracker,
     $     'Triple Argument tests        ')
      call testthree(t, test)

      call Overload_Test_deleteRef_f (t)

      call synch_RegOut_close_f(tracker)
      call synch_RegOut_deleteRef_f(tracker)
      end
